/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.estoque.almoxarifado;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Pesquisas;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.DadosPatrimonio;
import jalis.laboratorio.cadastro.Patrimonio;
import jalis.laboratorio.estoque.SaldoInsuficienteException;
import jalis.laboratorio.estoque.SolicitarLoteMaterial;
import jalis.laboratorio.estoque.almoxarifado.DialogoAnaliseCritica;
import jalis.laboratorio.estoque.almoxarifado.JanelaCelulaEstoque;
import jalis.laboratorio.estoque.almoxarifado.JanelaTipoOperacao;
import jalis.laboratorio.estoque.almoxarifado.PerguntarValorEstoque;
import jalis.model.bean.estoque.CelulaEstoqueBean;
import jalis.model.bean.estoque.EstoqueManualBean;
import jalis.model.bean.estoque.EstoqueManualMaterialBean;
import jalis.model.bean.estoque.MaterialBean;
import jalis.model.bean.estoque.MaterialLoteBean;
import jalis.model.bean.estoque.MaterialLoteLanctoEstoqueBean;
import jalis.model.bean.estoque.MaterialPatrimonioBean;
import jalis.model.bean.estoque.RequisicaoEstoqueBean;
import jalis.model.bean.estoque.RequisicaoEstoqueMaterialBean;
import jalis.model.bean.estoque.SaldoEstoqueCelulaBean;
import jalis.model.bean.estoque.TransfEstoqueBean;
import jalis.model.bean.estoque.TransfEstoqueMaterialBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.estoque.CelulaEstoqueVO;
import jalis.model.vo.estoque.LancamentoEstoqueVO;
import jalis.model.vo.estoque.MaterialVO;
import jalis.model.vo.estoque.RequisicaoEstoqueVO;
import jalis.service.estoque.CelulaEstoqueService;
import jalis.service.estoque.EstoqueManualService;
import jalis.service.estoque.LancamentoEstoquePepsService;
import jalis.service.estoque.LancamentoEstoqueUepsService;
import jalis.service.estoque.MaterialPatrimonioService;
import jalis.service.estoque.MaterialService;
import jalis.service.estoque.RequisicaoEstoqueService;
import jalis.service.estoque.SaldoEstoqueCelulaService;
import jalis.service.estoque.TransfEstoqueService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;

public class ManutencaoEstoque
extends FrmCadPadrao {
    private TTextField textCodigoMaterial = new TTextField(18, 3);
    private TTextField textQuantidade = new TTextField(12, 2);
    private JButton buttonBuscaMaterial = new JButton();
    private JButton buttonOK = new JButton();
    private JButton buttonImportar = new JButton();
    private JLabel labelCelula = new JLabel();
    private JLabel labelData = new JLabel();
    private JLabel labelDescData = new JLabel();
    private JLabel labelDescUsuario = new JLabel();
    private JLabel labelMaterial = new JLabel();
    private JLabel labelRecebida = new JLabel();
    private JLabel labelUsuario = new JLabel();
    private JLabel labelDescricaoMaterial = new JLabel();
    private JLabel labelObservacao = new JLabel();
    private JLabel labelTipoOperacao = new JLabel();
    private JPanel panelBotoes = new JPanel();
    private JPanel panelBotoesA = new JPanel();
    private JPanel panelCentro = new JPanel(new GridBagLayout());
    private JPanel panelObservacao = new JPanel(new GridBagLayout());
    private JPanel panelLegenda = null;
    JPanel panelImportar = null;
    private JScrollPane scrollMaterial = null;
    private JScrollPane scrollObservacao = new JScrollPane();
    private JComboBox comboCelula = new JComboBox();
    private String[] arrayOperacoes = new String[]{"I", "B", "A", "N"};
    private JComboBox comboTipoOperacao = new JComboBox<String>(new String[]{Tipos.getTipoOperacaoEstoque(this.arrayOperacoes[0]), Tipos.getTipoOperacaoEstoque(this.arrayOperacoes[1]), Tipos.getTipoOperacaoEstoque(this.arrayOperacoes[2]), Tipos.getTipoOperacaoEstoque(this.arrayOperacoes[3])});
    private ModeloGridTable modeloMaterial = null;
    private JTable tableMaterial;
    private JTextArea areaObservacao = new JTextArea();
    private JPopupMenu menuMaterial = new JPopupMenu();
    private JMenuItem itemAlterar = new JMenuItem("Alterar");
    private JMenuItem itemConfigurarPatrimonios = new JMenuItem("Configurar Patrim\u00f4nios");
    private JPopupMenu menuImportar = new JPopupMenu();
    private JMenuItem itemRequisicao = new JMenuItem("Requisi\u00e7\u00e3o de Material");
    private JMenuItem itemTransferencia = new JMenuItem("Confer\u00eancia de Transfer\u00eancia");
    private MaterialBean materialAux = null;
    private Date dataAux = null;
    private UsuarioVO usuarioAux = null;
    private RequisicaoEstoqueBean requisicaoAux = null;
    private TransfEstoqueBean transferenciaAux = null;
    private boolean isAlterandoMaterial = false;
    private static final Color COR_SOLICITA_PATRIMONIO = ScreenUtil.clarearCor(Color.YELLOW, 125);
    private static final int TIPO_OPERACAO_INCLUSAO = 0;
    private static final int TIPO_OPERACAO_BAIXA = 1;
    private static final int TIPO_OPERACAO_ALTERACAO_SUBTRAIR = 2;
    private static final int TIPO_OPERACAO_ALTERACAO_ADICIONAR = 3;
    private static final int TIPO_OPERACAO_INUTILIZACAO = 4;
    private static final int TIPO_ADICIONAR_MATERIAL = 0;
    private static final int TIPO_TRANSF_MATERIAL = 1;
    private static final int TIPO_REQUISICAO = 2;
    private final int COLUNA_CODIGO = 0;
    private final int COLUNA_MATERIAL = 1;
    private final int COLUNA_TIPO_OPERACAO = 2;
    private final int COLUNA_QUANTIDADE = 3;
    private final int COLUNA_UNIDADE = 4;
    private final int COLUNA_CELULA = 5;
    private final int COLUNA_OBJETO = 6;
    private final int COLUNA_PATRIMONIOS = 7;
    private final int COLUNA_OBJETO_MATERIAL = 8;
    private final int COLUNA_IMPORTADO = 9;
    private final String PARAMETRO_OPERACAO = "ManutencaoEstoque.tipoOperacao";

    public ManutencaoEstoque() {
        this.montaTela();
    }

    private void montaTela() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelCentro, "Center");
        ScreenUtil.setBorda(new Component[]{this.labelDescricaoMaterial, this.labelDescData, this.labelDescUsuario}, new TitledBorder(""));
        Funcoes.criaBarraDescricao(this, "Manuten\u00e7\u00e3o de Estoque", "Manuten\u00e7\u00e3o do estoque dos materiais", "estoque/manutencao_estoque.jpg");
        this.panelCentro.setBorder(ScreenUtil.criarBordaVazia());
        this.buscaCelulasCombo();
        this.menuMaterial.add(this.itemAlterar);
        this.menuMaterial.add(this.itemConfigurarPatrimonios);
        this.menuImportar.add(this.itemRequisicao);
        this.menuImportar.add(this.itemTransferencia);
        this.itemAlterar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManutencaoEstoque.this.alterarMaterial();
            }
        });
        this.itemConfigurarPatrimonios.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = ManutencaoEstoque.this.tableMaterial.getSelectedRow();
                boolean tipoOperacaoRemocao = false;
                ManutencaoEstoque.this.isAlterandoMaterial = true;
                if (row >= 0) {
                    MaterialBean beanMat = (MaterialBean)ManutencaoEstoque.this.modeloMaterial.getValueAt(row, 8);
                    EstoqueManualMaterialBean estBean = (EstoqueManualMaterialBean)ManutencaoEstoque.this.modeloMaterial.getValueAt(row, 6);
                    boolean importado = (Boolean)(ManutencaoEstoque.this.modeloMaterial.getValueAt(row, 9) == null ? Boolean.valueOf(false) : ManutencaoEstoque.this.modeloMaterial.getValueAt(row, 9));
                    int tipoOperacao = -1;
                    ArrayList dadosPatrimonio = null;
                    SaldoEstoqueCelulaBean saldo = null;
                    try {
                        saldo = (SaldoEstoqueCelulaBean)new SaldoEstoqueCelulaService().getSaldoAtualEstoqueMaterialCelula(Variaveis.filialPadrao, beanMat.getCodigo().toString(), estBean.getCelula().getCodigo().toString());
                    }
                    catch (Exception e1) {
                        saldo = new SaldoEstoqueCelulaBean();
                        saldo.setSaldo(0.0);
                    }
                    if (saldo == null) {
                        saldo = new SaldoEstoqueCelulaBean();
                        saldo.setSaldo(0.0);
                    }
                    if (estBean.getTipoOperacao() == "I") {
                        tipoOperacao = 0;
                        beanMat.setPatrimonios(new ArrayList<MaterialPatrimonioBean>());
                    } else if (estBean.getTipoOperacao() == "B") {
                        tipoOperacao = 1;
                        tipoOperacaoRemocao = true;
                    } else if (estBean.getTipoOperacao() == "N") {
                        tipoOperacao = 4;
                        tipoOperacaoRemocao = true;
                    } else if (estBean.getTipoOperacao() == "A") {
                        if (saldo == null || estBean.getQuantidade() >= saldo.getSaldo()) {
                            tipoOperacao = 3;
                        } else {
                            tipoOperacao = 2;
                            tipoOperacaoRemocao = true;
                        }
                    }
                    if ((tipoOperacao == 2 || tipoOperacao == 1 || tipoOperacao == 4) && saldo.getSaldo() < estBean.getQuantidade()) {
                        Funcoes.mensagem(ManutencaoEstoque.this, "A quantidade em estoque \u00e9 insuficiente.\nEstoque atual: " + Funcoes.formataDecimal(saldo.getSaldo()) + ".", 2);
                        return;
                    }
                    dadosPatrimonio = tipoOperacao == 2 ? ManutencaoEstoque.this.configurarPatrimonios(beanMat, saldo.getSaldo() - (estBean.getQuantidade() == null ? 0.0 : estBean.getQuantidade()), tipoOperacao, row) : (tipoOperacao == 3 ? ManutencaoEstoque.this.configurarPatrimonios(beanMat, (estBean.getQuantidade() == null ? 0.0 : estBean.getQuantidade()) - saldo.getSaldo(), tipoOperacao, row) : ManutencaoEstoque.this.configurarPatrimonios(beanMat, estBean.getQuantidade() == null ? 0.0 : estBean.getQuantidade(), tipoOperacao, row));
                    if (beanMat.getSolicitarPatrimonio() != null && beanMat.getSolicitarPatrimonio().booleanValue() && dadosPatrimonio == null) {
                        return;
                    }
                    if (!ManutencaoEstoque.this.isAlterandoMaterial) {
                        ManutencaoEstoque.this.modeloMaterial.addLine(new Object[]{estBean.getMaterial().getCodigo(), estBean.getMaterial().getDescricao(), Tipos.getTipoOperacaoEstoque(estBean.getTipoOperacao()), Funcoes.formataDecimal(estBean.getQuantidade()), estBean.getMaterial().getUnidadeMedida().getCodigo(), estBean.getCelula(), estBean, dadosPatrimonio, beanMat, importado});
                    } else {
                        ManutencaoEstoque.this.modeloMaterial.setValueAt(estBean.getMaterial().getCodigo(), row, 0);
                        ManutencaoEstoque.this.modeloMaterial.setValueAt(estBean.getMaterial().getDescricao(), row, 1);
                        ManutencaoEstoque.this.modeloMaterial.setValueAt(Tipos.getTipoOperacaoEstoque(estBean.getTipoOperacao()), row, 2);
                        ManutencaoEstoque.this.modeloMaterial.setValueAt(Funcoes.formataDecimal(estBean.getQuantidade()), row, 3);
                        ManutencaoEstoque.this.modeloMaterial.setValueAt(estBean.getMaterial().getUnidadeMedida().getCodigo(), row, 4);
                        ManutencaoEstoque.this.modeloMaterial.setValueAt(estBean.getCelula(), row, 5);
                        ManutencaoEstoque.this.modeloMaterial.setValueAt(estBean, row, 6);
                        ManutencaoEstoque.this.modeloMaterial.setValueAt(dadosPatrimonio, row, 7);
                        ManutencaoEstoque.this.modeloMaterial.setValueAt(beanMat, row, 8);
                        ManutencaoEstoque.this.modeloMaterial.setValueAt(importado, row, 9);
                    }
                    if (dadosPatrimonio != null) {
                        ManutencaoEstoque.this.modeloMaterial.setValueAt(dadosPatrimonio, row, 7);
                    }
                }
                ManutencaoEstoque.this.isAlterandoMaterial = false;
            }
        });
        this.buttonImportar.setMnemonic('I');
        this.buttonImportar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ManutencaoEstoque.this.panelImportar != null) {
                    ManutencaoEstoque.this.menuImportar.show(ManutencaoEstoque.this.panelImportar, ManutencaoEstoque.this.buttonImportar.getX(), ManutencaoEstoque.this.buttonImportar.getY() + ManutencaoEstoque.this.buttonImportar.getHeight());
                }
            }
        });
        this.itemRequisicao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RequisicaoEstoqueVO requisicao = new RequisicaoEstoqueVO();
                RequisicaoEstoqueService serviceRequisicao = new RequisicaoEstoqueService();
                requisicao = (RequisicaoEstoqueVO)serviceRequisicao.pesquisaRequisicaoAbertaVO(Laboratorio.getInstancia(), requisicao, "Pesquisando Requisi\u00e7\u00f5es", false);
                if (requisicao != null) {
                    RequisicaoEstoqueBean reqBean = null;
                    try {
                        reqBean = (RequisicaoEstoqueBean)serviceRequisicao.get(requisicao.getFilial().getCodigo().toString(), requisicao.getCodigo().toString());
                    }
                    catch (Exception e1) {
                        ErrorLogger.mostraMensagem(ManutencaoEstoque.this, e1.getMessage(), e1.getStackTrace());
                        return;
                    }
                    ManutencaoEstoque.this.preencherDadosRequisicao(reqBean);
                    ManutencaoEstoque.this.setStatus(2);
                    ManutencaoEstoque.this.controlaCampos();
                    if (ManutencaoEstoque.this.textCodigoMaterial.isFocusable() && ManutencaoEstoque.this.textCodigoMaterial.isEnabled()) {
                        ManutencaoEstoque.this.textCodigoMaterial.grabFocus();
                    }
                }
            }
        });
        this.itemTransferencia.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Integer transferencia;
                TransfEstoqueService serviceTransferencia = new TransfEstoqueService();
                Hashtable hash = serviceTransferencia.pesquisaTransfEstoqueConciliadaVO(Laboratorio.getInstancia(), false);
                if (hash != null && (transferencia = (Integer)hash.get("tra_codigo")) != null) {
                    TransfEstoqueBean transBean = null;
                    try {
                        transBean = (TransfEstoqueBean)serviceTransferencia.get(Variaveis.filialPadrao, transferencia.toString(), false);
                    }
                    catch (Exception e1) {
                        ErrorLogger.mostraMensagem(ManutencaoEstoque.this, e1.getMessage(), e1.getStackTrace());
                        return;
                    }
                    ManutencaoEstoque.this.preencherDadosTransferencia(transBean);
                    ManutencaoEstoque.this.setStatus(2);
                    ManutencaoEstoque.this.controlaCampos();
                    if (ManutencaoEstoque.this.textCodigoMaterial.isFocusable() && ManutencaoEstoque.this.textCodigoMaterial.isEnabled()) {
                        ManutencaoEstoque.this.textCodigoMaterial.grabFocus();
                    }
                    ManutencaoEstoque.this.transferenciaAux = transBean;
                }
            }
        });
        this.comboTipoOperacao.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (ManutencaoEstoque.this.comboTipoOperacao.getSelectedItem().equals(Tipos.getTipoOperacaoEstoque("B")) || ManutencaoEstoque.this.comboTipoOperacao.getSelectedItem().equals(Tipos.getTipoOperacaoEstoque("N"))) {
                    Integer celula = null;
                    if (ParametrosGerais.getPerguntarValorEstoque().equalsIgnoreCase("P")) {
                        try {
                            celula = new LancamentoEstoquePepsService().getProximaCelula(Variaveis.filialPadrao.toString(), ManutencaoEstoque.this.textCodigoMaterial.getText());
                        }
                        catch (Exception e1) {
                            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel efetuar busca autom\u00e1tica de c\u00e9lula de sa\u00edda (PEPS)." + e1.getMessage(), e1.getStackTrace());
                        }
                    } else if (ParametrosGerais.getPerguntarValorEstoque().equalsIgnoreCase("U")) {
                        try {
                            celula = new LancamentoEstoqueUepsService().getProximaCelula(Variaveis.filialPadrao.toString(), ManutencaoEstoque.this.textCodigoMaterial.getText());
                        }
                        catch (Exception e1) {
                            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel efetuar busca autom\u00e1tica de c\u00e9lula de sa\u00edda (UEPS)." + e1.getMessage(), e1.getStackTrace());
                        }
                    }
                    if (celula != null) {
                        CelulaEstoqueVO celulaVO = null;
                        try {
                            celulaVO = (CelulaEstoqueVO)new CelulaEstoqueService().getVO(Variaveis.filialPadrao.toString(), celula.toString());
                        }
                        catch (Exception e1) {
                            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel carregar dados da c\u00e9lula de sa\u00edda." + e1.getMessage(), e1.getStackTrace());
                        }
                        if (celulaVO != null) {
                            for (int i = 0; i < ManutencaoEstoque.this.comboCelula.getItemCount(); ++i) {
                                if (((CelulaEstoqueVO)ManutencaoEstoque.this.comboCelula.getItemAt(i)).getCodigo().intValue() != celulaVO.getCodigo().intValue()) continue;
                                ManutencaoEstoque.this.comboCelula.setSelectedIndex(i);
                                break;
                            }
                        }
                    }
                }
            }
        });
        this.buttonOK.setMnemonic('K');
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ManutencaoEstoque.this.materialAux == null) {
                    Funcoes.mensagem(ManutencaoEstoque.this, "Nenhum material foi selecionado.", 2);
                    if (ManutencaoEstoque.this.textCodigoMaterial.isFocusable() && ManutencaoEstoque.this.textCodigoMaterial.isEnabled()) {
                        ManutencaoEstoque.this.textCodigoMaterial.grabFocus();
                    }
                    return;
                }
                if (ManutencaoEstoque.this.textQuantidade.getText().isEmpty()) {
                    Funcoes.mensagem(ManutencaoEstoque.this, "A quantidade recebida deve ser informada.", 2);
                    if (ManutencaoEstoque.this.textQuantidade.isFocusable() && ManutencaoEstoque.this.textQuantidade.isEnabled()) {
                        ManutencaoEstoque.this.textQuantidade.grabFocus();
                    }
                    return;
                }
                if (ManutencaoEstoque.this.comboCelula.getSelectedIndex() < 0) {
                    Funcoes.mensagem(ManutencaoEstoque.this, "Nenhuma c\u00e9lula foi selecionada.", 2);
                    if (ManutencaoEstoque.this.comboCelula.isFocusable() && ManutencaoEstoque.this.comboCelula.isEnabled()) {
                        ManutencaoEstoque.this.comboCelula.grabFocus();
                    }
                    return;
                }
                if (ManutencaoEstoque.this.comboTipoOperacao.getSelectedIndex() < 0) {
                    Funcoes.mensagem(ManutencaoEstoque.this, "Nenhuma opera\u00e7\u00e3o foi selecionada.", 2);
                    if (ManutencaoEstoque.this.comboTipoOperacao.isFocusable() && ManutencaoEstoque.this.comboTipoOperacao.isEnabled()) {
                        ManutencaoEstoque.this.comboTipoOperacao.grabFocus();
                    }
                    return;
                }
                Double qtde = Double.parseDouble(ManutencaoEstoque.this.textQuantidade.getText());
                if (ManutencaoEstoque.this.isTipoOperacaoAlteracao() && ManutencaoEstoque.this.isQtdeMenorIgualZero(qtde)) {
                    Funcoes.mensagem(ManutencaoEstoque.this, "O campo 'Quantidade' deve possuir valor maior que 'Zero'.", 2);
                    ManutencaoEstoque.this.textQuantidade.grabFocus();
                    return;
                }
                if (ManutencaoEstoque.this.arrayOperacoes[ManutencaoEstoque.this.comboTipoOperacao.getSelectedIndex()] == "B" || ManutencaoEstoque.this.arrayOperacoes[ManutencaoEstoque.this.comboTipoOperacao.getSelectedIndex()] == "N") {
                    SaldoEstoqueCelulaService serviceAux = new SaldoEstoqueCelulaService();
                    try {
                        SaldoEstoqueCelulaBean saldo = (SaldoEstoqueCelulaBean)serviceAux.getSaldoAtualEstoqueMaterialCelula(Variaveis.filialPadrao, ManutencaoEstoque.this.materialAux.getCodigo().toString(), ((CelulaEstoqueVO)ManutencaoEstoque.this.comboCelula.getSelectedItem()).getCodigo().toString());
                        if (saldo == null || saldo.getSaldo() < Double.parseDouble(Funcoes.limpaDecimal(ManutencaoEstoque.this.textQuantidade.getText()))) {
                            Funcoes.mensagem(ManutencaoEstoque.this, "O saldo atual \u00e9 inferior \u00e0 quantidade informada na opera\u00e7\u00e3o.\nSaldo atual da c\u00e9lula: " + Funcoes.formataDecimal(saldo == null ? 0.0 : saldo.getSaldo()) + ".", 2);
                            return;
                        }
                    }
                    catch (Exception e1) {
                        ErrorLogger.mostraMensagem(ManutencaoEstoque.this, "N\u00e3o foi poss\u00edvel buscar saldo atual em estoque do material na c\u00e9lula.\n" + e1.getMessage(), e1.getStackTrace());
                    }
                }
                EstoqueManualMaterialBean material = new EstoqueManualMaterialBean();
                FilialVO filial = new FilialVO();
                filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
                material.setFilial(filial);
                material.setMaterial((MaterialVO)ManutencaoEstoque.this.materialAux.toVO());
                material.setQuantidade(Double.parseDouble(Funcoes.limpaDecimal(ManutencaoEstoque.this.textQuantidade.getText())));
                material.setCelula((CelulaEstoqueVO)ManutencaoEstoque.this.comboCelula.getSelectedItem());
                material.setTipoOperacao(ManutencaoEstoque.this.arrayOperacoes[ManutencaoEstoque.this.comboTipoOperacao.getSelectedIndex()]);
                String operacao = Tipos.tipoOperacaoEstoque(ManutencaoEstoque.this.comboTipoOperacao.getSelectedItem().toString());
                if ((operacao.equalsIgnoreCase("A") || operacao.equalsIgnoreCase("N")) && ParametrosGerais.isSolicitaAnaliseCriticaMovimentarMateriaisEstoque()) {
                    DialogoAnaliseCritica analiseCritica = DialogoAnaliseCritica.novaInstancia(Laboratorio.getInstancia());
                    if (ManutencaoEstoque.this.isAlterandoMaterial) {
                        analiseCritica.setAnalise(ManutencaoEstoque.this.materialAux.getAnaliseCritica());
                    }
                    analiseCritica.setVisible(true);
                    if (analiseCritica.getOK()) {
                        ManutencaoEstoque.this.materialAux.setAnaliseCritica(analiseCritica.getAnalise());
                        material.getMaterial().setAnaliseCritica(analiseCritica.getAnalise());
                    }
                }
                int row = -1;
                for (int i = 0; i < ManutencaoEstoque.this.modeloMaterial.getRowCount(); ++i) {
                    if (((Integer)ManutencaoEstoque.this.modeloMaterial.getValueAt(i, 0)).intValue() != ManutencaoEstoque.this.materialAux.getCodigo().intValue()) continue;
                    row = i;
                }
                if (ManutencaoEstoque.this.adicionaMaterial(material, ManutencaoEstoque.this.materialAux, row, false)) {
                    ManutencaoEstoque.this.textCodigoMaterial.setText("");
                    ManutencaoEstoque.this.labelDescricaoMaterial.setText("");
                    ManutencaoEstoque.this.textQuantidade.setText("");
                }
                if (ManutencaoEstoque.this.textCodigoMaterial.isFocusable() && ManutencaoEstoque.this.textCodigoMaterial.isEnabled()) {
                    ManutencaoEstoque.this.textCodigoMaterial.grabFocus();
                }
            }
        });
        this.textCodigoMaterial.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (Funcoes.textoVazio(ManutencaoEstoque.this.textCodigoMaterial)) {
                    ManutencaoEstoque.this.materialAux = null;
                    ManutencaoEstoque.this.labelDescricaoMaterial.setText("");
                    ManutencaoEstoque.this.controlaCampos();
                    return;
                }
                MaterialBean material = null;
                try {
                    material = (MaterialBean)new MaterialService().getAtivo(Variaveis.filialPadrao, ManutencaoEstoque.this.textCodigoMaterial.getText(), null, null, false, false);
                }
                catch (Exception e1) {
                    ManutencaoEstoque.this.materialAux = null;
                    ManutencaoEstoque.this.labelDescricaoMaterial.setText("N\u00e3o cadastrado");
                    ManutencaoEstoque.this.controlaCampos();
                }
                if (material != null) {
                    ManutencaoEstoque.this.materialAux = material;
                    ManutencaoEstoque.this.labelDescricaoMaterial.setText(material.getDescricao());
                } else {
                    ManutencaoEstoque.this.materialAux = null;
                    ManutencaoEstoque.this.labelDescricaoMaterial.setText("N\u00e3o cadastrado");
                    ManutencaoEstoque.this.textCodigoMaterial.clear();
                }
                ManutencaoEstoque.this.controlaCampos();
                if (ManutencaoEstoque.this.comboTipoOperacao.isEnabled() && ManutencaoEstoque.this.comboTipoOperacao.isFocusable()) {
                    ScreenUtil.requisitarFoco(ManutencaoEstoque.this.comboTipoOperacao);
                }
            }
        });
        this.buttonBuscaMaterial.setFocusable(false);
        Funcoes.imagemPesquisa(this.buttonBuscaMaterial);
        this.buttonBuscaMaterial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Hashtable hash = Pesquisas.materialAtivo(Laboratorio.getInstancia(), true);
                if (hash != null) {
                    MaterialBean bean = null;
                    try {
                        bean = (MaterialBean)new MaterialService().getAtivo(Variaveis.filialPadrao, String.valueOf((Integer)hash.get("mat_codigo")), null, null, false, false);
                    }
                    catch (Exception e1) {
                        Funcoes.mensagem(ManutencaoEstoque.this, "N\u00e3o foi poss\u00edvel buscar dados do material.", 2);
                        return;
                    }
                    if (bean != null) {
                        ManutencaoEstoque.this.textCodigoMaterial.setText(String.valueOf(bean.getCodigo()));
                        ManutencaoEstoque.this.labelDescricaoMaterial.setText(bean.getDescricao());
                        ManutencaoEstoque.this.materialAux = bean;
                    } else {
                        ManutencaoEstoque.this.textCodigoMaterial.setText(String.valueOf((Integer)hash.get("mat_codigo")));
                        ManutencaoEstoque.this.labelDescricaoMaterial.setText("N\u00e3o cadastrado");
                    }
                }
                ManutencaoEstoque.this.controlaCampos();
            }
        });
        this.modeloMaterial = new ModeloGridTable(new String[]{"C\u00f3digo", "Material", "Tipo Opera\u00e7\u00e3o", "Quantidade", "Unid.", "C\u00e9lula"}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return super.getColumnClass(columnIndex);
            }
        };
        this.tableMaterial = new JTable(this.modeloMaterial);
        this.tableMaterial.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
            }
        });
        this.tableMaterial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int row;
                if (e.getKeyCode() == 127) {
                    int row2 = ((JTable)e.getSource()).getSelectedRow();
                    if (row2 > -1) {
                        boolean importado = (Boolean)(ManutencaoEstoque.this.modeloMaterial.getValueAt(row2, 9) != null ? ManutencaoEstoque.this.modeloMaterial.getValueAt(row2, 9) : Boolean.valueOf(false));
                        if (importado) {
                            Funcoes.mensagem(ManutencaoEstoque.this, "O material foi importado e n\u00e3o pode ser removido.", 2);
                            return;
                        }
                        int resp = Funcoes.mensagem(ManutencaoEstoque.this, "Deseja remover?", 4);
                        if (resp == 0) {
                            ManutencaoEstoque.this.modeloMaterial.removeLine(row2);
                            if (ManutencaoEstoque.this.textCodigoMaterial.isEnabled() && ManutencaoEstoque.this.textCodigoMaterial.isFocusable()) {
                                ScreenUtil.requisitarFoco(ManutencaoEstoque.this.textCodigoMaterial);
                            }
                        }
                    }
                } else if (e.getKeyCode() == 32 && (row = ManutencaoEstoque.this.tableMaterial.getSelectedRow()) >= 0) {
                    MaterialBean material = (MaterialBean)ManutencaoEstoque.this.modeloMaterial.getValueAt(row, 8);
                    if (material.getSolicitarPatrimonio() != null && material.getSolicitarPatrimonio().booleanValue()) {
                        ManutencaoEstoque.this.abrirPopup();
                    } else {
                        ManutencaoEstoque.this.alterarMaterial();
                    }
                }
            }
        });
        this.tableMaterial.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row;
                if (e.getClickCount() == 1) {
                    if (ManutencaoEstoque.this.isAlterandoMaterial) {
                        ManutencaoEstoque.this.textCodigoMaterial.setText("");
                        ManutencaoEstoque.this.labelDescricaoMaterial.setText("");
                        ManutencaoEstoque.this.textQuantidade.setText("");
                        if (ManutencaoEstoque.this.comboTipoOperacao.getItemCount() > 0) {
                            ManutencaoEstoque.this.comboTipoOperacao.setSelectedIndex(0);
                        }
                        ManutencaoEstoque.this.isAlterandoMaterial = false;
                        ManutencaoEstoque.this.controlaCampos();
                    }
                } else if (e.getClickCount() == 2 && (row = ManutencaoEstoque.this.tableMaterial.getSelectedRow()) >= 0) {
                    MaterialBean material = (MaterialBean)ManutencaoEstoque.this.modeloMaterial.getValueAt(row, 8);
                    if (material != null && material.getSolicitarPatrimonio() != null && material.getSolicitarPatrimonio().booleanValue()) {
                        ManutencaoEstoque.this.abrirPopup();
                    } else {
                        ManutencaoEstoque.this.alterarMaterial();
                    }
                }
            }
        });
        this.modeloMaterial.setColumnSize(new int[]{80, 0, 130, 90, 60, 130}, this.tableMaterial);
        this.tableMaterial.getTableHeader().addMouseListener(this.modeloMaterial);
        this.scrollMaterial = new JScrollPane(this.tableMaterial);
        EstoqueRenderer renderer = new EstoqueRenderer();
        this.tableMaterial.setDefaultRenderer(Object.class, renderer);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelCentro.add((Component)this.scrollMaterial, gridBagConstraints);
        this.labelObservacao.setLabelFor(this.areaObservacao);
        this.labelObservacao.setDisplayedMnemonic('O');
        this.labelObservacao.setText("Observa\u00e7\u00e3o");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.panelObservacao.add((Component)this.labelObservacao, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panelObservacao.add((Component)new JLabel(), gridBagConstraints);
        this.areaObservacao.setRows(2);
        this.scrollObservacao.setMinimumSize(new Dimension(20, 60));
        this.scrollObservacao.setPreferredSize(new Dimension(20, 60));
        this.scrollObservacao.setViewportView(this.areaObservacao);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        this.panelObservacao.add((Component)this.scrollObservacao, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 7;
        this.panelCentro.add((Component)this.panelObservacao, gridBagConstraints);
        this.buttonImportar.setText("Importar \u25bc");
        this.panelImportar = new JPanel(new FlowLayout(0));
        this.panelImportar.add(this.buttonImportar);
        JPanel panelBotoesBasicos = new JPanel(new FlowLayout(2));
        panelBotoesBasicos.add(this.botaoNovo);
        panelBotoesBasicos.add(this.botaoSalvar);
        panelBotoesBasicos.add(this.botaoCancelar);
        panelBotoesBasicos.add(this.botaoFechar);
        this.panelBotoesA.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelBotoesA.add((Component)this.panelImportar, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.panelBotoesA.add((Component)panelBotoesBasicos, gridBagConstraints);
        this.panelBotoes.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelBotoes.add((Component)this.panelBotoesA, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelCentro.add((Component)this.panelBotoes, gridBagConstraints);
        this.labelMaterial.setLabelFor(this.textCodigoMaterial);
        this.labelMaterial.setDisplayedMnemonic('M');
        this.labelMaterial.setText("Material");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.panelCentro.add((Component)this.labelMaterial, gridBagConstraints);
        this.labelTipoOperacao.setLabelFor(this.comboTipoOperacao);
        this.labelTipoOperacao.setDisplayedMnemonic('p');
        this.labelTipoOperacao.setText("Opera\u00e7\u00e3o");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.panelCentro.add((Component)this.labelTipoOperacao, gridBagConstraints);
        this.labelRecebida.setLabelFor(this.textQuantidade);
        this.labelRecebida.setDisplayedMnemonic('Q');
        this.labelRecebida.setText("Quantidade");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.panelCentro.add((Component)this.labelRecebida, gridBagConstraints);
        this.labelCelula.setLabelFor(this.comboCelula);
        this.labelCelula.setDisplayedMnemonic('u');
        this.labelCelula.setText("C\u00e9lula");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.panelCentro.add((Component)this.labelCelula, gridBagConstraints);
        this.textCodigoMaterial.setPreferredSize(new Dimension(70, 20));
        this.textCodigoMaterial.setMinimumSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.panelCentro.add((Component)this.textCodigoMaterial, gridBagConstraints);
        this.labelDescricaoMaterial.setPreferredSize(new Dimension(20, 20));
        this.labelDescricaoMaterial.setMinimumSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelCentro.add((Component)this.labelDescricaoMaterial, gridBagConstraints);
        this.comboTipoOperacao.setPreferredSize(new Dimension(160, 20));
        this.comboTipoOperacao.setMinimumSize(new Dimension(160, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.panelCentro.add((Component)this.comboTipoOperacao, gridBagConstraints);
        this.textQuantidade.setPreferredSize(new Dimension(80, 20));
        this.textQuantidade.setMinimumSize(new Dimension(80, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.panelCentro.add((Component)this.textQuantidade, gridBagConstraints);
        this.comboCelula.setPreferredSize(new Dimension(100, 20));
        this.comboCelula.setMinimumSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.panelCentro.add((Component)this.comboCelula, gridBagConstraints);
        this.buttonOK.setText("OK");
        this.buttonOK.setMaximumSize(new Dimension(40, 20));
        this.buttonOK.setMinimumSize(new Dimension(40, 20));
        this.buttonOK.setPreferredSize(new Dimension(40, 20));
        this.buttonOK.setMargin(new Insets(1, 1, 1, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        this.panelCentro.add((Component)this.buttonOK, gridBagConstraints);
        this.buttonBuscaMaterial.setMaximumSize(new Dimension(20, 20));
        this.buttonBuscaMaterial.setMinimumSize(new Dimension(20, 20));
        this.buttonBuscaMaterial.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.panelCentro.add((Component)this.buttonBuscaMaterial, gridBagConstraints);
        this.labelData.setText("Data:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.panelCentro.add((Component)this.labelData, gridBagConstraints);
        this.labelUsuario.setText("Usu\u00e1rio:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.panelCentro.add((Component)this.labelUsuario, gridBagConstraints);
        this.labelDescData.setPreferredSize(new Dimension(80, 20));
        this.labelDescData.setMinimumSize(new Dimension(40, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        this.panelCentro.add((Component)this.labelDescData, gridBagConstraints);
        this.labelDescUsuario.setPreferredSize(new Dimension(40, 20));
        this.labelDescUsuario.setMinimumSize(new Dimension(40, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelCentro.add((Component)this.labelDescUsuario, gridBagConstraints);
        this.panelLegenda = this.montaPainelLegenda();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelCentro.add((Component)this.panelLegenda, gridBagConstraints);
        this.controlaCampos();
        this.modeloMaterial.ordenarColuna(1);
    }

    private boolean isQtdeMenorIgualZero(Double qtde) {
        return qtde <= 0.0;
    }

    private boolean isTipoOperacaoAlteracao() {
        return this.comboTipoOperacao.getSelectedIndex() != 2;
    }

    private void preencherDadosRequisicao(RequisicaoEstoqueBean requisicao) {
        String operacao = this.getTipoOperacao();
        CelulaEstoqueVO celula = this.getCelulaEstoque();
        if (celula == null) {
            Funcoes.mensagem(this, "Um c\u00e9lula de estoque deve ser selecionada.", 2);
            return;
        }
        this.dataAux = new Date();
        this.usuarioAux = requisicao.getUsuario();
        this.labelDescData.setText(Funcoes.formataData("dd/MM/yyyy HH:mm:ss", this.dataAux));
        this.labelDescUsuario.setText(this.usuarioAux.getCodigo());
        this.areaObservacao.setText(requisicao.getObservacao());
        ArrayList<RequisicaoEstoqueMaterialBean> materiais = requisicao.getMateriais();
        for (int i = 0; i < materiais.size(); ++i) {
            RequisicaoEstoqueMaterialBean material = materiais.get(i);
            EstoqueManualMaterialBean estoqueMaterial = new EstoqueManualMaterialBean();
            estoqueMaterial.setFilial(material.getFilial());
            estoqueMaterial.setMaterial(material.getMaterial());
            estoqueMaterial.setQuantidade(material.getQuantidade());
            estoqueMaterial.setTipoOperacao(operacao);
            estoqueMaterial.setCelula(celula);
            MaterialBean beanMaterial = null;
            try {
                beanMaterial = (MaterialBean)new MaterialService().getTodos(Variaveis.filialPadrao, material.getMaterial().getCodigo().toString(), null, null);
            }
            catch (Exception e) {
                Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel carregar dados do material.", 2);
            }
            this.adicionaMaterial(estoqueMaterial, beanMaterial, -1, true);
            this.requisicaoAux = requisicao;
        }
        this.controlaCampos();
    }

    private void preencherDadosTransferencia(TransfEstoqueBean transferencia) {
        String operacao = this.getTipoOperacao();
        this.dataAux = new Date();
        this.usuarioAux = transferencia.getUsuario();
        this.labelDescData.setText(Funcoes.formataData("dd/MM/yyyy HH:mm:ss", this.dataAux));
        this.labelDescUsuario.setText(this.usuarioAux.getCodigo());
        this.areaObservacao.setText(transferencia.getRequisicao() != null ? transferencia.getRequisicao().getObservacao() : "");
        ArrayList<TransfEstoqueMaterialBean> materiais = transferencia.getMateriais();
        for (int i = 0; i < materiais.size(); ++i) {
            TransfEstoqueMaterialBean material = materiais.get(i);
            EstoqueManualMaterialBean estoqueMaterial = new EstoqueManualMaterialBean();
            estoqueMaterial.setFilial(material.getFilial());
            estoqueMaterial.setMaterial(material.getMaterial());
            estoqueMaterial.setQuantidade(material.getQuantidade());
            estoqueMaterial.setTipoOperacao(operacao);
            estoqueMaterial.setCelula(transferencia.getCelulaDestino());
            MaterialBean beanMaterial = null;
            try {
                beanMaterial = (MaterialBean)new MaterialService().getTodos(Variaveis.filialPadrao, material.getMaterial().getCodigo().toString(), null, null);
            }
            catch (Exception e) {
                Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel carregar dados do material.", 2);
            }
            this.adicionaMaterial(estoqueMaterial, beanMaterial, -1, true);
            this.transferenciaAux = transferencia;
            SaldoEstoqueCelulaBean saldo = null;
            try {
                if (beanMaterial != null) {
                    saldo = (SaldoEstoqueCelulaBean)new SaldoEstoqueCelulaService().getSaldoAtualEstoqueMaterialCelula(Variaveis.filialPadrao, beanMaterial.getCodigo().toString(), estoqueMaterial.getCelula().getCodigo().toString());
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), "N\u00e3o foi poss\u00edvel buscar saldo do estoque.", e.getStackTrace());
                return;
            }
            this.solicitarAtualizacaoLote(1, 0, beanMaterial, estoqueMaterial, saldo);
        }
        this.controlaCampos();
    }

    private String getTipoOperacao() {
        JanelaTipoOperacao dialog = new JanelaTipoOperacao((Window)Laboratorio.getInstancia());
        dialog.setVisible(true);
        return dialog.getOk();
    }

    private CelulaEstoqueVO getCelulaEstoque() {
        JanelaCelulaEstoque dialog = new JanelaCelulaEstoque((Window)Laboratorio.getInstancia());
        dialog.setVisible(true);
        return dialog.getOk();
    }

    private boolean adicionaMaterial(EstoqueManualMaterialBean material, MaterialBean matBean, int row, boolean isImportando) {
        SplashMensagem splashMensagem = SplashMensagem.getInstancia(this);
        splashMensagem.mostrar("Aguarde...");
        try {
            new MaterialService();
            MaterialService.carregarLotesMaterial(matBean, false);
        }
        catch (ThreadDaoException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        for (int i = 0; i < this.modeloMaterial.getRowCount(); ++i) {
            EstoqueManualMaterialBean aux = (EstoqueManualMaterialBean)this.modeloMaterial.getValueAt(i, 6);
            if (aux == null || aux.getMaterial().getCodigo().intValue() != material.getMaterial().getCodigo().intValue() || aux.getCelula().getCodigo().intValue() != material.getCelula().getCodigo().intValue() || this.isAlterandoMaterial) continue;
            Funcoes.mensagem(this, "H\u00e1 uma modifica\u00e7\u00e3o de estoque do material na c\u00e9lula.", 2);
            if (this.textCodigoMaterial.isFocusable() && this.textCodigoMaterial.isEnabled()) {
                this.textCodigoMaterial.grabFocus();
            }
            splashMensagem.apagar();
            return false;
        }
        ArrayList<DadosPatrimonio> dadosPatrimonio = null;
        ArrayList<DadosPatrimonio> auxPatrimonio = null;
        boolean importado = isImportando || ((Boolean)(row >= 0 && this.modeloMaterial.getValueAt(row, 9) != null ? this.modeloMaterial.getValueAt(row, 9) : Boolean.valueOf(false))).booleanValue();
        boolean tipoOperacaoRemocao = false;
        SaldoEstoqueCelulaBean saldo = null;
        try {
            saldo = (SaldoEstoqueCelulaBean)new SaldoEstoqueCelulaService().getSaldoAtualEstoqueMaterialCelula(Variaveis.filialPadrao, matBean.getCodigo().toString(), material.getCelula().getCodigo().toString());
        }
        catch (Exception e) {
            saldo = new SaldoEstoqueCelulaBean();
            saldo.setSaldo(0.0);
        }
        if (saldo == null) {
            saldo = new SaldoEstoqueCelulaBean();
            saldo.setSaldo(0.0);
        }
        int tipoOperacao = -1;
        if (material.getTipoOperacao() == "I") {
            tipoOperacao = 0;
            matBean.setPatrimonios(new ArrayList<MaterialPatrimonioBean>());
        } else if (material.getTipoOperacao() == "B") {
            tipoOperacao = 1;
            tipoOperacaoRemocao = true;
        } else if (material.getTipoOperacao() == "N") {
            tipoOperacao = 4;
            tipoOperacaoRemocao = true;
        } else if (material.getTipoOperacao() == "A") {
            if (saldo == null || material.getQuantidade() > saldo.getSaldo()) {
                tipoOperacao = 3;
            } else if (saldo == null || material.getQuantidade() < saldo.getSaldo()) {
                tipoOperacao = 2;
                tipoOperacaoRemocao = true;
            } else {
                Funcoes.mensagem(this, "A quantidade informada \u00e9 igual ao saldo atual.", 2);
                ScreenUtil.requisitarFoco(this.textQuantidade);
                splashMensagem.apagar();
                return false;
            }
        }
        if ((tipoOperacao == 2 || tipoOperacao == 1 || tipoOperacao == 4) && saldo.getSaldo() < material.getQuantidade()) {
            Funcoes.mensagem(this, "A quantidade em estoque do material \"" + material.getMaterial().getDescricao() + "\" \u00e9 insuficiente.\nEstoque atual: " + Funcoes.formataDecimal(saldo.getSaldo()) + ".\nQuantidade a ser baixada: " + Funcoes.formataDecimal(material.getQuantidade()) + ".", 2);
            splashMensagem.apagar();
            return false;
        }
        auxPatrimonio = tipoOperacao == 2 ? this.configurarPatrimonios(matBean, saldo.getSaldo() - (material.getQuantidade() == null ? 0.0 : material.getQuantidade()), tipoOperacao, row) : (tipoOperacao == 3 ? this.configurarPatrimonios(matBean, (material.getQuantidade() == null ? 0.0 : material.getQuantidade()) - saldo.getSaldo(), tipoOperacao, row) : this.configurarPatrimonios(matBean, material.getQuantidade() == null ? 0.0 : material.getQuantidade(), tipoOperacao, row));
        if (matBean.getSolicitarPatrimonio() != null && matBean.getSolicitarPatrimonio().booleanValue() && auxPatrimonio == null && !isImportando) {
            splashMensagem.apagar();
            return false;
        }
        if (auxPatrimonio != null) {
            dadosPatrimonio = auxPatrimonio;
        }
        if (!(tipoOperacao != 0 && tipoOperacao != 3 || ParametrosGerais.getPerguntarValorEstoque().equals("N"))) {
            PerguntarValorEstoque tela = new PerguntarValorEstoque((Frame)Laboratorio.getInstancia(), material.getMaterial().getCodigo().toString(), this.textQuantidade.getText());
            tela.setValorUnitario(material.getValorUnitario());
            tela.setVisible(true);
            material.setValorUnitario(tela.getValorUnitario());
        }
        if (matBean.getSolicitarLote().booleanValue() && !this.solicitarAtualizacaoLote(0, tipoOperacao, matBean, material, saldo)) {
            splashMensagem.apagar();
            Funcoes.mensagem(this, "Os lotes do material devem ser informados.", 2);
            return false;
        }
        if (!this.isAlterandoMaterial) {
            this.modeloMaterial.addLine(new Object[]{material.getMaterial().getCodigo(), material.getMaterial().getDescricao(), material.getTipoOperacao() != null ? Tipos.getTipoOperacaoEstoque(material.getTipoOperacao()) : "", Funcoes.formataDecimal(material.getQuantidade()), material.getMaterial().getUnidadeMedida().getCodigo(), material.getCelula(), material, dadosPatrimonio, matBean, importado});
        } else {
            this.modeloMaterial.setValueAt(material.getMaterial().getCodigo(), row, 0);
            this.modeloMaterial.setValueAt(material.getMaterial().getDescricao(), row, 1);
            this.modeloMaterial.setValueAt(Tipos.getTipoOperacaoEstoque(material.getTipoOperacao()), row, 2);
            this.modeloMaterial.setValueAt(Funcoes.formataDecimal(material.getQuantidade()), row, 3);
            this.modeloMaterial.setValueAt(material.getMaterial().getUnidadeMedida().getCodigo(), row, 4);
            this.modeloMaterial.setValueAt(material.getCelula(), row, 5);
            this.modeloMaterial.setValueAt(material, row, 6);
            this.modeloMaterial.setValueAt(dadosPatrimonio, row, 7);
            this.modeloMaterial.setValueAt(matBean, row, 8);
            this.modeloMaterial.setValueAt(importado, row, 9);
        }
        if (this.modeloMaterial.getColunaOrdenacao() != -1) {
            this.modeloMaterial.ordenarColunaSemTrocarSentido(this.modeloMaterial.getColunaOrdenacao());
        } else {
            this.modeloMaterial.ordenarColunaSemTrocarSentido(1);
        }
        this.materialAux = null;
        this.isAlterandoMaterial = false;
        this.controlaCampos();
        splashMensagem.apagar();
        return true;
    }

    private boolean possuiLoteCelulaMaterial(MaterialBean beanMaterial, EstoqueManualMaterialBean material) {
        boolean temLote = false;
        Iterator<MaterialLoteBean> it = beanMaterial.getLotes().iterator();
        Double qtde = 0.0;
        while (it.hasNext()) {
            MaterialLoteBean aux = it.next();
            if (material.getCelula() == null) continue;
            for (MaterialLoteLanctoEstoqueBean lanctosLote : aux.getLancamentosEstoque()) {
                LancamentoEstoqueVO lancto = lanctosLote.getLancamento();
                if (lancto == null || !lancto.getTipo().equalsIgnoreCase("E")) continue;
                CelulaEstoqueVO celulaAux = lancto.getCelula();
                qtde = aux.getQuantidade() - aux.getQuantidadeConsumida();
                if (celulaAux == null || celulaAux.getCodigo().intValue() != material.getCelula().getCodigo().intValue() || !(qtde > 0.0)) continue;
                temLote = true;
            }
        }
        return temLote;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean solicitarAtualizacaoLote(int tipoFuncao, int tipoOperacao, MaterialBean matBean, EstoqueManualMaterialBean material, SaldoEstoqueCelulaBean saldo) {
        if (tipoFuncao == 0) {
            if (tipoOperacao == 3 || tipoOperacao == 0) {
                Double qtdeOriginal = matBean.getQuantidadeLotes(material.getCelula()) - matBean.getQuantidadeConsumidaLotes(material.getCelula());
                Double qtdeInserir = tipoOperacao == 0 ? (material.getQuantidade() == null ? 0.0 : material.getQuantidade()) : (material.getQuantidade() == null ? 0.0 : material.getQuantidade()) - saldo.getSaldo();
                SolicitarLoteMaterial lote = new SolicitarLoteMaterial(Laboratorio.getInstancia(), matBean.getCodigo(), matBean.getDescricao(), matBean.getUnidadeMedida().getCodigo(), matBean.getFichaTecnica(), matBean.getLotes(), 0, qtdeOriginal, qtdeInserir, null, qtdeOriginal, material.getCelula(), false, null, false);
                if (lote == null) return true;
                lote.setVisible(true);
                if (!lote.getOK()) return false;
                matBean.setLotes(lote.getLotes());
                Double qtde = 0.0;
                if (matBean.getLotes() != null && !matBean.getLotes().isEmpty()) {
                    for (int i = 0; i < lote.getLotes().size(); ++i) {
                        qtde = qtde + matBean.getLotes().get(i).getQuantidade();
                    }
                }
                matBean.setQuantidadeInformadaLotes(qtde);
                return true;
            } else {
                if (!this.possuiLoteCelulaMaterial(matBean, material)) return true;
                Double qtdeOriginal = matBean.getQuantidadeLotes(material.getCelula()) - matBean.getQuantidadeConsumidaOriginalLotes(material.getCelula());
                Double qtdeRemover = tipoOperacao == 1 || tipoOperacao == 4 ? (material.getQuantidade() == null ? 0.0 : material.getQuantidade()) : saldo.getSaldo() - (material.getQuantidade() == null ? 0.0 : material.getQuantidade());
                boolean isInutilizado = tipoOperacao == 4;
                SolicitarLoteMaterial lote = new SolicitarLoteMaterial(Laboratorio.getInstancia(), matBean.getCodigo(), matBean.getDescricao(), matBean.getUnidadeMedida().getCodigo(), matBean.getFichaTecnica(), matBean.getLotes(), 1, qtdeOriginal, null, qtdeRemover, qtdeOriginal, material.getCelula(), false, null, isInutilizado);
                if (lote == null) return true;
                lote.setVisible(true);
                if (!lote.getOK()) return false;
                matBean.setLotes(lote.getLotes());
                Double qtde = 0.0;
                for (int i = 0; i < lote.getLotes().size(); ++i) {
                    qtde = qtde + matBean.getLotes().get(i).getQuantidade();
                }
                matBean.setQuantidadeInformadaLotes(qtde);
            }
            return true;
        }
        for (int i = 0; i < this.modeloMaterial.getRowCount(); ++i) {
            EstoqueManualMaterialBean materialManual = (EstoqueManualMaterialBean)this.modeloMaterial.getValueAt(i, 6);
            MaterialBean beanMaterial = (MaterialBean)this.modeloMaterial.getValueAt(i, 8);
            try {
                saldo = (SaldoEstoqueCelulaBean)new SaldoEstoqueCelulaService().getSaldoAtualEstoqueMaterialCelula(Variaveis.filialPadrao, beanMaterial.getCodigo().toString(), materialManual.getCelula().getCodigo().toString());
            }
            catch (Exception e) {
                saldo = new SaldoEstoqueCelulaBean();
                saldo.setSaldo(0.0);
            }
            if (saldo == null) {
                saldo = new SaldoEstoqueCelulaBean();
                saldo.setSaldo(0.0);
            }
            if (materialManual.getTipoOperacao() == "I") {
                tipoOperacao = 0;
                beanMaterial.setPatrimonios(new ArrayList<MaterialPatrimonioBean>());
            } else if (materialManual.getTipoOperacao() == "B") {
                tipoOperacao = 1;
            } else if (materialManual.getTipoOperacao() == "N") {
                tipoOperacao = 4;
            } else if (materialManual.getTipoOperacao() == "A") {
                tipoOperacao = saldo == null || materialManual.getQuantidade() >= saldo.getSaldo() ? 3 : 2;
            }
            ArrayList<DadosPatrimonio> dadosPatrimonio = null;
            ArrayList<DadosPatrimonio> auxPatrimonio = null;
            boolean importado = (Boolean)(i >= 0 && this.modeloMaterial.getValueAt(i, 9) != null ? this.modeloMaterial.getValueAt(i, 9) : Boolean.valueOf(false));
            auxPatrimonio = tipoOperacao == 2 ? this.configurarPatrimonios(beanMaterial, saldo.getSaldo() - (materialManual.getQuantidade() == null ? 0.0 : materialManual.getQuantidade()), tipoOperacao, i) : (tipoOperacao == 3 ? this.configurarPatrimonios(beanMaterial, (materialManual.getQuantidade() == null ? 0.0 : materialManual.getQuantidade()) - saldo.getSaldo(), tipoOperacao, i) : this.configurarPatrimonios(beanMaterial, materialManual.getQuantidade() == null ? 0.0 : materialManual.getQuantidade(), tipoOperacao, i));
            if (beanMaterial.getSolicitarPatrimonio() != null && beanMaterial.getSolicitarPatrimonio().booleanValue() && auxPatrimonio == null) {
                return false;
            }
            if (auxPatrimonio != null) {
                dadosPatrimonio = auxPatrimonio;
            }
            if (!beanMaterial.getSolicitarLote().booleanValue() || !this.possuiLoteCelulaMaterial(beanMaterial, materialManual) || tipoOperacao != 2 && tipoOperacao != 1 && tipoOperacao != 4) continue;
            Double qtdeOriginal = beanMaterial.getQuantidadeLotes(materialManual.getCelula()) - beanMaterial.getQuantidadeConsumidaOriginalLotes(materialManual.getCelula());
            Double qtdeRemover = tipoOperacao == 1 || tipoOperacao == 4 ? (materialManual.getQuantidade() == null ? 0.0 : materialManual.getQuantidade()) : saldo.getSaldo() - (materialManual.getQuantidade() == null ? 0.0 : materialManual.getQuantidade());
            boolean isInutilizado = tipoOperacao == 4;
            SolicitarLoteMaterial lote = new SolicitarLoteMaterial(Laboratorio.getInstancia(), beanMaterial.getCodigo(), beanMaterial.getDescricao(), beanMaterial.getUnidadeMedida().getCodigo(), beanMaterial.getFichaTecnica(), beanMaterial.getLotes(), 1, qtdeOriginal, null, qtdeRemover, qtdeOriginal, materialManual.getCelula(), false, null, isInutilizado);
            if (lote == null) continue;
            lote.setVisible(true);
            if (!lote.getOK()) return false;
            beanMaterial.setLotes(lote.getLotes());
            Double qtde = 0.0;
            for (int j = 0; j < lote.getLotes().size(); ++j) {
                qtde = qtde + beanMaterial.getLotes().get(j).getQuantidade();
            }
            beanMaterial.setQuantidadeInformadaLotes(qtde);
            this.modeloMaterial.setValueAt(materialManual.getMaterial().getCodigo(), i, 0);
            this.modeloMaterial.setValueAt(materialManual.getMaterial().getDescricao(), i, 1);
            this.modeloMaterial.setValueAt(Tipos.getTipoOperacaoEstoque(materialManual.getTipoOperacao()), i, 2);
            this.modeloMaterial.setValueAt(Funcoes.formataDecimal(materialManual.getQuantidade()), i, 3);
            this.modeloMaterial.setValueAt(materialManual.getCelula(), i, 5);
            this.modeloMaterial.setValueAt(materialManual, i, 6);
            this.modeloMaterial.setValueAt(dadosPatrimonio, i, 7);
            this.modeloMaterial.setValueAt(beanMaterial, i, 8);
            this.modeloMaterial.setValueAt(importado, i, 9);
        }
        return true;
    }

    @Override
    public void pressioneiF2() {
        if (this.textCodigoMaterial.hasFocus()) {
            this.buttonBuscaMaterial.doClick();
        }
    }

    private Double verificaVazio(Double valor) {
        if (valor != null) {
            return valor;
        }
        return 0.0;
    }

    private void buscaCelulasCombo() {
        ArrayList<CelulaEstoqueBean> lista = null;
        try {
            lista = new CelulaEstoqueService().getTodasCelulasFilial(Variaveis.filialPadrao);
        }
        catch (ThreadDaoException e) {
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel buscar dados das c\u00e9lulas de estoque.", 2);
            return;
        }
        if (lista != null) {
            int posSelecionada = 0;
            String celulaEstoqueEstacao = ParametrosLocais.getParametro("celulaEstoque") == null ? "" : ParametrosLocais.getParametro("celulaEstoque");
            for (int i = 0; i < lista.size(); ++i) {
                CelulaEstoqueBean bean = lista.get(i);
                this.comboCelula.addItem(bean.toVO());
                if (Funcoes.textoVazio(celulaEstoqueEstacao)) {
                    if (!bean.getPadrao().booleanValue()) continue;
                    posSelecionada = i;
                    continue;
                }
                if (!bean.getCodigo().toString().equals(celulaEstoqueEstacao)) continue;
                posSelecionada = i;
            }
            this.comboCelula.setSelectedIndex(posSelecionada);
        }
    }

    private void limparCampos() {
        this.labelDescData.setText("");
        this.labelDescUsuario.setText("");
        this.textCodigoMaterial.setText("");
        this.labelDescricaoMaterial.setText("");
        this.textQuantidade.setText("");
        this.areaObservacao.setText("");
        if (!Funcoes.textoVazio(ParametrosUsuarios.getValor("ManutencaoEstoque.tipoOperacao"))) {
            String parametro = ParametrosUsuarios.getValor("ManutencaoEstoque.tipoOperacao");
            for (int i = 0; i < this.comboTipoOperacao.getItemCount(); ++i) {
                if (!this.comboTipoOperacao.getItemAt(i).toString().equals(parametro)) continue;
                this.comboTipoOperacao.setSelectedIndex(i);
                break;
            }
        } else if (this.comboTipoOperacao.getItemCount() > 0) {
            this.comboTipoOperacao.setSelectedIndex(0);
        }
        this.modeloMaterial.clear();
        this.materialAux = null;
        this.dataAux = null;
        this.usuarioAux = null;
        this.requisicaoAux = null;
        this.transferenciaAux = null;
        this.isAlterandoMaterial = false;
    }

    private void controlaCampos() {
        boolean habilitar = this.getStatus() == 2;
        this.textCodigoMaterial.setEnabled(habilitar && !this.isAlterandoMaterial);
        this.buttonBuscaMaterial.setEnabled(habilitar && !this.isAlterandoMaterial);
        this.textQuantidade.setEnabled(habilitar && this.materialAux != null);
        this.comboCelula.setEnabled(habilitar && this.materialAux != null && this.comboCelula.getItemCount() > 0 && !this.isAlterandoMaterial);
        this.comboTipoOperacao.setEnabled(habilitar && this.materialAux != null && !this.isAlterandoMaterial);
        this.buttonOK.setEnabled(habilitar && this.materialAux != null);
        this.buttonImportar.setEnabled(habilitar && this.requisicaoAux == null && this.transferenciaAux == null);
        this.tableMaterial.setEnabled(habilitar);
        this.areaObservacao.setEnabled(habilitar);
    }

    public static long getModuloAcesso() {
        return Long.parseLong("12003002000");
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    @Deprecated
    public void editar() {
    }

    @Override
    @Deprecated
    public void excluir() {
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        this.dataAux = new Date();
        this.labelDescData.setText(Funcoes.formataData("dd/MM/yyyy HH:mm:ss", this.dataAux));
        this.usuarioAux = new UsuarioVO();
        this.usuarioAux.setCodigo(Variaveis.login);
        this.labelDescUsuario.setText(this.usuarioAux.getCodigo());
        if (this.textCodigoMaterial.isFocusable() && this.textCodigoMaterial.isEnabled()) {
            this.textCodigoMaterial.grabFocus();
        }
    }

    protected String getCopiaFiliais() {
        return null;
    }

    @Override
    public void salvar() {
        EstoqueManualBean bean;
        EstoqueManualService service = new EstoqueManualService();
        MaterialBean auxMaterial = null;
        if (this.validaCampos() && (bean = this.getBeanPreenchido()) != null) {
            try {
                boolean contador = false;
                ArrayList<Integer> paraRemover = new ArrayList<Integer>();
                for (int i = 0; i < this.modeloMaterial.getRowCount(); ++i) {
                    boolean remover;
                    EstoqueManualMaterialBean estMatBean = (EstoqueManualMaterialBean)this.modeloMaterial.getValueAt(i, 6);
                    auxMaterial = (MaterialBean)this.modeloMaterial.getValueAt(i, 8);
                    SaldoEstoqueCelulaBean saldo = (SaldoEstoqueCelulaBean)new SaldoEstoqueCelulaService().getSaldoAtualEstoqueMaterialCelula(Variaveis.filialPadrao, auxMaterial.getCodigo().toString(), estMatBean.getCelula().getCodigo().toString());
                    double d = saldo != null ? saldo.getSaldo() : 0.0;
                    if (!(d < estMatBean.getQuantidade()) || !estMatBean.getTipoOperacao().equalsIgnoreCase("B") && !estMatBean.getTipoOperacao().equalsIgnoreCase("N")) continue;
                    boolean bl = remover = Funcoes.mensagem(null, "O material " + auxMaterial.getDescricao() + " (c\u00f3digo " + auxMaterial.getCodigo().toString() + ") n\u00e3o tem estoque suficiente,\ndeseja remover o material da listagem de baixa?", 4) == 0;
                    if (remover) {
                        paraRemover.add(i);
                        continue;
                    }
                    return;
                }
                if (paraRemover.size() > 0) {
                    int removidos = 0;
                    for (Integer i : paraRemover) {
                        this.modeloMaterial.removeLine(i - removidos++);
                    }
                }
                bean = this.getBeanPreenchido();
                ArrayList<MaterialBean> listaMateriais = new ArrayList<MaterialBean>();
                ArrayList<DadosPatrimonio> listaPatrimonios = new ArrayList<DadosPatrimonio>();
                for (int i = 0; i < this.modeloMaterial.getRowCount(); ++i) {
                    ArrayList listaPatrimoniosAux;
                    if (this.modeloMaterial.getValueAt(i, 8) != null) {
                        listaMateriais.add((MaterialBean)this.modeloMaterial.getValueAt(i, 8));
                    }
                    if ((listaPatrimoniosAux = (ArrayList)this.modeloMaterial.getValueAt(i, 7)) == null) continue;
                    for (DadosPatrimonio patrimonio : listaPatrimoniosAux) {
                        patrimonio.setMaterial((MaterialBean)this.modeloMaterial.getValueAt(i, 8));
                        listaPatrimonios.add(patrimonio);
                    }
                }
                service.gravaAutoCopiaSemCommit(bean, 0, Variaveis.filialPadrao, listaMateriais, listaPatrimonios);
                ParametrosUsuarios.setValor("ManutencaoEstoque.tipoOperacao", this.comboTipoOperacao.getSelectedItem().toString());
                Conexao.arquivaSQL();
                this.limparCampos();
                this.setStatus(1);
                this.controlaCampos();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                if (e instanceof SaldoInsuficienteException) {
                    Funcoes.mensagem(this, "N\u00e3o h\u00e1 saldo em estoque na c\u00e9lula suficiente para realizar o lan\u00e7amento de saida. ", 2);
                }
                Funcoes.mensagem(this, e.getMessage(), 2);
            }
        }
    }

    private EstoqueManualBean getBeanPreenchido() {
        EstoqueManualBean bean = new EstoqueManualBean();
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        bean.setFilial(filial);
        bean.setDataHora(this.dataAux);
        bean.setObservacao(this.areaObservacao.getText());
        bean.setUsuario(this.usuarioAux);
        bean.setRequisicaoEstoque(this.requisicaoAux != null ? (RequisicaoEstoqueVO)this.requisicaoAux.toVO() : null);
        ArrayList<EstoqueManualMaterialBean> listaMateriais = new ArrayList<EstoqueManualMaterialBean>();
        for (int i = 0; i < this.modeloMaterial.getRowCount(); ++i) {
            listaMateriais.add((EstoqueManualMaterialBean)this.modeloMaterial.getValueAt(i, 6));
        }
        bean.setMateriais(listaMateriais);
        return bean;
    }

    @Override
    public boolean validaCampos() {
        if (this.modeloMaterial.getRowCount() == 0) {
            Funcoes.mensagem(this, "Nenhuma opera\u00e7\u00e3o foi informada.", 2);
            ScreenUtil.requisitarFoco(this.textCodigoMaterial);
            return false;
        }
        for (int i = 0; i < this.modeloMaterial.getRowCount(); ++i) {
            EstoqueManualMaterialBean estMatBean = (EstoqueManualMaterialBean)this.modeloMaterial.getValueAt(i, 6);
            if (this.modeloMaterial.getValueAt(i, 3) == null) {
                Funcoes.mensagem(this, "A quantidade recebida de todos os materiais deve ser preenchida.", 2);
                return false;
            }
            Double qtde = Double.parseDouble(Funcoes.limpaDecimal((String)this.modeloMaterial.getValueAt(i, 3)));
            if (qtde <= 0.0 && !estMatBean.getTipoOperacao().equalsIgnoreCase("A")) {
                Funcoes.mensagem(this, "A quantidade recebida deve ser maior que zero.", 2);
                return false;
            }
            if (!(qtde < 0.0) || !estMatBean.getTipoOperacao().equalsIgnoreCase("A")) continue;
            Funcoes.mensagem(this, "A quantidade deve ser maior ou igual a zero.", 2);
            return false;
        }
        return true;
    }

    private JPanel montaPainelLegenda() {
        JPanel pnlLegenda = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        JPanel pnlCorLegenda = new JPanel();
        pnlCorLegenda.setPreferredSize(new Dimension(10, 10));
        pnlCorLegenda.setBackground(COR_SOLICITA_PATRIMONIO);
        pnlCorLegenda.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        pnlLegenda.add((Component)pnlCorLegenda, c);
        JLabel lblLegenda = new JLabel("Material solicita patrim\u00f4nio");
        Font font = new Font(lblLegenda.getFont().getName(), 0, 10);
        lblLegenda.setFont(font);
        ++c.gridx;
        pnlLegenda.add((Component)lblLegenda, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        pnlLegenda.add((Component)new JLabel(), c);
        return pnlLegenda;
    }

    private ArrayList<DadosPatrimonio> configurarPatrimonios(MaterialBean beanMat, Double quantidade, int tipoOperacao, int row) {
        ArrayList<DadosPatrimonio> dadosPatrimonio;
        block38: {
            if (beanMat == null || beanMat.getSolicitarPatrimonio() == null || !beanMat.getSolicitarPatrimonio().booleanValue()) {
                return null;
            }
            ArrayList<MaterialPatrimonioBean> patrimonios = beanMat.getPatrimonios();
            dadosPatrimonio = null;
            if ((tipoOperacao == 1 || tipoOperacao == 2 || tipoOperacao == 4) && (patrimonios == null || (double)patrimonios.size() < quantidade) && beanMat.getSolicitarPatrimonio() != null && beanMat.getSolicitarPatrimonio().booleanValue()) {
                if (patrimonios == null) {
                    Funcoes.mensagem(this, "N\u00e3o h\u00e1 patrim\u00f4nios definidos para o material.\nConfigure os patrim\u00f4nios do material no Cadastro de Material.", 2);
                } else {
                    Funcoes.mensagem(this, "A quantidade de patrim\u00f4nios definidos no Cadastro de Material\n\u00e9 inferior a " + Funcoes.formataDecimal(quantidade) + ".\nConfigure os patrim\u00f4nios em falta no Cadastro de Material.", 2);
                }
                this.textCodigoMaterial.selectAll();
                this.textCodigoMaterial.grabFocus();
                return null;
            }
            dadosPatrimonio = row >= 0 ? (ArrayList<DadosPatrimonio>)this.modeloMaterial.getValueAt(row, 7) : new ArrayList<DadosPatrimonio>();
            MaterialPatrimonioService servicePatrimonioMaterial = new MaterialPatrimonioService();
            if (!this.isAlterandoMaterial && patrimonios != null) {
                for (int i = 0; i < patrimonios.size(); ++i) {
                    MaterialPatrimonioBean patrimonioBean = patrimonios.get(i);
                    DadosPatrimonio auxAdiciona = null;
                    try {
                        auxAdiciona = new DadosPatrimonio(beanMat, patrimonioBean.getPatrimonio(), patrimonioBean.getSerie(), patrimonioBean.getNumeroNotaFiscal() == null ? "" : patrimonioBean.getNumeroNotaFiscal().toString(), patrimonioBean.getSetor(), servicePatrimonioMaterial.podeAlterarPatrimonioMaterial(Variaveis.filialPadrao, beanMat.getCodigo().toString(), patrimonioBean.getPatrimonio()), false);
                    }
                    catch (Exception e) {
                        continue;
                    }
                    dadosPatrimonio.add(auxAdiciona);
                }
            }
            Patrimonio p = null;
            if (tipoOperacao == 1 || tipoOperacao == 2 || tipoOperacao == 4) {
                p = Patrimonio.novaInstancia(this.getTopLevelAncestor(), true);
                if (p != null) {
                    if (tipoOperacao == 2) {
                        p.setTitle("Selecione o(s) " + quantidade + " patrim\u00f4nio(s) a serem removido(s)");
                    } else {
                        p.setTitle("Selecione os patrim\u00f4nios a serem removidos");
                    }
                }
            } else {
                p = Patrimonio.novaInstancia(this.getTopLevelAncestor(), false);
                if (tipoOperacao == 3) {
                    p.setTitle("Insira o(s) " + quantidade + " novo(s) patrim\u00f4nio(s)");
                } else {
                    p.setTitle("Insira os novos patrim\u00f4nios");
                }
            }
            if (p != null) {
                block37: {
                    p.setUsuarioPodeCancelar(true);
                    while (true) {
                        int qtdeAnt = dadosPatrimonio.size();
                        p.setPatrimonios(dadosPatrimonio.size() == 0 ? null : dadosPatrimonio);
                        p.setVisible(true);
                        if (!p.getOK()) break block37;
                        dadosPatrimonio = p.getPatrimonios();
                        int qtde = 0;
                        for (int i = 0; i < dadosPatrimonio.size(); ++i) {
                            if (!dadosPatrimonio.get(i).isSelecionado()) continue;
                            ++qtde;
                        }
                        if ((double)qtde < quantidade && (tipoOperacao == 1 || tipoOperacao == 2 || tipoOperacao == 4)) {
                            Funcoes.mensagem(this, "A quantidade de patrim\u00f4nios selecionada \u00e9 inferior \u00e0 quantidade a ser removida.\nDeve-se selecionar " + Funcoes.formataDecimal(quantidade) + " patrim\u00f4nio(s).", 2);
                            continue;
                        }
                        if ((double)qtde > quantidade && (tipoOperacao == 1 || tipoOperacao == 2 || tipoOperacao == 4)) {
                            Funcoes.mensagem(this, "A quantidade de patrim\u00f4nios selecionada \u00e9 superior \u00e0 quantidade a ser removida.\nDeve-se selecionar apenas " + Funcoes.formataDecimal(quantidade) + " patrim\u00f4nio(s).", 2);
                            continue;
                        }
                        if ((double)dadosPatrimonio.size() < quantidade && tipoOperacao == 0) {
                            Funcoes.mensagem(this, "A quantidade de patrim\u00f4nios informada \u00e9 inferior \u00e0 quantidade a ser adicionada.\nDeve-se informar " + Funcoes.formataDecimal(quantidade) + " patrim\u00f4nio(s).", 2);
                            continue;
                        }
                        if ((double)dadosPatrimonio.size() < quantidade + (double)qtdeAnt && tipoOperacao == 3) {
                            Funcoes.mensagem(this, "A quantidade de patrim\u00f4nios informada \u00e9 inferior \u00e0 quantidade a ser adicionada.\nDeve-se informar " + Funcoes.formataDecimal(quantidade) + " patrim\u00f4nio(s).", 2);
                            continue;
                        }
                        if ((double)dadosPatrimonio.size() > quantidade && tipoOperacao == 0) {
                            Funcoes.mensagem(this, "A quantidade de patrim\u00f4nios informada \u00e9 superior \u00e0 quantidade a ser adicionada.\nDeve-se informar apenas " + Funcoes.formataDecimal(quantidade) + " patrim\u00f4nio(s).", 2);
                            continue;
                        }
                        if (!((double)dadosPatrimonio.size() > quantidade + (double)qtdeAnt) || tipoOperacao != 3) break;
                        Funcoes.mensagem(this, "A quantidade de patrim\u00f4nios informada \u00e9 superior \u00e0 quantidade a ser adicionada.\nDeve-se informar apenas " + Funcoes.formataDecimal(quantidade) + " patrim\u00f4nio(s).", 2);
                    }
                    ArrayList<MaterialPatrimonioBean> listaPatrimonios = new ArrayList<MaterialPatrimonioBean>();
                    if (patrimonios != null) {
                        for (int i = 0; i < dadosPatrimonio.size(); ++i) {
                            DadosPatrimonio dados = dadosPatrimonio.get(i);
                            MaterialPatrimonioBean patrimonio = new MaterialPatrimonioBean();
                            patrimonio.setFilial(beanMat.getFilial());
                            patrimonio.setMaterial((MaterialVO)beanMat.toVO());
                            patrimonio.setNumeroNotaFiscal(Funcoes.textoVazio(dados.getNotaFiscal()) ? null : Integer.valueOf(Integer.parseInt(dados.getNotaFiscal())));
                            patrimonio.setSerie(dados.getSerie());
                            patrimonio.setPatrimonio(dados.getPatrimonio());
                            patrimonio.setSetor(dados.getSetor());
                            if ((tipoOperacao == 2 || tipoOperacao == 1 || tipoOperacao == 4) && dados.isSelecionado()) {
                                patrimonio.setInutilizado(true);
                            } else {
                                patrimonio.setInutilizado(false);
                            }
                            listaPatrimonios.add(patrimonio);
                        }
                    }
                    if (listaPatrimonios.size() > 0) {
                        if (tipoOperacao == 0) {
                            MaterialBean auxMat = null;
                            try {
                                auxMat = (MaterialBean)new MaterialService().getTodos(beanMat.getFilial().getCodigo().toString(), beanMat.getCodigo().toString(), null, null);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (auxMat != null && auxMat.getPatrimonios() != null) {
                                auxMat.getPatrimonios().addAll(listaPatrimonios);
                                beanMat.setPatrimonios(auxMat.getPatrimonios());
                            } else {
                                beanMat.setPatrimonios(listaPatrimonios);
                            }
                        } else {
                            beanMat.setPatrimonios(listaPatrimonios);
                        }
                    }
                    break block38;
                }
                if (!this.isAlterandoMaterial) {
                    if (tipoOperacao == 0 || tipoOperacao == 3) {
                        Funcoes.mensagem(this, "N\u00e3o \u00e9 poss\u00edvel adicionar o(s) material(is) sem informar o(s) patrim\u00f4nio(s).", 2);
                    } else {
                        Funcoes.mensagem(this, "N\u00e3o \u00e9 poss\u00edvel remover o(s) material(is) sem selecionar o(s) patrim\u00f4nio(s).", 2);
                    }
                }
                return null;
            }
        }
        return dadosPatrimonio;
    }

    private void alterarMaterial() {
        int row = this.tableMaterial.getSelectedRow();
        if (row >= 0) {
            EstoqueManualMaterialBean material = (EstoqueManualMaterialBean)this.modeloMaterial.getValueAt(row, 6);
            CelulaEstoqueVO celulaMaterial = (CelulaEstoqueVO)this.modeloMaterial.getValueAt(row, 5);
            MaterialBean beanMaterial = (MaterialBean)this.modeloMaterial.getValueAt(row, 8);
            this.isAlterandoMaterial = true;
            this.materialAux = beanMaterial;
            this.textCodigoMaterial.setText(String.valueOf(material.getMaterial().getCodigo()));
            this.labelDescricaoMaterial.setText(material.getMaterial().getDescricao());
            this.textQuantidade.setText(Funcoes.formataDecimal(material.getQuantidade()));
            this.comboCelula.setSelectedItem(celulaMaterial);
            this.comboTipoOperacao.setSelectedItem(Tipos.getTipoOperacaoEstoque(material.getTipoOperacao()));
            this.controlaCampos();
            ScreenUtil.requisitarFoco(this.comboTipoOperacao);
        }
    }

    private void abrirPopup() {
        if (this.tableMaterial.getSelectedRowCount() > 0) {
            int x = this.tableMaterial.getWidth() / 2 - this.menuMaterial.getWidth() / 2;
            int y = this.tableMaterial.getSelectedRow() * this.tableMaterial.getRowHeight() + this.tableMaterial.getRowHeight() / 2;
            this.menuMaterial.show(this.tableMaterial, x, y);
        }
    }

    @Override
    public String getRetornoParaPesquisa() {
        return "";
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return null;
    }

    class EstoqueRenderer
    extends DefaultTableCellRenderer {
        @Override
        public synchronized Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            MaterialVO material;
            Component c = super.getTableCellRendererComponent(table, value, selected, focused, row, column);
            this.setValue(value);
            if (selected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            EstoqueManualMaterialBean estoque = (EstoqueManualMaterialBean)ManutencaoEstoque.this.modeloMaterial.getValueAt(row, 6);
            if (estoque != null && (material = estoque.getMaterial()) != null && material.getSolicitarPatrimonio() != null && material.getSolicitarPatrimonio().booleanValue()) {
                c.setBackground(COR_SOLICITA_PATRIMONIO);
                if (selected && c.getBackground() != table.getSelectionBackground()) {
                    c.setBackground(ScreenUtil.escurecerCor(c.getBackground(), 30));
                }
            }
            if (focused) {
                Border border = selected ? UIManager.getBorder("Table.focusSelectedCellHighlightBorder") : UIManager.getBorder("Table.focusCellHighlightBorder");
                ((JComponent)c).setBorder(border);
                if (!selected && table.isCellEditable(row, column)) {
                    Color col = UIManager.getColor("Table.focusCellForeground");
                    if (col != null) {
                        c.setForeground(col);
                    }
                    if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                        c.setBackground(col);
                    }
                }
            } else {
                ((JComponent)c).setBorder(noFocusBorder);
            }
            return c;
        }
    }
}

