/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.estoque.almoxarifado;

import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.estoque.CelulaEstoqueVO;
import jalis.service.estoque.CelulaEstoqueService;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

class JanelaCelulaEstoque
extends JDialog
implements ActionListener {
    JLabel labelCelulas = new JLabel("Selecione a c\u00e9lula de estoque");
    JButton buttonOk = new JButton("Ok");
    JComboBox comboCelulas = null;
    CelulaEstoqueVO retorno = null;

    public JanelaCelulaEstoque(Window owner) {
        super(owner);
        this.setModal(true);
        this.setTitle("C\u00e9lulas de estoque");
        this.setResizable(false);
        this.setSize(new Dimension(300, 110));
        this.carregaCelulasEstoque();
        this.montaTela();
        Funcoes.montaEnter((JComponent)this.getContentPane());
        ScreenUtil.centralizar(this);
        ScreenUtil.requisitarFoco(this.comboCelulas);
    }

    private void montaTela() {
        JPanel panel = (JPanel)this.getContentPane();
        panel.setLayout(new BorderLayout());
        this.buttonOk.setMnemonic('O');
        JPanel panelBotao = new JPanel(new FlowLayout(2));
        panelBotao.add(this.buttonOk);
        this.comboCelulas.setPreferredSize(new Dimension(20, 20));
        this.comboCelulas.setMinimumSize(new Dimension(20, 20));
        JPanel panelCentral = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        panelCentral.add((Component)this.labelCelulas, c);
        ++c.gridy;
        panelCentral.add((Component)this.comboCelulas, c);
        panel.add((Component)panelCentral, "Center");
        panel.add((Component)panelBotao, "South");
        this.buttonOk.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOk) {
            this.retorno = (CelulaEstoqueVO)this.comboCelulas.getSelectedItem();
            this.setVisible(false);
        }
    }

    public CelulaEstoqueVO getOk() {
        return this.retorno;
    }

    private void carregaCelulasEstoque() {
        ArrayList<CelulaEstoqueVO> celulas = null;
        try {
            celulas = new CelulaEstoqueService().getTodasCelulasFilialVO(Variaveis.filialPadrao);
        }
        catch (ThreadDaoException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel carregar dados das c\u00e9lulas de estoque.\n" + e.getMessage(), e.getStackTrace());
        }
        this.comboCelulas = celulas != null ? new JComboBox<Object>(celulas.toArray()) : new JComboBox();
    }
}

