/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.estoque.almoxarifado;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadraoBean;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.estoque.almoxarifado.PreencherDadosEtiquetaAvulsa;
import jalis.laboratorio.estoque.almoxarifado.SelecionarLote;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.impressao.ImprimirEtiquetaEstoque;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.estoque.NotaFiscalMaterialBean;
import jalis.model.bean.estoque.PedidoBean;
import jalis.model.bean.estoque.PedidoMaterialBean;
import jalis.model.bean.financeiro.NotaFiscalBean;
import jalis.model.dao.estoque.PedidoDao;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.estoque.MaterialVO;
import jalis.model.vo.estoque.PedidoVO;
import jalis.model.vo.financeiro.NotaFiscalVO;
import jalis.service.estoque.MaterialService;
import jalis.service.estoque.PedidoService;
import jalis.service.financeiro.NotaFiscalService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

public class EtiquetaEstoque
extends FrmCadPadraoBean
implements ActionListener {
    private static final int POSICAO_COD_MATERIAL = 0;
    private static final int POSICAO_QTD_ETIQUETA = 2;
    private static final int POSICAO_OBJETO_TABELA = 3;
    private JButton buttonBuscarMaterial = ComponenteFactory.novoJButton(this, true);
    private JButton buttonAddMaterial = ComponenteFactory.novoJButton("OK", 'O', this);
    private JButton buttonImprimir = ComponenteFactory.novoJButton("Imprimir", 'P', this);
    private JButton buttonImportar = ComponenteFactory.novoJButton("Importar \u25bc", 'M', this);
    private JButton buttonAvulsa = ComponenteFactory.novoJButton("Etiqueta avulsa", 'l', this);
    private TTextField textCodMaterial = new TTextField(15, 1);
    private TTextField textQuantidade = new TTextField(12, 2);
    private JLabel labelMateiral = ComponenteFactory.novoJLabel("Material", 'A', this.textCodMaterial);
    private JLabel labelQuantidade = ComponenteFactory.novoJLabel("Quantidade", 'Q', this.textQuantidade);
    private JLabel labelVlrDescMaterial = new JLabel();
    private JPanel painelOpcoes = new JPanel(new FlowLayout(0));
    private JPanel painelCrud = new JPanel(new FlowLayout());
    private final JPopupMenu popMenu = new JPopupMenu();
    private final JMenuItem importarPedido = ComponenteFactory.novoJMenuItem("Pedido", 'P', (ActionListener)this);
    private final JMenuItem importarNota = ComponenteFactory.novoJMenuItem("Nota", 'N', (ActionListener)this);
    private ModeloGridTable modeloMaterial = new ModeloGridTable(new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Quantidade"});
    private JTable tableMaterial = new JTable(this.modeloMaterial);
    private JScrollPane scrollPaneMaterial = new JScrollPane(this.tableMaterial);
    private MaterialVO materialVO = null;
    private PedidoVO pedidoVO = new PedidoVO();
    private NotaFiscalVO notaFiscalVO = new NotaFiscalVO();
    private MaterialService materialService = new MaterialService();
    private NotaFiscalService notaFiscalService = new NotaFiscalService();
    private PedidoService pedidoService = new PedidoService();
    private ObjetoTabela objetoTabela = null;
    private ImprimirEtiquetaEstoque imprimirEtiquetaEstoque = new ImprimirEtiquetaEstoque();

    public EtiquetaEstoque() {
        try {
            this.jbInit();
            this.controlaCampos();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
    }

    private void jbInit() {
        ScreenUtil.setBorda(new JComponent[]{this.labelVlrDescMaterial}, new TitledBorder(""));
        this.modeloMaterial.setColumnSize(new int[]{80, 0, 80}, this.tableMaterial);
        this.tableMaterial.getTableHeader().addMouseListener(this.modeloMaterial);
        this.painelBotoes.removeAll();
        this.painelBotoes.setLayout(new BorderLayout());
        this.painelOpcoes.add(this.buttonImportar);
        this.painelOpcoes.add(this.buttonAvulsa);
        this.painelBotoes.add((Component)this.painelOpcoes, "West");
        this.painelBotoes.add((Component)this.painelCrud, "East");
        this.painelCrud.add(this.botaoNovo);
        this.painelCrud.add(this.buttonImprimir);
        this.painelCrud.add(this.botaoCancelar);
        this.painelCrud.add(this.botaoFechar);
        this.popMenu.add(this.importarNota);
        this.popMenu.add(this.importarPedido);
        this.setLabelFormulario("Impress\u00e3o de etiquetas");
        this.setLabelDescricao("Impress\u00e3o de etiquetas de estoque para identifica\u00e7\u00e3o de material");
        this.setIcone(ImagemUtils.carregaImagemJalis("estoque/impressao_etiquetas.jpg"));
        GridBagConstraints bagConstraints = new GridBagConstraints();
        bagConstraints.fill = 17;
        bagConstraints.anchor = 17;
        bagConstraints.insets = new Insets(0, 0, 0, 0);
        bagConstraints.gridx = 0;
        bagConstraints.gridy = 0;
        bagConstraints.weightx = 0.0;
        bagConstraints.weighty = 0.0;
        this.painelCentral.setLayout(new GridBagLayout());
        this.painelCentral.add((Component)this.labelMateiral, bagConstraints);
        ++bagConstraints.gridy;
        this.textCodMaterial.setMinimumSize(new Dimension(70, 21));
        this.textCodMaterial.setPreferredSize(new Dimension(70, 21));
        this.painelCentral.add((Component)this.textCodMaterial, bagConstraints);
        ++bagConstraints.gridx;
        this.buttonBuscarMaterial.setPreferredSize(new Dimension(20, 20));
        this.buttonBuscarMaterial.setMinimumSize(new Dimension(20, 20));
        this.painelCentral.add((Component)this.buttonBuscarMaterial, bagConstraints);
        ++bagConstraints.gridx;
        bagConstraints.fill = 2;
        bagConstraints.weightx = 1.0;
        bagConstraints.insets = new Insets(0, 1, 0, 0);
        this.labelVlrDescMaterial.setPreferredSize(new Dimension(20, 20));
        this.labelVlrDescMaterial.setMinimumSize(new Dimension(20, 20));
        this.painelCentral.add((Component)this.labelVlrDescMaterial, bagConstraints);
        bagConstraints.insets = new Insets(0, 0, 0, 0);
        bagConstraints.fill = 17;
        bagConstraints.weightx = 0.0;
        ++bagConstraints.gridx;
        bagConstraints.gridy += -1;
        this.painelCentral.add((Component)this.labelQuantidade, bagConstraints);
        ++bagConstraints.gridy;
        bagConstraints.insets = new Insets(0, 1, 0, 0);
        this.textQuantidade.setMinimumSize(new Dimension(100, 21));
        this.textQuantidade.setPreferredSize(new Dimension(100, 21));
        this.painelCentral.add((Component)this.textQuantidade, bagConstraints);
        bagConstraints.insets = new Insets(0, 0, 0, 0);
        ++bagConstraints.gridx;
        this.buttonAddMaterial.setMinimumSize(new Dimension(40, 20));
        this.buttonAddMaterial.setPreferredSize(new Dimension(40, 20));
        this.painelCentral.add((Component)this.buttonAddMaterial, bagConstraints);
        bagConstraints.gridx = 0;
        ++bagConstraints.gridy;
        bagConstraints.fill = 1;
        bagConstraints.weightx = 1.0;
        bagConstraints.weighty = 1.0;
        bagConstraints.gridwidth = 5;
        this.painelCentral.add((Component)this.scrollPaneMaterial, bagConstraints);
        this.tableMaterial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 || e.getKeyCode() == 32) {
                    EtiquetaEstoque.this.editarMaterial();
                }
            }
        });
        this.tableMaterial.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    EtiquetaEstoque.this.editarMaterial();
                }
            }
        });
        this.tableMaterial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int resp;
                int row;
                if (e.getKeyCode() == 127 && (row = ((JTable)e.getSource()).getSelectedRow()) >= 0 && (resp = Funcoes.mensagem(EtiquetaEstoque.this.painelCentral, "Deseja remover o material da composi\u00e7\u00e3o ?", 4)) == 0) {
                    EtiquetaEstoque.this.modeloMaterial.removeLine(row);
                }
            }
        });
        this.textCodMaterial.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (EtiquetaEstoque.this.objetoTabela != null && EtiquetaEstoque.this.objetoTabela.isEditando() && !Funcoes.textoVazio(EtiquetaEstoque.this.textCodMaterial) && EtiquetaEstoque.this.textCodMaterial.getText().equals(EtiquetaEstoque.this.objetoTabela.getMaterialVO().getCodigo().toString())) {
                    return;
                }
                try {
                    if (!Funcoes.textoVazio(EtiquetaEstoque.this.textCodMaterial.getText())) {
                        EtiquetaEstoque.this.materialVO = (MaterialVO)EtiquetaEstoque.this.materialService.getAtivoVO(Variaveis.filialPadrao, EtiquetaEstoque.this.textCodMaterial.getText().toString());
                        if (EtiquetaEstoque.this.materialVO != null) {
                            EtiquetaEstoque.this.textCodMaterial.setText(EtiquetaEstoque.this.materialVO.getCodigo().toString());
                            EtiquetaEstoque.this.labelVlrDescMaterial.setText(EtiquetaEstoque.this.materialVO.getDescricao());
                        } else {
                            EtiquetaEstoque.this.textCodMaterial.selectAll();
                            EtiquetaEstoque.this.labelVlrDescMaterial.setText("N\u00e3o cadastrado");
                            EtiquetaEstoque.this.textCodMaterial.grabFocus();
                        }
                    }
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(EtiquetaEstoque.this.getTopLevelAncestor(), "N\u00e3o foi poss\u00edvel buscar material.", ex.getStackTrace());
                }
            }
        });
        this.textCodMaterial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    EtiquetaEstoque.this.buttonBuscarMaterial.doClick();
                }
            }
        });
        ScreenUtil.requisitarFoco(this.botaoNovo);
    }

    private void editarMaterial() {
        int linha = this.tableMaterial.getSelectedRow();
        if (linha > -1) {
            this.objetoTabela = (ObjetoTabela)this.modeloMaterial.getValueAt(linha, 3);
            if (this.objetoTabela != null) {
                this.textCodMaterial.setText(this.objetoTabela.getMaterialVO().getCodigo().toString());
                this.labelVlrDescMaterial.setText(this.objetoTabela.getMaterialVO().getDescricao());
                this.textQuantidade.setText(Funcoes.formataDecimal(this.objetoTabela.getQuantidade()));
                this.objetoTabela.setEditando(true);
                this.materialVO = this.objetoTabela.getMaterialVO();
                ScreenUtil.requisitarFoco(this.textCodMaterial);
            }
        }
    }

    @Override
    public void fechar() {
        this.setVisible(false);
    }

    @Override
    public void novo() {
        super.novo();
        this.botaoFechar.setEnabled(true);
        this.textCodMaterial.grabFocus();
        this.controlaCampos();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.buttonImprimir)) {
            if (this.modeloMaterial.getRowCount() <= 0) {
                Funcoes.mensagem(this, "Informe os materiais para impress\u00e3o das etiquetas.", 2);
                ScreenUtil.requisitarFoco(this.textCodMaterial);
                return;
            }
            SplashMensagem splashMensagem = SplashMensagem.getInstancia(this);
            splashMensagem.mostrar("Imprimindo");
            this.imprimir();
            this.setStatus(1);
            this.controlaCampos();
            this.botaoFechar.setEnabled(true);
            splashMensagem.apagar();
        } else if (e.getSource() == this.buttonImportar) {
            this.popMenu.show(this.painelOpcoes, this.buttonImportar.getX(), this.buttonImportar.getY() * -2 - this.buttonImportar.getHeight());
        } else if (e.getSource() == this.buttonAvulsa) {
            PreencherDadosEtiquetaAvulsa pd = new PreencherDadosEtiquetaAvulsa((Frame)Laboratorio.getInstancia(), "Preencher dados");
            pd.setCamposPossiveis(Impressao.CAMPOS_ETIQUETA_ESTOQUE, PreencherDadosEtiquetaAvulsa.getLayoutEtiqueta(Conexao.getStatement(), Variaveis.filialPadrao));
            pd.setLocationRelativeTo(Laboratorio.getInstancia());
            pd.setModal(true);
            pd.setVisible(true);
            if (pd.getOK()) {
                FilialVO f = new FilialVO();
                f.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
                MaterialVO m = new MaterialVO();
                m.setFilial(f);
                m.setCodigo(new Double(Math.random()).intValue() * -1);
                m.setDescricao("Etiqueta avulsa");
                ObjetoTabela o = new ObjetoTabela(m, new Double(pd.getQuantidade()), "M", null, null, "", null, null);
                o.setModeloDadosPreenchido(pd.getModeloDados());
                this.modeloMaterial.addLine(new Object[]{o.getMaterialVO().getCodigo(), o.getMaterialVO().getDescricao(), Funcoes.formataDecimal(o.getQuantidade()), o});
            }
        } else if (e.getSource() == this.importarNota) {
            this.pesquisarNotaFiscal();
        } else if (e.getSource() == this.importarPedido) {
            this.pesquisarPedido();
        } else if (e.getSource() == this.buttonBuscarMaterial) {
            this.pesquisarMaterial();
        } else if (e.getSource() == this.buttonAddMaterial) {
            if (this.materialVO == null) {
                Funcoes.mensagem(this.getTopLevelAncestor(), "Informe o material.", 2);
                ScreenUtil.requisitarFoco(this.textCodMaterial);
                return;
            }
            if (Funcoes.textoVazio(this.textQuantidade)) {
                Funcoes.mensagem(this.getTopLevelAncestor(), "Informe a quantidade de etiquetas.", 2);
                ScreenUtil.requisitarFoco(this.textQuantidade);
                return;
            }
            String lote = "";
            Date dataLote = null;
            Date validadeLote = null;
            if (this.materialVO.getSolicitarLote().booleanValue()) {
                SelecionarLote sl = new SelecionarLote(Laboratorio.getInstancia());
                sl.setLocationRelativeTo(Laboratorio.getInstancia());
                sl.setMaterial(this.materialVO.getFilial().getCodigo().toString(), this.materialVO.getCodigo().toString());
                sl.setVisible(true);
                if (sl.getOK()) {
                    lote = sl.getCodigoLoteSelecionado();
                    dataLote = sl.getDataLoteSelecionado();
                    validadeLote = sl.getValidadeLoteSelecionado();
                } else {
                    Funcoes.mensagem(this, "O lote deve ser selecionado", 1);
                    this.textCodMaterial.clear();
                    this.textQuantidade.clear();
                    this.labelVlrDescMaterial.setText("");
                    this.textCodMaterial.grabFocus();
                    return;
                }
            }
            if (this.objetoTabela != null && this.objetoTabela.isEditando() && !Funcoes.textoVazio(this.textCodMaterial) && !this.textCodMaterial.getText().equals(this.objetoTabela.getMaterialVO().getCodigo().toString()) && !this.materialAdicionado()) {
                this.objetoTabela.setQuantidade(Double.valueOf(this.textQuantidade.getText()));
                this.objetoTabela.setMaterialVO(this.materialVO);
                this.objetoTabela.setNotaFiscalBean(this.getUltimaNotaFiscal(this.materialVO));
                this.objetoTabela.setPedidoBean(this.getUltimoPedido(this.materialVO));
                this.objetoTabela.setDataLote(dataLote);
                this.objetoTabela.setValidadeLote(validadeLote);
                this.objetoTabela.setLote(lote);
            } else if (this.objetoTabela == null || !this.objetoTabela.isEditando()) {
                this.objetoTabela = new ObjetoTabela(this.materialVO, Double.valueOf(this.textQuantidade.getText()), "M", null, null, lote, dataLote, validadeLote);
                this.objetoTabela.setNotaFiscalBean(this.getUltimaNotaFiscal(this.materialVO));
                this.objetoTabela.setPedidoBean(this.getUltimoPedido(this.materialVO));
            }
            this.addMaterial(false);
            this.textCodMaterial.clear();
            this.textQuantidade.clear();
            this.labelVlrDescMaterial.setText("");
            this.textCodMaterial.grabFocus();
        }
    }

    private PedidoBean getUltimoPedido(MaterialVO materialVO) {
        block5: {
            StringBuilder sql = new StringBuilder();
            sql.append(" select max(p.ped_codigo) as codPedido from pedido p inner join ");
            sql.append("        pedidomaterial pm on p.ped_codigo = pm.ped_codigo and p.fil_codigo = pm.fil_codigo ");
            sql.append("  where pm.mat_codigo = ");
            sql.append(materialVO.getCodigo());
            sql.append("    and p.usr_codexclusao is null and p. ped_dataexclusao is null ");
            sql.append("    and p.fil_codigo = ").append(Variaveis.filialPadrao);
            try {
                ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), sql.toString());
                if (!rs.next()) break block5;
                try {
                    Set set = this.pedidoService.load(" where ped_codigo = " + rs.getInt("codPedido") + " and fil_codigo = " + Variaveis.filialPadrao);
                    if (set != null && !set.isEmpty()) {
                        return (PedidoBean)set.toArray()[0];
                    }
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), "N\u00e3o foi poss\u00edvel buscar pedido.", e.getStackTrace());
                }
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), "N\u00e3o foi poss\u00edvel buscar pedido.", e.getStackTrace());
            }
        }
        return null;
    }

    private NotaFiscalBean getUltimaNotaFiscal(MaterialVO materialVO) {
        block5: {
            StringBuilder sql = new StringBuilder();
            sql.append(" select max(nf.nfi_codigo) as codNotaFiscal from notafiscal nf inner join notafiscalmaterial nfm  ");
            sql.append("     on nfm.nfi_codigo = nf.nfi_codigo and nfm.fil_codigo = nf.fil_codigo ");
            sql.append("  where nfm.mat_codigo = ").append(materialVO.getCodigo()).append(" and nf.fil_codigo = ").append(Variaveis.filialPadrao);
            sql.append("    and nf.usr_codcancelada is null and nf.nfi_datahoracancelada is null and nf.nfi_tipo = '").append("E").append("'");
            try {
                ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), sql.toString());
                if (!rs.next()) break block5;
                try {
                    Set set = this.notaFiscalService.load(" where fil_codigo = " + Variaveis.filialPadrao + " and nfi_codigo = " + rs.getInt("codNotaFiscal"));
                    if (set != null && !set.isEmpty()) {
                        return (NotaFiscalBean)set.toArray()[0];
                    }
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), "N\u00e3o foi poss\u00edvel buscar nota.", e.getStackTrace());
                }
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), "N\u00e3o foi poss\u00edvel buscar nota.", e.getStackTrace());
            }
        }
        return null;
    }

    private void imprimir() {
        try {
            this.imprimirEtiquetaEstoque.imprimir(this.getListaObjetoTabela());
            this.limparCampos();
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), "N\u00e3o foi poss\u00edvel imprimir etiquetas de estoque.", e.getStackTrace());
        }
    }

    private void pesquisarPedido() {
        try {
            String codigo = null;
            boolean adicionou = false;
            codigo = ParametrosGerais.getTipoAutorizacaoCompra().equalsIgnoreCase("P") || ParametrosGerais.getTipoAutorizacaoCompra().equalsIgnoreCase("E") ? this.pedidoService.pesquisaPedidoAutorizadoNaoConferidoVO(this.getTopLevelAncestor(), null) : this.pedidoService.pesquisaPedidoDisponivelNaoConferidoVO(this.getTopLevelAncestor(), null);
            if (!Funcoes.textoVazio(codigo)) {
                PedidoBean pedido = (PedidoBean)new PedidoDao().getBean(Variaveis.filialPadrao, codigo);
                for (int linha = 0; linha < this.modeloMaterial.getRowCount(); ++linha) {
                    ObjetoTabela ob = (ObjetoTabela)this.modeloMaterial.getValueAt(linha, 3);
                    if (!ob.getTipo().equals("N")) continue;
                    Funcoes.mensagem(this.getTopLevelAncestor(), "N\u00e3o \u00e9 poss\u00edvel importar materiais de notas e pedidos juntos.", 2);
                    return;
                }
                if (pedido != null && pedido.getMateriais() != null) {
                    for (PedidoMaterialBean pedidoMaterialBean : pedido.getMateriais()) {
                        this.materialVO = (MaterialVO)pedidoMaterialBean.getMaterial().toVO();
                        this.objetoTabela = new ObjetoTabela(this.materialVO, pedidoMaterialBean.getQuantidade(), "P", null, pedido, "", null, null);
                        adicionou = this.addMaterial(true);
                    }
                    if (!pedido.getMateriais().isEmpty() && adicionou) {
                        this.bloquearImportacao(false);
                    }
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), "N\u00e3o foi poss\u00edvel carregar dados do pedido de compra.\n", e.getStackTrace());
            return;
        }
    }

    private void pesquisarNotaFiscal() {
        try {
            NotaFiscalBean nota;
            Hashtable resultado = null;
            boolean adicionou = false;
            resultado = ParametrosGerais.getTipoAutorizacaoCompra().equalsIgnoreCase("F") || ParametrosGerais.getTipoAutorizacaoCompra().equalsIgnoreCase("E") ? this.notaFiscalService.pesquisaNotaEntradaAutorizadaNaoConferidaVO(Laboratorio.getInstancia(), new NotaFiscalVO(), "Pesquisando Notas Fiscais de Entrada (autorizadas)") : this.notaFiscalService.pesquisaNotaEntradaVO(Laboratorio.getInstancia(), new NotaFiscalVO(), "Pesquisando Notas Fiscais de Entrada");
            if (resultado != null && resultado.size() > 0 && (nota = (NotaFiscalBean)this.notaFiscalService.get(Variaveis.filialPadrao, resultado.get("nfi_codigo").toString())) != null && nota.getMateriais() != null) {
                for (int linha = 0; linha < this.modeloMaterial.getRowCount(); ++linha) {
                    ObjetoTabela ob = (ObjetoTabela)this.modeloMaterial.getValueAt(linha, 3);
                    if (!ob.getTipo().equals("P")) continue;
                    Funcoes.mensagem(this.getTopLevelAncestor(), "N\u00e3o \u00e9 poss\u00edvel importar materiais de pedidos e notas juntos.", 2);
                    return;
                }
                for (NotaFiscalMaterialBean notaFiscalMaterialBean : nota.getMateriais()) {
                    this.materialVO = notaFiscalMaterialBean.getMaterial();
                    this.objetoTabela = new ObjetoTabela(this.materialVO, notaFiscalMaterialBean.getQuantidade(), "N", nota, null, "", null, null);
                    adicionou = this.addMaterial(true);
                }
                if (!nota.getMateriais().isEmpty() && adicionou) {
                    this.bloquearImportacao(false);
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), "N\u00e3o foi poss\u00edvel carregar dados da nota fiscal.", e.getStackTrace());
            return;
        }
    }

    private boolean addMaterial(boolean origemImportacao) {
        boolean adicionou = false;
        if (this.materialAdicionado()) {
            if (this.objetoTabela != null && this.objetoTabela.isEditando() && this.objetoTabela.getQuantidade().equals(Double.valueOf(this.textQuantidade.getText()))) {
                return false;
            }
            boolean substitui = false;
            if (this.objetoTabela != null && origemImportacao) {
                substitui = Funcoes.mensagem(this.getTopLevelAncestor(), "O material " + this.objetoTabela.getMaterialVO().getDescricao() + " j\u00e1 foi informado, deseja substituir as informa\u00e7\u00f5es vindas da importa\u00e7\u00e3o ? \n Quantidade atual de " + this.quantidade() + " ser\u00e1 alterada para " + Funcoes.formataDecimal(this.objetoTabela.getQuantidade()) + ".", 4) == 0;
            } else {
                boolean bl = substitui = Funcoes.mensagem(this.getTopLevelAncestor(), "O material " + this.objetoTabela.getMaterialVO().getDescricao() + " j\u00e1 foi informado, deseja substituir as informa\u00e7\u00f5es ? \n Quantidade atual:" + Funcoes.formataDecimal(this.objetoTabela.getQuantidade()) + ", nova quantidade:" + Funcoes.formataDecimal(Double.parseDouble(this.textQuantidade.getText())) + ".", 4) == 0;
            }
            if (substitui) {
                if (this.objetoTabela != null && this.objetoTabela.isEditando()) {
                    this.objetoTabela.setQuantidade(Double.valueOf(this.textQuantidade.getText()));
                    if (this.materialVO != null && !this.objetoTabela.getMaterialVO().getCodigo().equals(this.materialVO.getCodigo())) {
                        for (int linha = 0; linha < this.modeloMaterial.getRowCount(); ++linha) {
                            Integer codMaterial = (Integer)this.modeloMaterial.getValueAt(linha, 0);
                            if (this.objetoTabela.getMaterialVO() == null || !this.objetoTabela.getMaterialVO().getCodigo().equals(codMaterial)) continue;
                            this.modeloMaterial.removeLine(linha);
                            adicionou = this.addMaterialModelo();
                            break;
                        }
                    } else {
                        for (int linha = 0; linha < this.modeloMaterial.getRowCount(); ++linha) {
                            Integer codMaterial = (Integer)this.modeloMaterial.getValueAt(linha, 0);
                            if (this.materialVO == null || !this.materialVO.getCodigo().equals(codMaterial)) continue;
                            this.modeloMaterial.removeLine(linha);
                            adicionou = this.addMaterialModelo();
                            break;
                        }
                    }
                } else {
                    for (int linha = 0; linha < this.modeloMaterial.getRowCount(); ++linha) {
                        Integer codMaterial = (Integer)this.modeloMaterial.getValueAt(linha, 0);
                        if (this.materialVO == null || !this.materialVO.getCodigo().equals(codMaterial)) continue;
                        this.modeloMaterial.removeLine(linha);
                        adicionou = this.addMaterialModelo();
                        break;
                    }
                }
            }
        } else {
            adicionou = this.addMaterialModelo();
        }
        return adicionou;
    }

    private boolean addMaterialModelo() {
        if (!this.materialAdicionado()) {
            this.modeloMaterial.addLine(new Object[]{this.objetoTabela.getMaterialVO().getCodigo(), this.objetoTabela.getMaterialVO().getDescricao(), Funcoes.formataDecimal(this.objetoTabela.getQuantidade()), this.objetoTabela});
            this.textCodMaterial.clear();
            this.textQuantidade.clear();
            this.labelVlrDescMaterial.setText("");
            this.objetoTabela = null;
            this.materialVO = null;
            return true;
        }
        return false;
    }

    private String quantidade() {
        for (int linha = 0; linha < this.modeloMaterial.getRowCount(); ++linha) {
            Integer codMaterial = (Integer)this.modeloMaterial.getValueAt(linha, 0);
            if (this.materialVO == null || !this.materialVO.getCodigo().equals(codMaterial)) continue;
            return this.modeloMaterial.getValueAt(linha, 2).toString();
        }
        return "0.0";
    }

    private boolean materialAdicionado() {
        for (int linha = 0; linha < this.modeloMaterial.getRowCount(); ++linha) {
            Integer codMaterial = (Integer)this.modeloMaterial.getValueAt(linha, 0);
            if (this.materialVO == null || !this.materialVO.getCodigo().equals(codMaterial)) continue;
            return true;
        }
        return false;
    }

    private void pesquisarMaterial() {
        try {
            this.materialVO = (MaterialVO)this.materialService.pesquisaAtivosVO(this.getTopLevelAncestor(), new MaterialVO(), "Pesquisando material", false);
            if (this.materialVO != null) {
                this.textCodMaterial.setText(this.materialVO.getCodigo().toString());
                this.labelVlrDescMaterial.setText(this.materialVO.getDescricao());
            } else {
                this.textCodMaterial.selectAll();
                this.labelVlrDescMaterial.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), "N\u00e3o foi poss\u00edvel buscar material.", e.getStackTrace());
        }
    }

    private boolean habilitaDesabilitaCampo() {
        return this.getStatus() == 3 || this.getStatus() == 2;
    }

    @Override
    protected void controlaCampos() {
        this.textCodMaterial.setEditable(this.habilitaDesabilitaCampo());
        this.textQuantidade.setEnabled(this.habilitaDesabilitaCampo());
        this.modeloMaterial.clear();
        this.buttonAddMaterial.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonBuscarMaterial.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonImprimir.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonImportar.setEnabled(this.habilitaDesabilitaCampo());
        this.buttonAvulsa.setEnabled(this.habilitaDesabilitaCampo());
        this.botaoFechar.setEnabled(!this.habilitaDesabilitaCampo());
    }

    @Override
    protected void limparCampos() {
        this.modeloMaterial.clear();
        this.textCodMaterial.clear();
        this.textQuantidade.clear();
        this.labelVlrDescMaterial.setText("");
        this.bloquearImportacao(true);
        this.materialVO = null;
    }

    @Override
    protected AbstractThreadBean pesquisar() {
        return null;
    }

    @Override
    protected AbstractThreadBean getBeanPreenchido() {
        return null;
    }

    @Override
    protected void preencherCampos(AbstractThreadBean bean) {
    }

    @Override
    protected String getCopiaFiliais() {
        return null;
    }

    @Override
    public boolean validaCampos() {
        return false;
    }

    @Override
    public String getRetornoParaPesquisa() {
        return null;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return null;
    }

    public static long getModuloAcesso() {
        return Long.valueOf("1200300120");
    }

    private List<ObjetoTabela> getListaObjetoTabela() {
        ArrayList<ObjetoTabela> lista = new ArrayList<ObjetoTabela>();
        for (int linha = 0; linha < this.modeloMaterial.getRowCount(); ++linha) {
            lista.add((ObjetoTabela)this.modeloMaterial.getValueAt(linha, 3));
        }
        return lista;
    }

    private void bloquearImportacao(boolean bloquear) {
        this.buttonImportar.setEnabled(bloquear);
        this.buttonImportar.repaint();
    }

    public class ObjetoTabela {
        private static final String TIPO_NOTA = "N";
        private static final String TIPO_PEDIDO = "P";
        private static final String TIPO_MANUAL = "M";
        private MaterialVO materialVO;
        private Double quantidade;
        private String tipo;
        private NotaFiscalBean notaFiscalBean = null;
        private PedidoBean pedidoBean = null;
        private boolean editando = false;
        private String lote;
        private Date dataLote;
        private Date validadeLote;
        private ModeloGridTable modeloDadosPreenchido = null;

        public ObjetoTabela(MaterialVO materialVO, Double quantidade, String tipo, NotaFiscalBean notaFiscalBean, PedidoBean pedidoBean, String lote, Date dataLote, Date validadeLote) {
            this.materialVO = materialVO;
            this.quantidade = quantidade;
            this.tipo = tipo;
            this.notaFiscalBean = notaFiscalBean;
            this.pedidoBean = pedidoBean;
            this.lote = lote;
            this.dataLote = dataLote;
            this.validadeLote = validadeLote;
        }

        public void setModeloDadosPreenchido(ModeloGridTable modelo) {
            this.modeloDadosPreenchido = modelo;
        }

        public ModeloGridTable getModeloDadosPreenchido() {
            return this.modeloDadosPreenchido;
        }

        public boolean isEditando() {
            return this.editando;
        }

        public void setEditando(boolean editando) {
            this.editando = editando;
        }

        public void setPedidoBean(PedidoBean pedidoBean) {
            this.pedidoBean = pedidoBean;
        }

        public void setNotaFiscalBean(NotaFiscalBean notaFiscalBean) {
            this.notaFiscalBean = notaFiscalBean;
        }

        public NotaFiscalBean getNotaFiscalBean() {
            return this.notaFiscalBean;
        }

        public MaterialVO getMaterialVO() {
            return this.materialVO;
        }

        public void setMaterialVO(MaterialVO materialVO) {
            this.materialVO = materialVO;
        }

        public Double getQuantidade() {
            return this.quantidade;
        }

        public PedidoBean getPedidoBean() {
            return this.pedidoBean;
        }

        public void setQuantidade(Double quantidade) {
            this.quantidade = quantidade;
        }

        public String getTipo() {
            return this.tipo;
        }

        public String getTipoNota() {
            return TIPO_NOTA;
        }

        public String getTipoPedido() {
            return TIPO_PEDIDO;
        }

        public String getTipoManual() {
            return TIPO_MANUAL;
        }

        public String getLote() {
            return this.lote == null ? "" : this.lote;
        }

        public void setLote(String lote) {
            this.lote = lote;
        }

        public Date getDataLote() {
            return this.dataLote;
        }

        public void setDataLote(Date dataLote) {
            this.dataLote = dataLote;
        }

        public Date getValidadeLote() {
            return this.validadeLote;
        }

        public void setValidadeLote(Date validadeLote) {
            this.validadeLote = validadeLote;
        }
    }
}

