/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.estoque.almoxarifado;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.model.bean.estoque.LancamentoEstoqueBean;
import jalis.model.bean.estoque.TransfEstoqueBean;
import jalis.model.bean.estoque.TransfEstoqueMaterialBean;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.estoque.MaterialLoteLanctoEstoqueVO;
import jalis.service.estoque.LancamentoEstoqueService;
import jalis.service.estoque.MaterialLoteLanctoEstoqueService;
import jalis.service.estoque.TransfEstoqueMaterialService;
import jalis.service.estoque.TransfEstoqueService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class EstornoTransferenciaEstoque
extends FrmPadrao
implements ActionListener {
    private static final int COLUNA_SELECIONADO = 0;
    private static final int COLUNA_CODIGO = 1;
    private static final int COLUNA_DESCRICAO = 2;
    private static final int COLUNA_QUANTIDADE = 3;
    private static final int COLUNA_LANCAMENTO = 4;
    private static final int COLUNA_OBJETOMATERIAL = 5;
    private static final int COLUNA_PODE_ESTORNAR = 6;
    private static final int COLUNA_MATERIAL_LOTE_LANCAMENTO_ENTRADA = 7;
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this);
    private JButton buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', this);
    private JButton buttonEstornar = ComponenteFactory.novoJButton("Estornar", 'E', this);
    private JLabel labelDescDestino = new JLabel();
    private JLabel labelDescOrigem = new JLabel();
    private JLabel labelCodigoDestino = new JLabel();
    private JLabel labelCodigoOrigem = new JLabel();
    private JLabel labelDestino = new JLabel("C\u00e9lula Destino:");
    private JLabel labelOrigem = new JLabel("C\u00e9lula Origem:");
    private JLabel labelData = new JLabel("Data:");
    private JLabel labelVlrData = new JLabel();
    private JLabel labelUsuario = new JLabel("Usu\u00e1rio:");
    private JLabel labelVlrUsuario = new JLabel();
    private JLabel labelVlrCodigo = new JLabel();
    private JLabel labelCodigo = new JLabel("C\u00f3digo:");
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JPanel panelCentro = new JPanel(new GridBagLayout());
    private JPanel panelMaterial = new JPanel(new BorderLayout());
    private JPanel panelLegenda = null;
    private ModeloGridTable modeloMaterial = new ModeloGridTable(new String[]{"Sel.", "C\u00f3digo", "Material", "Quantidade"}){

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            Boolean podeEstornar = (Boolean)EstornoTransferenciaEstoque.this.modeloMaterial.getValueAt(rowIndex, 6);
            return columnIndex == 0 && podeEstornar != false;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }
    };
    private JTable tabelaMaterial = new JTable(this.modeloMaterial);
    private JScrollPane scrollMaterial = new JScrollPane(this.tabelaMaterial);
    private int status = 1;
    private static final Color COR_NAO_PODE_ESTORNAR = ScreenUtil.escurecerCor(Color.RED, 25);
    private TransfEstoqueBean transferenciaAux = null;

    public EstornoTransferenciaEstoque() {
        this.montaTela();
        this.controlaCampos();
    }

    private void montaTela() {
        this.setLayout(new BorderLayout());
        ScreenUtil.setBorda(new Component[]{this.labelVlrData, this.labelVlrUsuario, this.labelCodigoOrigem, this.labelCodigoDestino, this.labelDescOrigem, this.labelDescDestino, this.labelVlrCodigo}, new TitledBorder(""));
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelCentro, "Center");
        Funcoes.criaBarraDescricao(this, "Estorno de transfer\u00eancia entre estoques", "Estorno de transfer\u00eancia de materiais entre c\u00e9lulas de estoque", "estoque/estorno_transferencia_entre_estoques.jpg");
        this.panelCentro.setBorder(ScreenUtil.criarBordaVazia());
        this.modeloMaterial.setColumnSize(new int[]{40, 70, 0, 100}, this.tabelaMaterial);
        this.tabelaMaterial.getTableHeader().addMouseListener(this.modeloMaterial);
        this.tabelaMaterial.setDefaultRenderer(Object.class, new EstoqueRenderer());
        this.tabelaMaterial.setDefaultRenderer(Boolean.class, new EstoqueBooleanRenderer());
        this.tabelaMaterial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    int row = EstornoTransferenciaEstoque.this.tabelaMaterial.getSelectedRow();
                    int column = EstornoTransferenciaEstoque.this.tabelaMaterial.getSelectedColumn();
                    if (row >= 0 && column != 0 && ((Boolean)EstornoTransferenciaEstoque.this.modeloMaterial.getValueAt(row, 6)).booleanValue()) {
                        Boolean valorAtual = (Boolean)EstornoTransferenciaEstoque.this.modeloMaterial.getValueAt(row, 0);
                        EstornoTransferenciaEstoque.this.modeloMaterial.setValueAt(valorAtual == false, row, 0);
                    }
                }
            }
        });
        this.labelVlrCodigo.setMinimumSize(new Dimension(80, 20));
        this.labelVlrCodigo.setPreferredSize(new Dimension(80, 20));
        this.labelVlrData.setMinimumSize(new Dimension(150, 20));
        this.labelVlrData.setPreferredSize(new Dimension(150, 20));
        this.labelVlrUsuario.setMinimumSize(new Dimension(250, 20));
        this.labelVlrUsuario.setPreferredSize(new Dimension(250, 20));
        JPanel panelCabecalho = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 0, 0);
        panelCabecalho.add((Component)this.labelCodigo, c);
        ++c.gridx;
        this.labelVlrCodigo.setHorizontalAlignment(4);
        panelCabecalho.add((Component)this.labelVlrCodigo, c);
        ++c.gridx;
        c.insets = new Insets(0, 20, 0, 0);
        panelCabecalho.add((Component)this.labelData, c);
        ++c.gridx;
        c.insets = new Insets(0, 0, 0, 0);
        panelCabecalho.add((Component)this.labelVlrData, c);
        ++c.gridx;
        c.insets = new Insets(0, 20, 0, 0);
        panelCabecalho.add((Component)this.labelUsuario, c);
        ++c.gridx;
        c.insets = new Insets(0, 0, 0, 0);
        panelCabecalho.add((Component)this.labelVlrUsuario, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        panelCabecalho.add((Component)new JLabel(), c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 10, 1);
        c.gridwidth = 5;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.panelCentro.add((Component)panelCabecalho, c);
        ++c.gridy;
        c.insets = new Insets(0, 1, 0, 0);
        c.gridwidth = 1;
        c.fill = 0;
        c.weightx = 0.0;
        this.panelCentro.add((Component)this.labelOrigem, c);
        ++c.gridx;
        this.labelCodigoOrigem.setMinimumSize(new Dimension(50, 20));
        this.labelCodigoOrigem.setPreferredSize(new Dimension(50, 20));
        this.labelCodigoOrigem.setHorizontalAlignment(4);
        c.insets = new Insets(0, 0, 0, 0);
        this.panelCentro.add((Component)this.labelCodigoOrigem, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = new Insets(0, 1, 0, 1);
        this.labelDescOrigem.setMinimumSize(new Dimension(20, 20));
        this.labelDescOrigem.setPreferredSize(new Dimension(20, 20));
        this.panelCentro.add((Component)this.labelDescOrigem, c);
        ++c.gridy;
        c.gridx = 0;
        c.fill = 0;
        c.weightx = 0.0;
        c.insets = new Insets(0, 1, 0, 0);
        this.panelCentro.add((Component)this.labelDestino, c);
        ++c.gridx;
        this.labelCodigoDestino.setMinimumSize(new Dimension(50, 20));
        this.labelCodigoDestino.setPreferredSize(new Dimension(50, 20));
        this.labelCodigoDestino.setHorizontalAlignment(4);
        this.labelCodigoOrigem.setHorizontalAlignment(4);
        c.insets = new Insets(0, 0, 0, 0);
        this.panelCentro.add((Component)this.labelCodigoDestino, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = new Insets(0, 1, 0, 1);
        this.labelDescDestino.setMinimumSize(new Dimension(20, 20));
        this.labelDescDestino.setPreferredSize(new Dimension(20, 20));
        this.panelCentro.add((Component)this.labelDescDestino, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 5;
        c.insets = new Insets(0, 1, 0, 1);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.panelCentro.add((Component)this.panelMaterial, c);
        ++c.gridy;
        c.fill = 2;
        c.weighty = 0.0;
        this.panelLegenda = this.montaPainelLegenda();
        this.panelCentro.add((Component)this.panelLegenda, c);
        ++c.gridy;
        this.panelCentro.add((Component)this.panelBotoes, c);
        this.panelMaterial.setBorder(BorderFactory.createTitledBorder("Materiais"));
        this.panelMaterial.add((Component)this.scrollMaterial, "Center");
        this.panelBotoes.add(this.buttonNovo);
        this.panelBotoes.add(this.buttonEstornar);
        this.panelBotoes.add(this.buttonCancelar);
        this.panelBotoes.add(this.buttonFechar);
        this.modeloMaterial.ordenarColuna(1, 1);
        Funcoes.montaEnter((JComponent)this.panelCentro);
    }

    private JPanel montaPainelLegenda() {
        JPanel pnlLegenda = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        JPanel pnlCorLegenda = new JPanel();
        pnlCorLegenda.setPreferredSize(new Dimension(10, 10));
        pnlCorLegenda.setBackground(COR_NAO_PODE_ESTORNAR);
        pnlCorLegenda.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        pnlLegenda.add((Component)pnlCorLegenda, c);
        JLabel lblLegenda = new JLabel("N\u00e3o \u00e9 poss\u00edvel estornar");
        Font font = new Font(lblLegenda.getFont().getName(), 0, 10);
        lblLegenda.setFont(font);
        ++c.gridx;
        pnlLegenda.add((Component)lblLegenda, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        pnlLegenda.add((Component)new JLabel(), c);
        return pnlLegenda;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("1200300130");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonNovo) {
            this.novo();
        } else if (e.getSource() == this.buttonCancelar) {
            this.cancelar();
        } else if (e.getSource() == this.buttonFechar) {
            this.fechar();
        } else if (e.getSource() == this.buttonEstornar) {
            this.estornar();
        }
    }

    private void estornar() {
        if (!this.validarEstorno()) {
            return;
        }
        UsuarioVO usuarioVO = new UsuarioVO();
        usuarioVO.setFilial(this.transferenciaAux.getFilial());
        usuarioVO.setCodigo(Variaveis.login);
        TransfEstoqueMaterialService transfMaterialService = new TransfEstoqueMaterialService();
        Date dataHoraEstorno = new Date();
        boolean isOk = true;
        int qtdeSelecionada = 0;
        for (int i = 0; i < this.modeloMaterial.getRowCount(); ++i) {
            if (!((Boolean)this.modeloMaterial.getValueAt(i, 0)).booleanValue()) continue;
            ++qtdeSelecionada;
            TransfEstoqueMaterialBean beanMat = (TransfEstoqueMaterialBean)this.modeloMaterial.getValueAt(i, 5);
            LancamentoEstoqueBean lancto = (LancamentoEstoqueBean)this.modeloMaterial.getValueAt(i, 4);
            ArrayList listaMatLoteLanctoEntrada = (ArrayList)this.modeloMaterial.getValueAt(i, 7);
            try {
                transfMaterialService.estornar(beanMat, lancto, dataHoraEstorno, usuarioVO, listaMatLoteLanctoEntrada);
                continue;
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel estornar o material da transfer\u00eancia de estoque.\n" + e.getMessage(), e.getStackTrace());
                isOk = false;
                break;
            }
        }
        if (this.modeloMaterial.getRowCount() == qtdeSelecionada) {
            this.transferenciaAux.setDataEstorno(new Date());
            this.transferenciaAux.setUsuarioEstorno(usuarioVO);
            try {
                new TransfEstoqueService().gravaAutoCopiaSemCommit(this.transferenciaAux, 1, this.transferenciaAux.getFilial().getCodigo().toString(), null);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel atualizar a transfer\u00eancia de estoque.\n" + e.getMessage(), e.getStackTrace());
                isOk = false;
            }
        }
        if (isOk) {
            try {
                Conexao.arquivaSQL();
                Funcoes.mensagem(this, "Estorno realizado com sucesso.", 5);
                this.limparCampos();
                this.setStatus(1);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel arquivar altera\u00e7\u00f5es.\n" + e.getMessage(), e.getStackTrace());
                try {
                    Conexao.arquivaSQL();
                }
                catch (SQLException sQLException) {}
            }
        } else {
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private boolean validarEstorno() {
        int qtde = 0;
        for (int i = 0; i < this.modeloMaterial.getRowCount(); ++i) {
            if (!((Boolean)this.modeloMaterial.getValueAt(i, 0)).booleanValue()) continue;
            ++qtde;
            break;
        }
        if (qtde == 0) {
            Funcoes.mensagem(this, "Pelo menos um material deve ser selecionado para estorno.", 2);
            return false;
        }
        return true;
    }

    private void limparCampos() {
        this.modeloMaterial.clear();
        this.labelCodigoDestino.setText("");
        this.labelCodigoOrigem.setText("");
        this.labelDescDestino.setText("");
        this.labelDescOrigem.setText("");
        this.labelVlrData.setText("");
        this.labelVlrUsuario.setText("");
        this.labelVlrCodigo.setText("");
        this.transferenciaAux = null;
    }

    private void setStatus(int status) {
        this.status = status;
        this.controlaCampos();
    }

    private void controlaCampos() {
        this.buttonNovo.setEnabled(this.status == 1);
        this.buttonEstornar.setEnabled(this.status == 2);
        this.buttonFechar.setEnabled(this.status == 1);
        this.buttonCancelar.setEnabled(this.status == 2);
    }

    private void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
        }
    }

    private void novo() {
        this.limparCampos();
        this.setStatus(2);
        TransfEstoqueService service = new TransfEstoqueService();
        Hashtable hash = service.pesquisaTransfEstoqueConciliadaVO(Laboratorio.getInstancia(), false);
        if (hash != null) {
            String codigo = hash.get("tra_codigo").toString();
            try {
                this.transferenciaAux = (TransfEstoqueBean)service.get(Variaveis.filialPadrao, codigo, false);
                if (this.transferenciaAux != null) {
                    this.preencheDados(this.transferenciaAux);
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar os dados da transfer\u00eancia de estoque.\n" + e.getMessage(), e.getStackTrace());
                this.limparCampos();
                this.setStatus(1);
            }
        } else {
            this.setStatus(1);
        }
    }

    private void preencheDados(TransfEstoqueBean bean) throws Exception {
        this.labelVlrCodigo.setText(bean.getCodigo().toString());
        this.labelVlrData.setText(Funcoes.formataData("dd/MM/yyyy HH:mm:ss", bean.getDataHora()));
        this.labelVlrUsuario.setText(bean.getUsuario().getCodigo());
        this.labelCodigoOrigem.setText(bean.getCelulaOrigem().getCodigo().toString());
        this.labelCodigoDestino.setText(bean.getCelulaDestino().getCodigo().toString());
        this.labelDescOrigem.setText(bean.getCelulaOrigem().getDescricao());
        this.labelDescDestino.setText(bean.getCelulaDestino().getDescricao());
        for (TransfEstoqueMaterialBean beanMat : bean.getMateriais()) {
            LancamentoEstoqueBean beanLanctoSaida = null;
            LancamentoEstoqueBean beanLanctoEntrada = null;
            for (LancamentoEstoqueBean aux : bean.getLancamentos()) {
                if (!aux.getTipo().equalsIgnoreCase("S") || aux.getMaterial().getCodigo().intValue() != beanMat.getMaterial().getCodigo().intValue()) continue;
                beanLanctoSaida = aux;
                break;
            }
            if (beanLanctoSaida == null) {
                throw new Exception("O lan\u00e7amento de sa\u00edda da transfer\u00eancia n\u00e3o foi localizado.");
            }
            for (LancamentoEstoqueBean aux : bean.getLancamentos()) {
                if (!aux.getTipo().equalsIgnoreCase("E") || aux.getMaterial().getCodigo().intValue() != beanMat.getMaterial().getCodigo().intValue()) continue;
                beanLanctoEntrada = aux;
                break;
            }
            if (beanLanctoEntrada == null) {
                throw new Exception("O lan\u00e7amento de entrada da transfer\u00eancia n\u00e3o foi localizado.");
            }
            LancamentoEstoqueService serviceLancto = new LancamentoEstoqueService();
            ArrayList<MaterialLoteLanctoEstoqueVO> listaMatLoteLanctoEntrada = new ArrayList<MaterialLoteLanctoEstoqueVO>();
            try {
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("fil_codigo", beanLanctoSaida.getFilial().getCodigo());
                chaves.put("lce_codigo", beanLanctoSaida.getCodigo());
                Set<MaterialLoteLanctoEstoqueVO> listaMatLoteLanctoVO = new MaterialLoteLanctoEstoqueService().getVOs(chaves);
                if (listaMatLoteLanctoVO != null) {
                    for (MaterialLoteLanctoEstoqueVO aux : listaMatLoteLanctoVO) {
                        chaves.clear();
                        chaves.put("fil_codigo", aux.getMaterialLote().getFilial().getCodigo());
                        chaves.put("mll_codigo", aux.getMaterialLote().getCodigo());
                        Set<MaterialLoteLanctoEstoqueVO> listaMatLotLancto = new MaterialLoteLanctoEstoqueService().getVOs(chaves);
                        for (MaterialLoteLanctoEstoqueVO aux2 : listaMatLotLancto) {
                            if (aux2.getLancamento().getTipo().equalsIgnoreCase("S")) continue;
                            aux2.setQuantidadeAuxiliar(aux.getQuantidade());
                            listaMatLoteLanctoEntrada.add(aux2);
                        }
                    }
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar os lan\u00e7amentos de entrada envolvidos na transfer\u00eancia.\n" + e.getMessage(), e.getStackTrace());
                return;
            }
            this.modeloMaterial.addLine(new Object[]{Boolean.FALSE, beanMat.getMaterial().getCodigo(), beanMat.getMaterial().getDescricao(), Funcoes.formataDecimal(beanMat.getQuantidade()), beanLanctoSaida, beanMat, beanLanctoEntrada.getLancamentoBaixaAutomatica() != null, listaMatLoteLanctoEntrada});
        }
        this.modeloMaterial.ordenarColunaSemTrocarSentido(this.modeloMaterial.getColunaOrdenacao());
    }

    private void fechar() {
        this.setVisible(false);
    }

    private String getCopiaFiliais() {
        return Variaveis.filialPadrao;
    }

    class EstoqueBooleanRenderer
    extends JCheckBox
    implements TableCellRenderer {
        @Override
        public synchronized Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            this.setSelected(value instanceof Boolean ? (Boolean)value : false);
            this.setHorizontalAlignment(0);
            if (selected) {
                if (((Boolean)EstornoTransferenciaEstoque.this.modeloMaterial.getValueAt(row, 6)).booleanValue()) {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setForeground(Color.WHITE);
                    this.setBackground(ScreenUtil.escurecerCor(COR_NAO_PODE_ESTORNAR, 50));
                }
            } else if (((Boolean)EstornoTransferenciaEstoque.this.modeloMaterial.getValueAt(row, 6)).booleanValue()) {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            } else {
                this.setForeground(Color.WHITE);
                this.setBackground(COR_NAO_PODE_ESTORNAR);
            }
            return this;
        }
    }

    class EstoqueRenderer
    extends DefaultTableCellRenderer {
        @Override
        public synchronized Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            this.setText(value != null ? value.toString() : "");
            if (selected) {
                if (((Boolean)EstornoTransferenciaEstoque.this.modeloMaterial.getValueAt(row, 6)).booleanValue()) {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setForeground(Color.WHITE);
                    this.setBackground(ScreenUtil.escurecerCor(COR_NAO_PODE_ESTORNAR, 50));
                }
            } else if (((Boolean)EstornoTransferenciaEstoque.this.modeloMaterial.getValueAt(row, 6)).booleanValue()) {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            } else {
                this.setForeground(Color.WHITE);
                this.setBackground(COR_NAO_PODE_ESTORNAR);
            }
            return this;
        }
    }
}

