/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.estoque.almoxarifado;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.model.bean.estoque.ConferenciaEntradaBean;
import jalis.model.bean.estoque.ConferenciaEntradaMaterialBean;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.estoque.ConferenciaEntradaVO;
import jalis.service.estoque.ConferenciaEntradaLanctoEstoqueService;
import jalis.service.estoque.ConferenciaEntradaService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;

public class EstornoConferenciaEntrada
extends FrmPadrao
implements ActionListener {
    private Color COR_NAO_PODE_ESTORNAR = Color.RED;
    private JButton buttonBuscaConferencia = ComponenteFactory.novoJButton(this, true);
    private JButton buttonCancelar;
    private JButton buttonEstornar;
    private JButton buttonFechar;
    private JButton buttonNovo;
    private JScrollPane jScrollPane1;
    private JLabel labelCodigo;
    private JLabel labelData;
    private JLabel labelDescData;
    private JLabel labelDescUsuario;
    private JLabel labelUsuario;
    private JPanel panelBotoes;
    private JPanel panelCentro;
    private JPanel panelMaterial;
    private JTable tabela;
    private TTextField textCodigoConferencia = new TTextField(8, 1);
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"C\u00f3digo", "Material", "Solicitado", "Recebido", "C\u00e9lula destino", "Objeto"}){

        @Override
        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            try {
                if (EstornoConferenciaEntrada.this.tabela != null) {
                    EstornoConferenciaEntrada.this.tabela.removeColumn(EstornoConferenciaEntrada.this.tabela.getColumn("Objeto"));
                }
            }
            catch (Exception iae) {
                iae.printStackTrace();
            }
        }

        @Override
        public void fireTableStructureChanged() {
            super.fireTableStructureChanged();
            try {
                if (EstornoConferenciaEntrada.this.tabela != null) {
                    EstornoConferenciaEntrada.this.tabela.removeColumn(EstornoConferenciaEntrada.this.tabela.getColumn("Objeto"));
                }
            }
            catch (Exception iae) {
                iae.printStackTrace();
            }
        }
    };
    private ConferenciaEntradaBean conferenciaAux;
    private int status = 1;

    public EstornoConferenciaEntrada() {
        this.montaTela();
    }

    private void montaTela() {
        this.setLayout(new BorderLayout());
        JPanel panelCentro = new JPanel(new GridBagLayout());
        Funcoes.criaBarraDescricao(this, "Estorno de Confer\u00eancia de Entrada", "Estorno de lan\u00e7amentos realizados pela Confer\u00eancia de Entrada de materiais", "estoque/estorno_conferencia_entrada.jpg");
        this.add((Component)panelCentro, "Center");
        this.labelCodigo = new JLabel();
        this.labelData = new JLabel();
        this.labelDescData = new JLabel();
        this.labelUsuario = new JLabel();
        this.labelDescUsuario = new JLabel();
        this.panelMaterial = new JPanel();
        this.tabela = new JTable(this.modelo);
        this.jScrollPane1 = new JScrollPane(this.tabela);
        this.panelBotoes = new JPanel();
        this.buttonNovo = new JButton();
        this.buttonEstornar = new JButton();
        this.buttonCancelar = new JButton();
        this.buttonFechar = new JButton();
        this.modelo.setColumnSize(new int[]{70, 0, 90, 90, 0, 0}, this.tabela);
        this.tabela.getTableHeader().addMouseListener(this.modelo);
        this.tabela.setDefaultRenderer(Object.class, new EstornoRenderer());
        panelCentro.setLayout(new GridBagLayout());
        panelCentro.setBorder(ScreenUtil.criarBordaVazia());
        this.textCodigoConferencia.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!(EstornoConferenciaEntrada.this.textCodigoConferencia.getText().isEmpty() || EstornoConferenciaEntrada.this.conferenciaAux != null && EstornoConferenciaEntrada.this.textCodigoConferencia.getText().equalsIgnoreCase(EstornoConferenciaEntrada.this.conferenciaAux.getCodigo().toString()))) {
                    EstornoConferenciaEntrada.this.pesquisaConferencia(EstornoConferenciaEntrada.this.textCodigoConferencia.getText());
                }
            }
        });
        this.labelCodigo.setText("C\u00f3digo:");
        this.labelCodigo.setDisplayedMnemonic('d');
        this.labelCodigo.setLabelFor(this.textCodigoConferencia);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        panelCentro.add((Component)this.labelCodigo, gridBagConstraints);
        this.textCodigoConferencia.setMinimumSize(new Dimension(70, 20));
        this.textCodigoConferencia.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        panelCentro.add((Component)this.textCodigoConferencia, gridBagConstraints);
        this.buttonBuscaConferencia.setMaximumSize(new Dimension(20, 20));
        this.buttonBuscaConferencia.setMinimumSize(new Dimension(20, 20));
        this.buttonBuscaConferencia.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        panelCentro.add((Component)this.buttonBuscaConferencia, gridBagConstraints);
        this.labelData.setText("Data:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        panelCentro.add((Component)this.labelData, gridBagConstraints);
        this.labelDescData.setBorder(BorderFactory.createTitledBorder(""));
        this.labelDescData.setMinimumSize(new Dimension(50, 20));
        this.labelDescData.setPreferredSize(new Dimension(80, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        panelCentro.add((Component)this.labelDescData, gridBagConstraints);
        this.labelUsuario.setText("Usu\u00e1rio:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        panelCentro.add((Component)this.labelUsuario, gridBagConstraints);
        this.labelDescUsuario.setBorder(BorderFactory.createTitledBorder(""));
        this.labelDescUsuario.setMinimumSize(new Dimension(50, 20));
        this.labelDescUsuario.setPreferredSize(new Dimension(80, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        panelCentro.add((Component)this.labelDescUsuario, gridBagConstraints);
        this.panelMaterial.setBorder(BorderFactory.createTitledBorder("Materiais"));
        this.panelMaterial.setLayout(new BorderLayout());
        this.panelMaterial.add((Component)this.jScrollPane1, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        panelCentro.add((Component)this.panelMaterial, gridBagConstraints);
        this.panelBotoes.setLayout(new BorderLayout());
        JPanel panelBotoesDireta = new JPanel(new FlowLayout(2));
        JPanel panelLegenda = new JPanel();
        this.montaLegenda(panelLegenda);
        this.panelBotoes.add((Component)panelBotoesDireta, "East");
        this.panelBotoes.add((Component)panelLegenda, "West");
        this.buttonNovo.addActionListener(this);
        this.buttonNovo.setText("Novo");
        this.buttonNovo.setMnemonic('N');
        panelBotoesDireta.add(this.buttonNovo);
        this.buttonEstornar.addActionListener(this);
        this.buttonEstornar.setText("Estornar");
        this.buttonEstornar.setMnemonic('E');
        panelBotoesDireta.add(this.buttonEstornar);
        this.buttonCancelar.addActionListener(this);
        this.buttonCancelar.setText("Cancelar");
        this.buttonCancelar.setMnemonic('C');
        panelBotoesDireta.add(this.buttonCancelar);
        this.buttonFechar.addActionListener(this);
        this.buttonFechar.setText("Fechar");
        this.buttonFechar.setMnemonic('F');
        panelBotoesDireta.add(this.buttonFechar);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        panelCentro.add((Component)this.panelBotoes, gridBagConstraints);
        this.controlaCampos();
        this.modelo.ordenarColuna(this.modelo.findColumn("Material"));
    }

    private void montaLegenda(JPanel panel) {
        if (panel != null) {
            panel.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 17;
            c.fill = 0;
            c.gridheight = 1;
            c.gridwidth = 1;
            c.gridx = 0;
            c.gridy = 0;
            c.insets = new Insets(1, 1, 1, 1);
            c.weightx = 0.0;
            c.weighty = 0.0;
            JPanel panelLegenda = new JPanel();
            panelLegenda.setPreferredSize(new Dimension(10, 10));
            panelLegenda.setBackground(this.COR_NAO_PODE_ESTORNAR);
            panelLegenda.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
            panel.add((Component)panelLegenda, c);
            JLabel labelLegenda = new JLabel("N\u00e3o \u00e9 poss\u00edvel estornar");
            Font font = new Font(labelLegenda.getFont().getName(), 0, 10);
            labelLegenda.setFont(font);
            ++c.gridx;
            panel.add((Component)labelLegenda, c);
        }
    }

    private int getStatus() {
        return this.status;
    }

    private void setStatus(int status) {
        this.status = status;
    }

    private void controlaCampos() {
        boolean habilitar = this.getStatus() == 2 || this.getStatus() == 3;
        this.textCodigoConferencia.setEnabled(habilitar && this.conferenciaAux == null);
        this.buttonBuscaConferencia.setEnabled(habilitar && this.conferenciaAux == null);
        this.buttonCancelar.setEnabled(this.status == 2);
        this.buttonNovo.setEnabled(this.status == 1);
        this.buttonFechar.setEnabled(this.status == 1);
        this.buttonEstornar.setEnabled(this.status == 2 && this.conferenciaAux != null);
    }

    public static long getModuloAcesso() {
        return Long.parseLong("1200300400");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonFechar) {
            this.fechar();
        } else if (e.getSource() == this.buttonNovo) {
            this.novo();
        } else if (e.getSource() == this.buttonCancelar) {
            this.cancelar();
        } else if (e.getSource() == this.buttonBuscaConferencia) {
            this.pesquisaConferencia();
        } else if (e.getSource() == this.buttonEstornar) {
            this.estornarConferencia();
        }
    }

    private void estornarConferencia() {
        int resp;
        int problemasEstorno = this.getProblemasEstorno();
        if (problemasEstorno > 0) {
            if (problemasEstorno == this.modelo.getRowCount()) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "Nenhuma entrada de material poder\u00e1 ser estornada, pois, h\u00e1 movimenta\u00e7\u00e3o ap\u00f3s a confer\u00eancia de entrada para todos os materiais.\n\u00c9 necess\u00e1rio fazer os ajustes manualmente.", 2);
                return;
            }
            Funcoes.mensagem(Laboratorio.getInstancia(), "Algumas entradas de material n\u00e3o poder\u00e3o ser estornadas, pois, h\u00e1 movimenta\u00e7\u00e3o ap\u00f3s a confer\u00eancia de entrada.\n\u00c9 necess\u00e1rio fazer os ajustes manualmente.", 2);
        }
        if ((resp = Funcoes.mensagem(this, "Deseja realmente estornar a Confer\u00eancia de Entrada?", 4)) == 0) {
            try {
                if (new ConferenciaEntradaService().estornaConferencia(this.conferenciaAux)) {
                    Conexao.arquivaSQL();
                    Funcoes.mensagem(this, "Confer\u00eancia estornada com sucesso.", 5);
                    this.setStatus(1);
                    this.limparCampos();
                    this.controlaCampos();
                }
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel estornar a confer\u00eancia de entrada.\n" + e.getMessage(), e.getStackTrace());
                return;
            }
        }
    }

    private int getProblemasEstorno() {
        int qtde = 0;
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            ConferenciaEntradaMaterialBean bean = (ConferenciaEntradaMaterialBean)this.modelo.getValueAt(i, this.modelo.findColumn("Objeto"));
            if (bean.getPodeEstornar()) continue;
            ++qtde;
        }
        return qtde;
    }

    private void verificaProblemasEstorno() {
        ConferenciaEntradaLanctoEstoqueService serviceLancto = new ConferenciaEntradaLanctoEstoqueService();
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            ConferenciaEntradaMaterialBean bean = (ConferenciaEntradaMaterialBean)this.modelo.getValueAt(i, this.modelo.findColumn("Objeto"));
            if (bean == null) continue;
            try {
                bean.setPodeEstornar(serviceLancto.podeEstornar(serviceLancto.getConferenciaEntradaLanctoEstoque(bean.getFilial().getCodigo().toString(), bean.getConferenciaEntrada().getCodigo().toString(), bean.getMaterial().getCodigo().toString())));
                continue;
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel verificar se a confer\u00eancia de entrada pode ser estornada.", e.getStackTrace());
            }
        }
    }

    private void pesquisaConferencia() {
        String codigoConferencia = new ConferenciaEntradaService().pesquisaVO(Laboratorio.getInstancia(), new ConferenciaEntradaVO());
        if (codigoConferencia != null) {
            this.pesquisaConferencia(codigoConferencia);
        }
    }

    private void pesquisaConferencia(String codigoConferencia) {
        this.conferenciaAux = null;
        try {
            this.conferenciaAux = (ConferenciaEntradaBean)new ConferenciaEntradaService().get(Variaveis.filialPadrao, codigoConferencia);
        }
        catch (Exception e1) {
            Funcoes.mensagem(this, "Erro ao buscar dados da confer\u00eancia.", 2);
            return;
        }
        if (this.conferenciaAux == null) {
            Funcoes.mensagem(this, "A confer\u00eancia de entrada n\u00e3o p\u00f4de ser encontrada.", 2);
            if (this.textCodigoConferencia.isEnabled() && this.textCodigoConferencia.isFocusable()) {
                this.textCodigoConferencia.selectAll();
                ScreenUtil.requisitarFoco(this.textCodigoConferencia);
            }
            return;
        }
        if (this.conferenciaAux.getDataHoraCancelamento() != null || this.conferenciaAux.getUsuarioCancelamento() != null) {
            this.conferenciaAux = null;
        }
        this.controlaCampos();
        if (this.conferenciaAux != null) {
            this.preencherCampos(this.conferenciaAux);
        } else {
            Funcoes.mensagem(this, "A confer\u00eancia n\u00e3o p\u00f4de ser carregada.", 2);
            if (this.textCodigoConferencia.isEnabled() && this.textCodigoConferencia.isFocusable()) {
                this.textCodigoConferencia.selectAll();
                ScreenUtil.requisitarFoco(this.textCodigoConferencia);
            }
        }
    }

    private void preencherCampos(ConferenciaEntradaBean bean) {
        if (bean == null) {
            return;
        }
        this.conferenciaAux.setDataHoraCancelamento(new Date());
        this.conferenciaAux.setUsuarioCancelamento(new UsuarioVO());
        this.conferenciaAux.getUsuarioCancelamento().setCodigo(Variaveis.login);
        this.labelDescData.setText(Funcoes.formataData("dd/MM/yyyy HH:mm:ss", this.conferenciaAux.getDataHoraCancelamento()));
        this.labelDescUsuario.setText(this.conferenciaAux.getUsuarioCancelamento().getCodigo());
        this.textCodigoConferencia.setText(String.valueOf(bean.getCodigo()));
        ArrayList<ConferenciaEntradaMaterialBean> materiais = bean.getMateriais();
        if (materiais != null) {
            for (int i = 0; i < materiais.size(); ++i) {
                this.adicionaMaterial(materiais.get(i));
            }
        }
        this.verificaProblemasEstorno();
        if (this.modelo.getColunaOrdenacao() != -1) {
            this.modelo.ordenarColunaSemTrocarSentido(this.modelo.getColunaOrdenacao());
        } else {
            this.modelo.ordenarColunaSemTrocarSentido(this.modelo.findColumn("Descri\u00e7\u00e3o"));
        }
    }

    private void adicionaMaterial(ConferenciaEntradaMaterialBean material) {
        this.modelo.addLine(new Object[]{material.getMaterial().getCodigo(), material.getMaterial().getDescricao(), Funcoes.formataDecimal(material.getQuantidadeSolicitada()), Funcoes.formataDecimal(material.getQuantidadeRecebida()), material.getCelulaEstoque().getDescricao(), material});
    }

    private void fechar() {
        this.setVisible(false);
    }

    private void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.status = 1;
            this.controlaCampos();
        }
    }

    private void novo() {
        this.limparCampos();
        this.status = 2;
        this.controlaCampos();
        if (this.textCodigoConferencia.isFocusable() && this.textCodigoConferencia.isEnabled()) {
            this.textCodigoConferencia.grabFocus();
        }
    }

    private void limparCampos() {
        this.textCodigoConferencia.setText("");
        this.labelDescData.setText("");
        this.labelDescUsuario.setText("");
        this.modelo.clear();
        this.conferenciaAux = null;
    }

    @Override
    public void pressioneiF2() {
        if (this.textCodigoConferencia.hasFocus()) {
            this.buttonBuscaConferencia.doClick();
        }
    }

    class EstornoRenderer
    extends DefaultTableCellRenderer {
        EstornoRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            ConferenciaEntradaMaterialBean bean = null;
            if (EstornoConferenciaEntrada.this.modelo != null && EstornoConferenciaEntrada.this.modelo.getRowCount() > row) {
                bean = (ConferenciaEntradaMaterialBean)EstornoConferenciaEntrada.this.modelo.getValueAt(row, EstornoConferenciaEntrada.this.modelo.findColumn("Objeto"));
            }
            if (bean != null && !bean.getPodeEstornar()) {
                comp.setForeground(EstornoConferenciaEntrada.this.COR_NAO_PODE_ESTORNAR);
            } else {
                comp.setForeground(UIManager.getColor("Table.foreground"));
            }
            return comp;
        }
    }
}

