/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.estoque.almoxarifado;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.model.bean.estoque.RequisicaoEstoqueBean;
import jalis.model.bean.estoque.RequisicaoEstoqueMaterialBean;
import jalis.model.bean.estoque.TransfEstoqueBean;
import jalis.model.bean.estoque.TransfEstoqueMaterialBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.service.estoque.RequisicaoEstoqueService;
import jalis.service.estoque.TransfEstoqueService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

public class ConferenciaTransferencia
extends FrmPadrao
implements ActionListener {
    private JButton buttonCancelar;
    private JButton buttonFechar;
    private JButton buttonImportarTransferencia;
    private JButton buttonImportarRequisicao;
    private JButton buttonConfirmar;
    private JScrollPane jScrollPane1;
    private JLabel labelDescDestino;
    private JLabel labelDescOrigem;
    private JLabel labelDestino;
    private JLabel labelOrigem;
    private JLabel labelVlrData = new JLabel();
    private JLabel labelVlrUsuario = new JLabel();
    private JLabel labelUsuario = new JLabel("Usu\u00e1rio:");
    private JLabel labelData = new JLabel("Data:");
    private JPanel panelBotoes;
    private JPanel panelCentro;
    private JPanel panelMaterial;
    private JTable tabelaMaterial;
    private TTextField textCodigoDestino;
    private TTextField textCodigoOrigem;
    private ModeloGridTable modeloMaterial = new ModeloGridTable(new String[]{"C\u00f3digo", "Material", "Quantidade"});
    private int status = 1;
    private TransfEstoqueBean transferenciaAux = null;
    private Date dataAux = null;
    private UsuarioVO usuarioAux = null;
    private static final int COLUNA_CODIGO = 0;
    private static final int COLUNA_DESCRICAO = 1;
    private static final int COLUNA_QUANTIDADE = 2;
    private static final int COLUNA_LANCAMENTO = 3;

    public ConferenciaTransferencia() {
        this.montaTela();
        this.controlaCampos();
    }

    private void montaTela() {
        this.setLayout(new BorderLayout());
        ScreenUtil.setBorda(new Component[]{this.labelVlrData, this.labelVlrUsuario}, new TitledBorder(""));
        this.panelCentro = new JPanel();
        this.labelOrigem = new JLabel();
        this.labelDestino = new JLabel();
        this.panelMaterial = new JPanel();
        this.tabelaMaterial = new JTable(this.modeloMaterial);
        this.jScrollPane1 = new JScrollPane(this.tabelaMaterial);
        this.textCodigoOrigem = new TTextField(5, 1);
        this.textCodigoDestino = new TTextField(5, 1);
        this.labelDescOrigem = new JLabel();
        this.labelDescDestino = new JLabel();
        this.panelBotoes = new JPanel();
        this.buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
        this.buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this);
        this.buttonImportarTransferencia = ComponenteFactory.novoJButton("Importar Transfer\u00eancia", 'T', this);
        this.buttonImportarRequisicao = ComponenteFactory.novoJButton("Importar Requisi\u00e7\u00e3o", 'R', this);
        this.buttonConfirmar = ComponenteFactory.novoJButton("Conferir Transfer\u00eancia", 'f', this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelCentro, "Center");
        Funcoes.criaBarraDescricao(this, "Confer\u00eancia de Transfer\u00eancia", "Confirma a Transfer\u00eancia de materiais entre c\u00e9lulas de estoque", "estoque/conferencia_transferencia.jpg");
        this.panelCentro.setLayout(new GridBagLayout());
        Funcoes.montaEnter((JComponent)this.panelCentro);
        this.panelCentro.setBorder(ScreenUtil.criarBordaVazia());
        this.labelVlrUsuario.setMinimumSize(new Dimension(90, 20));
        this.labelVlrUsuario.setMaximumSize(new Dimension(90, 20));
        this.labelVlrUsuario.setPreferredSize(new Dimension(90, 20));
        this.labelVlrData.setMinimumSize(new Dimension(150, 20));
        this.labelVlrData.setMaximumSize(new Dimension(150, 20));
        this.labelVlrData.setPreferredSize(new Dimension(150, 20));
        this.modeloMaterial.setColumnSize(new int[]{70, 0, 150}, this.tabelaMaterial);
        JPanel panelCabecalho = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        panelCabecalho.add((Component)this.labelData, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = new Insets(1, 0, 0, 20);
        panelCabecalho.add((Component)this.labelVlrData, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        panelCabecalho.add((Component)this.labelUsuario, gridBagConstraints);
        ++gridBagConstraints.gridx;
        panelCabecalho.add((Component)this.labelVlrUsuario, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        panelCabecalho.add((Component)new JLabel(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 0, 10, 0);
        gridBagConstraints.gridwidth = 4;
        this.panelCentro.add((Component)panelCabecalho, gridBagConstraints);
        this.labelOrigem.setText("C\u00e9lula Origem:");
        this.labelOrigem.setDisplayedMnemonic('O');
        this.labelOrigem.setLabelFor(this.textCodigoOrigem);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        this.panelCentro.add((Component)this.labelOrigem, gridBagConstraints);
        this.labelDestino.setText("C\u00e9lula Destino:");
        this.labelDestino.setDisplayedMnemonic('D');
        this.labelDestino.setLabelFor(this.textCodigoDestino);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.panelCentro.add((Component)this.labelDestino, gridBagConstraints);
        this.panelMaterial.setBorder(BorderFactory.createTitledBorder("Materiais"));
        this.panelMaterial.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelMaterial.add((Component)this.jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelCentro.add((Component)this.panelMaterial, gridBagConstraints);
        this.textCodigoOrigem.setMinimumSize(new Dimension(70, 20));
        this.textCodigoOrigem.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        this.panelCentro.add((Component)this.textCodigoOrigem, gridBagConstraints);
        this.textCodigoDestino.setMinimumSize(new Dimension(70, 20));
        this.textCodigoDestino.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.panelCentro.add((Component)this.textCodigoDestino, gridBagConstraints);
        this.labelDescOrigem.setBorder(BorderFactory.createTitledBorder(""));
        this.labelDescOrigem.setMinimumSize(new Dimension(56, 20));
        this.labelDescOrigem.setPreferredSize(new Dimension(56, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        this.panelCentro.add((Component)this.labelDescOrigem, gridBagConstraints);
        this.labelDescDestino.setBorder(BorderFactory.createTitledBorder(""));
        this.labelDescDestino.setMinimumSize(new Dimension(56, 20));
        this.labelDescDestino.setPreferredSize(new Dimension(56, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelCentro.add((Component)this.labelDescDestino, gridBagConstraints);
        JPanel panelBotoesBasicos = new JPanel(new FlowLayout(2));
        panelBotoesBasicos.add(this.buttonImportarTransferencia);
        panelBotoesBasicos.add(this.buttonImportarRequisicao);
        panelBotoesBasicos.add(this.buttonConfirmar);
        panelBotoesBasicos.add(this.buttonCancelar);
        panelBotoesBasicos.add(this.buttonFechar);
        this.panelBotoes.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panelBotoes.add((Component)panelBotoesBasicos, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panelCentro.add((Component)this.panelBotoes, gridBagConstraints);
    }

    public static long getModuloAcesso() {
        return Long.parseLong("1200300900");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonCancelar) {
            this.cancelar();
        } else if (e.getSource() == this.buttonFechar) {
            this.fechar();
        } else if (e.getSource() == this.buttonImportarTransferencia) {
            this.importarTransferencia();
        } else if (e.getSource() == this.buttonImportarRequisicao) {
            this.importarRequisicao();
        } else if (e.getSource() == this.buttonConfirmar) {
            this.confirmar();
        }
    }

    private void preencherDadosRequisicao(RequisicaoEstoqueBean requisicao) {
        this.novo();
        try {
            this.transferenciaAux = new RequisicaoEstoqueService().getTransfEstoqueRequisicao(Variaveis.filialPadrao, requisicao.getCodigo().toString());
        }
        catch (ThreadDaoException e) {
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel carregar os dados da Transfer\u00eancia de Estoque.", 2);
            this.limparCampos();
            return;
        }
        if (this.transferenciaAux.getCelulaDestino() != null && !this.transferenciaAux.getCelulaDestino().getInativa().booleanValue()) {
            this.textCodigoDestino.setText(this.transferenciaAux.getCelulaDestino().getCodigo().toString());
            this.labelDescDestino.setText(this.transferenciaAux.getCelulaDestino().getDescricao());
        }
        if (this.transferenciaAux.getCelulaOrigem() != null && !this.transferenciaAux.getCelulaOrigem().getInativa().booleanValue()) {
            this.textCodigoOrigem.setText(this.transferenciaAux.getCelulaOrigem().getCodigo().toString());
            this.labelDescOrigem.setText(this.transferenciaAux.getCelulaOrigem().getDescricao());
        }
        ArrayList<RequisicaoEstoqueMaterialBean> materiais = requisicao.getMateriais();
        for (int i = 0; i < materiais.size(); ++i) {
            RequisicaoEstoqueMaterialBean material = materiais.get(i);
            this.modeloMaterial.addLine(new Object[]{material.getMaterial().getCodigo(), material.getMaterial().getDescricao(), Funcoes.formataDecimal(material.getQuantidade()), null});
        }
        this.controlaCampos();
    }

    private void preencherDadosTransferenciaEstoque(TransfEstoqueBean transferencia) {
        this.novo();
        this.transferenciaAux = transferencia;
        if (this.transferenciaAux.getCelulaDestino() != null && !this.transferenciaAux.getCelulaDestino().getInativa().booleanValue()) {
            this.textCodigoDestino.setText(this.transferenciaAux.getCelulaDestino().getCodigo().toString());
            this.labelDescDestino.setText(this.transferenciaAux.getCelulaDestino().getDescricao());
        }
        if (this.transferenciaAux.getCelulaOrigem() != null && !this.transferenciaAux.getCelulaOrigem().getInativa().booleanValue()) {
            this.textCodigoOrigem.setText(this.transferenciaAux.getCelulaOrigem().getCodigo().toString());
            this.labelDescOrigem.setText(this.transferenciaAux.getCelulaOrigem().getDescricao());
        }
        ArrayList<TransfEstoqueMaterialBean> materiais = transferencia.getMateriais();
        for (int i = 0; i < materiais.size(); ++i) {
            TransfEstoqueMaterialBean material = materiais.get(i);
            this.modeloMaterial.addLine(new Object[]{material.getMaterial().getCodigo(), material.getMaterial().getDescricao(), Funcoes.formataDecimal(material.getQuantidade()), null});
        }
        this.controlaCampos();
    }

    private void limparCampos() {
        this.textCodigoDestino.clear();
        this.textCodigoOrigem.clear();
        this.modeloMaterial.clear();
        this.labelDescDestino.setText("");
        this.labelDescOrigem.setText("");
        this.labelVlrData.setText("");
        this.labelVlrUsuario.setText("");
        this.transferenciaAux = null;
        this.dataAux = null;
        this.usuarioAux = null;
    }

    private void setStatus(int status) {
        this.status = status;
        this.controlaCampos();
    }

    private void controlaCampos() {
        this.buttonFechar.setEnabled(this.status == 1);
        this.buttonCancelar.setEnabled(this.status == 3);
        this.textCodigoDestino.setEnabled(false);
        this.textCodigoOrigem.setEnabled(false);
        if (this.transferenciaAux != null) {
            this.buttonImportarRequisicao.setEnabled(false);
            this.buttonImportarTransferencia.setEnabled(false);
            this.buttonConfirmar.setEnabled(true);
        } else {
            this.buttonImportarRequisicao.setEnabled(true);
            this.buttonImportarTransferencia.setEnabled(true);
            this.buttonConfirmar.setEnabled(false);
        }
    }

    private void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
        }
    }

    private void novo() {
        this.limparCampos();
        this.setStatus(3);
        UsuarioVO usuario = new UsuarioVO();
        usuario.setCodigo(Variaveis.login);
        this.usuarioAux = usuario;
        this.dataAux = new Date();
        this.labelVlrUsuario.setText(this.usuarioAux.getCodigo());
        this.labelVlrData.setText(Funcoes.formataData(this.dataAux) + " " + Funcoes.formataHora(this.dataAux, true));
        ScreenUtil.requisitarFoco(this.textCodigoOrigem);
    }

    private void fechar() {
        this.setVisible(false);
    }

    private void importarTransferencia() {
        Hashtable transf = new TransfEstoqueService().pesquisaTransfEstoqueNaoConciliadaVO(Laboratorio.getInstancia(), false);
        if (transf != null) {
            Integer codigo = (Integer)transf.get("tra_codigo");
            TransfEstoqueBean bean = null;
            try {
                bean = (TransfEstoqueBean)new TransfEstoqueService().get(Variaveis.filialPadrao, codigo.toString(), false);
            }
            catch (Exception e) {
                Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel carregar os dados da Transfer\u00eancia de Estoque.", 2);
                return;
            }
            if (bean != null) {
                this.preencherDadosTransferenciaEstoque(bean);
            }
            ScreenUtil.requisitarFoco(this.tabelaMaterial);
            this.tabelaMaterial.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private void importarRequisicao() {
        Hashtable req = new RequisicaoEstoqueService().pesquisaRequisicaoEstoqueNaoConciliadaVO(Laboratorio.getInstancia());
        if (req != null) {
            Integer codigo = (Integer)req.get("ree_codigo");
            RequisicaoEstoqueBean bean = null;
            try {
                bean = (RequisicaoEstoqueBean)new RequisicaoEstoqueService().get(Variaveis.filialPadrao, codigo.toString());
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar os dados da Requisi\u00e7\u00e3o de Estoque.\n" + e.getMessage(), e.getStackTrace());
                return;
            }
            try {
                TransfEstoqueBean transferencia = new RequisicaoEstoqueService().getTransfEstoqueRequisicao(bean.getFilial().getCodigo().toString(), bean.getCodigo().toString());
                if (bean != null) {
                    this.preencherDadosTransferenciaEstoque(transferencia);
                }
            }
            catch (ThreadDaoException e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar os dados da Transfer\u00eancia associada \u00e0 Requisi\u00e7\u00e3o de Estoque.\n" + e.getMessage(), e.getStackTrace());
                return;
            }
            ScreenUtil.requisitarFoco(this.tabelaMaterial);
            this.tabelaMaterial.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private void confirmar() {
        try {
            new TransfEstoqueService().conciliaTransferencia(this.transferenciaAux);
            Conexao.arquivaSQL();
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel confirmar a Transfer\u00eancia de Estoque. " + e.getMessage(), e.getStackTrace());
        }
    }
}

