/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.estoque.almoxarifado;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.DadosPatrimonio;
import jalis.laboratorio.cadastro.Patrimonio;
import jalis.laboratorio.cadastro.VisualizarMateriaisAlternativos;
import jalis.laboratorio.estoque.SolicitarLoteMaterial;
import jalis.laboratorio.estoque.almoxarifado.DialogoAnaliseCritica;
import jalis.laboratorio.estoque.almoxarifado.PerguntarValorEstoque;
import jalis.model.bean.estoque.CelulaEstoqueBean;
import jalis.model.bean.estoque.ConferenciaEstoqueBean;
import jalis.model.bean.estoque.ConferenciaEstoqueLanctoEstoqueBean;
import jalis.model.bean.estoque.ConferenciaEstoqueMaterialBean;
import jalis.model.bean.estoque.MaterialBean;
import jalis.model.bean.estoque.MaterialLoteBean;
import jalis.model.bean.estoque.MaterialPatrimonioBean;
import jalis.model.bean.estoque.SaldoEstoqueCelulaBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.estoque.CelulaEstoqueVO;
import jalis.model.vo.estoque.MaterialVO;
import jalis.service.estoque.CelulaEstoqueService;
import jalis.service.estoque.ConferenciaEstoqueLanctoEstoqueService;
import jalis.service.estoque.ConferenciaEstoqueService;
import jalis.service.estoque.MaterialPatrimonioService;
import jalis.service.estoque.MaterialService;
import jalis.service.estoque.SaldoEstoqueCelulaService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextAreaDocument;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;

public class ConferenciaEstoque
extends FrmPadrao
implements ActionListener,
FocusListener {
    private JButton buttonBuscaCelula = ComponenteFactory.novoJButton(this, true);
    private JButton buttonBuscaMaterial = ComponenteFactory.novoJButton(this, true);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this);
    private JButton buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', this);
    private JButton buttonSalvar = ComponenteFactory.novoJButton("Salvar", 'S', this);
    private JButton buttonOK = ComponenteFactory.novoJButton("OK", '\u0000', this);
    private JTable tabelaMaterial;
    private JScrollPane jScrollPane1;
    private JLabel labelAtual;
    private JLabel labelCelula;
    private JLabel labelData;
    private JLabel labelDescCelula;
    private JLabel labelDescData;
    private JLabel labelDescMaterial;
    private JLabel labelDescUsuario;
    private JLabel labelMaterial;
    private JLabel labelNova;
    private JLabel labelQtdeAtual;
    private JLabel labelUsuario;
    private JPanel panelBotoes;
    private JPanel panelCelula;
    private JPanel panelData;
    private TTextField textCodigoCelula = new TTextField(5, 1);
    private TTextField textCodigoMaterial = new TTextField(18, 3);
    private TTextField textQuantidade = new TTextField(10, 2);
    private ModeloGridTable modelo = null;
    private JPanel panelCentro = new JPanel(new GridBagLayout());
    private JLabel labelObs = new JLabel("Observa\u00e7\u00e3o:");
    private JTextArea textObs = new JTextArea(new TTextAreaDocument(500));
    private JScrollPane scrollObs = new JScrollPane(this.textObs);
    private int status = 1;
    private Date dataAux = null;
    private UsuarioVO usuarioAux = null;
    private MaterialBean materialAux = null;
    private CelulaEstoqueVO celulaAux = null;
    private boolean isAlterandoMaterial = false;
    private int linhaSelecionada = -1;
    private static final Color COR_SOLICITA_PATRIMONIO = ScreenUtil.clarearCor(Color.YELLOW, 125);
    private final int COLUNA_CODIGO = 0;
    private final int COLUNA_MATERIAL = 1;
    private final int COLUNA_QTDE_ATUAL = 2;
    private final int COLUNA_NOVA_QTDE = 3;
    private final int COLUNA_OBJETO = 4;
    private final int COLUNA_OBJETO_MATERIAL = 5;
    private final int COLUNA_PATRIMONIOS = 6;
    private final int COLUNA_OPERACAO = 7;
    private final int OPERACAO_ADICAO = 0;
    private final int OPERACAO_SUBTRACAO = 1;
    private final int CASAS_MAIOR = 4;
    private final RoundingMode ROUND = ParametrosGerais.getArredondamentoPrecoExame();

    public ConferenciaEstoque() {
        this.montaTela();
        this.controlaCampos();
    }

    private void montaTela() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelCentro, "Center");
        Funcoes.criaBarraDescricao(this, "Confer\u00eancia de Estoque", "Confer\u00eancia dos materiais em estoque", "estoque/conferencia_estoque.jpg");
        Funcoes.montaEnter((JComponent)this.panelCentro);
        this.panelCentro.setBorder(ScreenUtil.criarBordaVazia());
        this.panelBotoes = new JPanel();
        this.labelMaterial = new JLabel();
        this.labelAtual = new JLabel();
        this.labelNova = new JLabel();
        this.labelCelula = new JLabel();
        this.panelData = new JPanel();
        this.labelUsuario = new JLabel();
        this.labelDescData = new JLabel();
        this.labelDescUsuario = new JLabel();
        this.labelData = new JLabel();
        this.labelDescMaterial = new JLabel();
        this.labelQtdeAtual = new JLabel();
        this.panelCelula = new JPanel();
        this.labelDescCelula = new JLabel();
        this.modelo = new ModeloGridTable(new String[]{"C\u00f3digo", "Material", "Qtde. atual", "Nova Qtde."}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return super.getColumnClass(columnIndex);
            }
        };
        this.tabelaMaterial = new JTable(this.modelo);
        this.tabelaMaterial.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public synchronized Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
                Component comp = super.getTableCellRendererComponent(table, value, selected, focused, row, column);
                ConferenciaEstoqueMaterialBean aux = (ConferenciaEstoqueMaterialBean)ConferenciaEstoque.this.modelo.getValueAt(row, 4);
                if (aux != null && aux.getMaterial() != null && aux.getMaterial().getSolicitarPatrimonio() != null && aux.getMaterial().getSolicitarPatrimonio().booleanValue()) {
                    comp.setBackground(COR_SOLICITA_PATRIMONIO);
                } else if (!selected) {
                    comp.setBackground(null);
                }
                return comp;
            }
        });
        this.modelo.setColumnSize(new int[]{60, 0, 90, 90}, this.tabelaMaterial);
        this.tabelaMaterial.getTableHeader().addMouseListener(this.modelo);
        this.jScrollPane1 = new JScrollPane(this.tabelaMaterial);
        this.tabelaMaterial.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
            }
        });
        this.tabelaMaterial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int row;
                if (e.getKeyCode() == 127) {
                    int resp = Funcoes.mensagem(ConferenciaEstoque.this, "Deseja remover o material?", 4);
                    if (resp == 0) {
                        int row2 = ((JTable)e.getSource()).getSelectedRow();
                        ConferenciaEstoque.this.modelo.removeLine(row2);
                        ConferenciaEstoque.this.controlaCampos();
                    }
                } else if (e.getKeyCode() == 32 && (row = ((JTable)e.getSource()).getSelectedRow()) >= 0) {
                    ConferenciaEstoqueMaterialBean material = (ConferenciaEstoqueMaterialBean)ConferenciaEstoque.this.modelo.getValueAt(row, 4);
                    MaterialBean beanMaterial = null;
                    try {
                        beanMaterial = (MaterialBean)new MaterialService().getAtivo(String.valueOf(material.getFilial().getCodigo()), String.valueOf(material.getMaterial().getCodigo()), null, null);
                        beanMaterial.setAnaliseCritica(material.getMaterial().getAnaliseCritica());
                    }
                    catch (Exception e1) {
                        Funcoes.mensagem(ConferenciaEstoque.this, "N\u00e3o foi poss\u00edvel carregar os dados do material.", 2);
                        return;
                    }
                    ConferenciaEstoque.this.isAlterandoMaterial = true;
                    ConferenciaEstoque.this.linhaSelecionada = row;
                    ConferenciaEstoque.this.materialAux = beanMaterial;
                    ConferenciaEstoque.this.textCodigoMaterial.setText(String.valueOf(beanMaterial.getCodigo()));
                    ConferenciaEstoque.this.labelDescMaterial.setText(beanMaterial.getDescricao());
                    ConferenciaEstoque.this.labelQtdeAtual.setText(Funcoes.formataDecimal(material.getQuantidadeAtual()));
                    ConferenciaEstoque.this.textQuantidade.setText(Funcoes.formataDecimal(material.getQuantidadeNova()));
                    ConferenciaEstoque.this.controlaCampos();
                    ScreenUtil.requisitarFoco(ConferenciaEstoque.this.textQuantidade);
                }
            }
        });
        this.tabelaMaterial.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ConferenciaEstoque.this.isAlterandoMaterial) {
                    ConferenciaEstoque.this.textCodigoMaterial.setText("");
                    ConferenciaEstoque.this.labelDescMaterial.setText("");
                    ConferenciaEstoque.this.labelQtdeAtual.setText("");
                    ConferenciaEstoque.this.textQuantidade.setText("");
                    ConferenciaEstoque.this.isAlterandoMaterial = false;
                    ConferenciaEstoque.this.linhaSelecionada = -1;
                    ConferenciaEstoque.this.controlaCampos();
                }
            }
        });
        this.labelData.setText("Data:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        this.panelCentro.add((Component)this.labelData, gridBagConstraints);
        this.panelBotoes.setLayout(new FlowLayout(2));
        this.buttonNovo.setText("Novo");
        this.panelBotoes.add(this.buttonNovo);
        this.buttonSalvar.setText("Salvar");
        this.panelBotoes.add(this.buttonSalvar);
        this.buttonCancelar.setText("Cancelar");
        this.panelBotoes.add(this.buttonCancelar);
        this.buttonFechar.setText("Fechar");
        this.panelBotoes.add(this.buttonFechar);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panelCentro.add((Component)this.panelBotoes, gridBagConstraints);
        this.labelMaterial.setDisplayedMnemonic('M');
        this.labelMaterial.setLabelFor(this.textCodigoMaterial);
        this.labelMaterial.setText("Material");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.panelCentro.add((Component)this.labelMaterial, gridBagConstraints);
        this.labelAtual.setText("Qtde. Atual");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.panelCentro.add((Component)this.labelAtual, gridBagConstraints);
        this.labelNova.setDisplayedMnemonic('Q');
        this.labelNova.setLabelFor(this.textQuantidade);
        this.labelNova.setText("Nova Qtde.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.panelCentro.add((Component)this.labelNova, gridBagConstraints);
        this.labelCelula.setDisplayedMnemonic('u');
        this.labelCelula.setLabelFor(this.textCodigoCelula);
        this.labelCelula.setText("C\u00e9lula:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.panelCentro.add((Component)this.labelCelula, gridBagConstraints);
        this.panelData.setPreferredSize(new Dimension(100, 21));
        this.panelData.setLayout(new GridBagLayout());
        this.labelUsuario.setText("Usu\u00e1rio:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(1, 14, 0, 0);
        this.panelData.add((Component)this.labelUsuario, gridBagConstraints);
        this.labelDescData.setBorder(BorderFactory.createTitledBorder(""));
        this.labelDescData.setMinimumSize(new Dimension(24, 20));
        this.labelDescData.setPreferredSize(new Dimension(24, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        this.panelData.add((Component)this.labelDescData, gridBagConstraints);
        this.labelDescUsuario.setBorder(BorderFactory.createTitledBorder(""));
        this.labelDescUsuario.setMinimumSize(new Dimension(24, 20));
        this.labelDescUsuario.setPreferredSize(new Dimension(24, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        this.panelData.add((Component)this.labelDescUsuario, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panelCentro.add((Component)this.panelData, gridBagConstraints);
        this.buttonBuscaMaterial.setMaximumSize(new Dimension(20, 20));
        this.buttonBuscaMaterial.setMinimumSize(new Dimension(20, 20));
        this.buttonBuscaMaterial.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.panelCentro.add((Component)this.buttonBuscaMaterial, gridBagConstraints);
        this.buttonOK.setText("OK");
        this.buttonOK.setMnemonic('O');
        this.buttonOK.setMargin(new Insets(1, 1, 1, 1));
        this.buttonOK.setMaximumSize(new Dimension(40, 20));
        this.buttonOK.setMinimumSize(new Dimension(40, 20));
        this.buttonOK.setPreferredSize(new Dimension(40, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.panelCentro.add((Component)this.buttonOK, gridBagConstraints);
        this.labelDescMaterial.setBorder(BorderFactory.createTitledBorder(""));
        this.labelDescMaterial.setMaximumSize(new Dimension(12, 20));
        this.labelDescMaterial.setMinimumSize(new Dimension(12, 20));
        this.labelDescMaterial.setPreferredSize(new Dimension(12, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelCentro.add((Component)this.labelDescMaterial, gridBagConstraints);
        this.labelQtdeAtual.setHorizontalAlignment(4);
        this.labelQtdeAtual.setBorder(BorderFactory.createTitledBorder(""));
        this.labelQtdeAtual.setMinimumSize(new Dimension(100, 20));
        this.labelQtdeAtual.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.panelCentro.add((Component)this.labelQtdeAtual, gridBagConstraints);
        this.textCodigoMaterial.addFocusListener(this);
        this.textCodigoMaterial.setMinimumSize(new Dimension(70, 20));
        this.textCodigoMaterial.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.panelCentro.add((Component)this.textCodigoMaterial, gridBagConstraints);
        this.textQuantidade.setMinimumSize(new Dimension(100, 20));
        this.textQuantidade.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.panelCentro.add((Component)this.textQuantidade, gridBagConstraints);
        this.panelCelula.setLayout(new GridBagLayout());
        this.textCodigoCelula.addFocusListener(this);
        this.textCodigoCelula.setMinimumSize(new Dimension(70, 20));
        this.textCodigoCelula.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.panelCelula.add((Component)this.textCodigoCelula, gridBagConstraints);
        this.buttonBuscaCelula.setMaximumSize(new Dimension(20, 20));
        this.buttonBuscaCelula.setMinimumSize(new Dimension(20, 20));
        this.buttonBuscaCelula.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.panelCelula.add((Component)this.buttonBuscaCelula, gridBagConstraints);
        this.labelDescCelula.setBorder(BorderFactory.createTitledBorder(""));
        this.labelDescCelula.setMaximumSize(new Dimension(40, 20));
        this.labelDescCelula.setMinimumSize(new Dimension(40, 20));
        this.labelDescCelula.setPreferredSize(new Dimension(40, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelCelula.add((Component)this.labelDescCelula, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelCentro.add((Component)this.panelCelula, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelCentro.add((Component)this.jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        this.labelObs.setDisplayedMnemonic('b');
        this.labelObs.setLabelFor(this.textObs);
        this.panelCentro.add((Component)this.labelObs, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.scrollObs.setPreferredSize(new Dimension(100, 60));
        this.scrollObs.setMinimumSize(new Dimension(100, 60));
        this.scrollObs.setMaximumSize(new Dimension(100, 60));
        this.panelCentro.add((Component)this.scrollObs, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panelCentro.add((Component)this.montaPainelLegenda(), gridBagConstraints);
    }

    private JPanel montaPainelLegenda() {
        JPanel pnlLegenda = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        JPanel pnlCorLegenda = new JPanel();
        pnlCorLegenda.setPreferredSize(new Dimension(10, 10));
        pnlCorLegenda.setBackground(COR_SOLICITA_PATRIMONIO);
        pnlCorLegenda.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        pnlLegenda.add((Component)pnlCorLegenda, c);
        JLabel lblLegenda = new JLabel("Material solicita patrim\u00f4nio");
        Font font = new Font(lblLegenda.getFont().getName(), 0, 10);
        lblLegenda.setFont(font);
        ++c.gridx;
        pnlLegenda.add((Component)lblLegenda, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        pnlLegenda.add((Component)new JLabel(), c);
        return pnlLegenda;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("1200300500");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonFechar) {
            this.fechar();
        } else if (e.getSource() == this.buttonNovo) {
            this.novo();
        } else if (e.getSource() == this.buttonCancelar) {
            this.cancelar();
        } else if (e.getSource() == this.buttonSalvar) {
            this.salvar();
        } else if (e.getSource() == this.buttonBuscaCelula) {
            this.pesquisaCelula();
        } else if (e.getSource() == this.buttonBuscaMaterial) {
            this.pesquisaMaterial(null);
        } else if (e.getSource() == this.buttonOK) {
            if (this.materialAux == null) {
                Funcoes.mensagem(this, "O material deve ser selecionado.", 2);
                if (this.textCodigoMaterial.isEnabled() && this.textCodigoMaterial.isFocusable()) {
                    this.textCodigoMaterial.selectAll();
                    ScreenUtil.requisitarFoco(this.textCodigoMaterial);
                }
                return;
            }
            if (this.textQuantidade.getText().isEmpty()) {
                Funcoes.mensagem(this, "A nova quantidade deve ser informada.", 2);
                if (this.textQuantidade.isEnabled() && this.textQuantidade.isFocusable()) {
                    ScreenUtil.requisitarFoco(this.textQuantidade);
                }
                return;
            }
            ConferenciaEstoqueMaterialBean material = new ConferenciaEstoqueMaterialBean();
            FilialVO filial = new FilialVO();
            filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
            material.setFilial(filial);
            material.setMaterial((MaterialVO)this.materialAux.toVO());
            material.setQuantidadeAtual(Double.parseDouble(Funcoes.limpaDecimal(this.labelQtdeAtual.getText())));
            material.setQuantidadeNova(Double.parseDouble(Funcoes.limpaDecimal(this.textQuantidade.getText())));
            if (ParametrosGerais.isSolicitaAnaliseCriticaMovimentarMateriaisEstoque()) {
                DialogoAnaliseCritica analiseCritica = DialogoAnaliseCritica.novaInstancia(Laboratorio.getInstancia());
                if (this.isAlterandoMaterial) {
                    analiseCritica.setAnalise(this.materialAux.getAnaliseCritica());
                }
                analiseCritica.setVisible(true);
                if (analiseCritica.getOK()) {
                    this.materialAux.setAnaliseCritica(analiseCritica.getAnalise());
                    material.getMaterial().setAnaliseCritica(analiseCritica.getAnalise());
                    material.setMaterial((MaterialVO)this.materialAux.toVO());
                }
            }
            if (this.adicionaMaterial(material)) {
                this.textCodigoMaterial.setText("");
                this.labelDescMaterial.setText("");
                this.textQuantidade.setText("");
                this.labelQtdeAtual.setText("");
                this.isAlterandoMaterial = false;
                this.linhaSelecionada = -1;
                this.materialAux = null;
            }
            if (this.textCodigoMaterial.isFocusable() && this.textCodigoMaterial.isEnabled()) {
                this.textCodigoMaterial.grabFocus();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean adicionaMaterial(ConferenciaEstoqueMaterialBean material) {
        int operacaoAtual = material.getQuantidadeAtual() < material.getQuantidadeNova() ? 0 : 1;
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            ConferenciaEstoqueMaterialBean aux = (ConferenciaEstoqueMaterialBean)this.modelo.getValueAt(i, 4);
            if (aux == null || aux.getMaterial().getCodigo().intValue() != this.materialAux.getCodigo().intValue() || this.isAlterandoMaterial) continue;
            Funcoes.mensagem(this, "Material j\u00e1 inserido.", 2);
            if (!this.textCodigoMaterial.isFocusable() || !this.textCodigoMaterial.isEnabled()) return false;
            this.textCodigoMaterial.grabFocus();
            return false;
        }
        if (!ParametrosGerais.getPerguntarValorEstoque().equals("N") && material.getQuantidadeAtual() < material.getQuantidadeNova()) {
            PerguntarValorEstoque tela = new PerguntarValorEstoque((Frame)Laboratorio.getInstancia(), material.getMaterial().getCodigo().toString(), this.textQuantidade.getText());
            tela.setValorUnitario(material.getValorUnitario());
            tela.setVisible(true);
            material.setValorUnitario(tela.getValorUnitario());
        }
        MaterialBean matBean = null;
        ArrayList<DadosPatrimonio> listaPatrimonios = null;
        try {
            int operacaoAnterior;
            matBean = this.isAlterandoMaterial ? (operacaoAtual == (operacaoAnterior = ((Integer)this.modelo.getValueAt(this.linhaSelecionada, 7)).intValue()) ? (MaterialBean)this.modelo.getValueAt(this.linhaSelecionada, 5) : (MaterialBean)new MaterialService().getTodos(material.getFilial().getCodigo().toString(), material.getMaterial().getCodigo().toString(), false)) : (MaterialBean)new MaterialService().getTodos(material.getFilial().getCodigo().toString(), material.getMaterial().getCodigo().toString(), false);
            listaPatrimonios = this.configurarPatrimonios(matBean, Math.abs(material.getQuantidadeAtual() - material.getQuantidadeNova()), operacaoAtual, this.linhaSelecionada);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel configurar os patrim\u00f4nios.\n" + e.getMessage(), e.getStackTrace());
        }
        if (matBean != null) {
            if (material.getQuantidadeAtual() < material.getQuantidadeNova()) {
                if (matBean.getSolicitarLote().booleanValue()) {
                    Double qtdeOriginal = matBean.getQuantidadeLotes(this.celulaAux) - matBean.getQuantidadeConsumidaLotes(this.celulaAux);
                    Double qtdeInserir = material.getQuantidadeNova() - material.getQuantidadeAtual();
                    SolicitarLoteMaterial lote = new SolicitarLoteMaterial(Laboratorio.getInstancia(), matBean.getCodigo(), matBean.getDescricao(), matBean.getUnidadeMedida().getCodigo(), matBean.getFichaTecnica(), matBean.getLotes(), 0, qtdeOriginal, qtdeInserir, null, null, this.celulaAux, false, null, false);
                    if (lote != null) {
                        lote.setVisible(true);
                        if (!lote.getOK()) return false;
                        matBean.setLotes(lote.getLotes());
                    }
                }
            } else if (material.getQuantidadeAtual() > material.getQuantidadeNova() && matBean.getSolicitarLote().booleanValue()) {
                Double qtdeOriginal = matBean.getQuantidadeLotes(this.celulaAux) - matBean.getQuantidadeConsumidaOriginalLotes(this.celulaAux);
                Double qtdeRemover = material.getQuantidadeAtual() - material.getQuantidadeNova();
                SolicitarLoteMaterial lote = new SolicitarLoteMaterial(Laboratorio.getInstancia(), matBean.getCodigo(), matBean.getDescricao(), matBean.getUnidadeMedida().getCodigo(), matBean.getFichaTecnica(), matBean.getLotes(), 1, qtdeOriginal, null, qtdeRemover, qtdeOriginal, this.celulaAux, false, null, false);
                if (lote != null) {
                    lote.setVisible(true);
                    if (!lote.getOK()) return false;
                    matBean.setLotes(lote.getLotes());
                }
            }
        }
        if (this.isAlterandoMaterial) {
            this.modelo.setValueAt(material.getMaterial().getCodigo(), this.linhaSelecionada, 0);
            this.modelo.setValueAt(material.getMaterial().getDescricao(), this.linhaSelecionada, 1);
            this.modelo.setValueAt(Funcoes.formataDecimal(material.getQuantidadeAtual()), this.linhaSelecionada, 2);
            this.modelo.setValueAt(Funcoes.formataDecimal(material.getQuantidadeNova()), this.linhaSelecionada, 3);
            this.modelo.setValueAt(material, this.linhaSelecionada, 4);
            this.modelo.setValueAt(matBean, this.linhaSelecionada, 5);
            this.modelo.setValueAt(listaPatrimonios, this.linhaSelecionada, 6);
            this.modelo.setValueAt(operacaoAtual, this.linhaSelecionada, 7);
        } else {
            this.modelo.addLine(new Object[]{material.getMaterial().getCodigo(), material.getMaterial().getDescricao(), Funcoes.formataDecimal(material.getQuantidadeAtual()), Funcoes.formataDecimal(material.getQuantidadeNova()), material, matBean, listaPatrimonios, operacaoAtual});
        }
        if (this.modelo.getColunaOrdenacao() != -1) {
            this.modelo.ordenarColunaSemTrocarSentido(this.modelo.getColunaOrdenacao());
        } else {
            this.modelo.ordenarColunaSemTrocarSentido(1);
        }
        this.controlaCampos();
        return true;
    }

    private ArrayList<DadosPatrimonio> configurarPatrimonios(MaterialBean beanMat, Double quantidade, int tipoOperacao, int row) {
        ArrayList<DadosPatrimonio> dadosPatrimonio;
        block32: {
            if (beanMat == null || beanMat.getSolicitarPatrimonio() == null || !beanMat.getSolicitarPatrimonio().booleanValue() || quantidade == 0.0) {
                return null;
            }
            ArrayList<MaterialPatrimonioBean> patrimonios = beanMat.getPatrimonios();
            dadosPatrimonio = null;
            if (tipoOperacao == 1 && (patrimonios == null || (double)patrimonios.size() < quantidade) && beanMat.getSolicitarPatrimonio() != null && beanMat.getSolicitarPatrimonio().booleanValue()) {
                if (patrimonios == null) {
                    Funcoes.mensagem(this, "N\u00e3o h\u00e1 patrim\u00f4nios definidos para o material.\nConfigure os patrim\u00f4nios do material no Cadastro de Material.", 2);
                } else {
                    Funcoes.mensagem(this, "A quantidade de patrim\u00f4nios definidos no Cadastro de Material\n\u00e9 inferior a " + Funcoes.formataDecimal(quantidade) + ".\nConfigure os patrim\u00f4nios em falta no Cadastro de Material.", 2);
                }
                this.textCodigoMaterial.selectAll();
                this.textCodigoMaterial.grabFocus();
                return null;
            }
            dadosPatrimonio = row >= 0 ? (ArrayList<DadosPatrimonio>)this.modelo.getValueAt(row, 6) : new ArrayList<DadosPatrimonio>();
            MaterialPatrimonioService servicePatrimonioMaterial = new MaterialPatrimonioService();
            if (!this.isAlterandoMaterial && patrimonios != null) {
                for (int i = 0; i < patrimonios.size(); ++i) {
                    MaterialPatrimonioBean patrimonioBean = patrimonios.get(i);
                    DadosPatrimonio auxAdiciona = null;
                    try {
                        auxAdiciona = new DadosPatrimonio(beanMat, patrimonioBean.getPatrimonio(), patrimonioBean.getSerie(), patrimonioBean.getNumeroNotaFiscal() == null ? "" : patrimonioBean.getNumeroNotaFiscal().toString(), patrimonioBean.getSetor(), servicePatrimonioMaterial.podeAlterarPatrimonioMaterial(Variaveis.filialPadrao, beanMat.getCodigo().toString(), patrimonioBean.getPatrimonio()), false);
                    }
                    catch (Exception e) {
                        continue;
                    }
                    dadosPatrimonio.add(auxAdiciona);
                }
            }
            Patrimonio p = null;
            if (tipoOperacao == 1) {
                p = Patrimonio.novaInstancia(this.getTopLevelAncestor(), true);
                p.setTitle("Selecione o(s) " + quantidade.intValue() + " patrim\u00f4nio(s) a serem removido(s)");
            } else {
                p = Patrimonio.novaInstancia(this.getTopLevelAncestor(), false);
                if (p != null) {
                    p.setTitle("Insira o(s) " + quantidade.intValue() + " novo(s) patrim\u00f4nio(s)");
                }
            }
            if (p != null) {
                block31: {
                    while (true) {
                        int qtdeAnt = dadosPatrimonio.size();
                        p.setPatrimonios(dadosPatrimonio.size() == 0 ? null : dadosPatrimonio);
                        p.setVisible(true);
                        if (!p.getOK()) break block31;
                        dadosPatrimonio = p.getPatrimonios();
                        int qtde = 0;
                        for (int i = 0; i < dadosPatrimonio.size(); ++i) {
                            if (!dadosPatrimonio.get(i).isSelecionado()) continue;
                            ++qtde;
                        }
                        if ((double)qtde < quantidade && tipoOperacao == 1) {
                            Funcoes.mensagem(this, "A quantidade de patrim\u00f4nios selecionada \u00e9 inferior \u00e0 quantidade a ser removida.\nDeve-se selecionar " + Funcoes.formataDecimal(quantidade) + " patrim\u00f4nio(s).", 2);
                            continue;
                        }
                        if ((double)qtde > quantidade && tipoOperacao == 1) {
                            Funcoes.mensagem(this, "A quantidade de patrim\u00f4nios selecionada \u00e9 superior \u00e0 quantidade a ser removida.\nDeve-se selecionar apenas " + Funcoes.formataDecimal(quantidade) + " patrim\u00f4nio(s).", 2);
                            continue;
                        }
                        if ((double)dadosPatrimonio.size() < quantidade + (double)qtdeAnt && tipoOperacao == 0) {
                            Funcoes.mensagem(this, "A quantidade de patrim\u00f4nios informada \u00e9 inferior \u00e0 quantidade a ser adicionada.\nDeve-se informar " + Funcoes.formataDecimal(quantidade) + " patrim\u00f4nio(s).", 2);
                            continue;
                        }
                        if (!((double)dadosPatrimonio.size() > quantidade) || tipoOperacao != 0) break;
                        Funcoes.mensagem(this, "A quantidade de patrim\u00f4nios informada \u00e9 superior \u00e0 quantidade a ser adicionada.\nDeve-se informar apenas " + Funcoes.formataDecimal(quantidade) + " patrim\u00f4nio(s).", 2);
                    }
                    ArrayList<MaterialPatrimonioBean> listaPatrimonios = new ArrayList<MaterialPatrimonioBean>();
                    if (patrimonios != null) {
                        for (int i = 0; i < dadosPatrimonio.size(); ++i) {
                            DadosPatrimonio dados = dadosPatrimonio.get(i);
                            MaterialPatrimonioBean patrimonio = new MaterialPatrimonioBean();
                            patrimonio.setFilial(beanMat.getFilial());
                            patrimonio.setMaterial((MaterialVO)beanMat.toVO());
                            patrimonio.setNumeroNotaFiscal(Funcoes.textoVazio(dados.getNotaFiscal()) ? null : Integer.valueOf(Integer.parseInt(dados.getNotaFiscal())));
                            patrimonio.setSerie(dados.getSerie());
                            patrimonio.setPatrimonio(dados.getPatrimonio());
                            patrimonio.setSetor(dados.getSetor());
                            if (tipoOperacao == 1 && dados.isSelecionado()) {
                                patrimonio.setInutilizado(true);
                            } else {
                                patrimonio.setInutilizado(false);
                            }
                            listaPatrimonios.add(patrimonio);
                        }
                    }
                    if (listaPatrimonios.size() > 0) {
                        if (tipoOperacao == 0) {
                            MaterialBean auxMat = null;
                            try {
                                auxMat = (MaterialBean)new MaterialService().getTodos(beanMat.getFilial().getCodigo().toString(), beanMat.getCodigo().toString(), null, null);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (auxMat != null && auxMat.getPatrimonios() != null) {
                                auxMat.getPatrimonios().addAll(listaPatrimonios);
                                beanMat.setPatrimonios(auxMat.getPatrimonios());
                            } else {
                                beanMat.setPatrimonios(listaPatrimonios);
                            }
                        } else {
                            beanMat.setPatrimonios(listaPatrimonios);
                        }
                    }
                    break block32;
                }
                if (!this.isAlterandoMaterial) {
                    if (tipoOperacao == 0) {
                        Funcoes.mensagem(this, "N\u00e3o \u00e9 poss\u00edvel adicionar o(s) material(is) sem informar o(s) patrim\u00f4nio(s).", 2);
                    } else {
                        Funcoes.mensagem(this, "N\u00e3o \u00e9 poss\u00edvel remover o(s) material(is) sem selecionar o(s) patrim\u00f4nio(s).", 2);
                    }
                }
                return null;
            }
        }
        return dadosPatrimonio;
    }

    private void pesquisaCelula() {
        this.celulaAux = null;
        CelulaEstoqueService service = new CelulaEstoqueService();
        CelulaEstoqueVO vo = (CelulaEstoqueVO)service.pesquisaCelulasAtivasVO(this.getTopLevelAncestor(), new CelulaEstoqueVO(), "Pesquisando C\u00e9lulas de Estoque", false);
        if (vo != null) {
            this.textCodigoCelula.setText(String.valueOf(vo.getCodigo()));
            this.labelDescCelula.setText(vo.getDescricao());
            this.celulaAux = vo;
        } else {
            this.textCodigoCelula.clear();
            this.labelDescCelula.setText("");
        }
        this.controlaCampos();
    }

    private void pesquisaMaterial(String codigoMaterial) {
        this.materialAux = null;
        Hashtable hash = null;
        if (codigoMaterial == null) {
            hash = Pesquisas.materialAtivo(Laboratorio.getInstancia(), true);
        }
        if (hash != null || hash == null && codigoMaterial != null) {
            MaterialBean bean = null;
            try {
                bean = hash != null ? (MaterialBean)new MaterialService().getAtivo(Variaveis.filialPadrao, String.valueOf((Integer)hash.get("mat_codigo")), null, null, false, true, false) : (MaterialBean)new MaterialService().getAtivo(Variaveis.filialPadrao, codigoMaterial, null, null, false, true, false);
                if (bean == null) {
                    bean = VisualizarMateriaisAlternativos.getTelaMaterialAlternativo(bean, this.textCodigoMaterial);
                }
                this.materialAux = bean;
            }
            catch (Exception e1) {
                Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel buscar dados do material.", 2);
                return;
            }
            if (bean != null) {
                this.textCodigoMaterial.setText(String.valueOf(bean.getCodigo()));
                this.labelDescMaterial.setText(bean.getDescricao());
                ScreenUtil.requisitarFoco(this.textQuantidade);
                this.buscaQuantidadeEstoque(bean);
            } else {
                this.textCodigoMaterial.selectAll();
                this.labelDescMaterial.setText("N\u00e3o cadastrado");
            }
        }
    }

    private void pesquisaCelula(String codigoCelula) {
        this.celulaAux = null;
        CelulaEstoqueBean bean = null;
        try {
            bean = (CelulaEstoqueBean)new CelulaEstoqueService().get(Variaveis.filialPadrao, codigoCelula);
            if (bean != null) {
                this.celulaAux = (CelulaEstoqueVO)bean.toVO();
            }
        }
        catch (Exception e1) {
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel buscar dados da c\u00e9lula de estoque.", 2);
            this.celulaAux = null;
            this.labelDescCelula.setText("");
            ScreenUtil.requisitarFoco(this.textCodigoCelula);
            this.controlaCampos();
            return;
        }
        if (bean != null && bean.getInativa().booleanValue()) {
            bean = null;
        }
        this.controlaCampos();
        if (bean != null) {
            this.textCodigoCelula.setText(String.valueOf(bean.getCodigo()));
            this.labelDescCelula.setText(bean.getDescricao());
            if (this.textCodigoMaterial.isFocusable() && this.textCodigoMaterial.isEnabled()) {
                this.textCodigoMaterial.grabFocus();
            }
        } else {
            this.textCodigoCelula.selectAll();
            this.labelDescCelula.setText("N\u00e3o cadastrado");
        }
    }

    private void buscaQuantidadeEstoque(MaterialBean bean) {
        if (bean == null) {
            return;
        }
        SaldoEstoqueCelulaBean saldo = null;
        try {
            saldo = (SaldoEstoqueCelulaBean)new SaldoEstoqueCelulaService().getSaldoAtualEstoqueMaterialCelula(Variaveis.filialPadrao, bean.getCodigo().toString(), this.celulaAux.getCodigo().toString());
        }
        catch (SQLException e) {
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel buscar saldo de estoque da c\u00e9lula.", 2);
            return;
        }
        catch (ThreadDaoException e) {
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel buscar saldo de estoque da c\u00e9lula.", 2);
            return;
        }
        if (saldo != null) {
            this.labelQtdeAtual.setText(Funcoes.formataDecimal(saldo.getSaldo()));
        } else {
            this.labelQtdeAtual.setText(Funcoes.formataDecimal(0));
        }
    }

    private void salvar() {
        ConferenciaEstoqueBean bean;
        ConferenciaEstoqueService service = new ConferenciaEstoqueService();
        MaterialService serviceMaterial = new MaterialService();
        if (this.validaCampos() && (bean = this.getBeanPreenchido()) != null) {
            try {
                service.gravaAutoCopiaSemCommit(bean, 0, Variaveis.filialPadrao, this.getCopiaFiliais());
                for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                    DadosPatrimonio dados;
                    int j;
                    MaterialBean auxMaterial = (MaterialBean)this.modelo.getValueAt(i, 5);
                    ConferenciaEstoqueLanctoEstoqueBean aux = new ConferenciaEstoqueLanctoEstoqueService().getConferenciaEstoqueLanctoEstoque(bean.getFilial().getCodigo().toString(), bean.getCodigo().toString(), auxMaterial.getCodigo().toString());
                    ArrayList<MaterialLoteBean> lotes = auxMaterial.getLotes();
                    if (lotes != null) {
                        for (int j2 = 0; j2 < lotes.size(); ++j2) {
                            MaterialLoteBean lote = lotes.get(j2);
                            if (lote.getRemovido().booleanValue()) continue;
                            serviceMaterial.gerarMaterialLoteLancEstoque(aux.getFilial(), aux.getLancamentoEstoque(), lote);
                        }
                    }
                    serviceMaterial.gravaAutoCopiaSemCommit(auxMaterial, 1, Variaveis.filialPadrao, null);
                    MaterialPatrimonioService matPatrimonioService = new MaterialPatrimonioService();
                    FilialVO filial = new FilialVO();
                    filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
                    ArrayList listaPatrimonios = (ArrayList)this.modelo.getValueAt(i, 6);
                    if (listaPatrimonios == null) continue;
                    ConferenciaEstoqueMaterialBean auxBean = (ConferenciaEstoqueMaterialBean)this.modelo.getValueAt(i, 4);
                    MaterialVO material = auxBean.getMaterial();
                    boolean isUpdate = false;
                    for (j = 0; j < listaPatrimonios.size(); ++j) {
                        dados = (DadosPatrimonio)listaPatrimonios.get(j);
                        if (!dados.isSelecionado()) continue;
                        isUpdate = true;
                        break;
                    }
                    for (j = 0; j < listaPatrimonios.size(); ++j) {
                        dados = (DadosPatrimonio)listaPatrimonios.get(j);
                        if (isUpdate && !dados.isSelecionado()) continue;
                        MaterialPatrimonioBean matPatrimonio = new MaterialPatrimonioBean();
                        matPatrimonio.setFilial(filial);
                        matPatrimonio.setMaterial(material);
                        matPatrimonio.setNumeroNotaFiscal(Integer.parseInt(dados.getNotaFiscal()));
                        matPatrimonio.setSerie(dados.getSerie());
                        matPatrimonio.setPatrimonio(dados.getPatrimonio());
                        matPatrimonio.setSetor(dados.getSetor());
                        matPatrimonio.setInutilizado(true);
                        matPatrimonioService.update(matPatrimonio, null, Variaveis.filialPadrao, null);
                    }
                }
                Conexao.arquivaSQL();
                this.limparCampos();
                this.setStatus(1);
                this.controlaCampos();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel salvar a Confer\u00eancia de Estoque.\n" + e.getMessage(), e.getStackTrace());
            }
        }
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    private String getCopiaFiliais() {
        return null;
    }

    @Override
    public void pressioneiF2() {
        if (this.textCodigoMaterial.hasFocus()) {
            this.pesquisaMaterial(null);
        } else if (this.textCodigoCelula.hasFocus()) {
            this.pesquisaCelula();
        }
    }

    private void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.status = 1;
            this.controlaCampos();
        }
    }

    private void controlaCampos() {
        this.textCodigoCelula.setEnabled(this.status == 2 && this.modelo.getRowCount() == 0);
        this.textCodigoMaterial.setEnabled(this.status == 2 && this.celulaAux != null && !this.isAlterandoMaterial);
        this.textObs.setEnabled(this.status == 2);
        this.textQuantidade.setEnabled(this.status == 2 && this.celulaAux != null);
        this.buttonBuscaCelula.setEnabled(this.status == 2 && this.modelo.getRowCount() == 0);
        this.buttonBuscaMaterial.setEnabled(this.status == 2 && this.celulaAux != null && !this.isAlterandoMaterial);
        this.buttonOK.setEnabled(this.status == 2 && this.celulaAux != null);
        this.buttonSalvar.setEnabled(this.status == 2);
        this.buttonCancelar.setEnabled(this.status == 2);
        this.buttonNovo.setEnabled(this.status == 1);
        this.buttonFechar.setEnabled(this.status == 1);
    }

    private void limparCampos() {
        this.textCodigoCelula.clear();
        this.textCodigoMaterial.clear();
        this.textObs.setText("");
        this.textQuantidade.clear();
        this.modelo.clear();
        this.labelDescCelula.setText("");
        this.labelDescData.setText("");
        this.labelDescMaterial.setText("");
        this.labelDescUsuario.setText("");
        this.labelQtdeAtual.setText("");
        this.dataAux = null;
        this.usuarioAux = null;
        this.materialAux = null;
        this.celulaAux = null;
        this.isAlterandoMaterial = false;
    }

    private void novo() {
        this.limparCampos();
        this.status = 2;
        this.controlaCampos();
        this.dataAux = new Date();
        this.usuarioAux = new UsuarioVO();
        this.usuarioAux.setCodigo(Variaveis.login);
        this.labelDescData.setText(Funcoes.formataData("dd/MM/yyyy HH:mm:ss", this.dataAux));
        this.labelDescUsuario.setText(this.usuarioAux.getCodigo());
        if (this.textCodigoCelula.isFocusable() && this.textCodigoCelula.isEnabled()) {
            this.textCodigoCelula.grabFocus();
        }
    }

    private void fechar() {
        this.setVisible(false);
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.textCodigoMaterial) {
            if (!this.textCodigoMaterial.getText().isEmpty()) {
                this.pesquisaMaterial(this.textCodigoMaterial.getText());
            }
        } else if (e.getSource() == this.textCodigoCelula && !this.textCodigoCelula.getText().isEmpty()) {
            this.pesquisaCelula(this.textCodigoCelula.getText());
        }
    }

    private boolean validaCampos() {
        if (this.celulaAux == null) {
            Funcoes.mensagem(this, "Deve-se selecionar uma C\u00e9lula.", 2);
            if (this.textCodigoCelula.isFocusable() && this.textCodigoCelula.isEnabled()) {
                this.textCodigoCelula.grabFocus();
            }
            return false;
        }
        if (this.modelo.getRowCount() <= 0) {
            Funcoes.mensagem(this, "Pelo menos um material deve ser adicionado.", 2);
            if (this.textCodigoMaterial.isFocusable() && this.textCodigoMaterial.isEnabled()) {
                this.textCodigoMaterial.grabFocus();
            }
            return false;
        }
        return true;
    }

    private ConferenciaEstoqueBean getBeanPreenchido() {
        ConferenciaEstoqueBean bean = new ConferenciaEstoqueBean();
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        bean.setFilial(filial);
        bean.setCelulaEstoque(this.celulaAux);
        bean.setDataHora(this.dataAux);
        bean.setObservacao(this.textObs.getText());
        bean.setUsuario(this.usuarioAux);
        ArrayList<ConferenciaEstoqueMaterialBean> materiais = new ArrayList<ConferenciaEstoqueMaterialBean>();
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            materiais.add((ConferenciaEstoqueMaterialBean)this.modelo.getValueAt(i, 4));
        }
        bean.setMateriais(materiais);
        return bean;
    }
}

