/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.estoque.almoxarifado;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Pesquisas;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.DadosPatrimonio;
import jalis.laboratorio.cadastro.Patrimonio;
import jalis.laboratorio.cadastro.VisualizarMateriaisAlternativos;
import jalis.laboratorio.estoque.SolicitarLoteMaterial;
import jalis.laboratorio.estoque.almoxarifado.PerguntarValorEstoque;
import jalis.model.bean.estoque.ConferenciaEntradaBean;
import jalis.model.bean.estoque.ConferenciaEntradaLanctoEstoqueBean;
import jalis.model.bean.estoque.ConferenciaEntradaMaterialBean;
import jalis.model.bean.estoque.MaterialBean;
import jalis.model.bean.estoque.MaterialLoteBean;
import jalis.model.bean.estoque.MaterialPatrimonioBean;
import jalis.model.bean.estoque.NotaFiscalMaterialBean;
import jalis.model.bean.estoque.PedidoBean;
import jalis.model.bean.estoque.PedidoMaterialBean;
import jalis.model.bean.financeiro.NotaFiscalBean;
import jalis.model.dao.estoque.PedidoDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.estoque.CelulaEstoqueVO;
import jalis.model.vo.estoque.MaterialVO;
import jalis.model.vo.estoque.PedidoVO;
import jalis.model.vo.financeiro.NotaFiscalVO;
import jalis.service.estoque.CelulaEstoqueService;
import jalis.service.estoque.ConferenciaEntradaLanctoEstoqueService;
import jalis.service.estoque.ConferenciaEntradaService;
import jalis.service.estoque.MaterialPatrimonioService;
import jalis.service.estoque.MaterialService;
import jalis.service.estoque.PedidoService;
import jalis.service.financeiro.NotaFiscalService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;

public class ConferenciaEntrada
extends FrmCadPadrao
implements ActionListener {
    private TTextField textCodigoMaterial = new TTextField(18, 3);
    private TTextField textQtdeRecebida = new TTextField(12, 2);
    private JButton buttonBuscaMaterial = ComponenteFactory.novoJButton(this, true);
    private JButton buttonImportar = ComponenteFactory.novoJButton(this, false);
    private JButton buttonOK = ComponenteFactory.novoJButton(this, false);
    private JLabel labelCelula = new JLabel();
    private JLabel labelData = new JLabel();
    private JLabel labelDescData = new JLabel();
    private JLabel labelDescUsuario = new JLabel();
    private JLabel labelMaterial = new JLabel();
    private JLabel labelRecebida = new JLabel();
    private JLabel labelSolicitada = new JLabel();
    private JLabel labelUsuario = new JLabel();
    private JLabel labelQtdeSolicitada = new JLabel();
    private JLabel labelDescricaoMaterial = new JLabel();
    private JLabel labelObservacao = new JLabel();
    private JPanel panelBotoes = new JPanel();
    private JPanel panelBotoesA = new JPanel();
    private JPanel panelBotoesB = new JPanel();
    private JPanel panelCentro = new JPanel(new GridBagLayout());
    private JPanel panelObservacao = new JPanel(new GridBagLayout());
    private JScrollPane scrollMaterial = null;
    private JScrollPane scrollObservacao = new JScrollPane();
    private JComboBox comboCelula = new JComboBox();
    private ModeloGridTable modeloMaterial = null;
    private JTable tableMaterial;
    private JTextArea areaObservacao = new JTextArea();
    private JPopupMenu menuImportar = new JPopupMenu();
    private JMenuItem itemPedido = ComponenteFactory.novoJMenuItem(this.menuImportar, "Pedido", (ActionListener)this);
    private JMenuItem itemNotaFiscal = ComponenteFactory.novoJMenuItem(this.menuImportar, "Nota Fiscal", (ActionListener)this);
    private MaterialBean materialAux = null;
    private Date dataAux = null;
    private UsuarioVO usuarioAux = null;
    private NotaFiscalVO notaFiscalAux = null;
    private PedidoVO pedidoAux = null;
    private boolean isAlterandoMaterial = false;
    private boolean isImportandoNota = false;
    private int rowAlterando = -1;
    private static final int COLUNA_CODIGO = 0;
    private static final int COLUNA_MATERIAL = 1;
    private static final int COLUNA_SOLICITADO = 2;
    private static final int COLUNA_RECEBIDO = 3;
    private static final int COLUNA_CELULA = 4;
    private static final int COLUNA_OBJETO = 5;
    private static final int COLUNA_OBJETO_MATERIAL = 6;
    private static final int COLUNA_PATRIMONIO = 7;
    private static final Color COR_SOLICITA_PATRIMONIO = ScreenUtil.clarearCor(Color.YELLOW, 125);
    private JPopupMenu popMaterial = new JPopupMenu();
    private JMenuItem itemEditarMaterial = ComponenteFactory.novoJMenuItem(this.popMaterial, "Editar", (ActionListener)this);
    private JMenuItem itemVisualizarLote = ComponenteFactory.novoJMenuItem(this.popMaterial, "Visualizar Lotes", (ActionListener)this);

    public ConferenciaEntrada() {
        this.montaTela();
    }

    private void montaTela() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelCentro, "Center");
        this.panelCentro.setBorder(ScreenUtil.criarBordaVazia());
        ScreenUtil.setBorda(new Component[]{this.labelDescricaoMaterial, this.labelQtdeSolicitada, this.labelDescData, this.labelDescUsuario}, new TitledBorder(""));
        Funcoes.criaBarraDescricao(this, "Confer\u00eancia de Entrada", "Confer\u00eancia de entrada de materiais no estoque", "estoque/conferencia_entrada.jpg");
        this.buscaCelulasCombo();
        this.itemPedido.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConferenciaEntrada.this.buscarPedido();
            }
        });
        this.itemNotaFiscal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConferenciaEntrada.this.buscarNotaFiscal();
            }
        });
        this.buttonImportar.setMnemonic('I');
        this.buttonImportar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConferenciaEntrada.this.menuImportar.show(ConferenciaEntrada.this.buttonImportar, ConferenciaEntrada.this.buttonImportar.getParent().getX() + ConferenciaEntrada.this.buttonImportar.getWidth() / 2, ConferenciaEntrada.this.buttonImportar.getParent().getY() + ConferenciaEntrada.this.buttonImportar.getHeight() / 2);
            }
        });
        this.buttonOK.setMnemonic('O');
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConferenciaEntrada.this.materialAux == null) {
                    Funcoes.mensagem(ConferenciaEntrada.this, "Nenhum material foi selecionado.", 2);
                    if (ConferenciaEntrada.this.textCodigoMaterial.isFocusable() && ConferenciaEntrada.this.textCodigoMaterial.isEnabled()) {
                        ConferenciaEntrada.this.textCodigoMaterial.grabFocus();
                    }
                    return;
                }
                if (ConferenciaEntrada.this.textQtdeRecebida.getText().isEmpty()) {
                    Funcoes.mensagem(ConferenciaEntrada.this, "A quantidade recebida deve ser informada.", 2);
                    if (ConferenciaEntrada.this.textQtdeRecebida.isFocusable() && ConferenciaEntrada.this.textQtdeRecebida.isEnabled()) {
                        ConferenciaEntrada.this.textQtdeRecebida.grabFocus();
                    }
                    return;
                }
                if (ConferenciaEntrada.this.comboCelula.getSelectedIndex() < 0) {
                    Funcoes.mensagem(ConferenciaEntrada.this, "Nenhuma c\u00e9lula foi selecionada.", 2);
                    if (ConferenciaEntrada.this.comboCelula.isFocusable() && ConferenciaEntrada.this.comboCelula.isEnabled()) {
                        ConferenciaEntrada.this.comboCelula.grabFocus();
                    }
                    return;
                }
                if (ConferenciaEntrada.this.modeloMaterial.getRowCount() > 1 && ConferenciaEntrada.this.isAlterandoMaterial) {
                    int resp;
                    boolean nenhumExigeLote = true;
                    for (int i = 0; i < ConferenciaEntrada.this.modeloMaterial.getRowCount(); ++i) {
                        ConferenciaEntradaMaterialBean aux = (ConferenciaEntradaMaterialBean)ConferenciaEntrada.this.modeloMaterial.getValueAt(i, 5);
                        if (aux == null || aux.getMaterial() == null || aux.getMaterial().getSolicitarLote() == null || !aux.getMaterial().getSolicitarLote().booleanValue()) continue;
                        nenhumExigeLote = false;
                        break;
                    }
                    if (nenhumExigeLote && (resp = Funcoes.mensagem(ConferenciaEntrada.this, "Deseja utilizar a mesma c\u00e9lula de estoque para todos os materiais?", 4)) == 0) {
                        for (int i = 0; i < ConferenciaEntrada.this.modeloMaterial.getRowCount(); ++i) {
                            ConferenciaEntradaMaterialBean aux = (ConferenciaEntradaMaterialBean)ConferenciaEntrada.this.modeloMaterial.getValueAt(i, 5);
                            aux.setCelulaEstoque((CelulaEstoqueVO)ConferenciaEntrada.this.comboCelula.getSelectedItem());
                            ConferenciaEntrada.this.modeloMaterial.setValueAt(aux.getCelulaEstoque().getDescricao(), i, 4);
                            ConferenciaEntrada.this.modeloMaterial.setValueAt(aux, i, 5);
                        }
                        ConferenciaEntrada.this.modeloMaterial.fireTableDataChanged();
                    }
                }
                ConferenciaEntradaMaterialBean material = null;
                if (!ConferenciaEntrada.this.isAlterandoMaterial) {
                    material = new ConferenciaEntradaMaterialBean();
                    FilialVO filial = new FilialVO();
                    filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
                    material.setFilial(filial);
                    material.setMaterial((MaterialVO)ConferenciaEntrada.this.materialAux.toVO());
                    material.setQuantidadeSolicitada(Double.parseDouble(Funcoes.limpaDecimal(ConferenciaEntrada.this.labelQtdeSolicitada.getText().isEmpty() ? "0" : ConferenciaEntrada.this.labelQtdeSolicitada.getText())));
                } else {
                    material = (ConferenciaEntradaMaterialBean)ConferenciaEntrada.this.modeloMaterial.getValueAt(ConferenciaEntrada.this.rowAlterando, 5);
                }
                material.setQuantidadeRecebida(Double.parseDouble(Funcoes.limpaDecimal(ConferenciaEntrada.this.textQtdeRecebida.getText())));
                material.setCelulaEstoque((CelulaEstoqueVO)ConferenciaEntrada.this.comboCelula.getSelectedItem());
                MaterialBean matBean = null;
                if (ConferenciaEntrada.this.isAlterandoMaterial) {
                    matBean = (MaterialBean)ConferenciaEntrada.this.modeloMaterial.getValueAt(ConferenciaEntrada.this.rowAlterando, 6);
                } else {
                    try {
                        matBean = (MaterialBean)new MaterialService().getAtivo(Variaveis.filialPadrao, ConferenciaEntrada.this.materialAux.getCodigo().toString(), ConferenciaEntrada.this.notaFiscalAux, ConferenciaEntrada.this.pedidoAux);
                        matBean.setIpiUltimaCompra(0.0);
                        matBean.setFreteUltimaCompra(0.0);
                    }
                    catch (Exception e1) {
                        ErrorLogger.mostraMensagem(ConferenciaEntrada.this, "N\u00e3o foi poss\u00edvel carregar bean do material.\n" + e1.getMessage(), e1.getStackTrace());
                    }
                }
                if (ConferenciaEntrada.this.adicionaMaterial(material, matBean, ConferenciaEntrada.this.tableMaterial.getSelectedRow(), null)) {
                    ConferenciaEntrada.this.textCodigoMaterial.setText("");
                    ConferenciaEntrada.this.labelDescricaoMaterial.setText("");
                    ConferenciaEntrada.this.labelQtdeSolicitada.setText("");
                    ConferenciaEntrada.this.textQtdeRecebida.setText("");
                    if (ConferenciaEntrada.this.textCodigoMaterial.isFocusable() && ConferenciaEntrada.this.textCodigoMaterial.isEnabled()) {
                        ConferenciaEntrada.this.textCodigoMaterial.grabFocus();
                    }
                }
                ConferenciaEntrada.this.isAlterandoMaterial = false;
                ConferenciaEntrada.this.rowAlterando = -1;
                ConferenciaEntrada.this.controlaCampos();
            }
        });
        this.textCodigoMaterial.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (ConferenciaEntrada.this.textCodigoMaterial.getText().isEmpty()) {
                    return;
                }
                try {
                    if (ConferenciaEntrada.this.materialAux == null || !Funcoes.isNumeric(ConferenciaEntrada.this.textCodigoMaterial.getText()) || Funcoes.isNumeric(ConferenciaEntrada.this.textCodigoMaterial.getText()) && ConferenciaEntrada.this.materialAux.getCodigo() != Integer.parseInt(ConferenciaEntrada.this.textCodigoMaterial.getText())) {
                        ConferenciaEntrada.this.materialAux = (MaterialBean)new MaterialService().getAtivo(Variaveis.filialPadrao, ConferenciaEntrada.this.textCodigoMaterial.getText(), ConferenciaEntrada.this.notaFiscalAux, ConferenciaEntrada.this.pedidoAux);
                    }
                }
                catch (Exception e1) {
                    ConferenciaEntrada.this.materialAux = null;
                    ConferenciaEntrada.this.labelDescricaoMaterial.setText("N\u00e3o cadastrado");
                    ConferenciaEntrada.this.controlaCampos();
                    return;
                }
                if (ConferenciaEntrada.this.materialAux == null) {
                    ConferenciaEntrada.this.materialAux = VisualizarMateriaisAlternativos.getTelaMaterialAlternativo(ConferenciaEntrada.this.materialAux, ConferenciaEntrada.this.textCodigoMaterial);
                }
                if (ConferenciaEntrada.this.materialAux != null) {
                    ConferenciaEntrada.this.textCodigoMaterial.setText(ConferenciaEntrada.this.materialAux.getCodigo().toString());
                    ConferenciaEntrada.this.labelDescricaoMaterial.setText(ConferenciaEntrada.this.materialAux.getDescricao());
                } else {
                    ConferenciaEntrada.this.materialAux = null;
                    ConferenciaEntrada.this.labelDescricaoMaterial.setText("N\u00e3o cadastrado");
                }
                ConferenciaEntrada.this.controlaCampos();
                if (ConferenciaEntrada.this.textQtdeRecebida.isEnabled() && ConferenciaEntrada.this.textQtdeRecebida.isFocusable()) {
                    ConferenciaEntrada.this.textQtdeRecebida.grabFocus();
                }
            }
        });
        this.buttonBuscaMaterial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Hashtable hash = Pesquisas.materialAtivo(Laboratorio.getInstancia(), true);
                if (hash != null) {
                    try {
                        if (ConferenciaEntrada.this.materialAux == null || !Funcoes.isNumeric(ConferenciaEntrada.this.textCodigoMaterial.getText()) || Funcoes.isNumeric(ConferenciaEntrada.this.textCodigoMaterial.getText()) && ConferenciaEntrada.this.materialAux.getCodigo() != Integer.parseInt(ConferenciaEntrada.this.textCodigoMaterial.getText())) {
                            ConferenciaEntrada.this.materialAux = (MaterialBean)new MaterialService().getAtivo(Variaveis.filialPadrao, String.valueOf((Integer)hash.get("mat_codigo")), ConferenciaEntrada.this.notaFiscalAux, ConferenciaEntrada.this.pedidoAux);
                        }
                    }
                    catch (Exception e1) {
                        Funcoes.mensagem(ConferenciaEntrada.this, "N\u00e3o foi poss\u00edvel buscar dados do material.", 2);
                        return;
                    }
                    if (ConferenciaEntrada.this.materialAux != null) {
                        ConferenciaEntrada.this.textCodigoMaterial.setText(String.valueOf(ConferenciaEntrada.this.materialAux.getCodigo()));
                        ConferenciaEntrada.this.labelDescricaoMaterial.setText(ConferenciaEntrada.this.materialAux.getDescricao());
                    } else {
                        ConferenciaEntrada.this.textCodigoMaterial.setText(String.valueOf((Integer)hash.get("mat_codigo")));
                        ConferenciaEntrada.this.labelDescricaoMaterial.setText("N\u00e3o cadastrado");
                    }
                }
                ConferenciaEntrada.this.controlaCampos();
            }
        });
        this.modeloMaterial = new ModeloGridTable(new String[]{"C\u00f3digo", "Material", "Solicitado", "Recebido", "C\u00e9lula", "Objeto", "ObjetoMaterial", "Patrimonio"}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return super.getColumnClass(columnIndex);
            }

            @Override
            public void fireTableStructureChanged() {
                super.fireTableStructureChanged();
                try {
                    if (ConferenciaEntrada.this.tableMaterial != null) {
                        ConferenciaEntrada.this.tableMaterial.removeColumn(ConferenciaEntrada.this.tableMaterial.getColumn("Objeto"));
                        ConferenciaEntrada.this.tableMaterial.removeColumn(ConferenciaEntrada.this.tableMaterial.getColumn("ObjetoMaterial"));
                        ConferenciaEntrada.this.tableMaterial.removeColumn(ConferenciaEntrada.this.tableMaterial.getColumn("Patrimonio"));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                try {
                    ConferenciaEntrada.this.tableMaterial.removeColumn(ConferenciaEntrada.this.tableMaterial.getColumn("Objeto"));
                    ConferenciaEntrada.this.tableMaterial.removeColumn(ConferenciaEntrada.this.tableMaterial.getColumn("ObjetoMaterial"));
                    ConferenciaEntrada.this.tableMaterial.removeColumn(ConferenciaEntrada.this.tableMaterial.getColumn("Patrimonio"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        };
        this.tableMaterial = new JTable(this.modeloMaterial);
        this.tableMaterial.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public synchronized Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
                Component comp = super.getTableCellRendererComponent(table, value, selected, focused, row, column);
                ConferenciaEntradaMaterialBean aux = (ConferenciaEntradaMaterialBean)ConferenciaEntrada.this.modeloMaterial.getValueAt(row, 5);
                if (aux != null && aux.getMaterial() != null && aux.getMaterial().getSolicitarPatrimonio() != null && aux.getMaterial().getSolicitarPatrimonio().booleanValue()) {
                    comp.setBackground(COR_SOLICITA_PATRIMONIO);
                } else if (!selected) {
                    comp.setBackground(null);
                }
                return comp;
            }
        });
        this.tableMaterial.removeColumn(this.tableMaterial.getColumn("Objeto"));
        this.tableMaterial.removeColumn(this.tableMaterial.getColumn("ObjetoMaterial"));
        this.tableMaterial.removeColumn(this.tableMaterial.getColumn("Patrimonio"));
        this.tableMaterial.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
            }
        });
        this.tableMaterial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    int resp = Funcoes.mensagem(ConferenciaEntrada.this, "Deseja remover o material da confer\u00eancia de entrada?", 4);
                    if (resp == 0) {
                        int row = ((JTable)e.getSource()).getSelectedRow();
                        ConferenciaEntrada.this.modeloMaterial.removeLine(row);
                    }
                } else if (e.getKeyCode() == 32) {
                    int row = ((JTable)e.getSource()).getSelectedRow();
                    ConferenciaEntrada.this.materialAux = (MaterialBean)ConferenciaEntrada.this.modeloMaterial.getValueAt(row, 6);
                    if (ConferenciaEntrada.this.materialAux != null && ConferenciaEntrada.this.materialAux.getSolicitarLote().booleanValue() && ParametrosGerais.getTipoMovimentarEstoque().equalsIgnoreCase("C")) {
                        int x = ConferenciaEntrada.this.tableMaterial.getColumnModel().getColumn(ConferenciaEntrada.this.tableMaterial.getSelectedColumn()).getWidth();
                        int y = ConferenciaEntrada.this.tableMaterial.getSelectedRow() * 18;
                        ConferenciaEntrada.this.popMaterial.show(ConferenciaEntrada.this.tableMaterial, x, y);
                    } else {
                        ConferenciaEntrada.this.editandoMaterial();
                    }
                }
            }
        });
        this.tableMaterial.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int row = ((JTable)e.getSource()).getSelectedRow();
                    if (row >= 0) {
                        ConferenciaEntradaMaterialBean material = (ConferenciaEntradaMaterialBean)ConferenciaEntrada.this.modeloMaterial.getValueAt(row, 5);
                        MaterialBean beanMaterial = null;
                        try {
                            beanMaterial = (MaterialBean)new MaterialService().getAtivo(String.valueOf(material.getMaterial().getFilial().getCodigo()), String.valueOf(material.getMaterial().getCodigo()), ConferenciaEntrada.this.notaFiscalAux, ConferenciaEntrada.this.pedidoAux);
                        }
                        catch (Exception e1) {
                            Funcoes.mensagem(ConferenciaEntrada.this, "N\u00e3o foi poss\u00edvel carregar os dados do material.", 2);
                            return;
                        }
                        beanMaterial = (MaterialBean)ConferenciaEntrada.this.modeloMaterial.getValueAt(row, 6);
                        if (ConferenciaEntrada.this.materialAux != null && ConferenciaEntrada.this.materialAux.getSolicitarLote().booleanValue() && ParametrosGerais.getTipoMovimentarEstoque().equalsIgnoreCase("C")) {
                            int x = ConferenciaEntrada.this.tableMaterial.getColumnModel().getColumn(ConferenciaEntrada.this.tableMaterial.getSelectedColumn()).getWidth();
                            int y = ConferenciaEntrada.this.tableMaterial.getSelectedRow() * 18;
                            ConferenciaEntrada.this.popMaterial.show(ConferenciaEntrada.this.tableMaterial, x, y);
                        } else {
                            ConferenciaEntrada.this.isAlterandoMaterial = true;
                            ConferenciaEntrada.this.rowAlterando = ConferenciaEntrada.this.tableMaterial.getSelectedRow();
                            ConferenciaEntrada.this.materialAux = beanMaterial;
                            ConferenciaEntrada.this.textCodigoMaterial.setText(String.valueOf(material.getMaterial().getCodigo()));
                            ConferenciaEntrada.this.labelDescricaoMaterial.setText(material.getMaterial().getDescricao());
                            ConferenciaEntrada.this.labelQtdeSolicitada.setText(Funcoes.formataDecimal(material.getQuantidadeSolicitada()));
                            ConferenciaEntrada.this.textQtdeRecebida.setText((String)ConferenciaEntrada.this.modeloMaterial.getValueAt(row, 3));
                            ConferenciaEntrada.this.comboCelula.setSelectedItem(ConferenciaEntrada.this.modeloMaterial.getValueAt(row, 4));
                            ConferenciaEntrada.this.controlaCampos();
                            ConferenciaEntrada.this.textQtdeRecebida.selectAll();
                            if (ConferenciaEntrada.this.textQtdeRecebida.isFocusable() && ConferenciaEntrada.this.textQtdeRecebida.isEnabled()) {
                                ConferenciaEntrada.this.textQtdeRecebida.grabFocus();
                            }
                        }
                    }
                } else if (e.getClickCount() == 1 && ConferenciaEntrada.this.isAlterandoMaterial) {
                    ConferenciaEntrada.this.textCodigoMaterial.setText("");
                    ConferenciaEntrada.this.labelDescricaoMaterial.setText("");
                    ConferenciaEntrada.this.labelQtdeSolicitada.setText("");
                    ConferenciaEntrada.this.textQtdeRecebida.setText("");
                    if (ConferenciaEntrada.this.comboCelula.getItemCount() > 0) {
                        ConferenciaEntrada.this.comboCelula.setSelectedIndex(0);
                    }
                    ConferenciaEntrada.this.isAlterandoMaterial = false;
                    ConferenciaEntrada.this.rowAlterando = -1;
                    ConferenciaEntrada.this.controlaCampos();
                }
            }
        });
        this.modeloMaterial.setColumnSize(new int[]{70, 0, 90, 90, 0, 0, 0, 0}, this.tableMaterial);
        this.tableMaterial.getTableHeader().addMouseListener(this.modeloMaterial);
        this.scrollMaterial = new JScrollPane(this.tableMaterial);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelCentro.add((Component)this.scrollMaterial, gridBagConstraints);
        this.labelObservacao.setLabelFor(this.areaObservacao);
        this.labelObservacao.setDisplayedMnemonic('b');
        this.labelObservacao.setText("Observa\u00e7\u00e3o");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.panelObservacao.add((Component)this.labelObservacao, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panelObservacao.add((Component)new JLabel(), gridBagConstraints);
        this.areaObservacao.setRows(2);
        this.scrollObservacao.setMinimumSize(new Dimension(20, 60));
        this.scrollObservacao.setPreferredSize(new Dimension(20, 60));
        this.scrollObservacao.setViewportView(this.areaObservacao);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        this.panelObservacao.add((Component)this.scrollObservacao, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 7;
        this.panelCentro.add((Component)this.panelObservacao, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 7;
        this.panelCentro.add((Component)this.montaPainelLegenda(), gridBagConstraints);
        this.panelBotoes.setLayout(new GridBagLayout());
        this.panelBotoesA.setLayout(new FlowLayout(2));
        this.panelBotoesA.add(this.botaoNovo);
        this.panelBotoesA.add(this.botaoSalvar);
        this.panelBotoesA.add(this.botaoCancelar);
        this.panelBotoesA.add(this.botaoFechar);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelBotoes.add((Component)this.panelBotoesA, gridBagConstraints);
        this.panelBotoesB.setLayout(new FlowLayout(0));
        this.buttonImportar.setText("Importar \u25bc");
        this.panelBotoesB.add(this.buttonImportar);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.panelBotoes.add((Component)this.panelBotoesB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelCentro.add((Component)this.panelBotoes, gridBagConstraints);
        this.labelMaterial.setLabelFor(this.textCodigoMaterial);
        this.labelMaterial.setDisplayedMnemonic('M');
        this.labelMaterial.setText("Material");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.panelCentro.add((Component)this.labelMaterial, gridBagConstraints);
        this.labelSolicitada.setText("Solicitado");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.panelCentro.add((Component)this.labelSolicitada, gridBagConstraints);
        this.labelRecebida.setText("Recebido");
        this.labelRecebida.setDisplayedMnemonic('e');
        this.labelRecebida.setLabelFor(this.textQtdeRecebida);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.panelCentro.add((Component)this.labelRecebida, gridBagConstraints);
        this.labelCelula.setText("C\u00e9lula Destino");
        this.labelCelula.setDisplayedMnemonic('u');
        this.labelCelula.setLabelFor(this.comboCelula);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.panelCentro.add((Component)this.labelCelula, gridBagConstraints);
        this.textCodigoMaterial.setPreferredSize(new Dimension(70, 20));
        this.textCodigoMaterial.setMinimumSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.panelCentro.add((Component)this.textCodigoMaterial, gridBagConstraints);
        this.labelDescricaoMaterial.setPreferredSize(new Dimension(20, 20));
        this.labelDescricaoMaterial.setMinimumSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelCentro.add((Component)this.labelDescricaoMaterial, gridBagConstraints);
        this.labelQtdeSolicitada.setHorizontalAlignment(4);
        this.labelQtdeSolicitada.setPreferredSize(new Dimension(100, 20));
        this.labelQtdeSolicitada.setMinimumSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.panelCentro.add((Component)this.labelQtdeSolicitada, gridBagConstraints);
        this.textQtdeRecebida.setPreferredSize(new Dimension(100, 20));
        this.textQtdeRecebida.setMinimumSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.panelCentro.add((Component)this.textQtdeRecebida, gridBagConstraints);
        this.comboCelula.setPreferredSize(new Dimension(120, 20));
        this.comboCelula.setMinimumSize(new Dimension(120, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.panelCentro.add((Component)this.comboCelula, gridBagConstraints);
        this.buttonOK.setText("OK");
        this.buttonOK.setMaximumSize(new Dimension(40, 20));
        this.buttonOK.setMinimumSize(new Dimension(40, 20));
        this.buttonOK.setPreferredSize(new Dimension(40, 20));
        this.buttonOK.setMargin(new Insets(1, 1, 1, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        this.panelCentro.add((Component)this.buttonOK, gridBagConstraints);
        this.buttonBuscaMaterial.setMaximumSize(new Dimension(20, 20));
        this.buttonBuscaMaterial.setMinimumSize(new Dimension(20, 20));
        this.buttonBuscaMaterial.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.panelCentro.add((Component)this.buttonBuscaMaterial, gridBagConstraints);
        this.labelData.setText("Data:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.panelCentro.add((Component)this.labelData, gridBagConstraints);
        this.labelUsuario.setText("Usu\u00e1rio:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.panelCentro.add((Component)this.labelUsuario, gridBagConstraints);
        this.labelDescData.setPreferredSize(new Dimension(80, 20));
        this.labelDescData.setMinimumSize(new Dimension(40, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        this.panelCentro.add((Component)this.labelDescData, gridBagConstraints);
        this.labelDescUsuario.setPreferredSize(new Dimension(40, 20));
        this.labelDescUsuario.setMinimumSize(new Dimension(40, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelCentro.add((Component)this.labelDescUsuario, gridBagConstraints);
        this.controlaCampos();
        this.modeloMaterial.ordenarColuna(1);
    }

    private void editandoMaterial() {
        int row = this.tableMaterial.getSelectedRow();
        this.isAlterandoMaterial = true;
        this.rowAlterando = row;
        ConferenciaEntradaMaterialBean material = null;
        if (row >= 0) {
            material = (ConferenciaEntradaMaterialBean)this.modeloMaterial.getValueAt(row, 5);
        }
        this.textCodigoMaterial.setText(String.valueOf(material.getMaterial().getCodigo()));
        this.labelDescricaoMaterial.setText(material.getMaterial().getDescricao());
        this.labelQtdeSolicitada.setText(Funcoes.formataDecimal(material.getQuantidadeSolicitada()));
        this.textQtdeRecebida.setText((String)this.modeloMaterial.getValueAt(row, 3));
        CelulaEstoqueVO celulaAux = ((ConferenciaEntradaMaterialBean)this.modeloMaterial.getValueAt(row, 5)).getCelulaEstoque();
        if (celulaAux != null) {
            for (int i = 0; i < this.comboCelula.getItemCount(); ++i) {
                CelulaEstoqueVO celulaComboAux = (CelulaEstoqueVO)this.comboCelula.getItemAt(i);
                if (celulaComboAux == null || celulaAux.getCodigo().intValue() != celulaComboAux.getCodigo().intValue()) continue;
                this.comboCelula.setSelectedItem(celulaComboAux);
            }
        }
        this.controlaCampos();
        this.textQtdeRecebida.selectAll();
        if (this.textQtdeRecebida.isFocusable() && this.textQtdeRecebida.isEnabled()) {
            this.textQtdeRecebida.grabFocus();
        }
    }

    private JPanel montaPainelLegenda() {
        JPanel pnlLegenda = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        JPanel pnlCorLegenda = new JPanel();
        pnlCorLegenda.setPreferredSize(new Dimension(10, 10));
        pnlCorLegenda.setBackground(COR_SOLICITA_PATRIMONIO);
        pnlCorLegenda.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        pnlLegenda.add((Component)pnlCorLegenda, c);
        JLabel lblLegenda = new JLabel("Material solicita patrim\u00f4nio");
        Font font = new Font(lblLegenda.getFont().getName(), 0, 10);
        lblLegenda.setFont(font);
        ++c.gridx;
        pnlLegenda.add((Component)lblLegenda, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        pnlLegenda.add((Component)new JLabel(), c);
        return pnlLegenda;
    }

    public void buscarPedido() {
        PedidoBean aux = this.pesquisar();
        if (aux != null) {
            this.novo();
            ArrayList<PedidoMaterialBean> materiais = aux.getMateriais();
            if (materiais != null) {
                this.isImportandoNota = true;
                for (int i = 0; i < materiais.size(); ++i) {
                    PedidoMaterialBean material = aux.getMateriais().get(i);
                    ConferenciaEntradaMaterialBean materialConf = new ConferenciaEntradaMaterialBean();
                    materialConf.setFilial(material.getFilial());
                    materialConf.setMaterial((MaterialVO)material.getMaterial().toVO());
                    materialConf.setQuantidadeSolicitada(material.getQuantidade());
                    materialConf.setQuantidadeRecebida(material.getQuantidade());
                    materialConf.setValorUnitario(material.getValorUnitario());
                    materialConf.setCelulaEstoque((CelulaEstoqueVO)this.comboCelula.getSelectedItem());
                    MaterialBean matBean = null;
                    try {
                        matBean = (MaterialBean)new MaterialService().getTodos(material.getFilial().getCodigo().toString(), material.getMaterial().getCodigo().toString(), this.notaFiscalAux, this.pedidoAux);
                        matBean.setFreteUltimaCompra(aux.getValorFrete());
                        matBean.setIpiUltimaCompra(0.0);
                    }
                    catch (Exception e) {
                        ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar bean do material.\n" + e.getMessage(), e.getStackTrace());
                    }
                    this.adicionaMaterial(materialConf, matBean, -1, null);
                }
            }
            this.isImportandoNota = false;
            this.pedidoAux = (PedidoVO)aux.toVO();
            this.controlaCampos();
        }
    }

    public void buscarNotaFiscal() {
        NotaFiscalBean aux = this.pesquisarNotaFiscal();
        if (aux != null) {
            this.novo();
            ArrayList<NotaFiscalMaterialBean> materiais = aux.getMateriais();
            if (materiais != null) {
                this.isImportandoNota = true;
                for (int i = 0; i < materiais.size(); ++i) {
                    NotaFiscalMaterialBean material = aux.getMateriais().get(i);
                    ConferenciaEntradaMaterialBean materialConf = new ConferenciaEntradaMaterialBean();
                    materialConf.setFilial(material.getFilial());
                    materialConf.setMaterial(material.getMaterial());
                    materialConf.setQuantidadeSolicitada(material.getQuantidade());
                    materialConf.setQuantidadeRecebida(material.getQuantidade());
                    materialConf.setValorUnitario(material.getValorUnitario());
                    materialConf.setCelulaEstoque((CelulaEstoqueVO)this.comboCelula.getSelectedItem());
                    MaterialBean matBean = null;
                    try {
                        matBean = (MaterialBean)new MaterialService().getAtivo(material.getFilial().getCodigo().toString(), material.getMaterial().getCodigo().toString(), this.notaFiscalAux, this.pedidoAux);
                        matBean.setFreteUltimaCompra(aux.getValorFrete());
                        matBean.setIpiUltimaCompra(material.getValorIpi());
                    }
                    catch (Exception e) {
                        ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar bean do material.\n" + e.getMessage(), e.getStackTrace());
                    }
                    this.adicionaMaterial(materialConf, matBean, -1, material);
                }
            }
            this.isImportandoNota = false;
            this.notaFiscalAux = (NotaFiscalVO)aux.toVO();
            this.controlaCampos();
        }
    }

    private PedidoBean pesquisar() {
        try {
            PedidoBean pedido;
            String codigo = null;
            codigo = ParametrosGerais.getTipoAutorizacaoCompra().equalsIgnoreCase("P") || ParametrosGerais.getTipoAutorizacaoCompra().equalsIgnoreCase("E") ? new PedidoService().pesquisaPedidoAutorizadoNaoConferidoVO(this.getTopLevelAncestor(), null) : new PedidoService().pesquisaPedidoDisponivelNaoConferidoVO(this.getTopLevelAncestor(), null);
            if (codigo != null && (pedido = (PedidoBean)new PedidoDao().getBean(Variaveis.filialPadrao, codigo)) != null) {
                return pedido;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar dados do pedido de compra.\n" + e.getMessage(), e.getStackTrace());
        }
        return null;
    }

    private NotaFiscalBean pesquisarNotaFiscal() {
        NotaFiscalService service = new NotaFiscalService();
        try {
            NotaFiscalBean nota;
            Hashtable resultado = null;
            resultado = ParametrosGerais.getTipoAutorizacaoCompra().equalsIgnoreCase("F") || ParametrosGerais.getTipoAutorizacaoCompra().equalsIgnoreCase("E") ? service.pesquisaNotaEntradaAutorizadaNaoConferidaVO(Laboratorio.getInstancia(), new NotaFiscalVO(), "Pesquisando Notas Fiscais (autorizadas)") : service.pesquisaNotaEntradaNaoConferidaVO(Laboratorio.getInstancia(), new NotaFiscalVO(), "Pesquisando Notas Fiscais");
            if (resultado != null && resultado.size() > 0 && (nota = (NotaFiscalBean)service.get(Variaveis.filialPadrao, resultado.get("nfi_codigo").toString())) != null) {
                return nota;
            }
        }
        catch (Exception e) {
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel carregar dados da nota fiscal.", 2);
        }
        return null;
    }

    private boolean adicionaMaterial(ConferenciaEntradaMaterialBean material, MaterialBean matBean, int row, NotaFiscalMaterialBean notaMat) {
        for (int i = 0; i < this.modeloMaterial.getRowCount(); ++i) {
            ConferenciaEntradaMaterialBean aux = (ConferenciaEntradaMaterialBean)this.modeloMaterial.getValueAt(i, 5);
            if (aux == null || aux.getMaterial().getCodigo().intValue() != material.getMaterial().getCodigo().intValue()) continue;
            if (this.isAlterandoMaterial) break;
            Funcoes.mensagem(this, "Material j\u00e1 inserido.", 2);
            if (this.textCodigoMaterial.isFocusable() && this.textCodigoMaterial.isEnabled()) {
                this.textCodigoMaterial.grabFocus();
            }
            return false;
        }
        ArrayList<DadosPatrimonio> listaPatrimonios = null;
        if (!ParametrosGerais.getPerguntarValorEstoque().equals("N") && !this.isImportandoNota) {
            PerguntarValorEstoque tela = new PerguntarValorEstoque((Frame)Laboratorio.getInstancia(), material.getMaterial().getCodigo().toString(), this.textQtdeRecebida.getText());
            tela.setValorUnitario(material.getValorUnitario());
            tela.setVisible(true);
            material.setValorUnitario(tela.getValorUnitario());
        }
        try {
            listaPatrimonios = this.configurarPatrimonios(material.getMaterial(), material.getQuantidadeRecebida(), row, notaMat);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel configurar os patrim\u00f4nios.\n" + e.getMessage(), e.getStackTrace());
        }
        if (matBean.getSolicitarLote().booleanValue() && !this.solicitarAtualizarLote(matBean, material)) {
            Funcoes.mensagem(this, "Os lotes do material devem ser informados.", 2);
            return false;
        }
        if (this.isAlterandoMaterial) {
            this.modeloMaterial.removeLine(this.rowAlterando);
        }
        this.modeloMaterial.addLine(new Object[]{material.getMaterial().getCodigo(), material.getMaterial().getDescricao(), Funcoes.formataDecimal(material.getQuantidadeSolicitada()), Funcoes.formataDecimal(material.getQuantidadeRecebida() == null ? 0.0 : material.getQuantidadeRecebida()), material.getCelulaEstoque(), material, matBean, listaPatrimonios});
        if (this.modeloMaterial.getColunaOrdenacao() != -1) {
            this.modeloMaterial.ordenarColunaSemTrocarSentido(this.modeloMaterial.getColunaOrdenacao());
        } else {
            this.modeloMaterial.ordenarColunaSemTrocarSentido(1);
        }
        this.controlaCampos();
        return true;
    }

    private ArrayList<DadosPatrimonio> configurarPatrimonios(MaterialVO voMat, Double quantidade, int row, NotaFiscalMaterialBean notaMat) throws Exception {
        ArrayList<DadosPatrimonio> dadosPatrimonio;
        block6: {
            MaterialBean beanMat = (MaterialBean)new MaterialService().getTodos(Variaveis.filialPadrao, voMat.getCodigo().toString(), this.notaFiscalAux, this.pedidoAux);
            if (beanMat == null || beanMat.getSolicitarPatrimonio() == null || !beanMat.getSolicitarPatrimonio().booleanValue()) {
                return null;
            }
            dadosPatrimonio = this.isAlterandoMaterial && row >= 0 ? (ArrayList<DadosPatrimonio>)this.modeloMaterial.getValueAt(row, 7) : new ArrayList<DadosPatrimonio>();
            Patrimonio p = Patrimonio.novaInstancia(this.getTopLevelAncestor(), false);
            p.setTitle(voMat.getDescricao());
            p.setPatrimonios(dadosPatrimonio);
            if (notaMat != null) {
                p.setNotaFiscalEntrada(notaMat);
            } else {
                p.setQuantidadeRecebida(quantidade);
            }
            while (true) {
                if (dadosPatrimonio != null) {
                    p.setPatrimonios(dadosPatrimonio.size() == 0 ? null : dadosPatrimonio);
                }
                p.setVisible(true);
                if (!p.getOK()) break block6;
                dadosPatrimonio = p.getPatrimonios();
                if ((double)dadosPatrimonio.size() < quantidade) {
                    Funcoes.mensagem(this, "A quantidade de patrim\u00f4nios informada \u00e9 inferior \u00e0 quantidade a ser inserida.\nDeve-se informar " + quantidade.intValue() + " patrim\u00f4nio(s).", 2);
                    continue;
                }
                if (!((double)dadosPatrimonio.size() > quantidade)) break;
                Funcoes.mensagem(this, "A quantidade de patrim\u00f4nios informada \u00e9 superior \u00e0 quantidade a ser inserida.\nDeve-se informar " + quantidade.intValue() + " patrim\u00f4nio(s).", 2);
            }
            return dadosPatrimonio;
        }
        return dadosPatrimonio;
    }

    private void editarVisualizarLotes() {
        int row = this.tableMaterial.getSelectedRow();
        MaterialBean beanMat = (MaterialBean)this.modeloMaterial.getValueAt(row, 6);
        ConferenciaEntradaMaterialBean notaBean = (ConferenciaEntradaMaterialBean)this.modeloMaterial.getValueAt(row, 5);
        try {
            if ((this.getStatus() == 2 && ParametrosGerais.getTipoMovimentarEstoque().equalsIgnoreCase("C") || this.getStatus() != 2) && beanMat.getSolicitarLote().booleanValue()) {
                SolicitarLoteMaterial lote;
                CelulaEstoqueVO celula = new CelulaEstoqueService().getCelulaPadraoVO(Variaveis.filialPadrao);
                Double qtdeOriginal = beanMat.getQuantidadeLotes(celula) - beanMat.getQuantidadeConsumidaLotes(celula);
                MaterialVO matVO = null;
                if (this.getStatus() != 2) {
                    matVO = (MaterialVO)beanMat.toVO();
                    new MaterialService();
                    MaterialService.carregarLotesMaterial(matVO);
                }
                if ((lote = new SolicitarLoteMaterial((Frame)this.getTopLevelAncestor(), beanMat.getCodigo(), beanMat.getDescricao(), beanMat.getUnidadeMedida().getCodigo(), beanMat.getFichaTecnica(), this.getStatus() == 2 ? beanMat.getLotes() : matVO.getLotes(), 2, qtdeOriginal, notaBean.getQuantidadeSolicitada(), null, null, celula, false, null, false)) != null) {
                    lote.setVisible(true);
                    if (lote.getOK()) {
                        beanMat.setLotes(lote.getLotes());
                        Double qtde = 0.0;
                        if (beanMat.getLotes() != null && !beanMat.getLotes().isEmpty()) {
                            for (int i = 0; i < lote.getLotes().size(); ++i) {
                                qtde = qtde + beanMat.getLotes().get(i).getQuantidade();
                            }
                        }
                        beanMat.setQuantidadeInformadaLotes(qtde);
                    }
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar os dado do material (configurando lotes).\n" + e.getMessage(), e.getStackTrace());
        }
    }

    private boolean solicitarAtualizarLote(MaterialBean beanMat, ConferenciaEntradaMaterialBean bean) {
        Double qtdeOriginal = beanMat.getQuantidadeLotes(bean.getCelulaEstoque()) - beanMat.getQuantidadeConsumidaOriginalLotes(bean.getCelulaEstoque());
        Double qtdeInserir = bean.getQuantidadeRecebida() == null ? 0.0 : bean.getQuantidadeRecebida();
        SolicitarLoteMaterial lote = new SolicitarLoteMaterial(Laboratorio.getInstancia(), beanMat.getCodigo(), beanMat.getDescricao(), beanMat.getUnidadeMedida().getCodigo(), beanMat.getFichaTecnica(), beanMat.getLotes(), 0, qtdeOriginal, qtdeInserir, null, null, bean.getCelulaEstoque(), false, null, false);
        if (lote != null) {
            lote.setVisible(true);
            if (lote.getOK()) {
                beanMat.setLotes(lote.getLotes());
                Double qtde = 0.0;
                if (beanMat.getLotes() != null && !beanMat.getLotes().isEmpty()) {
                    for (int i = 0; i < lote.getLotes().size(); ++i) {
                        qtde = qtde + beanMat.getLotes().get(i).getQuantidade();
                    }
                }
                beanMat.setQuantidadeInformadaLotes(qtde);
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public void pressioneiF2() {
        if (this.textCodigoMaterial.hasFocus()) {
            this.buttonBuscaMaterial.doClick();
        }
    }

    private void buscaCelulasCombo() {
        ArrayList<CelulaEstoqueVO> lista = null;
        try {
            lista = new CelulaEstoqueService().getTodasCelulasFilialVO(Variaveis.filialPadrao);
        }
        catch (ThreadDaoException e) {
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel buscar dados das c\u00e9lulas de estoque.", 2);
            return;
        }
        if (lista != null) {
            int posSelecionada = 0;
            String celulaEstoqueEstacao = ParametrosLocais.getParametro("celulaEstoque") == null ? "" : ParametrosLocais.getParametro("celulaEstoque");
            for (int i = 0; i < lista.size(); ++i) {
                CelulaEstoqueVO vo = lista.get(i);
                this.comboCelula.addItem(vo);
                if (Funcoes.textoVazio(celulaEstoqueEstacao)) {
                    if (!vo.getPadrao().booleanValue()) continue;
                    posSelecionada = i;
                    continue;
                }
                if (!vo.getCodigo().toString().equals(celulaEstoqueEstacao)) continue;
                posSelecionada = i;
            }
            this.comboCelula.setSelectedIndex(posSelecionada);
        }
    }

    private void limparCampos() {
        this.labelDescData.setText("");
        this.labelDescUsuario.setText("");
        this.textCodigoMaterial.setText("");
        this.labelDescricaoMaterial.setText("");
        this.labelQtdeSolicitada.setText("");
        this.textQtdeRecebida.setText("");
        this.areaObservacao.setText("");
        this.modeloMaterial.clear();
        this.materialAux = null;
        this.dataAux = null;
        this.usuarioAux = null;
        this.notaFiscalAux = null;
        this.pedidoAux = null;
        this.isImportandoNota = false;
        this.isAlterandoMaterial = false;
        this.rowAlterando = -1;
    }

    private void controlaCampos() {
        boolean habilitar = this.getStatus() == 2;
        this.textCodigoMaterial.setEnabled(habilitar && !this.isAlterandoMaterial);
        this.buttonBuscaMaterial.setEnabled(habilitar);
        this.textQtdeRecebida.setEnabled(habilitar && this.materialAux != null);
        this.comboCelula.setEnabled(habilitar && this.materialAux != null && this.comboCelula.getItemCount() > 0);
        this.buttonOK.setEnabled(habilitar && this.materialAux != null);
        this.buttonImportar.setEnabled(habilitar);
        this.tableMaterial.setEnabled(habilitar);
        this.areaObservacao.setEnabled(habilitar);
    }

    public static long getModuloAcesso() {
        return Long.parseLong("1200300100");
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    @Deprecated
    public void editar() {
    }

    @Override
    @Deprecated
    public void excluir() {
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public void novo() {
        if (ParametrosGerais.getTipoMovimentarEstoque().equalsIgnoreCase("N")) {
            Funcoes.mensagem(this, "O par\u00e2metro geral \"Movimentar estoque: " + Tipos.tipoMovimentarEstoque("N") + "\" pro\u00edbe o movimento pela tela de confer\u00eancia de entrada.", 2);
            return;
        }
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        this.dataAux = new Date();
        this.labelDescData.setText(Funcoes.formataData("dd/MM/yyyy HH:mm:ss", this.dataAux));
        this.usuarioAux = new UsuarioVO();
        this.usuarioAux.setCodigo(Variaveis.login);
        this.labelDescUsuario.setText(this.usuarioAux.getCodigo());
        if (this.textCodigoMaterial.isFocusable() && this.textCodigoMaterial.isEnabled()) {
            this.textCodigoMaterial.grabFocus();
        }
    }

    protected String getCopiaFiliais() {
        return null;
    }

    @Override
    public void salvar() {
        ConferenciaEntradaBean bean;
        ConferenciaEntradaService service = new ConferenciaEntradaService();
        MaterialService serviceMaterial = new MaterialService();
        if (this.validaCampos() && (bean = this.getBeanPreenchido()) != null) {
            try {
                service.gravaAutoCopiaSemCommit(bean, 0, Variaveis.filialPadrao, this.getCopiaFiliais());
                MaterialPatrimonioService matPatrimonioService = new MaterialPatrimonioService();
                FilialVO filial = new FilialVO();
                filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
                for (int i = 0; i < this.modeloMaterial.getRowCount(); ++i) {
                    ConferenciaEntradaMaterialBean auxBean = (ConferenciaEntradaMaterialBean)this.modeloMaterial.getValueAt(i, 5);
                    MaterialVO material = auxBean.getMaterial();
                    if (material.getIpiUltimaCompra() == null) {
                        material.setIpiUltimaCompra(0.0);
                    }
                    if (material.getFreteUltimaCompra() == null) {
                        material.setFreteUltimaCompra(0.0);
                    }
                    MaterialBean matBean = (MaterialBean)this.modeloMaterial.getValueAt(i, 6);
                    MaterialBean auxMaterial = (MaterialBean)this.modeloMaterial.getValueAt(i, this.modeloMaterial.findColumn("ObjetoMaterial"));
                    ConferenciaEntradaLanctoEstoqueBean aux = new ConferenciaEntradaLanctoEstoqueService().getConferenciaEntradaLanctoEstoque(auxBean.getFilial().getCodigo().toString(), auxBean.getConferenciaEntrada().getCodigo().toString(), auxBean.getMaterial().getCodigo().toString());
                    ArrayList<MaterialLoteBean> lotes = matBean.getLotes();
                    if (lotes != null && !lotes.isEmpty()) {
                        for (int j = 0; j < lotes.size(); ++j) {
                            MaterialLoteBean lote = lotes.get(j);
                            if (lote.getRemovido().booleanValue()) continue;
                            serviceMaterial.gerarMaterialLoteLancEstoque(aux.getFilial(), aux.getLancamentoEstoque(), lote);
                        }
                    }
                    serviceMaterial.gravaAutoCopiaSemCommit(auxMaterial, 1, Variaveis.filialPadrao, null);
                    ArrayList listaPatrimonios = (ArrayList)this.modeloMaterial.getValueAt(i, 7);
                    if (listaPatrimonios == null) continue;
                    for (int j = 0; j < listaPatrimonios.size(); ++j) {
                        DadosPatrimonio dados = (DadosPatrimonio)listaPatrimonios.get(j);
                        MaterialPatrimonioBean matPatrimonio = new MaterialPatrimonioBean();
                        matPatrimonio.setFilial(filial);
                        matPatrimonio.setInutilizado(false);
                        matPatrimonio.setMaterial(material);
                        matPatrimonio.setNumeroNotaFiscal(Integer.parseInt(dados.getNotaFiscal()));
                        matPatrimonio.setSerie(dados.getSerie());
                        matPatrimonio.setPatrimonio(dados.getPatrimonio());
                        matPatrimonio.setSetor(dados.getSetor());
                        matPatrimonioService.insert(matPatrimonio, null, Variaveis.filialPadrao, null);
                    }
                }
                Conexao.arquivaSQL();
                this.limparCampos();
                this.setStatus(1);
                this.controlaCampos();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel salvar a Confer\u00eancia de Entrada.\n" + e.getMessage(), e.getStackTrace());
            }
        }
    }

    private ConferenciaEntradaBean getBeanPreenchido() {
        ConferenciaEntradaBean bean = new ConferenciaEntradaBean();
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        bean.setFilial(filial);
        bean.setDataHora(this.dataAux);
        bean.setObservacao(this.areaObservacao.getText());
        bean.setUsuario(this.usuarioAux);
        ArrayList<ConferenciaEntradaMaterialBean> listaMateriais = new ArrayList<ConferenciaEntradaMaterialBean>();
        for (int i = 0; i < this.modeloMaterial.getRowCount(); ++i) {
            listaMateriais.add((ConferenciaEntradaMaterialBean)this.modeloMaterial.getValueAt(i, 5));
        }
        bean.setMateriais(listaMateriais);
        bean.setNotaFiscal(this.notaFiscalAux);
        bean.setPedido(this.pedidoAux);
        return bean;
    }

    @Override
    public boolean validaCampos() {
        for (int i = 0; i < this.modeloMaterial.getRowCount(); ++i) {
            if (this.modeloMaterial.getValueAt(i, 3) == null) {
                Funcoes.mensagem(this, "A quantidade recebida de todos os materiais deve ser preenchida.", 2);
                return false;
            }
            Double qtde = Double.parseDouble(Funcoes.limpaDecimal((String)this.modeloMaterial.getValueAt(i, 3)));
            if (qtde <= 0.0) {
                Funcoes.mensagem(this, "A quantidade recebida dever ser maior que zero.", 2);
                return false;
            }
            if (this.modeloMaterial.getValueAt(i, 4) != null) continue;
            Funcoes.mensagem(this, "A c\u00e9lula de todas as entradas de material devem ser preenchidas.", 2);
            return false;
        }
        if (this.tableMaterial.getRowCount() == 0) {
            Funcoes.mensagem(this, "Pelo menos um Material deve ser adicionado.", 2);
            return false;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() != this.buttonOK && e.getSource() != this.buttonBuscaMaterial && e.getSource() != this.buttonImportar) {
            if (e.getSource() == this.itemEditarMaterial) {
                this.editandoMaterial();
            } else if (e.getSource() == this.itemVisualizarLote) {
                this.editarVisualizarLotes();
            }
        }
    }

    @Override
    public String getRetornoParaPesquisa() {
        return "";
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return null;
    }
}

