/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.estoque.almoxarifado;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.estoque.JanelaDetalhamentoLancamentos;
import jalis.laboratorio.estoque.almoxarifado.DialogoComentarioEmLote;
import jalis.model.bean.estoque.MaterialBean;
import jalis.model.bean.estoque.MaterialLoteBean;
import jalis.model.bean.estoque.MaterialLoteHistoricoBean;
import jalis.model.bean.estoque.MaterialLoteLanctoEstoqueBean;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.estoque.CelulaEstoqueVO;
import jalis.model.vo.estoque.MaterialLoteVO;
import jalis.service.estoque.MaterialLoteHistoricoService;
import jalis.service.estoque.MaterialLoteService;
import jalis.service.estoque.MaterialService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

public class AberturaFechamentoLote
extends FrmCadPadrao
implements ActionListener {
    private static final int COLUNA_LOTE = 0;
    private static final int COLUNA_DATA = 1;
    private static final int COLUNA_VALIDADE = 2;
    private static final int COLUNA_QTDE = 3;
    private static final int COLUNA_CONSUMIDO = 4;
    private static final int COLUNA_DATA_ABERTURA = 5;
    private static final int COLUNA_USUARIO_ABERTURA = 6;
    private static final int COLUNA_DATA_FECHAMENTO = 7;
    private static final int COLUNA_USUARIO_FECHAMENTO = 8;
    private static final int COLUNA_OBJETO = 9;
    private JLabel labelMaterial = new JLabel("Material:");
    private JLabel labelDescMaterial = new JLabel("");
    private TTextField textMaterial = new TTextField(5, 1);
    private JPopupMenu menuAbrirLote = new JPopupMenu();
    private JButton buttonAbrirFechar = new JButton("Abrir lote \u25bc");
    private JMenuItem itemAbrirLote = new JMenuItem("Abrir lote");
    private JMenuItem itemAbrirLoteComentario = new JMenuItem("Abrir lote coment\u00e1rio");
    private JMenuItem itemFecharLote = new JMenuItem("Fechar lote");
    private JMenuItem itemFecharLoteComentario = new JMenuItem("Fechar lote coment\u00e1rio");
    private JButton buttonHistorico = new JButton("Hist\u00f3rico");
    private JButton buttonBuscaMaterial = ComponenteFactory.novoJButton(this, new Dimension(20, 20), new Dimension(20, 20), true);
    private JPanel panelBotoes = new JPanel(new GridBagLayout());
    private JPanel panelCentro = new JPanel(new GridBagLayout());
    private JPanel panelLotes = new JPanel(new BorderLayout());
    private ModeloGridTable modeloLotes = null;
    private JTable tableLotes = null;
    private JScrollPane scrollLotes = null;
    private String[] colunasGrid = new String[]{"Lote", "Data", "Validade", "Qtde.", "Consumido", "Dt. abertura", "Usu. abertura", "Dt. fechamento", "Usu. fechamento"};
    private int[] colunasTamanho = new int[]{250, 80, 80, 80, 80, 120, 120, 120, 120};
    private MaterialService serviceMaterial = new MaterialService();
    private MaterialLoteService serviceMatLot = new MaterialLoteService();

    public AberturaFechamentoLote() {
        this.montaTela();
        this.controlaCampos();
    }

    private void montaTela() {
        this.setLayout(new BorderLayout());
        this.modeloLotes = new ModeloGridTable(this.colunasGrid);
        this.tableLotes = new JTable(this.modeloLotes);
        this.scrollLotes = new JScrollPane(this.tableLotes);
        this.tableLotes.setAutoResizeMode(0);
        ScreenUtil.setBorda(new Component[]{this.labelDescMaterial}, new TitledBorder(""));
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelCentro, "Center");
        this.panelCentro.setBorder(ScreenUtil.criarBordaVazia());
        Funcoes.criaBarraDescricao(this, "Abertura e fechamento de lotes", "Abertura e fechamento de lotes", "estoque/abertura_lote.jpg");
        this.modeloLotes.setColumnSize(this.colunasTamanho, this.tableLotes);
        JPanel panelCabecalho = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 1);
        this.labelMaterial.setPreferredSize(new Dimension(53, 20));
        panelCabecalho.add((Component)this.labelMaterial, c);
        ++c.gridx;
        this.textMaterial.setPreferredSize(new Dimension(60, 20));
        panelCabecalho.add((Component)this.textMaterial, c);
        ++c.gridx;
        c.insets = new Insets(0, 0, 0, 1);
        panelCabecalho.add((Component)this.buttonBuscaMaterial, c);
        ++c.gridx;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = new Insets(1, 1, 1, 1);
        this.labelDescMaterial.setPreferredSize(new Dimension(60, 20));
        panelCabecalho.add((Component)this.labelDescMaterial, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 1, 1);
        c.gridwidth = 5;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.panelCentro.add((Component)panelCabecalho, c);
        ++c.gridy;
        c.insets = new Insets(0, 1, 0, 0);
        c.gridwidth = 1;
        c.fill = 0;
        c.weightx = 0.0;
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 5;
        c.insets = new Insets(0, 1, 0, 1);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.panelCentro.add((Component)this.panelLotes, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 5;
        c.insets = new Insets(1, 1, 1, 1);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.panelCentro.add((Component)this.panelLotes, c);
        ++c.gridy;
        c.fill = 2;
        c.weighty = 0.0;
        ++c.gridy;
        this.panelCentro.add((Component)this.panelBotoes, c);
        this.panelLotes.setBorder(BorderFactory.createTitledBorder("Lotes"));
        this.panelLotes.add((Component)this.scrollLotes, "Center");
        c = new GridBagConstraints();
        c.insets = new Insets(1, 3, 10, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        JPanel panelbtnEsquerda = new JPanel();
        this.buttonAbrirFechar.setMnemonic('A');
        panelbtnEsquerda.add(this.buttonAbrirFechar);
        this.menuAbrirLote.add(this.itemAbrirLote);
        this.menuAbrirLote.add(this.itemAbrirLoteComentario);
        this.itemAbrirLote.addActionListener(action -> this.modificarLoteSelecionado(null));
        this.itemAbrirLoteComentario.addActionListener(action -> this.acaoAbrirLoteComentario());
        this.itemFecharLote.addActionListener(action -> this.modificarLoteSelecionado(null));
        this.itemFecharLoteComentario.addActionListener(action -> this.acaoAbrirLoteComentario());
        this.buttonHistorico.setMnemonic('H');
        panelbtnEsquerda.add(this.buttonHistorico);
        this.buttonHistorico.addActionListener(this);
        this.panelBotoes.add((Component)panelbtnEsquerda, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.panelBotoes.add((Component)new JPanel(), c);
        JPanel panelbtnDireita = new JPanel();
        panelbtnDireita.add(this.botaoNovo);
        panelbtnDireita.add(this.botaoCancelar);
        panelbtnDireita.add(this.botaoFechar);
        ++c.gridx;
        c.weightx = 0.0;
        this.panelBotoes.add((Component)panelbtnDireita, c);
        this.buttonAbrirFechar.setEnabled(false);
        this.buttonHistorico.setEnabled(false);
        Funcoes.montaEnter((JComponent)this.panelCentro);
        this.textMaterial.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                AberturaFechamentoLote.this.preencheTable();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.textMaterial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    AberturaFechamentoLote.this.buscaMaterial();
                }
            }
        });
        this.tableLotes.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row = AberturaFechamentoLote.this.tableLotes.getSelectedRow();
                if (row > -1) {
                    MaterialLoteBean materialLoteBean = (MaterialLoteBean)AberturaFechamentoLote.this.modeloLotes.getValueAt(row, 9);
                    MaterialLoteBean mat = (MaterialLoteBean)AberturaFechamentoLote.this.modeloLotes.getValueAt(row, 9);
                    AberturaFechamentoLote.this.buttonHistorico.setEnabled(true);
                    if (materialLoteBean.getDataHoraFechado() == null && materialLoteBean.getDataHoraAberto() != null) {
                        AberturaFechamentoLote.this.buttonAbrirFechar.setText("Fechar lote \u25bc");
                    } else {
                        AberturaFechamentoLote.this.buttonAbrirFechar.setText("Abrir lote \u25bc");
                    }
                    if (AberturaFechamentoLote.this.buttonAbrirFechar.getText().contains("Abrir") && mat.getQuantidade().equals(mat.getQuantidadeConsumida())) {
                        AberturaFechamentoLote.this.buttonAbrirFechar.setEnabled(false);
                    } else {
                        AberturaFechamentoLote.this.buttonAbrirFechar.setEnabled(true);
                    }
                    AberturaFechamentoLote.this.acaoBotaoAbrirFecharLote();
                }
            }
        });
    }

    private void acaoAbrirLoteComentario() {
        DialogoComentarioEmLote comentarioLote = DialogoComentarioEmLote.novaInstancia(this.getTopLevelAncestor());
        if (comentarioLote.getOK()) {
            this.modificarLoteSelecionado(comentarioLote.getComentario());
        }
    }

    private void acaoBotaoAbrirFecharLote() {
        this.buttonAbrirFechar.addActionListener(action -> {
            if (this.buttonAbrirFechar.getText().equals("Fechar lote \u25bc")) {
                this.menuAbrirLote.removeAll();
                this.menuAbrirLote.add(this.itemFecharLote);
                if (Acesso.getAcesso(AberturaFechamentoLote.getModuloAcessoAdiconarComentario())) {
                    this.menuAbrirLote.add(this.itemFecharLoteComentario);
                }
                this.menuAbrirLote.show(this.buttonAbrirFechar.getParent(), this.buttonAbrirFechar.getX(), this.buttonAbrirFechar.getY() + this.buttonAbrirFechar.getHeight());
            } else {
                this.menuAbrirLote.removeAll();
                this.menuAbrirLote.add(this.itemAbrirLote);
                if (Acesso.getAcesso(AberturaFechamentoLote.getModuloAcessoAdiconarComentario())) {
                    this.menuAbrirLote.add(this.itemAbrirLoteComentario);
                }
                this.menuAbrirLote.show(this.buttonAbrirFechar.getParent(), this.buttonAbrirFechar.getX(), this.buttonAbrirFechar.getY() + this.buttonAbrirFechar.getHeight());
            }
        });
    }

    private void modificarLoteSelecionado(String comentario) {
        int row = this.tableLotes.getSelectedRow();
        if (row > -1) {
            MaterialLoteBean mat;
            if (this.validaCampos() && (mat = (MaterialLoteBean)this.modeloLotes.getValueAt(row, 9)) != null) {
                this.abrirFecharLote(mat, comentario);
            }
        } else {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Nenhum registro selecionado!", 3);
        }
    }

    private void abrirFecharLote(MaterialLoteBean materialLoteBean, String comentario) {
        String tipoOperacao;
        boolean loteAbertoFechado;
        UsuarioVO usuario = new UsuarioVO();
        usuario.setFilial(materialLoteBean.getFilial());
        usuario.setCodigo(Variaveis.login);
        boolean bl = loteAbertoFechado = materialLoteBean.getDataHoraFechado() == null && materialLoteBean.getDataHoraAberto() != null;
        if (loteAbertoFechado) {
            if (materialLoteBean.getUsuarioAberturaInicial() == null) {
                materialLoteBean.setUsuarioAberturaInicial(usuario);
            }
            if (materialLoteBean.getDataHoraAberturaInicial() == null) {
                materialLoteBean.setDataHoraAberturaInicial(Funcoes.getDataHoraServidor());
            }
            materialLoteBean.setDataHoraFechado(Funcoes.getDataHoraServidor());
            materialLoteBean.setUsuarioFechamento(usuario);
            this.buttonAbrirFechar.setText("Abrir lote \u25bc");
            tipoOperacao = "F";
        } else {
            materialLoteBean.setUsuarioAberto(usuario);
            materialLoteBean.setDataHoraAberto(Funcoes.getDataHoraServidor());
            materialLoteBean.setDataHoraFechado(null);
            materialLoteBean.setUsuarioFechamento(null);
            this.buttonAbrirFechar.setText("Fechar lote \u25bc");
            tipoOperacao = "A";
        }
        try {
            this.serviceMatLot.gravaAutoCopiaSemCommit(materialLoteBean, 1, Variaveis.filialPadrao, null);
            MaterialLoteHistoricoBean materialLoteHistoricoBean = new MaterialLoteHistoricoBean();
            materialLoteHistoricoBean.setDataHora(Funcoes.getDataHoraServidor());
            materialLoteHistoricoBean.setFilial(materialLoteBean.getFilial());
            materialLoteHistoricoBean.setMaterialLote((MaterialLoteVO)materialLoteBean.toVO());
            materialLoteHistoricoBean.setOperacao(tipoOperacao);
            materialLoteHistoricoBean.setUsuarioCriacao(usuario);
            if (comentario != null) {
                materialLoteHistoricoBean.setComentario(comentario);
            }
            MaterialLoteHistoricoService materialLoteHistoricoService = new MaterialLoteHistoricoService();
            materialLoteHistoricoService.gravaAutoCopiaSemCommit(materialLoteHistoricoBean, 0, Variaveis.filialPadrao, null);
            Conexao.arquivaSQL();
            int rowIndex = this.tableLotes.getSelectedRow();
            this.modeloLotes.setValueAt(Funcoes.formataData("dd/MM/yyyy HH:mm", materialLoteBean.getDataHoraAberto()), rowIndex, 5);
            this.modeloLotes.setValueAt(materialLoteBean.getUsuarioAberto(), rowIndex, 6);
            this.modeloLotes.setValueAt(Funcoes.formataData("dd/MM/yyyy HH:mm", materialLoteBean.getDataHoraFechado()), rowIndex, 7);
            this.modeloLotes.setValueAt(materialLoteBean.getUsuarioFechamento(), rowIndex, 8);
            this.modeloLotes.setValueAt(materialLoteBean, rowIndex, 9);
            Funcoes.mensagem(Laboratorio.getInstancia(), String.format("Lote %s com sucesso.", !loteAbertoFechado ? "aberto" : "fechado"), 3);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel abrir ou fechar o lote.", e.getStackTrace());
        }
    }

    @Override
    public void novo() {
        if (!ParametrosGerais.isExigirAberturaLote()) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "O par\u00e2metro geral \"Exigir abertura e fechamento de lotes de material\" \ndeve estar ativo para utilizar Abertura e Fechamento de lotes.", 5);
            return;
        }
        this.textMaterial.setEnabled(true);
        this.buttonBuscaMaterial.setEnabled(true);
        this.botaoCancelar.setEnabled(true);
        this.botaoNovo.setEnabled(false);
        ScreenUtil.requisitarFoco(this.textMaterial);
    }

    private void limparCampos() {
        this.modeloLotes.clear();
        this.textMaterial.clear();
        this.labelDescMaterial.setText("");
    }

    @Override
    @Deprecated
    public void salvar() {
    }

    @Override
    public void cancelar() {
        this.textMaterial.setEnabled(false);
        this.buttonBuscaMaterial.setEnabled(false);
        this.botaoCancelar.setEnabled(false);
        this.botaoNovo.setEnabled(true);
        this.buttonAbrirFechar.setEnabled(false);
        this.buttonHistorico.setEnabled(false);
        this.limparCampos();
    }

    @Override
    @Deprecated
    public void excluir() {
    }

    @Override
    @Deprecated
    public void editar() {
    }

    @Override
    public void fechar() {
        this.setVisible(false);
    }

    @Override
    public boolean validaCampos() {
        int row = this.tableLotes.getSelectedRow();
        MaterialLoteBean mat = (MaterialLoteBean)this.modeloLotes.getValueAt(row, 9);
        if (this.buttonAbrirFechar.getText().contains("Abrir") && mat.getQuantidade().equals(mat.getQuantidadeConsumida())) {
            StringBuilder mensagem = new StringBuilder();
            mensagem.append("Lote n\u00e3o pode ser aberto.\nPois encontra-se completamente consumido e encerrado.\nDt. Fechamento: ");
            mensagem.append(Funcoes.formataData(mat.getDataHoraFechado())).append("\nUsu\u00e1rio Fechamento: ").append(mat.getUsuarioFechamento());
            Funcoes.mensagem(Laboratorio.getInstancia(), mensagem.toString(), 2);
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public String getRetornoParaPesquisa() {
        return null;
    }

    @Override
    @Deprecated
    public String getCampoRetornoParaPesquisa() {
        return null;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("1200300140");
    }

    public static long getModuloAcessoAdiconarComentario() {
        return Long.parseLong("1200300141");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonBuscaMaterial) {
            this.buscaMaterial();
        } else if (e.getSource() == this.buttonHistorico) {
            this.mostrarLotes();
        }
    }

    private void mostrarLotes() {
        String lote = (String)this.modeloLotes.getValueAt(this.tableLotes.getSelectedRow(), 0);
        MaterialLoteBean obj = (MaterialLoteBean)this.modeloLotes.getValueAt(this.tableLotes.getSelectedRow(), 9);
        Set<MaterialLoteLanctoEstoqueBean> loteLancamentos = obj.getLancamentosEstoque();
        CelulaEstoqueVO celula = obj.getLancamentoEstoqueEntrada().getCelula();
        JanelaDetalhamentoLancamentos janela = new JanelaDetalhamentoLancamentos(Laboratorio.getInstancia(), obj.getMaterial().getDescricao(), lote, loteLancamentos, celula, (int)obj.getCodigo());
        janela.setVisible(true);
    }

    private void buscaMaterial() {
        Hashtable hash = Pesquisas.materialAtivo(Laboratorio.getInstancia(), true);
        if (hash != null) {
            MaterialBean bean = null;
            try {
                bean = (MaterialBean)new MaterialService().getAtivo(Variaveis.filialPadrao, String.valueOf((Integer)hash.get("mat_codigo")), null, null);
            }
            catch (Exception e1) {
                Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel buscar dados do material.", 2);
                return;
            }
            if (bean != null) {
                this.textMaterial.setText(String.valueOf(bean.getCodigo()));
                this.labelDescMaterial.setText(bean.getDescricao());
                this.preencheTable();
            } else {
                this.textMaterial.setText(String.valueOf((Integer)hash.get("mat_codigo")));
                this.labelDescMaterial.setText("N\u00e3o cadastrado");
            }
        }
    }

    private void controlaCampos() {
        this.textMaterial.setEnabled(false);
        this.buttonBuscaMaterial.setEnabled(false);
    }

    private void preencheTable() {
        if (!Funcoes.textoVazio(this.textMaterial)) {
            try {
                MaterialBean mat = (MaterialBean)this.serviceMaterial.get(this.textMaterial.getText());
                if (mat != null) {
                    if (!mat.getSolicitarLote().booleanValue()) {
                        Funcoes.mensagem(Laboratorio.getInstancia(), "Material selecionado n\u00e3o faz controle de lote.", 5);
                        this.textMaterial.clear();
                        ScreenUtil.requisitarFoco(this.textMaterial);
                        return;
                    }
                    this.labelDescMaterial.setText(mat.getDescricao());
                    HashMap<String, Object> chaves = new HashMap<String, Object>();
                    chaves.put("fil_codigo", Variaveis.filialPadrao);
                    chaves.put("mat_codigo", this.textMaterial.getText());
                    ArrayList<MaterialLoteBean> listaLotes = this.serviceMatLot.getBeans(chaves, true);
                    if (listaLotes == null) {
                        Funcoes.mensagem(Laboratorio.getInstancia(), "Nenhum lote localizado para o material selecionado.", 5);
                        this.textMaterial.clear();
                        ScreenUtil.requisitarFoco(this.textMaterial);
                        return;
                    }
                    Collections.sort(listaLotes);
                    if (listaLotes != null) {
                        for (int i = 0; i < listaLotes.size(); ++i) {
                            MaterialLoteBean aux = listaLotes.get(i);
                            this.modeloLotes.addLine(new Object[]{aux.getLote(), Funcoes.formataData("dd/MM/yyyy", aux.getDataLote()), Funcoes.formataData("dd/MM/yyyy", aux.getValidadeLote()), Funcoes.formataDecimal(aux.getQuantidade()), Funcoes.formataDecimal(aux.getQuantidadeConsumida()), Funcoes.formataData("dd/MM/yyyy HH:mm", aux.getDataHoraAberto()), aux.getUsuarioAberto(), Funcoes.formataData("dd/MM/yyyy HH:mm", aux.getDataHoraFechado()), aux.getUsuarioFechamento(), aux});
                        }
                    }
                } else {
                    this.labelDescMaterial.setText("N\u00e3o cadastrado");
                    this.textMaterial.clear();
                    ScreenUtil.requisitarFoco(this.textMaterial);
                    return;
                }
                this.textMaterial.setEnabled(false);
                this.buttonBuscaMaterial.setEnabled(false);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel localizar lotes do material.", e.getStackTrace());
            }
        }
    }
}

