/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.estoque;

import jalis.comum.Acesso;
import jalis.comum.ParametrosGerais;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.estoque.AssociarLote;
import jalis.laboratorio.estoque.JanelaDetalhamentoLancamentos;
import jalis.laboratorio.estoque.MaterialLoteLancamentoInserir;
import jalis.laboratorio.estoque.SolicitarLoteMaterial;
import jalis.laboratorio.estoque.util.ButtonRenderer;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.estoque.MaterialBean;
import jalis.model.bean.estoque.MaterialLoteBean;
import jalis.model.bean.estoque.MaterialLoteLanctoEstoqueBean;
import jalis.model.dao.estoque.MaterialDao;
import jalis.model.vo.estoque.CelulaEstoqueVO;
import jalis.model.vo.estoque.LancamentoEstoqueVO;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;

public class VisualizarLoteMaterial
extends AbstractDialogoOKCancelar {
    private static final long ACESSO_VISUALIZAR_LANCAMENTOS_LOTE = Long.parseLong("0101300304");
    private static boolean acessoVisualizarLancamentosLote = Acesso.getAcesso(ACESSO_VISUALIZAR_LANCAMENTOS_LOTE);
    private static final int COLUNA_LOTE = 0;
    private static final int COLUNA_DATA = 1;
    private static final int COLUNA_VALIDADE = 2;
    private static final int COLUNA_CELULA = 3;
    private static final int COLUNA_QUANTIDADE = 4;
    private static final int COLUNA_RESTANTE = 5;
    private static final int COLUNA_OBSERVACAO = 6;
    private static final int COLUNA_LANCAMENTOS = 7;
    private static final int COLUNA_OBJETO = acessoVisualizarLancamentosLote ? 8 : 7;
    private static final String PARAMETROS_VISUALIZAR_LOTE = "VisualizarLoteMaterial.ultimoFiltro";
    private static final String PARAMETRO_MOSTRAR_LOTES_CONSUMIDOS = "mostrarconsumidos";
    private JLabel labelVlrQtdeTotal = new JLabel("0,00");
    private JLabel labelVlrQtdeRestanteTotal = new JLabel("0,00");
    private JPanel panelLotes = new JPanel(new BorderLayout());
    private JPanel panelTotal = new JPanel(new GridBagLayout());
    private JPanel panelLegenda = new JPanel(new GridBagLayout());
    private JCheckBox checkMostrarLotesConsumidos = new JCheckBox("Mostrar lotes consumidos");
    private ModeloGridTable modeloLotes = null;
    private JTable tableLotes = null;
    private JScrollPane scrollLotes = null;
    private ArrayList<MaterialLoteBean> lotes = null;
    private ArrayList<MaterialLoteBean> lotesConsumidos = null;
    private ArrayList<MaterialLoteBean> lotesAbertos = null;
    private String codigoUnidade = "";
    private Double saldoAtual = null;
    private Double saldoRestanteLote = null;
    private String descricaoMaterial = null;
    private boolean isMostrarLoteConsumido = false;
    private boolean isMostrarBotaoAssociarLotes = false;
    private MaterialBean materialBean = new MaterialBean();
    protected JButton buttonAssociarLote = ComponenteFactory.novoJButton("Associar lotes", 'L', this);
    private List<MaterialLoteLancamentoInserir> loteLanctoInserir = new ArrayList<MaterialLoteLancamentoInserir>();
    private List<MaterialLoteLancamentoInserir> loteLanctoRemover = new ArrayList<MaterialLoteLancamentoInserir>();
    private List<List<Object>> listsLotesTemp = new ArrayList<List<Object>>();
    private List<List<Object>> listsLotesTempRemover = new ArrayList<List<Object>>();
    private String codigoMaterial;

    public VisualizarLoteMaterial(Dialog pai, String descricaoMaterial, String descricaoUnidade, ArrayList<MaterialLoteBean> lotes, Double saldoAtual, MaterialBean beanMat, List<List<Object>> loteLanctoInserir, List<List<Object>> loteLanctoRemover, boolean isMostrarBotaoAssociarLotes, String codigoMaterial) {
        super(pai, "Lotes do material" + (Funcoes.textoVazio(descricaoMaterial) ? "" : " - " + descricaoMaterial));
        this.lotes = lotes;
        this.codigoUnidade = descricaoUnidade;
        this.saldoAtual = saldoAtual;
        this.descricaoMaterial = descricaoMaterial;
        this.materialBean = beanMat;
        this.listsLotesTemp = loteLanctoInserir;
        this.listsLotesTempRemover = loteLanctoRemover;
        this.isMostrarBotaoAssociarLotes = isMostrarBotaoAssociarLotes;
        this.codigoMaterial = codigoMaterial;
        this.montaTela();
    }

    public VisualizarLoteMaterial(Frame pai, String descricaoMaterial, String descricaoUnidade, ArrayList<MaterialLoteBean> lotes, Double saldoAtual, MaterialBean beanMat, List<List<Object>> loteLanctoInserir, List<List<Object>> loteLanctoRemover, boolean isMostrarBotaoAssociarLotes, String codigoMaterial) {
        super(pai, "Lotes do material" + (Funcoes.textoVazio(descricaoMaterial) ? "" : " - " + descricaoMaterial));
        this.lotes = lotes;
        this.codigoUnidade = descricaoUnidade;
        this.saldoAtual = saldoAtual;
        this.descricaoMaterial = descricaoMaterial;
        this.materialBean = beanMat;
        this.listsLotesTemp = loteLanctoInserir;
        this.listsLotesTempRemover = loteLanctoRemover;
        this.isMostrarBotaoAssociarLotes = isMostrarBotaoAssociarLotes;
        this.codigoMaterial = codigoMaterial;
        this.montaTela();
    }

    private void montaTela() {
        if (acessoVisualizarLancamentosLote) {
            this.modeloLotes = new ModeloGridTable(new String[]{"Lote", "Data", "Validade", "C\u00e9lula", "Qtde.", "Restante", "Observa\u00e7\u00e3o", "Mov."});
            this.tableLotes = new JTable(this.modeloLotes){

                @Override
                public Class<?> getColumnClass(int column) {
                    if (column == 7) {
                        return Set.class;
                    }
                    return String.class;
                }

                @Override
                public boolean isCellEditable(int row, int column) {
                    return column == 7;
                }
            };
            this.tableLotes.setRowHeight(20);
            this.modeloLotes.setColumnSize(new int[]{100, 80, 80, 0, 60, 70, 0, 30}, this.tableLotes);
        } else {
            this.modeloLotes = new ModeloGridTable(new String[]{"Lote", "Data", "Validade", "C\u00e9lula", "Qtde.", "Restante", "Observa\u00e7\u00e3o"});
            this.tableLotes = new JTable(this.modeloLotes);
            this.modeloLotes.setColumnSize(new int[]{100, 80, 80, 0, 60, 70, 0}, this.tableLotes);
        }
        JPanel panelCentral = this.getPanelCentral();
        panelCentral.setLayout(new GridBagLayout());
        RendererLotes loteRenderer = new RendererLotes();
        loteRenderer.setDataAtual(Funcoes.getDataServidor());
        ButtonRenderer buttonRenderer = new ButtonRenderer();
        ButtonEditor buttonEditor = new ButtonEditor();
        this.tableLotes.getTableHeader().addMouseListener(this.modeloLotes);
        this.scrollLotes = new JScrollPane(this.tableLotes);
        this.tableLotes.setDefaultRenderer(Object.class, loteRenderer);
        if (acessoVisualizarLancamentosLote) {
            this.tableLotes.setDefaultRenderer(Set.class, buttonRenderer);
            this.tableLotes.setDefaultEditor(Set.class, buttonEditor);
        }
        this.setResizable(false);
        this.setSize(750, 450);
        this.panelLotes.add((Component)this.scrollLotes, "Center");
        this.panelLotes.add((Component)this.checkMostrarLotesConsumidos, "South");
        Insets insetPadrao = new Insets(1, 0, 0, 1);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, insetPadrao.bottom, insetPadrao.right);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.anchor = 17;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.panelLotes.setBorder(new TitledBorder("Lotes"));
        panelCentral.add((Component)this.panelLotes, c);
        ++c.gridy;
        c.weighty = 0.0;
        c.fill = 2;
        panelCentral.add((Component)this.panelTotal, c);
        ++c.gridy;
        panelCentral.add((Component)this.panelLegenda, c);
        this.montaPanelTotal();
        this.montaPanelLegenda();
        Funcoes.montaEnter((JComponent)panelCentral);
        Funcoes.defineUpperCase(panelCentral, ParametrosGerais.getUpperCase());
        ScreenUtil.centralizar(this);
        this.setDefaultCloseOperation(0);
        this.carregaParametrosUsuario();
        this.carregaDadosLotes(false);
        this.modeloLotes.setSentidoOrdenacao(1);
        this.modeloLotes.ordenarColunaSemTrocarSentido(2);
        this.checkMostrarLotesConsumidos.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                VisualizarLoteMaterial.this.isMostrarLoteConsumido = e.getStateChange() == 1;
                VisualizarLoteMaterial.this.carregaDadosLotes(false);
            }
        });
        this.buttonAssociarLote.setVisible(Acesso.getAcesso(AssociarLote.getAcessoAssociarLote()) && this.isMostrarBotaoAssociarLotes);
        this.getPanelBotoesEsquerda().add(this.buttonAssociarLote);
        this.buttonOK.setText("Fechar");
        this.buttonOK.setMnemonic('e');
        this.buttonCancelar.setVisible(false);
    }

    private void carregaParametrosUsuario() {
    }

    private void salvaParametrosUsuario() {
    }

    private void atualizarTotais() {
        Double qtde = 0.0;
        Double qtdeRestante = 0.0;
        for (MaterialLoteBean aux : this.lotes) {
            if (aux.getRemovido().booleanValue()) continue;
            qtde = qtde + aux.getQuantidade();
            qtdeRestante = qtdeRestante + (aux.getQuantidade() - aux.getQuantidadeConsumida());
        }
        this.labelVlrQtdeTotal.setText(Funcoes.formataDecimal(qtde != null ? qtde : 0.0));
        this.saldoRestanteLote = qtdeRestante;
        this.labelVlrQtdeRestanteTotal.setText(Funcoes.formataDecimal(qtdeRestante != null ? qtdeRestante : 0.0));
    }

    private void montaPanelTotal() {
        JPanel panelEsquerda = new JPanel(new FlowLayout(0));
        panelEsquerda.add(new JLabel("Estoque atual:"));
        panelEsquerda.add(new JLabel(Funcoes.formataDecimal(this.saldoAtual)));
        panelEsquerda.add(new JLabel("(" + this.codigoUnidade + ")"));
        JPanel panelDireita = new JPanel(new FlowLayout(2));
        panelDireita.add(new JLabel("Restante:"));
        panelDireita.add(this.labelVlrQtdeRestanteTotal);
        panelDireita.add(new JLabel("(" + this.codigoUnidade + ")"));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        this.panelTotal.add((Component)panelEsquerda, c);
        ++c.gridx;
        this.panelTotal.add((Component)panelDireita, c);
    }

    private void montaPanelLegenda() {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        JPanel pnlCorLegenda = new JPanel();
        pnlCorLegenda.setPreferredSize(new Dimension(10, 10));
        pnlCorLegenda.setBackground(SolicitarLoteMaterial.COR_LOTE_CONSUMIDO);
        pnlCorLegenda.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        this.panelLegenda.add((Component)pnlCorLegenda, c);
        JLabel lblLegenda = new JLabel("Lote consumido");
        Font font = new Font(lblLegenda.getFont().getName(), 0, 10);
        lblLegenda.setFont(font);
        ++c.gridx;
        this.panelLegenda.add((Component)lblLegenda, c);
        ++c.gridx;
        this.panelLegenda.add((Component)new JLabel("  "), c);
        pnlCorLegenda = new JPanel();
        pnlCorLegenda.setPreferredSize(new Dimension(10, 10));
        pnlCorLegenda.setBackground(SolicitarLoteMaterial.COR_LOTE_EM_CONSUMO);
        pnlCorLegenda.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        ++c.gridx;
        this.panelLegenda.add((Component)pnlCorLegenda, c);
        lblLegenda = new JLabel("Lote em consumo");
        font = new Font(lblLegenda.getFont().getName(), 0, 10);
        lblLegenda.setFont(font);
        ++c.gridx;
        this.panelLegenda.add((Component)lblLegenda, c);
        ++c.gridx;
        this.panelLegenda.add((Component)new JLabel("  "), c);
        pnlCorLegenda = new JPanel();
        pnlCorLegenda.setPreferredSize(new Dimension(10, 10));
        pnlCorLegenda.setBackground(SolicitarLoteMaterial.COR_LOTE_VENCIDO);
        pnlCorLegenda.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        ++c.gridx;
        this.panelLegenda.add((Component)pnlCorLegenda, c);
        lblLegenda = new JLabel("Lote vencido");
        font = new Font(lblLegenda.getFont().getName(), 0, 10);
        lblLegenda.setFont(font);
        ++c.gridx;
        this.panelLegenda.add((Component)lblLegenda, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.panelLegenda.add((Component)new JLabel(""), c);
    }

    private void carregaDadosLotes(boolean isAssociandoLotes) {
        this.modeloLotes.clear();
        if (isAssociandoLotes) {
            this.loteLanctoInserir.clear();
        }
        try {
            if (this.lotesConsumidos == null && (this.isMostrarLoteConsumido || isAssociandoLotes)) {
                new MaterialDao().carregarDadosLotes(this.materialBean, null, null, true);
                this.lotesConsumidos = this.materialBean.getLotes();
            }
            if (this.lotesAbertos == null && !this.isMostrarLoteConsumido) {
                new MaterialDao().carregarDadosLotes(this.materialBean, null, null, false);
                this.lotesAbertos = this.materialBean.getLotes();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<MaterialLoteBean> arrayList = this.lotes = this.isMostrarLoteConsumido || isAssociandoLotes ? this.lotesConsumidos : this.lotesAbertos;
        if (this.lotes != null) {
            for (MaterialLoteBean aux : this.lotes) {
                String observacao = aux.getObservacao();
                if (!Funcoes.textoVazio(observacao)) {
                    observacao = observacao.replace("\n", " ");
                }
                LancamentoEstoqueVO lanctoEntrada = aux.getLancamentoEstoqueEntrada();
                CelulaEstoqueVO celula = null;
                if (lanctoEntrada != null) {
                    celula = lanctoEntrada.getCelula();
                }
                Double restante = (aux.getQuantidade() == null ? 0.0 : aux.getQuantidade()) - (aux.getQuantidadeConsumida() == null ? 0.0 : aux.getQuantidadeConsumida());
                if (celula == null) continue;
                if (acessoVisualizarLancamentosLote) {
                    this.modeloLotes.addLine(new Object[]{aux.getLote(), Funcoes.formataData(aux.getDataLote()), Funcoes.formataData(aux.getValidadeLote()), celula, Funcoes.formataDecimal(aux.getQuantidade()), Funcoes.formataDecimal(restante), observacao, aux.getLancamentosEstoque(), aux});
                    continue;
                }
                this.modeloLotes.addLine(new Object[]{aux.getLote(), Funcoes.formataData(aux.getDataLote()), Funcoes.formataData(aux.getValidadeLote()), celula, Funcoes.formataDecimal(aux.getQuantidade()), Funcoes.formataDecimal(restante), observacao, aux});
            }
            this.modeloLotes.ordenarColunaSemTrocarSentido(this.modeloLotes.getColunaOrdenacao());
            this.atualizarTotais();
            if (isAssociandoLotes) {
                this.carregaDadosLotesAssociar();
            }
        }
    }

    private void carregaDadosLotesAssociar() {
        if (this.lotes != null) {
            for (MaterialLoteBean aux : this.lotes) {
                for (MaterialLoteLanctoEstoqueBean bean : aux.getLancamentosEstoque()) {
                    aux.setAlterar(true);
                    bean.setEditar(true);
                    this.loteLanctoInserir.add(new MaterialLoteLancamentoInserir(aux, bean));
                }
            }
            if (this.listsLotesTemp.isEmpty()) {
                this.listsLotesTemp.addAll(this.getLoteLanctoInserir());
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOK) {
            this.salvaParametrosUsuario();
            this.setVisible(false);
        } else if (e.getSource().equals(this.buttonAssociarLote)) {
            this.carregaDadosLotes(true);
            HashMap<Object, Object> params = new HashMap<Object, Object>();
            params.put("lotes", this.lotes);
            params.put("material", this.materialBean);
            params.put("saldoAtual", this.saldoAtual);
            params.put("saldoRestanteLote", this.saldoRestanteLote);
            AssociarLote associarLote = new AssociarLote(Laboratorio.getInstancia(), "Associar lotes", params, this.listsLotesTemp, this.listsLotesTempRemover);
            if (associarLote.getOK()) {
                this.setLoteAssociar(associarLote.getLotesInserir());
                this.setLoteLanctoRemover(associarLote.getListRemover());
                this.listsLotesTemp = this.getLoteLanctoInserir();
                this.listsLotesTempRemover = this.getLoteLanctoTempRemover();
            }
            this.carregaDadosLotes(false);
        }
    }

    public List<MaterialLoteLancamentoInserir> getLoteLanctoRemover() {
        return this.loteLanctoRemover;
    }

    public void setLoteLanctoRemover(List<MaterialLoteLancamentoInserir> loteLanctoRemover) {
        this.loteLanctoRemover = loteLanctoRemover;
    }

    private void setLoteAssociar(List<MaterialLoteLancamentoInserir> lotesInserir) {
        this.loteLanctoInserir = lotesInserir;
    }

    public List<List<Object>> getLoteLanctoInserir() {
        ArrayList<List<Object>> list = new ArrayList<List<Object>>();
        for (MaterialLoteLancamentoInserir obj : this.loteLanctoInserir) {
            if (obj.getMaterialLoteLanctoEstoqueBean().getLancamento().getTipo().equals("S")) continue;
            ArrayList<AbstractThreadBean> obList = new ArrayList<AbstractThreadBean>();
            obList.add(obj.getMaterialLoteBean());
            obList.add(obj.getMaterialLoteLanctoEstoqueBean());
            list.add(obList);
        }
        return list;
    }

    public List<List<Object>> getLoteLanctoTempRemover() {
        ArrayList<List<Object>> list = new ArrayList<List<Object>>();
        for (MaterialLoteLancamentoInserir obj : this.loteLanctoRemover) {
            ArrayList<AbstractThreadBean> obList = new ArrayList<AbstractThreadBean>();
            obList.add(obj.getMaterialLoteBean());
            obList.add(obj.getMaterialLoteLanctoEstoqueBean());
            list.add(obList);
        }
        return list;
    }

    public static long getModuloVisualizarLancamentosLote() {
        return ACESSO_VISUALIZAR_LANCAMENTOS_LOTE;
    }

    class ButtonEditor
    extends DefaultCellEditor {
        private JButton button;
        int linha;

        public ButtonEditor() {
            super(new JCheckBox());
            this.linha = -1;
            this.button = new JButton();
            this.button.setOpaque(true);
            Funcoes.imagemPesquisa(this.button);
            this.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ButtonEditor.this.fireEditingStopped();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (isSelected) {
                this.button.setForeground(table.getSelectionForeground());
                this.button.setBackground(table.getSelectionBackground());
            } else {
                this.button.setForeground(table.getForeground());
                this.button.setBackground(table.getBackground());
            }
            this.linha = row;
            return this.button;
        }

        @Override
        public Object getCellEditorValue() {
            if (this.linha > -1) {
                String lote = (String)VisualizarLoteMaterial.this.modeloLotes.getValueAt(this.linha, 0);
                Set loteLancamentos = (Set)VisualizarLoteMaterial.this.modeloLotes.getValueAt(this.linha, 7);
                CelulaEstoqueVO celula = (CelulaEstoqueVO)VisualizarLoteMaterial.this.modeloLotes.getValueAt(this.linha, 3);
                MaterialLoteBean obj = (MaterialLoteBean)VisualizarLoteMaterial.this.modeloLotes.getValueAt(this.linha, COLUNA_OBJETO);
                JanelaDetalhamentoLancamentos janela = new JanelaDetalhamentoLancamentos(VisualizarLoteMaterial.this, VisualizarLoteMaterial.this.descricaoMaterial, lote, (Set<MaterialLoteLanctoEstoqueBean>)loteLancamentos, celula, (int)obj.getCodigo());
                janela.setVisible(true);
                return loteLancamentos;
            }
            return null;
        }

        @Override
        public boolean stopCellEditing() {
            this.linha = -1;
            return super.stopCellEditing();
        }

        @Override
        protected void fireEditingStopped() {
            super.fireEditingStopped();
        }
    }

    class RendererLotes
    extends DefaultTableCellRenderer {
        private Date dataAtual;

        RendererLotes() {
        }

        public void setDataAtual(Date dataAtual) {
            this.dataAtual = dataAtual;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Object valor;
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            MaterialLoteBean obj = (MaterialLoteBean)VisualizarLoteMaterial.this.modeloLotes.getValueAt(row, COLUNA_OBJETO);
            if (obj != null) {
                if (obj.getValidadeLote().compareTo(this.dataAtual) < 0) {
                    if (!isSelected) {
                        comp.setBackground(SolicitarLoteMaterial.COR_LOTE_VENCIDO);
                    } else {
                        comp.setBackground(ScreenUtil.escurecerCor(SolicitarLoteMaterial.COR_LOTE_VENCIDO, 30));
                    }
                } else if (!isSelected) {
                    comp.setBackground(UIManager.getColor("TableHeader.cellBackground"));
                } else {
                    comp.setBackground(UIManager.getColor("TableHeader.focusCellBackground"));
                }
                if (obj.getQuantidade().doubleValue() == obj.getQuantidadeConsumida().doubleValue()) {
                    comp.setForeground(SolicitarLoteMaterial.COR_LOTE_CONSUMIDO);
                } else if (obj.getQuantidadeConsumida() > 0.0) {
                    comp.setForeground(SolicitarLoteMaterial.COR_LOTE_EM_CONSUMO);
                } else {
                    comp.setForeground(table.getForeground());
                }
            }
            if ((valor = table.getValueAt(row, column)) == null || Funcoes.textoVazio(valor.toString())) {
                table.setToolTipText(null);
            } else {
                table.setToolTipText(valor.toString());
            }
            return comp;
        }
    }
}

