/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.estoque;

import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.model.bean.estoque.MaterialLoteBean;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.estoque.CelulaEstoqueVO;
import jalis.model.vo.estoque.MaterialVO;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

public class VisualizaLoteEntrada
extends AbstractDialogoOKCancelar {
    public static final int RETORNO_OK = 0;
    public static final int RETORNO_CANCELAR = 1;
    public static final int RETORNO_ALTERAR_LOTES = 2;
    private static final int COLUNA_LOTE = 0;
    private static final int COLUNA_DATA = 1;
    private static final int COLUNA_VALIDADE = 2;
    private static final int COLUNA_CELULA = 3;
    private static final int COLUNA_QUANTIDADE = 4;
    private static final int COLUNA_OBSERVACAO = 5;
    private static final int COLUNA_OBJETO = 6;
    private int retorno = -1;
    private final ImageIcon IMAGEM_BAIXA_AUTOMATICA = ImagemUtils.carregaImagemJalis("baixaautomatica.png");
    private JPanel panelAvisoBaixaAutomatica = new JPanel(new BorderLayout());
    private ModeloGridTable modeloLotes = null;
    private JTable tableLotes = null;
    private JScrollPane scrollLotes = null;
    private JButton buttonAlterarLotes = ComponenteFactory.novoJButton("Alterar Lotes", 'A', this);
    private static MaterialVO material = null;
    private static ArrayList<MaterialLoteBean> lotesSaida = null;
    private static Double qtdeEntrada = null;
    private static CelulaEstoqueVO celulaEstoque = null;

    public static VisualizaLoteEntrada getInstancia(Window pai, MaterialVO material, ArrayList<MaterialLoteBean> lotesSaida, Double qtdeEntrada, CelulaEstoqueVO celulaEstoque) {
        VisualizaLoteEntrada.material = material;
        VisualizaLoteEntrada.lotesSaida = lotesSaida;
        VisualizaLoteEntrada.qtdeEntrada = qtdeEntrada;
        VisualizaLoteEntrada.celulaEstoque = celulaEstoque;
        if (pai instanceof Dialog) {
            return new VisualizaLoteEntrada((Dialog)pai);
        }
        return new VisualizaLoteEntrada((Frame)pai);
    }

    private VisualizaLoteEntrada(Dialog pai) {
        super(pai, "Inserindo \"" + Funcoes.formataDecimal(qtdeEntrada) + " " + material.getUnidadeMedida().getCodigo() + "\" nos lotes do material \"" + material.getDescricao() + "\".");
        this.montaTela();
    }

    private VisualizaLoteEntrada(Frame pai) {
        super(pai, "Inserindo \"" + Funcoes.formataDecimal(qtdeEntrada) + " " + material.getUnidadeMedida().getCodigo() + "\" nos lotes do material \"" + material.getDescricao() + "\".");
        this.montaTela();
    }

    private void montaTela() {
        this.modeloLotes = new ModeloGridTable(new String[]{"Lote", "Data", "Validade", "C\u00e9lula", "Qtde.", "Observa\u00e7\u00e3o"});
        this.tableLotes = new JTable(this.modeloLotes){

            @Override
            public Class<?> getColumnClass(int column) {
                return String.class;
            }
        };
        this.tableLotes.getTableHeader().addMouseListener(this.modeloLotes);
        this.modeloLotes.setColumnSize(new int[]{0, 80, 80, 0, 60, 0}, this.tableLotes);
        this.scrollLotes = new JScrollPane();
        this.scrollLotes.setViewportView(this.tableLotes);
        JPanel panelCentral = this.getPanelCentral();
        panelCentral.setLayout(new BorderLayout());
        panelCentral.setBorder(new TitledBorder("Novos lotes da c\u00e9lula de estoque " + celulaEstoque != null && celulaEstoque.getDescricao() != null ? celulaEstoque.getDescricao() : ""));
        panelCentral.add((Component)this.scrollLotes, "Center");
        this.getPanelBotoesEsquerda().add((Component)this.panelAvisoBaixaAutomatica, "South");
        this.montaPanelBotoes();
        this.montaPanelAvisoBaixaAutomatica();
        this.preencheDados(lotesSaida);
        this.setSize(780, 400);
        Funcoes.montaEnter((JComponent)panelCentral);
        Funcoes.defineUpperCase(panelCentral, ParametrosGerais.getUpperCase());
        ScreenUtil.centralizar(this);
        this.setDefaultCloseOperation(0);
    }

    private void montaPanelAvisoBaixaAutomatica() {
        if (celulaEstoque.getBaixarAutomatico().booleanValue()) {
            JLabel labelAviso = new JLabel("C\u00e9lula de baixa autom\u00e1tica", this.IMAGEM_BAIXA_AUTOMATICA, 2);
            labelAviso.setForeground(Color.RED);
            this.panelAvisoBaixaAutomatica.add((Component)labelAviso, "West");
        }
    }

    private void montaPanelBotoes() {
        JPanel aux = this.getPanelBotoesDireita();
        aux.removeAll();
        aux.add(this.getBotaoOK());
        aux.add(this.buttonAlterarLotes);
        aux.add(this.getBotaoCancelar());
    }

    private void preencheDados(ArrayList<MaterialLoteBean> lotesSaida) {
        if (lotesSaida == null) {
            return;
        }
        for (MaterialLoteBean lote : lotesSaida) {
            this.adicionaLote(lote);
        }
    }

    private void adicionaLote(MaterialLoteBean loteSaida) {
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        UsuarioVO usuario = new UsuarioVO();
        usuario.setFilial(filial);
        usuario.setCodigo(Variaveis.login);
        MaterialLoteBean novoLote = new MaterialLoteBean();
        novoLote.setFilial(filial);
        novoLote.setDataHoraCriacao(new Date());
        novoLote.setUsuarioCriacao(usuario);
        novoLote.setInserir(true);
        novoLote.setDataLote(loteSaida.getDataLote());
        novoLote.setLote(loteSaida.getLote());
        novoLote.setMaterial(material);
        novoLote.setQuantidade(loteSaida.getQuantidadeConsumida() - loteSaida.getQuantidadeConsumidaOriginal());
        novoLote.setQuantidadeConsumida(0.0);
        novoLote.setValidadeLote(loteSaida.getValidadeLote());
        novoLote.setObservacao(loteSaida.getObservacao());
        novoLote.setRemovido(false);
        novoLote.setLoteEntrada(true);
        this.modeloLotes.addLine(new Object[]{novoLote.getLote(), Funcoes.formataData(novoLote.getDataLote()), Funcoes.formataData("dd/MM/yyyy", novoLote.getValidadeLote()), celulaEstoque, Funcoes.formataDecimal(novoLote.getQuantidade()), novoLote.getObservacao(), novoLote});
        this.modeloLotes.ordenarColunaSemTrocarSentido(this.modeloLotes.getColunaOrdenacao());
    }

    public ArrayList<MaterialLoteBean> getLotes() {
        ArrayList<MaterialLoteBean> lotes = new ArrayList<MaterialLoteBean>();
        for (int i = 0; i < this.modeloLotes.getRowCount(); ++i) {
            lotes.add((MaterialLoteBean)this.modeloLotes.getValueAt(i, 6));
        }
        if (lotes.size() > 0) {
            return lotes;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getBotaoOK()) {
            this.doAcaoOK();
        } else if (e.getSource() == this.getBotaoCancelar()) {
            this.doAcaoCancelar();
        } else if (e.getSource() == this.buttonAlterarLotes) {
            this.doAcaoAlterarLotes();
        }
    }

    private void doAcaoAlterarLotes() {
        this.retorno = 2;
        this.dispose();
    }

    private void doAcaoCancelar() {
        this.retorno = 1;
        this.dispose();
    }

    private void doAcaoOK() {
        this.retorno = 0;
        this.dispose();
    }

    @Override
    @Deprecated
    public boolean getOK() {
        return true;
    }

    public int getRetorno() {
        return this.retorno;
    }
}

