/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.estoque;

import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.model.bean.estoque.MaterialLoteBean;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.estoque.CelulaEstoqueVO;
import jalis.model.vo.estoque.LancamentoEstoqueVO;
import jalis.model.vo.estoque.MaterialVO;
import jalis.service.estoque.MaterialLoteService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextAreaDocument;
import jalis.util.TTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class SolicitarLoteMaterial
extends AbstractDialogoOKCancelar
implements HierarchyListener {
    private int[] colunasTamanho = new int[]{0, 80, 80, 0, 60, 75, 0};
    public static final int TIPO_OPERACAO_ADICIONAR_LOTE = 0;
    public static final int TIPO_OPERACAO_REMOVER_LOTE = 1;
    public static final int TIPO_OPERACAO_VISUALIZAR_LOTE = 2;
    public static final int TIPO_OPERACAO_BAIXA = 3;
    public static final String TIPO_OPERACAO_LOTE_HISTORICO = "A";
    public static final Color COR_LOTE_CONSUMIDO = Color.BLUE;
    public static final Color COR_LOTE_EM_CONSUMO = new Color(60, 130, 0);
    public static final Color COR_LOTE_VENCIDO = new Color(255, 255, 0);
    private final int COLUNA_LOTE = 0;
    private final int COLUNA_DATA = 1;
    private final int COLUNA_VALIDADE = 2;
    private final int COLUNA_CELULA = 3;
    private final int COLUNA_QUANTIDADE = 4;
    private final int COLUNA_CONSUMIDO = 5;
    private final int COLUNA_OBSERVACAO = 6;
    private final int COLUNA_ABERTO = 7;
    private final int COLUNA_OBJETO = 8;
    private JLabel labelMaterial = new JLabel("Material:");
    private JLabel labelLote = new JLabel("Lote:");
    private JLabel labelValidade = new JLabel("Validade:");
    private JLabel labelData = new JLabel("Data:");
    private JLabel labelDias = new JLabel("Dias:");
    private JLabel labelQuantidade = new JLabel("");
    private JLabel labelObservacao = new JLabel("Observa\u00e7\u00e3o");
    private JLabel labelVlrUnidade1 = new JLabel();
    private JLabel labelVlrQtdeTotal = new JLabel("0,00");
    private JLabel labelVlrQtdeSaida = new JLabel("0,00");
    private JLabel labelVlrQtdeRestanteTotal = new JLabel("0,00");
    private JLabel labelDescricaoMaterial = new JLabel();
    private TTextField textLote = new TTextField(40, 3);
    private TTextField textValidade = new TTextField(10, 4);
    private TTextField textData = new TTextField(10, 4);
    private TTextField textQuantidade = new TTextField(12, 2);
    private TTextField textDias = new TTextField(3, 1);
    private JButton buttonValidade = new JButton();
    private JButton buttonData = new JButton();
    private JButton buttonGerarLoteInterno = new JButton("Gerar");
    private JTextArea areaObservacao = new JTextArea();
    private JScrollPane scrollObservacao = null;
    private JPanel panelBotoesLote = new JPanel(new FlowLayout(2));
    private JPanel panelLotes = new JPanel(new BorderLayout());
    private JPanel panelTotal = new JPanel(new GridBagLayout());
    private JPanel panelLegenda = new JPanel(new GridBagLayout());
    private JButton buttonAdicionarAbrirLote = new JButton("Adicionar e abrir");
    private JButton buttonAdicionarLote = new JButton("Adicionar");
    private JButton buttonCancelarLote = new JButton("Cancelar edi\u00e7\u00e3o");
    private ModeloGridTable modeloLotesNovos = null;
    private JTable tableLotesNovos = null;
    private JScrollPane scrollLotesNovos = null;
    private ModeloGridTable modeloLotesAntigos = null;
    private String[] colunasGrid = new String[]{"Lote", "Data", "Validade", "C\u00e9lula", "Qtde.", "Consumido", "Observa\u00e7\u00e3o"};
    private JTable tableLotesAntigos = null;
    private JScrollPane scrollLotesAntigos = null;
    private JTabbedPane paneLotes = new JTabbedPane();
    private ArrayList<MaterialLoteBean> lotes = null;
    private ArrayList<MaterialLoteBean> lotesRemovidos = new ArrayList();
    private MaterialLoteBean loteSelecionadoNovos = null;
    private MaterialLoteBean loteSelecionadoAntigos = null;
    private Integer codigoMaterial = null;
    private boolean isKit = false;
    private double qtdeInserir = 0.0;
    private double qtdeRemover = 0.0;
    private double qtdeOriginal = 0.0;
    private String codigoUnidade = "";
    private Double saldoAtual = null;
    private Double saldoSaidaAtual = null;
    private CelulaEstoqueVO celulaEstoque = null;
    private boolean loteEntrada = false;
    private int tipoOperacao = -1;
    private boolean isEditando = false;
    private int linhaEdicaoNovos = -1;
    private int linhaEdicaoAntigos = -1;
    private boolean isInutilizar = false;

    public SolicitarLoteMaterial(Frame pai, Integer codigoMaterial, String descricaoMaterial, String descricaoUnidade, boolean isKit, ArrayList<MaterialLoteBean> lotes, int tipoOperacao, Double qtdeOriginal, Double qtdeInserir, Double qtdeRemover, Double saldoAtual, CelulaEstoqueVO celulaEstoque, ArrayList<MaterialLoteBean> lotesSugestao, boolean isInutilizar) {
        this(pai, codigoMaterial, descricaoMaterial, descricaoUnidade, isKit, lotes, tipoOperacao, qtdeOriginal, qtdeInserir, qtdeRemover, saldoAtual, celulaEstoque, false, lotesSugestao, isInutilizar);
        if (ParametrosGerais.isExigirAberturaLote()) {
            this.configuraGrid();
        }
    }

    public SolicitarLoteMaterial(Frame pai, Integer codigoMaterial, String descricaoMaterial, String descricaoUnidade, boolean isKit, ArrayList<MaterialLoteBean> lotes, int tipoOperacao, Double qtdeOriginal, Double qtdeInserir, Double qtdeRemover, Double saldoAtual, CelulaEstoqueVO celulaEstoque, boolean loteEntrada, ArrayList<MaterialLoteBean> lotesSugestao, boolean isInutilizar) {
        super(pai, null);
        if (ParametrosGerais.isExigirAberturaLote()) {
            this.configuraGrid();
        }
        this.lotes = lotes;
        this.loteEntrada = loteEntrada;
        this.codigoUnidade = descricaoUnidade;
        this.codigoMaterial = codigoMaterial;
        this.tipoOperacao = tipoOperacao;
        this.qtdeOriginal = qtdeOriginal == null ? 0.0 : qtdeOriginal;
        this.qtdeInserir = qtdeInserir == null ? 0.0 : qtdeInserir;
        this.qtdeRemover = qtdeRemover == null ? 0.0 : qtdeRemover;
        this.saldoAtual = saldoAtual;
        this.celulaEstoque = celulaEstoque;
        this.isKit = isKit;
        this.isInutilizar = isInutilizar;
        this.labelVlrUnidade1.setText(descricaoUnidade);
        if (tipoOperacao != 2) {
            this.montaTela(descricaoMaterial);
        } else {
            this.montaTelaVisualizacao(descricaoMaterial);
        }
        if (this.qtdeInserir > 0.0) {
            this.textQuantidade.setText(Funcoes.formataDecimal(qtdeInserir - this.getTotalInseridoLotesNovos()));
        }
        this.preencheLotesSugestao(lotesSugestao);
    }

    private void configuraGrid() {
        this.colunasGrid = new String[]{"Lote", "Data", "Validade", "C\u00e9lula", "Qtde.", "Consumido", "Observa\u00e7\u00e3o", "Aberto"};
        this.colunasTamanho = new int[]{0, 80, 80, 0, 60, 75, 0, 40};
    }

    private void preencheLotesSugestao(ArrayList<MaterialLoteBean> lotesSugestao) {
        if (lotesSugestao == null) {
            return;
        }
        for (MaterialLoteBean lote : lotesSugestao) {
            this.addLinhaGrid(this.modeloLotesNovos, lote, this.celulaEstoque);
        }
        this.atualizarTotais();
    }

    private void montaTela(String descricaoMaterial) {
        this.setModal(true);
        this.textLote.addHierarchyListener(this);
        this.setUsuarioPodeCancelar(false);
        String titulo = "";
        if (this.qtdeInserir > 0.0 && this.tipoOperacao == 0) {
            titulo = "Inserindo \"" + Funcoes.formataDecimal(this.qtdeInserir);
            this.labelQuantidade.setText("Qtde. lote:");
        } else {
            titulo = "Removendo \"" + Funcoes.formataDecimal(this.qtdeRemover);
            this.labelQuantidade.setText("Qtde. remover:");
            this.buttonAdicionarLote.setText("Alterar");
        }
        titulo = titulo + " " + this.codigoUnidade + "\" nos lotes do material";
        this.labelDescricaoMaterial.setText(Funcoes.textoVazio(descricaoMaterial) ? "" : descricaoMaterial);
        this.setTitle(titulo);
        this.modeloLotesNovos = new ModeloGridTable(this.colunasGrid);
        this.tableLotesNovos = new JTable(this.modeloLotesNovos){

            @Override
            public Class<?> getColumnClass(int column) {
                if (column == 7) {
                    return Boolean.class;
                }
                return String.class;
            }
        };
        this.tableLotesNovos.setDefaultRenderer(String.class, new RendererLotes());
        this.tableLotesNovos.getTableHeader().addMouseListener(this.modeloLotesNovos);
        this.modeloLotesNovos.setColumnSize(this.colunasTamanho, this.tableLotesNovos);
        this.scrollLotesNovos = new JScrollPane();
        this.scrollLotesNovos.setViewportView(this.tableLotesNovos);
        this.modeloLotesAntigos = new ModeloGridTable(this.colunasGrid);
        this.tableLotesAntigos = new JTable(this.modeloLotesAntigos){

            @Override
            public Class<?> getColumnClass(int column) {
                if (column == 7) {
                    return Boolean.class;
                }
                return String.class;
            }
        };
        this.tableLotesAntigos.setDefaultRenderer(String.class, new RendererLotes());
        this.tableLotesAntigos.setDefaultRenderer(Boolean.class, new RendererLotesBoolean());
        this.tableLotesAntigos.getTableHeader().addMouseListener(this.modeloLotesAntigos);
        this.modeloLotesAntigos.setColumnSize(this.colunasTamanho, this.tableLotesAntigos);
        this.scrollLotesAntigos = new JScrollPane();
        this.scrollLotesAntigos.setViewportView(this.tableLotesAntigos);
        JPanel panelCentral = this.getPanelCentral();
        panelCentral.setLayout(new GridBagLayout());
        this.areaObservacao.setDocument(new TTextAreaDocument(300));
        this.areaObservacao.setLineWrap(true);
        this.scrollObservacao = new JScrollPane(this.areaObservacao);
        ScreenUtil.setBorda(new Component[]{this.labelVlrUnidade1}, new TitledBorder(""));
        this.setResizable(false);
        this.setSize(770, 450);
        this.montaPanelTotal(this.panelTotal);
        this.montaPanelLegenda(this.panelLegenda);
        if (this.qtdeRemover == 0.0) {
            this.paneLotes.addTab("Novos", this.scrollLotesNovos);
        }
        this.paneLotes.addTab("Cadastrados", this.scrollLotesAntigos);
        JPanel panelTabbed = new JPanel(new BorderLayout());
        panelTabbed.setBorder(new TitledBorder("Informa\u00e7\u00f5es dos lotes da c\u00e9lula de estoque " + this.celulaEstoque.getDescricao()));
        panelTabbed.add((Component)this.paneLotes, "Center");
        this.panelLotes.add(panelTabbed);
        this.panelBotoesLote.add(this.buttonCancelarLote);
        this.panelBotoesLote.add(this.buttonAdicionarAbrirLote);
        this.panelBotoesLote.add(this.buttonAdicionarLote);
        Insets insetPadrao = new Insets(1, 0, 0, 1);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, insetPadrao.bottom, insetPadrao.right);
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.labelMaterial.setLabelFor(this.labelDescricaoMaterial);
        panelCentral.add((Component)this.labelMaterial, c);
        this.labelDescricaoMaterial.setMaximumSize(null);
        this.labelDescricaoMaterial.setMinimumSize(new Dimension(20, 20));
        this.labelDescricaoMaterial.setPreferredSize(new Dimension(20, 20));
        ++c.gridx;
        c.gridwidth = 12;
        ScreenUtil.setBorda(new Component[]{this.labelDescricaoMaterial}, new TitledBorder(""));
        c.fill = 2;
        panelCentral.add((Component)this.labelDescricaoMaterial, c);
        c.gridx = 0;
        ++c.gridy;
        this.labelLote.setLabelFor(this.textLote);
        this.labelLote.setDisplayedMnemonic('L');
        panelCentral.add((Component)this.labelLote, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.textLote.setMinimumSize(new Dimension(220, 20));
        this.textLote.setPreferredSize(new Dimension(220, 20));
        this.textLote.setEnabled(!this.isKit);
        c.insets = new Insets(2, insetPadrao.left, insetPadrao.bottom, insetPadrao.right);
        panelCentral.add((Component)this.textLote, c);
        c.gridwidth = 1;
        c.gridx += 3;
        if (this.isKit && this.qtdeInserir > 0.0) {
            this.buttonGerarLoteInterno.setMnemonic('G');
            this.buttonGerarLoteInterno.setMinimumSize(new Dimension(60, 20));
            this.buttonGerarLoteInterno.setMaximumSize(new Dimension(60, 20));
            this.buttonGerarLoteInterno.setMargin(new Insets(1, 1, 1, 1));
            panelCentral.add((Component)this.buttonGerarLoteInterno, c);
        } else {
            JLabel labelAux = new JLabel("");
            labelAux.setMinimumSize(new Dimension(40, 20));
            labelAux.setMaximumSize(new Dimension(40, 20));
            panelCentral.add((Component)labelAux, c);
        }
        c.gridx = 0;
        ++c.gridy;
        c.insets = insetPadrao;
        this.labelQuantidade.setLabelFor(this.textQuantidade);
        this.labelQuantidade.setDisplayedMnemonic('Q');
        c.insets = new Insets(c.insets.top, 2, insetPadrao.bottom, insetPadrao.right);
        panelCentral.add((Component)this.labelQuantidade, c);
        ++c.gridx;
        this.textQuantidade.setMinimumSize(new Dimension(90, 20));
        this.textQuantidade.setPreferredSize(new Dimension(90, 20));
        c.insets = insetPadrao;
        panelCentral.add((Component)this.textQuantidade, c);
        ++c.gridx;
        c.fill = 2;
        this.labelVlrUnidade1.setMinimumSize(new Dimension(40, 20));
        this.labelVlrUnidade1.setPreferredSize(new Dimension(40, 20));
        panelCentral.add((Component)this.labelVlrUnidade1, c);
        ++c.gridx;
        c.gridwidth = 1;
        c.fill = 0;
        c.insets = new Insets(5, 20, insetPadrao.bottom, insetPadrao.right);
        this.labelData.setLabelFor(this.textData);
        this.labelData.setDisplayedMnemonic('D');
        panelCentral.add((Component)this.labelData, c);
        ++c.gridx;
        this.textData.setMinimumSize(new Dimension(90, 20));
        this.textData.setPreferredSize(new Dimension(90, 20));
        c.insets = new Insets(5, insetPadrao.left, insetPadrao.bottom, insetPadrao.right);
        panelCentral.add((Component)this.textData, c);
        ++c.gridx;
        this.buttonData.setMinimumSize(new Dimension(20, 20));
        this.buttonData.setPreferredSize(new Dimension(20, 20));
        Funcoes.imagemPesquisa(this.buttonData);
        this.buttonData.setFocusable(false);
        panelCentral.add((Component)this.buttonData, c);
        ++c.gridx;
        this.labelDias.setLabelFor(this.textDias);
        this.labelDias.setDisplayedMnemonic('s');
        this.labelDias.setMinimumSize(new Dimension(50, 20));
        this.labelDias.setPreferredSize(new Dimension(50, 20));
        this.labelDias.setHorizontalAlignment(4);
        panelCentral.add((Component)this.labelDias, c);
        ++c.gridx;
        this.textDias.setMinimumSize(new Dimension(60, 20));
        this.textDias.setPreferredSize(new Dimension(60, 20));
        c.insets = new Insets(5, insetPadrao.left, insetPadrao.bottom, insetPadrao.right);
        panelCentral.add((Component)this.textDias, c);
        ++c.gridx;
        c.insets = new Insets(5, 20, insetPadrao.bottom, insetPadrao.right);
        this.labelValidade.setLabelFor(this.textValidade);
        this.labelValidade.setDisplayedMnemonic('V');
        panelCentral.add((Component)this.labelValidade, c);
        ++c.gridx;
        c.insets = new Insets(5, insetPadrao.left, insetPadrao.bottom, insetPadrao.right);
        this.textValidade.setMinimumSize(new Dimension(120, 20));
        this.textValidade.setPreferredSize(new Dimension(120, 20));
        panelCentral.add((Component)this.textValidade, c);
        ++c.gridx;
        this.buttonValidade.setMinimumSize(new Dimension(20, 20));
        this.buttonValidade.setPreferredSize(new Dimension(20, 20));
        Funcoes.imagemPesquisa(this.buttonValidade);
        this.buttonValidade.setFocusable(false);
        panelCentral.add((Component)this.buttonValidade, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        c.weightx = 0.0;
        c.fill = 0;
        this.labelObservacao.setLabelFor(this.areaObservacao);
        this.labelObservacao.setDisplayedMnemonic('b');
        c.insets = new Insets(5, 2, insetPadrao.bottom, insetPadrao.right);
        panelCentral.add((Component)this.labelObservacao, c);
        ++c.gridy;
        c.gridwidth = 12;
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = insetPadrao;
        this.scrollObservacao.setMinimumSize(new Dimension(20, 50));
        this.scrollObservacao.setPreferredSize(new Dimension(20, 50));
        panelCentral.add((Component)this.scrollObservacao, c);
        ++c.gridy;
        c.weightx = 1.0;
        c.anchor = 13;
        c.gridwidth = 12;
        c.fill = 2;
        this.buttonCancelarLote.setMnemonic('n');
        this.buttonCancelarLote.setMargin(new Insets(1, 1, 1, 1));
        this.buttonCancelarLote.setMinimumSize(new Dimension(120, 20));
        this.buttonCancelarLote.setPreferredSize(new Dimension(120, 20));
        this.buttonCancelarLote.setVisible(false);
        this.buttonAdicionarLote.setMnemonic('A');
        this.buttonAdicionarLote.setMargin(new Insets(1, 1, 1, 1));
        this.buttonAdicionarLote.setMinimumSize(new Dimension(80, 20));
        this.buttonAdicionarLote.setPreferredSize(new Dimension(80, 20));
        this.buttonAdicionarAbrirLote.setMnemonic('l');
        this.buttonAdicionarAbrirLote.setMargin(new Insets(1, 1, 1, 1));
        this.buttonAdicionarAbrirLote.setMinimumSize(new Dimension(120, 20));
        this.buttonAdicionarAbrirLote.setPreferredSize(new Dimension(120, 20));
        panelCentral.add((Component)this.panelBotoesLote, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 12;
        c.fill = 1;
        c.anchor = 17;
        panelCentral.add((Component)this.panelLotes, c);
        JPanel panelRodape = new JPanel(new BorderLayout());
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 10;
        c.fill = 2;
        c.anchor = 17;
        panelCentral.add((Component)panelRodape, c);
        panelRodape.add((Component)this.panelLegenda, "West");
        panelRodape.add((Component)this.panelTotal, "East");
        this.buttonGerarLoteInterno.addActionListener(this);
        this.buttonAdicionarLote.addActionListener(this);
        this.buttonValidade.addActionListener(this);
        this.buttonData.addActionListener(this);
        this.buttonCancelarLote.addActionListener(this);
        this.buttonAdicionarAbrirLote.addActionListener(this);
        this.tableLotesNovos.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    SolicitarLoteMaterial.this.removerLoteSelecionado(SolicitarLoteMaterial.this.tableLotesNovos);
                    SolicitarLoteMaterial.this.atualizarTotais();
                } else if (e.getKeyCode() == 32) {
                    SolicitarLoteMaterial.this.modificarLoteSelecionado(SolicitarLoteMaterial.this.tableLotesNovos);
                    SolicitarLoteMaterial.this.atualizarTotais();
                }
            }
        });
        this.tableLotesAntigos.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (SolicitarLoteMaterial.this.qtdeRemover > 0.0) {
                    if (e.getKeyCode() == 127) {
                        SolicitarLoteMaterial.this.removerLoteSelecionado(SolicitarLoteMaterial.this.tableLotesAntigos);
                        SolicitarLoteMaterial.this.atualizarTotais();
                    } else if (e.getKeyCode() == 32) {
                        SolicitarLoteMaterial.this.modificarLoteSelecionado(SolicitarLoteMaterial.this.tableLotesAntigos);
                        SolicitarLoteMaterial.this.atualizarTotais();
                    }
                }
            }
        });
        this.textValidade.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    Funcoes.mostraData(SolicitarLoteMaterial.this.textValidade, SolicitarLoteMaterial.this.buttonValidade, SolicitarLoteMaterial.this.getPanelCentral(), true);
                }
            }
        });
        this.textData.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    Funcoes.mostraData(SolicitarLoteMaterial.this.textData, SolicitarLoteMaterial.this.buttonData, SolicitarLoteMaterial.this.getPanelCentral(), true);
                }
            }
        });
        this.textDias.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!Funcoes.textoVazio(SolicitarLoteMaterial.this.textDias)) {
                    SolicitarLoteMaterial.this.calcularDataValidade();
                }
            }
        });
        Funcoes.montaEnter((JComponent)panelCentral);
        Funcoes.defineUpperCase(panelCentral, ParametrosGerais.getUpperCase());
        ScreenUtil.centralizar(this);
        this.setDefaultCloseOperation(0);
        this.carregarDadosLotes();
        this.modeloLotesNovos.setSentidoOrdenacao(-1);
        this.modeloLotesNovos.ordenarColunaSemTrocarSentido(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                ScreenUtil.requisitarFoco(SolicitarLoteMaterial.this.textLote);
            }
        });
        this.controlarCampos(false);
    }

    private void montaTelaVisualizacao(String descricaoMaterial) {
        this.setModal(true);
        this.textLote.addHierarchyListener(this);
        this.setTitle("Visualizado \"" + Funcoes.formataDecimal(this.qtdeRemover) + " " + this.codigoUnidade + "\" dos lotes do material" + (Funcoes.textoVazio(descricaoMaterial) ? "" : " \"" + descricaoMaterial + "\""));
        this.modeloLotesAntigos = new ModeloGridTable(this.colunasGrid);
        this.tableLotesAntigos = new JTable(this.modeloLotesAntigos){

            @Override
            public Class<?> getColumnClass(int column) {
                return String.class;
            }
        };
        this.modeloLotesNovos = new ModeloGridTable(this.colunasGrid);
        this.tableLotesNovos = new JTable(this.modeloLotesNovos){

            @Override
            public Class<?> getColumnClass(int column) {
                return String.class;
            }
        };
        this.tableLotesNovos.setDefaultRenderer(String.class, new RendererLotes());
        this.tableLotesNovos.getTableHeader().addMouseListener(this.modeloLotesNovos);
        this.modeloLotesNovos.setColumnSize(this.colunasTamanho, this.tableLotesNovos);
        this.scrollLotesNovos = new JScrollPane();
        this.scrollLotesNovos.setViewportView(this.tableLotesNovos);
        this.tableLotesAntigos.setDefaultRenderer(String.class, new RendererLotes());
        this.tableLotesAntigos.getTableHeader().addMouseListener(this.modeloLotesAntigos);
        this.modeloLotesAntigos.setColumnSize(this.colunasTamanho, this.tableLotesAntigos);
        this.scrollLotesAntigos = new JScrollPane();
        this.scrollLotesAntigos.setViewportView(this.tableLotesAntigos);
        JPanel panelCentral = this.getPanelCentral();
        ScreenUtil.setBorda(new Component[]{this.labelVlrUnidade1}, new TitledBorder(""));
        this.setResizable(false);
        this.setSize(750, 425);
        this.scrollLotesAntigos.setPreferredSize(new Dimension(740, 300));
        this.panelLotes.setBorder(new TitledBorder(""));
        this.panelLotes.add(this.scrollLotesAntigos);
        this.montaPanelTotal(this.panelTotal);
        this.montaPanelLegenda(this.panelLegenda);
        JPanel panelRodape = new JPanel(new BorderLayout());
        panelRodape.setPreferredSize(new Dimension(740, 25));
        panelRodape.add((Component)this.panelLegenda, "West");
        panelCentral.setLayout(new BorderLayout());
        panelCentral.add((Component)this.panelLotes, "Center");
        panelCentral.add((Component)panelRodape, "South");
        this.getBotaoOK().setVisible(false);
        this.getBotaoCancelar().setText("OK");
        this.getBotaoCancelar().setMnemonic('O');
        ScreenUtil.centralizar(this);
        this.setDefaultCloseOperation(0);
        this.carregarDadosLotes();
        this.modeloLotesNovos.setSentidoOrdenacao(-1);
        this.modeloLotesNovos.ordenarColunaSemTrocarSentido(2);
    }

    private void atualizarTotais() {
        Double qtde = 0.0;
        Double qtdeRestante = 0.0;
        Double qtdeConsumida = 0.0;
        Double qtdeSaida = 0.0;
        ArrayList<MaterialLoteBean> lista = this.getLotes();
        if (lista != null) {
            for (int i = 0; i < lista.size(); ++i) {
                MaterialLoteBean aux = lista.get(i);
                if (aux.getRemovido().booleanValue()) continue;
                qtde = qtde + aux.getQuantidade();
                qtdeRestante = qtdeRestante + (aux.getQuantidade() - aux.getQuantidadeConsumida());
                qtdeConsumida = qtdeConsumida + aux.getQuantidadeConsumidaOriginal();
            }
        }
        this.labelVlrQtdeSaida.setText(Funcoes.formataDecimal(this.qtdeRemover));
        this.labelVlrQtdeTotal.setText(Funcoes.formataDecimal(qtde != null ? qtde : 0.0));
        this.labelVlrQtdeRestanteTotal.setText(Funcoes.formataDecimal(qtdeRestante != null ? qtdeRestante : 0.0));
    }

    private void montaPanelTotal(JPanel panelTotal) {
        JPanel panelEsquerda = new JPanel(new FlowLayout(0));
        if (this.qtdeInserir > 0.0 && this.tipoOperacao == 0) {
            panelEsquerda.add(new JLabel("Entrada atual:"));
            panelEsquerda.add(new JLabel(Funcoes.formataDecimal(this.qtdeInserir)));
            panelEsquerda.add(new JLabel("(" + this.codigoUnidade + ")"));
        } else if (this.qtdeRemover > 0.0 && this.tipoOperacao == 1) {
            panelEsquerda.add(new JLabel("Sa\u00edda atual:"));
            panelEsquerda.add(new JLabel(Funcoes.formataDecimal(this.qtdeRemover)));
            panelEsquerda.add(new JLabel("(" + this.codigoUnidade + ")"));
        } else {
            panelEsquerda.add(new JLabel("Total atual:"));
            panelEsquerda.add(new JLabel(Funcoes.formataDecimal(this.qtdeRemover)));
            panelEsquerda.add(new JLabel("(" + this.codigoUnidade + ")"));
        }
        JPanel panelDireita = new JPanel(new FlowLayout(2));
        panelDireita.add(new JLabel("Total:"));
        panelDireita.add(this.labelVlrQtdeTotal);
        panelDireita.add(new JLabel("(" + this.codigoUnidade + ")"));
        panelDireita.add(new JLabel("  "));
        panelDireita.add(new JLabel("Restante:"));
        panelDireita.add(this.labelVlrQtdeRestanteTotal);
        panelDireita.add(new JLabel("(" + this.codigoUnidade + ")"));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        panelTotal.add((Component)panelEsquerda, c);
        ++c.gridx;
    }

    private void montaPanelLegenda(JPanel pnlLegenda) {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        JPanel pnlCorLegenda = new JPanel();
        pnlCorLegenda.setPreferredSize(new Dimension(10, 10));
        pnlCorLegenda.setBackground(COR_LOTE_CONSUMIDO);
        pnlCorLegenda.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        pnlLegenda.add((Component)pnlCorLegenda, c);
        JLabel lblLegenda = new JLabel("Lote consumido");
        Font font = new Font(lblLegenda.getFont().getName(), 0, 10);
        lblLegenda.setFont(font);
        ++c.gridx;
        pnlLegenda.add((Component)lblLegenda, c);
        ++c.gridx;
        pnlLegenda.add((Component)new JLabel("  "), c);
        pnlCorLegenda = new JPanel();
        pnlCorLegenda.setPreferredSize(new Dimension(10, 10));
        pnlCorLegenda.setBackground(COR_LOTE_EM_CONSUMO);
        pnlCorLegenda.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        ++c.gridx;
        pnlLegenda.add((Component)pnlCorLegenda, c);
        lblLegenda = new JLabel("Lote em consumo");
        font = new Font(lblLegenda.getFont().getName(), 0, 10);
        lblLegenda.setFont(font);
        ++c.gridx;
        pnlLegenda.add((Component)lblLegenda, c);
        ++c.gridx;
        pnlLegenda.add((Component)new JLabel("  "), c);
        pnlCorLegenda = new JPanel();
        pnlCorLegenda.setPreferredSize(new Dimension(10, 10));
        pnlCorLegenda.setBackground(COR_LOTE_VENCIDO);
        pnlCorLegenda.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        ++c.gridx;
        pnlLegenda.add((Component)pnlCorLegenda, c);
        lblLegenda = new JLabel("Lote vencido");
        font = new Font(lblLegenda.getFont().getName(), 0, 10);
        lblLegenda.setFont(font);
        ++c.gridx;
        pnlLegenda.add((Component)lblLegenda, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        pnlLegenda.add((Component)new JLabel(""), c);
    }

    private void carregarDadosLotes() {
        if (this.lotes != null) {
            for (MaterialLoteBean aux : this.lotes) {
                CelulaEstoqueVO celulaAux;
                LancamentoEstoqueVO lanctoEntrada;
                if (aux.getRemovido().booleanValue()) {
                    this.lotesRemovidos.add(aux);
                    continue;
                }
                if (this.celulaEstoque != null && this.qtdeRemover > 0.0 && (lanctoEntrada = aux.getLancamentoEstoqueEntrada()) != null && ((celulaAux = lanctoEntrada.getCelula()) != null && Funcoes.textoVazio(celulaAux.getDescricao()) || celulaAux != null && celulaAux.getCodigo().intValue() != this.celulaEstoque.getCodigo().intValue())) {
                    this.lotesRemovidos.add(aux);
                    continue;
                }
                LancamentoEstoqueVO lancamentoEntrada = aux.getLancamentoEstoqueEntrada();
                CelulaEstoqueVO celulaEstoque = null;
                if (lancamentoEntrada != null) {
                    celulaEstoque = lancamentoEntrada.getCelula();
                }
                if ((aux.getAlterar() || aux.getInserir()) && this.qtdeRemover == 0.0) {
                    LancamentoEstoqueVO lanctoEntrada2 = aux.getLancamentoEstoqueEntrada();
                    if (lanctoEntrada2 != null) {
                        CelulaEstoqueVO celulaAux2 = lanctoEntrada2.getCelula();
                        if (!Funcoes.textoVazio(celulaAux2.getDescricao()) && (celulaAux2 == null || celulaEstoque == null || celulaAux2.getCodigo().intValue() == celulaEstoque.getCodigo().intValue())) continue;
                        this.lotesRemovidos.add(aux);
                        continue;
                    }
                    this.addLinhaGrid(this.modeloLotesNovos, aux, celulaEstoque);
                    continue;
                }
                this.addLinhaGrid(this.modeloLotesAntigos, aux, celulaEstoque);
            }
            this.atualizarTotais();
        }
    }

    private void addLinhaGrid(ModeloGridTable modelo, MaterialLoteBean aux, CelulaEstoqueVO celulaEstoque) {
        modelo.addLine(new Object[]{aux.getLote(), Funcoes.formataData(aux.getDataLote()), Funcoes.formataData(aux.getValidadeLote()), celulaEstoque, Funcoes.formataDecimal(aux.getQuantidade()), Funcoes.formataDecimal(aux.getQuantidadeConsumida()), aux.getObservacao(), aux.getDataHoraAberto() != null, aux});
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.buttonAdicionarLote && this.verificaAdicionarLote()) {
            if (this.qtdeRemover == 0.0) {
                this.adicionarLote(this.loteSelecionadoNovos, this.tableLotesNovos, false);
            } else {
                this.adicionarLote(this.loteSelecionadoAntigos, this.tableLotesAntigos, false);
            }
            this.atualizarTotais();
        }
        if (e.getSource() == this.buttonAdicionarAbrirLote && this.verificaAdicionarLote()) {
            if (this.qtdeRemover == 0.0) {
                this.adicionarLote(this.loteSelecionadoNovos, this.tableLotesNovos, true);
            } else {
                this.adicionarLote(this.loteSelecionadoAntigos, this.tableLotesAntigos, true);
            }
            this.atualizarTotais();
        }
        if (e.getSource() == this.buttonCancelarLote) {
            this.limparCamposLote();
            this.isEditando = false;
            this.linhaEdicaoNovos = -1;
            this.linhaEdicaoAntigos = -1;
            this.loteSelecionadoNovos = null;
            this.loteSelecionadoAntigos = null;
            this.controlarCampos(true);
            ScreenUtil.requisitarFoco(this.textLote);
        }
        if (e.getSource() == this.buttonCancelar) {
            this.limparCamposLote();
            this.isEditando = false;
            this.linhaEdicaoNovos = -1;
            this.linhaEdicaoAntigos = -1;
            this.loteSelecionadoNovos = null;
            this.loteSelecionadoAntigos = null;
            this.controlarCampos(true);
            this.setUsuarioPodeCancelar(true);
            ScreenUtil.requisitarFoco(this.textLote);
            super.actionPerformed(e);
        }
        if (e.getSource() == this.buttonGerarLoteInterno) {
            this.textLote.setText(MaterialLoteService.criarNumeracaoLoteInterno());
            ScreenUtil.requisitarFoco(this.textData);
        }
        if (e.getSource() == this.buttonValidade) {
            Funcoes.mostraData(this.textValidade, this.buttonValidade, this.getPanelCentral(), true);
        }
        if (e.getSource() == this.buttonData) {
            Funcoes.mostraData(this.textData, this.buttonData, this.getPanelCentral(), true);
        }
    }

    private void calcularDataValidade() {
        if (!Funcoes.textoVazio(this.textData.getText())) {
            Date data = Funcoes.getData("dd/MM/yyyy", this.textData.getText());
            Calendar c = Calendar.getInstance();
            c.setTime(data);
            c.add(5, Integer.valueOf(this.textDias.getText()));
            Date validade = c.getTime();
            this.textValidade.setText(Funcoes.formataData("dd/MM/yyyy", validade));
            this.textDias.clear();
        }
    }

    private void adicionarLote(MaterialLoteBean matLote, JTable tabela, boolean adicionarAbrir) {
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        MaterialVO material = new MaterialVO();
        material.setFilial(filial);
        material.setCodigo(this.codigoMaterial);
        UsuarioVO usuario = new UsuarioVO();
        usuario.setFilial(filial);
        usuario.setCodigo(Variaveis.login);
        double qtde = Double.parseDouble(Funcoes.limpaDecimal(this.textQuantidade.getText()));
        Date validade = Funcoes.getData("dd/MM/yyyy", this.textValidade.getText());
        Date data = Funcoes.getData("dd/MM/yyyy", this.textData.getText());
        if (matLote == null) {
            matLote = new MaterialLoteBean();
        }
        matLote.setFilial(filial);
        matLote.setCodigo(matLote.getCodigo());
        matLote.setDataHoraCriacao(matLote.getDataHoraCriacao());
        matLote.setUsuarioCriacao(matLote.getUsuarioCriacao());
        if (ParametrosGerais.isExigirAberturaLote() && adicionarAbrir) {
            Date d = Funcoes.getDataHoraServidor();
            matLote.setUsuarioAberturaInicial(usuario);
            matLote.setDataHoraAberturaInicial(d);
            matLote.setUsuarioAberto(usuario);
            matLote.setDataHoraAberto(d);
        }
        if (matLote.getCodigo() == null) {
            matLote.setInserir(true);
        } else {
            matLote.setAlterar(true);
        }
        matLote.setDataLote(data);
        matLote.setLote(this.textLote.getText());
        matLote.setMaterial(material);
        if (this.qtdeInserir > 0.0 && this.tipoOperacao == 0 && !this.celulaEstoque.getBaixarAutomatico().booleanValue()) {
            matLote.setQuantidade(qtde);
            matLote.setQuantidadeConsumida(0.0);
        } else if (this.tipoOperacao == 1) {
            matLote.setQuantidadeConsumida(matLote.getQuantidadeConsumidaOriginal() + qtde);
        } else {
            matLote.setQuantidade(qtde);
            matLote.setQuantidadeConsumida(0.0);
            if (this.celulaEstoque.getBaixarAutomatico().booleanValue()) {
                matLote.setQuantidadeConsumida(qtde);
            }
        }
        matLote.setValidadeLote(validade);
        String obs = StringUtil.textoDB(this.areaObservacao.getText());
        matLote.setObservacao(obs.substring(0, obs.length() < 300 ? obs.length() : 300));
        matLote.setRemovido(false);
        matLote.setLoteEntrada(this.loteEntrada);
        matLote.setDataHoraServidor(Funcoes.getDataHoraServidor());
        if (this.isEditando) {
            int linhaEdicao = this.linhaEdicaoNovos > -1 ? this.linhaEdicaoNovos : this.linhaEdicaoAntigos;
            tabela.getModel().setValueAt(matLote.getLote(), linhaEdicao, 0);
            tabela.getModel().setValueAt(Funcoes.formataData(matLote.getDataLote()), linhaEdicao, 1);
            tabela.getModel().setValueAt(Funcoes.formataData("dd/MM/yyyy", matLote.getValidadeLote()), linhaEdicao, 2);
            tabela.getModel().setValueAt(this.celulaEstoque, linhaEdicao, 3);
            tabela.getModel().setValueAt(Funcoes.formataDecimal(matLote.getQuantidade()), linhaEdicao, 4);
            tabela.getModel().setValueAt(Funcoes.formataDecimal(matLote.getQuantidadeConsumida()), linhaEdicao, 5);
            tabela.getModel().setValueAt(matLote.getObservacao(), linhaEdicao, 6);
            tabela.getModel().setValueAt(matLote, linhaEdicao, 8);
        } else {
            this.addLinhaGrid((ModeloGridTable)tabela.getModel(), matLote, this.celulaEstoque);
        }
        ((ModeloGridTable)tabela.getModel()).ordenarColunaSemTrocarSentido(((ModeloGridTable)tabela.getModel()).getColunaOrdenacao());
        this.limparCamposLote();
        this.isEditando = false;
        this.linhaEdicaoNovos = -1;
        this.linhaEdicaoAntigos = -1;
        this.loteSelecionadoNovos = null;
        this.loteSelecionadoAntigos = null;
        this.controlarCampos(true);
        this.textQuantidade.setText(Funcoes.formataDecimal(this.qtdeInserir - this.getTotalInseridoLotesNovos()));
        ScreenUtil.requisitarFoco(this.textLote);
    }

    private Double getQuantidadeRemovidaAtual() {
        Double qtde = 0.0;
        for (int i = 0; i < this.modeloLotesAntigos.getRowCount(); ++i) {
            MaterialLoteBean bean = (MaterialLoteBean)this.modeloLotesAntigos.getValueAt(i, 8);
            qtde = qtde + (bean.getQuantidadeConsumida() - bean.getQuantidadeConsumidaOriginal());
        }
        return qtde;
    }

    private void limparCamposLote() {
        this.textLote.clear();
        this.textValidade.clear();
        this.textQuantidade.clear();
        this.textData.clear();
        this.areaObservacao.setText("");
    }

    private boolean verificaAdicionarLote() {
        Date dataValidade;
        if (Funcoes.textoVazio(this.textLote)) {
            Funcoes.mensagem(this, "O lote deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textLote);
            return false;
        }
        if (Funcoes.textoVazio(this.textData) || !Funcoes.verificaData(this.textData.getText())) {
            Funcoes.mensagem(this, "A Data do lote deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textData);
            return false;
        }
        if (Funcoes.textoVazio(this.textValidade) || !Funcoes.verificaData(this.textValidade.getText())) {
            Funcoes.mensagem(this, "A validade do lote deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textValidade);
            return false;
        }
        if (Funcoes.textoVazio(this.textQuantidade)) {
            Funcoes.mensagem(this, "A quantidade do lote deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textQuantidade);
            return false;
        }
        double qtde = Double.parseDouble(Funcoes.limpaDecimal(this.textQuantidade.getText()));
        if (qtde == 0.0 && this.qtdeInserir > 0.0 && this.tipoOperacao == 0) {
            Funcoes.mensagem(this, "A quantidade do lote deve ser maior que zero.", 2);
            this.textQuantidade.selectAll();
            ScreenUtil.requisitarFoco(this.textQuantidade);
            return false;
        }
        if (this.qtdeRemover > 0.0 && this.tipoOperacao == 1 && this.loteSelecionadoAntigos.getQuantidadeConsumidaOriginal() + qtde > this.loteSelecionadoAntigos.getQuantidade()) {
            Funcoes.mensagem(this, "A quantidade consumida do lote ultrapassa a quantidade original.", 2);
            this.textQuantidade.selectAll();
            ScreenUtil.requisitarFoco(this.textQuantidade);
            return false;
        }
        Date dataLote = Funcoes.getData("dd/MM/yyyy", this.textData.getText());
        if (dataLote.compareTo(dataValidade = Funcoes.getData("dd/MM/yyyy", this.textValidade.getText())) > 0) {
            Funcoes.mensagem(this, "A data de cria\u00e7\u00e3o do lote \u00e9 posterior \u00e1 data de validade.", 2);
            ScreenUtil.requisitarFoco(this.textData);
            return false;
        }
        if (dataValidade.compareTo(Funcoes.getDataServidor()) < 0) {
            Funcoes.mensagem(this, "A validade do lote expirou.", 2);
        }
        return true;
    }

    public ArrayList<MaterialLoteBean> getLotes() {
        int i;
        ArrayList<MaterialLoteBean> lotes = new ArrayList<MaterialLoteBean>();
        for (i = 0; i < this.modeloLotesNovos.getRowCount(); ++i) {
            MaterialLoteBean lote = (MaterialLoteBean)this.modeloLotesNovos.getValueAt(i, 8);
            if (lote.getDataHoraCriacao() == null) {
                FilialVO filial = new FilialVO();
                filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
                UsuarioVO usuario = new UsuarioVO();
                usuario.setFilial(filial);
                usuario.setCodigo(Variaveis.login);
                lote.setDataHoraCriacao(new Date());
                lote.setUsuarioCriacao(usuario);
            }
            lotes.add((MaterialLoteBean)this.modeloLotesNovos.getValueAt(i, 8));
        }
        for (i = 0; i < this.modeloLotesAntigos.getRowCount(); ++i) {
            lotes.add((MaterialLoteBean)this.modeloLotesAntigos.getValueAt(i, 8));
        }
        for (i = 0; i < this.lotesRemovidos.size(); ++i) {
            lotes.add(this.lotesRemovidos.get(i));
        }
        if (lotes.size() > 0) {
            return lotes;
        }
        return null;
    }

    public Double getTotalInseridoLotesNovos() {
        Double totalAdicionado = 0.0;
        for (int i = 0; i < this.modeloLotesNovos.getRowCount(); ++i) {
            MaterialLoteBean lote = (MaterialLoteBean)this.modeloLotesNovos.getValueAt(i, 8);
            if (lote.getRemovido().booleanValue()) continue;
            totalAdicionado = totalAdicionado + lote.getQuantidade();
        }
        return totalAdicionado;
    }

    public ArrayList<MaterialLoteBean> getLotesAlterados() {
        ArrayList<MaterialLoteBean> lotes = this.getLotes();
        ArrayList<MaterialLoteBean> lotesAlterados = new ArrayList<MaterialLoteBean>();
        for (MaterialLoteBean materialLoteBean : lotes) {
            if (!materialLoteBean.getAlterar()) continue;
            lotesAlterados.add(materialLoteBean);
        }
        return lotesAlterados;
    }

    private void removerLoteSelecionado(JTable tabela) {
        int row = tabela.getSelectedRow();
        if (row > -1) {
            MaterialLoteBean aux = (MaterialLoteBean)tabela.getModel().getValueAt(row, 8);
            if (this.tipoOperacao == 1) {
                Funcoes.mensagem(this, "N\u00e3o \u00e9 poss\u00edvel remover lotes.", 2);
                return;
            }
            if (this.tipoOperacao == 0 && !aux.getInserir() && !aux.getAlterar()) {
                Funcoes.mensagem(this, "Somente os novos lotes podem ser removidos.", 2);
                return;
            }
            int resp = Funcoes.mensagem(this, "Deseja remover o lote?", 4, false);
            if (resp == 0) {
                if (aux.getCodigo() != null) {
                    FilialVO filial = new FilialVO();
                    filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
                    UsuarioVO usuario = new UsuarioVO();
                    usuario.setFilial(filial);
                    usuario.setCodigo(Variaveis.login);
                    aux.setUsuarioRemocao(usuario);
                    aux.setDataHoraRemovido(new Date());
                    aux.setRemovido(true);
                    this.lotesRemovidos.add(aux);
                }
                ((ModeloGridTable)tabela.getModel()).removeLine(row);
            }
        }
    }

    private void modificarLoteSelecionado(JTable tabela) {
        int row = tabela.getSelectedRow();
        if (row > -1) {
            MaterialLoteBean aux = (MaterialLoteBean)tabela.getModel().getValueAt(row, 8);
            if (this.tipoOperacao == 0 && !aux.getInserir() && !aux.getAlterar()) {
                Funcoes.mensagem(this, "Somente os novos lotes podem ser alterados.", 2);
                return;
            }
            if (this.tipoOperacao == 1 && aux.getQuantidadeConsumida().equals(aux.getQuantidade())) {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 saldo restante para o lote.", 2);
                return;
            }
            if (ParametrosGerais.isExigirAberturaLote() && this.tipoOperacao == 1 && (aux.getUsuarioAberto() == null || aux.getDataHoraAberto() == null || aux.getDataHoraFechado() != null)) {
                Funcoes.mensagem(this, "O lote " + aux.getLote() + " n\u00e3o est\u00e1 aberto.\nN\u00e3o \u00e9 poss\u00edvel moviment\u00e1-lo.", 2);
                return;
            }
            if (tabela == this.tableLotesNovos) {
                this.loteSelecionadoNovos = aux;
                this.linhaEdicaoNovos = row;
                this.loteSelecionadoAntigos = null;
                this.linhaEdicaoAntigos = -1;
            } else {
                this.loteSelecionadoAntigos = aux;
                this.linhaEdicaoAntigos = row;
                this.loteSelecionadoNovos = null;
                this.linhaEdicaoNovos = -1;
            }
            this.textLote.setText(aux.getLote());
            this.textData.setText(Funcoes.formataData("dd/MM/yyyy", aux.getDataLote()));
            this.textValidade.setText(Funcoes.formataData("dd/MM/yyyy", aux.getValidadeLote()));
            Double qtdeRemoverMaxima = aux.getQuantidade() - aux.getQuantidadeConsumidaOriginal();
            Double qtdeRemoverAux = this.qtdeRemover - this.getQuantidadeRemovidaAtual();
            if (row > -1 && this.qtdeRemover == 0.0) {
                this.textQuantidade.setText(Funcoes.formataDecimal(aux.getQuantidade()));
            } else {
                this.textQuantidade.setText(Funcoes.formataDecimal(qtdeRemoverAux < qtdeRemoverMaxima ? qtdeRemoverAux : qtdeRemoverMaxima));
            }
            this.areaObservacao.setText(aux.getObservacao());
            this.isEditando = aux.getValidadeLote().compareTo(Funcoes.getDataServidor()) >= 0 ? true : this.isInutilizar;
            this.controlarCampos(aux.getCodigo() == null);
            ScreenUtil.requisitarFoco(this.textLote);
        }
    }

    private void controlarCampos(boolean podeEditarNumeroLote) {
        boolean isInserindo = this.tipoOperacao == 0;
        boolean isRemovendo = this.tipoOperacao == 1;
        this.textLote.setEnabled(!this.isKit && (podeEditarNumeroLote && this.isEditando || isInserindo));
        this.textData.setEnabled(isInserindo);
        this.textDias.setEnabled(isInserindo);
        this.buttonData.setEnabled(isInserindo);
        this.textValidade.setEnabled(isInserindo);
        this.buttonValidade.setEnabled(isInserindo);
        this.textQuantidade.setEnabled(isInserindo || isRemovendo && this.isEditando);
        this.areaObservacao.setEditable(isInserindo || isRemovendo && this.isEditando);
        this.buttonAdicionarLote.setText(this.isEditando || this.qtdeRemover > 0.0 ? "Alterar" : "Adicionar");
        this.buttonAdicionarLote.setEnabled(isInserindo || isRemovendo && this.isEditando);
        this.buttonGerarLoteInterno.setEnabled(!this.isEditando);
        this.buttonCancelarLote.setVisible(this.isEditando);
        this.tableLotesNovos.setEnabled(!this.isEditando);
        this.buttonAdicionarAbrirLote.setVisible(ParametrosGerais.isExigirAberturaLote() && isInserindo);
        this.buttonAdicionarAbrirLote.setEnabled(!this.isEditando);
    }

    @Override
    protected boolean acaoOk() {
        if (this.qtdeInserir > 0.0) {
            Double qtde = 0.0;
            ArrayList<MaterialLoteBean> lista = this.getLotes();
            if (lista != null) {
                for (int i = 0; i < lista.size(); ++i) {
                    MaterialLoteBean aux = lista.get(i);
                    if (aux.getRemovido().booleanValue() || aux.getCodigo() != null && (aux.getCodigo() == null || !aux.getInserir() && !aux.getAlterar())) continue;
                    qtde = qtde + aux.getQuantidade();
                    qtde = qtde - aux.getQuantidadeConsumida();
                }
            }
            if (qtde != this.qtdeInserir && !this.celulaEstoque.getBaixarAutomatico().booleanValue()) {
                Funcoes.mensagem(this, "<html><body>A  quantidade a ser inserida do material \u00e9: <font color=red>" + Funcoes.formataDecimal(this.qtdeInserir) + " (" + this.codigoUnidade + ")</font>.<br>A quantidade inserida foi: <font color=red>" + Funcoes.formataDecimal(qtde) + "</font> (" + this.codigoUnidade + ").</body></html>", 2);
                return false;
            }
        } else if (this.qtdeRemover > 0.0) {
            double qtdeConsumida = 0.0;
            double qtdeConsumidaOriginal = 0.0;
            ArrayList<MaterialLoteBean> lista = this.getLotes();
            if (lista != null) {
                for (int i = 0; i < lista.size(); ++i) {
                    MaterialLoteBean aux = lista.get(i);
                    if (aux.getRemovido().booleanValue()) continue;
                    qtdeConsumida += aux.getQuantidadeConsumida() == null ? 0.0 : aux.getQuantidadeConsumida();
                    qtdeConsumidaOriginal += aux.getQuantidadeConsumidaOriginal() == null ? 0.0 : aux.getQuantidadeConsumidaOriginal();
                }
            }
            BigDecimal qtdeDiferenca = new BigDecimal(qtdeConsumida).setScale(2, RoundingMode.HALF_UP).subtract(new BigDecimal(qtdeConsumidaOriginal).setScale(2, RoundingMode.HALF_UP));
            if ((qtdeDiferenca = qtdeDiferenca.setScale(2, RoundingMode.HALF_UP)).doubleValue() != this.qtdeRemover) {
                Funcoes.mensagem(this, "<html><body>A  quantidade a ser removida do material \u00e9: <font color=red>" + Funcoes.formataDecimal(this.qtdeRemover) + " (" + this.codigoUnidade + ")</font>.<br>A quantidade removida foi: <font color=red>" + Funcoes.formataDecimal(qtdeDiferenca.doubleValue()) + " (" + this.codigoUnidade + ")</font>.</body></html>", 2);
                return false;
            }
        }
        this.saldoSaidaAtual = 0.0;
        return super.acaoOk();
    }

    @Override
    public void hierarchyChanged(HierarchyEvent event) {
        if (this.textLote.isShowing() && (event.getChangeFlags() & 4L) != 0L) {
            this.addWindowFocusListener(new WindowAdapter(){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                    if (SolicitarLoteMaterial.this.tipoOperacao == 0) {
                        SolicitarLoteMaterial.this.textLote.requestFocus();
                    } else if (SolicitarLoteMaterial.this.tipoOperacao == 1) {
                        if (SolicitarLoteMaterial.this.tableLotesNovos.getSelectedRow() == -1 && SolicitarLoteMaterial.this.tableLotesNovos.getRowCount() > 0) {
                            SolicitarLoteMaterial.this.tableLotesNovos.getSelectionModel().setSelectionInterval(0, 0);
                        }
                        SolicitarLoteMaterial.this.tableLotesNovos.requestFocus();
                    }
                    SolicitarLoteMaterial.this.removeWindowFocusListener(this);
                }
            });
            this.textLote.removeHierarchyListener(this);
        }
    }

    class RendererNovo
    extends DefaultTableCellRenderer {
        RendererNovo() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            MaterialLoteBean obj = (MaterialLoteBean)table.getModel().getValueAt(row, 8);
            this.setText(value != null ? value.toString() : "");
            if (obj != null) {
                if (obj.getQuantidade().doubleValue() == obj.getQuantidadeConsumida().doubleValue()) {
                    this.setForeground(Color.RED);
                } else if (obj.getQuantidadeConsumida() > 0.0) {
                    this.setForeground(Color.BLUE);
                } else {
                    this.setForeground(table.getForeground());
                }
            }
            this.setHorizontalAlignment(0);
            return this;
        }
    }

    class RendererLotesBoolean
    extends JCheckBox
    implements TableCellRenderer {
        RendererLotesBoolean() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Object valor;
            MaterialLoteBean obj = (MaterialLoteBean)table.getModel().getValueAt(row, 8);
            this.setSelected((Boolean)value);
            if (obj != null) {
                if (obj.getValidadeLote() != null && obj.getDataHoraServidor() != null && obj.getValidadeLote().compareTo(obj.getDataHoraServidor()) < 0) {
                    if (!isSelected) {
                        this.setBackground(COR_LOTE_VENCIDO);
                    } else {
                        this.setBackground(ScreenUtil.escurecerCor(COR_LOTE_VENCIDO, 30));
                    }
                } else if (!isSelected) {
                    this.setBackground(table.getBackground());
                } else {
                    this.setBackground(table.getSelectionBackground());
                }
                if (obj.getQuantidade().doubleValue() == obj.getQuantidadeConsumida().doubleValue()) {
                    this.setForeground(COR_LOTE_CONSUMIDO);
                } else if (obj.getQuantidadeConsumida() > 0.0) {
                    this.setForeground(COR_LOTE_EM_CONSUMO);
                } else {
                    this.setForeground(table.getForeground());
                }
            }
            if ((valor = table.getValueAt(row, column)) == null || Funcoes.textoVazio(valor.toString())) {
                table.setToolTipText(null);
            } else {
                table.setToolTipText(valor.toString());
            }
            this.setHorizontalAlignment(0);
            return this;
        }
    }

    class RendererLotes
    extends DefaultTableCellRenderer {
        RendererLotes() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            MaterialLoteBean obj = (MaterialLoteBean)table.getModel().getValueAt(row, 8);
            this.setText(value != null ? value.toString() : "");
            if (obj != null) {
                if (obj.getValidadeLote() != null && obj.getDataHoraServidor() != null && obj.getValidadeLote().compareTo(obj.getDataHoraServidor()) < 0) {
                    if (!isSelected) {
                        this.setBackground(COR_LOTE_VENCIDO);
                    } else {
                        this.setBackground(ScreenUtil.escurecerCor(COR_LOTE_VENCIDO, 30));
                    }
                } else if (!isSelected) {
                    this.setBackground(table.getBackground());
                } else {
                    this.setBackground(table.getSelectionBackground());
                }
                if (obj.getQuantidade().doubleValue() == obj.getQuantidadeConsumida().doubleValue()) {
                    this.setForeground(COR_LOTE_CONSUMIDO);
                } else if (obj.getQuantidadeConsumida() > 0.0) {
                    this.setForeground(COR_LOTE_EM_CONSUMO);
                } else {
                    this.setForeground(table.getForeground());
                }
            } else {
                this.setBackground(Color.CYAN);
            }
            Object valor = table.getValueAt(row, column);
            if (valor == null || Funcoes.textoVazio(valor.toString())) {
                table.setToolTipText(null);
            } else {
                table.setToolTipText(valor.toString());
            }
            return this;
        }
    }
}

