/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.estoque;

import jalis.comum.Conexao;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.estoque.almoxarifado.DialogoComentarioEmLote;
import jalis.model.bean.estoque.ConferenciaEntradaLanctoEstoqueBean;
import jalis.model.bean.estoque.ConferenciaEstoqueLanctoEstoqueBean;
import jalis.model.bean.estoque.EstoqueManualLanctoEstoqueBean;
import jalis.model.bean.estoque.MaterialLoteLanctoEstoqueBean;
import jalis.model.bean.estoque.MontagemKitLanctoEstoqueBean;
import jalis.model.bean.estoque.NotaFiscalLanctoEstoqueBean;
import jalis.model.bean.estoque.PedidoLanctoEstoqueBean;
import jalis.model.bean.estoque.TransfEstoqueLanctoEstoqueBean;
import jalis.model.vo.estoque.CelulaEstoqueVO;
import jalis.model.vo.estoque.LancamentoEstoqueVO;
import jalis.service.estoque.ConferenciaEntradaLanctoEstoqueService;
import jalis.service.estoque.ConferenciaEstoqueLanctoEstoqueService;
import jalis.service.estoque.EstoqueManualLanctoEstoqueService;
import jalis.service.estoque.LancamentoEstoqueService;
import jalis.service.estoque.MontagemKitLanctoEstoqueService;
import jalis.service.estoque.NotaFiscalLanctoEstoqueService;
import jalis.service.estoque.PedidoLanctoEstoqueService;
import jalis.service.estoque.TransfEstoqueLanctoEstoqueService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

public class JanelaDetalhamentoLancamentos
extends AbstractDialogoOKCancelar {
    private static final int COLUNA_CODIGO = 0;
    private static final int COLUNA_DATA_HORA = 1;
    private static final int COLUNA_TIPO = 2;
    private static final int COLUNA_QUANTIDADE = 3;
    private static final int COLUNA_DETALHE_ORIGEM = 4;
    private JPanel panelLancamentos = new JPanel(new BorderLayout());
    private JPanel panelHistoricoAbertura = new JPanel(new GridBagLayout());
    private ModeloGridTable modeloLotes = null;
    private ModeloGridTable modeloLotesAbertura = null;
    private JTable tableLotes = null;
    private JTable tableLotesAbertura = null;
    private JScrollPane scrollLotes = null;
    private JScrollPane scrollLotesAbertura = null;
    private Set<MaterialLoteLanctoEstoqueBean> loteLancamentos = null;
    private CelulaEstoqueVO celula = null;
    private JLabel labelDataAbertura = new JLabel("");
    private JLabel labelDataFechamento = new JLabel("");
    private JLabel labelUserAbertura = new JLabel("");
    private JLabel labelUserFechamento = new JLabel("");
    private int codigoLote;

    public JanelaDetalhamentoLancamentos(Dialog pai, String descricaoMaterial, String lote, Set<MaterialLoteLanctoEstoqueBean> loteLancamentos, CelulaEstoqueVO celula, int codigoLote) {
        super(pai, "Movimenta\u00e7\u00e3o do lote " + lote + " - " + descricaoMaterial + " - " + celula.toString());
        this.loteLancamentos = loteLancamentos;
        this.celula = celula;
        this.codigoLote = codigoLote;
        this.montaTela();
    }

    public JanelaDetalhamentoLancamentos(Frame pai, String descricaoMaterial, String lote, Set<MaterialLoteLanctoEstoqueBean> loteLancamentos, CelulaEstoqueVO celula, int codigoLote) {
        super(pai, "Movimenta\u00e7\u00e3o do lote " + lote + " - " + descricaoMaterial + " - " + celula.toString());
        this.loteLancamentos = loteLancamentos;
        this.celula = celula;
        this.codigoLote = codigoLote;
        this.montaTela();
    }

    private void montaTela() {
        this.setModal(true);
        this.setSize(750, 600);
        this.setResizable(false);
        JPanel panelCentral = this.getPanelCentral();
        panelCentral.setLayout(new BorderLayout());
        this.panelLancamentos.setBorder(new TitledBorder("Hist\u00f3rico de Lan\u00e7amentos"));
        this.panelHistoricoAbertura.setBorder(new TitledBorder("Hist\u00f3rico de Abertura"));
        panelCentral.add((Component)this.panelHistoricoAbertura, "North");
        panelCentral.add((Component)this.panelLancamentos, "Center");
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 0, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.panelHistoricoAbertura.add((Component)this.labelDataAbertura, c);
        c.gridx = 0;
        ++c.gridy;
        this.panelHistoricoAbertura.add((Component)this.labelDataFechamento, c);
        this.modeloLotesAbertura = new ModeloGridTable(new String[]{"Data", "Usu\u00e1rio", "Situa\u00e7\u00e3o", "Coment\u00e1rio"});
        this.tableLotesAbertura = new JTable(this.modeloLotesAbertura);
        this.modeloLotesAbertura.setColumnSize(new int[]{125, 150, 100, 0}, this.tableLotesAbertura);
        this.scrollLotesAbertura = new JScrollPane(this.tableLotesAbertura);
        this.scrollLotesAbertura.setPreferredSize(new Dimension(20, 230));
        this.tableLotesAbertura.getTableHeader().addMouseListener(this.modeloLotesAbertura);
        this.tableLotesAbertura.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                String comentario;
                if (JanelaDetalhamentoLancamentos.this.tableLotesAbertura.getSelectedRow() > -1 && e.getClickCount() == 2 && JanelaDetalhamentoLancamentos.this.tableLotesAbertura.getValueAt(JanelaDetalhamentoLancamentos.this.tableLotesAbertura.getSelectedRow(), 3) != null && !Funcoes.textoVazio(comentario = JanelaDetalhamentoLancamentos.this.tableLotesAbertura.getValueAt(JanelaDetalhamentoLancamentos.this.tableLotesAbertura.getSelectedRow(), 3).toString())) {
                    DialogoComentarioEmLote.novaInstancia(Laboratorio.getInstancia(), comentario);
                }
            }
        });
        this.modeloLotesAbertura.ordenarColuna(0, -1);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 3;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.panelHistoricoAbertura.add((Component)this.scrollLotesAbertura, c);
        this.modeloLotes = new ModeloGridTable(new String[]{"C\u00f3digo", "Data/Hora", "Tipo", "Qtde.", "Detalhes da Origem"});
        this.tableLotes = new JTable(this.modeloLotes);
        this.modeloLotes.setColumnSize(new int[]{60, 125, 55, 70, 0}, this.tableLotes);
        this.scrollLotes = new JScrollPane(this.tableLotes);
        this.tableLotes.getTableHeader().addMouseListener(this.modeloLotes);
        this.modeloLotes.ordenarColuna(0, -1);
        this.panelLancamentos.add((Component)this.scrollLotes, "Center");
        this.buttonCancelar.setVisible(false);
        this.buttonOK.setText("Fechar");
        this.buttonOK.setMnemonic('F');
        try {
            this.carregaDados();
            this.carregaDadosHistorioLote();
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Erro ao carregar dados dos lan\u00e7amento do lote.", e.getStackTrace());
        }
        ScreenUtil.centralizar(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void carregaDadosHistorioLote() throws SQLException {
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append(" select moh.moh_datahora, moh.moh_operacao, moh.usr_codigo, moh.moh_comentario, ");
        buf.append(" mll.mll_aberturainicial as dataAberturaInicial, mll.usr_codaberturainicial as usuarioAberturaInicial ");
        buf.append(" from materiallotehistorico moh ");
        buf.append(" join materiallote mll on mll.fil_codigo = moh.fil_codigo and mll.mll_codigo = moh.mll_codigo ");
        buf.append(" where mll.fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append(" and mll.mll_codigo = ").append(this.codigoLote);
        buf.append(" order by moh.moh_datahora asc ");
        try (ResultSet rs = null;){
            rs = st.executeQuery(buf.toString());
            if (rs.next()) {
                this.labelDataAbertura.setText("Abertura: " + Funcoes.formataData("dd/MM/yyyy HH:mm:ss", rs.getTimestamp("dataAberturaInicial")) + " por " + rs.getString("usuarioAberturaInicial") + ".");
                do {
                    String operacao = rs.getString("moh_operacao");
                    String usuario = rs.getString("usr_codigo");
                    Timestamp data = rs.getTimestamp("moh_datahora");
                    String comentario = rs.getString("moh_comentario");
                    this.modeloLotesAbertura.addLine(new Object[]{Funcoes.formataData("dd/MM/yyyy HH:mm", data), usuario, Tipos.getTipoOperacaoMaterialLoteHistorico(operacao), comentario});
                    if (!operacao.equals("E")) continue;
                    this.labelDataFechamento.setText("Encerramento: " + Funcoes.formataData("dd/MM/yyyy HH:mm:ss", data) + " por " + usuario + ".");
                } while (rs.next());
            }
        }
    }

    private void carregaDados() {
        if (this.loteLancamentos == null) {
            return;
        }
        for (MaterialLoteLanctoEstoqueBean loteLancto : this.loteLancamentos) {
            LancamentoEstoqueVO lancamento = loteLancto.getLancamento();
            if (loteLancto.getQuantidade() == 0.0) continue;
            LancamentoEstoqueVO lanctoOrigem = null;
            if (lancamento.getTipoOrigem().equalsIgnoreCase("A")) {
                try {
                    lanctoOrigem = new LancamentoEstoqueService().getLancamentoOrigem(lancamento);
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(this, "Erro ao buscar o lan\u00e7amento de origem.\n" + e.getMessage(), e.getStackTrace());
                }
            }
            String detalheOrigem = this.getDetalhesOrigem(lancamento, lanctoOrigem);
            this.modeloLotes.addLine(new Object[]{lancamento.getCodigo(), Funcoes.formataData("dd/MM/yyyy HH:mm", lancamento.getDataHora()), Tipos.tipoLancamentoEstoque(lancamento.getTipo()), Funcoes.formataDecimal(loteLancto.getQuantidade()), Tipos.tipoOrigemLancamentoEstoque(lancamento.getTipoOrigem()) + (!Funcoes.textoVazio(detalheOrigem) ? " - " + detalheOrigem : "")});
        }
        this.modeloLotes.ordenarColuna(0, -1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getDetalhesOrigem(LancamentoEstoqueVO lancamento, LancamentoEstoqueVO lanctoOrigem) {
        if (lancamento == null) {
            return "";
        }
        String retorno = "";
        String tipoOrigem = lancamento.getTipoOrigem();
        String tipoDoLancamento = lancamento.getTipo();
        try {
            if (tipoOrigem.equalsIgnoreCase("A")) {
                if (lanctoOrigem == null) return retorno;
                retorno = retorno + "Filial: " + lanctoOrigem.getFilial().getCodigo();
                retorno = retorno + ", C\u00f3digo: " + lanctoOrigem.getCodigo();
                return retorno + ", Destino: " + lancamento.getCelula().getDescricao();
            }
            if (tipoOrigem.equalsIgnoreCase("C")) {
                ConferenciaEntradaLanctoEstoqueBean confEntradaLancto = new ConferenciaEntradaLanctoEstoqueService().getConferenciaEntradaLanctoEstoque(lancamento.getFilial().getCodigo().toString(), lancamento.getCodigo().toString());
                if (confEntradaLancto == null) return retorno;
                retorno = retorno + "Filial: " + confEntradaLancto.getFilial().getCodigo();
                return retorno + ", C\u00f3digo: " + confEntradaLancto.getConferenciaEntrada().getCodigo();
            }
            if (tipoOrigem.equalsIgnoreCase("O")) {
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("fil_codigo", lancamento.getFilial().getCodigo());
                chaves.put("lce_codigo", lancamento.getCodigo());
                ConferenciaEstoqueLanctoEstoqueBean confEstoqueLancto = (ConferenciaEstoqueLanctoEstoqueBean)new ConferenciaEstoqueLanctoEstoqueService().getBean(chaves);
                if (confEstoqueLancto == null) return retorno;
                retorno = retorno + "Filial: " + confEstoqueLancto.getFilial().getCodigo();
                return retorno + ", C\u00f3digo: " + confEstoqueLancto.getConferenciaEstoque().getCodigo();
            }
            if (tipoOrigem.equalsIgnoreCase("K")) {
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("fil_codigo", lancamento.getFilial().getCodigo());
                chaves.put("lce_codigo", lancamento.getCodigo());
                MontagemKitLanctoEstoqueBean montagemKitLancto = (MontagemKitLanctoEstoqueBean)new MontagemKitLanctoEstoqueService().getBean(chaves);
                if (montagemKitLancto == null) return retorno;
                retorno = retorno + "Filial: " + montagemKitLancto.getFilial().getCodigo();
                return retorno + ", C\u00f3digo: " + montagemKitLancto.getMontagemKit().getCodigo();
            }
            if (tipoOrigem.equalsIgnoreCase("N")) {
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("fil_codigo", lancamento.getFilial().getCodigo());
                chaves.put("lce_codigo", lancamento.getCodigo());
                NotaFiscalLanctoEstoqueBean notaLancto = (NotaFiscalLanctoEstoqueBean)new NotaFiscalLanctoEstoqueService().getBean(chaves);
                if (notaLancto == null) return retorno;
                retorno = retorno + "Filial: " + notaLancto.getFilial().getCodigo();
                retorno = retorno + ", C\u00f3digo: " + notaLancto.getNotaFiscal().getCodigo();
                return retorno + ", NF: " + notaLancto.getNotaFiscal().getNumero();
            }
            if (tipoOrigem.equalsIgnoreCase("D")) {
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("fil_codigo", lancamento.getFilial().getCodigo());
                chaves.put("lce_codigo", lancamento.getCodigo());
                PedidoLanctoEstoqueBean pedidoLancto = (PedidoLanctoEstoqueBean)new PedidoLanctoEstoqueService().getBean(chaves);
                if (pedidoLancto == null) return retorno;
                retorno = retorno + "Filial: " + pedidoLancto.getFilial().getCodigo();
                return retorno + ", C\u00f3digo: " + pedidoLancto.getPedido().getCodigo();
            }
            if (tipoOrigem.equalsIgnoreCase("M")) {
                EstoqueManualLanctoEstoqueBean estoqueManualLancto = new EstoqueManualLanctoEstoqueService().getEstoqueManualLanctoEstoqueBean(lancamento.getFilial().getCodigo().toString(), lancamento.getCodigo().toString());
                if (estoqueManualLancto == null) return retorno;
                retorno = retorno + "Filial: " + estoqueManualLancto.getFilial().getCodigo();
                return retorno + ", C\u00f3digo: " + estoqueManualLancto.getEstoqueManual().getCodigo();
            }
            if (tipoOrigem.equalsIgnoreCase("I")) return retorno;
            if (tipoOrigem.equalsIgnoreCase("T")) {
                TransfEstoqueLanctoEstoqueBean transfEstoqueLancto = (TransfEstoqueLanctoEstoqueBean)new TransfEstoqueLanctoEstoqueService().getBean(lancamento.getFilial().getCodigo().toString(), lancamento.getCodigo().toString());
                if (transfEstoqueLancto != null && tipoDoLancamento.equalsIgnoreCase("S")) {
                    retorno = retorno + "Filial: " + transfEstoqueLancto.getFilial().getCodigo();
                    retorno = retorno + ", C\u00f3digo: " + transfEstoqueLancto.getTransfEstoque().getCodigo();
                    retorno = retorno + ", Destino: " + transfEstoqueLancto.getTransfEstoque().getCelulaDestino().getDescricao();
                }
                if (transfEstoqueLancto == null) return retorno;
                if (!tipoDoLancamento.equalsIgnoreCase("E")) return retorno;
                retorno = retorno + "Filial: " + transfEstoqueLancto.getFilial().getCodigo();
                retorno = retorno + ", C\u00f3digo: " + transfEstoqueLancto.getTransfEstoque().getCodigo();
                return retorno + ", Origem: " + transfEstoqueLancto.getTransfEstoque().getCelulaOrigem().getDescricao();
            }
            if (tipoOrigem.equalsIgnoreCase("X")) {
                TransfEstoqueLanctoEstoqueBean transfEstoqueLancto = (TransfEstoqueLanctoEstoqueBean)new TransfEstoqueLanctoEstoqueService().getBean(lancamento.getFilial().getCodigo().toString(), lancamento.getCodigo().toString());
                if (transfEstoqueLancto == null) return retorno;
                retorno = retorno + "Filial: " + transfEstoqueLancto.getFilial().getCodigo();
                return retorno + ", C\u00f3digo: " + transfEstoqueLancto.getTransfEstoque().getCodigo();
            }
            if (tipoOrigem.equalsIgnoreCase("R") || tipoOrigem.equalsIgnoreCase("E") || tipoOrigem.equalsIgnoreCase("B") || tipoOrigem.equalsIgnoreCase("P")) return retorno;
            if (!tipoOrigem.equalsIgnoreCase("S")) return retorno;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            return "";
        }
        return retorno;
    }
}

