/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.estoque;

import jalis.comum.Conexao;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.Material;
import jalis.util.CheckItemFiltro;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class DialogoFiltroMateriais
extends JDialog
implements ActionListener {
    private JButton buttonCadastrar = ComponenteFactory.novoJButton("Cadastrar", 'a', this);
    private JButton buttonConsultar = ComponenteFactory.novoJButton("Consultar", 'n', this);
    private JButton buttonDesmarcarTodos = ComponenteFactory.novoJButton("Desmarcar Todos", 'D', this);
    private JButton buttonMarcarTodos = ComponenteFactory.novoJButton("Selecionar Todos", 'S', this);
    private JButton buttonOK = ComponenteFactory.novoJButton("OK", 'O', this);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    private TTextField textDescricao = new TTextField(40, 3);
    private CheckItemFiltro itemTipoMaterial = new CheckItemFiltro("Tipo Material", "Filtrar", "Filtrando Tipo de Material", "fil_codigo = " + Variaveis.filialPadrao);
    private SpinnerEditor spinnerEditor = new SpinnerEditor();
    JTable table = null;
    private final int COLUNA_SELECAO = 2;
    private final int COLUNA_QUANTIDADE = 3;
    private final int COLUNA_UNIDADE = 4;
    private final String PARAMETRO_TIPO_MATERIAL_SOLICITACAO_COTACAO = "SolicitarCotacao.tipoMaterialFiltro";
    private ModeloGridTable modMat = new ModeloGridTable(new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o Material", "Sel", "Qtde.", "Unid."}){

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 2 || col == 3;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 2) {
                return Boolean.class;
            }
            if (columnIndex == 3) {
                return Integer.class;
            }
            return Object.class;
        }

        @Override
        public void fireTableStructureChanged() {
            super.fireTableStructureChanged();
            if (DialogoFiltroMateriais.this.spinnerEditor != null) {
                DialogoFiltroMateriais.this.spinnerEditor.stopCellEditing();
            }
            if (DialogoFiltroMateriais.this.table != null) {
                DialogoFiltroMateriais.this.table.getColumn(DialogoFiltroMateriais.this.table.getColumnName(3)).setCellRenderer(new SpinnerRenderer());
                DialogoFiltroMateriais.this.table.getColumn(DialogoFiltroMateriais.this.table.getColumnName(3)).setCellEditor(DialogoFiltroMateriais.this.spinnerEditor);
            }
        }
    };
    private boolean ok;

    public DialogoFiltroMateriais(Frame pai) {
        super(pai, "Pesquisando Materiais", true);
        this.iniciar();
    }

    public DialogoFiltroMateriais(Dialog pai) {
        super(pai, "Pesquisando Materiais", true);
        this.iniciar();
    }

    public boolean getOk() {
        return this.ok;
    }

    public List<HashMap<String, Object>> getMateriaisSelecionados() {
        ArrayList<HashMap<String, Object>> sel = new ArrayList<HashMap<String, Object>>();
        for (int i = 0; i < this.modMat.getRowCount(); ++i) {
            HashMap<String, Object> hash = this.modMat.getLine(i);
            if (!hash.get("Sel").equals(true)) continue;
            sel.add(hash);
        }
        return sel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonOK || o == this.buttonCancelar) {
            String[] itens = this.itemTipoMaterial.getSelecionados();
            String aux = "";
            for (int i = 0; itens != null && i < itens.length; ++i) {
                aux = aux.length() > 0 ? aux + ", " + itens[i] : itens[i];
            }
            if (o == this.buttonOK) {
                String param = "<tipoMaterial>" + aux + "</tipoMaterial>";
                ParametrosUsuarios.setValor("SolicitarCotacao.tipoMaterialFiltro", param);
                ParametrosUsuarios.salvarParametros(true);
            }
            this.spinnerEditor.stopCellEditing();
            this.ok = o == this.buttonOK;
            this.dispose();
        } else if (o == this.buttonMarcarTodos || o == this.buttonDesmarcarTodos) {
            boolean marcar = o == this.buttonMarcarTodos;
            for (int i = 0; i < this.modMat.getRowCount(); ++i) {
                this.modMat.setValueAt(marcar, i, 2);
            }
            this.modMat.fireTableDataChanged();
        } else if (o == this.buttonConsultar) {
            this.consultarMateriais();
        } else if (o == this.buttonCadastrar) {
            this.cadastrarMaterial();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consultarMateriais() {
        Statement st = Conexao.getStatement();
        if (st != null) {
            try {
                this.buttonConsultar.setEnabled(false);
                this.modMat.clear();
                ResultSet res = Conexao.executeQuery(st, this.getSelect());
                while (res.next()) {
                    Object[] obj = new Object[]{res.getInt("codigo"), res.getString("descricao"), new Boolean(false), new Double(1.0), res.getString("unidade")};
                    this.modMat.addLine(obj);
                }
                this.modMat.fireTableDataChanged();
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            }
            finally {
                this.buttonConsultar.setEnabled(true);
            }
        }
    }

    private void cadastrarMaterial() {
        Material.novaInstanciaDialog(Laboratorio.getInstancia());
    }

    private String getSelect() {
        String[] materiais;
        StringBuilder buf = new StringBuilder();
        buf.append(" select mat.mat_codigo as codigo ");
        buf.append("       ,mat.mat_descricao as descricao ");
        buf.append("       ,mat.unm_codigo as unidade ");
        buf.append("   from material mat ");
        buf.append("   left join tipomaterial tpm on mat.fil_codigo = tpm.fil_codigo and mat.tpm_codigo = tpm.tpm_codigo ");
        buf.append("  where mat.fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append("    and not mat.mat_inativo ");
        if (!Funcoes.textoVazio(this.textDescricao)) {
            buf.append(" and mat_descricao ilike '%").append(this.textDescricao.getText()).append("%' ");
        }
        if ((materiais = this.itemTipoMaterial.getSelecionados()) != null && materiais.length > 0) {
            buf.append(" and tpm.tpm_codigo in (");
            for (int i = 0; i < materiais.length; ++i) {
                if (i != materiais.length - 1) {
                    buf.append(materiais[i]).append(", ");
                    continue;
                }
                buf.append(materiais[i]);
            }
            buf.append(") ");
        }
        buf.append("  order by mat.mat_descricao ");
        return buf.toString();
    }

    private void iniciar() {
        this.getContentPane().setLayout(new GridBagLayout());
        JPanel panelBotoes = new JPanel(new BorderLayout());
        panelBotoes.add((Component)ComponenteFactory.novoJPanelFlowLayout(0, this.buttonMarcarTodos, this.buttonDesmarcarTodos, this.buttonCadastrar), "West");
        panelBotoes.add((Component)ComponenteFactory.novoJPanelFlowLayout(2, this.buttonOK, this.buttonCancelar), "East");
        JPanel panelTabela = new JPanel(new BorderLayout());
        panelTabela.setBorder(BorderFactory.createTitledBorder("Materiais"));
        this.table = new JTable(this.modMat);
        this.modMat.setColumnSize(new int[]{60, 0, 30, 60, 35}, this.table);
        this.table.getTableHeader().addMouseListener(this.modMat);
        this.table.setRowHeight(20);
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int row;
                int[] colunas = ((JTable)e.getSource()).getSelectedColumns();
                boolean colunaSelecionada = false;
                for (int i = 0; i < colunas.length; ++i) {
                    if (colunas[i] != 2) continue;
                    colunaSelecionada = true;
                    break;
                }
                if (e.getKeyCode() == 32 && !colunaSelecionada && (row = ((JTable)e.getSource()).getSelectedRow()) >= 0) {
                    Boolean valor = (Boolean)DialogoFiltroMateriais.this.modMat.getValueAt(row, 2);
                    DialogoFiltroMateriais.this.modMat.setValueAt(valor == false, row, 2);
                }
            }
        });
        JScrollPane scroll = new JScrollPane(this.table);
        scroll.setPreferredSize(new Dimension(600, 200));
        panelTabela.add((Component)scroll, "Center");
        JPanel panelFiltros = new JPanel(new GridBagLayout());
        panelFiltros.setBorder(BorderFactory.createTitledBorder("Filtros"));
        Dimension d = new Dimension(200, 20);
        this.textDescricao.setPreferredSize(d);
        this.textDescricao.setMinimumSize(d);
        this.itemTipoMaterial.setDados("tipomaterial", new String[]{"tpm_codigo", "tpm_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemTipoMaterial.setColunaHint(1);
        d = new Dimension(180, 20);
        this.itemTipoMaterial.setPreferredSize(d);
        this.itemTipoMaterial.setMinimumSize(d);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(1, 1, 1, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 17;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 0;
        panelFiltros.add((Component)new JLabel("Descri\u00e7\u00e3o:"), c);
        ++c.gridx;
        panelFiltros.add((Component)this.textDescricao, c);
        ++c.gridx;
        c.insets = new Insets(0, 20, 0, 0);
        panelFiltros.add((Component)this.itemTipoMaterial, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        panelFiltros.add((Component)new JLabel(""), c);
        ++c.gridx;
        c.fill = 0;
        c.anchor = 12;
        panelFiltros.add((Component)this.buttonConsultar, c);
        Container panelPrinc = this.getContentPane();
        panelPrinc.setLayout(new GridBagLayout());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 2;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        panelPrinc.add((Component)panelFiltros, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.fill = 1;
        panelPrinc.add((Component)panelTabela, c);
        ++c.gridy;
        panelPrinc.add((Component)panelBotoes, c);
        Funcoes.montaEnter((JComponent)this.getContentPane());
        this.modMat.ordenarColuna(this.modMat.findColumn("Descri\u00e7\u00e3o Material"));
        this.pack();
        d = new Dimension(250, 200);
        this.setPreferredSize(d);
        this.setMinimumSize(d);
        this.setResizable(false);
        ScreenUtil.centralizar(this);
        String param = ParametrosUsuarios.getValor("SolicitarCotacao.tipoMaterialFiltro");
        if (param != null && !Funcoes.textoVazio(param)) {
            StringTokenizer tokenizer = new StringTokenizer(StringUtil.getValor(param, "tipoMaterial"), ",");
            String[] itens = new String[tokenizer.countTokens()];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                itens[i++] = tokenizer.nextToken().trim();
            }
            this.itemTipoMaterial.setSelecionados(itens);
            this.itemTipoMaterial.setSelected(true);
        }
    }

    class SpinnerEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        final JSpinner spinner = new JSpinner();

        public SpinnerEditor() {
            this.spinner.setModel(new SpinnerNumberModel(1.0, 0.1, Double.MAX_VALUE, 0.1));
            ((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField().addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 9 || e.getKeyCode() == 10) {
                        SpinnerEditor.this.gravaValorNoCampo();
                    }
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.spinner.setValue(value);
            return this.spinner;
        }

        @Override
        public boolean isCellEditable(EventObject evt) {
            if (evt instanceof MouseEvent) {
                return ((MouseEvent)evt).getClickCount() >= 1;
            }
            return true;
        }

        @Override
        public Object getCellEditorValue() {
            this.gravaValorNoCampo();
            return this.spinner.getValue();
        }

        private void gravaValorNoCampo() {
            try {
                this.spinner.commitEdit();
            }
            catch (ParseException e1) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e1.getMessage(), e1.getStackTrace());
            }
        }
    }

    class SpinnerRenderer
    implements TableCellRenderer {
        Component comp = null;

        SpinnerRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (column == 3) {
                if (this.comp == null) {
                    this.comp = new JSpinner();
                }
                if (value instanceof Double) {
                    ((JSpinner)this.comp).setValue((Double)value);
                }
            }
            return this.comp;
        }
    }
}

