/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.estoque;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.estoque.MaterialLoteLancamentoInserir;
import jalis.model.bean.estoque.LancamentoEstoqueBean;
import jalis.model.bean.estoque.MaterialBean;
import jalis.model.bean.estoque.MaterialLoteBean;
import jalis.model.bean.estoque.MaterialLoteLanctoEstoqueBean;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.estoque.LancamentoEstoqueVO;
import jalis.model.vo.estoque.MaterialLoteVO;
import jalis.model.vo.estoque.MaterialVO;
import jalis.service.estoque.LancamentoEstoqueService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.CorTableCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AssociarLote
extends AbstractDialogoOKCancelar
implements ActionListener {
    private static final long ACESSO_ASSOCIAR_LOTE = Long.parseLong("0101300305");
    private static final int OBJETO_LOTE = 6;
    private JLabel labelLote = new JLabel("Lote:");
    private JLabel labelQtdLote = new JLabel("Qtde. lote:");
    private JLabel labelData = new JLabel("Data:");
    private JLabel labelValidade = new JLabel("Validade:");
    private JLabel labelObs = new JLabel("Observa\u00e7\u00e3o");
    private JLabel labelEntradaAtual = new JLabel("Entrada atual:");
    private JLabel labelQtdLoteConsuminda = new JLabel("Qtde. Cons.:");
    private JLabel labelVlrUnidadeMedida = new JLabel("");
    private JLabel labelUnidadeMedida = new JLabel("");
    private JLabel labelDescricaoLancto = new JLabel("");
    private TTextField textQtdeLoteConsumida = new TTextField();
    private TTextField textLote = new TTextField();
    private TTextField textQtdeLote = new TTextField();
    private TTextField textData = new TTextField(10, 4);
    private TTextField textValidade = new TTextField(10, 4);
    private JTextArea textObs = new JTextArea();
    private JButton buttonData = ComponenteFactory.novoJButton(null, true);
    private JButton buttonValidade = ComponenteFactory.novoJButton(null, true);
    private JButton buttonAdicionar = ComponenteFactory.novoJButton("Adicionar", 'A', null);
    private ModeloGridTable modeloLote = new ModeloGridTable(new String[]{"Lote", "Data", "Validade", "Qtde.", "Lancto.", "Qtde. Cons."});
    private JTable tableLote = new JTable(this.modeloLote);
    private JScrollPane scrollPaneLote = new JScrollPane(this.tableLote);
    private ModeloGridTable modeloLcto = new ModeloGridTable(new String[]{""});
    private JTable tableLcto = new JTable(this.modeloLcto);
    private JScrollPane scrollPaneLcto = new JScrollPane(this.tableLcto);
    private JPanel paneLcto = new JPanel(new BorderLayout());
    private JPanel panelDataValidade = new JPanel(new GridBagLayout());
    private JPanel paneLote = new JPanel(new GridBagLayout());
    private Double saldoAtual = 0.0;
    private Double saldoRestante = 0.0;
    private int editandoLinha = -1;
    private LancamentoEstoqueService lancamentoEstoqueService = new LancamentoEstoqueService();
    private Map<Object, Object> params = new HashMap<Object, Object>();
    private CorTableCellRenderer renderer = new CorTableCellRenderer();
    private CorTableCellRenderer rendererLote = new CorTableCellRenderer();
    private JLabel legenda = new JLabel("Lan\u00e7amentos associados");
    List<MaterialLoteLancamentoInserir> listRemover = new ArrayList<MaterialLoteLancamentoInserir>();
    private boolean dadoEditado = false;

    public AssociarLote(Frame pai, String titulo, Map<Object, Object> params, List<List<Object>> listsLotesTemp, List<List<Object>> listsLotesRemover) {
        super(pai, titulo);
        this.params = params;
        this.montaTela(params, listsLotesTemp, listsLotesRemover);
        this.setResizable(false);
        this.setSize(793, 600);
        ScreenUtil.centralizar(this);
        this.setModal(true);
        this.setVisible(true);
    }

    public List<MaterialLoteLancamentoInserir> getLotesInserir() {
        ArrayList<MaterialLoteLancamentoInserir> list = new ArrayList<MaterialLoteLancamentoInserir>();
        for (int i = 0; i < this.modeloLote.getRowCount(); ++i) {
            list.add((MaterialLoteLancamentoInserir)this.modeloLote.getValueAt(i, 6));
        }
        return list;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.buttonOK) ? !this.validarAssociacao() : e.getSource().equals(this.buttonCancelar) && (this.getPossuiLoteRecemCriado() || this.dadoEditado) && Funcoes.mensagem(Laboratorio.getInstancia(), "Os dados do lan\u00e7amento ser\u00e3o perdidos. Deseja continuar?", 4) == 1) {
            return;
        }
        super.actionPerformed(e);
    }

    private boolean validarAssociacao() {
        int resp;
        if (this.getTotalLotesModelo() < this.getQuantidadeLancanmeto() && (resp = Funcoes.mensagem(Laboratorio.getInstancia(), "A quantidate dos lotes \u00e9 menor do que a quantidade dos lan\u00e7amentos. Deseja continuar?", 4)) == 1) {
            return false;
        }
        Double totalLancto = this.getQuantidadeLancanmeto();
        Double totalConsumida = this.getQuantidadeConsumida();
        Double totalEstoque = Double.parseDouble(this.params.get("saldoAtual").toString());
        if (totalLancto - totalConsumida != totalEstoque) {
            if (this.getQuantidadeConsumida().doubleValue() == this.getQuantidadeAssociarOriginal().doubleValue()) {
                return true;
            }
            int resp2 = Funcoes.mensagem(Laboratorio.getInstancia(), "A Quantidade consumida foi " + Funcoes.formataDecimal(this.getQuantidadeConsumida()) + ", a quantidade correta para consumo deveria ser " + Funcoes.formataDecimal(this.getQuantidadeAssociarOriginal()) + " . Deseja continuar?", 4);
            if (resp2 == 1) {
                return false;
            }
        }
        return true;
    }

    public static long getAcessoAssociarLote() {
        return ACESSO_ASSOCIAR_LOTE;
    }

    private boolean getPossuiLoteRecemCriado() {
        for (int i = 0; i < this.modeloLote.getRowCount(); ++i) {
            Boolean loteRecente = (Boolean)this.modeloLote.getValueAt(i, 7);
            if (!loteRecente.booleanValue()) continue;
            return true;
        }
        return false;
    }

    private void montaTela(Map<Object, Object> params, List<List<Object>> listsLotesTemp, List<List<Object>> listsLotesRemover) {
        this.getPanelCentral().setLayout(new GridBagLayout());
        this.modeloLcto.setColumnSize(new int[]{70, 0, 70}, this.tableLcto);
        this.modeloLote.setColumnSize(new int[]{0, 85, 85, 70, 60, 70}, this.tableLote);
        this.tableLcto.setRowHeight(88);
        this.tableLcto.setRowMargin(2);
        this.legenda.setIcon(ImagemUtils.criarImagemLegenda(10, 10, Color.CYAN, Color.BLACK));
        this.legenda.setFont(new Font(this.legenda.getFont().getName(), 0, 10));
        this.renderer.setVerticalAlignment(1);
        this.tableLcto.getColumnModel().getColumn(0).setCellRenderer(this.renderer);
        this.saldoAtual = (Double)params.get("saldoAtual");
        this.saldoRestante = (Double)params.get("saldoRestanteLote");
        ScreenUtil.setBorda(new JComponent[]{this.labelUnidadeMedida, this.labelVlrUnidadeMedida}, new TitledBorder(""));
        GridBagConstraints bag = new GridBagConstraints();
        bag.gridx = 0;
        bag.gridy = 0;
        bag.fill = 3;
        bag.weightx = 0.0;
        bag.weighty = 1.0;
        GridBagConstraints bagLote = new GridBagConstraints();
        bagLote.gridx = 0;
        bagLote.gridy = 0;
        bagLote.fill = 2;
        bagLote.weightx = 0.0;
        bagLote.weighty = 0.0;
        bagLote.insets = new Insets(1, 1, 1, 2);
        GridBagConstraints bagConsumida = new GridBagConstraints();
        bagConsumida.gridx = 0;
        bagConsumida.gridy = 0;
        bagConsumida.fill = 2;
        bagConsumida.weightx = 0.0;
        bagConsumida.weighty = 0.0;
        bagConsumida.insets = new Insets(1, 1, 1, 1);
        GridBagConstraints bagValidade = new GridBagConstraints();
        bagValidade.gridx = 0;
        bagValidade.gridy = 0;
        bagValidade.fill = 0;
        bagValidade.anchor = 17;
        bagValidade.weightx = 0.0;
        bagValidade.weighty = 0.0;
        bagValidade.insets = new Insets(1, 0, 1, 0);
        this.paneLcto.setPreferredSize(new Dimension(270, 100));
        this.paneLcto.setMinimumSize(new Dimension(270, 100));
        this.paneLcto.setBorder(new TitledBorder("Lan\u00e7amentos"));
        this.paneLcto.add(this.scrollPaneLcto);
        this.getPanelCentral().add((Component)this.paneLcto, bag);
        this.paneLote.add((Component)this.labelLote, bagLote);
        bagLote.insets = new Insets(1, 1, 1, 0);
        ++bagLote.gridx;
        bagLote.gridwidth = 3;
        this.textLote.setPreferredSize(new Dimension(201, 20));
        this.textLote.setMinimumSize(new Dimension(201, 20));
        this.paneLote.add((Component)this.textLote, bagLote);
        bagLote.gridwidth = 1;
        bagLote.insets = new Insets(1, 1, 1, 1);
        bagLote.insets = new Insets(0, 20, 1, 0);
        bagLote.gridx += 3;
        this.paneLote.add((Component)this.labelQtdLote, bagLote);
        bagLote.insets = new Insets(0, 1, 0, 0);
        ++bagLote.gridx;
        this.textQtdeLote.setPreferredSize(new Dimension(90, 20));
        this.textQtdeLote.setMinimumSize(new Dimension(90, 20));
        this.paneLote.add((Component)this.textQtdeLote, bagLote);
        bagLote.insets = new Insets(1, 1, 1, 2);
        ++bagLote.gridx;
        this.labelVlrUnidadeMedida.setPreferredSize(new Dimension(100, 19));
        this.labelVlrUnidadeMedida.setMinimumSize(new Dimension(100, 19));
        this.paneLote.add((Component)this.labelVlrUnidadeMedida, bagLote);
        bagLote.insets = new Insets(0, 1, 0, 0);
        this.panelDataValidade.add((Component)this.labelData, bagValidade);
        bagValidade.insets = new Insets(1, 1, 1, 0);
        ++bagValidade.gridx;
        this.textData.setPreferredSize(new Dimension(90, 20));
        this.textData.setMinimumSize(new Dimension(90, 20));
        this.panelDataValidade.add((Component)this.textData, bagValidade);
        ++bagValidade.gridx;
        bagValidade.insets = new Insets(0, 1, 1, 0);
        this.buttonData.setPreferredSize(new Dimension(20, 19));
        this.buttonData.setMinimumSize(new Dimension(20, 19));
        this.panelDataValidade.add((Component)this.buttonData, bagValidade);
        bagValidade.insets = new Insets(0, 20, 1, 0);
        ++bagValidade.gridx;
        this.panelDataValidade.add((Component)this.labelValidade, bagValidade);
        bagValidade.insets = new Insets(0, 1, 0, 0);
        ++bagValidade.gridx;
        this.textValidade.setPreferredSize(new Dimension(90, 20));
        this.textValidade.setMinimumSize(new Dimension(90, 20));
        this.panelDataValidade.add((Component)this.textValidade, bagValidade);
        ++bagValidade.gridx;
        bagValidade.insets = new Insets(0, 1, 1, 0);
        this.buttonValidade.setPreferredSize(new Dimension(20, 19));
        this.buttonValidade.setMinimumSize(new Dimension(20, 19));
        this.panelDataValidade.add((Component)this.buttonValidade, bagValidade);
        ++bagValidade.gridx;
        bagValidade.insets = new Insets(0, 20, 1, 0);
        this.panelDataValidade.add((Component)this.labelQtdLoteConsuminda, bagValidade);
        bagValidade.weightx = 1.0;
        bagValidade.fill = 2;
        ++bagValidade.gridx;
        bagValidade.insets = new Insets(0, 0, 1, 0);
        this.panelDataValidade.add((Component)this.textQtdeLoteConsumida, bagValidade);
        bagLote.gridx = 0;
        ++bagLote.gridy;
        bagLote.gridwidth = 8;
        bagLote.fill = 2;
        this.paneLote.add((Component)this.panelDataValidade, bagLote);
        bagLote.gridx = 0;
        bagLote.gridwidth = 8;
        bagLote.fill = 2;
        bagLote.insets = new Insets(1, 1, 1, 1);
        ++bagLote.gridy;
        this.paneLote.add((Component)this.labelObs, bagLote);
        ++bagLote.gridy;
        this.textObs.setPreferredSize(new Dimension(100, 50));
        this.textObs.setMinimumSize(new Dimension(100, 50));
        JScrollPane scrollPane = new JScrollPane(this.textObs);
        scrollPane.setPreferredSize(new Dimension(100, 50));
        scrollPane.setMinimumSize(new Dimension(100, 50));
        this.paneLote.add((Component)scrollPane, bagLote);
        bagLote.insets = new Insets(0, 0, 0, 0);
        ++bagLote.gridy;
        JPanel panelAdicionar = new JPanel(new FlowLayout(2));
        this.buttonAdicionar.setPreferredSize(new Dimension(100, 20));
        this.buttonAdicionar.setMinimumSize(new Dimension(100, 20));
        panelAdicionar.add(this.buttonAdicionar);
        this.paneLote.add((Component)panelAdicionar, bagLote);
        JPanel panelTableLote = new JPanel(new BorderLayout());
        panelTableLote.setBorder(new TitledBorder("Informa\u00e7\u00f5es dos lotes"));
        panelTableLote.add(this.scrollPaneLote);
        bagLote.fill = 1;
        bagLote.gridx = 0;
        ++bagLote.gridy;
        bagLote.weightx = 1.0;
        bagLote.weighty = 1.0;
        bagLote.gridwidth = 11;
        this.paneLote.add((Component)panelTableLote, bagLote);
        this.paneLote.setBorder(new TitledBorder("Lotes"));
        bag.fill = 1;
        bag.weightx = 1.0;
        ++bag.gridx;
        this.getPanelCentral().add((Component)this.paneLote, bag);
        bag.gridx = 0;
        bag.weighty = 0.0;
        bag.fill = 2;
        ++bag.gridy;
        bag.gridwidth = 2;
        JPanel panelEntradaAtual = new JPanel(new FlowLayout(2));
        panelEntradaAtual.add(this.labelEntradaAtual);
        this.getPanelCentral().add((Component)this.labelDescricaoLancto, bag);
        ++bag.gridx;
        this.getPanelCentral().add((Component)panelEntradaAtual, bag);
        bag.gridx = 0;
        bag.weighty = 0.0;
        bag.fill = 2;
        ++bag.gridy;
        bag.gridx = 0;
        bag.gridwidth = 2;
        JPanel panelLegenda = new JPanel(new FlowLayout(0));
        panelLegenda.add(this.legenda);
        this.getPanelCentral().add((Component)panelLegenda, bag);
        this.textObs.setWrapStyleWord(true);
        this.textObs.setLineWrap(true);
        ScreenUtil.montaSaidaTextArea(this.textObs);
        ScreenUtil.posicionaTextoTopo(this.textObs);
        this.buscarLancamento(params);
        this.montaLancamentosMemoria(listsLotesTemp, listsLotesRemover);
        this.atualizarQtdeLanctoAssociar();
        if (this.tableLcto.getSelectedRow() > -1) {
            this.textQtdeLote.setText(Funcoes.formataDecimal(this.getLanctoSelecionado().getQuantidade() - this.getTotalLoteAtingiuLimiteQtdeLancto()));
        }
        this.labelVlrUnidadeMedida.setText(((MaterialBean)params.get("material")).getUnidadeMedida().getCodigo());
        this.labelEntradaAtual.setText(this.getEntradaAtual());
        this.tableLcto.addMouseListener(this.modeloLcto);
        this.tableLcto.getTableHeader().addMouseListener(this.modeloLcto);
        this.tableLcto.setDefaultRenderer(String.class, this.renderer);
        this.tableLote.addMouseListener(this.modeloLote);
        this.tableLote.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (AssociarLote.this.editandoLinha == -1) {
                    AssociarLote.this.modeloLote.mouseClicked(e);
                }
            }
        });
        this.tableLote.setDefaultRenderer(Object.class, this.rendererLote);
        this.marcarLanctoAssociado();
        ScreenUtil.requisitarFoco(this.textLote);
        this.tableLote.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (AssociarLote.this.tableLote.getSelectedRow() > -1) {
                    MaterialLoteLancamentoInserir novoLote = (MaterialLoteLancamentoInserir)AssociarLote.this.modeloLote.getValueAt(AssociarLote.this.tableLote.getSelectedRow(), 6);
                    for (int i = 0; i < AssociarLote.this.modeloLcto.getRowCount(); ++i) {
                        LancamentoEstoqueBean lancamentoBean = (LancamentoEstoqueBean)AssociarLote.this.modeloLcto.getValueAt(i, 3);
                        if (!novoLote.getMaterialLoteLanctoEstoqueBean().getLancamento().getCodigo().equals(lancamentoBean.getCodigo())) continue;
                        AssociarLote.this.tableLcto.getSelectionModel().setSelectionInterval(i, i);
                        break;
                    }
                }
            }
        });
        this.tableLcto.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                AssociarLote.this.tableLote.clearSelection();
                if (AssociarLote.this.tableLcto.getSelectedRow() != -1) {
                    AssociarLote.this.textQtdeLote.setText(Funcoes.formataDecimal(AssociarLote.this.getLanctoSelecionado().getQuantidade() - AssociarLote.this.getTotalLoteAtingiuLimiteQtdeLancto()));
                    AssociarLote.this.marcarLoteLanctoSelecionado();
                    AssociarLote.this.labelEntradaAtual.setText(AssociarLote.this.getEntradaAtual());
                }
            }
        });
        this.buttonAdicionar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssociarLote.this.addLote();
            }
        });
        this.buttonData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Funcoes.mostraData(AssociarLote.this.textData, AssociarLote.this.buttonData, AssociarLote.this.panelDataValidade, true);
            }
        });
        this.buttonValidade.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Funcoes.mostraData(AssociarLote.this.textValidade, AssociarLote.this.buttonValidade, AssociarLote.this.panelDataValidade, true);
            }
        });
        this.textData.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    AssociarLote.this.buttonData.doClick();
                }
            }
        });
        this.tableLote.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 || e.getKeyCode() == 32) {
                    AssociarLote.this.editarLinhaLote();
                }
            }
        });
        this.textValidade.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    AssociarLote.this.buttonValidade.doClick();
                }
            }
        });
        this.tableLote.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int row;
                if (e.getKeyCode() == 127 && (row = ((JTable)e.getSource()).getSelectedRow()) >= 0) {
                    if (AssociarLote.this.getLanctoSelecionado().getTipoOrigem().equalsIgnoreCase("T")) {
                        Funcoes.mensagem(Laboratorio.getInstancia(), "Lote n\u00e3o pode ser exclu\u00eddo. Lan\u00e7amento possui como origem uma transfer\u00eancia entre estoques.", 2);
                        return;
                    }
                    int resp = Funcoes.mensagem(Laboratorio.getInstancia(), "Deseja remover o lote da composi\u00e7\u00e3o?", 4);
                    if (resp == 0) {
                        AssociarLote.this.listRemover.add((MaterialLoteLancamentoInserir)AssociarLote.this.modeloLote.getValueAt(row, 6));
                        AssociarLote.this.modeloLote.removeLine(row);
                        AssociarLote.this.dadoEditado = true;
                        AssociarLote.this.labelEntradaAtual.setText(AssociarLote.this.getEntradaAtual());
                        AssociarLote.this.textQtdeLote.setText(Funcoes.formataDecimal(AssociarLote.this.getLanctoSelecionado().getQuantidade() - AssociarLote.this.getTotalLoteAtingiuLimiteQtdeLancto()));
                        AssociarLote.this.atualizarQtdeLanctoAssociar();
                        AssociarLote.this.marcarLanctoAssociado();
                        AssociarLote.this.marcarLoteLanctoSelecionado();
                        AssociarLote.this.verificarStatusExcluir();
                        AssociarLote.this.editandoLinha = -1;
                    }
                }
            }
        });
        if (this.modeloLcto.getRowCount() == 1) {
            this.tableLcto.getSelectionModel().setSelectionInterval(0, 0);
            if (this.tableLcto.getSelectedRow() > -1) {
                this.textQtdeLote.setText(Funcoes.formataDecimal(this.getLanctoSelecionado().getQuantidade() - this.getTotalLoteAtingiuLimiteQtdeLancto()));
            }
            this.marcarLoteLanctoSelecionado();
        } else {
            this.tableLcto.clearSelection();
            this.textQtdeLote.setText("");
            this.textQtdeLoteConsumida.setText("");
        }
    }

    public List<MaterialLoteLancamentoInserir> getListRemover() {
        return this.listRemover;
    }

    private void marcarLoteLanctoSelecionado() {
        this.rendererLote.limpar();
        LancamentoEstoqueVO lancamentoEstoqueVo = this.getLanctoSelecionado();
        this.modeloLote.ordenarColunaSemTrocarSentido(4);
        int posInicial = -1;
        int posFinal = -1;
        for (int i = 0; i < this.modeloLote.getRowCount(); ++i) {
            MaterialLoteLancamentoInserir novoLote = (MaterialLoteLancamentoInserir)this.modeloLote.getValueAt(i, 6);
            if (!novoLote.getMaterialLoteLanctoEstoqueBean().getLancamento().getCodigo().equals(lancamentoEstoqueVo.getCodigo())) continue;
            if (posInicial == -1) {
                posInicial = i;
            }
            posFinal = i;
            this.rendererLote.setCorLinha(Color.CYAN, i);
        }
        this.tableLote.getSelectionModel().setSelectionInterval(posInicial, posFinal);
        this.tableLote.repaint();
    }

    protected void editarLinhaLote() {
        this.editandoLinha = this.tableLote.getSelectedRow();
        if (this.editandoLinha > -1) {
            this.editarloteLancamentoTransf();
            MaterialLoteLancamentoInserir novoLote = (MaterialLoteLancamentoInserir)this.modeloLote.getValueAt(this.editandoLinha, 6);
            if (novoLote != null) {
                for (int i = 0; i < this.modeloLcto.getRowCount(); ++i) {
                    LancamentoEstoqueBean lancamentoBean = (LancamentoEstoqueBean)this.modeloLcto.getValueAt(i, 3);
                    if (!novoLote.getMaterialLoteLanctoEstoqueBean().getLancamento().getCodigo().equals(lancamentoBean.getCodigo())) continue;
                    this.tableLcto.getSelectionModel().setSelectionInterval(i, i);
                }
                this.textLote.setText(novoLote.getMaterialLoteBean().getLote());
                this.textQtdeLote.setText(Funcoes.formataDecimal(novoLote.getMaterialLoteBean().getQuantidade()));
                this.textData.setText(Funcoes.formataData(novoLote.getMaterialLoteBean().getDataHoraCriacao()));
                this.textValidade.setText(Funcoes.formataData(novoLote.getMaterialLoteBean().getValidadeLote()));
                this.textObs.setText(novoLote.getMaterialLoteBean().getObservacao());
                if (novoLote.getMaterialLoteBean().getQuantidadeConsumida() != null) {
                    this.textQtdeLoteConsumida.setText(Funcoes.formataDecimal(novoLote.getMaterialLoteBean().getQuantidadeConsumida()));
                } else {
                    this.textQtdeLoteConsumida.setText(Funcoes.formataDecimal(0.0));
                }
                this.tableLcto.setEnabled(false);
                this.tableLote.setEnabled(false);
            }
        }
    }

    private void editarloteLancamentoTransf() {
        if (this.getLanctoSelecionado().getTipoOrigem().equalsIgnoreCase("T")) {
            this.textLote.setEnabled(false);
            this.textQtdeLote.setEnabled(false);
            this.textData.setEnabled(false);
            this.textValidade.setEnabled(false);
            this.buttonData.setEnabled(false);
            this.buttonValidade.setEnabled(false);
        } else {
            this.textLote.setEnabled(true);
            this.textQtdeLote.setEnabled(true);
            this.textData.setEnabled(true);
            this.textValidade.setEnabled(true);
            this.buttonData.setEnabled(true);
            this.buttonValidade.setEnabled(true);
        }
    }

    private void montaLancamentosMemoria(List<List<Object>> listsLotesTemp, List<List<Object>> listsLotesRemover) {
        try {
            MaterialLoteLanctoEstoqueBean materialLoteLanctoEstoqueBean;
            MaterialLoteBean materialLoteBean;
            for (List<Object> lisObjects : listsLotesRemover) {
                materialLoteBean = null;
                materialLoteLanctoEstoqueBean = null;
                for (Object object : lisObjects) {
                    if (object instanceof MaterialLoteBean) {
                        materialLoteBean = (MaterialLoteBean)object;
                        continue;
                    }
                    if (!(object instanceof MaterialLoteLanctoEstoqueBean)) continue;
                    materialLoteLanctoEstoqueBean = (MaterialLoteLanctoEstoqueBean)object;
                }
                this.listRemover.add(new MaterialLoteLancamentoInserir(materialLoteBean, materialLoteLanctoEstoqueBean));
            }
            for (List<Object> lisObjects : listsLotesTemp) {
                materialLoteBean = null;
                materialLoteLanctoEstoqueBean = null;
                for (Object object : lisObjects) {
                    if (object instanceof MaterialLoteBean) {
                        materialLoteBean = (MaterialLoteBean)object;
                        continue;
                    }
                    if (!(object instanceof MaterialLoteLanctoEstoqueBean)) continue;
                    materialLoteLanctoEstoqueBean = (MaterialLoteLanctoEstoqueBean)object;
                }
                this.modeloLote.addLine(new Object[]{materialLoteBean.getLote(), Funcoes.formataData(materialLoteBean.getDataHoraCriacao()), Funcoes.formataData(materialLoteBean.getValidadeLote()), Funcoes.formataDecimal(materialLoteBean.getQuantidade()), materialLoteLanctoEstoqueBean.getLancamento().getCodigo(), Funcoes.formataDecimal(materialLoteBean.getQuantidadeConsumida()), new MaterialLoteLancamentoInserir(materialLoteBean, (MaterialLoteLanctoEstoqueBean)materialLoteLanctoEstoqueBean.clonar()), false});
                LancamentoEstoqueBean lanctoEstBean = this.converterParaLancamentoBean(materialLoteLanctoEstoqueBean);
                if (lanctoEstBean == null || this.modeloLcto.localizar(4, lanctoEstBean.getCodigo().toString()) != -1) continue;
                this.modeloLcto.addLine(new Object[]{this.getDescricaoLancamento(lanctoEstBean, materialLoteLanctoEstoqueBean.getQuantidade()), Funcoes.formataData(lanctoEstBean.getDataHora()), Funcoes.formataDecimal(lanctoEstBean.getQuantidade()), lanctoEstBean, lanctoEstBean.getCodigo(), this.getQuantidadeAssociada(materialLoteBean.getMaterial().getCodigo().toString(), materialLoteLanctoEstoqueBean.getLancamento().getCodigo().toString())});
            }
            this.modeloLote.ordenarColunaSemTrocarSentido(4);
            for (int i = 0; i < this.modeloLcto.getRowCount(); ++i) {
                this.tableLcto.getSelectionModel().setSelectionInterval(i, i);
                this.verificarStatus();
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar lan\u00e7amento.", e.getStackTrace());
        }
    }

    private LancamentoEstoqueBean converterParaLancamentoBean(MaterialLoteLanctoEstoqueBean materialLoteLanctoEstoqueBean) {
        try {
            Set beans = new LancamentoEstoqueService().load(" where fil_codigo = " + materialLoteLanctoEstoqueBean.getLancamento().getFilial().getCodigo() + " and lce_codigo = " + materialLoteLanctoEstoqueBean.getLancamento().getCodigo() + " and lce_tipo = '" + "E" + "' ");
            if (beans != null && !beans.isEmpty()) {
                return (LancamentoEstoqueBean)beans.toArray()[0];
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar lan\u00e7amento.", e.getStackTrace());
        }
        return null;
    }

    private boolean getAtingiuLimite() {
        return this.getRestanteLote() == 0.0;
    }

    private void addLote() {
        if (this.validar()) {
            MaterialLoteLancamentoInserir selecionado = null;
            MaterialLoteLanctoEstoqueBean materialLoteLanctoEstoqueBean = new MaterialLoteLanctoEstoqueBean();
            MaterialLoteBean novoLote = new MaterialLoteBean();
            if (this.editandoLinha > -1) {
                selecionado = (MaterialLoteLancamentoInserir)this.modeloLote.getValueAt(this.tableLote.getSelectedRow(), 6);
                this.tableLcto.setEnabled(true);
                this.tableLote.setEnabled(true);
            }
            FilialVO filialVO = new FilialVO();
            filialVO.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
            UsuarioVO usuarioVO = new UsuarioVO();
            usuarioVO.setCodigo(Variaveis.login);
            if (selecionado != null && selecionado.getMaterialLoteBean().getCodigo() != null && selecionado.getMaterialLoteBean().getCodigo() > 0) {
                novoLote = (MaterialLoteBean)selecionado.getMaterialLoteBean().clonar();
                novoLote.setInserir(false);
                materialLoteLanctoEstoqueBean.setInserir(false);
            } else {
                novoLote.setInserir(true);
                materialLoteLanctoEstoqueBean.setInserir(true);
                novoLote.setFilial(filialVO);
                novoLote.setDataHoraCriacao(new Date());
                novoLote.setUsuarioCriacao(usuarioVO);
                novoLote.setMaterial((MaterialVO)((MaterialBean)this.params.get("material")).toVO());
                novoLote.setRemovido(false);
                novoLote.setLoteEntrada(true);
            }
            novoLote.setDataLote(Funcoes.stringToDate("dd/MM/yyyy", this.textData.getText()));
            novoLote.setLote(this.textLote.getText());
            novoLote.setQuantidade(Double.valueOf(Funcoes.limpaDecimal(this.textQtdeLote.getText())));
            novoLote.setValidadeLote(Funcoes.stringToDate("dd/MM/yyyy", this.textValidade.getText()));
            novoLote.setObservacao(this.textObs.getText());
            if (!Funcoes.textoVazio(this.textQtdeLoteConsumida.getText())) {
                novoLote.setQuantidadeConsumida(Double.valueOf(Funcoes.limpaDecimal(this.textQtdeLoteConsumida.getText())));
            } else {
                novoLote.setQuantidadeConsumida(0.0);
            }
            materialLoteLanctoEstoqueBean.setFilial(filialVO);
            materialLoteLanctoEstoqueBean.setLancamento(this.getLanctoSelecionado());
            materialLoteLanctoEstoqueBean.setMaterialLote((MaterialLoteVO)novoLote.toVO());
            materialLoteLanctoEstoqueBean.setQuantidade(Double.valueOf(Funcoes.limpaDecimal(this.textQtdeLote.getText())));
            if (this.editandoLinha > -1) {
                this.modeloLote.setValueAt(novoLote.getLote(), this.editandoLinha, 0);
                this.modeloLote.setValueAt(this.textData.getText(), this.editandoLinha, 1);
                this.modeloLote.setValueAt(this.textValidade.getText(), this.editandoLinha, 2);
                this.modeloLote.setValueAt(Funcoes.formataDecimal(novoLote.getQuantidade()), this.editandoLinha, 3);
                this.modeloLote.setValueAt(materialLoteLanctoEstoqueBean.getLancamento().getCodigo(), this.editandoLinha, 4);
                this.modeloLote.setValueAt(Funcoes.formataDecimal(novoLote.getQuantidadeConsumida()), this.editandoLinha, 5);
                this.modeloLote.setValueAt(new MaterialLoteLancamentoInserir(novoLote, materialLoteLanctoEstoqueBean), this.editandoLinha, 6);
                this.modeloLote.setValueAt(true, this.editandoLinha, 7);
            } else {
                this.modeloLote.addLine(new Object[]{novoLote.getLote(), this.textData.getText(), this.textValidade.getText(), Funcoes.formataDecimal(novoLote.getQuantidade()), materialLoteLanctoEstoqueBean.getLancamento().getCodigo(), Funcoes.formataDecimal(novoLote.getQuantidadeConsumida()), new MaterialLoteLancamentoInserir(novoLote, materialLoteLanctoEstoqueBean), true});
            }
            Double diferenca = this.getLanctoSelecionado().getQuantidade() - this.getTotalLoteAtingiuLimiteQtdeLancto();
            if (!(diferenca < 0.0)) {
                ScreenUtil.requisitarFoco(this.textLote);
            }
            if (diferenca < 0.0) {
                ScreenUtil.requisitarFoco(this.textQtdeLote);
                this.tableLote.getSelectionModel().setSelectionInterval(this.editandoLinha, this.editandoLinha);
                this.editarLinhaLote();
                novoLote.setQuantidade(selecionado.getMaterialLoteBean().getQuantidade());
                this.modeloLote.setValueAt(this.textLote.getText(), this.editandoLinha, 0);
                this.modeloLote.setValueAt(this.textData.getText(), this.editandoLinha, 1);
                this.modeloLote.setValueAt(this.textValidade.getText(), this.editandoLinha, 2);
                this.modeloLote.setValueAt(Funcoes.formataDecimal(selecionado.getMaterialLoteBean().getQuantidade()), this.editandoLinha, 3);
                this.modeloLote.setValueAt(Funcoes.formataDecimal(selecionado.getMaterialLoteBean().getQuantidadeConsumida()), this.editandoLinha, 5);
                Funcoes.mensagem(Laboratorio.getInstancia(), "A Quantidade do lote \u00e9 superior a quantidade total do lan\u00e7amento selecionado.", 2);
                return;
            }
            if (this.editandoLinha > -1) {
                this.editandoLinha = -1;
            }
            this.dadoEditado = true;
            this.limpar();
            this.textQtdeLote.setText(Funcoes.formataDecimal(this.getLanctoSelecionado().getQuantidade() - this.getTotalLoteAtingiuLimiteQtdeLancto()));
            this.labelEntradaAtual.setText(this.getEntradaAtual());
            this.atualizarQtdeLanctoAssociar();
            this.modeloLote.ordenarColunaSemTrocarSentido(4);
            this.marcarLanctoAssociado();
            this.marcarLoteLanctoSelecionado();
            this.verificarStatus();
            this.textLote.setEnabled(true);
            this.textQtdeLote.setEnabled(true);
            this.textData.setEnabled(true);
            this.textValidade.setEnabled(true);
            this.buttonData.setEnabled(true);
            this.buttonValidade.setEnabled(true);
        }
    }

    private void verificarStatus() {
        try {
            if (this.getLanctoSelecionado() != null) {
                Double restante = this.getLanctoSelecionado().getQuantidade() - this.getTotalLoteAtingiuLimiteQtdeLancto();
                LancamentoEstoqueBean bean = (LancamentoEstoqueBean)this.modeloLcto.getValueAt(this.tableLcto.getSelectedRow(), 3);
                this.modeloLcto.setValueAt(this.getDescricaoLancamento(bean, restante), this.tableLcto.getSelectedRow(), 0);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
    }

    private void verificarStatusExcluir() {
        try {
            if (this.getLanctoSelecionado() != null) {
                Double restante = this.getLanctoSelecionado().getQuantidade() - this.getTotalLoteAtingiuLimiteQtdeLancto();
                LancamentoEstoqueBean bean = (LancamentoEstoqueBean)this.modeloLcto.getValueAt(this.tableLcto.getSelectedRow(), 3);
                this.modeloLcto.setValueAt(this.getDescricaoLancamentoExcluir(bean, restante), this.tableLcto.getSelectedRow(), 0);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
    }

    private void marcarLanctoAssociado() {
        this.renderer.limpar();
        block0: for (int i = 0; i < this.modeloLote.getRowCount(); ++i) {
            MaterialLoteLancamentoInserir novoLote = (MaterialLoteLancamentoInserir)this.modeloLote.getValueAt(i, 6);
            for (int x = 0; x < this.modeloLcto.getRowCount(); ++x) {
                LancamentoEstoqueBean lancamentoBean = (LancamentoEstoqueBean)this.modeloLcto.getValueAt(x, 3);
                if (!novoLote.getMaterialLoteLanctoEstoqueBean().getLancamento().getCodigo().equals(lancamentoBean.getCodigo())) continue;
                this.renderer.setCorLinha(Color.CYAN, x);
                continue block0;
            }
        }
        this.tableLcto.repaint();
    }

    private boolean getLoteAtingiuLimiteQtdeLancto() {
        try {
            LancamentoEstoqueVO lanctoEstVo = this.getLanctoSelecionado();
            Double totalLoteLancamento = 0.0;
            for (int i = 0; i < this.modeloLote.getRowCount(); ++i) {
                MaterialLoteLancamentoInserir lancamentoInserir = (MaterialLoteLancamentoInserir)this.modeloLote.getValueAt(i, 6);
                if (!lancamentoInserir.getMaterialLoteLanctoEstoqueBean().getLancamento().getCodigo().equals(lanctoEstVo.getCodigo())) continue;
                totalLoteLancamento = totalLoteLancamento + lancamentoInserir.getMaterialLoteBean().getQuantidade();
            }
            return lanctoEstVo.getQuantidade() == totalLoteLancamento - this.getQuantidadeAssociada(this.getCodigoMaterial(), lanctoEstVo.getCodigo().toString());
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
            return false;
        }
    }

    private Double getTotalLoteAtingiuLimiteQtdeLancto() {
        Double totalLoteLancamento = 0.0;
        LancamentoEstoqueVO lanctoEstVo = this.getLanctoSelecionado();
        try {
            for (int i = 0; i < this.modeloLote.getRowCount(); ++i) {
                MaterialLoteLancamentoInserir lancamentoInserir = (MaterialLoteLancamentoInserir)this.modeloLote.getValueAt(i, 6);
                if (lanctoEstVo == null || !lancamentoInserir.getMaterialLoteLanctoEstoqueBean().getLancamento().getCodigo().equals(lanctoEstVo.getCodigo())) continue;
                totalLoteLancamento = totalLoteLancamento + lancamentoInserir.getMaterialLoteBean().getQuantidade();
            }
            if (lanctoEstVo != null) {
                return totalLoteLancamento - this.getQuantidadeAssociada(this.getCodigoMaterial(), lanctoEstVo.getCodigo().toString());
            }
            totalLoteLancamento.doubleValue();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        return totalLoteLancamento;
    }

    private boolean getLanctoPossuiLoteAssociado() {
        Double totalLoteLancamento = 0.0;
        LancamentoEstoqueVO lanctoEstVo = this.getLanctoSelecionado();
        try {
            for (int i = 0; i < this.modeloLote.getRowCount(); ++i) {
                MaterialLoteLancamentoInserir lancamentoInserir = (MaterialLoteLancamentoInserir)this.modeloLote.getValueAt(i, 6);
                if (lanctoEstVo == null || !lancamentoInserir.getMaterialLoteLanctoEstoqueBean().getLancamento().getCodigo().equals(lanctoEstVo.getCodigo())) continue;
                return true;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        return false;
    }

    private String getCodigoMaterial() {
        return ((MaterialBean)this.params.get("material")).getCodigo().toString();
    }

    private String getEntradaAtual() {
        return "Entrada atual: " + Funcoes.formataDecimal(this.getTotalLotesLimiteLancamento()) + " (" + ((MaterialBean)this.params.get("material")).getUnidadeMedida().getCodigo() + ")";
    }

    private Double getRestanteLote() {
        Double totalRestante = this.saldoAtual - this.getTotalLotesLimite();
        return totalRestante;
    }

    private void limpar() {
        this.textLote.clear();
        this.textQtdeLote.clear();
        this.textQtdeLoteConsumida.clear();
        this.textData.clear();
        this.textValidade.clear();
        this.textObs.setText("");
    }

    private boolean validar() {
        if (this.tableLcto.getSelectedRow() < 0) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Selecione um lan\u00e7amento.", 2);
            if (this.tableLcto.getRowCount() > 0) {
                this.tableLcto.getSelectionModel().setSelectionInterval(0, 0);
            }
            return false;
        }
        if (Funcoes.textoVazio(this.textLote)) {
            ScreenUtil.requisitarFoco(this.textLote);
            return false;
        }
        if (Funcoes.textoVazio(this.textQtdeLote)) {
            ScreenUtil.requisitarFoco(this.textQtdeLote);
            return false;
        }
        try {
            if (Double.valueOf(Funcoes.limpaDecimal(this.textQtdeLote.getText())) <= 0.0) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "Quantidade inv\u00e1lida.", 2);
                ScreenUtil.requisitarFoco(this.textQtdeLote);
                return false;
            }
        }
        catch (NumberFormatException e) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Valor informado na quantidade \u00e9 inv\u00e1lido.", 2);
            ScreenUtil.requisitarFoco(this.textQtdeLote);
            return false;
        }
        if (Funcoes.textoVazio(this.textData)) {
            ScreenUtil.requisitarFoco(this.textData);
            return false;
        }
        if (Funcoes.textoVazio(this.textValidade)) {
            ScreenUtil.requisitarFoco(this.textValidade);
            return false;
        }
        if (!Funcoes.verificaData(this.textData.getText())) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Data inv\u00e1lida.", 2);
            ScreenUtil.requisitarFoco(this.textData);
            return false;
        }
        if (!Funcoes.verificaData(this.textValidade.getText())) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Validade inv\u00e1lida.", 2);
            ScreenUtil.requisitarFoco(this.textValidade);
            return false;
        }
        if (Funcoes.comparaData(this.textData.getText(), this.textValidade.getText()) > 0) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "A data de validade deve ser maior que a data do lote.", 2);
            ScreenUtil.requisitarFoco(this.textValidade);
            return false;
        }
        if (this.editandoLinha > -1) {
            try {
                Double associado = this.getQuantidadeAssociada(this.getCodigoMaterial(), this.getLanctoSelecionado().getCodigo().toString());
                if (associado > 0.0) {
                    MaterialLoteLancamentoInserir loteSelecionado = (MaterialLoteLancamentoInserir)this.modeloLote.getValueAt(this.editandoLinha, 6);
                    Double qtde = Double.valueOf(Funcoes.limpaDecimal(this.textQtdeLote.getText())) - loteSelecionado.getMaterialLoteLanctoEstoqueBean().getQuantidade();
                    Double faltaAssociar = this.getRestanteLancamento(this.getCodigoMaterial(), this.getLanctoSelecionado().getCodigo().toString());
                    Double total = faltaAssociar + associado;
                    Double totalLancto = this.getTotalLotesLimiteLancamento() - loteSelecionado.getMaterialLoteLanctoEstoqueBean().getQuantidade() + Double.valueOf(Funcoes.limpaDecimal(this.textQtdeLote.getText()));
                    if (qtde > faltaAssociar || totalLancto > total) {
                        Funcoes.mensagem(Laboratorio.getInstancia(), "A Quantidade do lote \u00e9 superior a quantidade total do lan\u00e7amento selecionado.", 2);
                        ScreenUtil.requisitarFoco(this.textQtdeLote);
                        return false;
                    }
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
            }
        }
        if (this.getLoteAtingiuLimiteQtdeLancto() && this.editandoLinha == -1) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Quantidade total dos lotes para o lan\u00e7amento j\u00e1 foi atingida.", 2);
            ScreenUtil.requisitarFoco(this.textQtdeLote);
            return false;
        }
        if (this.getTotalLoteAtingiuLimiteQtdeLancto() + Double.valueOf(Funcoes.limpaDecimal(this.textQtdeLote.getText())) > this.getLanctoSelecionado().getQuantidade() && this.editandoLinha == -1) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Quantidade do lote excede a quantidade do lan\u00e7amento.", 2);
            ScreenUtil.requisitarFoco(this.textQtdeLote);
            return false;
        }
        if (this.editandoLinha > -1) {
            MaterialLoteLancamentoInserir loteSelecionado = (MaterialLoteLancamentoInserir)this.modeloLote.getValueAt(this.editandoLinha, 6);
            LancamentoEstoqueVO lanctoEstVo = this.getLanctoSelecionado();
            Double totalLoteLancamento = 0.0;
            for (int i = 0; i < this.modeloLote.getRowCount(); ++i) {
                MaterialLoteLancamentoInserir lancamentoInserir = (MaterialLoteLancamentoInserir)this.modeloLote.getValueAt(i, 6);
                if (!lancamentoInserir.getMaterialLoteLanctoEstoqueBean().getLancamento().getCodigo().equals(lanctoEstVo.getCodigo())) continue;
                totalLoteLancamento = totalLoteLancamento + lancamentoInserir.getMaterialLoteBean().getQuantidade();
            }
            if (!loteSelecionado.getMaterialLoteBean().getAlterar() && lanctoEstVo.getQuantidade() < totalLoteLancamento - Double.valueOf(Funcoes.limpaDecimal(this.modeloLote.getValueAt(this.editandoLinha, 3).toString())) + Double.valueOf(Funcoes.limpaDecimal(this.textQtdeLote.getText())) - loteSelecionado.getMaterialLoteLanctoEstoqueBean().getQuantidade() - totalLoteLancamento) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "Quantidade do lote excede a quantidade do lan\u00e7amento.", 2);
                ScreenUtil.requisitarFoco(this.textQtdeLote);
                return false;
            }
            if (this.editandoLinha > -1 && !loteSelecionado.getMaterialLoteLanctoEstoqueBean().getLancamento().getCodigo().equals(this.getLanctoSelecionado().getCodigo())) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "O lan\u00e7amento associoado ao lote \u00e9 diferente do lan\u00e7amento que est\u00e1 selecionado. ", 2);
                return false;
            }
        }
        if (this.getQuantidadeAssociar() < 0.0) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Quantidade do lote excede a quantidade do lan\u00e7amento.", 2);
            ScreenUtil.requisitarFoco(this.textQtdeLote);
            return false;
        }
        if (!Funcoes.textoVazio(this.textQtdeLoteConsumida.getText())) {
            try {
                Double qtdeConsumida = Double.valueOf(Funcoes.limpaDecimal(this.textQtdeLoteConsumida.getText()));
                Double qtdeLote = Double.valueOf(Funcoes.limpaDecimal(this.textQtdeLote.getText()));
                if (qtdeConsumida > 0.0) {
                    if (qtdeConsumida > qtdeLote) {
                        Funcoes.mensagem(Laboratorio.getInstancia(), "Quantidade consumida deve ser menor ou igual a quantidade do lote.", 2);
                        ScreenUtil.requisitarFoco(this.textQtdeLoteConsumida);
                        return false;
                    }
                } else if (qtdeConsumida < 0.0) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "Quantidade consumida inv\u00e1lida.", 2);
                    ScreenUtil.requisitarFoco(this.textQtdeLoteConsumida);
                    return false;
                }
            }
            catch (NumberFormatException e) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "Quantidade consumida inv\u00e1lida.", 2);
                ScreenUtil.requisitarFoco(this.textQtdeLoteConsumida);
                return false;
            }
        }
        return true;
    }

    private LancamentoEstoqueVO getLanctoSelecionado() {
        int linha = this.tableLcto.getSelectedRow();
        if (linha >= 0) {
            LancamentoEstoqueBean bean = (LancamentoEstoqueBean)this.modeloLcto.getValueAt(linha, 3);
            return (LancamentoEstoqueVO)bean.toVO();
        }
        return null;
    }

    private Double getTotalLotes() {
        Double totalLotes = 0.0;
        for (int i = 0; i < this.modeloLote.getRowCount(); ++i) {
            MaterialLoteLancamentoInserir novoLote = (MaterialLoteLancamentoInserir)this.modeloLote.getValueAt(i, 6);
            if (novoLote == null) continue;
            totalLotes = totalLotes + novoLote.getMaterialLoteBean().getQuantidade();
        }
        return totalLotes - this.getTotalQuantidateAssociada();
    }

    private Double getTotalLotesModelo() {
        Double totalLotes = 0.0;
        for (int i = 0; i < this.modeloLote.getRowCount(); ++i) {
            MaterialLoteLancamentoInserir novoLote = (MaterialLoteLancamentoInserir)this.modeloLote.getValueAt(i, 6);
            if (novoLote == null) continue;
            totalLotes = totalLotes + novoLote.getMaterialLoteBean().getQuantidade();
        }
        return totalLotes;
    }

    private Double getTotalLotesLimite() {
        Double totalLotes = 0.0;
        for (int i = 0; i < this.modeloLote.getRowCount(); ++i) {
            MaterialLoteLancamentoInserir novoLote = (MaterialLoteLancamentoInserir)this.modeloLote.getValueAt(i, 6);
            if (novoLote == null) continue;
            totalLotes = totalLotes + novoLote.getMaterialLoteBean().getQuantidade();
        }
        return totalLotes;
    }

    private Double getTotalLotesLimiteLancamento() {
        Double totalLotes = 0.0;
        for (int i = 0; i < this.modeloLote.getRowCount(); ++i) {
            MaterialLoteLancamentoInserir novoLote = (MaterialLoteLancamentoInserir)this.modeloLote.getValueAt(i, 6);
            if (novoLote == null || this.getLanctoSelecionado() == null || !this.getLanctoSelecionado().getCodigo().equals(novoLote.getMaterialLoteLanctoEstoqueBean().getLancamento().getCodigo())) continue;
            totalLotes = totalLotes + novoLote.getMaterialLoteBean().getQuantidade();
        }
        return totalLotes;
    }

    private Double getTotalQuantidateAssociada() {
        Double totalLotes = 0.0;
        try {
            for (int i = 0; i < this.modeloLcto.getRowCount(); ++i) {
                LancamentoEstoqueBean lancamentoBean = (LancamentoEstoqueBean)this.modeloLcto.getValueAt(i, 3);
                if (lancamentoBean == null) continue;
                totalLotes = totalLotes + this.getQuantidadeAssociada(this.getCodigoMaterial(), lancamentoBean.getCodigo().toString());
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        return totalLotes;
    }

    private String getCodigoLoteDivergencia(String codigoMaterial) throws SQLException {
        String codigoLancamentos = "";
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT distinct(a.lce_codigo)   ");
        sql.append(" \t FROM lanctoestoque a  ");
        sql.append(" \t LEFT JOIN materiallote mll ON mll.fil_codigo = a.fil_codigo  ");
        sql.append(" \t  AND mll.mat_codigo = a.mat_codigo  ");
        sql.append(" \tWHERE a.fil_codigo = ").append(Variaveis.filialPadrao);
        sql.append(" \t  AND a.mat_codigo = ").append(codigoMaterial);
        sql.append("    AND a.lce_tipo = 'E' ");
        sql.append("    AND a.lce_datahoracancelamento is null ");
        sql.append(" order by a.lce_codigo desc ");
        ResultSet result = Conexao.executeQuery(Conexao.getStatement(), sql.toString());
        while (result.next()) {
            codigoLancamentos = codigoLancamentos + result.getString("lce_codigo") + ",";
        }
        if (!Funcoes.textoVazio(codigoLancamentos)) {
            return codigoLancamentos.substring(0, codigoLancamentos.length() - 1);
        }
        return null;
    }

    private double getRestanteLancamento(String codigoMaterial, String codigoLancamento) throws SQLException {
        String codigoLancamentos = "";
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT a.lce_codigo, ");
        sql.append(" a.lce_quantidade  - (SELECT sum(mll_quantidade)  ");
        sql.append("   FROM materiallotelanctoestoque  ");
        sql.append("  WHERE lce_codigo = a.lce_codigo  ");
        sql.append("   AND fil_codigo = a.fil_codigo) as restante ");
        sql.append(" \t FROM lanctoestoque a  ");
        sql.append(" \t LEFT JOIN materiallote mll ON mll.fil_codigo = a.fil_codigo  ");
        sql.append(" \t  AND mll.mat_codigo = a.mat_codigo  ");
        sql.append(" \t LEFT JOIN materiallotelanctoestoque mle ON mle.fil_codigo = mll.fil_codigo ");
        sql.append(" \t  AND mle.lce_codigo = a.lce_codigo  ");
        sql.append(" \t  AND mle.mll_codigo = mll.mll_codigo  ");
        sql.append(" \tWHERE a.fil_codigo = ");
        sql.append(Variaveis.filialPadrao);
        sql.append(" \t  AND a.lce_tipo = 'E' ");
        sql.append(" \t  AND a.lce_datahoracancelamento IS NULL ");
        sql.append(" \t  AND a.mat_codigo = ");
        sql.append(codigoMaterial);
        sql.append(" \t  AND a.lce_codigo = ");
        sql.append(codigoLancamento);
        sql.append("    AND a.lce_tipo = 'E' ");
        sql.append("    AND a.lce_datahoracancelamento is null ");
        sql.append(" \t  AND (a.lce_quantidade > ");
        sql.append(" \t      (SELECT sum(mll_quantidade) ");
        sql.append(" \t      FROM materiallotelanctoestoque ");
        sql.append(" \t      WHERE lce_codigo = a.lce_codigo ");
        sql.append(" \t        AND fil_codigo = a.fil_codigo) ");
        sql.append(" \t       \t\tOR a.lce_codigo NOT IN ");
        sql.append(" \t      (SELECT lce_codigo ");
        sql.append(" \t       \t FROM materiallotelanctoestoque ");
        sql.append(" \t        WHERE fil_codigo = a.fil_codigo ");
        sql.append(" \t          AND lce_codigo = a.lce_codigo) ) and mll.mll_removido = false  ");
        sql.append(" \tGROUP BY a.lce_codigo,restante ");
        ResultSet result = Conexao.executeQuery(Conexao.getStatement(), sql.toString());
        if (result.next()) {
            return result.getDouble("restante");
        }
        return 0.0;
    }

    private double getQuantidadeAssociada(String codigoMaterial, String codigoLancamento) throws SQLException {
        String codigoLancamentos = "";
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT a.lce_codigo, ");
        sql.append(" (SELECT sum(mll_quantidade)  ");
        sql.append("   FROM materiallotelanctoestoque  ");
        sql.append("  WHERE lce_codigo = a.lce_codigo  ");
        sql.append("   AND fil_codigo = a.fil_codigo) as restante ");
        sql.append(" \t FROM lanctoestoque a  ");
        sql.append(" \t LEFT JOIN materiallote mll ON mll.fil_codigo = a.fil_codigo  ");
        sql.append(" \t  AND mll.mat_codigo = a.mat_codigo  ");
        sql.append(" \t LEFT JOIN materiallotelanctoestoque mle ON mle.fil_codigo = mll.fil_codigo ");
        sql.append(" \t  AND mle.lce_codigo = a.lce_codigo  ");
        sql.append(" \t  AND mle.mll_codigo = mll.mll_codigo  ");
        sql.append(" \tWHERE a.fil_codigo = ");
        sql.append(Variaveis.filialPadrao);
        sql.append(" \t  AND a.lce_tipo = 'E' ");
        sql.append(" \t  AND a.lce_datahoracancelamento IS NULL ");
        sql.append(" \t  AND a.mat_codigo = ");
        sql.append(codigoMaterial);
        sql.append(" \t  AND a.lce_codigo = ");
        sql.append(codigoLancamento);
        sql.append("    AND a.lce_tipo = 'E' ");
        sql.append("    AND a.lce_datahoracancelamento is null ");
        sql.append(" \t  AND (a.lce_quantidade > ");
        sql.append(" \t      (SELECT sum(mll_quantidade) ");
        sql.append(" \t      FROM materiallotelanctoestoque ");
        sql.append(" \t      WHERE lce_codigo = a.lce_codigo ");
        sql.append(" \t        AND fil_codigo = a.fil_codigo) ");
        sql.append(" \t       \t\tOR a.lce_codigo NOT IN ");
        sql.append(" \t      (SELECT lce_codigo ");
        sql.append(" \t       \t FROM materiallotelanctoestoque ");
        sql.append(" \t        WHERE fil_codigo = a.fil_codigo ");
        sql.append(" \t          AND lce_codigo = a.lce_codigo) ) and mll.mll_removido = false  ");
        sql.append(" \tGROUP BY a.lce_codigo,restante ");
        ResultSet result = Conexao.executeQuery(Conexao.getStatement(), sql.toString());
        if (result.next()) {
            return result.getDouble("restante");
        }
        return 0.0;
    }

    private boolean getAssociacaoParcial(String codigoMaterial, String codigoLancamento) throws SQLException {
        String codigoLancamentos = "";
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT a.lce_codigo, ");
        sql.append(" a.lce_quantidade  - (SELECT sum(mll_quantidade)  ");
        sql.append("   FROM materiallotelanctoestoque  ");
        sql.append("  WHERE lce_codigo = a.lce_codigo  ");
        sql.append("   AND fil_codigo = a.fil_codigo) as restante ");
        sql.append(" \t FROM lanctoestoque a  ");
        sql.append(" \t INNER JOIN materiallote mll ON mll.fil_codigo = a.fil_codigo  ");
        sql.append(" \t  AND mll.mat_codigo = a.mat_codigo  ");
        sql.append(" \t INNER JOIN materiallotelanctoestoque mle ON mle.fil_codigo = mll.fil_codigo ");
        sql.append(" \t  AND mle.lce_codigo = a.lce_codigo  ");
        sql.append(" \t  AND mle.mll_codigo = mll.mll_codigo  ");
        sql.append(" \tWHERE a.fil_codigo = ");
        sql.append(Variaveis.filialPadrao);
        sql.append(" \t  AND a.lce_tipo = 'E' ");
        sql.append(" \t  AND a.lce_datahoracancelamento IS NULL ");
        sql.append(" \t  AND a.mat_codigo = ");
        sql.append(codigoMaterial);
        sql.append(" \t  AND a.lce_codigo = ");
        sql.append(codigoLancamento);
        sql.append("    AND a.lce_tipo = 'E' ");
        sql.append("    AND a.lce_datahoracancelamento is null ");
        sql.append(" \t  AND (a.lce_quantidade > ");
        sql.append(" \t      (SELECT sum(mll_quantidade) ");
        sql.append(" \t      FROM materiallotelanctoestoque ");
        sql.append(" \t      WHERE lce_codigo = a.lce_codigo ");
        sql.append(" \t        AND fil_codigo = a.fil_codigo) ");
        sql.append(" \t       \t\tOR a.lce_codigo NOT IN ");
        sql.append(" \t      (SELECT lce_codigo ");
        sql.append(" \t       \t FROM materiallotelanctoestoque ");
        sql.append(" \t        WHERE fil_codigo = a.fil_codigo ");
        sql.append(" \t          AND lce_codigo = a.lce_codigo) ) and mll.mll_removido = false  ");
        sql.append(" \tGROUP BY a.lce_codigo,restante ");
        ResultSet result = Conexao.executeQuery(Conexao.getStatement(), sql.toString());
        if (result.next()) {
            return result.getDouble("restante") > 0.0;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buscarLancamento(Map<Object, Object> params) {
        try {
            String lotes = this.getCodigoLoteDivergencia(((MaterialBean)params.get("material")).getCodigo().toString());
            if (!Funcoes.textoVazio(lotes)) {
                Conexao.setSessaoConexao(true);
                Set lancamentos = this.lancamentoEstoqueService.load(" where lce_codigo in ( " + this.getCodigoLoteDivergencia(((MaterialBean)params.get("material")).getCodigo().toString()) + ")  and lce_tipo = '" + "E" + "' order by lce_codigo desc ");
                if (lancamentos != null && !lancamentos.isEmpty()) {
                    for (Object object : lancamentos) {
                        LancamentoEstoqueBean lanctoEstBean = (LancamentoEstoqueBean)object;
                        Double restante = this.getRestanteLancamento(((MaterialBean)params.get("material")).getCodigo().toString(), lanctoEstBean.getCodigo().toString());
                        if (restante != null && restante > 0.0) {
                            lanctoEstBean.setQuantidade(restante);
                        }
                        if (this.modeloLcto.localizar(4, lanctoEstBean.getCodigo().toString()) != -1) continue;
                        this.modeloLcto.addLine(new Object[]{this.getDescricaoLancamento(lanctoEstBean, lanctoEstBean.getQuantidade()), Funcoes.formataData(lanctoEstBean.getDataHora()), Funcoes.formataDecimal(lanctoEstBean.getQuantidade()), lanctoEstBean, lanctoEstBean.getCodigo(), this.getQuantidadeAssociada(((MaterialBean)params.get("material")).getCodigo().toString(), lanctoEstBean.getCodigo().toString())});
                    }
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar lan\u00e7amentos.", e.getStackTrace());
        }
        finally {
            Conexao.setSessaoConexao(false);
        }
    }

    private String getDescricaoLancamento(LancamentoEstoqueBean lanctoEstBean, Double quantidadeRestante) throws Exception {
        StringBuilder descricao = new StringBuilder();
        descricao.append("<html>");
        descricao.append("\t<body>");
        descricao.append("\t\t<table style='font-size:8px'>");
        descricao.append("\t\t\t<tr>");
        descricao.append("\t\t\t\t<td height=10 style='width:80px'>");
        descricao.append("\t\t\t\t\t<b>").append("C\u00f3digo: ").append("</b>").append(lanctoEstBean.getCodigo());
        descricao.append("\t\t\t\t</td>");
        descricao.append("\t\t\t\t<td height=10  style='width:160px'>");
        descricao.append("\t\t\t\t\t<b>").append("Data: ");
        descricao.append("   \t\t\t  </b>").append(Funcoes.formataData("dd/MM/yyyy hh:mm", lanctoEstBean.getDataHora()));
        descricao.append("\t\t\t\t</td>");
        descricao.append("\t\t\t</tr>");
        descricao.append("\t\t\t<tr>");
        descricao.append("\t\t\t\t<td height=10>");
        descricao.append("\t \t  \t\t<b>").append("Tipo: ").append("</b>").append(this.getTipoLancamento(lanctoEstBean));
        descricao.append("\t  \t\t</td>");
        descricao.append("\t \t\t\t<td height=10>");
        descricao.append("\t  \t\t\t<b>").append("Usu\u00e1rio: ").append("</b>");
        descricao.append(lanctoEstBean.getUsuario().getCodigo());
        descricao.append("\t\t  \t</td>");
        descricao.append("\t\t\t</tr>");
        descricao.append("\t\t\t<tr>");
        descricao.append("    \t\t<td height=10>");
        descricao.append("\t  \t\t\t<b>").append("Qtde.: ").append("</b>").append(Funcoes.formataDecimal(this.lancamentoEstoqueService.get(lanctoEstBean.getFilial().getCodigo().toString(), lanctoEstBean.getCodigo().toString()).getQuantidade()));
        descricao.append("    \t\t</td>");
        descricao.append("    \t\t<td height='10' colspan='2'>");
        descricao.append("\t  \t\t\t<span><b>").append("Status: </b><span>");
        try {
            if (!this.getAssociacaoParcial(this.getCodigoMaterial(), lanctoEstBean.getCodigo().toString()) && this.getTotalLoteAtingiuLimiteQtdeLancto() == 0.0) {
                descricao.append("<span style='color:red'><b>").append("N\u00e3o associado").append("</b></span>");
            } else if (quantidadeRestante > 0.0) {
                descricao.append("<span style='color:red'><b>").append("Parcial. associado").append("</b></span>");
            } else {
                descricao.append("<span style='color:black'><b>").append("Associado").append("</b></span>");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "", e.getStackTrace());
        }
        descricao.append("    \t\t</td>");
        descricao.append("    \t</tr>");
        descricao.append("    \t<tr>");
        descricao.append("    \t\t<td colspan='2' height=10 >");
        descricao.append("<div style='overflow:none; width:200px; height:12px; font-size:8px'>");
        descricao.append("\t    \t\t<b>").append("C\u00e9lula: ").append("</b>").append(this.getDescricaoCelulaEstoque(lanctoEstBean));
        descricao.append("</div>");
        descricao.append("\t\t\t\t</td>");
        descricao.append("\t\t\t</tr>");
        descricao.append("\t\t</table>");
        descricao.append("  </body>");
        descricao.append("</html>");
        return descricao.toString().trim();
    }

    private String getDescricaoLancamentoExcluir(LancamentoEstoqueBean lanctoEstBean, Double quantidadeRestante) throws Exception {
        StringBuilder descricao = new StringBuilder();
        descricao.append("<html>");
        descricao.append("\t<body>");
        descricao.append("\t\t<table style='font-size:8px'>");
        descricao.append("\t\t\t<tr>");
        descricao.append("\t\t\t\t<td height=10 style='width:80px'>");
        descricao.append("\t\t\t\t\t<b>").append("C\u00f3digo: ").append("</b>").append(lanctoEstBean.getCodigo());
        descricao.append("\t\t\t\t</td>");
        descricao.append("\t\t\t\t<td height=10  style='width:160px'>");
        descricao.append("\t\t\t\t\t<b>").append("Data: ");
        descricao.append("   \t\t\t  </b>").append(Funcoes.formataData("dd/MM/yyyy hh:mm", lanctoEstBean.getDataHora()));
        descricao.append("\t\t\t\t</td>");
        descricao.append("\t\t\t</tr>");
        descricao.append("\t\t\t<tr>");
        descricao.append("\t\t\t\t<td height=10>");
        descricao.append("\t \t  \t\t<b>").append("Tipo: ").append("</b>").append(this.getTipoLancamento(lanctoEstBean));
        descricao.append("\t  \t\t</td>");
        descricao.append("\t \t\t\t<td height=10>");
        descricao.append("\t  \t\t\t<b>").append("Usu\u00e1rio: ").append("</b>");
        descricao.append(lanctoEstBean.getUsuario().getCodigo());
        descricao.append("\t\t  \t</td>");
        descricao.append("\t\t\t</tr>");
        descricao.append("\t\t\t<tr>");
        descricao.append("    \t\t<td height=10>");
        descricao.append("\t  \t\t\t<b>").append("Qtde.: ").append("</b>").append(Funcoes.formataDecimal(this.lancamentoEstoqueService.get(lanctoEstBean.getFilial().getCodigo().toString(), lanctoEstBean.getCodigo().toString()).getQuantidade()));
        descricao.append("    \t\t</td>");
        descricao.append("    \t\t<td height='10' colspan='2'>");
        descricao.append("\t  \t\t\t<span><b>").append("Status: </b><span>");
        try {
            if (!this.getAssociacaoParcial(this.getCodigoMaterial(), lanctoEstBean.getCodigo().toString()) && this.getTotalLoteAtingiuLimiteQtdeLancto() == 0.0 || !this.getLanctoPossuiLoteAssociado()) {
                descricao.append("<span style='color:red'><b>").append("N\u00e3o associado").append("</b></span>");
            } else if (quantidadeRestante > 0.0) {
                descricao.append("<span style='color:red'><b>").append("Parcial. associado").append("</b></span>");
            } else {
                descricao.append("<span style='color:black'><b>").append("Associado").append("</b></span>");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "", e.getStackTrace());
        }
        descricao.append("    \t\t</td>");
        descricao.append("    \t</tr>");
        descricao.append("    \t<tr>");
        descricao.append("    \t\t<td colspan='2' height=10 >");
        descricao.append("<div style='overflow:none; width:200px; height:12px; font-size:8px'>");
        descricao.append("\t    \t\t<b>").append("C\u00e9lula: ").append("</b>").append(this.getDescricaoCelulaEstoque(lanctoEstBean));
        descricao.append("</div>");
        descricao.append("\t\t\t\t</td>");
        descricao.append("\t\t\t</tr>");
        descricao.append("\t\t</table>");
        descricao.append("  </body>");
        descricao.append("</html>");
        return descricao.toString().trim();
    }

    private String getDescricaoCelulaEstoque(LancamentoEstoqueBean lanctoEstBean) {
        if (lanctoEstBean.getCelulaEstoque().getDescricao().length() > 35) {
            return lanctoEstBean.getCelulaEstoque().getDescricao().substring(0, 35).toLowerCase() + "...";
        }
        return lanctoEstBean.getCelulaEstoque().getDescricao();
    }

    private String getTipoLancamento(LancamentoEstoqueBean lanctoEstBean) {
        if (lanctoEstBean.getTipo().equalsIgnoreCase("E")) {
            return "Entrada";
        }
        return "Sa\u00edda";
    }

    private void atualizarQtdeLanctoAssociar() {
        Double associar = this.getQuantidadeAssociar();
        Double consumir = this.getQuantidadeAssociarOriginal();
        Double consumida = this.getQuantidadeConsumida();
        boolean isConsumidoDiferente = consumir.doubleValue() != consumida.doubleValue();
        this.labelDescricaoLancto.setText("<html>Qtde. a associar: " + Funcoes.formataDecimal(associar) + " (" + ((MaterialBean)this.params.get("material")).getUnidadeMedida().getCodigo() + ") | Qtde. a consumir: " + Funcoes.formataDecimal(consumir) + " | Qtde. consumida: " + (isConsumidoDiferente ? "<font color = 'red'>" : "") + Funcoes.formataDecimal(consumida) + "</font></html>");
    }

    private Double getQuantidadeConsumida() {
        Double qtde = 0.0;
        for (int i = 0; i < this.modeloLote.getRowCount(); ++i) {
            MaterialLoteLancamentoInserir materialLoteLancamentoInserir = (MaterialLoteLancamentoInserir)this.modeloLote.getValueAt(i, 6);
            qtde = qtde + materialLoteLancamentoInserir.getMaterialLoteBean().getQuantidadeConsumida();
        }
        return qtde;
    }

    private Double getQuantidadeAssociar() {
        Double qtde = 0.0;
        for (int i = 0; i < this.modeloLcto.getRowCount(); ++i) {
            LancamentoEstoqueBean lanctoEstBean = (LancamentoEstoqueBean)this.modeloLcto.getValueAt(i, 3);
            qtde = qtde + lanctoEstBean.getQuantidade();
        }
        return qtde - this.getTotalLotes();
    }

    private Double getQuantidadeLancanmeto() {
        Double qtde = 0.0;
        for (int i = 0; i < this.modeloLcto.getRowCount(); ++i) {
            LancamentoEstoqueBean lanctoEstBean = (LancamentoEstoqueBean)this.modeloLcto.getValueAt(i, 3);
            qtde = qtde + lanctoEstBean.getQuantidade();
        }
        return qtde;
    }

    private Double getQuantidadeAssociarOriginal() {
        try {
            Double qtde = 0.0;
            for (int i = 0; i < this.modeloLcto.getRowCount(); ++i) {
                LancamentoEstoqueBean lanctoEstBean = (LancamentoEstoqueBean)this.modeloLcto.getValueAt(i, 3);
                qtde = qtde + this.lancamentoEstoqueService.get(lanctoEstBean.getFilial().getCodigo().toString(), lanctoEstBean.getCodigo().toString()).getQuantidade();
            }
            return qtde - Double.parseDouble(this.params.get("saldoAtual").toString());
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            return 0.0;
        }
    }
}

