/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.digitacao.evento;

import jalis.laboratorio.configurador.ValoresReferencia;
import jalis.laboratorio.configurador.componente.Campo;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.awt.Color;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class MudaCorReferenciaListener
implements DocumentListener {
    private Campo dono;
    private JTextField textField;
    private ValoresReferencia valoresReferencia;

    public MudaCorReferenciaListener(Campo dono, JTextField textField, ValoresReferencia valoresReferencia) {
        this.dono = dono;
        this.textField = textField;
        this.valoresReferencia = valoresReferencia;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (this.contemNumero(this.textField.getText()).booleanValue()) {
            int valor = this.valoresReferencia.verificaValor(this.adicionarZeroAposVirgula(this.textField.getText()));
            this.textField.setForeground(this.getCorFonteValorReferencia(valor));
        } else {
            this.textField.setForeground(this.dono.getCorDaFonte());
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (this.contemNumero(this.textField.getText()).booleanValue()) {
            int valor = this.valoresReferencia.verificaValor(this.adicionarZeroAposVirgula(this.textField.getText()));
            this.textField.setForeground(this.getCorFonteValorReferencia(valor));
        } else {
            this.textField.setForeground(this.dono.getCorDaFonte());
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (this.contemNumero(this.textField.getText()).booleanValue()) {
            int valor = this.valoresReferencia.verificaValor(this.adicionarZeroAposVirgula(this.textField.getText()));
            this.textField.setForeground(this.getCorFonteValorReferencia(valor));
        } else {
            this.textField.setForeground(this.dono.getCorDaFonte());
        }
    }

    private Boolean contemNumero(String s) {
        boolean contemNumero = false;
        if (s != null && !s.isEmpty()) {
            char c;
            char[] cArray = s.toCharArray();
            int n = cArray.length;
            for (int i = 0; i < n && !(contemNumero = Character.isDigit(c = cArray[i])); ++i) {
            }
        }
        return contemNumero;
    }

    private Color getCorFonteValorReferencia(int vlr) {
        int rgb = this.dono.getCorDaFonte().getRGB();
        if (vlr > -1 && this.dono.getColorirReferencia() && !Funcoes.textoVazio(this.dono.getCoresValorReferencia())) {
            if (vlr == 1 || vlr == 3) {
                rgb = Integer.valueOf(StringUtil.getValor(this.dono.getCoresValorReferencia(), "Limitrofe").trim());
            }
            if (vlr == 2 || vlr == 4) {
                rgb = Integer.valueOf(StringUtil.getValor(this.dono.getCoresValorReferencia(), "Absurdo").trim());
            }
            if (vlr == 0) {
                rgb = Integer.valueOf(StringUtil.getValor(this.dono.getCoresValorReferencia(), "Normal").trim());
            }
            this.dono.setCorDaFonte(new Color(rgb));
        }
        return new Color(rgb);
    }

    private String adicionarZeroAposVirgula(String valorDigitado) {
        String str = valorDigitado.replace(" ", "");
        if (str.charAt(str.length() - 1) == ',') {
            str = str.concat("0");
        }
        return str;
    }
}

