/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.digitacao.componente;

import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.configurador.componente.ComponenteInterfaceamento;
import jalis.laboratorio.digitacao.Execucao;
import jalis.laboratorio.digitacao.TabelaSimbolos;
import jalis.laboratorio.digitacao.componente.ComponenteResultado;
import jalis.laboratorio.digitacao.componente.DocumentoWrap;
import jalis.laboratorio.digitacao.evento.CampoEvento;
import jalis.laboratorio.digitacao.evento.CampoListener;
import jalis.laboratorio.digitacao.evento.CampoRedimensionadoListener;
import jalis.laboratorio.digitacao.evento.MensagemListener;
import jalis.laboratorio.impressao.componente.ComponenteImpressao;
import jalis.laboratorio.util.parsers.ProtocoloCampoImportacao;
import jalis.util.Funcoes;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.AffineTransform;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Utilities;
import javax.swing.text.View;

public class TextoDigitacao
extends JTextPane
implements ComponenteResultado,
ComponenteImpressao,
ComponenteInterfaceamento,
CampoListener {
    private Componente dono;
    private boolean imprimir;
    private boolean resultadoAnterior;
    private boolean removerVazio;
    private List<String> ligacoes = new ArrayList<String>();
    private CampoEvento evento;
    private String valorPadrao = "";
    private String expressao = "";
    private TabelaSimbolos tabela;
    private List<Component> componentesFoco = new ArrayList<Component>();
    private String campoInterfaceamento = "";
    private boolean redimensionar = false;
    private Dimension tamanhoMaximo = null;
    private boolean novoEditor = true;
    private String simularAumentoDeFonte;
    private TitledBorder border = new TitledBorder("bor");

    public TextoDigitacao() {
        this.setLayout(null);
        this.setBorder(BorderFactory.createTitledBorder(""));
        this.setDocument(new DocumentoWrap(this));
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() == '\t') {
                    e.consume();
                    TextoDigitacao.this.transferFocus();
                }
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!e.isTemporary() && TextoDigitacao.this.verificarFoco(e.getOppositeComponent())) {
                    TextoDigitacao.this.fireDigitouValor();
                }
            }
        });
        this.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                if (TextoDigitacao.this.getRedimensionar()) {
                    Dimension novoTamanho = TextoDigitacao.this.getPreferredSize();
                    Rectangle recTemp = TextoDigitacao.this.getDimensoes();
                    if (novoTamanho.height > recTemp.height && novoTamanho.height <= ((TextoDigitacao)TextoDigitacao.this).tamanhoMaximo.height) {
                        TextoDigitacao.this.setDimensoes(recTemp.x, recTemp.y, recTemp.width, novoTamanho.height);
                        TextoDigitacao.this.fireComponenteRedimensionado(new Dimension(recTemp.width, recTemp.height), new Dimension(novoTamanho.width, novoTamanho.height));
                    }
                }
            }
        });
    }

    @Override
    public Dimension getPreferredSize() {
        int margem = this.getMargin().top + this.getMargin().bottom;
        Dimension dimension = super.getPreferredSize();
        Rectangle rec = this.getDimensoes();
        if (this.getText().trim().length() == 0) {
            return dimension;
        }
        int qtdeLinhas = this.contaLinhas();
        int alturaPorLinha = dimension.height / (qtdeLinhas == 0 ? 1 : qtdeLinhas);
        int alturaCalculada = alturaPorLinha * qtdeLinhas;
        if (this.isArial(this.getFont().getFamily()) && !Funcoes.textoVazio((String)this.getValor())) {
            alturaCalculada += 3;
        }
        dimension = new Dimension(dimension.width, alturaCalculada + margem);
        return dimension;
    }

    private int contaLinhas() {
        int qtde = 0;
        View view = this.getUI().getRootView(this).getView(0);
        for (int i = 0; i < view.getViewCount(); ++i) {
            View aux2;
            View aux = view.getView(i);
            for (int j = 0; j < aux.getViewCount() && (aux2 = aux.getView(j)) != null; ++j) {
                qtde += aux2.getViewCount();
            }
        }
        return qtde;
    }

    @Override
    public boolean digitavel() {
        return this.isEditable();
    }

    @Override
    public void setDono(Componente dono) {
        this.dono = dono;
    }

    @Override
    public Componente getDono() {
        return this.dono;
    }

    @Override
    public String getNome() {
        return this.getName();
    }

    public void setNovoEditor(boolean novoEditor) {
        this.novoEditor = novoEditor;
        if (!novoEditor) {
            this.setDocument(new DefaultStyledDocument());
        }
    }

    @Override
    public boolean vazio() {
        return this.getStringValor().trim().length() == 0;
    }

    @Override
    public boolean removerVazio() {
        return this.removerVazio;
    }

    public String isSimularAumentoDeFonte() {
        return this.simularAumentoDeFonte;
    }

    public void setSimularAumentoDeFonte(String simularAumentoDeFonte) {
        this.simularAumentoDeFonte = simularAumentoDeFonte;
    }

    @Override
    public boolean salvarParcialmente() {
        return true;
    }

    @Override
    public void setRemoverVazio(boolean valor) {
        this.removerVazio = valor;
    }

    @Override
    public Object getValor() {
        return this.vazio() ? null : this.getText();
    }

    @Override
    public void setValor(Object valor) {
        if (valor != null) {
            if (this.isEditable()) {
                this.setEditable(false);
            }
            this.setText(valor.toString());
        }
    }

    public void setValorPadrao(String valor) {
        if (valor != null) {
            this.valorPadrao = valor;
        }
    }

    public void setExpressao(String expressao) {
        if (!Funcoes.textoVazio(expressao)) {
            ((DefaultCaret)super.getCaret()).setUpdatePolicy(1);
            this.expressao = expressao;
        }
    }

    public String getExpressao() {
        return this.expressao;
    }

    public void setRedimensionar(boolean redimensionar) {
        this.redimensionar = redimensionar;
    }

    public boolean getRedimensionar() {
        return this.redimensionar;
    }

    public void setTabelaSimbolos(TabelaSimbolos tabela) {
        this.tabela = tabela;
    }

    @Override
    public void limpar() {
        if (this.isEditable()) {
            this.setText("");
        }
    }

    @Override
    public void carregarValorPadrao() {
        if (this.isEditable()) {
            this.setText(this.valorPadrao);
        }
    }

    @Override
    public boolean imprimir() {
        return this.imprimir;
    }

    public void setImprimir(boolean imprimir) {
        this.imprimir = imprimir;
    }

    @Override
    public void setProcessarPerdaDeFoco(boolean flag) {
    }

    @Override
    public List<String> getLigacoes() {
        return this.ligacoes;
    }

    public void setLigacoes(List<String> lig) {
        this.ligacoes.clear();
        this.ligacoes.addAll(lig);
    }

    @Override
    public boolean resultadoAnterior() {
        return this.resultadoAnterior;
    }

    public void setResultadoAnterior(boolean resultadoAnterior) {
        this.resultadoAnterior = resultadoAnterior;
    }

    @Override
    public void addCampoListener(CampoListener l) {
        this.listenerList.add(CampoListener.class, l);
    }

    public void addCampoRedimensionadoListener(CampoRedimensionadoListener l) {
        this.listenerList.add(CampoRedimensionadoListener.class, l);
    }

    @Override
    public void removeCampoListener(CampoListener l) {
        this.listenerList.remove(CampoListener.class, l);
    }

    @Override
    public void setDimensoes(Rectangle dim) {
        if (this.dono != null) {
            this.dono.setDimensoes(dim);
        }
        this.setBounds(dim);
    }

    @Override
    public void setDimensoes(int esquerda, int topo, int largura, int altura) {
        this.setDimensoes(new Rectangle(esquerda, topo, largura, altura));
    }

    @Override
    public Rectangle getDimensoes() {
        if (this.dono != null) {
            return this.dono.getDimensoes();
        }
        return new Rectangle();
    }

    @Override
    public Point getPosicao() {
        return this.getDimensoes().getLocation();
    }

    @Override
    public String getStringValor() {
        String texto = this.getText();
        while (texto.endsWith("\n")) {
            texto = texto.substring(0, texto.length() - 1);
        }
        return texto;
    }

    @Override
    public int getAlinhamentoHorizontal() {
        return 0;
    }

    @Override
    public void setAlinhamentoHorizontal(int alinhamento) {
    }

    @Override
    public void setComponentesFoco(List<Component> list) {
        if (list != null) {
            this.componentesFoco.clear();
            this.componentesFoco.addAll(list);
        }
    }

    @Override
    public void paint(Graphics g) {
        if (!this.isOpaque() && this.isEditable()) {
            g.setColor(Color.white);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        super.paint(g);
    }

    @Override
    public void pintar(Graphics g) {
        boolean isJustificado = false;
        if (!Funcoes.objectIsNull(this.getParagraphAttributes()) && !Funcoes.objectIsNull(this.getParagraphAttributes().copyAttributes())) {
            isJustificado = this.getParagraphAttributes().copyAttributes().toString().contains("Alignment=3");
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setFont(this.getFont());
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        g.setColor(this.getForeground());
        if (isJustificado) {
            this.justificarTexto(g2);
        } else {
            this.alinharTextoNaoJustificado(g2);
        }
    }

    private void alinharTextoNaoJustificado(Graphics2D graphics) {
        graphics.setClip(0, 0, this.getWidth(), this.getHeight());
        ArrayList<String> linhas = this.getWrappedLines();
        int alturaLinha = 0;
        float escalaDaLarguraDeImpressao = this.calcularEscalaDaLarguraDeImpressao(linhas, graphics);
        for (String linha : linhas) {
            this.alinharLinhas(graphics, linha, alturaLinha += this.getFontMetrics(this.getFont()).getHeight(), escalaDaLarguraDeImpressao);
        }
    }

    private void alinharLinhas(Graphics2D graphics, String linha, int y, float escalaDaLarguraDeImpressao) {
        AffineTransform originTransform = graphics.getTransform();
        if (escalaDaLarguraDeImpressao < 1.0f) {
            graphics.scale(escalaDaLarguraDeImpressao, escalaDaLarguraDeImpressao);
        }
        if (this.getParagraphAttributes().copyAttributes().toString().contains("Alignment=2")) {
            float tamanhoLinha = (float)graphics.getFontMetrics().getStringBounds(linha, graphics).getWidth();
            if (escalaDaLarguraDeImpressao < 1.0f) {
                float dif = 1.0f - escalaDaLarguraDeImpressao;
                float somar = (float)(this.getBounds().getWidth() * (double)dif);
                tamanhoLinha = (float)(this.getBounds().getWidth() + (double)somar);
            }
            float x = tamanhoLinha;
            graphics.drawString(linha, (float)this.getWidth() - x, (float)y);
        } else {
            graphics.drawString(linha, 0, y);
        }
        graphics.setTransform(originTransform);
    }

    private ArrayList<String> getWrappedLines() {
        ArrayList<String> linhas;
        block4: {
            linhas = new ArrayList<String>();
            try {
                if (this.getText().length() == 0) break block4;
                int startOfRow = Utilities.getRowStart(this, 0);
                int endOfRow = Utilities.getRowEnd(this, 0);
                while (endOfRow != -1) {
                    String rowText = this.getText(startOfRow, endOfRow - startOfRow);
                    linhas.add(rowText);
                    if (endOfRow < this.getText().length()) {
                        startOfRow = Utilities.getRowStart(this, endOfRow + 1);
                        endOfRow = Utilities.getRowEnd(this, endOfRow + 1);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return linhas;
    }

    private void justificarTexto(Graphics2D g2) {
        float tamanhoImpressao = (float)this.getBounds().getWidth();
        int alturaFonte = g2.getFontMetrics().getAscent() + g2.getFontMetrics().getDescent();
        ArrayList<String> linhas = this.getWrappedLines();
        float escalaDaLarguraDeImpressao = this.calcularEscalaDaLarguraDeImpressao(linhas, g2);
        int linhaAltura = 0;
        for (int i = 0; i < linhas.size(); ++i) {
            this.drawString(g2, linhas.get(i), i == linhas.size() - 1, linhaAltura += alturaFonte, escalaDaLarguraDeImpressao);
        }
    }

    private float calcularEscalaDaLarguraDeImpressao(List<String> linhas, Graphics2D g2) {
        float tamanhoImpressao = (float)this.getBounds().getWidth();
        boolean reduzEscala = false;
        float maiorLinha = 0.0f;
        FontMetrics fontMetrics = g2.getFontMetrics();
        for (String linha : linhas) {
            float tamanhoLinha = (float)fontMetrics.getStringBounds(linha, g2).getWidth();
            float f = maiorLinha = tamanhoLinha > maiorLinha ? tamanhoLinha : maiorLinha;
            if (!(tamanhoLinha >= tamanhoImpressao)) continue;
            reduzEscala = true;
        }
        BigDecimal calculoEscala = BigDecimal.ZERO;
        if (maiorLinha > 0.0f) {
            calculoEscala = BigDecimal.valueOf(tamanhoImpressao).divide(BigDecimal.valueOf(maiorLinha), 4, RoundingMode.HALF_DOWN);
        }
        return reduzEscala ? calculoEscala.floatValue() : 1.0f;
    }

    public void drawString(Graphics2D g2, String linha, boolean ultimaLinha, int y, float escalaDaLarguraDeImpressao) {
        AffineTransform originTransform = g2.getTransform();
        if (escalaDaLarguraDeImpressao < 1.0f) {
            g2.scale(escalaDaLarguraDeImpressao, escalaDaLarguraDeImpressao);
        }
        FontMetrics fontMetrics = g2.getFontMetrics();
        String[] termos = linha.split(" ");
        int quantTermos = termos.length;
        float tamanhoImpressao = (float)this.getBounds().getWidth();
        float medidaLinha = (float)fontMetrics.getStringBounds(linha, g2).getWidth();
        float diminuirEsp = 0.0f;
        float diminuirProp = 0.0f;
        if (escalaDaLarguraDeImpressao < 1.0f) {
            float dif = 1.0f - escalaDaLarguraDeImpressao;
            float somar = (float)(this.getBounds().getWidth() * (double)dif);
            tamanhoImpressao = (float)(this.getBounds().getWidth() + (double)somar);
        }
        if (medidaLinha > tamanhoImpressao) {
            diminuirEsp = medidaLinha - tamanhoImpressao;
            diminuirProp = diminuirEsp / (float)(quantTermos - 2);
        }
        if ((double)medidaLinha <= (double)tamanhoImpressao * 0.7 || this.temQuebraDeLInha(linha) || ultimaLinha && diminuirEsp == 0.0f) {
            g2.drawString(linha, 0, y);
        } else {
            float diferenca = this.getDiferenca(medidaLinha, escalaDaLarguraDeImpressao);
            float preencher = diferenca / (float)(quantTermos - 1);
            float x = 0.0f;
            int contTermos = 1;
            for (String termo : termos) {
                g2.drawString(termo, x, (float)y);
                float medidaEspaco = (float)fontMetrics.getStringBounds(" ", g2).getWidth();
                float medidaTermo = (float)fontMetrics.getStringBounds(termo, g2).getWidth();
                if (diferenca > 0.0f && diferenca > medidaEspaco) {
                    float espacamento = diferenca > preencher ? preencher : diferenca;
                    x = x + medidaTermo + medidaEspaco + espacamento;
                    diferenca -= espacamento;
                } else if (diminuirEsp > 0.0f && (double)(diminuirProp / diminuirEsp) < 0.1) {
                    float d = diminuirEsp > diminuirProp ? diminuirProp : diminuirEsp;
                    diminuirEsp -= d;
                    x = x + medidaTermo + medidaEspaco;
                } else if (contTermos == quantTermos - 1) {
                    float medidaProximoTermo = x + (float)fontMetrics.getStringBounds(termos[contTermos], g2).getWidth();
                    float espacoFinal = tamanhoImpressao - medidaProximoTermo;
                    x += espacoFinal;
                } else {
                    if (diminuirEsp > 0.0f) {
                        medidaEspaco = (float)((double)(medidaEspaco - diminuirEsp) < (double)medidaEspaco * 0.7 ? (double)medidaEspaco * 0.7 : (double)(medidaEspaco - diminuirEsp));
                        diminuirEsp = 0.0f;
                    }
                    x = x + medidaTermo + medidaEspaco;
                }
                ++contTermos;
            }
        }
        g2.setTransform(originTransform);
    }

    private float getDiferenca(float tamanhoLinha, float escalaDaLarguraDeImpressao) {
        float tamanhoImpressao = (float)this.getBounds().getWidth();
        if (escalaDaLarguraDeImpressao < 1.0f) {
            float dif = 1.0f - escalaDaLarguraDeImpressao;
            float somar = (float)(this.getBounds().getWidth() * (double)dif);
            tamanhoImpressao = (float)(this.getBounds().getWidth() + (double)somar);
        }
        float diferenca = tamanhoImpressao - tamanhoLinha > 0.0f ? tamanhoImpressao - tamanhoLinha : 0.0f;
        return diferenca;
    }

    private boolean temQuebraDeLInha(String linha) {
        String str = "";
        if (this.getText().length() != 0 && this.getText().contains(linha)) {
            int inicio = this.getText().indexOf(linha);
            int fim = this.getText().indexOf(linha) + linha.length() + 2;
            fim = this.getText().length() < fim ? this.getText().length() : fim;
            str = this.getText().substring(inicio, fim);
        }
        return str.contains(System.lineSeparator()) || str.contains("\n") || str.contains("\r");
    }

    public static boolean isFonteMonoespacada(Font fonte) {
        boolean retorno = fonte.getFamily().equals("Andale Mono") || fonte.getFamily().equals("Cascadia Code") || fonte.getFamily().equals("Consolas") || fonte.getFamily().equals("Courier") || fonte.getFamily().equals("Courier New") || fonte.getFamily().equals("DejaVu Sans Mono") || fonte.getFamily().equals("Droid Sans Mono") || fonte.getFamily().equals("FreeMono") || fonte.getFamily().equals("Liberation Mono") || fonte.getFamily().equals("Lucida Console") || fonte.getFamily().equals("Lucida Sans Typewriter") || fonte.getFamily().equals("Nimbus Mono PS") || fonte.getFamily().equals("OCR A Extended") || fonte.getFamily().equals("OCRB") || fonte.getFamily().equals("Segoe UI") || fonte.getFamily().equals("SimHei") || fonte.getFamily().equals("SimSun") || fonte.getFamily().equals("Source Code Pro");
        return retorno;
    }

    public String getWrappedText() {
        String returnText;
        block5: {
            returnText = "";
            try {
                if (this.getText().length() == 0) break block5;
                int startOfRow = Utilities.getRowStart(this, 0);
                int endOfRow = Utilities.getRowEnd(this, 0);
                while (endOfRow != -1) {
                    String rowText = this.getText(startOfRow, endOfRow - startOfRow);
                    if (!rowText.endsWith("\n")) {
                        rowText = rowText + "\n";
                    }
                    returnText = returnText + rowText;
                    if (endOfRow < this.getText().length()) {
                        startOfRow = Utilities.getRowStart(this, endOfRow + 1);
                        endOfRow = Utilities.getRowEnd(this, endOfRow + 1);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return returnText;
    }

    private boolean isFonteGrandeSemNegrito(Font fonte) {
        return fonte.getStyle() != 1 || fonte.getSize() > 12;
    }

    private boolean isArial(String family) {
        return family.equals("Arial");
    }

    @Override
    public void setCampoInterfaceamento(String campo) {
        if (campo != null) {
            this.campoInterfaceamento = campo;
        }
    }

    @Override
    public String getCampoInterfaceamento() {
        return this.campoInterfaceamento.trim().length() == 0 ? this.getNome() : this.campoInterfaceamento;
    }

    @Override
    public String getCampoDeImportacao() {
        return this.dono != null ? this.dono.getCampoImportacao().campoImportacao : "";
    }

    @Override
    public boolean isRelacionavelComCampoDeImportacao() {
        return this.dono != null ? this.dono.isRelacionavelComCampoDeImportacao() : false;
    }

    protected void fireDigitouValor() {
        Object[] ouvintes = this.listenerList.getListenerList();
        for (int i = ouvintes.length - 2; i >= 0; i -= 2) {
            if (ouvintes[i] != CampoListener.class) continue;
            if (this.evento == null) {
                this.evento = new CampoEvento(this);
            }
            ((CampoListener)ouvintes[i + 1]).digitouValor(this.evento);
        }
    }

    protected void fireComponenteRedimensionado(Dimension dimensaoAnterior, Dimension novaDimensao) {
        Object[] ouvintes = this.listenerList.getListenerList();
        for (int i = ouvintes.length - 2; i >= 0; i -= 2) {
            if (ouvintes[i] != CampoRedimensionadoListener.class) continue;
            ((CampoRedimensionadoListener)ouvintes[i + 1]).componenteRedimensionado(this, dimensaoAnterior, novaDimensao);
        }
    }

    private boolean verificarFoco(Component foco) {
        for (Component c : this.componentesFoco) {
            if (c != foco) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addMensagemListener(MensagemListener l) {
    }

    @Override
    public void removeMensagemListener(MensagemListener l) {
    }

    @Override
    public void digitouValor(CampoEvento e) {
        this.executar();
    }

    public void executar() {
        if (this.tabela != null) {
            Execucao exe = new Execucao(this.getExpressao(), this.tabela, 0);
            Object res = exe.resultadoExpressao();
            if (res == null) {
                this.setText("");
            } else {
                this.setText(res.toString());
            }
            this.fireDigitouValor();
        }
    }

    @Override
    public String getValorOriginal() {
        return this.getStringValor();
    }

    public Dimension getTamanhoMaximo() {
        return this.tamanhoMaximo;
    }

    public void setTamanhoMaximo(Dimension dim) {
        if (dim != null) {
            this.tamanhoMaximo = dim;
        }
    }

    public void mostraInfo(String s) {
        this.border.setTitle(s);
    }

    @Override
    public Map<String, ProtocoloCampoImportacao> getMapCampoDeImportacao() {
        if (this.dono != null) {
            return this.dono.getMapCamposImportacao();
        }
        return null;
    }
}

