/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.digitacao.componente;

import jalis.laboratorio.configurador.componente.Imagem;
import jalis.laboratorio.configurador.componente.Rotulo;
import jalis.laboratorio.digitacao.componente.RtfAtributo;
import jalis.laboratorio.digitacao.componente.RtfImagemAtributo;
import jalis.util.Funcoes;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JTextPane;

public class RtfParaComponenteJalis {
    private int xRtf;
    private int yRtf;
    private int alturaRtf;
    private int larguraRtf;
    private boolean redimensionar = false;
    private Map<Integer, RtfImagemAtributo> imagens;
    private int y = 10;
    private int ultimaAltura = 0;
    private int numeroParagrafo = 0;
    private int numeroComponente = 0;
    private boolean continuarProcesso = true;
    private List<RtfAtributo> atributos;
    private List<Component> componentsRtf = new ArrayList<Component>();

    protected void rtfParaRotulo() {
        int c = 0;
        int yTemp = 0;
        boolean linhaEmBranco = this.linhaApenasComEspaco(this.atributos);
        for (RtfAtributo atributo : this.atributos) {
            if (atributo.getConteudo() != null && (atributo.getConteudo().equals("\r\n") || atributo.getConteudo().equals("\n")) || linhaEmBranco) {
                this.y = this.calcularAlturaDeLinhaEmBranco(atributo, this.ultimaAltura, this.y);
                if (linhaEmBranco) {
                    break;
                }
            } else if (atributo.getAtributos() != null && !Funcoes.textoVazio(atributo.getConteudo())) {
                if (c == 0) {
                    yTemp = this.definirPosicaoY(this.atributos);
                }
                if (!this.addComponentePagina(this.y)) {
                    return;
                }
                this.componentsRtf.add(this.montaRotulo(this.y, this.ultimaAltura, atributo));
                ++this.numeroComponente;
            }
            if (Funcoes.textoVazio(atributo.getConteudo())) continue;
            ++c;
        }
        if (!linhaEmBranco) {
            this.y += yTemp;
            this.ultimaAltura = yTemp;
        }
    }

    private Rotulo montaRotulo(int y, int ultimaAltura, RtfAtributo atributo) {
        Rectangle alturaComponente = new Rectangle(atributo.getInicio() + this.xRtf, y, new JTextPane().getFontMetrics(atributo.getFonte()).stringWidth(atributo.getConteudo()), ultimaAltura);
        Rotulo rotulo = new Rotulo();
        rotulo.setTexto(this.adiconarTag(atributo));
        if (this.numeroComponente != 0) {
            rotulo.setNome("." + this.numeroComponente);
        }
        rotulo.setFonte(atributo.getFonte());
        rotulo.setBounds(alturaComponente);
        rotulo.setAltura(ultimaAltura);
        rotulo.setDimensoes(alturaComponente);
        rotulo.setCorDaFonte(this.getCorDaFonte(atributo.getAtributos()));
        return rotulo;
    }

    private String adiconarTag(RtfAtributo atributo) {
        StringBuilder conteudo = new StringBuilder();
        String caracterInvalido = "";
        if (atributo.getConteudo().trim().length() == 1) {
            char ct = atributo.getConteudo().charAt(0);
            String a = String.format("%d", ct);
            if (a.equals("8805")) {
                caracterInvalido = "&ge;";
            } else if (a.equals("8804")) {
                caracterInvalido = "&le;";
            } else if (a.equals("8230")) {
                caracterInvalido = "&hellip;";
            }
        }
        if (this.isSublinhado(atributo.getAtributos()) || !Funcoes.textoVazio(caracterInvalido)) {
            conteudo.append("<html>");
            if (this.isSublinhado(atributo.getAtributos())) {
                conteudo.append("<u>");
            }
        }
        conteudo.append(!Funcoes.textoVazio(caracterInvalido) ? caracterInvalido : atributo.getConteudo());
        if (this.isSublinhado(atributo.getAtributos()) || !Funcoes.textoVazio(caracterInvalido)) {
            if (this.isSublinhado(atributo.getAtributos())) {
                conteudo.append("</u>");
            }
            conteudo.append("</html>");
        }
        return conteudo.toString();
    }

    private Color getCorDaFonte(AttributedString atributos) {
        AttributedCharacterIterator iterator = atributos.getIterator();
        for (int i = iterator.getBeginIndex(); i < iterator.getEndIndex(); ++i) {
            Map<AttributedCharacterIterator.Attribute, Object> attributes = iterator.getAttributes();
            if (attributes.containsKey(TextAttribute.FOREGROUND)) {
                return (Color)attributes.get(TextAttribute.FOREGROUND);
            }
            iterator.next();
        }
        return Color.BLACK;
    }

    private boolean isSublinhado(AttributedString atributos) {
        if (atributos != null) {
            AttributedCharacterIterator iterator = atributos.getIterator();
            for (int i = iterator.getBeginIndex(); i < iterator.getEndIndex(); ++i) {
                Map<AttributedCharacterIterator.Attribute, Object> attributes = iterator.getAttributes();
                if (attributes.containsKey(TextAttribute.UNDERLINE)) {
                    return attributes.get(TextAttribute.UNDERLINE).equals(TextAttribute.UNDERLINE_ON);
                }
                iterator.next();
            }
        }
        return false;
    }

    private boolean linhaApenasComEspaco(List<RtfAtributo> atributos) {
        for (RtfAtributo atributo : atributos) {
            String[] atr;
            if (atributo.getConteudo() == null) continue;
            for (String a : atr = atributo.getConteudo().split("")) {
                if (a.equals(" ")) continue;
                return false;
            }
        }
        return true;
    }

    private int calcularAlturaDeLinhaEmBranco(RtfAtributo atributo, int ultimaAltura, int y) {
        if (atributo.getFonte() != null) {
            FontMetrics fm = new JTextPane().getFontMetrics(atributo.getFonte());
            y += fm.getAscent() + fm.getDescent() - 4;
        } else {
            y += ultimaAltura;
        }
        return y;
    }

    private int definirPosicaoY(List<RtfAtributo> atributos) {
        BufferedImage buffer = new BufferedImage(this.larguraRtf, this.alturaRtf, 2);
        Graphics2D g = buffer.createGraphics();
        int maxY = 0;
        HashSet<Font> fontes = new HashSet<Font>();
        for (RtfAtributo atributo : atributos) {
            if (atributo.getFonte() == null) continue;
            fontes.add(atributo.getFonte());
            g.setFont(atributo.getFonte());
            FontMetrics fm = g.getFontMetrics(atributo.getFonte());
            int alturaAtual = fm.getAscent() + fm.getDescent();
            if (alturaAtual <= maxY) continue;
            maxY = alturaAtual;
        }
        return maxY;
    }

    protected void rtfParaImagem() {
        if (this.imagens.containsKey(this.numeroParagrafo)) {
            RtfImagemAtributo imagem = this.imagens.get(this.numeroParagrafo);
            if (!this.addComponentePagina(imagem.getAltura())) {
                return;
            }
            this.componentsRtf.add(this.montaImagem(imagem, this.numeroComponente, this.y));
            ++this.numeroComponente;
            this.y += imagem.getAltura();
        }
    }

    private boolean addComponentePagina(int alturaComponente) {
        if (!this.redimensionar && this.y + alturaComponente > this.alturaRtf) {
            this.continuarProcesso = false;
        }
        return this.continuarProcesso;
    }

    private Imagem montaImagem(RtfImagemAtributo atributo, int i, int y) {
        Rectangle alturaComponente = new Rectangle(this.xRtf, y, atributo.getLargura(), atributo.getAltura());
        Imagem imagem = new Imagem();
        imagem.setValorResultado(atributo.getImagemBase64());
        if (this.numeroComponente != 0) {
            imagem.setNome("." + i);
        }
        imagem.setDimensoes(alturaComponente);
        return imagem;
    }

    public int getxRtf() {
        return this.xRtf;
    }

    public void setxRtf(int xRtf) {
        this.xRtf = xRtf;
    }

    public int getyRtf() {
        return this.yRtf;
    }

    public void setyRtf(int yRtf) {
        this.yRtf = yRtf;
    }

    public int getAlturaRtf() {
        return this.alturaRtf;
    }

    public void setAlturaRtf(int alturaRtf) {
        this.alturaRtf = alturaRtf;
    }

    public int getLarguraRtf() {
        return this.larguraRtf;
    }

    public void setLarguraRtf(int larguraRtf) {
        this.larguraRtf = larguraRtf;
    }

    public boolean isRedimensionar() {
        return this.redimensionar;
    }

    public void setRedimensionar(boolean redimensionar) {
        this.redimensionar = redimensionar;
    }

    public Map<Integer, RtfImagemAtributo> getImagens() {
        return this.imagens;
    }

    public void setImagens(Map<Integer, RtfImagemAtributo> imagens) {
        this.imagens = imagens;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getUltimaAltura() {
        return this.ultimaAltura;
    }

    public void setUltimaAltura(int ultimaAltura) {
        this.ultimaAltura = ultimaAltura;
    }

    public int getNumeroParagrafo() {
        return this.numeroParagrafo;
    }

    public void setNumeroParagrafo(int numeroParagrafo) {
        this.numeroParagrafo = numeroParagrafo;
    }

    public int getNumeroComponente() {
        return this.numeroComponente;
    }

    public void setNumeroComponente(int numeroComponente) {
        this.numeroComponente = numeroComponente;
    }

    public boolean isContinuarProcesso() {
        return this.continuarProcesso;
    }

    public void setContinuarProcesso(boolean continuarProcesso) {
        this.continuarProcesso = continuarProcesso;
    }

    public List<Component> getComponentsRtf() {
        return this.componentsRtf;
    }

    public void setComponentsRtf(List<Component> componentsRtf) {
        this.componentsRtf = componentsRtf;
    }

    public List<RtfAtributo> getAtributos() {
        return this.atributos;
    }

    public void setAtributos(List<RtfAtributo> atributos) {
        this.atributos = atributos;
    }

    private RtfParaComponenteJalis(RtfParaComponenteJalisBuilder builder) {
        this.xRtf = builder.xRtf;
        this.yRtf = builder.yRtf;
        this.alturaRtf = builder.alturaRtf;
        this.larguraRtf = builder.larguraRtf;
        this.redimensionar = builder.redimensionar;
        this.imagens = builder.imagens;
    }

    public static class RtfParaComponenteJalisBuilder {
        private int xRtf;
        private int yRtf;
        private int alturaRtf;
        private int larguraRtf;
        private boolean redimensionar = false;
        private Map<Integer, RtfImagemAtributo> imagens;

        public RtfParaComponenteJalisBuilder() {
        }

        public RtfParaComponenteJalisBuilder(int xRtf, int yRtf, int alturaRtf, int larguraRtf, boolean redimensionar, Map<Integer, RtfImagemAtributo> imagens) {
            this.xRtf = xRtf;
            this.yRtf = yRtf;
            this.alturaRtf = alturaRtf;
            this.larguraRtf = larguraRtf;
            this.redimensionar = redimensionar;
            this.imagens = imagens;
        }

        public RtfParaComponenteJalisBuilder setxRtf(int xRtf) {
            this.xRtf = xRtf;
            return this;
        }

        public RtfParaComponenteJalisBuilder setyRtf(int yRtf) {
            this.yRtf = yRtf;
            return this;
        }

        public RtfParaComponenteJalisBuilder setAlturaRtf(int alturaRtf) {
            this.alturaRtf = alturaRtf;
            return this;
        }

        public RtfParaComponenteJalisBuilder setLarguraRtf(int larguraRtf) {
            this.larguraRtf = larguraRtf;
            return this;
        }

        public RtfParaComponenteJalisBuilder setRedimensionar(boolean redimensionar) {
            this.redimensionar = redimensionar;
            return this;
        }

        public RtfParaComponenteJalisBuilder setImagens(Map<Integer, RtfImagemAtributo> imagens) {
            this.imagens = imagens;
            return this;
        }

        public RtfParaComponenteJalis build() {
            return new RtfParaComponenteJalis(this);
        }
    }
}

