/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.digitacao.componente;

import jalis.util.ImagemUtils;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import javax.imageio.ImageIO;

public class RtfImagemAtributo {
    private String imagemHex;
    private byte[] imagemByteArray;
    private String imagemBase64;
    private int altura;
    private int largura;
    private Image image;
    private static final double PORCENTAGEM_TAM_IMG = 0.6;

    public RtfImagemAtributo(String imagemHex) {
        this.imagemHex = imagemHex;
        this.montaImagemRtf();
    }

    public String getImagemBase64() {
        return this.imagemBase64;
    }

    public int getAltura() {
        return this.altura;
    }

    public int getLargura() {
        return this.largura;
    }

    public Image getImage() {
        return this.image;
    }

    private void montaImagemRtf() {
        this.converteHexParaByte();
        this.redimensionarImagem();
        this.imagemBase64 = ImagemUtils.converterImagemParaBase64(this.image);
        this.setAlturaELargura();
    }

    private void converteHexParaByte() {
        int qtd = this.imagemHex.length();
        byte[] byteArray = new byte[qtd / 2];
        for (int i = 0; i < qtd; i += 2) {
            byteArray[i / 2] = (byte)((Character.digit(this.imagemHex.charAt(i), 16) << 4) + Character.digit(this.imagemHex.charAt(i + 1), 16));
        }
        this.imagemByteArray = byteArray;
    }

    private void setAlturaELargura() {
        this.altura = this.image.getHeight(null);
        this.largura = this.image.getWidth(null);
    }

    private void redimensionarImagem() {
        try {
            this.image = ImageIO.read(new ByteArrayInputStream(this.imagemByteArray));
            this.altura = (int)((double)this.image.getHeight(null) * 0.6);
            this.largura = (int)((double)this.image.getWidth(null) * 0.6);
            this.image = this.image.getScaledInstance(this.largura, this.altura, 4);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

