/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.digitacao.componente;

import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.digitacao.Execucao;
import jalis.laboratorio.digitacao.TabelaSimbolos;
import jalis.laboratorio.digitacao.componente.ComponenteResultado;
import jalis.laboratorio.digitacao.componente.PosicaoFonte;
import jalis.laboratorio.digitacao.componente.RtfAtributo;
import jalis.laboratorio.digitacao.componente.RtfImagemAtributo;
import jalis.laboratorio.digitacao.componente.RtfParaComponenteJalis;
import jalis.laboratorio.digitacao.evento.CampoEvento;
import jalis.laboratorio.digitacao.evento.CampoListener;
import jalis.laboratorio.digitacao.evento.MensagemListener;
import jalis.laboratorio.impressao.componente.ComponenteImpressao;
import jalis.laboratorio.util.parsers.ProtocoloCampoImportacao;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.rtf.RTFEditorKit;

public class RtfDigitacao
extends JTextPane
implements ComponenteResultado,
ComponenteImpressao {
    private static final String ITALICO = "italic";
    private static final String NEGRITO = "bold";
    private static final String SUBLINHADO = "underline";
    private static final String COR_FONTE = "foreground";
    private static final String TAMANHO_FONTE = "size";
    private static final String FAMILIA_FONTE = "family";
    private transient Componente dono;
    private boolean imprimir;
    private boolean redimensionar = false;
    private String expressao = "";
    private TabelaSimbolos tabela;
    private CampoEvento evento;
    private List<String> ligacoes = new ArrayList<String>();
    private String resultado;
    private transient List<Component> componentsRtf = new ArrayList<Component>();

    public void parseRTF() {
        if (!Funcoes.textoVazio(this.resultado) && this.componentsRtf.isEmpty()) {
            this.extrairTextoInvalido();
            try {
                this.textoParaRtf();
                Map<Integer, RtfImagemAtributo> imagens = this.mapearImagem();
                Dimension d = this.getPreferredSize();
                Rectangle r = this.getBounds();
                r.setSize(d);
                int paragrafoCount = 0;
                Map<Integer, List<RtfAtributo>> paragrafos = this.mapearRtf();
                RtfParaComponenteJalis componenteJalis = this.montarAtributosBasicos(imagens);
                for (Map.Entry<Integer, List<RtfAtributo>> paragrafo : paragrafos.entrySet()) {
                    componenteJalis.rtfParaImagem();
                    if (!componenteJalis.isContinuarProcesso()) break;
                    componenteJalis.setAtributos(paragrafo.getValue());
                    componenteJalis.rtfParaRotulo();
                    if (!componenteJalis.isContinuarProcesso()) break;
                    componenteJalis.setNumeroParagrafo(++paragrafoCount);
                }
                this.componentsRtf.addAll(componenteJalis.getComponentsRtf());
                this.defineTamanhoAreaDoComponente(d, componenteJalis.getY(), componenteJalis.getUltimaAltura());
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "RtfDigitacao");
            }
        }
    }

    private void extrairTextoInvalido() {
        String pattern = "(.*?)(\\{\\\\field[^}]*\\}[^{]*\\{\\\\fldrslt\\{(.*?)\\}\\}\\})(.*?)";
        Pattern regex = Pattern.compile(pattern);
        Matcher matcher = regex.matcher(this.resultado);
        while (matcher.find()) {
            String textoInvalido = matcher.group(2);
            String textoValido = matcher.group(3);
            String espaco = " ";
            this.resultado = this.resultado.replace(textoInvalido, espaco + textoValido + espaco);
        }
    }

    private void textoParaRtf() throws IOException, BadLocationException {
        RTFEditorKit editorKit = new RTFEditorKit();
        this.setContentType("text/rtf");
        this.setEditorKit(editorKit);
        editorKit.read(new ByteArrayInputStream(this.resultado.getBytes(StandardCharsets.ISO_8859_1)), (Document)this.getStyledDocument(), 0);
    }

    private RtfParaComponenteJalis montarAtributosBasicos(Map<Integer, RtfImagemAtributo> imagens) {
        return new RtfParaComponenteJalis.RtfParaComponenteJalisBuilder().setxRtf(this.getX()).setyRtf(this.getY()).setLarguraRtf(this.getWidth()).setAlturaRtf(this.getHeight()).setRedimensionar(this.redimensionar).setImagens(imagens).build();
    }

    private void defineTamanhoAreaDoComponente(Dimension d, int y, int ultimaAltura) {
        if (this.redimensionar) {
            Rectangle alturaRedimensionada = new Rectangle(this.getX(), this.getY(), this.getWidth(), y - ultimaAltura - 8);
            this.setDimensoes(alturaRedimensionada);
        } else if (d.getHeight() > this.getDimensoes().getHeight()) {
            Rectangle alturaRedimensionada = new Rectangle(this.getX(), this.getY(), this.getWidth(), (int)this.getDimensoes().getHeight());
            this.setDimensoes(alturaRedimensionada);
        }
    }

    @Override
    public void pintar(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
    }

    private AttributedString copiarAtributos(AttributedString atributos, String conteudoComQuebra) {
        Map<AttributedCharacterIterator.Attribute, Object> atributosString = atributos.getIterator().getAttributes();
        AttributedString as = new AttributedString(conteudoComQuebra);
        atributosString.forEach(as::addAttribute);
        return as;
    }

    private Map<Integer, List<RtfAtributo>> mapearRtf() {
        ConcurrentHashMap<Integer, List<RtfAtributo>> paragrafos = new ConcurrentHashMap<Integer, List<RtfAtributo>>();
        Element conteudo = this.getStyledDocument().getDefaultRootElement();
        for (int numParagrafo = 0; numParagrafo < conteudo.getElementCount(); ++numParagrafo) {
            List<RtfAtributo> paragrafoDetalhes = this.mapearParagrafo(conteudo.getElement(numParagrafo));
            paragrafos.put(numParagrafo, paragrafoDetalhes);
        }
        return paragrafos;
    }

    private List<RtfAtributo> mapearParagrafo(Element paragrafo) {
        int posicaoParagrafo;
        BufferedImage buffer = new BufferedImage(this.getDimensoes().width, this.getDimensoes().height, 2);
        Graphics2D g = buffer.createGraphics();
        int finalParagrafo = paragrafo.getEndOffset();
        ArrayList<RtfAtributo> atributos = new ArrayList<RtfAtributo>();
        RtfAtributo atributo = new RtfAtributo();
        if (finalParagrafo - posicaoParagrafo < 2) {
            Element ec = this.getStyledDocument().getCharacterElement(posicaoParagrafo);
            Font fonteCaracter = this.carregarFonteDoCaracter(ec.getAttributes().getAttributeNames(), ec.getAttributes());
            atributo.setConteudo(System.lineSeparator());
            atributo.setAtributos(null);
            atributo.setFonte(fonteCaracter);
            atributos.add(atributo);
        } else {
            StringBuilder conteudo = new StringBuilder();
            int metricaParagrafo = 0;
            int inicio = 0;
            for (posicaoParagrafo = paragrafo.getStartOffset(); posicaoParagrafo < finalParagrafo; ++posicaoParagrafo) {
                char caracter = this.getCaracterNaPosicao(posicaoParagrafo);
                char proxCaracter = this.getCaracterNaPosicao(posicaoParagrafo + 1);
                Element ec = this.getStyledDocument().getCharacterElement(posicaoParagrafo);
                Font fonteCaracter = this.carregarFonteDoCaracter(ec.getAttributes().getAttributeNames(), ec.getAttributes());
                Element ecProx = this.getStyledDocument().getCharacterElement(posicaoParagrafo + 1);
                Font proxFonteCaracter = this.carregarFonteDoCaracter(ecProx.getAttributes().getAttributeNames(), ecProx.getAttributes());
                if (caracter == '\t') {
                    int posicaoTab;
                    metricaParagrafo = posicaoTab = this.calcularPosicaoTab(metricaParagrafo);
                } else if (caracter != '\n') {
                    conteudo.append(caracter);
                    g.setFont(fonteCaracter);
                    int medidadeCaracter = g.getFontMetrics().charWidth(caracter);
                    metricaParagrafo += medidadeCaracter;
                }
                if (!(fonteCaracter != null && proxFonteCaracter != null && !fonteCaracter.equals(proxFonteCaracter) || posicaoParagrafo == finalParagrafo - 1 || caracter == '\t' && proxCaracter != '\t' || RtfDigitacao.isCaracterInvalido(proxCaracter)) && !RtfDigitacao.isCaracterInvalido(caracter)) continue;
                char antCaracter = this.getCaracterNaPosicao(posicaoParagrafo - 1);
                if (this.redimencionarEspacamento(caracter, proxCaracter, fonteCaracter, proxFonteCaracter, antCaracter)) {
                    metricaParagrafo += g.getFontMetrics().charWidth(' ') * 3;
                    conteudo.append("   ");
                }
                AttributedString as = null;
                if (conteudo.length() > 0) {
                    as = this.converterAttributeSetParaAttributedString(conteudo.toString(), ec.getAttributes().getAttributeNames(), ec.getAttributes(), atributo);
                    atributo.setAtributos(as);
                    atributo.setConteudo(conteudo.toString());
                    atributo.setFonte(fonteCaracter);
                }
                atributo.setInicio(inicio);
                atributo.setFim(metricaParagrafo);
                atributos.add(atributo);
                atributo = new RtfAtributo();
                conteudo.delete(0, conteudo.length());
                inicio = metricaParagrafo;
            }
        }
        return atributos;
    }

    private boolean redimencionarEspacamento(char caracter, char proxCaracter, Font fonteCaracter, Font proxFonteCaracter, char antCaracter) {
        return fonteCaracter != null && proxFonteCaracter != null && fonteCaracter.getStyle() != 2 && proxFonteCaracter.getStyle() != 2 && (this.isBold(fonteCaracter) && !this.isBold(proxFonteCaracter) || !this.isBold(fonteCaracter) && this.isBold(proxFonteCaracter)) && ((antCaracter == '.' || antCaracter == ':') && caracter == ' ' || (caracter == '.' || caracter == ':') && proxCaracter == ' ');
    }

    private boolean isBold(Font fonte) {
        return fonte.getStyle() == 1;
    }

    private int calcularPosicaoTab(int metrica) {
        int tab = 36;
        if (metrica < 36) {
            return 36;
        }
        int div = metrica / 36;
        return (div + 1) * 36;
    }

    private char getCaracterNaPosicao(int posicao) {
        String c = "";
        try {
            c = this.getStyledDocument().getText(posicao, 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return c.charAt(0);
    }

    private Font carregarFonteDoCaracter(Enumeration<?> keys, AttributeSet attributeSet) {
        Float tamanhoFonte = Float.valueOf(0.0f);
        ConcurrentHashMap<TextAttribute, Object> map = new ConcurrentHashMap<TextAttribute, Object>();
        Font fonte = null;
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = attributeSet.getAttribute(key);
            if (key == null || value == null) continue;
            if (key.toString().equals(ITALICO) && value.toString().equalsIgnoreCase(Boolean.TRUE.toString())) {
                map.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
                continue;
            }
            if (key.toString().equals(NEGRITO) && value.toString().equalsIgnoreCase(Boolean.TRUE.toString())) {
                map.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
                continue;
            }
            if (key.toString().equals(SUBLINHADO) && value.toString().equalsIgnoreCase(Boolean.TRUE.toString())) {
                map.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                continue;
            }
            if (key.toString().equals(COR_FONTE)) {
                Color cor = (Color)value;
                map.put(TextAttribute.FOREGROUND, cor);
                continue;
            }
            if (key.toString().equals(TAMANHO_FONTE)) {
                tamanhoFonte = Float.valueOf(value.toString());
                continue;
            }
            if (!key.toString().equals(FAMILIA_FONTE)) continue;
            tamanhoFonte = Float.valueOf(tamanhoFonte.floatValue() - 0.4f);
            map.put(TextAttribute.SIZE, tamanhoFonte);
            map.put(TextAttribute.WIDTH, 1.0);
            map.put(TextAttribute.FAMILY, value.toString());
            fonte = new Font(map);
        }
        return fonte;
    }

    private AttributedString converterAttributeSetParaAttributedString(String conteudo, Enumeration<?> keys, AttributeSet attributeSet, RtfAtributo atributo) {
        AttributedString as = new AttributedString(conteudo);
        ConcurrentHashMap<TextAttribute, Object> map = new ConcurrentHashMap<TextAttribute, Object>();
        Float tamanhoFonte = Float.valueOf(0.0f);
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = attributeSet.getAttribute(key);
            if (key == null || value == null) continue;
            if (key.toString().equals(ITALICO) && value.toString().equalsIgnoreCase(Boolean.TRUE.toString())) {
                as.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
                map.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
                continue;
            }
            if (key.toString().equals(NEGRITO) && value.toString().equalsIgnoreCase(Boolean.TRUE.toString())) {
                as.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
                map.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
                continue;
            }
            if (key.toString().equals(SUBLINHADO) && value.toString().equalsIgnoreCase(Boolean.TRUE.toString())) {
                as.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                map.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                continue;
            }
            if (key.toString().equals(COR_FONTE)) {
                Color cor = (Color)value;
                as.addAttribute(TextAttribute.FOREGROUND, cor);
                map.put(TextAttribute.FOREGROUND, cor);
                continue;
            }
            if (key.toString().equals(TAMANHO_FONTE)) {
                tamanhoFonte = Float.valueOf(value.toString());
                as.addAttribute(TextAttribute.SIZE, tamanhoFonte);
                continue;
            }
            if (!key.toString().equals(FAMILIA_FONTE)) continue;
            map.put(TextAttribute.SIZE, tamanhoFonte);
            map.put(TextAttribute.WIDTH, 1.0);
            map.put(TextAttribute.FAMILY, value.toString());
            Font f = new Font(map);
            as.addAttribute(TextAttribute.FONT, f);
            atributo.setFonte(f);
        }
        return as;
    }

    private int calcularLarguraDoConteudo(Font fonte, String conteudo, Graphics2D g) {
        g.setFont(fonte);
        FontMetrics fm = g.getFontMetrics();
        return fm.charsWidth(conteudo.toCharArray(), 0, conteudo.length());
    }

    private void manterSomentePosicoesDuplicadas(Map<Font, List<PosicaoFonte>> posicoesCalculadas) {
        ArrayList<Font> semPosicoes = new ArrayList<Font>();
        for (Map.Entry<Font, List<PosicaoFonte>> pf : posicoesCalculadas.entrySet()) {
            List<PosicaoFonte> posicoes = pf.getValue();
            HashSet set = new HashSet();
            HashSet duplicados = new HashSet();
            posicoes.forEach(posicao -> {
                boolean adicionou = set.add(posicao.getPosicaoString());
                if (!adicionou) {
                    duplicados.add(posicao.getPosicaoString());
                }
            });
            posicoes.removeIf(pos -> !duplicados.contains(pos.getPosicaoString()));
            if (!posicoes.isEmpty()) continue;
            semPosicoes.add(pf.getKey());
        }
        semPosicoes.forEach(sp -> {
            List cfr_ignored_0 = (List)posicoesCalculadas.remove(sp);
        });
    }

    private Map<Font, List<PosicaoFonte>> ajustarParaMaiorPosicaoFM(Map<Font, List<PosicaoFonte>> posicoesCalculadas) {
        ConcurrentHashMap<Font, List<PosicaoFonte>> posicoesAjustadas = new ConcurrentHashMap<Font, List<PosicaoFonte>>();
        for (Map.Entry<Font, List<PosicaoFonte>> pf : posicoesCalculadas.entrySet()) {
            ConcurrentSkipListSet posicoesString = new ConcurrentSkipListSet();
            pf.getValue().forEach(p -> posicoesString.add(p.getPosicaoString()));
            ConcurrentHashMap<Integer, Integer> maioresPosicoes = new ConcurrentHashMap<Integer, Integer>();
            for (Integer posString : posicoesString) {
                OptionalInt maxFM = pf.getValue().stream().filter(p -> p.getPosicaoString() == posString.intValue()).mapToInt(p -> p.getPosicaoFM()).max();
                maioresPosicoes.put(posString, maxFM.getAsInt());
            }
            ArrayList novasPosicoes = new ArrayList();
            maioresPosicoes.forEach((k, v) -> novasPosicoes.add(new PosicaoFonte((int)k, (int)v, (Font)pf.getKey())));
            posicoesAjustadas.put(pf.getKey(), novasPosicoes);
        }
        return posicoesAjustadas;
    }

    public static boolean isCaracterInvalido(char caracter) {
        return String.format("%d", caracter).equals("8804") || String.format("%d", caracter).equals("8805") || String.format("%d", caracter).equals("8230");
    }

    private Map<Integer, RtfImagemAtributo> mapearImagem() {
        HashMap<Integer, RtfImagemAtributo> imagens = new HashMap<Integer, RtfImagemAtributo>();
        String pattern = "picscaley(\\d+)\\s([^}]+)";
        Pattern regex = Pattern.compile(pattern);
        Matcher matcher = regex.matcher(this.resultado);
        while (matcher.find()) {
            String hex = matcher.group(2);
            int paragrafoImagem = this.resultado.substring(0, this.resultado.indexOf(hex)).split("\\\\par ").length - 1;
            imagens.put(paragrafoImagem += this.resultado.substring(0, this.resultado.indexOf(hex)).split("\\\\par\\\\").length - 1, new RtfImagemAtributo(hex));
        }
        return imagens;
    }

    private int imprimirLinhaComQuebra(Graphics2D g, int x, int y, int larguraConteudo, String conteudo, FontMetrics fm, RtfAtributo atributo) {
        int i;
        StringBuilder conteudoComQuebra = new StringBuilder();
        boolean adicionarEspaco = true;
        String[] palavras = conteudo.split(" ");
        if (palavras.length == 1) {
            adicionarEspaco = false;
            palavras = new String[conteudo.length()];
            for (i = 0; i < conteudo.length(); ++i) {
                palavras[i] = String.valueOf(conteudo.charAt(i));
            }
        }
        for (i = 0; i < palavras.length; ++i) {
            conteudoComQuebra.append(palavras[i]);
            if (adicionarEspaco) {
                conteudoComQuebra.append(" ");
            }
            int larguraCalculada = fm.charsWidth(conteudoComQuebra.toString().toCharArray(), 0, conteudoComQuebra.toString().length());
            if (palavras.length - i > 1) {
                String proximaPlavra = palavras[i + 1];
                int larguraProximaPalavra = fm.charsWidth(proximaPlavra.toCharArray(), 0, proximaPlavra.length());
                if (x + larguraCalculada + larguraProximaPalavra <= this.getWidth()) continue;
                AttributedString as = this.copiarAtributos(atributo.getAtributos(), conteudoComQuebra.toString());
                g.drawString(as.getIterator(), x, y += fm.getAscent() + fm.getDescent());
                conteudoComQuebra.delete(0, conteudoComQuebra.length());
                x = 0;
                continue;
            }
            AttributedString as = this.copiarAtributos(atributo.getAtributos(), conteudoComQuebra.toString());
            g.drawString(as.getIterator(), x, y += fm.getAscent() + fm.getDescent());
        }
        return y;
    }

    private Map<Font, List<PosicaoFonte>> calcularPosicionamentoPorFonte(Map<Integer, List<RtfAtributo>> paragrafos, Graphics2D g) {
        ConcurrentHashMap<Font, List<PosicaoFonte>> posicoesCalculadas = new ConcurrentHashMap<Font, List<PosicaoFonte>>();
        paragrafos.forEach((numParagrafo, atributosParagrafo) -> {
            if (atributosParagrafo.size() > 1) {
                int larguraConteudo = 0;
                for (RtfAtributo atributo : atributosParagrafo) {
                    List<PosicaoFonte> posicoesFonte;
                    if (posicoesCalculadas.isEmpty()) {
                        posicoesFonte = new ArrayList<PosicaoFonte>();
                        posicoesFonte.add(new PosicaoFonte(atributo.getInicio(), larguraConteudo, atributo.getFonte()));
                        larguraConteudo += this.calcularLarguraDoConteudo(atributo.getFonte(), atributo.getConteudo(), g);
                        posicoesCalculadas.put(atributo.getFonte(), posicoesFonte);
                        continue;
                    }
                    posicoesFonte = (List)posicoesCalculadas.get(atributo.getFonte());
                    if (posicoesFonte == null) {
                        posicoesFonte = new ArrayList();
                    }
                    posicoesFonte.add(new PosicaoFonte(atributo.getInicio(), larguraConteudo, atributo.getFonte()));
                    larguraConteudo += this.calcularLarguraDoConteudo(atributo.getFonte(), atributo.getConteudo(), g);
                    posicoesCalculadas.put(atributo.getFonte(), posicoesFonte);
                }
            }
        });
        this.manterSomentePosicoesDuplicadas(posicoesCalculadas);
        return this.ajustarParaMaiorPosicaoFM(posicoesCalculadas);
    }

    @Override
    public String getNome() {
        return this.getName();
    }

    @Override
    public Object getValor() {
        return !Funcoes.textoVazio(this.resultado) ? this.resultado : "";
    }

    @Override
    public String getValorOriginal() {
        return null;
    }

    @Override
    public boolean vazio() {
        return this.getStringValor().trim().length() == 0;
    }

    @Override
    public boolean resultadoAnterior() {
        return false;
    }

    @Override
    public void setDono(Componente dono) {
        this.dono = dono;
    }

    @Override
    public String getStringValor() {
        return this.resultado;
    }

    @Override
    public boolean imprimir() {
        return this.imprimir;
    }

    @Override
    public boolean removerVazio() {
        return this.dono != null && this.dono.getRemoverVazio();
    }

    @Override
    public void setRemoverVazio(boolean valor) {
        if (this.dono != null) {
            this.dono.setRemoverVazio(valor);
        }
    }

    @Override
    public boolean salvarParcialmente() {
        return false;
    }

    @Override
    public List<String> getLigacoes() {
        return this.ligacoes;
    }

    @Override
    public int getAlinhamentoHorizontal() {
        return 0;
    }

    @Override
    public void setAlinhamentoHorizontal(int alinhamento) {
    }

    public List<Component> getComponentsRtf() {
        return this.componentsRtf;
    }

    public void setComponentsRtf(List<Component> componentsRtf) {
        this.componentsRtf = componentsRtf;
    }

    @Override
    public Componente getDono() {
        return this.dono;
    }

    @Override
    public Rectangle getDimensoes() {
        if (this.dono != null) {
            return this.dono.getDimensoes();
        }
        return new Rectangle();
    }

    @Override
    public void setDimensoes(Rectangle rec) {
        if (this.dono != null) {
            this.dono.setDimensoes(rec);
        }
        this.setBounds(rec);
    }

    @Override
    public void setDimensoes(int esquerda, int topo, int largura, int altura) {
        this.setDimensoes(new Rectangle(esquerda, topo, largura, altura));
    }

    @Override
    public Point getPosicao() {
        return null;
    }

    @Override
    public void setValor(Object valor) {
        if (valor != null) {
            String resultadoRTF;
            this.resultado = resultadoRTF = valor.toString().replace("\\\\", "\\");
            if (this.dono != null) {
                this.dono.setValorResultado(resultadoRTF);
            }
            if (!Funcoes.textoVazio(this.resultado)) {
                this.parseRTF();
            }
        }
    }

    @Override
    public void limpar() {
    }

    @Override
    public void carregarValorPadrao() {
    }

    @Override
    public void setProcessarPerdaDeFoco(boolean flag) {
    }

    @Override
    public void addCampoListener(CampoListener l) {
    }

    @Override
    public void removeCampoListener(CampoListener l) {
    }

    @Override
    public void addMensagemListener(MensagemListener l) {
    }

    @Override
    public void removeMensagemListener(MensagemListener l) {
    }

    @Override
    public boolean digitavel() {
        return false;
    }

    @Override
    public void setComponentesFoco(List<Component> list) {
    }

    @Override
    public boolean isRelacionavelComCampoDeImportacao() {
        return this.dono != null ? this.dono.isRelacionavelComCampoDeImportacao() : false;
    }

    @Override
    public String getCampoDeImportacao() {
        return this.dono != null ? this.dono.getCampoImportacao().campoImportacao : "";
    }

    @Override
    public Map<String, ProtocoloCampoImportacao> getMapCampoDeImportacao() {
        return null;
    }

    public void setRedimensionar(boolean redimensionar) {
        this.redimensionar = redimensionar;
    }

    public boolean isRedimensionar() {
        return this.redimensionar;
    }

    public void setImprimir(boolean imprimir) {
        this.imprimir = imprimir;
    }

    public void setTabelaSimbolos(TabelaSimbolos tabela) {
        this.tabela = tabela;
    }

    public void setLigacoes(List<String> lig) {
        this.ligacoes.clear();
        this.ligacoes.addAll(lig);
    }

    public void setExpressao(String expressao) {
        if (!Funcoes.textoVazio(expressao)) {
            ((DefaultCaret)super.getCaret()).setUpdatePolicy(1);
            this.expressao = expressao;
        }
    }

    public String getExpressao() {
        return this.expressao;
    }

    public void executar() {
        if (this.tabela != null) {
            Execucao exe = new Execucao(this.getExpressao(), this.tabela, 0);
            Object res = exe.resultadoExpressao();
            String resExpressao = res == null ? "" : res.toString();
            this.setText(resExpressao);
        }
    }
}

