/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.digitacao.componente;

import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.configurador.Constantes;
import jalis.laboratorio.configurador.ValoresReferencia;
import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.configurador.componente.ReguaReferencial;
import jalis.laboratorio.digitacao.Execucao;
import jalis.laboratorio.digitacao.TabelaSimbolos;
import jalis.laboratorio.digitacao.TabelaSimbolosListener;
import jalis.laboratorio.digitacao.componente.ComponenteDigitacao;
import jalis.laboratorio.digitacao.componente.ComponenteValor;
import jalis.laboratorio.digitacao.evento.CampoEvento;
import jalis.laboratorio.digitacao.evento.CampoListener;
import jalis.util.Funcoes;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;

public class ReguaReferencialDigitacao
extends JComponent
implements ComponenteDigitacao,
CampoListener {
    private ReguaReferencial dono;
    private TabelaSimbolos tabela;
    private Float valor;
    private int tipoRegua;
    private static final DecimalFormat decfor = new DecimalFormat("0.00");

    @Override
    public void digitouValor(CampoEvento e) {
        this.atualizar();
    }

    @Override
    public void setDono(Componente dono) {
        if (dono instanceof ReguaReferencial) {
            this.dono = (ReguaReferencial)dono;
        }
    }

    public void setTipo(int tipoRegua) {
        this.tipoRegua = tipoRegua;
    }

    public int getTipoRegua() {
        return this.tipoRegua;
    }

    public void setTabelaSimbolos(TabelaSimbolos tabela) {
        this.tabela = tabela;
    }

    public void atualizar() {
        this.valor = null;
        if (this.tabela != null && this.dono != null) {
            Object o = this.getValorReguaDigitacao(this.dono.getOrigem(), this.tabela);
            Object object = o = o instanceof String ? ReguaReferencial.getValorStringReguaReferencial(o.toString()) : o;
            if (o instanceof Number) {
                this.valor = Float.valueOf(((Number)o).floatValue());
            }
            if (o instanceof Date) {
                this.valor = this.parserDataParaReferencial(o);
            }
            if (this.dono.getTipoRegua() == 1) {
                Object resultado = this.executarExpressao();
                if (resultado instanceof Double) {
                    this.valor = Float.valueOf(resultado.toString());
                }
                if (resultado instanceof Double) {
                    this.dono.setResultadoExpressaoMedia(resultado.toString());
                }
            }
        }
        this.repaint();
    }

    private Object getValorReguaDigitacao(String simbolo, TabelaSimbolos tabela) {
        Object valorRegua = null;
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        if (tabela.getSimbolos() != null) {
            tmp.putAll(tabela.getSimbolos());
        }
        if (tabela.getSimbolosExternos() != null) {
            tmp.putAll(tabela.getSimbolosExternos());
        }
        if (!tmp.isEmpty()) {
            if (tmp.containsKey(simbolo.toLowerCase()) || tabela.getListener().isEmpty()) {
                valorRegua = tmp.get(simbolo.toLowerCase());
                if (valorRegua instanceof ComponenteValor) {
                    valorRegua = ((ComponenteValor)valorRegua).getValorOriginal();
                }
            } else {
                for (TabelaSimbolosListener l : tabela.getListener()) {
                    valorRegua = l.simboloNaoLocalizado(simbolo);
                }
            }
        }
        return valorRegua;
    }

    public Float parserDataParaReferencial(Object o) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
        String horaFormatada = dateFormat.format((Date)o);
        try {
            Date hora = dateFormat.parse(horaFormatada);
            Long z = hora.getTime();
            return Float.valueOf(z.floatValue());
        }
        catch (ParseException e) {
            e.printStackTrace();
            return Float.valueOf(0.0f);
        }
    }

    public String getOrigem() {
        return this.dono == null ? "" : this.dono.getOrigem();
    }

    public String getExpressao() {
        return this.dono == null ? "" : this.dono.getExpressao();
    }

    @Override
    public String getStringValor() {
        return this.valor == null ? "" : this.valor.toString();
    }

    @Override
    public boolean imprimir() {
        return this.dono != null && this.dono.getImprimir();
    }

    @Override
    public boolean vazio() {
        return this.dono != null ? this.dono.getOrigem() == null : this.valor == null;
    }

    @Override
    public boolean removerVazio() {
        return false;
    }

    @Override
    public void setRemoverVazio(boolean valor) {
    }

    @Override
    public boolean salvarParcialmente() {
        return true;
    }

    @Override
    public List<String> getLigacoes() {
        return new ArrayList<String>();
    }

    @Override
    public int getAlinhamentoHorizontal() {
        return 0;
    }

    @Override
    public void setAlinhamentoHorizontal(int alinhamento) {
    }

    @Override
    public Componente getDono() {
        return this.dono;
    }

    @Override
    public Rectangle getDimensoes() {
        return this.dono == null ? new Rectangle() : this.dono.getDimensoes();
    }

    @Override
    public String getNome() {
        return this.dono == null ? "" : this.dono.getNome();
    }

    @Override
    public void setDimensoes(Rectangle rec) {
        if (this.dono != null) {
            this.dono.setDimensoes(rec);
        }
        this.setBounds(rec);
    }

    @Override
    public void setDimensoes(int esquerda, int topo, int largura, int altura) {
        this.setDimensoes(new Rectangle(esquerda, topo, largura, altura));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void paint(Graphics g) {
        block16: {
            block17: {
                block21: {
                    block23: {
                        block22: {
                            block18: {
                                block20: {
                                    block19: {
                                        block15: {
                                            g2 = (Graphics2D)g;
                                            width = this.getWidth();
                                            height = this.getHeight();
                                            y = height / 2;
                                            if (this.dono != null) break block15;
                                            g2.setColor(Color.red);
                                            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                                            break block16;
                                        }
                                        valores = this.dono.getValoresDeReferencia();
                                        atributosAlterado = this.dono.getAtributosAlterado();
                                        atributosNormal = this.dono.getAtributosNormal();
                                        atributosReguaMedia = this.dono.getAtributosReguaMedia();
                                        g2.setColor(this.dono.getCorDeFundo());
                                        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                                        if (this.dono.getTipoRegua() != 1) break block17;
                                        if (!atributosReguaMedia.getTipoPreenchimento().equals("Degrad\u00ea")) break block18;
                                        cores = new Color[atributosReguaMedia.getAtributosReguas().size()];
                                        dist = new float[atributosReguaMedia.getAtributosReguas().size()];
                                        parteLargura = 1.0f / (float)atributosReguaMedia.getAtributosReguas().size();
                                        for (i = 0; i < atributosReguaMedia.getAtributosReguas().size(); ++i) {
                                            cores[i] = atributosReguaMedia.getAtributosReguas().get(i).getCor();
                                            dist[i] = (float)(i + 1) * parteLargura;
                                        }
                                        if (cores.length > 0) {
                                            primary = new LinearGradientPaint(0.0f, 0.0f, width, height, dist, cores);
                                            g2.setPaint(primary);
                                        }
                                        g2.fillRect(0, 5, width, height - 10);
                                        minimo = atributosReguaMedia.getMinimo().toString().replace(".", ",");
                                        maximo = atributosReguaMedia.getMaximo().toString().replace(".", ",");
                                        if (valores != null) {
                                            valores.setValores(new String[]{minimo, minimo, maximo, maximo});
                                        } else {
                                            valores = ValoresReferencia.novaInstancia(1, "#####");
                                            valores.setValores(new String[]{minimo, minimo, maximo, maximo});
                                        }
                                        if (valores != null && !valores.zero() && !valores.invalido()) break block19;
                                        g2.drawLine(0, y, width - 1, y);
                                        break block16;
                                    }
                                    vlrs = this.dono.converteValores(valores);
                                    dist2 = vlrs[3] - vlrs[0];
                                    resultado = this.executarExpressao();
                                    if (resultado != null) {
                                        this.valor = Float.valueOf(resultado instanceof Number != false ? new Float(resultado.toString()).floatValue() : 0.0f);
                                        this.dono.setResultadoExpressaoMedia(this.valor.toString());
                                    }
                                    minimo = minimo.replace(",", ".");
                                    maximo = maximo.replace(",", ".");
                                    if (!minimo.matches("\\-?\\d+(\\.\\d+)?") || !maximo.matches("\\-?\\d+(\\.\\d+)?")) break block20;
                                    if (this.valor != null) {
                                        v0 = new Float(minimo);
                                        if (this.valor.floatValue() >= v0.floatValue()) {
                                            v1 = new Float(maximo);
                                            if (this.valor.floatValue() <= v1.floatValue()) {
                                                pos = (int)((float)width * (this.valor.floatValue() - vlrs[0]) / dist2);
                                                pos = pos < 1 ? 0 : (pos > width - 3 ? width - 3 : pos - 1);
                                                g2.setColor(atributosReguaMedia.getCorMedia());
                                                larguraCursor = atributosReguaMedia.getLarguraMedia() <= 0 ? 5 : atributosReguaMedia.getLarguraMedia();
                                                pos = larguraCursor + pos >= width ? width - larguraCursor : pos;
                                                g2.fillRect(pos, 0, larguraCursor, height);
                                                ** GOTO lbl152
                                            }
                                        }
                                    }
                                    break block16;
                                }
                                Funcoes.mensagem(Laboratorio.getInstancia(), "Valores m\u00ednimo e/ou m\u00e1ximo invalidos. Verifique a configura\u00e7\u00e3o da r\u00e9gua m\u00e9dia.", 1);
                                return;
                            }
                            height = height <= 10 ? 15 : height;
                            ReguaReferencial.paintReguaFixa(g2, width, height - 10, atributosReguaMedia);
                            resultado = this.executarExpressao();
                            if (resultado == null) break block16;
                            this.valor = Float.valueOf(resultado instanceof Number != false ? new Float(resultado.toString()).floatValue() : 0.0f);
                            this.dono.setResultadoExpressaoMedia(this.valor.toString());
                            minimo = atributosReguaMedia.getMinimo().toString().replace(",", ".");
                            maximo = atributosReguaMedia.getMaximo().toString().replace(",", ".");
                            valormin = 0.0f;
                            valormax = 0.0f;
                            dist = ReguaReferencial.getPosicoesReguaFixa(atributosReguaMedia);
                            for (i = 0; i < atributosReguaMedia.getAtributosReguas().size(); ++i) {
                                atrib = atributosReguaMedia.getAtributosReguas().get(i);
                                if (this.valor == null) continue;
                                v2 = new Float(atrib.getValorInicial().replace(",", "."));
                                if (!(this.valor.floatValue() >= v2.floatValue())) continue;
                                v3 = new Float(atrib.getValorFinal().replace(",", "."));
                                if (!(this.valor.floatValue() <= v3.floatValue())) continue;
                                minimo = atrib.getValorInicial().replace(",", ".");
                                maximo = atrib.getValorFinal().replace(",", ".");
                                valormin = dist[i * 2];
                                valormax = dist[i * 2 + 1];
                            }
                            if (valormax < 0.0f || valormin < 0.0f || valormin == valormax) break block16;
                            dist2 = new Float(maximo).floatValue() - new Float(minimo).floatValue();
                            min = (int)((float)width * valormin);
                            max = (int)((float)width * valormax);
                            if (!minimo.matches("\\-?\\d+(\\.\\d+)?") || !maximo.matches("\\-?\\d+(\\.\\d+)?")) break block21;
                            if (this.valor == null) break block16;
                            larguraCursor = atributosReguaMedia.getLarguraMedia() <= 0 ? 5 : atributosReguaMedia.getLarguraMedia();
                            pos = (int)((float)max * (this.valor.floatValue() - new Float(minimo).floatValue()) / dist2);
                            if (!this.valor.equals(new Float(maximo))) break block22;
                            pos = max;
                            pos = larguraCursor + pos >= width ? width - larguraCursor : pos;
                            break block23;
                        }
                        v4 = new Float(minimo);
                        if (!(this.valor.floatValue() > v4.floatValue())) ** GOTO lbl-1000
                        v5 = new Float(maximo);
                        if (this.valor.floatValue() < v5.floatValue()) {
                            intervalo = atributosReguaMedia.getMaximo().floatValue() - atributosReguaMedia.getMinimo().floatValue();
                            diferencaValorFinal = Float.valueOf(this.valor.floatValue() - atributosReguaMedia.getMinimo().floatValue());
                            posicaoInicial = Float.parseFloat(ReguaReferencialDigitacao.decfor.format(diferencaValorFinal.floatValue() / intervalo).replace(",", "."));
                            pos = (int)(posicaoInicial * (float)width);
                            pos = larguraCursor + pos >= max ? max : pos;
                            pos = larguraCursor + pos >= width ? width - larguraCursor : pos;
                        } else if (this.valor.equals(new Float(minimo))) {
                            pos = min;
                        }
                    }
                    g2.setColor(atributosReguaMedia.getCorMedia());
                    g2.fillRect(pos, 0, larguraCursor, height);
                    break block16;
                }
                Funcoes.mensagem(Laboratorio.getInstancia(), "Valores m\u00ednimo e/ou m\u00e1ximo invalidos. Verifique a configura\u00e7\u00e3o da r\u00e9gua m\u00e9dia.", 1);
                return;
            }
            if (valores == null || valores.zero() || valores.invalido()) {
                g2.setColor(Color.red);
                g2.setStroke(Constantes.SOLIDO);
                g2.drawLine(0, y, width - 1, y);
            } else {
                vlrs = this.dono.converteValores(valores);
                dist = vlrs[3] - vlrs[0];
                min = (int)((float)width * (vlrs[1] - vlrs[0]) / dist);
                max = (int)((float)width * (vlrs[2] - vlrs[0]) / dist);
                atributosAlterado.aplicarAtributos(g2);
                g2.drawLine(0, y, min, y);
                g2.drawLine(max, y, width - 1, y);
                atributosNormal.aplicarAtributos(g2);
                g2.drawLine(min, y, max, y);
                g2.setStroke(Constantes.SOLIDO);
                g2.drawLine(min, 2, min, height - 3);
                g2.drawLine(max, 2, max, height - 3);
                if (this.valor != null) {
                    pos = (int)((float)width * (this.valor.floatValue() - vlrs[0]) / dist);
                    pos = pos < 1 ? 0 : (pos > width - 3 ? width - 3 : pos - 1);
                    y = height / 4;
                    g2.setColor(Color.black);
                    g2.fillRect(pos, y, 3, height - y * 2);
                }
                g2.setColor(atributosAlterado.getCor());
            }
            g2.drawLine(0, 0, 0, height - 1);
            g2.drawLine(width - 1, 0, width - 1, height - 1);
        }
    }

    private Object executarExpressao() {
        Execucao exe = new Execucao(this.dono.getExpressao(), this.tabela, 0);
        return exe.resultadoExpressao();
    }
}

