/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.digitacao.componente;

import jalis.util.StringUtil;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;

public class ModeloTabelaHistoricos
extends AbstractTableModel
implements MouseListener {
    ArrayList<String[]> dados = new ArrayList();
    ArrayList<String[]> filtrado = new ArrayList();
    int ultCol = -1;
    int ultSentido = 1;

    @Override
    public void mouseClicked(MouseEvent e) {
        Object o = e.getSource();
        if (o instanceof JTableHeader) {
            JTableHeader header = (JTableHeader)o;
            JTable tab = header.getTable();
            int col = header.getColumnModel().getColumnIndexAtX(e.getX());
            Rectangle rec = header.getHeaderRect(col);
            if (col == 0) {
                rec.width -= 3;
            } else {
                rec.grow(-3, 0);
            }
            if (rec.contains(e.getPoint())) {
                this.ordenar(col);
            }
            tab.getColumnModel().getColumn(0).setMaxWidth(70);
        }
    }

    private void ordenar(final int col) {
        if (col > -1 && col < 2) {
            if (col == this.ultCol) {
                this.ultSentido *= -1;
            } else {
                this.ultSentido = 1;
                this.ultCol = col;
            }
            Comparator com = new Comparator(){

                public int compare(Object o1, Object o2) {
                    Object a = o1 == null ? "" : o1;
                    Object b = o2 == null ? "" : o2;
                    int retorno = 0;
                    if (a instanceof String && b instanceof String) {
                        retorno = ModeloTabelaHistoricos.this.removeTagsHTML(a.toString()).compareTo(ModeloTabelaHistoricos.this.removeTagsHTML(b.toString())) * ModeloTabelaHistoricos.this.ultSentido;
                    } else if (a instanceof Integer && b instanceof Integer) {
                        retorno = ((Integer)a).compareTo((Integer)b) * ModeloTabelaHistoricos.this.ultSentido;
                    } else if (a instanceof Object[] && b instanceof Object[]) {
                        retorno = ModeloTabelaHistoricos.this.removeTagsHTML(((Object[])a)[col].toString()).compareTo(ModeloTabelaHistoricos.this.removeTagsHTML(((Object[])b)[col].toString())) * ModeloTabelaHistoricos.this.ultSentido;
                    }
                    return retorno;
                }
            };
            Collections.sort(this.dados, com);
            Collections.sort(this.filtrado, com);
            this.fireTableStructureChanged();
        }
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.filtrado.size();
    }

    @Override
    public String getColumnName(int column) {
        StringBuilder bui = new StringBuilder(column == 0 ? "C\u00f3digo" : "Descri\u00e7\u00e3o");
        if (column == this.ultCol) {
            bui.append(this.ultSentido == 1 ? "  \u25bc" : "  \u25b2");
        }
        return bui.toString();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.filtrado.get(rowIndex)[columnIndex];
    }

    public void setHistoricos(Map<String, String> historicos) {
        if (historicos != null) {
            this.dados.clear();
            this.filtrado.clear();
            for (String cod : historicos.keySet()) {
                String descricao = historicos.get(cod);
                if (descricao.indexOf("<html>") < 0) {
                    descricao = descricao.replaceAll("&gt;", ">").replaceAll("&lt;", "<");
                }
                this.dados.add(new String[]{cod, descricao});
            }
            this.filtrado.addAll(this.dados);
            this.ordenar(1);
            this.fireTableDataChanged();
        }
    }

    public void filtrar(String str) {
        if (str != null) {
            this.filtrado.clear();
            if (str.matches(" *")) {
                this.filtrado.addAll(this.dados);
            } else {
                for (String[] linha : this.dados) {
                    if (!StringUtil.removerAcentos(this.removeTagsHTML(linha[1])).toLowerCase().contains(StringUtil.removerAcentos(str).toLowerCase())) continue;
                    this.filtrado.add(linha);
                }
            }
            this.fireTableDataChanged();
        }
    }

    private String removeTagsHTML(String texto) {
        return texto.replaceAll("\\<.[html]*[b]*[i]*[u]*[sub]*[sup]*\\>", "");
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

