/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.digitacao.componente;

import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.configurador.componente.ComponenteInterfaceamento;
import jalis.laboratorio.digitacao.Execucao;
import jalis.laboratorio.digitacao.TabelaSimbolos;
import jalis.laboratorio.digitacao.componente.ComponenteResultado;
import jalis.laboratorio.digitacao.evento.CampoEvento;
import jalis.laboratorio.digitacao.evento.CampoListener;
import jalis.laboratorio.digitacao.evento.ImagemDigitacaoListener;
import jalis.laboratorio.digitacao.evento.MensagemListener;
import jalis.laboratorio.util.parsers.ProtocoloCampoImportacao;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import org.apache.commons.codec.binary.Base64;

public class ImagemDigitacao
extends JLabel
implements MouseListener,
ComponenteInterfaceamento,
ComponenteResultado,
CampoListener {
    private Componente dono;
    private List<String> ligacoes = new ArrayList<String>();
    private boolean imprimir;
    private boolean estender;
    private ImageIcon imagem;
    private ImageIcon imagemTemp;
    private String campoBanco = "";
    private String campoInterfaceamento = "";
    private String condicao = "";
    private TabelaSimbolos tabela;
    private boolean removerVazio = true;
    private int ordem;
    private ArrayList<ImagemDigitacaoListener> listenerDigitacao = new ArrayList();

    public ImagemDigitacao() {
        super("<html><div align=\"center\">Clique para selecionar imagem</div></html>");
        this.setHorizontalAlignment(0);
        this.setHorizontalAlignment(0);
        this.setBorder(BorderFactory.createTitledBorder(""));
        this.addMouseListener(this);
    }

    @Override
    public void setDono(Componente dono) {
        this.dono = dono;
    }

    @Override
    public Componente getDono() {
        return this.dono;
    }

    public String getCampoDoBanco() {
        return this.campoBanco;
    }

    public void setCampoDoBanco(String campoBanco) {
        this.campoBanco = campoBanco;
    }

    @Override
    public String getNome() {
        return this.getName();
    }

    @Override
    public String getStringValor() {
        return this.getImagem();
    }

    @Override
    public boolean imprimir() {
        return this.imprimir;
    }

    public void setImprimir(boolean imprimir) {
        this.imprimir = imprimir;
    }

    public boolean getEstender() {
        return this.estender;
    }

    public void setEstender(boolean estender) {
        this.estender = estender;
    }

    public String getImagem() {
        return null != this.imagem && null != this.imagem.getImage() ? ImagemUtils.converterImagemParaBase64(this.imagem.getImage()) : "";
    }

    public void setImagem(String imagem) {
        if (imagem != null) {
            if (imagem.length() == 0) {
                this.imagemTemp = this.imagem = null;
            } else {
                try {
                    this.setImagem(new ImageIcon(new Base64().decode(imagem)));
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ImagemDigitacao: 144");
                }
            }
        }
    }

    public void setImagem(ImageIcon imagem) {
        if (imagem != null) {
            try {
                this.imagemTemp = this.imagem = imagem;
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ImagemDigitacao: 187");
            }
        } else {
            this.imagem = null;
            this.imagemTemp = null;
        }
    }

    @Override
    public boolean vazio() {
        return this.imagem == null;
    }

    @Override
    public void setRemoverVazio(boolean valor) {
        this.removerVazio = valor;
    }

    @Override
    public boolean removerVazio() {
        return this.removerVazio;
    }

    @Override
    public boolean salvarParcialmente() {
        return true;
    }

    @Override
    public List<String> getLigacoes() {
        return this.ligacoes;
    }

    public void setLigacoes(List<String> lig) {
        this.ligacoes.clear();
        this.ligacoes.addAll(lig);
    }

    @Override
    public void setDimensoes(Rectangle dim) {
        if (this.dono != null) {
            this.dono.setDimensoes(dim);
        }
        this.setBounds(dim);
    }

    @Override
    public void setDimensoes(int esquerda, int topo, int largura, int altura) {
        this.setDimensoes(new Rectangle(esquerda, topo, largura, altura));
    }

    @Override
    public Rectangle getDimensoes() {
        if (this.dono != null) {
            return this.dono.getDimensoes();
        }
        return new Rectangle();
    }

    @Override
    public int getAlinhamentoHorizontal() {
        return this.getHorizontalAlignment();
    }

    @Override
    public void setAlinhamentoHorizontal(int alinhamento) {
        this.setHorizontalAlignment(alinhamento);
    }

    public int getAlinhamentoVertical() {
        return this.getVerticalAlignment();
    }

    public void setAlinhamentoVertical(int alinhamento) {
        this.setVerticalAlignment(alinhamento);
    }

    @Override
    public void paint(Graphics g) {
        Dimension d = this.getSize();
        Graphics2D g2 = (Graphics2D)g;
        if (this.imagem != null) {
            if (this.estender) {
                Image redimensionada = ImagemUtils.redimensionarImagemComBiblioteca(this.imagem.getImage(), this.getWidth(), this.getHeight());
                g2.drawImage(redimensionada, 0, 0, null);
            } else {
                int x = 0;
                int y = 0;
                int hor = this.getHorizontalAlignment();
                int ver = this.getVerticalAlignment();
                int imgW = this.imagem.getIconWidth();
                int imgH = this.imagem.getIconHeight();
                int n = hor == 2 ? 0 : (x = hor == 4 ? d.width - imgW : (d.width - imgW) / 2);
                y = ver == 1 ? 0 : (ver == 3 ? d.height - imgH : (d.height - imgH) / 2);
                g2.drawImage(this.imagem.getImage(), x, y, this.imagem.getIconWidth(), this.imagem.getIconHeight(), null);
            }
            Rectangle botao = this.getRetanguloBotao();
            g2.setColor(Color.white);
            g2.fill(botao);
            g2.setColor(Color.black);
            g2.draw(botao);
            g2.setColor(Color.red);
            g2.setStroke(new BasicStroke(2.0f));
            g2.drawLine(botao.x + 3, botao.y + 3, botao.x + botao.width - 3, botao.y + botao.height - 3);
            g2.drawLine(botao.x + 3, botao.y + botao.height - 3, botao.x + botao.width - 3, botao.y + 3);
        } else {
            super.paint(g);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        ScreenUtil.requisitarFoco(this);
        if (this.imagem == null && e.getButton() == 1 && e.getClickCount() == 2) {
            if (this.listenerDigitacao.isEmpty()) {
                JFileChooser fc = ComponenteFactory.novoJFileChooser();
                fc.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo de imagem", "bmp", "jpg", "jpeg", "gif", "png"));
                if (fc.showOpenDialog(this.getTopLevelAncestor()) == 0) {
                    this.imagem = new ImageIcon(ImagemUtils.carregarImagem(fc.getSelectedFile().getPath()));
                }
            } else {
                this.fireImagemDigitacaoListener();
            }
            this.executar();
            this.repaint();
        } else if (e.getButton() == 1 && e.getClickCount() == 1 && this.getRetanguloBotao().contains(e.getPoint())) {
            this.imagem = null;
            this.repaint();
        }
    }

    private Rectangle getRetanguloBotao() {
        Dimension size = this.getSize();
        return new Rectangle(size.width - 12, 2, 10, 10);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public String getCampoInterfaceamento() {
        return this.campoInterfaceamento.trim().length() == 0 ? this.getNome() : this.campoInterfaceamento;
    }

    @Override
    public void setCampoInterfaceamento(String campo) {
        if (campo != null) {
            this.campoInterfaceamento = campo;
        }
    }

    @Override
    public void addCampoListener(CampoListener l) {
    }

    @Override
    public void addMensagemListener(MensagemListener l) {
    }

    public void addImagemDigitacaoListener(ImagemDigitacaoListener l) {
        if (!this.listenerDigitacao.contains(l)) {
            this.listenerDigitacao.add(l);
        }
    }

    public void removeImagemDigitacalListener(ImagemDigitacaoListener l) {
        if (this.listenerDigitacao.contains(l)) {
            this.listenerDigitacao.remove(l);
        }
    }

    private void fireImagemDigitacaoListener() {
        for (ImagemDigitacaoListener l : this.listenerDigitacao) {
            l.selecionarImagem(this);
        }
    }

    @Override
    public void carregarValorPadrao() {
    }

    @Override
    public boolean digitavel() {
        return false;
    }

    @Override
    public String getCampoDeImportacao() {
        return this.dono != null ? this.dono.getCampoImportacao().campoImportacao : "";
    }

    @Override
    public boolean isRelacionavelComCampoDeImportacao() {
        return this.dono != null ? this.dono.isRelacionavelComCampoDeImportacao() : false;
    }

    @Override
    public void limpar() {
        this.setImagem("");
    }

    @Override
    public void removeCampoListener(CampoListener l) {
    }

    @Override
    public void removeMensagemListener(MensagemListener l) {
    }

    @Override
    public void setComponentesFoco(List<Component> list) {
    }

    @Override
    public void setProcessarPerdaDeFoco(boolean flag) {
    }

    @Override
    public void setValor(Object valor) {
        if (valor != null && valor instanceof String) {
            this.setImagem(valor.toString());
        }
    }

    @Override
    public Object getValor() {
        return this.getImagem();
    }

    @Override
    public String getValorOriginal() {
        return null;
    }

    @Override
    public boolean resultadoAnterior() {
        return false;
    }

    public void setCondicao(String condicao) {
        if (condicao != null) {
            this.condicao = condicao;
        }
    }

    public String getCondicao() {
        return this.condicao;
    }

    public void setTabelaSimbolos(TabelaSimbolos tabela) {
        this.tabela = tabela;
    }

    public void executar() {
        if (this.tabela != null && this.getCondicao().trim().length() > 0) {
            Execucao exe = new Execucao(this.getCondicao(), this.tabela, 1);
            boolean res = exe.resultadoCondicao();
            if (!res) {
                this.imagem = null;
                this.setImprimir(res);
                this.repaint();
            } else if (this.imagemTemp != null && this.imagem == null) {
                this.imagem = this.imagemTemp;
                this.setImprimir(true);
                this.repaint();
            }
        }
    }

    @Override
    public void digitouValor(CampoEvento e) {
        this.executar();
    }

    @Override
    public Map<String, ProtocoloCampoImportacao> getMapCampoDeImportacao() {
        if (this.dono != null) {
            return this.dono.getMapCamposImportacao();
        }
        return null;
    }

    public int getOrdem() {
        return this.ordem;
    }

    public void setOrdem(int ordem) {
        this.ordem = ordem;
    }
}

