/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.digitacao.componente;

import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.configurador.componente.ComponenteInterfaceamento;
import jalis.laboratorio.digitacao.componente.ComponenteResultado;
import jalis.laboratorio.digitacao.componente.DocumentoHistorico;
import jalis.laboratorio.digitacao.evento.CampoEvento;
import jalis.laboratorio.digitacao.evento.CampoListener;
import jalis.laboratorio.digitacao.evento.MensagemListener;
import jalis.laboratorio.util.parsers.ProtocoloCampoImportacao;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JTextPane;

public class HistoricoDigitacao
extends JTextPane
implements ComponenteResultado,
ComponenteInterfaceamento {
    private Componente dono;
    private boolean imprimir;
    private boolean resultadoAnterior;
    private boolean removerVazio;
    private List<String> ligacoes = new ArrayList<String>();
    private CampoEvento evento;
    private DocumentoHistorico documento;
    private List<String> codigos = new ArrayList<String>();
    private String valorPadrao = "";
    private String campoInterfaceamento = "";

    public HistoricoDigitacao() {
        super.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                HistoricoDigitacao.this.fireDigitouValor();
            }

            @Override
            public void focusGained(FocusEvent e) {
                HistoricoDigitacao.this.fireDigitouValor();
            }
        });
        super.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 116) {
                    HistoricoDigitacao.this.fireDigitouValor();
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        this.setMargin(new Insets(0, 0, 0, 0));
        this.documento = new DocumentoHistorico(this);
        this.setDocument(this.documento);
        this.setBorder(BorderFactory.createLineBorder(this.getCaretColor(), 1));
    }

    @Override
    public boolean digitavel() {
        return true;
    }

    @Override
    public void setDono(Componente dono) {
        this.dono = dono;
    }

    @Override
    public Componente getDono() {
        return this.dono;
    }

    @Override
    public String getNome() {
        return this.getName();
    }

    @Override
    public Object getValor() {
        return this.vazio() ? null : this.getStringValor();
    }

    @Override
    public void setValor(Object valor) {
        if (valor != null) {
            String tmp = valor.toString();
            if (tmp.matches("\\-?\\d+")) {
                this.documento.setDescricao(this.documento.getDescricao(tmp));
            } else if (tmp.length() > 0) {
                this.documento.setDescricao(tmp);
            }
        }
    }

    @Override
    public void limpar() {
        this.documento.limpar();
    }

    @Override
    public void carregarValorPadrao() {
        this.setValor(this.valorPadrao);
    }

    @Override
    public boolean imprimir() {
        return this.imprimir;
    }

    @Override
    public boolean vazio() {
        return this.getStringValor().trim().length() == 0;
    }

    @Override
    public void setRemoverVazio(boolean valor) {
        this.removerVazio = valor;
    }

    @Override
    public boolean removerVazio() {
        return this.removerVazio;
    }

    @Override
    public boolean salvarParcialmente() {
        return true;
    }

    public void setValorPadrao(String valor) {
        if (valor != null) {
            this.valorPadrao = valor;
        }
    }

    public void setImprimir(boolean imprimir) {
        this.imprimir = imprimir;
    }

    @Override
    public List<String> getLigacoes() {
        return this.ligacoes;
    }

    public void setLigacoes(List<String> lig) {
        this.ligacoes.clear();
        this.ligacoes.addAll(lig);
    }

    @Override
    public boolean resultadoAnterior() {
        return this.resultadoAnterior;
    }

    public void setPermissaoAlterar(boolean permissao) {
        this.documento.setPermissaoAlterar(permissao);
    }

    @Override
    public void setProcessarPerdaDeFoco(boolean flag) {
        this.documento.setProcessar(flag);
    }

    public void setResultadoAnterior(boolean resultadoAnterior) {
        this.resultadoAnterior = resultadoAnterior;
    }

    @Override
    public void addCampoListener(CampoListener l) {
        this.listenerList.add(CampoListener.class, l);
    }

    @Override
    public void removeCampoListener(CampoListener l) {
        this.listenerList.remove(CampoListener.class, l);
    }

    @Override
    public void setDimensoes(Rectangle dim) {
        if (this.dono != null) {
            this.dono.setDimensoes(dim);
        }
        this.setBounds(dim);
    }

    @Override
    public void setDimensoes(int esquerda, int topo, int largura, int altura) {
        this.setDimensoes(new Rectangle(esquerda, topo, largura, altura));
    }

    @Override
    public Rectangle getDimensoes() {
        if (this.dono != null) {
            return this.dono.getDimensoes();
        }
        return new Rectangle();
    }

    @Override
    public String getStringValor() {
        try {
            return this.documento.getAtributos2Texto();
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public int getAlinhamentoHorizontal() {
        return 0;
    }

    @Override
    public void setAlinhamentoHorizontal(int alinhamento) {
    }

    public void setCodigoHistoricos(List<String> codigos) {
        this.codigos = codigos;
    }

    public void setHistoricos(Map<String, String> historicos, Map<String, String> historicosPorMnemonico) {
        if (historicos != null) {
            if (this.codigos.isEmpty()) {
                this.documento.setHistoricos(historicos, historicosPorMnemonico);
            } else {
                HashMap<String, String> tmp = new HashMap<String, String>();
                for (String cod : historicos.keySet()) {
                    if (!this.codigos.contains(cod)) continue;
                    tmp.put(cod, historicos.get(cod));
                }
                this.documento.setHistoricos(tmp, historicosPorMnemonico);
            }
        }
    }

    public void setQuantidade(int qtde) {
        this.documento.setQuantidade(qtde);
    }

    @Override
    public void setComponentesFoco(List<Component> list) {
        this.documento.setComponentesFoco(list);
    }

    @Override
    public void setCampoInterfaceamento(String campo) {
        if (campo != null) {
            this.campoInterfaceamento = campo;
        }
    }

    @Override
    public String getCampoInterfaceamento() {
        return this.campoInterfaceamento.trim().length() == 0 ? this.getNome() : this.campoInterfaceamento;
    }

    @Override
    public String getCampoDeImportacao() {
        return this.dono != null ? this.dono.getCampoImportacao().campoImportacao : "";
    }

    @Override
    public boolean isRelacionavelComCampoDeImportacao() {
        return this.dono != null ? this.dono.isRelacionavelComCampoDeImportacao() : false;
    }

    private boolean contem(String[] arr, String valor) {
        for (int i = 0; i < arr.length; ++i) {
            if (!arr[i].equalsIgnoreCase(valor)) continue;
            return true;
        }
        return false;
    }

    protected void fireDigitouValor() {
        Object[] ouvintes = this.listenerList.getListenerList();
        for (int i = ouvintes.length - 2; i >= 0; i -= 2) {
            if (ouvintes[i] != CampoListener.class) continue;
            if (this.evento == null) {
                this.evento = new CampoEvento(this);
            }
            ((CampoListener)ouvintes[i + 1]).digitouValor(this.evento);
        }
    }

    @Override
    public void addMensagemListener(MensagemListener l) {
    }

    @Override
    public void removeMensagemListener(MensagemListener l) {
    }

    @Override
    public String getValorOriginal() {
        return this.getStringValor();
    }

    @Override
    public Map<String, ProtocoloCampoImportacao> getMapCampoDeImportacao() {
        if (this.dono != null) {
            return this.dono.getMapCamposImportacao();
        }
        return null;
    }
}

