/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.digitacao.componente;

import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.configurador.componente.Grafico;
import jalis.laboratorio.digitacao.Execucao;
import jalis.laboratorio.digitacao.TabelaSimbolos;
import jalis.laboratorio.digitacao.componente.ComponenteDigitacao;
import jalis.laboratorio.digitacao.evento.CampoEvento;
import jalis.laboratorio.digitacao.evento.CampoListener;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;

public class GraficoResultadoAnteriorDigitacao
extends JComponent
implements ComponenteDigitacao,
CampoListener {
    private Grafico dono;
    private List<String> valores = new ArrayList<String>();
    private List<String> valoresAux = new ArrayList<String>();
    private List<String> datas = new ArrayList<String>();
    private List<String> horas = new ArrayList<String>();
    private boolean ordemCrescente = false;
    private TabelaSimbolos tabela;
    private String tagResultado = "";
    private boolean imprimir;
    private String condicao = "";
    private int posicaoExpressaoAdicional = -1;

    @Override
    public Rectangle getDimensoes() {
        if (this.dono != null) {
            return this.dono.getDimensoes();
        }
        return new Rectangle();
    }

    @Override
    public Componente getDono() {
        return this.dono;
    }

    @Override
    public String getNome() {
        if (this.dono != null) {
            return this.dono.getNome();
        }
        return "";
    }

    @Override
    public String getName() {
        return this.getNome();
    }

    public void setCondicao(String condicao) {
        if (condicao != null) {
            this.condicao = condicao;
        }
    }

    public String getCondicao() {
        return this.condicao;
    }

    @Override
    public void setDimensoes(int esquerda, int topo, int largura, int altura) {
        this.setDimensoes(new Rectangle(esquerda, topo, largura, altura));
    }

    @Override
    public void setDimensoes(Rectangle rec) {
        if (this.dono != null) {
            this.dono.setDimensoes(rec);
        }
    }

    @Override
    public int getAlinhamentoHorizontal() {
        return 0;
    }

    @Override
    public List<String> getLigacoes() {
        return this.dono != null ? this.dono.getLigacoes() : new ArrayList();
    }

    @Override
    public String getStringValor() {
        StringBuilder bui = new StringBuilder("<valorGrafico>");
        if (this.dono != null) {
            bui.append(StringUtil.getTag("valor", this.valores));
            bui.append(StringUtil.getTag("rotulo1", this.dono.getTipoRotulo() == 2 || this.dono.getTipoRotulo() == 0 ? this.datas : this.horas));
            if (this.dono.getTipoRotulo() == 2 || this.dono.getTipoRotulo() == 3) {
                bui.append(StringUtil.getTag("rotulo2", this.dono.getTipoRotulo() == 2 ? this.horas : this.datas));
            }
        }
        return bui.append("</valorGrafico>").toString();
    }

    @Override
    public boolean imprimir() {
        return this.dono != null ? this.dono.getImprimir() : false;
    }

    @Override
    public boolean removerVazio() {
        return this.dono != null ? this.dono.getRemoverVazio() : false;
    }

    @Override
    public boolean salvarParcialmente() {
        return false;
    }

    @Override
    public void setAlinhamentoHorizontal(int alinhamento) {
        if (this.dono != null) {
            this.dono.setAlinhamentoHorizontal(alinhamento);
        }
    }

    @Override
    public void setDono(Componente dono) {
        if (dono instanceof Grafico && ((Grafico)dono).getTipoGrafico() == 0) {
            this.dono = (Grafico)dono;
        }
    }

    @Override
    public boolean vazio() {
        return this.valores.isEmpty();
    }

    public void setImprimir(boolean imprimir) {
        this.dono.setImprimir(imprimir);
    }

    public void executar() {
        if (this.tabela != null && this.getCondicao().trim().length() > 0) {
            Execucao exe = new Execucao(this.getCondicao(), this.tabela, 1);
            boolean res = exe.resultadoCondicao();
            if (!res) {
                this.valoresAux.addAll(this.valores);
                this.valores.clear();
                this.setImprimir(res);
                this.setVisible(false);
            } else {
                this.valores.addAll(this.valoresAux);
                this.valoresAux.clear();
                this.setImprimir(true);
                this.setVisible(true);
            }
        }
        this.repaint();
    }

    public void setResultadosAnteriores(Map<Integer, String> res, boolean ordemCrescente, String resultadoAtual) {
        String expressaoAdicional;
        if (res != null && this.dono != null) {
            this.valores.clear();
            this.datas.clear();
            this.horas.clear();
            this.ordemCrescente = ordemCrescente;
            int posInicial = 1;
            if (ordemCrescente && res.size() > this.dono.getQuantidadeResultados()) {
                posInicial = res.size() - this.dono.getQuantidadeResultados() + 1;
            }
            int qtdeAdicionada = this.dono.getQuantidadeResultados();
            for (int i = posInicial; i <= res.size() && qtdeAdicionada > 0; ++i) {
                String temp = StringUtil.getTagEmMinusculas(res.get(i));
                if (temp == null) continue;
                String valor = null;
                if (!Funcoes.textoVazio(this.dono.getTagResultado()) && !this.dono.getTagResultado().equalsIgnoreCase("null")) {
                    valor = StringUtil.getValorAtributoTagCampo("tagResultado".toLowerCase(), this.dono.getTagResultado().toLowerCase(), temp);
                }
                if (Funcoes.textoVazio(valor)) {
                    valor = StringUtil.getValor(temp, this.dono.getOrigem().toLowerCase());
                }
                if (Funcoes.textoVazio(valor)) continue;
                this.valores.add(valor);
                this.datas.add(StringUtil.getValor(temp, "dataresultado"));
                this.horas.add(StringUtil.getValor(temp, "horaresultado"));
                --qtdeAdicionada;
            }
        }
        if (!Funcoes.textoVazio(expressaoAdicional = ((Grafico)this.dono.getDono()).getExpressaoAdicional()) && !Funcoes.textoVazio(resultadoAtual)) {
            Execucao exeRotulo = new Execucao(this.dono.getRotuloAdicional(), this.tabela, 0);
            Object temp = exeRotulo.resultadoExpressao();
            String rotuloAdicionalLinha1 = "#erro";
            String rotuloAdicionalLinha2 = "#erro";
            if (temp != null) {
                if (temp instanceof Date) {
                    rotuloAdicionalLinha1 = Funcoes.formataData("dd/MM/yyyy", (Date)temp);
                    rotuloAdicionalLinha2 = Funcoes.formataData("HH:mm", (Date)temp);
                } else if (temp instanceof String) {
                    if (temp.toString().matches("(0[1-9]|[12]\\d|3[01])/(0[1-9]|1[012])/\\d{4} ([01]\\d|2[0-3]):[0-5]\\d")) {
                        String[] linhas = temp.toString().split(" ");
                        rotuloAdicionalLinha1 = linhas[0];
                        rotuloAdicionalLinha2 = linhas[1];
                    } else if (temp.toString().matches("(0[1-9]|[12]\\d|3[01])/(0[1-9]|1[012])(/(\\d{2}|\\d{4}))?")) {
                        rotuloAdicionalLinha1 = temp.toString();
                        rotuloAdicionalLinha2 = "";
                    } else if (temp.toString().matches("([01]\\d|2[0-3]):[0-5]\\d")) {
                        rotuloAdicionalLinha1 = "";
                        rotuloAdicionalLinha2 = temp.toString();
                    } else {
                        rotuloAdicionalLinha1 = temp.toString();
                        rotuloAdicionalLinha2 = "";
                    }
                }
            }
            if (this.posicaoExpressaoAdicional > -1) {
                this.valores.remove(this.posicaoExpressaoAdicional);
                this.datas.remove(this.posicaoExpressaoAdicional);
                this.horas.remove(this.posicaoExpressaoAdicional);
            } else if (this.dono.getQuantidadeResultados() == this.valores.size()) {
                if (ordemCrescente) {
                    this.valores.remove(0);
                    this.datas.remove(0);
                    this.horas.remove(0);
                } else {
                    this.valores.remove(this.valores.size() - 1);
                    this.datas.remove(this.datas.size() - 1);
                    this.horas.remove(this.horas.size() - 1);
                }
            }
            if (ordemCrescente) {
                this.valores.add(resultadoAtual);
                this.datas.add(rotuloAdicionalLinha1.toString());
                this.horas.add(rotuloAdicionalLinha2.toString());
                this.posicaoExpressaoAdicional = this.valores.size() - 1;
            } else {
                this.valores.add(0, resultadoAtual);
                this.datas.add(0, rotuloAdicionalLinha1.toString());
                this.horas.add(0, rotuloAdicionalLinha2.toString());
                this.posicaoExpressaoAdicional = 0;
            }
        }
    }

    public static String tratarMaiorMenorResultadoAnterior(String valor, String mascara) {
        if (Funcoes.textoVazio(valor) || !valor.matches("#+(\\.#+)*(\\,#+)?")) {
            return valor;
        }
        if (valor.indexOf("<") > -1) {
            valor = valor.replace("<", "");
            valor = valor.replace(" ", "");
            valor = valor.replace(".", "");
            valor = valor.replace(",", ".");
            BigDecimal valorAux = new BigDecimal(valor);
            valorAux = valorAux.subtract(new BigDecimal("0.1"));
            return GraficoResultadoAnteriorDigitacao.formatar(valorAux, mascara);
        }
        if (valor.indexOf(">") > -1) {
            valor = valor.replace(">", "");
            valor = valor.replace(" ", "");
            valor = valor.replace(".", "");
            valor = valor.replace(",", ".");
            BigDecimal valorAux = new BigDecimal(valor);
            valorAux = valorAux.add(new BigDecimal("0.1"));
            return GraficoResultadoAnteriorDigitacao.formatar(valorAux, mascara);
        }
        return valor;
    }

    private static String formatar(BigDecimal valor, String mascara) {
        if (valor == null) {
            valor = BigDecimal.ZERO;
        }
        BigDecimal[] valores = valor.divideAndRemainder(BigDecimal.ONE);
        String inteira = String.valueOf(valores[0].intValue());
        String decimal = String.valueOf(valores[1].doubleValue());
        String formatado = "";
        int posValor = inteira.length() - 1;
        int posMascara = mascara.indexOf(",") - 1;
        while (posValor >= 0) {
            boolean isPonto = false;
            if (posMascara >= 0) {
                isPonto = mascara.substring(posMascara, posMascara + 1).equals(".");
            }
            if (isPonto) {
                formatado = "." + formatado;
                ++posValor;
            } else {
                formatado = inteira.substring(posValor, posValor + 1) + formatado;
            }
            --posValor;
            --posMascara;
        }
        formatado = formatado + "," + decimal.substring(decimal.indexOf(".") + 1);
        for (int i = formatado.length() - formatado.indexOf(","); i < mascara.length() - mascara.indexOf(","); ++i) {
            formatado = formatado + "0";
        }
        return formatado;
    }

    @Override
    public void paint(Graphics g) {
        if (this.dono != null) {
            int tipo;
            Graphics2D g2 = (Graphics2D)g;
            this.dono.desenharGrafico(g2);
            if (this.dono.getExpressaoAdicional().trim().length() > 0) {
                Execucao exe = new Execucao(this.dono.getExpressaoAdicional(), this.tabela, 0);
                Object valorAdicional = exe.resultadoExpressao();
                String rotuloAdicionalLinha1 = "#erro";
                String rotuloAdicionalLinha2 = "#erro";
                Execucao exeRotulo = new Execucao(this.dono.getRotuloAdicional(), this.tabela, 0);
                Object temp = exeRotulo.resultadoExpressao();
                if (temp != null) {
                    if (temp instanceof Date) {
                        rotuloAdicionalLinha1 = Funcoes.formataData("dd/MM/yyyy", (Date)temp);
                        rotuloAdicionalLinha2 = Funcoes.formataData("HH:mm", (Date)temp);
                    } else if (temp instanceof String) {
                        if (temp.toString().matches("(0[1-9]|[12]\\d|3[01])/(0[1-9]|1[012])/\\d{4} ([01]\\d|2[0-3]):[0-5]\\d")) {
                            String[] linhas = temp.toString().split(" ");
                            rotuloAdicionalLinha1 = linhas[0];
                            rotuloAdicionalLinha2 = linhas[1];
                        } else if (temp.toString().matches("(0[1-9]|[12]\\d|3[01])/(0[1-9]|1[012])(/(\\d{2}|\\d{4}))?")) {
                            rotuloAdicionalLinha1 = temp.toString();
                            rotuloAdicionalLinha2 = "";
                        } else if (temp.toString().matches("([01]\\d|2[0-3]):[0-5]\\d")) {
                            rotuloAdicionalLinha1 = "";
                            rotuloAdicionalLinha2 = temp.toString();
                        } else {
                            rotuloAdicionalLinha1 = temp.toString();
                            rotuloAdicionalLinha2 = "";
                        }
                    }
                }
                if (valorAdicional != null) {
                    if (this.posicaoExpressaoAdicional > -1) {
                        this.valores.remove(this.posicaoExpressaoAdicional);
                        this.datas.remove(this.posicaoExpressaoAdicional);
                        this.horas.remove(this.posicaoExpressaoAdicional);
                    } else if (this.dono.getQuantidadeResultados() == this.valores.size()) {
                        if (this.ordemCrescente) {
                            this.valores.remove(0);
                            this.datas.remove(0);
                            this.horas.remove(0);
                        } else {
                            this.valores.remove(this.valores.size() - 1);
                            this.datas.remove(this.datas.size() - 1);
                            this.horas.remove(this.horas.size() - 1);
                        }
                    }
                    if (this.ordemCrescente) {
                        if (!Funcoes.textoVazio(valorAdicional.toString())) {
                            this.valores.add(valorAdicional.toString());
                            this.datas.add(rotuloAdicionalLinha1.toString());
                            this.horas.add(rotuloAdicionalLinha2.toString());
                            this.posicaoExpressaoAdicional = this.valores.size() - 1;
                        }
                    } else if (!Funcoes.textoVazio(valorAdicional.toString())) {
                        this.valores.add(0, valorAdicional.toString());
                        this.datas.add(0, rotuloAdicionalLinha1.toString());
                        this.horas.add(0, rotuloAdicionalLinha2.toString());
                        this.posicaoExpressaoAdicional = 0;
                    }
                }
            }
            String[] rot1 = (tipo = this.dono.getTipoRotulo()) == 0 || tipo == 2 ? this.datas.toArray(new String[this.datas.size()]) : this.horas.toArray(new String[this.horas.size()]);
            String[] rot2 = null;
            if (tipo == 2 || tipo == 3) {
                rot2 = tipo == 2 ? this.horas.toArray(new String[this.horas.size()]) : this.datas.toArray(new String[this.datas.size()]);
            }
            this.dono.desenharRotulos(g2, this.dono.getQuantidadeResultados(), rot1, rot2);
            this.dono.desenharValores(g2, this.dono.getQuantidadeResultados(), this.valores.toArray(new String[this.valores.size()]), null);
        }
    }

    @Override
    public void setRemoverVazio(boolean valor) {
    }

    public void setTabelaSimbolos(TabelaSimbolos tabela) {
        this.tabela = tabela;
    }

    @Override
    public void digitouValor(CampoEvento e) {
        this.executar();
    }

    public void atualizar() {
        this.repaint();
    }

    public void setTagResultado(String tag) {
        this.tagResultado = tag;
    }

    public String getTagResultado() {
        return this.tagResultado;
    }
}

