/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.digitacao.componente;

import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.configurador.componente.Grafico;
import jalis.laboratorio.digitacao.Execucao;
import jalis.laboratorio.digitacao.TabelaSimbolos;
import jalis.laboratorio.digitacao.componente.ComponenteDigitacao;
import jalis.laboratorio.digitacao.evento.CampoEvento;
import jalis.laboratorio.digitacao.evento.CampoListener;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.swing.JComponent;

public class GraficoReferenciaDigitacao
extends JComponent
implements ComponenteDigitacao,
CampoListener {
    private Grafico dono;
    private TabelaSimbolos tabela;
    private Execucao exe = null;
    private boolean res = true;
    private List<String> valores = new ArrayList<String>();
    private List<String> valoresAux = new ArrayList<String>();
    private List<String> linhasFixas = new ArrayList<String>();
    private String tagResultado = "";
    private boolean imprimir;
    private String condicao = "";

    public void setCondicao(String condicao) {
        if (condicao != null) {
            this.condicao = condicao;
        }
    }

    public String getCondicao() {
        return this.condicao;
    }

    @Override
    public List<String> getLigacoes() {
        return this.dono != null ? this.dono.getLigacoes() : new ArrayList();
    }

    public List<String> getCampos() {
        return this.dono != null ? this.dono.getCampos() : new ArrayList();
    }

    @Override
    public String getStringValor() {
        StringBuilder bui = new StringBuilder("<valorGrafico>");
        bui.append(StringUtil.getTag("valor", this.valores));
        if (this.dono != null) {
            bui.append(StringUtil.getTag("rotulo1", this.dono.getRotulos()));
        }
        return bui.append("</valorGrafico>").toString();
    }

    @Override
    public boolean imprimir() {
        return this.dono != null ? this.dono.getImprimir() : false;
    }

    public void setImprimir(boolean imprimir) {
        this.dono.setImprimir(imprimir);
    }

    @Override
    public boolean removerVazio() {
        return this.dono != null ? this.dono.getRemoverVazio() : false;
    }

    @Override
    public boolean salvarParcialmente() {
        return false;
    }

    @Override
    public int getAlinhamentoHorizontal() {
        return 0;
    }

    @Override
    public void setAlinhamentoHorizontal(int alinhamento) {
    }

    @Override
    public void setDono(Componente dono) {
        if (dono instanceof Grafico && ((Grafico)dono).getTipoGrafico() == 2) {
            this.dono = (Grafico)dono;
            this.valores.clear();
            if (((Grafico)dono).getMultiplosCampos()) {
                for (int i = 0; i < this.dono.getCampos().size(); ++i) {
                    this.valores.add("");
                }
            } else {
                this.valores.add("");
            }
        }
    }

    @Override
    public void setRemoverVazio(boolean valor) {
    }

    @Override
    public boolean vazio() {
        boolean isVazio = false;
        if (Funcoes.textoVazio(this.getCondicao())) {
            isVazio = true;
        } else {
            this.exe = new Execucao(this.getCondicao(), this.tabela, 1);
            this.res = this.exe.resultadoCondicao();
            if (!this.res) {
                return true;
            }
        }
        return this.valores.isEmpty() && isVazio;
    }

    @Override
    public Rectangle getDimensoes() {
        return this.dono != null ? this.dono.getDimensoes() : new Rectangle();
    }

    @Override
    public Componente getDono() {
        return this.dono;
    }

    @Override
    public String getNome() {
        return this.dono != null ? this.dono.getNome() : "";
    }

    @Override
    public String getName() {
        return this.getNome();
    }

    @Override
    public void setDimensoes(int esquerda, int topo, int largura, int altura) {
        this.setDimensoes(new Rectangle(esquerda, topo, largura, altura));
    }

    @Override
    public void setDimensoes(Rectangle rec) {
        if (this.dono != null) {
            this.dono.setDimensoes(rec);
        }
    }

    public void setTabelaSimbolos(TabelaSimbolos tabela) {
        this.tabela = tabela;
    }

    @Override
    public void digitouValor(CampoEvento e) {
        this.executar();
    }

    public void executar() {
        this.valores.clear();
        this.atualizar();
        if (this.tabela != null && this.getCondicao().trim().length() > 0) {
            this.exe = new Execucao(this.getCondicao(), this.tabela, 1);
            this.res = this.exe.resultadoCondicao();
            if (!this.res) {
                this.setImprimir(this.res);
                this.setVisible(false);
            } else {
                this.setImprimir(true);
                this.setVisible(true);
            }
        }
        this.repaint();
    }

    public void atualizar() {
        if (this.dono != null && this.tabela != null) {
            if (this.dono.getMultiplosCampos()) {
                List<String> campos = this.dono.getCampos();
                for (int i = 0; i < campos.size(); ++i) {
                    Object valor = this.tabela.getValor(campos.get(i));
                    this.valores.add(valor == null ? "" : valor.toString());
                }
                this.buscarMaiorValor();
            } else {
                Execucao exe;
                Object res;
                String campo = this.dono.getCampoValor();
                Object valor = this.tabela.getValor(campo);
                this.valores.add(0, valor == null ? "" : valor.toString());
                if (this.dono.getValorMaximoResultado() && valor != null) {
                    Double aux = Double.parseDouble(valor.toString()) + (double)this.dono.getIntervaloEixoY();
                    this.dono.setValorMaximoY(String.valueOf(aux));
                }
                if (!this.dono.getMultiplosCampos() && this.dono.getExpressaoEixoX().trim().length() > 0 && this.dono.getRetornoExpressaoEixoX().trim().length() == 0 && (res = (exe = new Execucao(this.dono.getExpressaoEixoX(), this.tabela, 0)).resultadoExpressao()) instanceof Number && !(res instanceof Float)) {
                    this.dono.setRetornoExpressaoEixoX(String.valueOf((Integer)res));
                }
            }
        }
        this.repaint();
    }

    private void buscarMaiorValor() {
        Optional<Double> resultMaiorValor;
        if (this.dono.getValorMaximoResultado() && (resultMaiorValor = this.valores.stream().filter(v -> v != "").map(v -> Double.parseDouble(v)).max(Double::compare)).isPresent()) {
            this.dono.setValorMaximoY(String.valueOf(resultMaiorValor.get() + Double.parseDouble(this.dono.getIntervaloLinhas())));
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.dono != null) {
            Execucao exe;
            Object res;
            Graphics2D g2 = (Graphics2D)g;
            this.dono.desenharGrafico(g2);
            this.dono.desenharIntervaloLinhas(g2);
            this.dono.desenhaLinhaFixa(g2);
            List<String> tmp = this.dono.getRotulos();
            ArrayList<String> rot = new ArrayList<String>();
            if (tmp.size() > 0) {
                for (String xml : tmp) {
                    rot.add(StringUtil.getValor(xml, "titulo"));
                }
            }
            this.dono.desenharRotulos(g2, rot.size(), rot.toArray(new String[rot.size()]), null);
            Integer pontoFaixa = null;
            if (!this.dono.getMultiplosCampos() && this.dono.getExpressaoEixoX().trim().length() > 0 && (res = (exe = new Execucao(this.dono.getExpressaoEixoX(), this.tabela, 0)).resultadoExpressao()) instanceof Number && !(res instanceof Float)) {
                pontoFaixa = (Integer)res;
                this.dono.setRetornoExpressaoEixoX(String.valueOf(res));
            }
            this.dono.desenharValores(g2, rot.size(), this.valores.toArray(new String[this.valores.size()]), pontoFaixa);
        }
    }

    private int getIndiceCampo(String campo) {
        return this.dono.getCampos().indexOf(campo.toLowerCase());
    }

    public List<String> getLinhasFixas() {
        return this.linhasFixas;
    }

    public void setLinhasFixas(List<String> linhasFixas) {
        this.linhasFixas = linhasFixas;
    }
}

