/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.digitacao.componente;

import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.configurador.componente.Grafico;
import jalis.laboratorio.digitacao.Execucao;
import jalis.laboratorio.digitacao.TabelaSimbolos;
import jalis.laboratorio.digitacao.componente.ComponenteDigitacao;
import jalis.laboratorio.digitacao.evento.CampoEvento;
import jalis.laboratorio.digitacao.evento.CampoListener;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class GraficoQuadranteDigitacao
extends JComponent
implements ComponenteDigitacao,
CampoListener {
    private Grafico dono;
    private TabelaSimbolos tabela;
    private String tagResultado = "";
    private boolean imprimir;
    private String condicao = "";
    Execucao exe = null;
    boolean res = true;

    @Override
    public List<String> getLigacoes() {
        return this.dono != null ? this.dono.getLigacoes() : new ArrayList();
    }

    public List<String> getCampos() {
        return this.dono != null ? this.dono.getCampos() : new ArrayList();
    }

    @Override
    public String getStringValor() {
        StringBuilder bui = new StringBuilder("<valorGrafico>");
        if (this.dono != null) {
            this.executarExpressao();
            bui.append(StringUtil.getTag("retornoExpressaoEixoX", this.dono.getRetornoExpressaoEixoX()));
            bui.append(StringUtil.getTag("retornoExpressaoEixoY", this.dono.getRetornoExpressaoEixoY()));
        }
        return bui.append("</valorGrafico>").toString();
    }

    @Override
    public boolean imprimir() {
        return this.dono != null ? this.dono.getImprimir() : false;
    }

    @Override
    public boolean removerVazio() {
        return this.dono != null ? this.dono.getRemoverVazio() : false;
    }

    @Override
    public boolean salvarParcialmente() {
        return false;
    }

    @Override
    public int getAlinhamentoHorizontal() {
        return 0;
    }

    @Override
    public void setAlinhamentoHorizontal(int alinhamento) {
    }

    @Override
    public void setDono(Componente dono) {
        if (dono instanceof Grafico && ((Grafico)dono).getTipoGrafico() == 3) {
            this.dono = (Grafico)dono;
        }
    }

    @Override
    public void setRemoverVazio(boolean valor) {
    }

    @Override
    public boolean vazio() {
        boolean isVazio = false;
        if (Funcoes.textoVazio(this.getCondicao())) {
            isVazio = false;
        } else {
            this.exe = new Execucao(this.getCondicao(), this.tabela, 1);
            this.res = this.exe.resultadoCondicao();
            if (!this.res) {
                return true;
            }
        }
        return isVazio;
    }

    @Override
    public Rectangle getDimensoes() {
        return this.dono != null ? this.dono.getDimensoes() : new Rectangle();
    }

    @Override
    public Componente getDono() {
        return this.dono;
    }

    @Override
    public String getNome() {
        return this.dono != null ? this.dono.getNome() : "";
    }

    @Override
    public String getName() {
        return this.getNome();
    }

    @Override
    public void setDimensoes(int esquerda, int topo, int largura, int altura) {
        this.setDimensoes(new Rectangle(esquerda, topo, largura, altura));
    }

    @Override
    public void setDimensoes(Rectangle rec) {
        if (this.dono != null) {
            this.dono.setDimensoes(rec);
        }
    }

    public void setTabelaSimbolos(TabelaSimbolos tabela) {
        this.tabela = tabela;
    }

    @Override
    public void digitouValor(CampoEvento e) {
        this.executar();
    }

    public void setCondicao(String condicao) {
        if (condicao != null) {
            this.condicao = condicao;
        }
    }

    public String getCondicao() {
        return this.condicao;
    }

    public void setImprimir(boolean imprimir) {
        this.dono.setImprimir(imprimir);
    }

    public void executar() {
        if (this.tabela != null && this.getCondicao().trim().length() > 0) {
            this.exe = new Execucao(this.getCondicao(), this.tabela, 1);
            this.res = this.exe.resultadoCondicao();
            if (!this.res) {
                this.setImprimir(this.res);
                this.setVisible(false);
            } else {
                this.setImprimir(true);
                this.setVisible(true);
            }
        }
        this.repaint();
    }

    public void atualizar() {
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        if (this.dono != null) {
            Graphics2D g2 = (Graphics2D)g;
            this.dono.desenharGrafico(g2);
            List<String> rot = this.dono.getRotulos();
            this.dono.desenharRotulos(g2, rot.size(), rot.toArray(new String[rot.size()]), null);
            this.executarExpressao();
            this.dono.desenharValores(g2, rot.size(), null, null, new Double(this.dono.getRetornoExpressaoEixoX()), new Double(this.dono.getRetornoExpressaoEixoY()));
        }
    }

    private int getIndiceCampo(String campo) {
        return this.dono.getCampos().indexOf(campo.toLowerCase());
    }

    private void executarExpressao() {
        this.exe = new Execucao(this.dono.getExpressaoEixoX(), this.tabela, 0);
        Object eixoX = this.exe.resultadoExpressao();
        this.exe = new Execucao(this.dono.getExpressaoEixoY(), this.tabela, 0);
        Object eixoY = this.exe.resultadoExpressao();
        this.dono.setRetornoExpressaoEixoX(eixoX != null ? new Double(eixoX.toString()).toString() : "0");
        this.dono.setRetornoExpressaoEixoY(eixoY != null ? new Double(eixoY.toString()).toString() : "0");
    }
}

