/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.digitacao.componente;

import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.configurador.componente.Externo;
import jalis.laboratorio.digitacao.componente.ComponenteResultado;
import jalis.laboratorio.digitacao.evento.CampoListener;
import jalis.laboratorio.digitacao.evento.MensagemListener;
import jalis.laboratorio.util.parsers.ProtocoloCampoImportacao;
import jalis.util.DocumentoLimite;
import jalis.util.StringUtil;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JTextField;

public class ExternoDigitacao
extends JTextField
implements ComponenteResultado {
    private Externo dono;

    public ExternoDigitacao() {
        this.setFocusable(false);
        this.setEditable(false);
        this.setBorder(null);
        this.setDocument(new DocumentoLimite(this));
    }

    public String getCampoExterno() {
        return this.dono == null ? "" : this.dono.getCampoExterno();
    }

    @Override
    public void setDono(Componente dono) {
        if (dono instanceof Externo) {
            this.dono = (Externo)dono;
        }
    }

    @Override
    public String getStringValor() {
        return this.getText();
    }

    @Override
    public boolean imprimir() {
        return this.dono != null ? this.dono.getImprimir() : false;
    }

    @Override
    public boolean vazio() {
        return this.getStringValor().matches("[ |,|.|:|/]*");
    }

    @Override
    public boolean removerVazio() {
        return this.dono == null ? false : this.dono.getRemoverVazio();
    }

    @Override
    public void setRemoverVazio(boolean valor) {
        if (this.dono != null) {
            this.dono.setRemoverVazio(valor);
        }
    }

    @Override
    public boolean salvarParcialmente() {
        return true;
    }

    @Override
    public List<String> getLigacoes() {
        return this.dono == null ? new ArrayList() : this.dono.getLigacoes();
    }

    @Override
    public int getAlinhamentoHorizontal() {
        return this.getHorizontalAlignment();
    }

    @Override
    public void setAlinhamentoHorizontal(int alinhamento) {
        this.setHorizontalAlignment(alinhamento);
    }

    @Override
    public Componente getDono() {
        return this.dono;
    }

    @Override
    public Rectangle getDimensoes() {
        return this.dono == null ? new Rectangle() : this.dono.getDimensoes();
    }

    @Override
    public String getNome() {
        return this.dono == null ? "" : this.dono.getNome();
    }

    @Override
    public void setDimensoes(Rectangle rec) {
        if (this.dono != null) {
            this.dono.setDimensoes(rec);
        }
        this.setBounds(rec);
    }

    @Override
    public void setDimensoes(int esquerda, int topo, int largura, int altura) {
        this.setDimensoes(new Rectangle(esquerda, topo, largura, altura));
    }

    @Override
    public Object getValor() {
        return this.vazio() ? null : StringUtil.getValorString(this.getText());
    }

    @Override
    public boolean resultadoAnterior() {
        return this.dono == null ? false : this.dono.getResultadoAnterior();
    }

    @Override
    public void setValor(Object valor) {
        if (valor != null) {
            this.setText(valor.toString());
        }
    }

    @Override
    public void limpar() {
        this.setText("");
    }

    @Override
    public void carregarValorPadrao() {
    }

    @Override
    public void setProcessarPerdaDeFoco(boolean flag) {
    }

    @Override
    public void addCampoListener(CampoListener l) {
    }

    @Override
    public void removeCampoListener(CampoListener l) {
    }

    @Override
    public void addMensagemListener(MensagemListener l) {
    }

    @Override
    public void removeMensagemListener(MensagemListener l) {
    }

    @Override
    public boolean digitavel() {
        return false;
    }

    @Override
    public void setComponentesFoco(List<Component> list) {
    }

    @Override
    public String getCampoDeImportacao() {
        return this.dono != null ? this.dono.getCampoImportacao().campoImportacao : "";
    }

    @Override
    public boolean isRelacionavelComCampoDeImportacao() {
        return this.dono != null ? this.dono.isRelacionavelComCampoDeImportacao() : false;
    }

    @Override
    public String getValorOriginal() {
        return this.getStringValor();
    }

    @Override
    public Map<String, ProtocoloCampoImportacao> getMapCampoDeImportacao() {
        if (this.dono != null) {
            return this.dono.getMapCamposImportacao();
        }
        return null;
    }
}

