/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.digitacao.componente;

import jalis.laboratorio.configurador.ValoresReferencia;
import jalis.laboratorio.configurador.componente.Campo;
import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.configurador.componente.Expressao;
import jalis.laboratorio.configurador.expressao.Token;
import jalis.laboratorio.digitacao.Execucao;
import jalis.laboratorio.digitacao.TabelaSimbolos;
import jalis.laboratorio.digitacao.componente.ComponenteResultado;
import jalis.laboratorio.digitacao.componente.ComponenteValor;
import jalis.laboratorio.digitacao.evento.CampoEvento;
import jalis.laboratorio.digitacao.evento.CampoListener;
import jalis.laboratorio.digitacao.evento.MensagemListener;
import jalis.laboratorio.util.parsers.ProtocoloCampoImportacao;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;

public class ExpressaoDigitacao
extends JLabel
implements ComponenteResultado,
CampoListener {
    private Componente dono;
    private boolean imprimir;
    private boolean resultadoAnterior;
    private boolean removerVazio;
    private TabelaSimbolos tabela;
    private List<String> ligacoes = new ArrayList<String>();
    private String expressao = "";
    private CampoEvento evento;
    private String mascara;
    private ValoresReferencia valores;
    private final Color background = this.getBackground();

    @Override
    public boolean digitavel() {
        return false;
    }

    @Override
    public void setDono(Componente dono) {
        this.dono = dono;
    }

    @Override
    public Componente getDono() {
        return this.dono;
    }

    @Override
    public String getNome() {
        return this.getName();
    }

    @Override
    public Object getValor() {
        return this.vazio() ? null : StringUtil.getValorString(this.getText());
    }

    @Override
    public void setValor(Object valor) {
    }

    @Override
    public void limpar() {
        this.setText("");
        this.fireDigitouValor();
    }

    @Override
    public void carregarValorPadrao() {
    }

    public void setExpressao(String expressao) {
        this.expressao = expressao;
    }

    public String getExpressao() {
        return this.expressao;
    }

    public void setTabelaSimbolos(TabelaSimbolos tabela) {
        this.tabela = tabela;
    }

    @Override
    public boolean imprimir() {
        return this.imprimir;
    }

    @Override
    public boolean vazio() {
        return this.getText().matches("[ |,|.|:|/]*");
    }

    private void marcarValorAlterado(boolean alterado) {
        this.setBackground(alterado ? Campo.COR_ALTERADO : this.background);
        if (this.dono != null && this.dono instanceof Expressao) {
            ((Expressao)this.dono).setValorAlterado(alterado);
        }
    }

    @Override
    public boolean removerVazio() {
        return this.removerVazio;
    }

    @Override
    public boolean salvarParcialmente() {
        boolean salvar = true;
        Map<String, ComponenteValor> comps = this.tabela.getComponentesValor();
        for (String ident : Token.getIdentificadores(this.getExpressao())) {
            ComponenteValor comp = comps.get(ident.toLowerCase());
            if (comp == null || !comp.vazio()) continue;
            salvar = false;
            break;
        }
        return salvar;
    }

    @Override
    public void setRemoverVazio(boolean valor) {
        this.removerVazio = valor;
    }

    public void setImprimir(boolean imprimir) {
        this.imprimir = imprimir;
    }

    @Override
    public List<String> getLigacoes() {
        return this.ligacoes;
    }

    public void setLigacoes(List<String> lig) {
        this.ligacoes.clear();
        this.ligacoes.addAll(lig);
    }

    @Override
    public boolean resultadoAnterior() {
        return this.resultadoAnterior;
    }

    public void setResultadoAnterior(boolean resultadoAnterior) {
        this.resultadoAnterior = resultadoAnterior;
    }

    @Override
    public void setProcessarPerdaDeFoco(boolean flag) {
    }

    @Override
    public void digitouValor(CampoEvento e) {
        this.executar();
    }

    public void executar() {
        if (this.tabela != null) {
            Execucao exe = new Execucao(this.getExpressao(), this.tabela, 0);
            Object res = exe.resultadoExpressao();
            if (res == null) {
                this.setText("");
            } else if (this.getMascara() != null && this.getMascara().trim().length() > 0) {
                String retorno = res.toString();
                if (res instanceof String && StringUtil.validaNumero(res.toString())) {
                    BigDecimal valor = new BigDecimal(StringUtil.strDecimal(res.toString()));
                    retorno = StringUtil.validaMascaraNumero(this.mascara) ? new DecimalFormat(StringUtil.trocarCaractere(this.mascara, ',', '.')).format(valor) : new DecimalFormat().format(valor);
                } else if (res instanceof BigDecimal) {
                    BigDecimal valor = new BigDecimal(StringUtil.strDecimal(res.toString()));
                    retorno = StringUtil.validaMascaraNumero(this.mascara) ? new DecimalFormat(this.mascara).format(valor) : new DecimalFormat().format(valor);
                }
                this.setText(retorno.toString());
                this.validarValores();
            } else {
                this.setText(res.toString());
            }
            this.fireDigitouValor();
        }
    }

    public void validarValores() {
        if (this.mascara != null && this.mascara.length() > 0) {
            int vlr;
            if (this.valores == null || this.valores.zero() || this.getText().matches("(\\-|\\*|[ :.,/]*)") || (vlr = this.valores.verificaValor(this.getText())) == 0) {
                this.marcarValorAlterado(false);
                return;
            }
            if (vlr == 2 || vlr == 4) {
                this.marcarValorAlterado(true);
            } else {
                String mensagem = vlr == 1 ? "Resultado inferior ao valor de refer\u00eancia" : "Resultado superior ao valor de refer\u00eancia";
                this.setToolTipText(mensagem);
                this.marcarValorAlterado(true);
            }
        }
    }

    @Override
    public void addCampoListener(CampoListener l) {
        this.listenerList.add(CampoListener.class, l);
    }

    @Override
    public void removeCampoListener(CampoListener l) {
        this.listenerList.remove(CampoListener.class, l);
    }

    @Override
    public void setDimensoes(Rectangle dim) {
        if (this.dono != null) {
            this.dono.setDimensoes(dim);
        }
        this.setBounds(dim);
    }

    @Override
    public void setDimensoes(int esquerda, int topo, int largura, int altura) {
        this.setDimensoes(new Rectangle(esquerda, topo, largura, altura));
    }

    @Override
    public Rectangle getDimensoes() {
        if (this.dono != null) {
            return this.dono.getDimensoes();
        }
        return new Rectangle();
    }

    @Override
    public String getStringValor() {
        return this.getText();
    }

    @Override
    public int getAlinhamentoHorizontal() {
        return this.getHorizontalAlignment();
    }

    @Override
    public void setAlinhamentoHorizontal(int alinhamento) {
        this.setHorizontalAlignment(alinhamento);
    }

    @Override
    public void setComponentesFoco(List<Component> list) {
    }

    @Override
    public String getCampoDeImportacao() {
        return this.dono != null ? this.dono.getCampoImportacao().campoImportacao : "";
    }

    @Override
    public boolean isRelacionavelComCampoDeImportacao() {
        return this.dono != null ? this.dono.isRelacionavelComCampoDeImportacao() : false;
    }

    protected void fireDigitouValor() {
        Object[] ouvintes = this.listenerList.getListenerList();
        for (int i = ouvintes.length - 2; i >= 0; i -= 2) {
            if (ouvintes[i] != CampoListener.class) continue;
            if (this.evento == null) {
                this.evento = new CampoEvento(this);
            }
            ((CampoListener)ouvintes[i + 1]).digitouValor(this.evento);
        }
    }

    @Override
    public void addMensagemListener(MensagemListener l) {
    }

    @Override
    public void removeMensagemListener(MensagemListener l) {
    }

    @Override
    public String getValorOriginal() {
        return this.getStringValor();
    }

    public void setValoresReferencia(ValoresReferencia valores) {
        this.valores = valores;
    }

    public String getValoresNormais() {
        if (this.valores == null || Funcoes.textoVazio(this.valores.getValores()[1]) && Funcoes.textoVazio(this.valores.getValores()[2])) {
            return "";
        }
        return this.valores.getValores()[1] + " a " + this.valores.getValores()[2];
    }

    public boolean validarValoresConferenciaAutomatica() {
        if (this.mascara != null && this.mascara.length() > 0) {
            String semVirgulas = this.getText();
            if (this.getText().contains(".")) {
                semVirgulas = semVirgulas.replaceAll(",", "");
            }
            semVirgulas = semVirgulas.replaceAll("\\.", ",");
            if (this.valores != null) {
                int vlr = this.valores.verificaValor(semVirgulas);
                return this.valores != null && !this.valores.zero() && vlr == 0;
            }
        }
        return false;
    }

    public void setMascara(String mascara) {
        this.mascara = mascara;
    }

    public String getMascara() {
        return this.mascara;
    }

    @Override
    public Map<String, ProtocoloCampoImportacao> getMapCampoDeImportacao() {
        if (this.dono != null) {
            return this.dono.getMapCamposImportacao();
        }
        return null;
    }
}

