/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.digitacao.componente;

import jalis.laboratorio.digitacao.componente.TextoDigitacao;
import jalis.util.ArraysUtil;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import javax.swing.text.Utilities;

class DocumentoWrap
extends DefaultStyledDocument {
    TextoDigitacao componenteTexto = null;

    public DocumentoWrap(TextoDigitacao componente) {
        this.componenteTexto = componente;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (this.podeInserir(str, offs)) {
            super.insertString(offs, str, a);
        }
        if (this.ultrapassouLimites()) {
            super.remove(offs, str.length());
        }
    }

    public void _insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        int inicioLinha = Utilities.getRowStart(this.componenteTexto, offs);
        Segment s = new Segment(this.componenteTexto.getText().toCharArray(), inicioLinha, offs - inicioLinha);
        FontMetrics fm = this.componenteTexto.getFontMetrics(this.componenteTexto.getFont());
        boolean adicionouQuebra = false;
        int margem = this.componenteTexto.getMargin().right + this.componenteTexto.getMargin().left;
        if (str.equals("\n") && this.podeInserir(str, offs)) {
            super.insertString(offs, str, a);
        } else if (this.podeInserir(str, offs) || this.getTamanhoLinha(this.componenteTexto, offs, str) < this.componenteTexto.getDimensoes().width - margem && !str.equals("\n")) {
            if (fm.stringWidth(s.toString() + str) >= this.componenteTexto.getDimensoes().width - margem) {
                super.insertString(offs, str, a);
                for (int i = s.length() - 1; i > 0; --i) {
                    String c = String.valueOf(s.charAt(i));
                    if (ArraysUtil.indice((Object[])new String[]{".", ",", " "}, c) < 0 || c.equals("\n") || s.toString().endsWith("\n") || str.startsWith("\n")) continue;
                    super.insertString(inicioLinha + i + 1, "\n", null);
                    adicionouQuebra = true;
                    break;
                }
            } else if (this.getTamanhoLinha(this.componenteTexto, offs, str) < this.componenteTexto.getDimensoes().width - margem) {
                int posicaoUltimaPalavra = Utilities.getRowEnd(this.componenteTexto, offs);
                if (posicaoUltimaPalavra > 0 || s.length() == 0) {
                    if (this.componenteTexto.getText().length() >= posicaoUltimaPalavra + 1 && this.componenteTexto.getText().substring(posicaoUltimaPalavra, posicaoUltimaPalavra + 1).equals("\n") && fm.stringWidth(s.toString() + str) >= this.componenteTexto.getDimensoes().width - margem) {
                        super.remove(posicaoUltimaPalavra, 1);
                    }
                    super.insertString(offs, str, a);
                }
            } else {
                super.insertString(offs + (adicionouQuebra ? 1 : 0), str, a);
            }
        }
    }

    private boolean podeInserir(String novoTexto, int posCursor) {
        if (!this.componenteTexto.getRedimensionar() || this.componenteTexto.getRedimensionar() && this.componenteTexto.getTamanhoMaximo() != null) {
            Dimension novoTamanho = this.componenteTexto.getPreferredSize();
            Rectangle tamanhoAnterior = this.componenteTexto.getDimensoes();
            int margem = this.componenteTexto.getMargin().top + this.componenteTexto.getMargin().bottom;
            FontMetrics fm = this.componenteTexto.getFontMetrics(this.componenteTexto.getFont());
            int alturaNovoTexto = fm.getHeight();
            if (!novoTexto.equals("\n")) {
                alturaNovoTexto = 0;
                int linhaAtual = 0;
                try {
                    linhaAtual = this.getTamanhoLinha(this.componenteTexto, posCursor, novoTexto);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                if (linhaAtual > tamanhoAnterior.width - margem) {
                    alturaNovoTexto = fm.getHeight();
                }
            }
            FontMetrics metrics = this.componenteTexto.getFontMetrics(this.componenteTexto.getFont());
            return true;
        }
        return false;
    }

    protected boolean ultrapassouLimites() {
        int qtde = this.getQuantidadeLinhas();
        int qtdeMaxima = 0;
        if (this.componenteTexto != null) {
            FontMetrics fm = this.componenteTexto.getFontMetrics(this.componenteTexto.getFont());
            float alturaLinha = this.componenteTexto.getFontMetrics(this.componenteTexto.getFont()).getHeight();
            qtdeMaxima = (int)((float)this.componenteTexto.getHeight() / alturaLinha);
        }
        return this.componenteTexto != null && this.componenteTexto.getTamanhoMaximo() != null && qtde > qtdeMaxima;
    }

    protected int getQuantidadeLinhas() {
        int qtde = 0;
        if (this.componenteTexto.isEditable()) {
            int rowStartOffset = this.componenteTexto.viewToModel(new Point(0, 0));
            int endOffset = this.componenteTexto.viewToModel(new Point(0, this.componenteTexto.getHeight()));
            while (rowStartOffset <= endOffset) {
                ++qtde;
                try {
                    rowStartOffset = Utilities.getRowEnd(this.componenteTexto, rowStartOffset) + 1;
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
        } else {
            qtde = this.componenteTexto.getHeight() / this.componenteTexto.getFontMetrics(this.componenteTexto.getFont()).getHeight();
            if (this.componenteTexto.getHeight() % this.componenteTexto.getFontMetrics(this.componenteTexto.getFont()).getHeight() > 0) {
                --qtde;
            }
        }
        return qtde;
    }

    private int qtdeLinhasOcupadas(int tamanhoLinha, float tamanhoComponente) {
        if (tamanhoComponente > 0.0f) {
            if ((float)tamanhoLinha % tamanhoComponente > 0.0f) {
                return tamanhoLinha / (int)tamanhoComponente + 1;
            }
            return tamanhoLinha / (int)tamanhoComponente;
        }
        return 1;
    }

    private int getTamanhoLinha(JTextComponent componente, int offs, String textoAdicional) throws BadLocationException {
        int inicioLinha = Utilities.getRowStart(componente, offs);
        int fimLinha = Utilities.getRowEnd(componente, offs);
        String textoParaMedir = componente.getText().substring(inicioLinha, fimLinha) + textoAdicional;
        FontMetrics metrics = this.componenteTexto.getFontMetrics(this.componenteTexto.getFont());
        int tamanhoLinha = SwingUtilities.computeStringWidth(metrics, textoParaMedir);
        return tamanhoLinha;
    }
}

