/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.digitacao.componente;

import jalis.laboratorio.configurador.Constantes;
import jalis.laboratorio.configurador.historicos.DialogoHistorico;
import jalis.laboratorio.digitacao.componente.AtributosFonteHistorico;
import jalis.laboratorio.digitacao.componente.ComponenteResultado;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.FocusManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

class DocumentoHistorico
extends DefaultStyledDocument
implements CaretListener,
FocusListener,
KeyListener {
    private JTextComponent text;
    private boolean entradaCodigo = true;
    private boolean permissaoAlterar = false;
    private int qtdeMax = 1;
    private Stack<String> pilha = new Stack();
    private Map<String, String> historicosPorCodigo;
    private Map<String, String> historicosPorMnemonico;
    private boolean processar;
    private boolean processarTemp;
    private List<Component> componentesFoco = new ArrayList<Component>();
    private final int NEGRITO = 1;
    private final int ITALICO = 3;
    private final int SUBLINHADO = 5;

    public DocumentoHistorico(JTextComponent text) {
        try {
            this.text = text;
            text.addCaretListener(this);
            text.addFocusListener(this);
            text.addKeyListener(this);
            super.insertString(0, "[ ]", null);
            this.processarTemp = true;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "DocumentoHistorico: 440");
        }
    }

    @Override
    public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
        if (this.entradaCodigo) {
            if (offset < this.getLength() && str.matches("\\-?\\d+")) {
                if (this.getText(offset, 1).equals(" ")) {
                    super.remove(offset, 1);
                }
                super.insertString(offset, str, attr);
            }
        } else if (this.permissaoAlterar) {
            super.insertString(offset, this.subString(str), attr);
        }
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        if (this.entradaCodigo) {
            if (offs > 0 && this.getText(offs, len).matches("\\-?\\d+")) {
                super.remove(offs, len);
                if (this.getText(0, this.getLength()).lastIndexOf(91) + 1 == offs) {
                    super.insertString(offs, " ", null);
                }
            }
        } else if (this.permissaoAlterar) {
            super.remove(offs, len);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        try {
            if (e.getKeyCode() == 113 && this.entradaCodigo) {
                DialogoHistorico dh = DialogoHistorico.novaInstancia(this.text.getTopLevelAncestor());
                if (dh == null) {
                    return;
                }
                dh.setHistoricos(this.historicosPorCodigo);
                dh.setLocationRelativeTo(null);
                dh.setVisible(true);
                if (dh.ok()) {
                    this.pilha.push(dh.getCodigoSelecionado());
                    this.atualizar(null);
                }
                this.text.requestFocus();
            } else if (e.getKeyCode() == 116) {
                if (this.entradaCodigo && !this.pilha.isEmpty()) {
                    this.pilha.pop();
                }
                this.atualizar(null);
            } else if (e.getKeyCode() == 115) {
                int index;
                if (this.permissaoAlterar && this.entradaCodigo && (index = this.getText(0, this.getLength()).indexOf(91)) > -1) {
                    super.remove(index, this.getLength() - index);
                    this.entradaCodigo = false;
                    this.pilha.clear();
                    this.text.setCaretPosition(this.getLength());
                }
            } else if (e.getKeyCode() == 10) {
                FocusManager.getCurrentManager().focusNextComponent();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "DocumentoHistorico: 516");
        }
    }

    public void setComponentesFoco(List<Component> list) {
        if (list != null) {
            this.componentesFoco.clear();
            this.componentesFoco.addAll(list);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.processar = this.processarTemp;
        this.text.setCaretPosition(this.entradaCodigo ? this.getPosicaoCorreta() : this.getLength());
    }

    @Override
    public void focusLost(FocusEvent e) {
        try {
            if (!e.isTemporary()) {
                if (this.processar) {
                    String codigo = this.getCodigo().trim();
                    if (!this.entradaCodigo || codigo.length() == 0) {
                        return;
                    }
                    if (this.contemCodigo(codigo)) {
                        this.pilha.push(codigo);
                    }
                    this.atualizar(null);
                    Component o = e.getOppositeComponent();
                    if (o instanceof ComponenteResultado && this.verificarFoco(o)) {
                        ((ComponenteResultado)((Object)o)).setProcessarPerdaDeFoco(false);
                    }
                    this.text.grabFocus();
                }
                this.setProcessar(true);
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "DocumentoHistorico: 566");
        }
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        if (this.entradaCodigo) {
            int pos = this.getPosicaoCorreta();
            if (e.getDot() != pos) {
                this.text.setCaretPosition(pos);
            }
        }
    }

    public void setPermissaoAlterar(boolean permissao) {
        this.permissaoAlterar = permissao;
    }

    public void setQuantidade(int qtde) {
        if (qtde > 1) {
            this.qtdeMax = qtde;
        }
    }

    public void setCodigo(String codigo) {
        try {
            this.entradaCodigo = true;
            this.pilha.clear();
            super.remove(0, this.getLength());
            super.insertString(0, "[" + codigo + "]", null);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "DocumentoHistorico: 612");
        }
    }

    public void setDescricao(String descricao) {
        try {
            this.entradaCodigo = false;
            super.remove(0, this.getLength());
            if (descricao.indexOf("<html>") >= 0) {
                this.atualizar(descricao);
            } else {
                super.insertString(0, descricao, null);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "DocumentoHistorico: 627");
        }
    }

    public void setHistoricos(Map<String, String> historicos, Map<String, String> historicosPorMnemonico) {
        this.historicosPorCodigo = historicos;
        this.historicosPorMnemonico = historicosPorMnemonico;
    }

    public void limpar() {
        try {
            this.entradaCodigo = true;
            this.pilha.clear();
            super.remove(0, this.getLength());
            super.insertString(0, "[ ]", null);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "DocumentoHistorico: 650");
        }
    }

    public void setProcessar(boolean processar) {
        this.processarTemp = processar;
    }

    public String getDescricao(String codigo) {
        if (this.historicosPorCodigo != null && this.historicosPorCodigo.containsKey(codigo)) {
            return this.historicosPorCodigo.get(codigo);
        }
        if (this.historicosPorMnemonico != null && this.historicosPorMnemonico.containsKey(codigo)) {
            return this.historicosPorMnemonico.get(codigo);
        }
        return codigo;
    }

    public String getDescricoes() {
        StringBuilder bui = new StringBuilder();
        try {
            if (this.entradaCodigo) {
                Iterator itr = this.pilha.iterator();
                while (itr.hasNext()) {
                    bui.append(this.getDescricao((String)itr.next()));
                    bui.append(' ');
                }
            } else {
                bui.append(this.getText(0, this.getLength()));
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "DocumentoHistorico: 693");
        }
        return bui.toString();
    }

    private String converteMaiorMenor(String texto, boolean gravarBanco) {
        if (gravarBanco) {
            String novoTexto = "";
            char[] array = texto.toCharArray();
            int posicaoAbriu = -1;
            for (int i = 0; i < array.length; ++i) {
                String c = String.valueOf(texto.toCharArray()[i]);
                if (c.equals("<")) {
                    posicaoAbriu = i;
                    int j = posicaoAbriu + 1;
                    if (j >= array.length) continue;
                    if (array[j] == '/' || array[j] == 'u' || array[j] == 'b' || array[j] == 'i' || array[j] == 's') {
                        novoTexto = novoTexto + c;
                        continue;
                    }
                    novoTexto = novoTexto + "&lt;";
                    posicaoAbriu = -1;
                    continue;
                }
                if (c.equals(">") && posicaoAbriu < 0) {
                    novoTexto = novoTexto + "&gt;";
                    continue;
                }
                if (c.equals(">") && posicaoAbriu >= 0) {
                    posicaoAbriu = -1;
                    novoTexto = novoTexto + c;
                    continue;
                }
                novoTexto = novoTexto + c;
            }
            return novoTexto;
        }
        return texto.replaceAll("&gt;", ">").replaceAll("&lt;", "<");
    }

    private void atualizar(String texto) {
        try {
            super.remove(0, this.getLength());
            StringBuilder buf = new StringBuilder(texto == null || texto.trim().length() == 0 ? this.converteMaiorMenor(this.getDescricoes(), false) : this.converteMaiorMenor(texto, false));
            if (buf.indexOf("<html>") > -1) {
                ArrayList<AtributosFonteHistorico> aplicar = new ArrayList<AtributosFonteHistorico>();
                int posHtml = -1;
                while ((posHtml = buf.indexOf("<html>")) > -1) {
                    buf.delete(posHtml, posHtml + 6);
                    posHtml = buf.indexOf("</html>");
                    if (posHtml <= -1) continue;
                    buf.delete(posHtml, posHtml + 7);
                }
                boolean abriu = false;
                String tag = "";
                int posicaoAbriu = -1;
                int posicaoFechou = -1;
                int posicaoAtual = 0;
                for (int i = 0; i < buf.length(); ++i) {
                    char c = buf.charAt(i);
                    if (String.valueOf(c).equals("<") && !abriu && i < buf.length() && (buf.charAt(i + 1) == '/' || buf.charAt(i + 1) == 'u' || buf.charAt(i + 1) == 'b' || buf.charAt(i + 1) == 'i' || buf.charAt(i + 1) == 's')) {
                        posicaoAbriu = posicaoAtual;
                        abriu = true;
                        continue;
                    }
                    if (String.valueOf(c).equals(">") && abriu) {
                        if (Constantes.estilos.containsKey(tag) && Constantes.estilos.get(tag) != null) {
                            AtributosFonteHistorico at = new AtributosFonteHistorico();
                            at.posicaoInicial = posicaoAbriu;
                            at.estilo = Constantes.estilos.get(tag);
                            aplicar.add(at);
                        }
                        posicaoAbriu = -1;
                        abriu = false;
                        tag = "";
                        continue;
                    }
                    if (abriu) {
                        int pos;
                        if ((tag = tag + String.valueOf(c)).length() > 4) {
                            tag = "";
                            posicaoAbriu = -1;
                            abriu = false;
                            continue;
                        }
                        if (tag.length() == 2 && tag.indexOf("/") > -1 && Constantes.estilos.containsKey(tag.substring(1))) {
                            int pos2 = this.achaPosicaoTagAberta(aplicar, Constantes.estilos.get(tag.substring(1)));
                            if (pos2 <= -1) continue;
                            aplicar.get((int)pos2).posicaoFinal = posicaoAbriu;
                            continue;
                        }
                        if (tag.length() != 4 || tag.indexOf("/") <= -1 || !Constantes.estilos.containsKey(tag.substring(1)) || (pos = this.achaPosicaoTagAberta(aplicar, Constantes.estilos.get(tag.substring(1)))) <= -1) continue;
                        aplicar.get((int)pos).posicaoFinal = posicaoAbriu;
                        continue;
                    }
                    ++posicaoAtual;
                }
                super.insertString(0, this.subString(buf.toString().replaceAll("\\<.[html]*[b]*[i]*[u]*[sub]*[sup]*\\>", "")), null);
                for (AtributosFonteHistorico at : aplicar) {
                    SimpleAttributeSet mat = new SimpleAttributeSet();
                    mat.addAttribute(at.estilo, Boolean.TRUE);
                    this.setCharacterAttributes(at.posicaoInicial, at.posicaoFinal - at.posicaoInicial, mat, false);
                }
            } else {
                super.insertString(0, this.subString(buf.toString()).replaceAll("&gt;", ">").replaceAll("&lt;", "<"), null);
            }
            boolean bl = this.entradaCodigo = this.qtdeMax > this.pilha.size() && texto == null;
            if (this.entradaCodigo) {
                super.insertString(this.getLength(), "[ ]", null);
            } else {
                this.pilha.clear();
            }
            this.text.setCaretPosition(this.getPosicaoCorreta());
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "DocumentoHistorico: 714");
        }
    }

    private int achaPosicaoTagAberta(ArrayList<AtributosFonteHistorico> lista, Object estilo) {
        int retorno = -1;
        for (int i = lista.size() - 1; i >= 0; --i) {
            AtributosFonteHistorico a = lista.get(i);
            if (!a.estilo.equals(estilo) || a.posicaoFinal != -1) continue;
            return i;
        }
        return retorno;
    }

    private boolean verificarFoco(Component foco) {
        for (Component c : this.componentesFoco) {
            if (c != foco) continue;
            return true;
        }
        return false;
    }

    private int getPosicaoCorreta() {
        int pos = 0;
        try {
            char[] ch = this.getText(0, this.getLength()).toCharArray();
            for (pos = ch.length; pos > 0 && ch[pos - 1] != '[' && !Character.isDigit(ch[pos - 1]); --pos) {
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "DocumentoHistorico: 745");
        }
        return pos;
    }

    private String getCodigo() {
        if (this.entradaCodigo) {
            try {
                StringBuilder bui = new StringBuilder(this.getText(0, this.getLength()));
                int abre = bui.lastIndexOf("[");
                int fecha = bui.lastIndexOf("]");
                if (abre > -1 && abre < fecha) {
                    return bui.substring(abre + 1, fecha);
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "DocumentoHistorico: 765");
            }
        }
        return "";
    }

    private int comprimento(String str) {
        if (this.text != null) {
            return this.text.getFontMetrics(this.text.getFont()).stringWidth(str);
        }
        return 0;
    }

    public String stringComprimento(String str, int comprimento) throws BadLocationException {
        int pos;
        for (pos = 0; pos < str.length() && this.comprimento(str.substring(0, pos)) < comprimento; ++pos) {
        }
        return str.substring(0, pos);
    }

    public String subString(String str) throws BadLocationException {
        int pos;
        int comprimento = this.text.getWidth() - this.comprimento(this.getText(0, this.getLength())) - 10;
        for (pos = 0; pos < str.length() && this.comprimento(str.substring(0, pos)) < comprimento; ++pos) {
        }
        return str.substring(0, pos);
    }

    private boolean contemCodigo(String codigo) {
        return this.historicosPorCodigo != null && this.historicosPorCodigo.containsKey(codigo);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    public String getAtributos2Texto() throws IOException, BadLocationException {
        String textoTemp = this.getText(0, this.getLength());
        ElementIterator it = new ElementIterator(this.getDefaultRootElement());
        it.current();
        Element next = null;
        StringBuilder bui = new StringBuilder();
        int estilos = 0;
        boolean adicionousHtml = false;
        boolean negritoAberto = false;
        boolean italicoAberto = false;
        boolean sublinhadoAberto = false;
        boolean subAberto = false;
        boolean supAberto = false;
        if (!this.nenhumHistoricoDigitado(textoTemp)) {
            while ((next = it.next()) != null) {
                int posEdicao = this.getText(0, this.getLength()).indexOf("[");
                int posFinal = this.entradaCodigo && posEdicao >= 0 && next.getEndOffset() >= this.getLength() ? next.getEndOffset() - (next.getEndOffset() - posEdicao) : next.getEndOffset();
                String tmp = this.getText(next.getStartOffset(), posFinal - next.getStartOffset());
                if (!next.isLeaf() || tmp.equals("\n")) continue;
                AttributeSet a = next.getAttributes();
                if (StyleConstants.isBold(a) && !negritoAberto) {
                    bui.append("<b>");
                    negritoAberto = true;
                    adicionousHtml = true;
                } else if (!StyleConstants.isBold(a) && negritoAberto) {
                    bui.append("</b>");
                    negritoAberto = false;
                }
                if (StyleConstants.isItalic(a) && !italicoAberto) {
                    bui.append("<i>");
                    estilos += 3;
                    italicoAberto = true;
                    adicionousHtml = true;
                } else if (!StyleConstants.isItalic(a) && italicoAberto) {
                    bui.append("</i>");
                    italicoAberto = false;
                }
                if (StyleConstants.isUnderline(a) && !sublinhadoAberto) {
                    bui.append("<u>");
                    estilos += 5;
                    adicionousHtml = true;
                    sublinhadoAberto = true;
                } else if (!StyleConstants.isUnderline(a) && sublinhadoAberto) {
                    sublinhadoAberto = false;
                    bui.append("</u>");
                }
                if (StyleConstants.isSubscript(a) && !subAberto) {
                    bui.append("<sub>");
                    adicionousHtml = true;
                    subAberto = true;
                } else if (!StyleConstants.isSubscript(a) && subAberto) {
                    subAberto = false;
                    bui.append("</sub>");
                }
                if (StyleConstants.isSuperscript(a) && !supAberto) {
                    bui.append("<sup>");
                    adicionousHtml = true;
                    supAberto = true;
                } else if (!StyleConstants.isSuperscript(a) && supAberto) {
                    supAberto = false;
                    bui.append("</sup>");
                }
                bui.append(tmp.replace("\n", ""));
            }
            if (adicionousHtml) {
                if (supAberto) {
                    bui.append("</sup>");
                    supAberto = false;
                }
                if (subAberto) {
                    bui.append("</sub>");
                    subAberto = false;
                }
                if (sublinhadoAberto) {
                    bui.append("</u>");
                    sublinhadoAberto = false;
                }
                if (italicoAberto) {
                    bui.append("</i>");
                    italicoAberto = false;
                }
                if (negritoAberto) {
                    bui.append("</b>");
                    negritoAberto = false;
                }
            }
        }
        if (adicionousHtml) {
            return "<html>" + this.converteMaiorMenor(bui.toString(), true) + "</html>";
        }
        return this.converteMaiorMenor(bui.toString(), true);
    }

    private boolean nenhumHistoricoDigitado(String texto) {
        String tmp = texto.trim();
        if (tmp.indexOf("[") == 0) {
            tmp = tmp.substring(tmp.indexOf("[") + 1);
        }
        if (tmp.indexOf("]") >= 0) {
            tmp = tmp.substring(0, tmp.indexOf("]") - 1);
        }
        return tmp.trim().length() == 0;
    }
}

