/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.digitacao.componente;

import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.digitacao.componente.CampoDigitacao;
import jalis.util.DocumentoMascara;
import jalis.util.ScreenUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

class DialogoAbsurdo
extends JDialog
implements ActionListener,
DisposeListener {
    public static final int REDIGITAR = 0;
    public static final int SENHA = 1;
    private JTextField textCampo;
    private JButton buttonOk = new JButton("OK");
    private JButton buttonCancelar = new JButton("Cancelar");
    private int tipo;
    private String masc;
    private String senha;
    private boolean ok = false;

    public static DialogoAbsurdo novaInstancia(Object pai, int tipo, String masc) {
        if (pai instanceof Frame) {
            return new DialogoAbsurdo((Frame)pai, tipo, masc);
        }
        if (pai instanceof Dialog) {
            return new DialogoAbsurdo((Dialog)pai, tipo, masc);
        }
        return null;
    }

    public DialogoAbsurdo(Frame pai, int tipo, String masc) {
        super(pai, "Valor absurdo", true);
        if (pai instanceof Laboratorio) {
            ((Laboratorio)pai).addDisposeListener(this);
        }
        this.iniciar(tipo, masc);
        ScreenUtil.centralizar(this);
    }

    public DialogoAbsurdo(Dialog pai, int tipo, String masc) {
        super(pai, "Valor absurdo", true);
        this.iniciar(tipo, masc);
        ScreenUtil.centralizar(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonOk || o == this.buttonCancelar) {
            this.ok = o == this.buttonOk;
            this.dispose();
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            Toolkit.getDefaultToolkit().beep();
        }
        super.setVisible(b);
    }

    public void setCampo(CampoDigitacao campo) {
        if (campo != null && this.textCampo != null) {
            this.textCampo.setDocument(new DocumentoMascara(this.textCampo, this.masc));
            this.textCampo.setHorizontalAlignment(campo.getHorizontalAlignment());
            this.textCampo.setForeground(campo.getForeground());
            this.textCampo.setBackground(campo.getBackground());
            this.textCampo.setPreferredSize(campo.getSize());
            this.setSize(new Dimension(campo.getWidth() + 200, this.getHeight()));
        }
    }

    public void setSenha(String senha) {
        this.senha = senha;
    }

    public String getValor() {
        if (this.textCampo.getDocument() instanceof DocumentoMascara) {
            return ((DocumentoMascara)this.textCampo.getDocument()).getValor();
        }
        return null;
    }

    public boolean ok() {
        return this.ok;
    }

    private void iniciar(int tipo, String masc) {
        this.tipo = tipo;
        this.masc = masc;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                ScreenUtil.requisitarFoco(DialogoAbsurdo.this.textCampo);
            }
        });
        Container c = this.getContentPane();
        JPanel panel = new JPanel(new FlowLayout(2, 3, 3));
        c.setLayout(new BorderLayout());
        c.add((Component)panel, "South");
        panel.setPreferredSize(new Dimension(10, 35));
        panel.setBorder(BorderFactory.createEtchedBorder());
        panel.add(this.buttonOk);
        panel.add(this.buttonCancelar);
        panel = new JPanel(new BorderLayout());
        c.add((Component)panel, "Center");
        c = panel;
        panel = new JPanel();
        c.add((Component)panel, "North");
        panel.setPreferredSize(new Dimension(3, 3));
        panel = new JPanel();
        c.add((Component)panel, "South");
        panel.setPreferredSize(new Dimension(3, 3));
        c.add((Component)new JLabel(tipo == 0 ? "Redigite o valor:" : "Digite a senha:"), "Center");
        this.textCampo = tipo == 0 ? new JTextField() : new JPasswordField();
        c.add((Component)this.textCampo, "East");
        this.buttonOk.addActionListener(this);
        this.buttonOk.setMnemonic('O');
        this.buttonCancelar.addActionListener(this);
        this.buttonCancelar.setMnemonic('C');
        this.setSize(new Dimension(300, 100));
        this.definirTeclas();
    }

    private void definirTeclas() {
        if (this.getContentPane() instanceof JComponent) {
            JComponent c = (JComponent)this.getContentPane();
            ScreenUtil.addActionMap(c, KeyStroke.getKeyStroke(10, 0, false), "enter", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogoAbsurdo.this.buttonOk.doClick();
                }
            });
            ScreenUtil.addActionMap(c, KeyStroke.getKeyStroke(27, 0, false), "esc", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogoAbsurdo.this.buttonCancelar.doClick();
                }
            });
        }
    }
}

