/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.digitacao.componente;

import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.digitacao.componente.ComponenteResultado;
import jalis.laboratorio.digitacao.evento.CampoEvento;
import jalis.laboratorio.digitacao.evento.CampoListener;
import jalis.laboratorio.digitacao.evento.MensagemListener;
import jalis.laboratorio.util.parsers.ProtocoloCampoImportacao;
import jalis.util.DocumentoLimite;
import jalis.util.StringUtil;
import java.awt.Component;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.JTextField;

public class DadosDigitacao
extends JTextField
implements ComponenteResultado {
    private Componente dono;
    private boolean imprimir;
    private boolean resultadoAnterior;
    private boolean removerVazio;
    private boolean quebrarLinha;
    private List<String> ligacoes = new ArrayList<String>();
    private String campoBanco = "";
    private String mascara = "";
    private CampoEvento evento;

    public DadosDigitacao() {
        this.setFocusable(false);
        this.setEditable(false);
        this.setBorder(null);
        this.setDocument(new DocumentoLimite(this));
    }

    @Override
    public boolean digitavel() {
        return false;
    }

    @Override
    public void setDono(Componente dono) {
        this.dono = dono;
    }

    @Override
    public Componente getDono() {
        return this.dono;
    }

    @Override
    public String getNome() {
        return this.getName();
    }

    @Override
    public Object getValor() {
        return this.vazio() ? null : StringUtil.getValorString(this.getText());
    }

    @Override
    public void setValor(Object valor) {
        if (valor != null) {
            if (this.mascara.length() == 0 || !(valor instanceof Date) && !(valor instanceof Number)) {
                this.setText(valor.toString());
            } else if (valor instanceof Date) {
                this.setText(new SimpleDateFormat(this.mascara.replace('a', 'y').replace('h', 'H')).format((Date)valor));
            } else if (valor instanceof Number) {
                this.setText(new DecimalFormat(StringUtil.trocarCaractere(this.mascara, ',', '.')).format(valor));
            }
        }
    }

    @Override
    public void limpar() {
        this.setText("");
    }

    @Override
    public void carregarValorPadrao() {
    }

    public void setMascara(String mascara) {
        if (mascara != null) {
            this.mascara = mascara;
        }
    }

    public void setCampoBanco(String campoBanco) {
        this.campoBanco = campoBanco;
    }

    public String getCampoBanco() {
        return this.campoBanco;
    }

    @Override
    public boolean imprimir() {
        return this.imprimir;
    }

    @Override
    public boolean vazio() {
        return this.getStringValor().matches("[ |,|.|:|/]*");
    }

    @Override
    public boolean removerVazio() {
        return this.removerVazio;
    }

    @Override
    public boolean salvarParcialmente() {
        return true;
    }

    @Override
    public void setRemoverVazio(boolean valor) {
        this.removerVazio = valor;
    }

    @Override
    public void setProcessarPerdaDeFoco(boolean flag) {
    }

    public void setImprimir(boolean imprimir) {
        this.imprimir = imprimir;
    }

    @Override
    public List<String> getLigacoes() {
        return this.ligacoes;
    }

    public void setLigacoes(List<String> lig) {
        this.ligacoes.clear();
        this.ligacoes.addAll(lig);
    }

    @Override
    public boolean resultadoAnterior() {
        return this.resultadoAnterior;
    }

    public void setResultadoAnterior(boolean resultadoAnterior) {
        this.resultadoAnterior = resultadoAnterior;
    }

    @Override
    public void addCampoListener(CampoListener l) {
    }

    @Override
    public void removeCampoListener(CampoListener l) {
    }

    @Override
    public void setDimensoes(Rectangle dim) {
        if (this.dono != null) {
            this.dono.setDimensoes(dim);
        }
        this.setBounds(dim);
    }

    @Override
    public void setDimensoes(int esquerda, int topo, int largura, int altura) {
        this.setDimensoes(new Rectangle(esquerda, topo, largura, altura));
    }

    @Override
    public Rectangle getDimensoes() {
        if (this.dono != null) {
            return this.dono.getDimensoes();
        }
        return new Rectangle();
    }

    @Override
    public String getStringValor() {
        return this.getText();
    }

    @Override
    public int getAlinhamentoHorizontal() {
        return this.getHorizontalAlignment();
    }

    @Override
    public void setAlinhamentoHorizontal(int alinhamento) {
        this.setHorizontalAlignment(alinhamento);
    }

    @Override
    public void setComponentesFoco(List<Component> list) {
    }

    @Override
    public String getCampoDeImportacao() {
        return this.dono != null ? this.dono.getCampoImportacao().campoImportacao : "";
    }

    @Override
    public boolean isRelacionavelComCampoDeImportacao() {
        return this.dono != null ? this.dono.isRelacionavelComCampoDeImportacao() : false;
    }

    @Override
    public void addMensagemListener(MensagemListener l) {
    }

    @Override
    public void removeMensagemListener(MensagemListener l) {
    }

    @Override
    public String getValorOriginal() {
        return this.getStringValor();
    }

    public boolean getQuebrarLinha() {
        return this.quebrarLinha;
    }

    public void setQuebrarLinha(boolean wordWrap) {
        this.quebrarLinha = wordWrap;
    }

    @Override
    public Map<String, ProtocoloCampoImportacao> getMapCampoDeImportacao() {
        if (this.dono != null) {
            return this.dono.getMapCamposImportacao();
        }
        return null;
    }
}

