/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.digitacao.componente;

import jalis.laboratorio.configurador.componente.Campo;
import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.configurador.componente.ComponenteInterfaceamento;
import jalis.laboratorio.digitacao.Digitacao;
import jalis.laboratorio.digitacao.Execucao;
import jalis.laboratorio.digitacao.TabelaSimbolos;
import jalis.laboratorio.digitacao.componente.ComponenteResultado;
import jalis.laboratorio.digitacao.evento.CampoEvento;
import jalis.laboratorio.digitacao.evento.CampoListener;
import jalis.laboratorio.digitacao.evento.MensagemListener;
import jalis.laboratorio.util.parsers.ProtocoloCampoImportacao;
import jalis.util.Funcoes;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.KeyStroke;

public class CampoListaDigitacao
extends JComboBox
implements ComponenteResultado,
ComponenteInterfaceamento,
KeyListener {
    private boolean resAnt = false;
    private boolean imprimir = false;
    private boolean remVazio = false;
    private List<String> ligacoes = new ArrayList<String>();
    private Componente dono = null;
    private String valorPadrao = "";
    private String itemVazio = "";
    private String campoInterfaceamento = "";
    private boolean modificou;
    public static String VAZIO = "&nbsp;";
    private TabelaSimbolos tabelaSimbolo;
    private Campo campo;

    public CampoListaDigitacao() {
        this(new Object[0]);
    }

    public CampoListaDigitacao(Object[] itens) {
        super(itens);
        this.addKeyListener(this);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CampoListaDigitacao.this.fireDigitouValor();
            }
        });
        this.definirTeclas();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (e.getKeyChar() == '\n') {
            Container c;
            for (c = this.getParent(); c != null && !(c instanceof Digitacao); c = c.getParent()) {
            }
            if (c instanceof Digitacao) {
                ((Digitacao)c).setFocoProximo();
            }
        }
    }

    @Override
    public Object getValor() {
        return this.vazio() ? null : this.getSelectedItem();
    }

    public String getValorSelecionado() {
        if (this.campoListaVazio()) {
            return "";
        }
        if (null != this.getSelectedItem() && !Funcoes.textoVazio(this.itemVazio) && this.getSelectedItem().toString().equals(this.itemVazio)) {
            return "";
        }
        if (null != this.getSelectedItem()) {
            return this.getSelectedItem().toString();
        }
        return "";
    }

    @Override
    public void setValor(Object valor) {
        this.setSelectedItem(valor);
        this.modificou = false;
    }

    @Override
    public void limpar() {
        this.setSelectedItem(null);
    }

    @Override
    public void carregarValorPadrao() {
        if (!Funcoes.textoVazio(this.valorPadrao)) {
            this.setSelectedItem(this.valorPadrao);
        } else if (!Funcoes.textoVazio(this.itemVazio)) {
            this.setSelectedItem(this.itemVazio);
        }
    }

    @Override
    public boolean resultadoAnterior() {
        return this.resAnt;
    }

    public void setResultadoAnterior(boolean res) {
        this.resAnt = res;
    }

    @Override
    public void setProcessarPerdaDeFoco(boolean flag) {
    }

    @Override
    public void addCampoListener(CampoListener l) {
        this.listenerList.add(CampoListener.class, l);
    }

    @Override
    public void removeCampoListener(CampoListener l) {
        this.listenerList.remove(CampoListener.class, l);
    }

    @Override
    public void addMensagemListener(MensagemListener l) {
        this.listenerList.add(MensagemListener.class, l);
    }

    @Override
    public void removeMensagemListener(MensagemListener l) {
        this.listenerList.remove(MensagemListener.class, l);
    }

    @Override
    public boolean digitavel() {
        return true;
    }

    @Override
    public void setDono(Componente dono) {
        this.dono = dono;
    }

    @Override
    public Componente getDono() {
        return this.dono;
    }

    @Override
    public String getNome() {
        return this.getName();
    }

    @Override
    public String getStringValor() {
        Object tmp = this.getSelectedItem();
        if (this.isModificou() && null != tmp && Funcoes.textoVazio(tmp.toString())) {
            return VAZIO;
        }
        return tmp != null ? tmp.toString() : "";
    }

    @Override
    public boolean imprimir() {
        return this.imprimir;
    }

    public void setValorPadrao(String valor) {
        if (valor != null) {
            this.valorPadrao = valor;
        }
    }

    public String getItemVazio() {
        return this.itemVazio;
    }

    public void setItemVazio(String itemVazio) {
        this.itemVazio = itemVazio;
    }

    public void setImprimir(boolean imprimir) {
        this.imprimir = imprimir;
    }

    @Override
    public boolean vazio() {
        if (!(this.isModificou() || (null == this.getSelectedItem() || this.getItemVazio().equals(this.getSelectedItem().toString())) && this.removerVazio())) {
            return this.getStringValor().trim().length() == 0 && !this.campoListaVazio() || this.campoListaVazio();
        }
        if (!Funcoes.textoVazio(this.getStringValor()) && !this.campoListaVazio()) {
            String tmp = this.getStringValor();
            String itemVazio = this.getItemVazio();
            if (!Funcoes.textoVazio(itemVazio)) {
                return itemVazio.trim().equalsIgnoreCase(tmp.toString().trim());
            }
        }
        return this.getStringValor().trim().length() == 0 && !this.campoListaVazio();
    }

    public boolean campoListaVazio() {
        return this.getStringValor().equals(VAZIO);
    }

    @Override
    public void setRemoverVazio(boolean valor) {
        this.remVazio = valor;
    }

    @Override
    public boolean removerVazio() {
        return this.remVazio;
    }

    @Override
    public boolean salvarParcialmente() {
        return true;
    }

    @Override
    public List<String> getLigacoes() {
        return this.ligacoes;
    }

    public void setLigacoes(List<String> lig) {
        this.ligacoes.clear();
        this.ligacoes.addAll(lig);
    }

    @Override
    public void setDimensoes(Rectangle dim) {
        if (this.dono != null) {
            this.dono.setDimensoes(dim);
        }
        this.setBounds(dim);
    }

    @Override
    public void setDimensoes(int esquerda, int topo, int largura, int altura) {
        this.setDimensoes(new Rectangle(esquerda, topo, largura, altura));
    }

    @Override
    public Rectangle getDimensoes() {
        if (this.dono != null) {
            return this.dono.getDimensoes();
        }
        return new Rectangle();
    }

    @Override
    public int getAlinhamentoHorizontal() {
        return 0;
    }

    @Override
    public void setAlinhamentoHorizontal(int alinhamento) {
    }

    @Override
    public void setComponentesFoco(List<Component> list) {
    }

    @Override
    public void setCampoInterfaceamento(String campo) {
        if (campo != null) {
            this.campoInterfaceamento = campo;
        }
    }

    @Override
    public String getCampoInterfaceamento() {
        return this.campoInterfaceamento.trim().length() == 0 ? this.getNome() : this.campoInterfaceamento;
    }

    @Override
    public String getCampoDeImportacao() {
        return this.dono != null ? this.dono.getCampoImportacao().campoImportacao : "";
    }

    @Override
    public boolean isRelacionavelComCampoDeImportacao() {
        return this.dono != null ? this.dono.isRelacionavelComCampoDeImportacao() : false;
    }

    public void setCampo(Campo campo) {
        this.campo = campo;
    }

    private void definirTeclas() {
        InputMap input = this.getInputMap(1);
        ActionMap action = this.getActionMap();
        input.put(KeyStroke.getKeyStroke("DOWN"), "setaAbaixo");
        action.put("setaAbaixo", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CampoListaDigitacao.this.isPopupVisible()) {
                    CampoListaDigitacao.this.selecionarProximo();
                }
            }
        });
        input.put(KeyStroke.getKeyStroke("RIGHT"), "setaDireita");
        action.put("setaDireita", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!CampoListaDigitacao.this.isPopupVisible()) {
                    CampoListaDigitacao.this.selecionarProximo();
                }
            }
        });
        input.put(KeyStroke.getKeyStroke("LEFT"), "setaEsquerda");
        action.put("setaEsquerda", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!CampoListaDigitacao.this.isPopupVisible()) {
                    CampoListaDigitacao.this.selecionarAnterior();
                }
            }
        });
    }

    private void selecionarProximo() {
        int index = this.getSelectedIndex();
        this.setSelectedIndex(index < this.getItemCount() - 1 ? index + 1 : index);
    }

    private void selecionarAnterior() {
        int index = this.getSelectedIndex();
        this.setSelectedIndex(index > 0 ? index - 1 : 0);
    }

    private void fireDigitouValor() {
        this.executar();
        CampoListener[] ouvintes = (CampoListener[])this.listenerList.getListeners(CampoListener.class);
        for (int i = 0; i < ouvintes.length; ++i) {
            ouvintes[i].digitouValor(new CampoEvento(this));
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public String getValorOriginal() {
        return this.getStringValor();
    }

    public boolean isModificou() {
        return this.modificou;
    }

    @Override
    public Map<String, ProtocoloCampoImportacao> getMapCampoDeImportacao() {
        if (this.dono != null) {
            return this.dono.getMapCamposImportacao();
        }
        return null;
    }

    public void setTabelaSimbolo(TabelaSimbolos tabelaSimbolo) {
        this.tabelaSimbolo = tabelaSimbolo;
    }

    public void executar() {
        if (this.tabelaSimbolo != null && this.campo.getExpressaoDeCor().trim().length() > 0 && this.campo.getExpressaoDeCor() != null && this.campo.getCorDeReferencia()) {
            Execucao exe = new Execucao(this.campo.getExpressaoDeCor(), this.tabelaSimbolo, 0);
            Object res = exe.resultadoExpressao();
            if (res != null && CampoListaDigitacao.isHex(res.toString())) {
                this.setForeground(Color.decode(res.toString()));
                this.dono.setCorDaFonte(Color.decode(res.toString()));
            } else {
                this.setForeground(Color.black);
                this.dono.setCorDaFonte(Color.black);
            }
        }
    }

    private static boolean isHex(String valor) {
        return valor.matches("^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$");
    }
}

