/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.digitacao.componente;

import jalis.laboratorio.configurador.ValoresReferencia;
import jalis.laboratorio.configurador.componente.Campo;
import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.configurador.componente.ComponenteInterfaceamento;
import jalis.laboratorio.digitacao.Execucao;
import jalis.laboratorio.digitacao.TabelaSimbolos;
import jalis.laboratorio.digitacao.componente.AbsurdoListener;
import jalis.laboratorio.digitacao.componente.ComponenteResultado;
import jalis.laboratorio.digitacao.componente.DialogoAbsurdo;
import jalis.laboratorio.digitacao.evento.CampoEvento;
import jalis.laboratorio.digitacao.evento.CampoListener;
import jalis.laboratorio.digitacao.evento.MensagemEvento;
import jalis.laboratorio.digitacao.evento.MensagemListener;
import jalis.laboratorio.util.parsers.ProtocoloCampoImportacao;
import jalis.util.DocumentoLimite;
import jalis.util.DocumentoListener;
import jalis.util.DocumentoMascara;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class CampoDigitacao
extends JTextField
implements DocumentoListener,
ComponenteResultado,
ComponenteInterfaceamento {
    private Campo dono;
    private DocumentoMascara documento;
    private boolean processar = true;
    private boolean processarTemp = true;
    private boolean removerVazio;
    private boolean imprimir;
    private boolean resultadoAnterior;
    private final Color background;
    private int tipo;
    private String mascara;
    private String valorPadrao = "";
    private List<String> ligacoes = new ArrayList<String>();
    private CampoEvento eventoCampo;
    private MensagemEvento eventoMensagem;
    private ValoresReferencia valores;
    private FocusListener focus;
    private ComponenteResultado prox;
    private List<Component> componentesFoco = new ArrayList<Component>();
    private String campoInterfaceamento = "";
    private boolean modificou = false;
    private boolean bloquearFoco = false;
    private List<AbsurdoListener> absurdoListeners = new ArrayList<AbsurdoListener>();
    private TabelaSimbolos tabela;
    private String expressao = "";

    public CampoDigitacao() {
        this.setMargin(new Insets(1, 1, 1, 1));
        this.focus = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                CampoDigitacao.this.processar = CampoDigitacao.this.processarTemp;
                CampoDigitacao.this.modificou = false;
                CampoDigitacao.this.fireComponenteSelecionado();
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    Component o = e.getOppositeComponent();
                    if (CampoDigitacao.this.processar && CampoDigitacao.this.modificou) {
                        if (!CampoDigitacao.this.getText().matches("[ :.,/]*") && (o instanceof ComponenteResultado || CampoDigitacao.this.verificarFoco(o))) {
                            if (o instanceof ComponenteResultado) {
                                CampoDigitacao.this.prox = (ComponenteResultado)((Object)o);
                            }
                            if (CampoDigitacao.this.documento != null) {
                                CampoDigitacao.this.documento.formatarValor();
                            }
                        }
                        CampoDigitacao.this.validarValores(true);
                        CampoDigitacao.this.fireDigitouValor();
                    }
                    CampoDigitacao.this.setProcessarPerdaDeFoco(true);
                    if (o instanceof ComponenteResultado) {
                        ((ComponenteResultado)((Object)o)).setProcessarPerdaDeFoco(true);
                    }
                }
            }
        };
        super.addFocusListener(this.focus);
        this.background = this.getBackground();
    }

    public void executar() {
        if (this.tabela != null && this.dono.getExpressaoDeCor().trim().length() > 0 && this.dono.getExpressaoDeCor() != null && this.dono.getCorDeReferencia()) {
            Execucao exe = new Execucao(this.dono.getExpressaoDeCor(), this.tabela, 0);
            Object res = exe.resultadoExpressao();
            if (res != null && CampoDigitacao.isHex(res.toString())) {
                this.setForeground(Color.decode(res.toString()));
                this.dono.setCorDaFonte(Color.decode(res.toString()));
            } else {
                this.setForeground(Color.black);
                this.dono.setCorDaFonte(Color.black);
            }
        }
    }

    private static boolean isHex(String valor) {
        return valor.matches("^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$");
    }

    public void addListenerAbsurdo(AbsurdoListener absurdoListener) {
        this.absurdoListeners.add(absurdoListener);
    }

    public void removeListenerAbsurdo(AbsurdoListener absurdoListener) {
        if (this.absurdoListeners.contains(absurdoListener)) {
            this.absurdoListeners.remove(absurdoListener);
        }
    }

    private void fireAbsurdoListener() {
        for (AbsurdoListener absurdoListener : this.absurdoListeners) {
            absurdoListener.absurdoDisparado();
        }
    }

    private void fireAbsurdoListenerOcultar() {
        for (AbsurdoListener absurdoListener : this.absurdoListeners) {
            absurdoListener.absurdoOcultado();
        }
    }

    public void formatarValor() {
        if (this.documento != null) {
            this.documento.formatarValor();
        }
    }

    private void fireComponenteSelecionado() {
        for (AbsurdoListener absurdoListener : this.absurdoListeners) {
            absurdoListener.componenteSelecionado(this);
        }
    }

    @Override
    public boolean digitavel() {
        return true;
    }

    @Override
    public void setDono(Componente dono) {
        if (dono instanceof Campo) {
            this.dono = (Campo)dono;
        }
    }

    public TabelaSimbolos getTabela() {
        return this.tabela;
    }

    public void setTabela(TabelaSimbolos tabela) {
        this.tabela = tabela;
    }

    public String getExpressao() {
        return this.expressao;
    }

    public void setExpressao(String expressao) {
        this.expressao = expressao;
    }

    public String getMascara() {
        return this.mascara;
    }

    public void setTipoMascara(int tipo, String mascara, int limite) {
        this.tipo = tipo;
        this.mascara = mascara;
        if (mascara != null && mascara.trim().length() > 0) {
            this.documento = new DocumentoMascara(this, mascara);
            this.setDocument(this.documento);
            this.documento.addDocumentoListener(this);
            this.documento.setProcessarPerdaDeFoco(false);
        } else {
            String padrao = null;
            switch (tipo) {
                case 1: {
                    padrao = "[0-9|.|,]+";
                    break;
                }
                case 2: {
                    padrao = "[0-9|/]+";
                    break;
                }
                case 3: {
                    padrao = "[0-9|:]+";
                }
            }
            this.setDocument(new DocumentoLimite(this, limite, padrao, this));
        }
    }

    @Override
    public Componente getDono() {
        return this.dono;
    }

    @Override
    public String getNome() {
        return this.getName();
    }

    @Override
    public void addFocusListener(FocusListener l) {
        if (super.getFocusListeners().length > 0) {
            super.removeFocusListener(this.focus);
        }
        super.addFocusListener(l);
        super.addFocusListener(this.focus);
    }

    @Override
    public Object getValor() {
        int pos;
        if (this.vazio()) {
            return null;
        }
        float ajuste = 0.0f;
        String tmp = this.getStringValor();
        for (pos = 0; pos < tmp.length() && " <>".indexOf(tmp.charAt(pos)) > -1; ++pos) {
            if (tmp.charAt(pos) == '>') {
                ajuste = 0.1f;
                continue;
            }
            if (tmp.charAt(pos) != '<') continue;
            ajuste = -0.1f;
        }
        tmp = tmp.substring(pos, tmp.length());
        tmp = StringUtil.limpaCdata(tmp);
        Object valor = this.tipo != 0 && (tmp.equals("-") || tmp.equals("*")) ? null : StringUtil.getValorString(tmp);
        return valor instanceof Number ? new Double(((Number)valor).doubleValue() + (double)ajuste) : valor;
    }

    @Override
    public void setValor(Object valor) {
        if (valor != null && valor.toString().length() > 0) {
            Document doc = this.getDocument();
            if (doc instanceof DocumentoMascara) {
                ((DocumentoMascara)doc).setValor(StringUtil.limpaCdata(valor.toString()));
            } else {
                this.setText(StringUtil.limpaCdata(valor.toString()));
            }
            this.validarValores(false);
        }
    }

    @Override
    public void limpar() {
        Document doc = this.getDocument();
        if (doc instanceof DocumentoMascara) {
            ((DocumentoMascara)doc).limpar();
        } else {
            this.setText("");
        }
        this.marcarValorAlterado(false);
        this.fireDigitouValor();
    }

    @Override
    public void carregarValorPadrao() {
        if (this.vazio()) {
            Document doc = this.getDocument();
            if (doc instanceof DocumentoMascara) {
                ((DocumentoMascara)doc).setValor(this.valorPadrao);
            } else {
                this.setText(this.valorPadrao);
            }
        }
    }

    @Override
    public void setProcessarPerdaDeFoco(boolean flag) {
        this.processarTemp = flag;
    }

    @Override
    public boolean imprimir() {
        return this.imprimir;
    }

    @Override
    public boolean vazio() {
        return this.getText().matches("[ |,|.|:|/]*");
    }

    @Override
    public boolean removerVazio() {
        return this.removerVazio;
    }

    @Override
    public boolean salvarParcialmente() {
        return true;
    }

    @Override
    public void setRemoverVazio(boolean valor) {
        this.removerVazio = valor;
    }

    public void setValorPadrao(String valor) {
        if (valor != null) {
            this.valorPadrao = StringUtil.limpaCdata(valor);
        }
    }

    public void setImprimir(boolean imprimir) {
        this.imprimir = imprimir;
    }

    public void setValoresReferencia(ValoresReferencia valores) {
        this.valores = valores;
    }

    @Override
    public boolean resultadoAnterior() {
        return this.resultadoAnterior;
    }

    public void setResultadoAnterior(boolean resultadoAnterior) {
        this.resultadoAnterior = resultadoAnterior;
    }

    @Override
    public List<String> getLigacoes() {
        return this.ligacoes;
    }

    public void setLigacoes(List<String> lig) {
        this.ligacoes.clear();
        this.ligacoes.addAll(lig);
    }

    @Override
    public void addCampoListener(CampoListener l) {
        this.listenerList.add(CampoListener.class, l);
    }

    @Override
    public void removeCampoListener(CampoListener l) {
        this.listenerList.remove(CampoListener.class, l);
    }

    @Override
    public void addMensagemListener(MensagemListener l) {
        this.listenerList.add(MensagemListener.class, l);
    }

    @Override
    public void removeMensagemListener(MensagemListener l) {
        this.listenerList.remove(MensagemListener.class, l);
    }

    @Override
    public void setDimensoes(Rectangle dim) {
        if (this.dono != null) {
            this.dono.setDimensoes(dim);
        }
        this.setBounds(dim);
    }

    @Override
    public void setDimensoes(int esquerda, int topo, int largura, int altura) {
        this.setDimensoes(new Rectangle(esquerda, topo, largura, altura));
    }

    @Override
    public Rectangle getDimensoes() {
        if (this.dono != null) {
            return this.dono.getDimensoes();
        }
        return new Rectangle();
    }

    @Override
    public String getStringValor() {
        if (this.documento != null) {
            return this.documento.getValor();
        }
        return this.getText();
    }

    @Override
    public int getAlinhamentoHorizontal() {
        return this.getHorizontalAlignment();
    }

    @Override
    public void setAlinhamentoHorizontal(int alinhamento) {
        this.setHorizontalAlignment(alinhamento);
    }

    @Override
    public void setComponentesFoco(List<Component> list) {
        if (list != null) {
            this.componentesFoco.clear();
            this.componentesFoco.addAll(list);
        }
    }

    @Override
    public void setCampoInterfaceamento(String campo) {
        if (campo != null) {
            this.campoInterfaceamento = campo;
        }
    }

    @Override
    public String getCampoInterfaceamento() {
        return this.campoInterfaceamento.trim().length() == 0 ? this.getNome() : this.campoInterfaceamento;
    }

    protected void fireDigitouValor() {
        Object[] ouvintes = this.listenerList.getListenerList();
        for (int i = ouvintes.length - 2; i >= 0; i -= 2) {
            if (ouvintes[i] != CampoListener.class) continue;
            if (this.eventoCampo == null) {
                this.eventoCampo = new CampoEvento(this);
            }
            ((CampoListener)ouvintes[i + 1]).digitouValor(this.eventoCampo);
        }
        this.executar();
    }

    protected void fireExibirMensagem(String mensagem) {
        Object[] ouvintes = this.listenerList.getListenerList();
        for (int i = ouvintes.length - 2; i >= 0; i -= 2) {
            if (ouvintes[i] != MensagemListener.class) continue;
            this.eventoMensagem = new MensagemEvento(this, mensagem);
            ((MensagemListener)ouvintes[i + 1]).exibirMensagem(this.eventoMensagem);
        }
    }

    @Override
    public String getCampoDeImportacao() {
        return this.dono != null ? this.dono.getCampoImportacao().campoImportacao : "";
    }

    @Override
    public Map<String, ProtocoloCampoImportacao> getMapCampoDeImportacao() {
        if (this.dono != null) {
            return this.dono.getMapCamposImportacao();
        }
        return null;
    }

    @Override
    public boolean isRelacionavelComCampoDeImportacao() {
        return this.dono != null ? this.dono.isRelacionavelComCampoDeImportacao() : false;
    }

    private boolean verificarFoco(Component foco) {
        for (Component c : this.componentesFoco) {
            if (c != foco) continue;
            return true;
        }
        return false;
    }

    public void validarValores(boolean mostrarDialogoAbsurdo) {
        if ((this.tipo == 1 || this.tipo == 3) && this.mascara != null && this.mascara.length() > 0) {
            int vlr = -1;
            if (this.valores == null || this.valores.zero() || this.getText().matches("(\\-|\\*|[ :.,/]*)") || (vlr = this.valores.verificaValor(this.getText())) == 0) {
                this.marcarValorAlterado(false);
                return;
            }
            if (vlr == 2 || vlr == 4) {
                if (this.prox != null) {
                    this.prox.setProcessarPerdaDeFoco(false);
                }
                int tipo = 0;
                if (mostrarDialogoAbsurdo) {
                    DialogoAbsurdo da = DialogoAbsurdo.novaInstancia(this.getTopLevelAncestor(), tipo, this.mascara);
                    if (da != null && tipo == 0) {
                        da.setCampo(this);
                        if (mostrarDialogoAbsurdo) {
                            this.fireAbsurdoListener();
                            da.setVisible(true);
                        }
                        if (!da.ok() || da.getValor() == null || !da.getValor().equals(this.getText())) {
                            this.limpar();
                            this.marcarValorAlterado(false);
                            this.grabFocus();
                        } else {
                            String mensagem = "Resultado superior ao valor de refer\u00eancia";
                            this.setToolTipText(mensagem);
                            this.marcarValorAlterado(true);
                        }
                    }
                } else {
                    this.marcarValorAlterado(true);
                }
            } else {
                String mensagem = vlr == 1 ? "Resultado inferior ao valor de refer\u00eancia" : "Resultado superior ao valor de refer\u00eancia";
                this.fireExibirMensagem(mensagem);
                this.setToolTipText(mensagem);
                this.marcarValorAlterado(true);
            }
        }
        this.fireAbsurdoListenerOcultar();
    }

    public boolean validarValoresConferenciaAutomatica() {
        if ((this.tipo == 1 || this.tipo == 3) && this.mascara != null && this.mascara.length() > 0) {
            int vlr = this.valores.verificaValor(this.getText());
            return this.valores != null && !this.valores.zero() && vlr == 0;
        }
        return false;
    }

    public String getValoresNormais() {
        if (this.valores == null || Funcoes.textoVazio(this.valores.getValores()[1]) && Funcoes.textoVazio(this.valores.getValores()[2])) {
            return "";
        }
        return this.valores.getValores()[1] + " a " + this.valores.getValores()[2];
    }

    @Override
    public void modificouValor() {
        this.modificou = true;
    }

    public boolean isModificou() {
        return this.modificou;
    }

    private void marcarValorAlterado(boolean alterado) {
        this.setBackground(alterado ? Campo.COR_ALTERADO : this.background);
        if (this.dono != null) {
            this.dono.setValorAlterado(alterado);
        }
    }

    @Override
    public String getValorOriginal() {
        return this.getStringValor();
    }

    public boolean getBloquearFoco() {
        return this.bloquearFoco;
    }

    public void setBloquearFoco(boolean bloquearFoco) {
        this.bloquearFoco = bloquearFoco;
        this.setFocusable(!this.bloquearFoco);
    }
}

