/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.digitacao;

import jalis.laboratorio.digitacao.TabelaSimbolosListener;
import jalis.laboratorio.digitacao.componente.CampoDigitacao;
import jalis.laboratorio.digitacao.componente.ComponenteValor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class TabelaSimbolos
implements Serializable {
    private Map<String, Object> simbolos = new HashMap<String, Object>();
    private ArrayList<TabelaSimbolosListener> listener = new ArrayList();
    private Map<String, CampoDigitacao> campos = new HashMap<String, CampoDigitacao>();
    private Map<String, Object> simbolosExternos = new HashMap<String, Object>();

    public Object getValor(String simbolo) {
        Object valor = null;
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        if (this.simbolos != null) {
            tmp.putAll(this.simbolos);
        }
        if (this.simbolosExternos != null) {
            tmp.putAll(this.simbolosExternos);
        }
        if (tmp != null) {
            if (tmp.containsKey(simbolo.toLowerCase()) || this.listener.size() == 0) {
                valor = tmp.get(simbolo.toLowerCase());
                valor = valor instanceof ComponenteValor ? ((ComponenteValor)valor).getValor() : valor;
            } else {
                for (TabelaSimbolosListener l : this.listener) {
                    Object valorRetorno = null;
                    valor = l.simboloNaoLocalizado(simbolo);
                }
            }
        }
        return valor;
    }

    public CampoDigitacao getCampoDigitacao(String nomeCampo) {
        if (this.campos != null && this.campos.get(nomeCampo.toLowerCase()) != null) {
            return this.campos.get(nomeCampo.toLowerCase());
        }
        return null;
    }

    public Map<String, ComponenteValor> getComponentesValor() {
        Object obj;
        HashMap<String, ComponenteValor> mapa = new HashMap<String, ComponenteValor>();
        for (String chave : this.simbolos.keySet()) {
            obj = this.simbolos.get(chave);
            if (!(obj instanceof ComponenteValor)) continue;
            mapa.put(chave, (ComponenteValor)obj);
        }
        for (String chave : this.simbolosExternos.keySet()) {
            obj = this.simbolosExternos.get(chave);
            if (!(obj instanceof ComponenteValor)) continue;
            mapa.put(chave, (ComponenteValor)obj);
        }
        return mapa;
    }

    public void setDados(Map<String, Object> dados) {
        if (dados != null) {
            for (String simb : dados.keySet()) {
                this.simbolos.put(simb.toLowerCase(), dados.get(simb));
            }
        }
    }

    public void setDadosExternos(Map<String, Object> dados) {
        if (dados != null) {
            for (String simb : dados.keySet()) {
                this.simbolosExternos.put(simb.toLowerCase(), dados.get(simb));
            }
        }
    }

    public void setSimbolo(String simbolo, Object valor) {
        if (simbolo != null && valor != null) {
            this.simbolos.put(simbolo.toLowerCase(), valor);
        }
    }

    public void setCampoDigitacao(CampoDigitacao campo) {
        if (campo != null && this.campos != null) {
            this.campos.put(campo.getNome().toLowerCase(), campo);
        }
    }

    public void limpar() {
        this.simbolos.clear();
        this.simbolosExternos.clear();
    }

    public void limparDados() {
        this.simbolos.clear();
    }

    public void limparDadosExternos() {
        this.simbolosExternos.clear();
    }

    public void adicionaListener(TabelaSimbolosListener l) {
        if (!this.listener.contains(l)) {
            this.listener.add(l);
        }
    }

    public Map<String, Object> getSimbolos() {
        return this.simbolos;
    }

    public ArrayList<TabelaSimbolosListener> getListener() {
        return this.listener;
    }

    public Map<String, Object> getSimbolosExternos() {
        return this.simbolosExternos;
    }
}

