/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.digitacao;

import jalis.laboratorio.configurador.componente.AbstractComponente;
import jalis.laboratorio.configurador.componente.Campo;
import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.configurador.componente.ComponenteEditor;
import jalis.laboratorio.configurador.componente.ComponenteInterfaceamento;
import jalis.laboratorio.configurador.componente.Dados;
import jalis.laboratorio.configurador.componente.Dimensionavel;
import jalis.laboratorio.configurador.componente.Expressao;
import jalis.laboratorio.configurador.componente.Externo;
import jalis.laboratorio.configurador.componente.Forma;
import jalis.laboratorio.configurador.componente.Grafico;
import jalis.laboratorio.configurador.componente.Historico;
import jalis.laboratorio.configurador.componente.Imagem;
import jalis.laboratorio.configurador.componente.ReguaReferencial;
import jalis.laboratorio.configurador.componente.ResultadoAnterior;
import jalis.laboratorio.configurador.componente.Rotulo;
import jalis.laboratorio.configurador.componente.Rtf;
import jalis.laboratorio.configurador.componente.Texto;
import jalis.laboratorio.configurador.expressao.Token;
import jalis.laboratorio.digitacao.Digitacao;
import jalis.laboratorio.digitacao.Execucao;
import jalis.laboratorio.digitacao.TabelaSimbolos;
import jalis.laboratorio.digitacao.TabelaSimbolosListener;
import jalis.laboratorio.digitacao.componente.CampoDigitacao;
import jalis.laboratorio.digitacao.componente.CampoListaDigitacao;
import jalis.laboratorio.digitacao.componente.ComponenteDigitacao;
import jalis.laboratorio.digitacao.componente.ComponenteResultado;
import jalis.laboratorio.digitacao.componente.ComponenteValor;
import jalis.laboratorio.digitacao.componente.DadosDigitacao;
import jalis.laboratorio.digitacao.componente.ExpressaoDigitacao;
import jalis.laboratorio.digitacao.componente.ExternoDigitacao;
import jalis.laboratorio.digitacao.componente.GraficoConfiguravelDigitacao;
import jalis.laboratorio.digitacao.componente.GraficoQuadranteDigitacao;
import jalis.laboratorio.digitacao.componente.GraficoReferenciaDigitacao;
import jalis.laboratorio.digitacao.componente.GraficoResultadoAnteriorDigitacao;
import jalis.laboratorio.digitacao.componente.HistoricoDigitacao;
import jalis.laboratorio.digitacao.componente.ImagemDigitacao;
import jalis.laboratorio.digitacao.componente.ReguaReferencialDigitacao;
import jalis.laboratorio.digitacao.componente.ResultadoAnteriorDigitacao;
import jalis.laboratorio.digitacao.componente.RtfDigitacao;
import jalis.laboratorio.digitacao.componente.TextoDigitacao;
import jalis.laboratorio.digitacao.evento.CampoRedimensionadoListener;
import jalis.laboratorio.digitacao.evento.MensagemEvento;
import jalis.laboratorio.digitacao.evento.MensagemListener;
import jalis.laboratorio.impressao.componente.ComponenteImpressao;
import jalis.laboratorio.impressao.componente.FormaImpressao;
import jalis.laboratorio.impressao.componente.GraficoImpressao;
import jalis.laboratorio.impressao.componente.ImagemImpressao;
import jalis.laboratorio.impressao.componente.ReguaReferencialImpressao;
import jalis.laboratorio.impressao.componente.TextoEstatico;
import jalis.laboratorio.util.parsers.ProtocoloCampoImportacao;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.text.JTextComponent;
import org.apache.commons.codec.binary.Base64;

public class Resultado {
    public static final String LAUDO = "laudo";
    public static final String IMAGENS = "imagens";
    public static final int ANTERIOR_ORDEM_CRESCENTE = 0;
    public static final int ANTERIOR_ORDEM_DECRESCENTE = 1;
    public static final int VALIDACAO_ERRO = 0;
    public static final int VALIDACAO_OK = 1;
    public static final int VALIDACAO_VAZIA = 2;
    static final String PARCIAL = "parcial";
    static final String IMPORTACAO = "importacao";
    static final String RESULTADO = "resultado";
    static final String CONFIGURACAO = "configuracao";
    static final String VERSAO = "versao";
    static final String PARAMETROS = "parametros";
    static final String PARAMETROS_ORIGINAIS = "parametrosOriginal";
    static final String CONDICAO = "condicao";
    static final String MENSAGEM = "mensagem";
    static final String VALIDACAO = "validacao";
    static final String MENSAGEM_VALIDACAO = "mensagemValidacao";
    static final String VALIDACAO_COMPULSORIA = "validacaoCompulsoria";
    static final String MENSAGEM_COMPULSORIA = "mensagemCompulsoria";
    static final String VALIDACAO_RESULTADO_CRITICO = "validacaoResultadoCritico";
    static final String MENSAGEM_RESULTADO_CRITICO = "mensagemResultadoCritico";
    static final String TIPO = "tipo";
    static final String VERSAO_EXAME = "versao-exame";
    static final String VERSAO_LAYOUT_EXAME = "versaoExame";
    private TabelaSimbolos tabela = new TabelaSimbolos();
    private Map<String, Dimensionavel> componentes = new LinkedHashMap<String, Dimensionavel>();
    private HashMap<Integer, ArrayList<String>> componentesPorPagina = new HashMap();
    private HashMap<Integer, Integer> alturaMaximaPorPagina = new HashMap();
    private Map<String, ComponenteResultado> compResultado = new HashMap<String, ComponenteResultado>();
    private Map<String, String> xml = new HashMap<String, String>();
    private Map<String, Object> dadosBanco = new HashMap<String, Object>();
    private Map<String, Object> dadosExternos = new HashMap<String, Object>();
    private List<Component> compDigitavel = new ArrayList<Component>();
    private boolean atualizar = true;
    private boolean modificarHistorico = false;
    private boolean naoRemoverCamposParcial = false;
    private boolean reposicionarComponentesPorPagina = true;
    private String versaoXML = "3.0";
    private boolean isImportacaoUltimo = true;

    public boolean isNaoRemoverCamposParcial() {
        return this.naoRemoverCamposParcial;
    }

    /*
     * WARNING - void declaration
     */
    public Resultado(final Digitacao digitacao, String atributos, Map<String, Object> dados, Map<String, Object> externos, Map<String, String> historicos, Map<String, String> historicosPorMnemonico, Map<Integer, String> resAnterior, List<Component> componentesFoco, boolean edicao, int ordemAnteriores, boolean removerTagsHTMLResultadoAnterior, String resultadoAtual, boolean mostrar) {
        ArrayList<ExpressaoDigitacao> exps = new ArrayList<ExpressaoDigitacao>();
        ArrayList<TextoDigitacao> textos = new ArrayList<TextoDigitacao>();
        ArrayList<ReguaReferencialDigitacao> reguas = new ArrayList<ReguaReferencialDigitacao>();
        HashMap<Integer, List<ResultadoAnteriorDigitacao>> mapResAnt = new HashMap<Integer, List<ResultadoAnteriorDigitacao>>();
        ArrayList<GraficoConfiguravelDigitacao> graficos = new ArrayList<GraficoConfiguravelDigitacao>();
        ArrayList<GraficoReferenciaDigitacao> graficosReferencia = new ArrayList<GraficoReferenciaDigitacao>();
        ArrayList<GraficoQuadranteDigitacao> graficosQuadrante = new ArrayList<GraficoQuadranteDigitacao>();
        ArrayList<GraficoResultadoAnteriorDigitacao> graficosResultadoAnterior = new ArrayList<GraficoResultadoAnteriorDigitacao>();
        ArrayList<ImagemDigitacao> imagens = new ArrayList<ImagemDigitacao>();
        ArrayList<FormaImpressao> formas2 = new ArrayList<FormaImpressao>();
        MensagemListener ouvinteMensagem = new MensagemListener(){

            @Override
            public void exibirMensagem(final MensagemEvento e) {
                new Thread("ThreadMensagemDigitacao"){

                    @Override
                    public void run() {
                        if (digitacao != null && digitacao.labelMensagem != null) {
                            try {
                                digitacao.labelMensagem.setText(e.getMensagem());
                                Thread.sleep(5000L);
                                digitacao.labelMensagem.setText("");
                            }
                            catch (Exception e2) {
                                ErrorLogger.mostraMensagem(null, e2.getMessage(), e2.getStackTrace(), "Resultado: 120");
                            }
                        }
                    }
                }.start();
            }
        };
        FocusAdapter ouvinteFoco = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (digitacao != null && digitacao.panelArea != null) {
                    Rectangle r = ((Component)e.getSource()).getBounds();
                    r.translate(-5, -5);
                    r.grow(10, 10);
                    digitacao.panelArea.scrollRectToVisible(r);
                    boolean tmp = Resultado.this.atualizar;
                    Resultado.this.atualizar();
                    if (tmp && e.getSource() instanceof CampoDigitacao) {
                        ((CampoDigitacao)e.getSource()).selectAll();
                    }
                }
            }
        };
        try {
            if (dados != null) {
                for (String chave : dados.keySet()) {
                    this.dadosBanco.put(chave.toLowerCase(), dados.get(chave));
                }
                this.tabela.setDados(dados);
            }
            if (externos != null) {
                for (String chave : externos.keySet()) {
                    this.dadosExternos.put(chave.toLowerCase(), externos.get(chave));
                }
            }
            String atributosOriginais = atributos;
            this.versaoXML = StringUtil.getValor(atributos, VERSAO) == null ? "1" : StringUtil.getValor(atributos, VERSAO);
            atributos = StringUtil.getValor(atributos, "exame");
            this.xml.put(VERSAO_LAYOUT_EXAME, Funcoes.textoVazio(StringUtil.getValor(atributos, VERSAO_LAYOUT_EXAME)) ? "0" : StringUtil.getValor(atributos, VERSAO_LAYOUT_EXAME));
            this.xml.put(VERSAO, this.versaoXML);
            this.xml.put(TIPO, StringUtil.getValor(atributos, TIPO));
            this.xml.put(VERSAO_EXAME, StringUtil.getValor(atributos, "versaoExameLabExterno"));
            String tmp = StringUtil.getValor(atributos, PARAMETROS);
            this.xml.put(PARAMETROS_ORIGINAIS, StringUtil.getValor(atributosOriginais, PARAMETROS, false, null, false));
            this.xml.put(PARAMETROS, tmp);
            this.xml.put(CONDICAO, StringUtil.getValor(tmp, CONDICAO));
            this.xml.put(MENSAGEM, StringUtil.getValor(tmp, "mensagemErro"));
            this.xml.put(VALIDACAO, StringUtil.getValor(tmp, VALIDACAO));
            this.xml.put(MENSAGEM_VALIDACAO, StringUtil.getValor(tmp, MENSAGEM_VALIDACAO));
            this.xml.put(MENSAGEM_COMPULSORIA, StringUtil.getValor(tmp, MENSAGEM_COMPULSORIA));
            this.xml.put(VALIDACAO_COMPULSORIA, StringUtil.getValor(tmp, VALIDACAO_COMPULSORIA));
            this.xml.put(MENSAGEM_RESULTADO_CRITICO, StringUtil.getValor(tmp, MENSAGEM_RESULTADO_CRITICO));
            this.xml.put(VALIDACAO_RESULTADO_CRITICO, StringUtil.getValor(tmp, VALIDACAO_RESULTADO_CRITICO));
            this.xml.put("tipoconfiguracao", StringUtil.getValor(atributos, "tipoConfiguracao"));
            this.xml.put("corValorReferencia", StringUtil.getValor(tmp, "corValorReferencia"));
            this.modificarHistorico = StringUtil.getBoolean(tmp, "modificarHistorico");
            this.naoRemoverCamposParcial = StringUtil.getBoolean(tmp, "naoRemoverParcial");
            boolean bl = this.reposicionarComponentesPorPagina = this.versaoXML.equals("1.0") || StringUtil.getValor(tmp, "reposicionarComponentes").trim().length() == 0 ? true : StringUtil.getBoolean(tmp, "reposicionarComponentes");
            if (this.xml.get(TIPO).equals(PARCIAL) || this.xml.get(TIPO).equals(RESULTADO)) {
                tmp = StringUtil.getValor(atributos, RESULTADO);
            } else if (this.xml.get("tipoconfiguracao").equals("2")) {
                tmp = StringUtil.getValor(atributos, "pagina");
                tmp = StringUtil.getValor(StringUtil.getValor(tmp, "itens"), "cabecalho");
            } else {
                tmp = StringUtil.getValor(atributos, "pagina");
                tmp = StringUtil.getValor(StringUtil.getValor(tmp, "itens"), "corpo");
            }
            List<String> componentesLocalizados = StringUtil.getListValores(tmp, "componente");
            int componenteMaisDistante = 0;
            for (String item : componentesLocalizados) {
                int contador;
                String xmlItem = StringUtil.getValor(item, "atributos");
                int altura = StringUtil.getInt(xmlItem, "altura");
                int topo = StringUtil.getInt(xmlItem, "topo");
                int n = contador = StringUtil.getValor(xmlItem, "contadorPagina").matches("\\d+") ? StringUtil.getInt(xmlItem, "contadorPagina") : 1;
                if (!this.componentesPorPagina.containsKey(contador)) {
                    this.componentesPorPagina.put(contador, new ArrayList());
                }
                this.componentesPorPagina.get(contador).add(item);
                if (!this.alturaMaximaPorPagina.containsKey(contador)) {
                    this.alturaMaximaPorPagina.put(contador, 0);
                    componenteMaisDistante = 0;
                }
                if (topo + altura > componenteMaisDistante) {
                    componenteMaisDistante = topo + altura;
                }
                this.alturaMaximaPorPagina.put(contador, componenteMaisDistante);
            }
            boolean possuiMesmaVersao = false;
            block7: for (Integer pag : this.componentesPorPagina.keySet()) {
                List valores = this.componentesPorPagina.get(pag);
                for (String item : valores) {
                    Componente c = (Componente)Class.forName(StringUtil.getValor(item, TIPO)).newInstance();
                    c.setAtributos(this.getAtributosComCoresDeReferencia(item));
                    Component comp = c.getComponenteDigitacao(edicao);
                    if (!(comp instanceof ComponenteResultado)) continue;
                    ComponenteResultado compRes = (ComponenteResultado)((Object)comp);
                    this.compResultado.put(compRes.getNome().toLowerCase(), compRes);
                    Map<String, ProtocoloCampoImportacao> campos = compRes.getMapCampoDeImportacao();
                    String versao = "";
                    if (campos != null && this.dadosBanco.get("superexame|codigoformato") != null) {
                        versao = this.dadosBanco.get("superexame|codigoformato").toString();
                        String campoImportacao = campos.get(versao) != null ? campos.get((Object)versao).campoImportacao.substring(campos.get((Object)versao).campoImportacao.indexOf("SuperExame"), campos.get((Object)versao).campoImportacao.length()) : compRes.getCampoDeImportacao();
                        campoImportacao = campoImportacao.replace("|Formato|", "|");
                    }
                    if (!compRes.isRelacionavelComCampoDeImportacao() || compRes.getCampoDeImportacao().trim().length() <= 0 || !compRes.getCampoDeImportacao().contains(versao)) continue;
                    possuiMesmaVersao = true;
                    continue block7;
                }
            }
            for (Integer pag : this.componentesPorPagina.keySet()) {
                List valores = this.componentesPorPagina.get(pag);
                int alturaMaximaDaPagina = 0;
                HashMap<ComponenteDigitacao, Integer> componenteRedimensionado = new HashMap<ComponenteDigitacao, Integer>();
                String componentesPorPaginaJuntos = "";
                for (String componenteAtual : valores) {
                    componentesPorPaginaJuntos = componentesPorPaginaJuntos.concat(componenteAtual);
                }
                for (String item : valores) {
                    int alturaComponenteAtual;
                    Componente c = (Componente)Class.forName(StringUtil.getValor(item, TIPO)).newInstance();
                    c.setAtributos(this.getAtributosComCoresDeReferencia(item));
                    Component comp = c.getComponenteDigitacao(edicao);
                    if (comp instanceof TextoEstatico && (((TextoEstatico)comp).getDono() instanceof Historico || ((TextoEstatico)comp).getDono() instanceof HistoricoDigitacao) && !Funcoes.textoVazio(this.versaoXML) && (this.versaoXML.equalsIgnoreCase("1.0") || this.versaoXML.equalsIgnoreCase("2.0"))) {
                        ((TextoEstatico)comp).setHorizontalAlignment(2);
                    }
                    if (pag > 1) {
                        comp.setBounds(comp.getX(), comp.getY() + this.calculaAlturaPaginaAnterior(this.alturaMaximaPorPagina, pag), comp.getWidth(), comp.getHeight());
                    }
                    this.componentes.put(comp.getName().toLowerCase(), (Dimensionavel)((Object)comp));
                    if (comp instanceof ComponenteValor) {
                        ComponenteValor compVlr = (ComponenteValor)((Object)comp);
                        this.tabela.setSimbolo(compVlr.getNome(), compVlr);
                    }
                    if (comp instanceof FormaImpressao) {
                        FormaImpressao forma = (FormaImpressao)comp;
                        formas2.add(forma);
                        forma.setTabelaSimbolos(this.tabela);
                    }
                    if (comp instanceof ComponenteDigitacao) {
                        RtfDigitacao rtfDigi;
                        String campoImportacao;
                        Map<String, ProtocoloCampoImportacao> campos;
                        Object valor;
                        comp.addFocusListener(ouvinteFoco);
                        if (comp instanceof CampoDigitacao) {
                            this.tabela.setCampoDigitacao((CampoDigitacao)comp);
                        }
                        if (comp instanceof ExpressaoDigitacao) {
                            ExpressaoDigitacao exp = (ExpressaoDigitacao)comp;
                            exps.add(exp);
                            exp.setTabelaSimbolos(this.tabela);
                        } else if (comp instanceof TextoDigitacao) {
                            if (!Funcoes.textoVazio(((TextoDigitacao)comp).getExpressao())) {
                                TextoDigitacao t = (TextoDigitacao)comp;
                                textos.add(t);
                                t.setTabelaSimbolos(this.tabela);
                            }
                            if (((TextoDigitacao)comp).getRedimensionar() && Funcoes.objectIsNull(digitacao)) {
                                Rectangle posicaoOriginal = ((ComponenteDigitacao)((Object)comp)).getDimensoes();
                                valor = "";
                                if (((TextoDigitacao)comp).getCampoDeImportacao().contains("~") && this.dadosBanco.get("superexame|codigoformato") != null) {
                                    campos = ((TextoDigitacao)comp).getMapCampoDeImportacao();
                                    if (campos != null) {
                                        int pos;
                                        String string = this.dadosBanco.get("superexame|codigoformato").toString();
                                        campoImportacao = campos.get(string) != null ? campos.get((Object)string).campoImportacao.substring(campos.get((Object)string).campoImportacao.indexOf("SuperExame"), campos.get((Object)string).campoImportacao.length()) : ((TextoDigitacao)comp).getCampoDeImportacao();
                                        valor = this.dadosBanco.get((campoImportacao = campoImportacao.replace("|Formato|", "|")).toLowerCase());
                                        if (valor == null) {
                                            campoImportacao = campoImportacao.replace("|Formatos|", "|");
                                            valor = this.dadosBanco.get(campoImportacao.toLowerCase());
                                        }
                                        if (valor == null) {
                                            valor = dados.get(campoImportacao.toLowerCase() + "_" + comp.getName().toLowerCase());
                                        }
                                        if (valor == null && (pos = campoImportacao.indexOf("|SuperExame")) > -1) {
                                            valor = this.dadosBanco.get(campoImportacao.substring(pos + 1).toLowerCase());
                                        }
                                        if (valor == null && (pos = campoImportacao.indexOf("|")) > -1) {
                                            valor = this.dadosBanco.get(campoImportacao.substring(pos + 1, campoImportacao.length()).toLowerCase());
                                        }
                                    }
                                } else {
                                    valor = this.dadosBanco.get(((TextoDigitacao)comp).getCampoDeImportacao().toLowerCase());
                                    if (valor == null) {
                                        valor = this.dadosBanco.get(((TextoDigitacao)comp).getCampoDeImportacao().toLowerCase() + "_" + comp.getName().toLowerCase());
                                    }
                                    if (valor != null && valor.toString().trim().length() > 0 && comp instanceof TextoDigitacao && ((TextoDigitacao)comp).getRedimensionar() && !valor.toString().substring(valor.toString().length() - 1, valor.toString().length()).equals("\n")) {
                                        valor = valor.toString().concat("\n");
                                    }
                                }
                                Integer alturaMaximaPagina = null;
                                try {
                                    String string = StringUtil.getValor(atributos, "propriedades");
                                    String altura = StringUtil.getValor(StringUtil.getValor(string, "dimensoes"), "altura");
                                    String margemSuperior = StringUtil.getValor(string, "margemSuperior");
                                    String margemInferior = StringUtil.getValor(string, "margemInferior");
                                    alturaMaximaPagina = Integer.parseInt(altura) - Integer.parseInt(margemSuperior) - Integer.parseInt(margemInferior);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (Funcoes.objectIsNull(digitacao)) {
                                    void var44_85;
                                    posicaoOriginal = ((ComponenteDigitacao)((Object)comp)).getDimensoes();
                                    String string = ((TextoDigitacao)comp).getCampoDeImportacao().toLowerCase();
                                    if (string.contains("~") && this.dadosBanco.get("superexame|codigoformato") != null) {
                                        String string3 = ((TextoDigitacao)comp).getCampoDeImportacao().toLowerCase();
                                        string3 = string3.substring(string3.indexOf("|") + 1);
                                    }
                                    if (!Funcoes.objectIsNull(this.dadosBanco.get(var44_85))) {
                                        ((TextoDigitacao)comp).setText(this.dadosBanco.get(var44_85).toString());
                                        Rectangle posicaoAtual = ((TextoDigitacao)comp).getDimensoes();
                                        int posicaoAtualAltura = ((TextoDigitacao)comp).getPreferredSize().height;
                                        if (!Funcoes.objectIsNull(alturaMaximaPagina) && posicaoAtualAltura > alturaMaximaPagina - posicaoOriginal.y) {
                                            posicaoAtualAltura = alturaMaximaPagina - posicaoOriginal.y;
                                        }
                                        int diferencaAltura = posicaoAtualAltura - posicaoOriginal.height;
                                        if (!componenteRedimensionado.containsKey((ComponenteDigitacao)((Object)comp))) {
                                            componenteRedimensionado.put((ComponenteDigitacao)((Object)comp), diferencaAltura);
                                        }
                                    }
                                }
                            }
                        } else if (comp instanceof ReguaReferencialDigitacao) {
                            ReguaReferencialDigitacao rd = (ReguaReferencialDigitacao)comp;
                            reguas.add(rd);
                            rd.setTabelaSimbolos(this.tabela);
                        } else if (comp instanceof CampoDigitacao) {
                            CampoDigitacao cd = (CampoDigitacao)comp;
                            cd.setTabela(this.tabela);
                        } else if (comp instanceof CampoListaDigitacao) {
                            CampoListaDigitacao cld = (CampoListaDigitacao)comp;
                            cld.setTabelaSimbolo(this.tabela);
                        } else if (comp instanceof HistoricoDigitacao) {
                            HistoricoDigitacao his = (HistoricoDigitacao)comp;
                            his.setPermissaoAlterar(this.modificarHistorico);
                            his.setHistoricos(historicos, historicosPorMnemonico);
                        } else if (comp instanceof DadosDigitacao) {
                            DadosDigitacao dig = (DadosDigitacao)comp;
                            dig.setValor(this.dadosBanco.get(dig.getCampoBanco().toLowerCase()));
                        } else if (comp instanceof ExternoDigitacao) {
                            ExternoDigitacao ext = (ExternoDigitacao)comp;
                            ext.setValor(this.dadosExternos.get(ext.getCampoExterno().toLowerCase()));
                        } else if (comp instanceof ImagemDigitacao) {
                            ComponenteInterfaceamento inter;
                            Object object;
                            ImagemDigitacao img = (ImagemDigitacao)comp;
                            img.setTabelaSimbolos(this.tabela);
                            imagens.add(img);
                            String campoImportacao3 = img.getCampoDeImportacao();
                            if (img.getCampoDoBanco().trim().length() > 0) {
                                Object o = this.dadosBanco.get(img.getCampoDoBanco().toLowerCase());
                                if (o != null) {
                                    img.setImagem(o.toString());
                                }
                            } else if (this.verificaCampoImportacaoImagem(campoImportacao3)) {
                                this.setImagemCampoImportacao(dados, img, campoImportacao3);
                            } else if (comp instanceof ComponenteInterfaceamento && (object = this.dadosBanco.get((inter = (ComponenteInterfaceamento)((Object)comp)).getCampoInterfaceamento().toLowerCase())) != null && object.toString().trim().length() > 0) {
                                img.setImagem(object.toString());
                            }
                        } else if (comp instanceof ResultadoAnteriorDigitacao) {
                            ResultadoAnteriorDigitacao ra = (ResultadoAnteriorDigitacao)comp;
                            ArrayList<ResultadoAnteriorDigitacao> list = (ArrayList<ResultadoAnteriorDigitacao>)mapResAnt.get(ra.getOrdem());
                            if (list == null) {
                                list = new ArrayList<ResultadoAnteriorDigitacao>();
                                mapResAnt.put(ra.getOrdem(), list);
                            }
                            list.add(ra);
                        } else if (comp instanceof GraficoResultadoAnteriorDigitacao) {
                            GraficoResultadoAnteriorDigitacao grafico = (GraficoResultadoAnteriorDigitacao)comp;
                            HashMap clone = null;
                            if (resAnterior != null) {
                                clone = (HashMap)((HashMap)resAnterior).clone();
                            }
                            String valorAtual = null;
                            if (!Funcoes.textoVazio(resultadoAtual)) {
                                void var44_90;
                                Object var44_88 = null;
                                if (grafico.getDono() instanceof ComponenteEditor) {
                                    String string = ((ComponenteEditor)((Object)grafico.getDono())).getTagResultado();
                                }
                                if (!Funcoes.textoVazio((String)var44_90) && !var44_90.equalsIgnoreCase("null")) {
                                    valorAtual = StringUtil.getValorAtributoTagCampo("tagResultado".toLowerCase(), var44_90.toLowerCase(), resultadoAtual);
                                }
                                if (Funcoes.textoVazio(valorAtual)) {
                                    valorAtual = StringUtil.getValor(resultadoAtual, ((Grafico)grafico.getDono()).getOrigem().toLowerCase());
                                }
                                if (Funcoes.textoVazio(valorAtual)) {
                                    List<String> components = StringUtil.getListValores(resultadoAtual, "componente");
                                    for (String xml : components) {
                                        String atributs = StringUtil.getValor(xml, "atributos");
                                        String nome = StringUtil.getValor(atributs, "nome");
                                        if (!nome.equalsIgnoreCase(((Grafico)grafico.getDono()).getOrigem())) continue;
                                        valorAtual = StringUtil.getValor(atributs, "valorResultado");
                                        break;
                                    }
                                }
                            }
                            grafico.setTabelaSimbolos(this.tabela);
                            grafico.setResultadosAnteriores(clone, ordemAnteriores == 0, valorAtual);
                            graficosResultadoAnterior.add(grafico);
                        } else if (comp instanceof GraficoConfiguravelDigitacao) {
                            GraficoConfiguravelDigitacao grafico = (GraficoConfiguravelDigitacao)comp;
                            graficos.add(grafico);
                            grafico.setTabelaSimbolos(this.tabela);
                        } else if (comp instanceof GraficoReferenciaDigitacao) {
                            GraficoReferenciaDigitacao grafico = (GraficoReferenciaDigitacao)comp;
                            graficosReferencia.add(grafico);
                            grafico.setTabelaSimbolos(this.tabela);
                        } else if (comp instanceof GraficoQuadranteDigitacao) {
                            GraficoQuadranteDigitacao grafico = (GraficoQuadranteDigitacao)comp;
                            graficosQuadrante.add(grafico);
                            grafico.setTabelaSimbolos(this.tabela);
                        } else if (comp instanceof RtfDigitacao && !Funcoes.textoVazio((rtfDigi = (RtfDigitacao)comp).getExpressao())) {
                            rtfDigi.setTabelaSimbolos(this.tabela);
                        }
                        if (comp instanceof ComponenteResultado) {
                            ComponenteResultado compRes = (ComponenteResultado)((Object)comp);
                            this.compResultado.put(compRes.getNome().toLowerCase(), compRes);
                            compRes.addMensagemListener(ouvinteMensagem);
                            compRes.setComponentesFoco(componentesFoco);
                            if (compRes instanceof CampoDigitacao) {
                                ((CampoDigitacao)compRes).carregarValorPadrao();
                            } else if (compRes instanceof HistoricoDigitacao && Funcoes.textoVazio(((HistoricoDigitacao)compRes).getText())) {
                                ((HistoricoDigitacao)compRes).carregarValorPadrao();
                            }
                            if (compRes.digitavel()) {
                                ScreenUtil.inserirOrdenadoXY((Component)((Object)compRes), this.compDigitavel);
                            }
                            if (comp instanceof ComponenteInterfaceamento && ((ComponenteInterfaceamento)((Object)comp)).getCampoInterfaceamento().trim().length() > 0) {
                                ComponenteInterfaceamento inter = (ComponenteInterfaceamento)((Object)comp);
                                Object valor3 = this.dadosBanco.get(inter.getCampoInterfaceamento().toLowerCase() + "_" + comp.getName().toLowerCase());
                                if (valor3 == null) {
                                    valor3 = this.dadosBanco.get(inter.getCampoInterfaceamento().toLowerCase());
                                }
                                if (valor3 != null && valor3.toString().trim().length() > 0) {
                                    if (valor3.toString().equals(CampoListaDigitacao.VAZIO)) {
                                        compRes.setValor("");
                                    } else {
                                        compRes.setValor(valor3);
                                    }
                                }
                            }
                            if (compRes.isRelacionavelComCampoDeImportacao() && compRes.getCampoDeImportacao().trim().length() > 0) {
                                if (compRes.getCampoDeImportacao().contains("~") && this.dadosBanco.get("superexame|codigoformato") != null) {
                                    valor = null;
                                    campos = compRes.getMapCampoDeImportacao();
                                    if (campos != null) {
                                        int pos;
                                        String string = this.dadosBanco.get("superexame|codigoformato").toString();
                                        campoImportacao = campos.get(string) != null ? campos.get((Object)string).campoImportacao.substring(campos.get((Object)string).campoImportacao.indexOf("SuperExame"), campos.get((Object)string).campoImportacao.length()) : compRes.getCampoDeImportacao();
                                        valor = this.dadosBanco.get((campoImportacao = campoImportacao.replace("|Formato|", "|")).toLowerCase());
                                        if (valor == null) {
                                            campoImportacao = campoImportacao.replace("|Formatos|", "|");
                                            valor = this.dadosBanco.get(campoImportacao.toLowerCase());
                                        }
                                        if (valor == null) {
                                            valor = dados.get(campoImportacao.toLowerCase() + "_" + comp.getName().toLowerCase());
                                        }
                                        if (valor == null && (pos = campoImportacao.indexOf("|SuperExame")) > -1) {
                                            valor = this.dadosBanco.get(campoImportacao.substring(pos + 1).toLowerCase());
                                        }
                                        if (valor == null && (pos = campoImportacao.indexOf("|")) > -1) {
                                            valor = this.dadosBanco.get(campoImportacao.substring(pos + 1, campoImportacao.length()).toLowerCase());
                                        }
                                        if (valor != null && valor.toString().trim().length() > 0) {
                                            for (String camp : compRes.getMapCampoDeImportacao().keySet()) {
                                                if (Funcoes.textoVazio(compRes.getMapCampoDeImportacao().get((Object)camp).campoImportacao)) continue;
                                                String v1 = compRes.getMapCampoDeImportacao().get((Object)camp).campoImportacao.substring(compRes.getMapCampoDeImportacao().get((Object)camp).campoImportacao.indexOf("~") + 1, compRes.getMapCampoDeImportacao().get((Object)camp).campoImportacao.indexOf("|"));
                                                if ((!possuiMesmaVersao || !v1.equals(string)) && possuiMesmaVersao) continue;
                                                compRes.setValor(valor);
                                            }
                                        }
                                    }
                                } else if (compRes.getCampoDeImportacao().contains("~") && compRes.getMapCampoDeImportacao().size() > 1) {
                                    String versaoResultadoImportado = "";
                                    for (String string : this.dadosBanco.keySet()) {
                                        if (!string.startsWith("~") || !string.contains("|")) continue;
                                        versaoResultadoImportado = string.substring(1, string.indexOf("|"));
                                        break;
                                    }
                                    if (!Funcoes.textoVazio(versaoResultadoImportado)) {
                                        for (Map.Entry entry : compRes.getMapCampoDeImportacao().entrySet()) {
                                            String versaoConfigLaudo;
                                            if (Funcoes.textoVazio(((ProtocoloCampoImportacao)entry.getValue()).campoImportacao) || !(versaoConfigLaudo = ((ProtocoloCampoImportacao)entry.getValue()).campoImportacao.substring(1, ((ProtocoloCampoImportacao)entry.getValue()).campoImportacao.indexOf("|"))).equals(versaoResultadoImportado)) continue;
                                            Object valor4 = this.dadosBanco.get(((ProtocoloCampoImportacao)entry.getValue()).campoImportacao.toLowerCase());
                                            compRes.setValor(valor4);
                                        }
                                    }
                                } else {
                                    valor = this.dadosBanco.get(compRes.getCampoDeImportacao().toLowerCase());
                                    if (valor == null) {
                                        valor = this.dadosBanco.get(compRes.getCampoDeImportacao().toLowerCase() + "_" + comp.getName().toLowerCase());
                                    }
                                    if (valor != null && valor.toString().trim().length() > 0 && !(comp instanceof RtfDigitacao) && !valor.toString().startsWith("{\\rtf")) {
                                        if (comp instanceof TextoDigitacao && ((TextoDigitacao)comp).getRedimensionar() && !valor.toString().substring(valor.toString().length() - 1, valor.toString().length()).equals("\n")) {
                                            valor = valor.toString().concat("\n");
                                        }
                                        compRes.setValor(valor);
                                    } else if (valor != null && valor.toString().trim().length() > 0 && comp instanceof RtfDigitacao && valor.toString().startsWith("{\\rtf")) {
                                        valor = valor.toString();
                                        compRes.setValor(valor);
                                    }
                                }
                            }
                        }
                    }
                    if (alturaMaximaDaPagina >= (alturaComponenteAtual = ((Dimensionavel)((Object)comp)).getDimensoes().y + ((Dimensionavel)((Object)comp)).getDimensoes().height)) continue;
                    alturaMaximaDaPagina = alturaComponenteAtual;
                }
                for (ComponenteDigitacao componenteDigitacao : componenteRedimensionado.keySet()) {
                    if ((Integer)componenteRedimensionado.get(componenteDigitacao) >= 0) continue;
                    for (Dimensionavel dim : this.componentes.values()) {
                        int alturaComponenteAtual;
                        if (!componentesPorPaginaJuntos.contains(StringUtil.getTag("nome", dim.getNome()))) continue;
                        if (dim.getNome().equals(componenteDigitacao.getNome())) {
                            Rectangle rec = dim.getDimensoes();
                            rec.height -= ((Integer)componenteRedimensionado.get(componenteDigitacao)).intValue();
                            dim.setDimensoes(rec);
                        } else if (dim.getDimensoes().getY() > (double)(componenteDigitacao.getDimensoes().y + componenteDigitacao.getDimensoes().height + (Integer)componenteRedimensionado.get(componenteDigitacao))) {
                            Rectangle rec = dim.getDimensoes();
                            if ((Integer)componenteRedimensionado.get(componenteDigitacao) > 0) {
                                rec.y += ((Integer)componenteRedimensionado.get(componenteDigitacao)).intValue();
                            }
                            dim.setDimensoes(rec);
                        }
                        if (alturaMaximaDaPagina >= (alturaComponenteAtual = dim.getDimensoes().y + dim.getDimensoes().height)) continue;
                        alturaMaximaDaPagina = alturaComponenteAtual;
                    }
                }
                this.alturaMaximaPorPagina.put((int)pag, alturaMaximaDaPagina);
            }
            this.ligarCampoExpressao(exps, this.compResultado);
            this.ligarCampoTexto(textos, this.compResultado);
            this.ligarCampoReguaReferencial(reguas, this.compResultado);
            this.ligarCampoGrafico(graficos, this.compResultado);
            this.ligarCampoGraficoReferencia(graficosReferencia, this.compResultado);
            this.ligarCampoGraficoQuadrante(graficosQuadrante, this.compResultado);
            this.ligarCampoGraficoResultadoAnterior(graficosResultadoAnterior, this.compResultado);
            this.ligarCampoImagem(imagens, this.compResultado);
            this.ligarCampoForma(formas2, this.compResultado);
            this.setFocoPrimeiro();
            this.carregarResultadoAnterior(mapResAnt, resAnterior, ordemAnteriores, removerTagsHTMLResultadoAnterior);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(digitacao, e.getMessage(), e.getStackTrace(), "Resultado: 252");
        }
    }

    public Resultado(Digitacao digitacao, String atributos, Map<String, Object> dados, Map<String, Object> externos, Map<String, String> historicos, Map<String, String> historicosPorMnemonico, Map<Integer, String> resAnterior, List<Component> componentesFoco, boolean edicao, int ordemAnteriores, boolean removerTagsHTMLResultadoAnterior, String resultadoAtual) {
        this(digitacao, atributos, dados, externos, historicos, historicosPorMnemonico, resAnterior, componentesFoco, edicao, ordemAnteriores, removerTagsHTMLResultadoAnterior, resultadoAtual, true);
    }

    public void setImagemCampoImportacao(Map<String, Object> dados, ImagemDigitacao img, String campoImportacao) {
        Object o;
        Object object = o = dados != null ? dados.get(campoImportacao.substring(0, campoImportacao.indexOf("@"))) : null;
        if (o != null) {
            img.setImagem(o.toString());
        }
    }

    public boolean verificaCampoImportacaoImagem(String campoImportacao) {
        return campoImportacao.length() > 0 && campoImportacao.contains("@");
    }

    public String getAtributosComCoresDeReferencia(String item) {
        String atributos = StringUtil.getValor(item, "atributos");
        if (StringUtil.getValor(item, "colorirReferencia").equals("true")) {
            atributos = atributos.concat(StringUtil.getTag("corValorReferencia", this.xml.get("corValorReferencia")));
        }
        return atributos;
    }

    private int calculaAlturaPaginaAnterior(Map<Integer, Integer> paginas, int paginaParaCalcular) {
        if (paginaParaCalcular > paginas.size() && paginaParaCalcular - 1 <= 0) {
            return 0;
        }
        int retorno = 0;
        for (int i = paginaParaCalcular - 1; i >= 1; --i) {
            retorno += paginas.containsKey(i) ? paginas.get(i) : 0;
        }
        return retorno;
    }

    public Resultado(String atributos, Map<String, Object> dados, Map<Integer, String> resAnterior, int ordemAnteriores) {
        this(null, atributos, dados, null, null, null, resAnterior, null, false, ordemAnteriores, false, null);
    }

    public Resultado(String atributos, Map<String, Object> dados, Map<Integer, String> resAnterior, int ordemAnteriores, Map<String, String> historicos, Map<String, String> historicosPorMnemonico) {
        this(null, atributos, dados, null, historicos, historicosPorMnemonico, resAnterior, null, false, ordemAnteriores, false, null);
    }

    public Resultado(String atributos, Map<String, Object> dados, Map<String, Object> externos, Map<Integer, String> resAnterior, int ordemAnteriores, boolean removerTagsHTMLResultadoAnterior) {
        this(null, atributos, dados, externos, null, null, resAnterior, null, false, ordemAnteriores, removerTagsHTMLResultadoAnterior, null);
    }

    public Resultado(String atributos, Map<String, Object> dados, Map<String, Object> externos, Map<Integer, String> resAnterior, Map<String, String> historicos, Map<String, String> historicosPorMnemonico, int ordemAnteriores, String resultadoAtual) {
        this(null, atributos, dados, externos, historicos, historicosPorMnemonico, resAnterior, null, false, ordemAnteriores, false, resultadoAtual);
    }

    public Resultado(String atributos) {
        this(null, atributos, null, null, null, null, null, null, false, 1, false, null);
    }

    public Resultado(String atributos, boolean edicao, boolean mostrarErrorLogger) {
        this(null, atributos, null, null, null, null, null, null, edicao, 1, false, null, mostrarErrorLogger);
    }

    public Resultado(String atributos, boolean edicao) {
        this(null, atributos, null, null, null, null, null, null, edicao, 1, false, null);
    }

    public Resultado(String atributos, Map<String, Object> dados) {
        this(null, atributos, dados, null, null, null, null, null, false, 1, false, null);
    }

    public Resultado(String atributos, Map<String, Object> dados, boolean edicao) {
        this(null, atributos, dados, null, null, null, null, null, edicao, 1, false, null);
    }

    String getAtributo(String chave) {
        String valor = this.xml.get(chave);
        return valor == null ? "" : valor;
    }

    public List<Component> getComponentes() {
        ArrayList<Component> comps = new ArrayList<Component>();
        for (Dimensionavel dim : this.componentes.values()) {
            if (!(dim instanceof Component)) continue;
            comps.add((Component)((Object)dim));
        }
        return comps;
    }

    void setFocoPrimeiro() {
        if (!this.compDigitavel.isEmpty()) {
            ScreenUtil.requisitarFoco(this.compDigitavel.get(0));
        }
    }

    boolean setFocoProximo() {
        boolean encontrou = false;
        for (Component comp : this.compDigitavel) {
            if (comp.hasFocus()) {
                encontrou = true;
                continue;
            }
            if (!encontrou) continue;
            ScreenUtil.requisitarFoco(comp);
            return true;
        }
        return false;
    }

    public void setImportacaoUltimo(boolean isImportacaoUltimo) {
        this.isImportacaoUltimo = isImportacaoUltimo;
    }

    void setFocoAnterior() {
        Component anterior = null;
        for (Component comp : this.compDigitavel) {
            if (comp.hasFocus()) {
                ScreenUtil.requisitarFoco(anterior);
                return;
            }
            anterior = comp;
        }
    }

    void limpar() {
        for (ComponenteResultado comp : this.compResultado.values()) {
            if (comp instanceof DadosDigitacao) continue;
            comp.limpar();
        }
        this.atualizar = true;
    }

    Component getPrimeiroCampoVazio() {
        for (Component c : this.compDigitavel) {
            if (!(c instanceof ComponenteDigitacao) || ((ComponenteDigitacao)((Object)c)).removerVazio() || !((ComponenteDigitacao)((Object)c)).vazio()) continue;
            return c;
        }
        return null;
    }

    Component getPrimeiroComponenteDoTipo(Class<? extends ComponenteDigitacao> tipo) {
        if (tipo != null) {
            for (Component c : this.compDigitavel) {
                if (!tipo.isInstance(c)) continue;
                return c;
            }
        }
        return null;
    }

    public boolean resultadoCompleto(boolean verificarSalvarParcial) {
        for (Dimensionavel d : this.componentes.values()) {
            if (!(d instanceof ComponenteDigitacao) || (!verificarSalvarParcial || !this.naoRemoverCamposParcial) && ((ComponenteDigitacao)d).removerVazio() || !((ComponenteDigitacao)d).vazio()) continue;
            return false;
        }
        return true;
    }

    public String getNomeCampoSemResultado() {
        for (Dimensionavel d : this.componentes.values()) {
            if (!(d instanceof ComponenteDigitacao) || ((ComponenteDigitacao)d).removerVazio() || !((ComponenteDigitacao)d).vazio()) continue;
            return ((ComponenteDigitacao)d).getNome();
        }
        return "";
    }

    public String getResultado() {
        return this.getResultado(true);
    }

    public String getResultado(boolean reprocessar) {
        return this.gerarResultado(RESULTADO, true, reprocessar);
    }

    public String getResultadoPergunta() {
        return this.gerarResultado(RESULTADO, false, true);
    }

    public String getResultadoParcialValidandoCamposRemover() {
        return this.gerarResultado(PARCIAL, !this.naoRemoverCamposParcial, true);
    }

    public String getResultadoValidandoCamposRemover(boolean reprocessar) {
        return this.gerarResultado(RESULTADO, !this.naoRemoverCamposParcial, reprocessar);
    }

    public String getResultadoParcial() {
        return this.gerarResultado(PARCIAL, !this.naoRemoverCamposParcial, true);
    }

    public String getResultadoImportacao() {
        return this.gerarResultado(IMPORTACAO, true, true);
    }

    public String getResultadoParcial(double zoom) {
        return this.gerarResultado(PARCIAL, !this.naoRemoverCamposParcial, true, zoom);
    }

    public Map<String, Object> getCamposInterfaceamento() {
        HashMap<String, Object> campos = new HashMap<String, Object>();
        ArrayList<String> tmp = new ArrayList<String>();
        HashSet<String> duplicados = new HashSet<String>();
        for (ComponenteResultado comp : this.compResultado.values()) {
            if (!(comp instanceof ComponenteInterfaceamento) || comp.vazio() || ((ComponenteInterfaceamento)((Object)comp)).getCampoInterfaceamento().toLowerCase().equalsIgnoreCase("null")) continue;
            duplicados.add(((ComponenteInterfaceamento)((Object)comp)).getCampoInterfaceamento().toLowerCase());
            if (tmp.contains(((ComponenteInterfaceamento)((Object)comp)).getCampoInterfaceamento().toLowerCase())) continue;
            tmp.add(((ComponenteInterfaceamento)((Object)comp)).getCampoInterfaceamento().toLowerCase());
            duplicados.remove(((ComponenteInterfaceamento)((Object)comp)).getCampoInterfaceamento().toLowerCase());
        }
        ArrayList<String> listaAdicionados = new ArrayList<String>();
        for (ComponenteResultado componenteResultado : this.compResultado.values()) {
            if (!(componenteResultado instanceof ComponenteInterfaceamento) || componenteResultado.vazio()) continue;
            if (!duplicados.contains(((ComponenteInterfaceamento)((Object)componenteResultado)).getCampoInterfaceamento().toLowerCase())) {
                campos.put(((ComponenteInterfaceamento)((Object)componenteResultado)).getCampoInterfaceamento().toLowerCase(), componenteResultado.getStringValor());
                continue;
            }
            if (!listaAdicionados.contains(((ComponenteInterfaceamento)((Object)componenteResultado)).getCampoInterfaceamento().toLowerCase())) {
                campos.put(((ComponenteInterfaceamento)((Object)componenteResultado)).getCampoInterfaceamento().toLowerCase(), componenteResultado.getStringValor());
            } else {
                campos.put(((ComponenteInterfaceamento)((Object)componenteResultado)).getCampoInterfaceamento().toLowerCase() + "_" + componenteResultado.getNome(), componenteResultado.getStringValor());
            }
            listaAdicionados.add(((ComponenteInterfaceamento)((Object)componenteResultado)).getCampoInterfaceamento().toLowerCase());
        }
        for (Dimensionavel dimensionavel : this.componentes.values()) {
            if (!(dimensionavel instanceof GraficoResultadoAnteriorDigitacao)) continue;
            String valor = ((GraficoResultadoAnteriorDigitacao)dimensionavel).getStringValor();
            valor = valor.replaceAll("valor", "valoraux");
            campos.put(((GraficoResultadoAnteriorDigitacao)dimensionavel).getNome().toLowerCase() + "_" + ((GraficoResultadoAnteriorDigitacao)dimensionavel).getNome(), valor);
        }
        return campos;
    }

    public String getResultadoAnterior(Date dataBase, Date horaBase) {
        StringBuilder bui = new StringBuilder();
        for (Dimensionavel d : this.componentes.values()) {
            Componente comp = d.getDono();
            if (comp == null || !comp.getResultadoAnterior()) continue;
            if (d instanceof ComponenteDigitacao) {
                comp.setValorResultado(((ComponenteDigitacao)d).getStringValor());
            }
            if (comp instanceof ComponenteEditor) {
                bui.append(StringUtil.getTag(comp.getNome().toLowerCase(), comp.getValorResultado(), "tagResultado", ((ComponenteEditor)((Object)comp)).getTagResultado()));
                continue;
            }
            bui.append(StringUtil.getTag(comp.getNome().toLowerCase(), comp.getValorResultado()));
        }
        bui.append(StringUtil.getTag("dataResultado", new SimpleDateFormat("dd/MM/yyyy").format(dataBase != null ? dataBase : new Date())));
        bui.append(StringUtil.getTag("horaResultado", new SimpleDateFormat("HH:mm").format(horaBase != null ? horaBase : new Date())));
        return bui.toString();
    }

    public static Map<String, Object> getCamposResultado(String xmlResultado) {
        return Resultado.getCamposResultado(xmlResultado, false);
    }

    public static Map<String, Object> getCamposResultado(String xmlResultado, boolean valoresOriginais) {
        HashMap<String, Object> campos = new HashMap<String, Object>();
        Resultado res = new Resultado(xmlResultado);
        if (res.xml.get(TIPO).equals(RESULTADO)) {
            for (Component comp : res.getComponentes()) {
                if (!(comp instanceof ComponenteValor)) continue;
                ComponenteValor compVlr = (ComponenteValor)((Object)comp);
                campos.put(compVlr.getNome().toLowerCase(), valoresOriginais ? compVlr.getValorOriginal() : (compVlr instanceof TextoEstatico ? ((TextoEstatico)compVlr).getText() : (compVlr.getValor() != null ? compVlr.getValor() : "")));
            }
        }
        return campos;
    }

    public static Map<String, Object> getTodosCamposResultado(String xmlResultado, boolean valoresOriginais) {
        HashMap<String, Object> campos = new HashMap<String, Object>();
        Resultado res = new Resultado(xmlResultado);
        if (res.xml.get(TIPO).equals(RESULTADO)) {
            for (Component comp : res.getComponentes()) {
                ComponenteResultado aux;
                if (comp instanceof CampoDigitacao) {
                    aux = (CampoDigitacao)comp;
                    campos.put(((CampoDigitacao)aux).getNome().toLowerCase(), valoresOriginais ? ((CampoDigitacao)aux).getValorOriginal() : ((CampoDigitacao)aux).getValor());
                    continue;
                }
                if (comp instanceof ExpressaoDigitacao) {
                    aux = (ExpressaoDigitacao)comp;
                    campos.put(((ExpressaoDigitacao)aux).getNome().toLowerCase(), valoresOriginais ? ((ExpressaoDigitacao)aux).getValorOriginal() : ((ExpressaoDigitacao)aux).getValor());
                    continue;
                }
                if (comp instanceof HistoricoDigitacao) {
                    aux = (HistoricoDigitacao)comp;
                    campos.put(((HistoricoDigitacao)aux).getNome().toLowerCase(), valoresOriginais ? ((HistoricoDigitacao)aux).getValorOriginal() : ((HistoricoDigitacao)aux).getValor());
                    continue;
                }
                if (comp instanceof DadosDigitacao) {
                    aux = (DadosDigitacao)comp;
                    campos.put(((DadosDigitacao)aux).getNome().toLowerCase(), valoresOriginais ? ((DadosDigitacao)aux).getValorOriginal() : ((DadosDigitacao)aux).getValor());
                    continue;
                }
                if (comp instanceof ExternoDigitacao) {
                    aux = (ExternoDigitacao)comp;
                    campos.put(((ExternoDigitacao)aux).getNome().toLowerCase(), valoresOriginais ? ((ExternoDigitacao)aux).getValorOriginal() : ((ExternoDigitacao)aux).getValor());
                    continue;
                }
                if (comp instanceof ComponenteResultado) {
                    aux = (ComponenteResultado)((Object)comp);
                    campos.put(aux.getNome().toLowerCase(), valoresOriginais ? aux.getValorOriginal() : aux.getValor());
                    continue;
                }
                if (!(comp instanceof ComponenteValor)) continue;
                ComponenteValor compVlr = (ComponenteValor)((Object)comp);
                campos.put(compVlr.getNome().toLowerCase(), valoresOriginais ? compVlr.getValorOriginal() : (compVlr instanceof TextoEstatico ? ((TextoEstatico)compVlr).getText() : (compVlr.getValor() != null ? compVlr.getValor() : "")));
            }
        }
        return campos;
    }

    public static Map<String, Object> getTodosCamposResultado(String xmlResultado, boolean valoresOriginais, boolean mostrarErroLogger) {
        HashMap<String, Object> campos = new HashMap<String, Object>();
        Resultado res = new Resultado(xmlResultado, false, mostrarErroLogger);
        if (res.xml.get(TIPO).equals(RESULTADO)) {
            for (Component comp : res.getComponentes()) {
                ComponenteResultado aux;
                if (comp instanceof CampoDigitacao) {
                    aux = (CampoDigitacao)comp;
                    campos.put(((CampoDigitacao)aux).getNome().toLowerCase(), valoresOriginais ? ((CampoDigitacao)aux).getValorOriginal() : ((CampoDigitacao)aux).getValor());
                    continue;
                }
                if (comp instanceof ExpressaoDigitacao) {
                    aux = (ExpressaoDigitacao)comp;
                    campos.put(((ExpressaoDigitacao)aux).getNome().toLowerCase(), valoresOriginais ? ((ExpressaoDigitacao)aux).getValorOriginal() : ((ExpressaoDigitacao)aux).getValor());
                    continue;
                }
                if (comp instanceof HistoricoDigitacao) {
                    aux = (HistoricoDigitacao)comp;
                    campos.put(((HistoricoDigitacao)aux).getNome().toLowerCase(), valoresOriginais ? ((HistoricoDigitacao)aux).getValorOriginal() : ((HistoricoDigitacao)aux).getValor());
                    continue;
                }
                if (comp instanceof DadosDigitacao) {
                    aux = (DadosDigitacao)comp;
                    campos.put(((DadosDigitacao)aux).getNome().toLowerCase(), valoresOriginais ? ((DadosDigitacao)aux).getValorOriginal() : ((DadosDigitacao)aux).getValor());
                    continue;
                }
                if (comp instanceof ExternoDigitacao) {
                    aux = (ExternoDigitacao)comp;
                    campos.put(((ExternoDigitacao)aux).getNome().toLowerCase(), valoresOriginais ? ((ExternoDigitacao)aux).getValorOriginal() : ((ExternoDigitacao)aux).getValor());
                    continue;
                }
                if (comp instanceof ComponenteResultado) {
                    aux = (ComponenteResultado)((Object)comp);
                    campos.put(aux.getNome().toLowerCase(), valoresOriginais ? aux.getValorOriginal() : aux.getValor());
                    continue;
                }
                if (!(comp instanceof ComponenteValor)) continue;
                ComponenteValor compVlr = (ComponenteValor)((Object)comp);
                campos.put(compVlr.getNome().toLowerCase(), valoresOriginais ? compVlr.getValorOriginal() : (compVlr instanceof TextoEstatico ? ((TextoEstatico)compVlr).getText() : (compVlr.getValor() != null ? compVlr.getValor() : "")));
            }
        }
        return campos;
    }

    public static Map<String, Object> getCamposResultadoParaTexto(String xmlResultado) {
        HashMap<String, Object> campos = new HashMap<String, Object>();
        Resultado res = new Resultado(xmlResultado);
        if (res.xml.get(TIPO).equals(RESULTADO)) {
            for (Component comp : res.getComponentes()) {
                JComponent compVlr;
                if (comp instanceof TextoEstatico) {
                    compVlr = (TextoEstatico)comp;
                    campos.put(((TextoEstatico)compVlr).getNome().toLowerCase(), ((JLabel)compVlr).getText() != null ? ((JLabel)compVlr).getText() : "");
                    continue;
                }
                if (!(comp instanceof TextoDigitacao)) continue;
                compVlr = (TextoDigitacao)comp;
                campos.put(((TextoDigitacao)compVlr).getNome().toLowerCase(), ((JEditorPane)compVlr).getText() != null ? ((JEditorPane)compVlr).getText() : "");
            }
        }
        return campos;
    }

    public static Map<String, String> getCamposResultadoAnterior(String xmlResultado) {
        HashMap<String, String> campos = new HashMap<String, String>();
        String atributos = StringUtil.getValor(xmlResultado, "exame");
        String tipo = StringUtil.getValor(atributos, TIPO);
        if (tipo.equals(CONFIGURACAO) || tipo.equals(PARCIAL) || tipo.equals(RESULTADO)) {
            try {
                for (String item : StringUtil.getListValores(xmlResultado, "componente")) {
                    JComponent compVlr;
                    Componente c = (Componente)Class.forName(StringUtil.getValor(item, TIPO)).newInstance();
                    c.setAtributos(StringUtil.getValor(item, "atributos"));
                    if (c instanceof ResultadoAnterior) {
                        compVlr = (ResultadoAnterior)c;
                        campos.put(((AbstractComponente)compVlr).getNome().toLowerCase(), ((ResultadoAnterior)compVlr).getOrigem() != null ? ((ResultadoAnterior)compVlr).getOrigem() : "");
                        continue;
                    }
                    if (c instanceof ResultadoAnteriorDigitacao) {
                        compVlr = (ResultadoAnteriorDigitacao)((Object)c);
                        campos.put(((ResultadoAnteriorDigitacao)compVlr).getNome().toLowerCase(), ((ResultadoAnteriorDigitacao)compVlr).getOrigem() != null ? ((ResultadoAnteriorDigitacao)compVlr).getOrigem() : "");
                        continue;
                    }
                    if (c instanceof Grafico) {
                        compVlr = (Grafico)c;
                        campos.put(((AbstractComponente)compVlr).getNome().toLowerCase(), ((Grafico)compVlr).getOrigem() != null ? ((Grafico)compVlr).getOrigem() : "");
                        continue;
                    }
                    if (!(c instanceof Expressao)) continue;
                    compVlr = (Expressao)c;
                    campos.put(((AbstractComponente)compVlr).getNome().toLowerCase(), ((AbstractComponente)compVlr).getNome() != null ? ((AbstractComponente)compVlr).getNome() : "");
                }
            }
            catch (Exception e) {
                campos.clear();
            }
        }
        return campos;
    }

    public static String getResultadoImagemBase64(String resultado) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        double zoom = 1.25;
        int acrescimo = (int)(15.0 * zoom);
        Resultado res = new Resultado(resultado);
        if (res.xml.get(TIPO).equals(RESULTADO)) {
            try {
                List<Component> comps = res.getComponentes();
                Dimension dim = ScreenUtil.getAreaOcupada(comps, zoom, true);
                dim.setSize(Math.max(dim.width + acrescimo, 1), Math.max(dim.height, 1));
                BufferedImage bimg = new BufferedImage(dim.width, dim.height, 1);
                Graphics2D g2d = bimg.createGraphics();
                g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                g2d.scale(zoom, zoom);
                g2d.setColor(Color.white);
                g2d.fillRect(0, 0, dim.width, dim.height);
                ListIterator<Component> itr = comps.listIterator(comps.size());
                while (itr.hasPrevious()) {
                    Component comp = itr.previous();
                    if (!(comp instanceof ComponenteImpressao) || !((ComponenteImpressao)((Object)comp)).imprimir()) continue;
                    g2d.setClip(comp.getX(), comp.getY(), (int)((double)comp.getWidth() * zoom), (int)((double)comp.getHeight() * zoom));
                    g2d.translate(comp.getX(), comp.getY());
                    comp.paint(g2d);
                    g2d.translate(-comp.getX(), -comp.getY());
                }
                ImageIO.write((RenderedImage)bimg, "jpg", out);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Resultado: 548");
            }
        }
        return new Base64().encodeAsString(out.toByteArray());
    }

    public static Map<String, Object> getResultadoHTML(String xmlResultado, List<Component> componentesRodapeExame, String requisicao, String exame, String material, String requisicaoImagemWeb, boolean adicionarImagemComoValorData, int alturaRodapeExame, int contadorPaginaExameImagem) {
        Resultado res = new Resultado(xmlResultado);
        if (res.xml.get(TIPO).equals(RESULTADO)) {
            return new ConverteResultadoHTML(res.getComponentes(), componentesRodapeExame != null ? componentesRodapeExame : null, requisicaoImagemWeb, exame, material, adicionarImagemComoValorData, alturaRodapeExame, contadorPaginaExameImagem, true).getMapResultadoImagens();
        }
        return null;
    }

    public static Map<String, Object> getResultadoHTML(String xmlResultado, List<Component> componentesRodapeExame, String requisicao, String exame, String material, String requisicaoImagemWeb, boolean adicionarImagemComoValorData, int alturaRodapeExame, int contadorPaginaExameImagem, boolean adicionarTagPHP) {
        Resultado res = new Resultado(xmlResultado);
        if (res.xml.get(TIPO).equals(RESULTADO)) {
            return new ConverteResultadoHTML(res.getComponentes(), componentesRodapeExame != null ? componentesRodapeExame : null, requisicaoImagemWeb, exame, material, adicionarImagemComoValorData, alturaRodapeExame, contadorPaginaExameImagem, adicionarTagPHP).getMapResultadoImagens();
        }
        return null;
    }

    public static String getResultadoExportacao(String xmlResultado, boolean tratarHTML) throws XMLStringBuilderException {
        Resultado res = new Resultado(xmlResultado);
        if (res.xml.get(TIPO).equals(RESULTADO)) {
            return new ConverteResultadoExportacao(res.getAtributo(VERSAO_LAYOUT_EXAME), res.getComponentes()).getXmlExportacao(tratarHTML);
        }
        return "";
    }

    public static String getResultadoExportacaoComCdata(String xmlResultado) throws XMLStringBuilderException {
        Resultado res = new Resultado(xmlResultado);
        if (res.xml.get(TIPO).equals(RESULTADO)) {
            return new ConverteResultadoExportacao(res.getAtributo(VERSAO_LAYOUT_EXAME), res.getComponentes()).getXmlExportacaoComCdata();
        }
        return "";
    }

    public boolean verificarCondicao() {
        String cond = this.xml.get(CONDICAO);
        if (cond != null && (cond = cond.trim()).length() > 0) {
            Execucao exe = new Execucao(cond, this.tabela, 1);
            return exe.resultadoCondicao();
        }
        return true;
    }

    public int verificarValidacao() {
        String validar = this.xml.get(VALIDACAO);
        if (validar != null && (validar = validar.trim()).length() > 0) {
            Execucao exe = new Execucao(validar, this.tabela, 1);
            return exe.resultadoCondicao() ? 1 : 0;
        }
        return 2;
    }

    public int verificarValidacaoCompulsoria() {
        String validar = this.xml.get(VALIDACAO_COMPULSORIA);
        if (!Funcoes.objectIsNull(validar) && !(validar = validar.trim()).isEmpty()) {
            Execucao exe = new Execucao(validar, this.tabela, 1);
            return exe.resultadoCondicao() ? 1 : 0;
        }
        return 2;
    }

    public int verificarValidacaoResultadoCritico() {
        String validar = this.xml.get(VALIDACAO_RESULTADO_CRITICO);
        if (!Funcoes.objectIsNull(validar) && !(validar = validar.trim()).isEmpty()) {
            Execucao exe = new Execucao(validar, this.tabela, 1);
            return exe.resultadoCondicao() ? 1 : 0;
        }
        return 2;
    }

    public String getMensagemErro() {
        Execucao exec = new Execucao(this.xml.get(MENSAGEM), this.tabela, 0);
        return String.valueOf(exec.resultadoExpressao());
    }

    public String getMensagemValidacao() {
        Execucao exec = new Execucao(this.xml.get(MENSAGEM_VALIDACAO), this.tabela, 0);
        Object mensagemValidacao = exec.resultadoExpressao();
        return mensagemValidacao == null ? null : String.valueOf(mensagemValidacao);
    }

    public String getMensagemValidacaoCompulsoria() {
        Execucao exec = new Execucao(this.xml.get(MENSAGEM_COMPULSORIA), this.tabela, 0);
        Object mensagemValidacao = exec.resultadoExpressao();
        return Funcoes.objectIsNull(mensagemValidacao) ? null : String.valueOf(mensagemValidacao);
    }

    public String getMensagemValidacaoResultadoCritico() {
        Execucao exec = new Execucao(this.xml.get(MENSAGEM_RESULTADO_CRITICO), this.tabela, 0);
        Object mensagemValidacao = exec.resultadoExpressao();
        return Funcoes.objectIsNull(mensagemValidacao) ? null : String.valueOf(mensagemValidacao);
    }

    public void atualizarComponentes() {
        for (Dimensionavel dim : this.componentes.values()) {
            Object valor;
            if (dim instanceof ExpressaoDigitacao) {
                ((ExpressaoDigitacao)dim).executar();
                continue;
            }
            if (dim instanceof TextoDigitacao && ((TextoDigitacao)dim).getExpressao() != null) {
                ((TextoDigitacao)dim).executar();
                continue;
            }
            if (dim instanceof ReguaReferencialDigitacao) {
                ((ReguaReferencialDigitacao)dim).atualizar();
                continue;
            }
            if (dim instanceof CampoDigitacao) {
                ((CampoDigitacao)dim).executar();
                continue;
            }
            if (dim instanceof CampoListaDigitacao) {
                ((CampoListaDigitacao)dim).executar();
                continue;
            }
            if (dim instanceof ImagemDigitacao) {
                ((ImagemDigitacao)dim).executar();
                continue;
            }
            if (dim instanceof FormaImpressao) {
                ((FormaImpressao)dim).executar();
                continue;
            }
            if (dim instanceof GraficoConfiguravelDigitacao) {
                ((GraficoConfiguravelDigitacao)dim).executar();
                continue;
            }
            if (dim instanceof GraficoReferenciaDigitacao) {
                ((GraficoReferenciaDigitacao)dim).executar();
                continue;
            }
            if (dim instanceof GraficoResultadoAnteriorDigitacao) {
                ((GraficoResultadoAnteriorDigitacao)dim).executar();
                continue;
            }
            if (dim instanceof GraficoQuadranteDigitacao) {
                ((GraficoQuadranteDigitacao)dim).executar();
                continue;
            }
            if (!(dim instanceof CampoListaDigitacao) || !((CampoListaDigitacao)dim).vazio() || this.isItemVazio(dim, valor = ((CampoListaDigitacao)dim).getSelectedItem())) continue;
            ((CampoListaDigitacao)dim).carregarValorPadrao();
        }
    }

    private boolean isItemVazio(Dimensionavel dim, Object valor) {
        return valor != null && !Funcoes.textoVazio(valor.toString()) && valor.toString().equalsIgnoreCase(((CampoListaDigitacao)dim).getItemVazio());
    }

    private void ligarCampoExpressao(List<ExpressaoDigitacao> exps, Map<String, ComponenteResultado> res) {
        for (ExpressaoDigitacao exp : exps) {
            for (String ident : Token.getIdentificadores(exp.getExpressao())) {
                ComponenteResultado comp = res.get(ident.toLowerCase());
                if (comp == null) continue;
                comp.addCampoListener(exp);
            }
        }
    }

    private void ligarCampoImagem(List<ImagemDigitacao> exps, Map<String, ComponenteResultado> res) {
        for (ImagemDigitacao exp : exps) {
            for (String ident : Token.getIdentificadores(exp.getCondicao())) {
                ComponenteResultado comp = res.get(ident.toLowerCase());
                if (comp == null) continue;
                comp.addCampoListener(exp);
            }
        }
    }

    private void ligarCampoForma(List<FormaImpressao> formas2, Map<String, ComponenteResultado> res) {
        for (FormaImpressao f : formas2) {
            for (String ident : Token.getIdentificadores(f.getCondicao())) {
                ComponenteResultado comp = res.get(ident.toLowerCase());
                if (comp == null) continue;
                comp.addCampoListener(f);
            }
        }
    }

    private void ligarCampoTexto(List<TextoDigitacao> textos, Map<String, ComponenteResultado> res) {
        for (TextoDigitacao t : textos) {
            for (String ident : Token.getIdentificadores(t.getExpressao())) {
                ComponenteResultado comp = res.get(ident.toLowerCase());
                if (comp == null) continue;
                comp.addCampoListener(t);
            }
        }
    }

    private void ligarCampoReguaReferencial(List<ReguaReferencialDigitacao> reguas, Map<String, ComponenteResultado> res) {
        for (ReguaReferencialDigitacao regua : reguas) {
            if (regua.getTipoRegua() == 0) {
                ComponenteResultado comp = res.get(regua.getOrigem().toLowerCase());
                if (comp == null) continue;
                comp.addCampoListener(regua);
                continue;
            }
            if (regua.getTipoRegua() != 1) continue;
            for (String ident : Token.getIdentificadores(regua.getExpressao())) {
                ComponenteResultado comp = res.get(ident.toLowerCase());
                if (comp == null) continue;
                comp.addCampoListener(regua);
            }
        }
    }

    private void ligarCampoGraficoResultadoAnterior(List<GraficoResultadoAnteriorDigitacao> graficos, Map<String, ComponenteResultado> res) {
        for (GraficoResultadoAnteriorDigitacao grafico : graficos) {
            for (String key : res.keySet()) {
                ComponenteResultado comp = res.get(key.toLowerCase());
                if (comp == null) continue;
                comp.addCampoListener(grafico);
            }
            grafico.atualizar();
        }
    }

    private void ligarCampoGrafico(List<GraficoConfiguravelDigitacao> graficos, Map<String, ComponenteResultado> res) {
        for (GraficoConfiguravelDigitacao grafico : graficos) {
            for (String key : res.keySet()) {
                ComponenteResultado comp = res.get(key.toLowerCase());
                if (comp == null) continue;
                comp.addCampoListener(grafico);
            }
            grafico.atualizar();
        }
    }

    private void ligarCampoGraficoReferencia(List<GraficoReferenciaDigitacao> graficos, Map<String, ComponenteResultado> res) {
        for (GraficoReferenciaDigitacao grafico : graficos) {
            ComponenteResultado comp;
            if (((Grafico)grafico.getDono()).getMultiplosCampos()) {
                for (String key : res.keySet()) {
                    comp = res.get(key.toLowerCase());
                    if (comp == null) continue;
                    comp.addCampoListener(grafico);
                }
            } else {
                for (String key : res.keySet()) {
                    comp = res.get(key.toLowerCase());
                    if (comp == null) continue;
                    comp.addCampoListener(grafico);
                }
            }
            grafico.atualizar();
        }
    }

    private void ligarCampoGraficoQuadrante(List<GraficoQuadranteDigitacao> graficos, Map<String, ComponenteResultado> res) {
        for (GraficoQuadranteDigitacao grafico : graficos) {
            ComponenteResultado comp = res.get(((Grafico)grafico.getDono()).getCampoValor().toLowerCase());
            if (comp != null) {
                comp.addCampoListener(grafico);
            }
            for (String key : res.keySet()) {
                res.get(key).addCampoListener(grafico);
            }
            grafico.atualizar();
        }
    }

    private void carregarResultadoAnterior(Map<Integer, List<ResultadoAnteriorDigitacao>> mapResAnt, Map<Integer, String> anterior, final int ordem, boolean removerTagsHTML) {
        anterior = anterior == null ? new HashMap() : anterior;
        ArrayList<String> tmp = new ArrayList<String>();
        if (ordem == 0 && anterior.size() > mapResAnt.size()) {
            ArrayList<Integer> marcaParaRemover = new ArrayList<Integer>();
            for (Integer chave : anterior.keySet()) {
                if (anterior.size() - marcaParaRemover.size() <= mapResAnt.size()) break;
                marcaParaRemover.add(chave);
            }
            for (Integer chave : marcaParaRemover) {
                anterior.remove(chave);
            }
            HashMap novoAnterior = new HashMap();
            boolean d = false;
            for (Integer chave : anterior.keySet()) {
                novoAnterior.put(novoAnterior.size() + 1, anterior.get(chave));
            }
            if (novoAnterior != null) {
                anterior = novoAnterior;
            }
        }
        for (Integer chave : mapResAnt.keySet()) {
            String str;
            ArrayList<String> listaExameControle = new ArrayList<String>();
            HashMap<Integer, String> anteriorLimpo = new HashMap<Integer, String>();
            for (int i = 0; i < mapResAnt.get(chave).size(); ++i) {
                ResultadoAnteriorDigitacao componenteAtual = mapResAnt.get(chave).get(i);
                if (componenteAtual.getOrigem().contains("data") || componenteAtual.getOrigem().contains("hora")) continue;
                for (Integer posicao : anterior.keySet()) {
                    String exameControle = (String)anterior.get(posicao);
                    String valor = null;
                    if (!Funcoes.textoVazio(componenteAtual.getTagResultado())) {
                        valor = StringUtil.getValorAtributoTagCampo("tagResultado".toLowerCase(), componenteAtual.getTagResultado().toLowerCase(), exameControle);
                    }
                    if (componenteAtual.getOrigem().contains("data") || componenteAtual.getOrigem().contains("hora") || Funcoes.textoVazio(valor)) {
                        valor = StringUtil.getValor(exameControle, componenteAtual.getOrigem().toLowerCase());
                    }
                    if (Funcoes.textoVazio(valor) || listaExameControle.contains(exameControle)) continue;
                    anteriorLimpo.put(anteriorLimpo.size() + 1, exameControle);
                    listaExameControle.add(exameControle);
                }
            }
            if (null != anteriorLimpo && anteriorLimpo.size() > 0) {
                ArrayList resultadosParaOrdenar = new ArrayList(anteriorLimpo.values());
                Collections.sort(resultadosParaOrdenar, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        if (null == o1 || null == o2) {
                            return 0;
                        }
                        String data1 = StringUtil.getValor(o1, "dataResultado");
                        String data2 = StringUtil.getValor(o2, "dataResultado");
                        String hora1 = StringUtil.getValor(o1, "horaResultado");
                        String hora2 = StringUtil.getValor(o2, "horaResultado");
                        if (Funcoes.textoVazio(hora1) || Funcoes.textoVazio(hora2) || Funcoes.textoVazio(data1) || Funcoes.textoVazio(data2) || !StringUtil.verificaDataValida(data1) || !StringUtil.verificaDataValida(data2) || !hora1.matches("([01]\\d|2[0-3]):[0-5]\\d") || !hora2.matches("([01]\\d|2[0-3]):[0-5]\\d")) {
                            return 0;
                        }
                        Date time1 = Funcoes.stringToDate("dd/MM/yyyy kk:mm", data1 + " " + hora1);
                        Date time2 = Funcoes.stringToDate("dd/MM/yyyy kk:mm", data2 + " " + hora2);
                        return null != time1 && null != time2 ? (ordem == 0 ? time1.compareTo(time2) : time2.compareTo(time1)) : 0;
                    }
                });
                anteriorLimpo.clear();
                for (String s : resultadosParaOrdenar) {
                    anteriorLimpo.put(anteriorLimpo.size() + 1, s);
                }
            }
            if ((str = (String)anteriorLimpo.get(chave)) == null) {
                for (ResultadoAnteriorDigitacao rad : mapResAnt.get(chave)) {
                    tmp.addAll(rad.getLigacoes());
                    tmp.add(rad.getNome());
                }
                continue;
            }
            str = StringUtil.getTagEmMinusculas(str);
            for (ResultadoAnteriorDigitacao rad : mapResAnt.get(chave)) {
                String valor = null;
                if (!Funcoes.textoVazio(rad.getTagResultado())) {
                    valor = StringUtil.getValorAtributoTagCampo("tagResultado".toLowerCase(), rad.getTagResultado().toLowerCase(), str);
                }
                if (rad.getOrigem().contains("data") || rad.getOrigem().contains("hora") || Funcoes.textoVazio(valor)) {
                    valor = StringUtil.getValor(str, rad.getOrigem().toLowerCase());
                }
                if (removerTagsHTML) {
                    valor = valor.replaceAll("\\<.[html]*[b]*[i]*[u]*[sub]*[sup]*\\>", "");
                }
                rad.setText(valor);
            }
        }
        this.removerCampos(tmp);
    }

    private void removerCampos(List<String> nomes) {
        if (nomes != null) {
            for (String nome : nomes) {
                Dimensionavel comp = this.componentes.get(nome = nome.toLowerCase());
                if (comp == null) continue;
                if (this.compDigitavel.contains(nome)) {
                    this.compDigitavel.remove(nome);
                }
                this.componentes.remove(nome);
                this.reajustar(comp, comp.getDimensoes());
            }
        }
    }

    private void reajustar(Dimensionavel componente, Rectangle rec) {
        boolean ok = true;
        HashMap<String, String> componentesNaPagina = new HashMap<String, String>();
        int paginaComponente = this.getPaginaComponente(componente.getNome());
        if (paginaComponente > -1 && this.componentesPorPagina.containsKey(paginaComponente)) {
            for (String c : this.componentesPorPagina.get(paginaComponente)) {
                componentesNaPagina.put(StringUtil.getValor(c, "nome").toLowerCase(), c);
            }
        }
        for (Dimensionavel comp : this.componentes.values()) {
            Rectangle r;
            if (!componentesNaPagina.containsKey(comp.getNome().toLowerCase()) || !ScreenUtil.interceptaY(rec, r = comp.getDimensoes()) || r.y > rec.y || r.y + r.height - 3 <= rec.y) continue;
            ok = false;
            break;
        }
        if (ok) {
            Rectangle r;
            int tmp = 0;
            for (Dimensionavel comp : this.componentes.values()) {
                if (!componentesNaPagina.containsKey(comp.getNome().toLowerCase())) continue;
                r = comp.getDimensoes();
                tmp = r.y > rec.y && (tmp == 0 || r.y < tmp) ? r.y : tmp;
            }
            tmp -= rec.y;
            for (Dimensionavel comp : this.componentes.values()) {
                if (!componentesNaPagina.containsKey(comp.getNome().toLowerCase())) continue;
                r = comp.getDimensoes();
                if (r.y <= rec.y) continue;
                comp.setDimensoes(new Rectangle(r.x, r.y - tmp, r.width, r.height));
            }
        }
    }

    private boolean componentesNaMesmaPagina(String nomeComponente1, String nomeComponente2) {
        Integer pagina1 = null;
        Integer pagina2 = null;
        for (Integer pag : this.componentesPorPagina.keySet()) {
            if (!this.componentesPorPagina.containsKey(pag)) continue;
            for (String c : this.componentesPorPagina.get(pag)) {
                String nome = StringUtil.getValor(c, "nome");
                if (nome.equalsIgnoreCase(nomeComponente1)) {
                    pagina1 = pag;
                    continue;
                }
                if (!nome.equalsIgnoreCase(nomeComponente2)) continue;
                pagina2 = pag;
            }
        }
        return pagina1 != null && pagina2 != null && pagina1.equals(pagina2);
    }

    private Integer getPaginaComponente(String nomeComponente1) {
        Object pagina1 = null;
        for (Integer pag : this.componentesPorPagina.keySet()) {
            if (!this.componentesPorPagina.containsKey(pag)) continue;
            for (String c : this.componentesPorPagina.get(pag)) {
                String nome = StringUtil.getValor(c, "nome");
                if (!nome.equalsIgnoreCase(nomeComponente1)) continue;
                return pag;
            }
        }
        return -1;
    }

    private void atualizar() {
        if (this.atualizar) {
            for (ComponenteResultado comp : this.compResultado.values()) {
                if (!comp.vazio()) continue;
                comp.carregarValorPadrao();
            }
            this.atualizarComponentes();
            this.atualizar = false;
        }
    }

    public String gerarResultado(String tipo, boolean removerVazio, boolean reprocessar) {
        StringBuilder bui = new StringBuilder();
        if (reprocessar) {
            this.atualizarComponentes();
            if (removerVazio && this.isImportacaoUltimo) {
                this.removerCamposVazios();
            }
            this.ajustarComponentesDeTexto();
        }
        bui.append("<exame>");
        bui.append(StringUtil.getTag(VERSAO, this.versaoXML));
        bui.append(StringUtil.getTag(TIPO, tipo));
        bui.append(StringUtil.getTag("versaoExameLabExterno", this.xml.get(VERSAO_EXAME)));
        bui.append(StringUtil.getTag(VERSAO_LAYOUT_EXAME, this.xml.get(VERSAO_LAYOUT_EXAME)));
        bui.append(StringUtil.getTag("alturaResultado", String.valueOf(this.getAlturaResultado())));
        bui.append(StringUtil.getTag("alturaResultadoImpressao", String.valueOf(this.getAlturaResultadoParaImpressao())));
        if (this.versaoXML.equals("2.0") || this.versaoXML.equals("3.0")) {
            bui.append(StringUtil.getTag("reposicionarComponentes", String.valueOf(this.reposicionarComponentesPorPagina)));
        }
        bui.append("<resultado>");
        for (Dimensionavel c : this.componentes.values()) {
            boolean salvo;
            ComponenteDigitacao dig;
            Componente comp = c.getDono();
            if (comp == null) continue;
            if (comp instanceof Rtf && c instanceof ComponenteDigitacao) {
                dig = (ComponenteDigitacao)c;
                salvo = (removerVazio && dig.removerVazio() || !dig.vazio()) && (tipo != PARCIAL || dig.salvarParcialmente());
                comp.setSalvoValor(salvo);
                comp.setValorResultado(salvo ? dig.getStringValor() : "");
                if (salvo && comp instanceof Rtf) {
                    bui.append(((Rtf)comp).getComponenteJalis());
                    continue;
                }
                bui.append("<componente>");
                bui.append(StringUtil.getTag(TIPO, comp.getClass().getName()));
                bui.append(StringUtil.getTag("atributos", comp.getAtributos()));
                bui.append("</componente>");
                continue;
            }
            if (c instanceof ComponenteDigitacao) {
                dig = (ComponenteDigitacao)c;
                salvo = (removerVazio && dig.removerVazio() || !dig.vazio()) && (tipo != PARCIAL || dig.salvarParcialmente());
                comp.setSalvoValor(salvo);
                String versao = this.xml.get(VERSAO);
                if ((comp instanceof Historico || comp instanceof HistoricoDigitacao) && !Funcoes.textoVazio(versao) && (versao.equalsIgnoreCase("1.0") || versao.equalsIgnoreCase("2.0"))) {
                    comp.setAlinhamentoHorizontal(2);
                }
                if (c instanceof CampoListaDigitacao) {
                    comp.setValorResultado(salvo ? ((CampoListaDigitacao)c).getValorSelecionado().toString() : "");
                } else {
                    comp.setValorResultado(salvo ? dig.getStringValor() : "");
                }
            }
            bui.append("<componente>");
            bui.append(StringUtil.getTag(TIPO, comp.getClass().getName()));
            bui.append(StringUtil.getTag("atributos", comp.getAtributos()));
            bui.append("</componente>");
        }
        bui.append("</resultado>");
        bui.append(StringUtil.getTag(PARAMETROS, this.xml.get(PARAMETROS_ORIGINAIS)));
        bui.append("</exame>");
        return bui.toString();
    }

    public String gerarResultado(String tipo, boolean removerVazio, boolean reprocessar, double zoom) {
        Componente comp;
        StringBuilder bui = new StringBuilder();
        for (Dimensionavel c : this.componentes.values()) {
            comp = c.getDono();
            if (comp == null) continue;
            comp = this.voltaPosicaoOriginal(comp, zoom);
        }
        if (reprocessar) {
            this.atualizarComponentes();
            if (removerVazio) {
                this.removerCamposVazios();
            }
            this.ajustarComponentesDeTexto();
        }
        bui.append("<exame>");
        bui.append(StringUtil.getTag(VERSAO, this.versaoXML));
        bui.append(StringUtil.getTag(TIPO, tipo));
        bui.append(StringUtil.getTag("versaoExameLabExterno", this.xml.get(VERSAO_EXAME)));
        bui.append(StringUtil.getTag(VERSAO_LAYOUT_EXAME, this.xml.get(VERSAO_LAYOUT_EXAME)));
        bui.append(StringUtil.getTag("alturaResultado", String.valueOf(this.getAlturaResultado())));
        bui.append(StringUtil.getTag("alturaResultadoImpressao", String.valueOf(this.getAlturaResultadoParaImpressao())));
        bui.append(StringUtil.getTag("corValorReferencia", this.xml.get("corValorReferencia")));
        if (this.versaoXML.equals("2.0") || this.versaoXML.equals("3.0")) {
            bui.append(StringUtil.getTag("reposicionarComponentes", String.valueOf(this.reposicionarComponentesPorPagina)));
        }
        bui.append("<resultado>");
        for (Dimensionavel c : this.componentes.values()) {
            comp = c.getDono();
            if (comp == null) continue;
            if (c instanceof ComponenteDigitacao) {
                ComponenteDigitacao dig = (ComponenteDigitacao)c;
                boolean salvo = !(!removerVazio && dig.vazio() || tipo == PARCIAL && !dig.salvarParcialmente());
                comp.setSalvoValor(salvo);
                String versao = this.xml.get(VERSAO);
                if ((comp instanceof Historico || comp instanceof HistoricoDigitacao) && !Funcoes.textoVazio(versao) && (versao.equalsIgnoreCase("1.0") || versao.equalsIgnoreCase("2.0"))) {
                    comp.setAlinhamentoHorizontal(2);
                }
                if (c instanceof CampoListaDigitacao) {
                    if (salvo) {
                        comp.setValorResultado(((CampoListaDigitacao)c).getValorSelecionado().toString());
                    }
                } else {
                    comp.setValorResultado(salvo ? dig.getStringValor() : "");
                }
            }
            bui.append("<componente>");
            bui.append(StringUtil.getTag(TIPO, comp.getClass().getName()));
            bui.append(StringUtil.getTag("atributos", comp.getAtributos()));
            bui.append("</componente>");
        }
        bui.append("</resultado>");
        bui.append(StringUtil.getTag(PARAMETROS, this.xml.get(PARAMETROS_ORIGINAIS)));
        bui.append("</exame>");
        return bui.toString();
    }

    private Componente voltaPosicaoOriginal(Componente c, double zoom) {
        int valorEsquerda = c.getEsquerda();
        int valorTopo = c.getTopo();
        int width = 0;
        int height = 0;
        int pagina = c.getContadorPagina();
        if (pagina > 1) {
            List valores = this.componentesPorPagina.get(pagina);
            for (String item : valores) {
                if (!c.getNome().equals(StringUtil.getValor(item, "nome"))) continue;
                valorTopo = Integer.valueOf(StringUtil.getValor(item, "topo"));
                break;
            }
        } else {
            valorTopo = (int)((double)valorTopo / zoom);
        }
        if (c instanceof Texto) {
            width = (int)((double)((Texto)c).getWidth() / zoom);
            height = (int)((double)((Texto)c).getHeight() / zoom);
            c.setAltura(height);
            c.setLargura(width);
            valorEsquerda = (int)((double)valorEsquerda / zoom);
        } else if (c instanceof Campo) {
            width = (int)((double)((Campo)c).getWidth() / zoom);
            height = (int)((double)((Campo)c).getHeight() / zoom);
            c.setAltura(height);
            c.setLargura(width);
            valorEsquerda = (int)((double)valorEsquerda / zoom);
        } else if (c instanceof Expressao) {
            width = (int)((double)((Expressao)c).getWidth() / zoom);
            height = (int)((double)((Expressao)c).getHeight() / zoom);
            c.setAltura(height);
            c.setLargura(width);
            valorEsquerda = (int)((double)valorEsquerda / zoom);
        } else if (c instanceof ResultadoAnterior) {
            width = (int)((double)((ResultadoAnterior)c).getWidth() / zoom);
            height = (int)((double)((ResultadoAnterior)c).getHeight() / zoom);
            c.setAltura(height);
            c.setLargura(width);
            valorEsquerda = (int)((double)valorEsquerda / zoom);
        } else if (c instanceof Historico) {
            width = (int)((double)((Historico)c).getWidth() / zoom);
            height = (int)((double)((Historico)c).getHeight() / zoom);
            c.setAltura(height);
            c.setLargura(width);
            valorEsquerda = (int)((double)valorEsquerda / zoom);
        } else if (c instanceof Forma) {
            width = (int)((double)((Forma)c).getWidth() / zoom);
            height = (int)((double)((Forma)c).getHeight() / zoom);
            c.setAltura(height);
            c.setLargura(width);
            valorEsquerda = (int)((double)valorEsquerda / zoom);
        } else if (c instanceof Grafico) {
            valorEsquerda = (int)((double)valorEsquerda / zoom);
        } else if (c instanceof Imagem) {
            valorEsquerda = (int)((double)valorEsquerda / zoom);
        } else if (c instanceof ReguaReferencial) {
            width = (int)((double)((ReguaReferencial)c).getWidth() / zoom);
            height = (int)((double)((ReguaReferencial)c).getHeight() / zoom);
            c.setAltura(height);
            c.setLargura(width);
            valorEsquerda = (int)((double)valorEsquerda / zoom);
        } else if (c instanceof Rotulo) {
            width = (int)((double)((Rotulo)c).getWidth() / zoom);
            height = (int)((double)((Rotulo)c).getHeight() / zoom);
            c.setAltura(height);
            c.setLargura(width);
            valorEsquerda = (int)((double)valorEsquerda / zoom);
        } else if (c instanceof Dados) {
            width = (int)((double)((Dados)c).getWidth() / zoom);
            height = (int)((double)((Dados)c).getHeight() / zoom);
            c.setAltura(height);
            c.setLargura(width);
            valorEsquerda = (int)((double)valorEsquerda / zoom);
        } else if (c instanceof Externo) {
            width = (int)((double)((Externo)c).getWidth() / zoom);
            height = (int)((double)((Externo)c).getHeight() / zoom);
            c.setAltura(height);
            c.setLargura(width);
            valorEsquerda = (int)((double)valorEsquerda / zoom);
        }
        c.setEsquerda(valorEsquerda);
        c.setTopo(valorTopo);
        return c;
    }

    private void removerCamposVazios() {
        ArrayList<String> nomes = new ArrayList<String>();
        HashMap<String, Boolean> componentesLigacoes = new HashMap<String, Boolean>();
        for (Dimensionavel dim : this.componentes.values()) {
            if (!(dim instanceof ComponenteDigitacao)) continue;
            ComponenteDigitacao comp = (ComponenteDigitacao)dim;
            boolean valorVazio = false;
            if (dim instanceof CampoListaDigitacao) {
                String selecaoCombo = null;
                if (!Funcoes.textoVazio((String)((CampoListaDigitacao)dim).getSelectedItem())) {
                    selecaoCombo = ((CampoListaDigitacao)dim).getSelectedItem().toString();
                }
                valorVazio = ((ComponenteDigitacao)dim).removerVazio() && ((CampoListaDigitacao)dim).getItemVazio().equals(selecaoCombo) || !StringUtil.getBoolean(this.xml.get(PARAMETROS_ORIGINAIS), "validarItemVazio") && !Funcoes.objectIsNull(selecaoCombo) && selecaoCombo.trim().isEmpty();
            }
            boolean removerLigacoes = false;
            if (valorVazio || comp.vazio() && comp.removerVazio()) {
                nomes.add(comp.getNome());
                removerLigacoes = true;
            }
            if (comp.getLigacoes() == null) continue;
            for (String ligacao : comp.getLigacoes()) {
                Boolean valorLigacao = (Boolean)componentesLigacoes.get(ligacao);
                CampoListaDigitacao campoLista = null;
                if (comp instanceof CampoListaDigitacao && (campoLista = (CampoListaDigitacao)comp).getItemVazio().equals(campoLista.getSelectedItem().toString()) && comp.removerVazio()) {
                    removerLigacoes = campoLista.getLigacoes().contains(ligacao);
                }
                componentesLigacoes.put(ligacao, valorLigacao == null ? removerLigacoes : valorLigacao != false || removerLigacoes);
            }
        }
        for (String aux : componentesLigacoes.keySet()) {
            if (!((Boolean)componentesLigacoes.get(aux)).booleanValue()) continue;
            nomes.add(aux);
        }
        this.removerCampos(nomes);
    }

    private void ajustarComponentesDeTexto() {
        for (Dimensionavel dim : this.componentes.values()) {
            Rectangle rec;
            if (!(dim instanceof TextoDigitacao) || ((TextoDigitacao)dim).vazio() || (rec = this.ajustarTextoDigitacao((TextoDigitacao)dim)) == null) continue;
            this.reajustar(dim, rec);
        }
    }

    public int getAlturaResultado() {
        int altura = 0;
        for (Dimensionavel comp : this.componentes.values()) {
            Rectangle dim = comp.getDimensoes();
            int tmp = dim.y + dim.height;
            if (tmp <= altura) continue;
            altura = tmp;
        }
        return altura;
    }

    public int getAlturaResultadoParaImpressao() {
        int altura = 0;
        for (Dimensionavel comp : this.componentes.values()) {
            if (!(comp instanceof ComponenteImpressao && ((ComponenteImpressao)comp).imprimir() || comp instanceof ComponenteResultado && ((ComponenteResultado)comp).imprimir()) && (!(comp instanceof ComponenteDigitacao) || !((ComponenteDigitacao)comp).imprimir())) continue;
            Rectangle dim = comp.getDimensoes();
            int tmp = dim.y + dim.height;
            if (tmp <= altura) continue;
            altura = tmp;
        }
        return altura;
    }

    private Rectangle ajustarTextoDigitacao(TextoDigitacao text) {
        Rectangle recAntigo = text.getDimensoes();
        Dimension sizeNovo = text.getPreferredSize();
        if (sizeNovo.height >= recAntigo.height) {
            return null;
        }
        text.setDimensoes(recAntigo.x, recAntigo.y, recAntigo.width, sizeNovo.height);
        Rectangle retorno = new Rectangle(recAntigo.x, recAntigo.y + sizeNovo.height, recAntigo.width, sizeNovo.height);
        return retorno;
    }

    public void atualizarCamposExamesExternos(Map<String, Object> campos) {
        this.tabela.setDadosExternos(campos);
    }

    public void adicionaListenerTabelaSimbolos(TabelaSimbolosListener l) {
        if (l != null) {
            this.tabela.adicionaListener(l);
        }
    }

    public void retornaValor(final Digitacao digitacao, String atributos, Map<String, Object> dados, Map<String, Object> externos, Map<String, String> historicos, Map<String, String> historicosPorMnemonico, Map<Integer, String> resAnterior, List<Component> componentesFoco, boolean edicao, int ordemAnteriores, boolean removerTagsHTMLResultadoAnterior, String resultadoAtual) {
        ArrayList<ExpressaoDigitacao> exps = new ArrayList<ExpressaoDigitacao>();
        ArrayList<TextoDigitacao> textos = new ArrayList<TextoDigitacao>();
        ArrayList<ReguaReferencialDigitacao> reguas = new ArrayList<ReguaReferencialDigitacao>();
        HashMap<Integer, List<ResultadoAnteriorDigitacao>> mapResAnt = new HashMap<Integer, List<ResultadoAnteriorDigitacao>>();
        ArrayList<GraficoConfiguravelDigitacao> graficos = new ArrayList<GraficoConfiguravelDigitacao>();
        ArrayList<GraficoReferenciaDigitacao> graficosReferencia = new ArrayList<GraficoReferenciaDigitacao>();
        ArrayList<GraficoQuadranteDigitacao> graficosQuadrante = new ArrayList<GraficoQuadranteDigitacao>();
        ArrayList<GraficoResultadoAnteriorDigitacao> graficosResultadoAnterior = new ArrayList<GraficoResultadoAnteriorDigitacao>();
        ArrayList<ImagemDigitacao> imagens = new ArrayList<ImagemDigitacao>();
        MensagemListener ouvinteMensagem = new MensagemListener(){

            @Override
            public void exibirMensagem(final MensagemEvento e) {
                new Thread("ThreadMensagemDigitacao"){

                    @Override
                    public void run() {
                        if (digitacao != null && digitacao.labelMensagem != null) {
                            try {
                                digitacao.labelMensagem.setText(e.getMensagem());
                                Thread.sleep(5000L);
                                digitacao.labelMensagem.setText("");
                            }
                            catch (Exception e2) {
                                ErrorLogger.mostraMensagem(null, e2.getMessage(), e2.getStackTrace(), "Resultado: 120");
                            }
                        }
                    }
                }.start();
            }
        };
        FocusAdapter ouvinteFoco = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (digitacao != null && digitacao.panelArea != null) {
                    Rectangle r = ((Component)e.getSource()).getBounds();
                    r.translate(-5, -5);
                    r.grow(10, 10);
                    digitacao.panelArea.scrollRectToVisible(r);
                    boolean tmp = Resultado.this.atualizar;
                    Resultado.this.atualizar();
                    if (tmp && e.getSource() instanceof CampoDigitacao) {
                        ((CampoDigitacao)e.getSource()).selectAll();
                    }
                }
            }
        };
        try {
            if (dados != null) {
                for (String chave : dados.keySet()) {
                    this.dadosBanco.put(chave.toLowerCase(), dados.get(chave));
                }
                this.tabela.setDados(dados);
            }
            if (externos != null) {
                for (String chave : externos.keySet()) {
                    this.dadosExternos.put(chave.toLowerCase(), externos.get(chave));
                }
            }
            String atributosOriginais = atributos;
            this.versaoXML = StringUtil.getValor(atributos, VERSAO) == null ? "1" : StringUtil.getValor(atributos, VERSAO);
            atributos = StringUtil.getValor(atributos, "exame");
            this.xml.put(VERSAO_LAYOUT_EXAME, Funcoes.textoVazio(StringUtil.getValor(atributos, VERSAO_LAYOUT_EXAME)) ? "0" : StringUtil.getValor(atributos, VERSAO_LAYOUT_EXAME));
            this.xml.put(VERSAO, this.versaoXML);
            this.xml.put(TIPO, StringUtil.getValor(atributos, TIPO));
            this.xml.put(VERSAO_EXAME, StringUtil.getValor(atributos, "versaoExameLabExterno"));
            String tmp = StringUtil.getValor(atributos, PARAMETROS);
            this.xml.put(PARAMETROS_ORIGINAIS, StringUtil.getValor(atributosOriginais, PARAMETROS, false, null, false));
            this.xml.put(PARAMETROS, tmp);
            this.xml.put(CONDICAO, StringUtil.getValor(tmp, CONDICAO));
            this.xml.put(MENSAGEM, StringUtil.getValor(tmp, "mensagemErro"));
            this.xml.put(VALIDACAO, StringUtil.getValor(tmp, VALIDACAO));
            this.xml.put(MENSAGEM_VALIDACAO, StringUtil.getValor(tmp, MENSAGEM_VALIDACAO));
            this.modificarHistorico = StringUtil.getBoolean(tmp, "modificarHistorico");
            this.naoRemoverCamposParcial = StringUtil.getBoolean(tmp, "naoRemoverParcial");
            boolean bl = this.reposicionarComponentesPorPagina = this.versaoXML.equals("1.0") || StringUtil.getValor(tmp, "reposicionarComponentes").trim().length() == 0 ? true : StringUtil.getBoolean(tmp, "reposicionarComponentes");
            if (this.xml.get(TIPO).equals(PARCIAL) || this.xml.get(TIPO).equals(RESULTADO)) {
                tmp = StringUtil.getValor(atributos, RESULTADO);
            } else {
                tmp = StringUtil.getValor(atributos, "pagina");
                tmp = StringUtil.getValor(StringUtil.getValor(tmp, "itens"), "corpo");
            }
            List<String> componentesLocalizados = StringUtil.getListValores(tmp, "componente");
            int componenteMaisDistante = 0;
            for (String item : componentesLocalizados) {
                int contador;
                String xmlItem = StringUtil.getValor(item, "atributos");
                int altura = StringUtil.getInt(xmlItem, "altura");
                int topo = StringUtil.getInt(xmlItem, "topo");
                int n = contador = StringUtil.getValor(xmlItem, "contadorPagina").matches("\\d+") ? StringUtil.getInt(xmlItem, "contadorPagina") : 1;
                if (!this.componentesPorPagina.containsKey(contador)) {
                    this.componentesPorPagina.put(contador, new ArrayList());
                }
                this.componentesPorPagina.get(contador).add(item);
                if (!this.alturaMaximaPorPagina.containsKey(contador)) {
                    this.alturaMaximaPorPagina.put(contador, 0);
                    componenteMaisDistante = 0;
                }
                if (topo + altura > componenteMaisDistante) {
                    componenteMaisDistante = topo + altura;
                }
                this.alturaMaximaPorPagina.put(contador, componenteMaisDistante);
            }
            for (Integer pag : this.componentesPorPagina.keySet()) {
                List valores = this.componentesPorPagina.get(pag);
                for (String item : valores) {
                    JComponent grafico;
                    Object valor;
                    ComponenteInterfaceamento inter;
                    Componente c = (Componente)Class.forName(StringUtil.getValor(item, TIPO)).newInstance();
                    c.setAtributos(StringUtil.getValor(item, "atributos"));
                    Component comp = c.getComponenteDigitacao(edicao);
                    if (comp instanceof TextoEstatico && (((TextoEstatico)comp).getDono() instanceof Historico || ((TextoEstatico)comp).getDono() instanceof HistoricoDigitacao) && !Funcoes.textoVazio(this.versaoXML) && (this.versaoXML.equalsIgnoreCase("1.0") || this.versaoXML.equalsIgnoreCase("2.0"))) {
                        ((TextoEstatico)comp).setHorizontalAlignment(2);
                    }
                    if (pag > 1) {
                        comp.setBounds(comp.getX(), comp.getY() + this.calculaAlturaPaginaAnterior(this.alturaMaximaPorPagina, pag), comp.getWidth(), comp.getHeight());
                    }
                    this.componentes.put(comp.getName().toLowerCase(), (Dimensionavel)((Object)comp));
                    if (comp instanceof ComponenteValor) {
                        ComponenteValor compVlr = (ComponenteValor)((Object)comp);
                        this.tabela.setSimbolo(compVlr.getNome(), compVlr);
                    }
                    if (!(comp instanceof ComponenteDigitacao)) continue;
                    comp.addFocusListener(ouvinteFoco);
                    if (comp instanceof CampoDigitacao) {
                        this.tabela.setCampoDigitacao((CampoDigitacao)comp);
                    }
                    if (comp instanceof RtfDigitacao) {
                        RtfDigitacao rtfDigi = (RtfDigitacao)comp;
                        rtfDigi.setTabelaSimbolos(this.tabela);
                    }
                    if (comp instanceof ExpressaoDigitacao) {
                        ExpressaoDigitacao exp = (ExpressaoDigitacao)comp;
                        exps.add(exp);
                        exp.setTabelaSimbolos(this.tabela);
                    } else if (comp instanceof TextoDigitacao) {
                        if (!Funcoes.textoVazio(((TextoDigitacao)comp).getExpressao())) {
                            TextoDigitacao t = (TextoDigitacao)comp;
                            textos.add(t);
                            t.setTabelaSimbolos(this.tabela);
                        }
                        if (((TextoDigitacao)comp).getRedimensionar()) {
                            ((TextoDigitacao)comp).addCampoRedimensionadoListener(new CampoRedimensionadoListener(){

                                @Override
                                public void componenteRedimensionado(ComponenteResultado e, Dimension dimensaoAnterior, Dimension novaDimensao) {
                                    Rectangle posicaoAtual = e.getDimensoes();
                                    int diferencaAltura = novaDimensao.height - dimensaoAnterior.height;
                                    boolean alterouPosicao = false;
                                    ArrayList<Component> tmp = new ArrayList<Component>();
                                    if (diferencaAltura > 0) {
                                        for (Dimensionavel dim : Resultado.this.componentes.values()) {
                                            if (!(dim.getDimensoes().getY() > (double)posicaoAtual.y)) continue;
                                            Rectangle rec = dim.getDimensoes();
                                            rec.y += diferencaAltura;
                                            dim.setDimensoes(rec);
                                            if (!(dim instanceof Component)) continue;
                                            tmp.add((Component)((Object)dim));
                                        }
                                        if (tmp.size() > 0) {
                                            digitacao.redimensionar(tmp, true);
                                        }
                                    }
                                }
                            });
                        }
                    } else if (comp instanceof ReguaReferencialDigitacao) {
                        ReguaReferencialDigitacao rd = (ReguaReferencialDigitacao)comp;
                        reguas.add(rd);
                        rd.setTabelaSimbolos(this.tabela);
                    } else if (comp instanceof HistoricoDigitacao) {
                        HistoricoDigitacao his = (HistoricoDigitacao)comp;
                        his.setPermissaoAlterar(this.modificarHistorico);
                        his.setHistoricos(historicos, historicosPorMnemonico);
                    } else if (comp instanceof DadosDigitacao) {
                        DadosDigitacao dig = (DadosDigitacao)comp;
                        dig.setValor(this.dadosBanco.get(dig.getCampoBanco().toLowerCase()));
                    } else if (comp instanceof ExternoDigitacao) {
                        ExternoDigitacao ext = (ExternoDigitacao)comp;
                        ext.setValor(this.dadosExternos.get(ext.getCampoExterno().toLowerCase()));
                    } else if (comp instanceof ImagemDigitacao) {
                        Object o;
                        ImagemDigitacao img = (ImagemDigitacao)comp;
                        img.setTabelaSimbolos(this.tabela);
                        imagens.add(img);
                        if (comp instanceof ComponenteInterfaceamento) {
                            inter = (ComponenteInterfaceamento)((Object)comp);
                            valor = this.dadosBanco.get(inter.getCampoInterfaceamento().toLowerCase());
                            if (valor != null && valor.toString().trim().length() > 0) {
                                img.setImagem(valor.toString());
                            }
                        } else if (img.getCampoDoBanco().trim().length() > 0 && (o = this.dadosBanco.get(img.getCampoDoBanco().toLowerCase())) != null) {
                            img.setImagem(o.toString());
                        }
                    } else if (comp instanceof ResultadoAnteriorDigitacao) {
                        ResultadoAnteriorDigitacao ra = (ResultadoAnteriorDigitacao)comp;
                        ArrayList<ResultadoAnteriorDigitacao> list = (ArrayList<ResultadoAnteriorDigitacao>)mapResAnt.get(ra.getOrdem());
                        if (list == null) {
                            list = new ArrayList<ResultadoAnteriorDigitacao>();
                            mapResAnt.put(ra.getOrdem(), list);
                        }
                        list.add(ra);
                    } else if (comp instanceof GraficoResultadoAnteriorDigitacao) {
                        grafico = (GraficoResultadoAnteriorDigitacao)comp;
                        HashMap clone = null;
                        if (resAnterior != null) {
                            clone = (HashMap)((HashMap)resAnterior).clone();
                        }
                        String valorAtual = null;
                        if (!Funcoes.textoVazio(resultadoAtual)) {
                            String tagResultado = null;
                            if (((GraficoResultadoAnteriorDigitacao)grafico).getDono() instanceof ComponenteEditor) {
                                tagResultado = ((ComponenteEditor)((Object)((GraficoResultadoAnteriorDigitacao)grafico).getDono())).getTagResultado();
                            }
                            if (!Funcoes.textoVazio(tagResultado)) {
                                valorAtual = StringUtil.getValorAtributoTagCampo("tagResultado".toLowerCase(), tagResultado.toLowerCase(), resultadoAtual);
                            }
                            if (Funcoes.textoVazio(valorAtual)) {
                                valorAtual = StringUtil.getValor(resultadoAtual, ((Grafico)((GraficoResultadoAnteriorDigitacao)grafico).getDono()).getOrigem().toLowerCase());
                            }
                        }
                        ((GraficoResultadoAnteriorDigitacao)grafico).setTabelaSimbolos(this.tabela);
                        ((GraficoResultadoAnteriorDigitacao)grafico).setResultadosAnteriores(clone, ordemAnteriores == 0, valorAtual);
                        graficosResultadoAnterior.add((GraficoResultadoAnteriorDigitacao)grafico);
                    } else if (comp instanceof GraficoConfiguravelDigitacao) {
                        grafico = (GraficoConfiguravelDigitacao)comp;
                        graficos.add((GraficoConfiguravelDigitacao)grafico);
                        ((GraficoConfiguravelDigitacao)grafico).setTabelaSimbolos(this.tabela);
                    } else if (comp instanceof GraficoReferenciaDigitacao) {
                        grafico = (GraficoReferenciaDigitacao)comp;
                        graficosReferencia.add((GraficoReferenciaDigitacao)grafico);
                        ((GraficoReferenciaDigitacao)grafico).setTabelaSimbolos(this.tabela);
                    } else if (comp instanceof GraficoQuadranteDigitacao) {
                        grafico = (GraficoQuadranteDigitacao)comp;
                        graficosQuadrante.add((GraficoQuadranteDigitacao)grafico);
                        ((GraficoQuadranteDigitacao)grafico).setTabelaSimbolos(this.tabela);
                    }
                    if (!(comp instanceof ComponenteResultado)) continue;
                    ComponenteResultado compRes = (ComponenteResultado)((Object)comp);
                    this.compResultado.put(compRes.getNome().toLowerCase(), compRes);
                    compRes.addMensagemListener(ouvinteMensagem);
                    compRes.setComponentesFoco(componentesFoco);
                    if (compRes instanceof CampoDigitacao) {
                        ((CampoDigitacao)compRes).carregarValorPadrao();
                    } else if (compRes instanceof HistoricoDigitacao && Funcoes.textoVazio(((HistoricoDigitacao)compRes).getText())) {
                        ((HistoricoDigitacao)compRes).carregarValorPadrao();
                    }
                    if (compRes.digitavel()) {
                        ScreenUtil.inserirOrdenadoXY((Component)((Object)compRes), this.compDigitavel);
                    }
                    if (comp instanceof ComponenteInterfaceamento && ((ComponenteInterfaceamento)((Object)comp)).getCampoInterfaceamento().trim().length() > 0) {
                        inter = (ComponenteInterfaceamento)((Object)comp);
                        valor = this.dadosBanco.get(inter.getCampoInterfaceamento().toLowerCase() + "_" + comp.getName().toLowerCase());
                        if (valor == null) {
                            valor = this.dadosBanco.get(inter.getCampoInterfaceamento().toLowerCase());
                        }
                        if (valor != null && valor.toString().trim().length() > 0) {
                            if (valor.toString().equals(CampoListaDigitacao.VAZIO)) {
                                compRes.setValor("");
                            } else {
                                compRes.setValor(valor);
                            }
                        }
                    }
                    if (!compRes.isRelacionavelComCampoDeImportacao() || compRes.getCampoDeImportacao().trim().length() <= 0) continue;
                    Object valor2 = this.dadosBanco.get(compRes.getCampoDeImportacao().toLowerCase());
                    if (valor2 == null) {
                        valor2 = this.dadosBanco.get(compRes.getCampoDeImportacao().toLowerCase() + "_" + comp.getName().toLowerCase());
                    }
                    if (valor2 == null || valor2.toString().trim().length() <= 0) continue;
                    compRes.setValor(valor2);
                }
            }
            this.ligarCampoExpressao(exps, this.compResultado);
            this.ligarCampoTexto(textos, this.compResultado);
            this.ligarCampoReguaReferencial(reguas, this.compResultado);
            this.ligarCampoGrafico(graficos, this.compResultado);
            this.ligarCampoGraficoReferencia(graficosReferencia, this.compResultado);
            this.ligarCampoGraficoQuadrante(graficosQuadrante, this.compResultado);
            this.ligarCampoGraficoResultadoAnterior(graficosResultadoAnterior, this.compResultado);
            this.ligarCampoImagem(imagens, this.compResultado);
            this.carregarResultadoAnterior(mapResAnt, resAnterior, ordemAnteriores, removerTagsHTMLResultadoAnterior);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(digitacao, e.getMessage(), e.getStackTrace(), "Resultado: 252");
        }
    }

    private static class ConverteResultadoExportacao {
        private List<Component> comps;
        private String versaoResultado = "0";

        public ConverteResultadoExportacao(String versaoExame, List<Component> comps) {
            this.versaoResultado = versaoExame;
            this.comps = comps;
        }

        public String getXmlExportacao(boolean tratarHTML) throws XMLStringBuilderException {
            XMLStringBuilder xml = new XMLStringBuilder();
            xml.abrir(Resultado.RESULTADO);
            xml.escrever(Resultado.VERSAO_LAYOUT_EXAME, this.versaoResultado);
            for (Component c : this.comps) {
                xml.abrir("componente");
                xml.escrever("nome", c.getName());
                String valor = "";
                if (c instanceof TextoEstatico) {
                    valor = ((TextoEstatico)c).getText();
                } else if (c instanceof ComponenteResultado) {
                    valor = ((ComponenteResultado)((Object)c)).getStringValor();
                }
                xml.escrever("valor", tratarHTML ? StringUtil.tratarEntidadesHTML(valor) : valor);
                xml.fechar("componente");
            }
            xml.fechar(Resultado.RESULTADO);
            return xml.getXML();
        }

        public String getXmlExportacaoComCdata() throws XMLStringBuilderException {
            XMLStringBuilder xml = new XMLStringBuilder();
            xml.abrir(Resultado.RESULTADO);
            xml.escrever(Resultado.VERSAO_LAYOUT_EXAME, this.versaoResultado);
            xml.abrir("componentes");
            for (Component c : this.comps) {
                xml.abrir("componente");
                xml.escrever("nome", c.getName());
                String valor = "";
                if (c instanceof TextoEstatico) {
                    valor = ((TextoEstatico)c).getText();
                } else if (c instanceof ComponenteResultado) {
                    valor = ((ComponenteResultado)((Object)c)).getStringValor();
                }
                xml.escrever("valor", "<![CDATA[" + valor + "]]>");
                xml.fechar("componente");
            }
            xml.fechar("componentes");
            xml.fechar(Resultado.RESULTADO);
            return xml.getXML();
        }
    }

    private static class ConverteResultadoHTML {
        private static final double ZOOM_FONTE_TEXTO = 1.4;
        private static final double ZOOM_COMPONENTE_TEXTO = 1.335;
        private List<Component> comps;
        private List<Component> componentesRodapeExame;
        private Graphics graphics = new BufferedImage(10, 10, 1).createGraphics();
        private Map<Integer, String> imagens = new HashMap<Integer, String>();
        private String requisicao;
        private String exame;
        private String material;
        private boolean imagemComoData = false;
        private int contadorImagens = 0;
        private final float ZOOM = 1.4f;
        private final float ZOOM_CAMPO_TEXTO = 1.4f;
        private final int LARGURA_MAXIMA_PAGINA_WEB = 800;
        private float zoom = 1.4f;
        private int alturaRodapeExame = 0;
        private boolean adicionarTagPHP = true;

        public ConverteResultadoHTML(List<Component> comps, List<Component> componentesRodapeExame, String requisicao, String exame, String material, boolean imagemComoData, int alturaRodapeExame, int contadorPaginaExameImagem, boolean adicionarTagPHP) {
            this.comps = comps;
            this.requisicao = requisicao;
            this.exame = exame;
            this.material = material;
            this.imagemComoData = true;
            this.componentesRodapeExame = componentesRodapeExame;
            this.alturaRodapeExame = alturaRodapeExame;
            this.adicionarTagPHP = adicionarTagPHP;
            if (contadorPaginaExameImagem > -1) {
                this.contadorImagens = contadorPaginaExameImagem;
            }
        }

        public Map<String, Object> getMapResultadoImagens() {
            Component comp;
            this.tratarDimensoes(this.comps);
            Dimension dim = ScreenUtil.getAreaOcupada(this.comps, 1.0, true);
            StringBuilder bui = new StringBuilder();
            if (this.adicionarTagPHP) {
                bui.append("?>\n");
            }
            bui.append("<div style=\"word-wrap: break-word;position: relative; ");
            bui.append("width: ").append(dim.width).append("px;");
            bui.append("height: ");
            bui.append(dim.height + (this.alturaRodapeExame < 0 ? 0 : this.alturaRodapeExame));
            bui.append("px;\">\n");
            ListIterator<Component> itr = this.comps.listIterator(this.comps.size());
            while (itr.hasPrevious()) {
                comp = itr.previous();
                if (!(comp instanceof ComponenteImpressao) || !((ComponenteImpressao)((Object)comp)).imprimir()) continue;
                bui.append("  ");
                if (comp instanceof TextoEstatico) {
                    bui.append(this.getAtributosTextoEstatico((TextoEstatico)comp, false));
                } else if (comp instanceof TextoDigitacao) {
                    bui.append(this.getAtributosTextoDigitacao((TextoDigitacao)comp, false));
                } else if (comp instanceof FormaImpressao) {
                    bui.append(this.getAtributosFormaImpressao((FormaImpressao)comp, this.imagemComoData, false));
                } else if (comp instanceof ReguaReferencialImpressao) {
                    bui.append(this.getAtributosReguaReferencialImpressao((ReguaReferencialImpressao)comp, this.imagemComoData, false));
                } else if (comp instanceof GraficoImpressao) {
                    bui.append(this.getAtributosGraficoImpressao((GraficoImpressao)comp, this.imagemComoData, false));
                } else if (comp instanceof ImagemImpressao) {
                    bui.append(this.getAtributosImagemImpressao((ImagemImpressao)comp, this.imagemComoData, false));
                }
                bui.append("\n");
            }
            if (this.componentesRodapeExame != null && this.componentesRodapeExame.size() > 0) {
                bui.append("<div style=\"word-wrap: break-word;position:absolute; bottom:1px; display:block;");
                bui.append(" width: ").append(dim.width - 2).append("px;");
                bui.append(" height:").append(this.alturaRodapeExame).append("px\">\n");
                itr = this.componentesRodapeExame.listIterator(this.componentesRodapeExame.size());
                while (itr.hasPrevious()) {
                    TextoEstatico t;
                    JComponent d;
                    comp = itr.previous();
                    Component c = null;
                    if (comp instanceof ComponenteImpressao) {
                        c = comp;
                    } else if (comp instanceof DadosDigitacao) {
                        d = (DadosDigitacao)comp;
                        t = new TextoEstatico();
                        t.setBackground(d.getBackground());
                        t.setDimensoes(((DadosDigitacao)d).getDimensoes());
                        t.setImprimir(((DadosDigitacao)d).imprimir());
                        t.setValor(((DadosDigitacao)d).getValor());
                        t.setText(((DadosDigitacao)d).getValor() != null ? ((DadosDigitacao)d).getValor().toString() : ((JTextComponent)d).getText());
                        t.setFont(d.getFont());
                        t.setDono(((DadosDigitacao)d).getDono());
                        c = t;
                    } else if (comp instanceof ExpressaoDigitacao) {
                        d = (ExpressaoDigitacao)comp;
                        t = new TextoEstatico();
                        t.setBackground(d.getBackground());
                        t.setDimensoes(((ExpressaoDigitacao)d).getDimensoes());
                        t.setImprimir(((ExpressaoDigitacao)d).imprimir());
                        t.setValor(((ExpressaoDigitacao)d).getValor());
                        t.setText(((ExpressaoDigitacao)d).getValor() != null ? ((ExpressaoDigitacao)d).getValor().toString() : ((JLabel)d).getText());
                        t.setFont(d.getFont());
                        t.setDono(((ExpressaoDigitacao)d).getDono());
                        c = t;
                    } else if (comp instanceof ImagemDigitacao) {
                        ImagemDigitacao i = (ImagemDigitacao)comp;
                        ImagemImpressao ii = new ImagemImpressao();
                        ii.setBackground(i.getBackground());
                        ii.setDimensoes(i.getDimensoes());
                        ii.setImprimir(i.imprimir());
                        ii.setImagem(i.getImagem());
                        ii.setDono(i.getDono());
                        c = ii;
                    }
                    if (c == null || !(c instanceof ComponenteImpressao) || !((ComponenteImpressao)((Object)c)).imprimir()) continue;
                    bui.append("  ");
                    if (c instanceof TextoEstatico) {
                        bui.append(this.getAtributosTextoEstatico((TextoEstatico)c, false));
                    } else if (c instanceof TextoDigitacao) {
                        bui.append(this.getAtributosTextoDigitacao((TextoDigitacao)c, false));
                    } else if (c instanceof FormaImpressao) {
                        bui.append(this.getAtributosFormaImpressao((FormaImpressao)c, this.imagemComoData, false));
                    } else if (c instanceof ReguaReferencialImpressao) {
                        bui.append(this.getAtributosReguaReferencialImpressao((ReguaReferencialImpressao)c, this.imagemComoData, false));
                    } else if (c instanceof GraficoImpressao) {
                        bui.append(this.getAtributosGraficoImpressao((GraficoImpressao)c, this.imagemComoData, false));
                    } else if (c instanceof ImagemImpressao) {
                        bui.append(this.getAtributosImagemImpressao((ImagemImpressao)c, this.imagemComoData, false));
                    }
                    bui.append("\n");
                }
                bui.append("</div>\n");
            }
            bui.append("</div>");
            if (this.adicionarTagPHP) {
                bui.append("\n<?");
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(Resultado.LAUDO, bui.toString());
            map.put(Resultado.IMAGENS, this.imagens);
            return map;
        }

        private void tratarDimensoes(List<Component> comps) {
            for (Component comp : comps) {
                FontMetrics fm;
                Font fonte;
                JComponent text;
                Rectangle rec = comp.getBounds();
                this.zoom = 1.4f;
                if (comp instanceof TextoDigitacao) {
                    this.zoom = 1.4f;
                }
                rec = new Rectangle((int)((float)rec.x * this.zoom), (int)((float)rec.y * this.zoom), (int)((float)rec.width * this.zoom), (int)((float)rec.height * this.zoom));
                if (comp instanceof TextoEstatico) {
                    text = (TextoEstatico)comp;
                    fonte = text.getFont();
                    fonte = new Font(fonte.getName(), fonte.getStyle(), fonte.getSize() + 2);
                    text.setFont(fonte);
                    fm = this.graphics.getFontMetrics(fonte);
                    int width = fm.stringWidth(((JLabel)text).getText());
                    if (width > rec.width) {
                        if (((JLabel)text).getHorizontalAlignment() == 4) {
                            rec.x = rec.x - width + rec.width;
                        }
                        rec.width = width;
                    }
                } else if (comp instanceof TextoDigitacao) {
                    text = (TextoDigitacao)comp;
                    fonte = text.getFont();
                    fonte = new Font(fonte.getName(), fonte.getStyle(), (int)((double)fonte.getSize() * 1.4));
                    text.setFont(fonte);
                    fm = this.graphics.getFontMetrics(fonte);
                    if (((TextoDigitacao)text).imprimir()) {
                        rec.width = ((TextoDigitacao)text).getPreferredSize().width > 800 ? 800 : (int)((float)((TextoDigitacao)text).getPreferredSize().width * this.zoom);
                        rec.height = (int)((float)comp.getBounds().height * this.zoom);
                    } else {
                        rec.width = 0;
                        rec.height = 0;
                    }
                }
                comp.setBounds(rec);
            }
        }

        private String getAtributosTextoEstatico(TextoEstatico texto, boolean alterarParaRodape) {
            String alteracaoParaRodape = "relative; float: left; ";
            if (!alterarParaRodape) {
                alteracaoParaRodape = "absolute; ";
            }
            StringBuilder bui = new StringBuilder("<span style=\"white-space:nowrap; z-index:10; position: ").append(alteracaoParaRodape);
            Rectangle rec = texto.getBounds();
            if (texto.isOpaque()) {
                bui.append("background-color: ");
                bui.append(StringUtil.getHexadecimal(texto.getBackground()));
                bui.append("; ");
                bui.append(this.getAtributosRetangulo(rec));
                bui.append("\"></span>\n<span style=\"z-index:11;position: ").append(alteracaoParaRodape);
            }
            bui.append("color: ");
            bui.append(StringUtil.getHexadecimal(texto.getForeground()));
            bui.append("; ");
            if (texto.getHorizontalAlignment() == 0 || texto.getHorizontalAlignment() == 4) {
                bui.append("text-align: ");
                bui.append(texto.getHorizontalAlignment() == 0 ? "center; " : "right; ");
            }
            Font font = texto.getFont();
            FontMetrics fm = this.graphics.getFontMetrics(font);
            rec.y += (rec.height - fm.getHeight()) / 2;
            rec.height = fm.getHeight();
            bui.append(this.getAtributosFonte(font));
            bui.append(" ");
            bui.append(this.getAtributosRetangulo(rec));
            bui.append("\">");
            bui.append(StringUtil.tratarEntidadesHTML(texto.getText(), true, false));
            bui.append("</span>");
            return bui.toString();
        }

        private String getAtributosTextoDigitacao(TextoDigitacao texto, boolean alterarParaRodape) {
            if (!texto.imprimir()) {
                return "";
            }
            String alteracaoParaRodape = "relative; float: left; ";
            if (!alterarParaRodape) {
                alteracaoParaRodape = "absolute; ";
            }
            StringBuilder bui = new StringBuilder("<span style=\"word-wrap: break-word;position: ").append(alteracaoParaRodape);
            if (texto.isOpaque()) {
                bui.append("background-color: ");
                bui.append(StringUtil.getHexadecimal(texto.getBackground()));
                bui.append("; ");
            }
            Font fonte = texto.getFont();
            fonte = new Font(fonte.getName(), fonte.getStyle(), fonte.getSize());
            texto.setFont(fonte);
            Rectangle rec = texto.getBounds();
            bui.append("z-index:5; white-space: normal; color: ");
            bui.append(StringUtil.getHexadecimal(texto.getForeground()));
            bui.append("; ");
            bui.append(this.getAtributosFonte(texto.getFont()));
            bui.append(" ");
            bui.append(this.getAtributosRetangulo(rec));
            bui.append("\">");
            bui.append(StringUtil.tratarEntidadesHTML(texto.getText().replace("\r\n", "\n").replace("\r", "\n")));
            bui.append("</span>");
            return bui.toString();
        }

        private String getAtributosFormaImpressao(FormaImpressao forma, boolean imagemData, boolean alterarParaRodape) {
            String alteracaoParaRodape = "relative; float: left; ";
            if (!alterarParaRodape) {
                alteracaoParaRodape = "absolute; ";
            }
            StringBuilder bui = new StringBuilder("<span style=\"");
            if (forma.getForma() != 1 && forma.getForma() != 0) {
                bui.append("border: 0px; ");
            }
            bui.append("position: ").append(alteracaoParaRodape);
            Rectangle rec = forma.getBounds();
            if (forma.getForma() == 0) {
                bui.append("z-index:3; background-color: ");
                bui.append(StringUtil.getHexadecimal(forma.getCorPreenchimento()));
                bui.append("; border: ");
                bui.append(forma.getEspessura());
                bui.append("px ");
                bui.append(StringUtil.getHexadecimal(forma.getCorLinha()));
                bui.append(" solid; ");
                --rec.width;
                --rec.height;
            } else if (forma.getForma() == 2) {
                bui.append("z-index:3; border-top:solid ");
                bui.append(StringUtil.getHexadecimal(forma.getCorLinha()));
                bui.append(" ");
                bui.append(forma.getEspessura());
                bui.append("px; ");
                rec.y += (rec.height - forma.getEspessura()) / 2;
                rec.height = forma.getEspessura() + 2;
            } else if (forma.getForma() == 3) {
                bui.append("z-index:1; border-left: solid  ");
                bui.append(StringUtil.getHexadecimal(forma.getCorLinha()));
                bui.append(" ");
                bui.append(forma.getEspessura());
                bui.append("px; ");
                rec.width = forma.getEspessura();
                rec.x += rec.width / 2 - forma.getEspessura() / 2;
            }
            bui.append(this.getAtributosRetangulo(rec));
            bui.append("\">");
            if (forma.getForma() == 1) {
                ++this.contadorImagens;
                BufferedImage buf = new BufferedImage(rec.width, rec.height, 2);
                Graphics2D g = buf.createGraphics();
                g.setColor(forma.getCorPreenchimento());
                g.fillOval(0, 0, rec.width - 1, rec.height - 1);
                g.setColor(forma.getCorLinha());
                g.drawOval(0, 0, rec.width - 1, rec.height - 1);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    ImageIO.write((RenderedImage)buf, "png", baos);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String imagemBase64 = new Base64().encodeAsString(baos.toByteArray());
                bui.append("<img width=\"");
                bui.append(rec.width);
                bui.append("\" height=\"");
                bui.append(rec.height);
                bui.append("\" border=\"0\" src=\"");
                if (!imagemData) {
                    this.imagens.put(new Integer(this.contadorImagens), imagemBase64);
                    bui.append("gerador.php?req=").append(this.requisicao);
                    bui.append("&exm=").append(this.exame);
                    bui.append("&mat=").append(this.material);
                    bui.append("&img=").append(this.contadorImagens);
                } else {
                    bui.append("data:image/jpg;base64,");
                    bui.append(imagemBase64);
                }
                bui.append("\"></img>");
            }
            bui.append("</span>");
            return bui.toString();
        }

        private String getAtributosReguaReferencialImpressao(ReguaReferencialImpressao regua, boolean imagemData, boolean alterarParaRodape) {
            String alteracaoParaRodape = "relative; float: left; ";
            if (!alterarParaRodape) {
                alteracaoParaRodape = "absolute; ";
            }
            StringBuilder bui = new StringBuilder("<span style=\"z-index:4; position: ").append(alteracaoParaRodape);
            Rectangle rec = regua.getBounds();
            bui.append(this.getAtributosRetangulo(rec));
            bui.append("\">");
            ++this.contadorImagens;
            BufferedImage buf = new BufferedImage(rec.width, rec.height, 2);
            regua.pintar(buf.createGraphics());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)buf, "png", baos);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String imagemBase64 = new Base64().encodeAsString(baos.toByteArray());
            bui.append("<img width=\"");
            bui.append(rec.width);
            bui.append("\" height=\"");
            bui.append(rec.height);
            bui.append("\" src=\"");
            if (!imagemData) {
                this.imagens.put(new Integer(this.contadorImagens), imagemBase64);
                bui.append("gerador.php?req=").append(this.requisicao);
                bui.append("&exm=").append(this.exame);
                bui.append("&mat=").append(this.material);
                bui.append("&img=").append(this.contadorImagens);
            } else {
                bui.append("data:image/jpg;base64,");
                bui.append(imagemBase64);
            }
            bui.append("\"></img></span>");
            return bui.toString();
        }

        private String getAtributosGraficoImpressao(GraficoImpressao grafico, boolean imagemData, boolean alterarParaRodape) {
            String alteracaoParaRodape = "relative; float: left; ";
            if (!alterarParaRodape) {
                alteracaoParaRodape = "absolute; ";
            }
            StringBuilder bui = new StringBuilder("<span style=\"background-color:white; z-index:4; position: ").append(alteracaoParaRodape);
            Rectangle rec = grafico.getBounds();
            bui.append(this.getAtributosRetangulo(rec));
            bui.append("\">");
            ++this.contadorImagens;
            BufferedImage buf = new BufferedImage(rec.width, rec.height, 2);
            Graphics2D g = buf.createGraphics();
            g.setColor(grafico.getBackground());
            g.fillRect(0, 0, rec.width, rec.height);
            grafico.pintar(buf.createGraphics());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)buf, "png", baos);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String imagemBase64 = new Base64().encodeAsString(baos.toByteArray());
            bui.append("<img width=\"");
            bui.append(rec.width);
            bui.append("\" height=\"");
            bui.append(rec.height);
            bui.append("\" src=\"");
            if (!imagemData) {
                this.imagens.put(new Integer(this.contadorImagens), imagemBase64);
                bui.append("gerador.php?req=").append(this.requisicao);
                bui.append("&exm=").append(this.exame);
                bui.append("&mat=").append(this.material);
                bui.append("&img=").append(this.contadorImagens);
            } else {
                bui.append("data:image/jpg;base64,");
                bui.append(imagemBase64);
            }
            bui.append("\"></img></span>");
            return bui.toString();
        }

        private String getAtributosImagemImpressao(ImagemImpressao imagem, boolean imagemData, boolean alterarParaRodape) {
            StringBuilder bui = new StringBuilder("");
            if (imagem.imprimir()) {
                ++this.contadorImagens;
                String imagemBase64 = imagem.getImagem();
                String alteracaoParaRodape = "relative; float: left; ";
                if (!alterarParaRodape) {
                    alteracaoParaRodape = "absolute; ";
                }
                Rectangle rec = imagem.getBounds();
                bui.append("<span style=\"z-index:4; position: ").append(alteracaoParaRodape);
                bui.append(this.getAtributosRetangulo(rec));
                bui.append("\"><img width=\"");
                bui.append(rec.width);
                bui.append("\" height=\"");
                bui.append(rec.height);
                bui.append("\" src=\"");
                if (!imagemData) {
                    this.imagens.put(new Integer(this.contadorImagens), imagemBase64);
                    bui.append("gerador.php?req=").append(this.requisicao);
                    bui.append("&exm=").append(this.exame);
                    bui.append("&mat=").append(this.material);
                    bui.append("&img=").append(this.contadorImagens);
                } else {
                    bui.append("data:image/jpg;base64,");
                    bui.append(imagemBase64);
                }
                bui.append("\"></img></span>");
            }
            return bui.toString();
        }

        private String getAtributosFonte(Font fonte) {
            StringBuilder bui = new StringBuilder();
            bui.append("font-family: '");
            bui.append(fonte.getFamily());
            bui.append("'; ");
            if (fonte.isBold()) {
                bui.append("font-weight: bold; ");
            }
            if (fonte.isItalic()) {
                bui.append("font-style: italic; ");
            }
            bui.append("font-size: ");
            bui.append(fonte.getSize());
            bui.append("px;");
            return bui.toString();
        }

        private String getAtributosRetangulo(Rectangle rec) {
            StringBuilder bui = new StringBuilder("left: ");
            bui.append(rec.x);
            bui.append("px; top: ");
            bui.append(rec.y);
            bui.append("px; width: ");
            bui.append(rec.width);
            bui.append("px; height: ");
            bui.append(rec.height);
            bui.append("px;");
            return bui.toString();
        }
    }
}

