/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.digitacao;

import jalis.laboratorio.configurador.componente.Campo;
import jalis.laboratorio.configurador.expressao.Sintatico;
import jalis.laboratorio.configurador.expressao.SintaticoCondicao;
import jalis.laboratorio.configurador.expressao.SintaticoExpressao;
import jalis.laboratorio.configurador.expressao.Token;
import jalis.laboratorio.digitacao.TabelaSimbolos;
import jalis.laboratorio.digitacao.componente.CampoDigitacao;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.expressao.parser.ExpUtil;
import jalis.util.logger.ErrorLogger;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class Execucao {
    private Sintatico sin;
    private TabelaSimbolos tab;
    private Token tkTermExec;

    public Execucao(String expressao, TabelaSimbolos tab, int tipo) {
        this.sin = tipo == 0 ? new SintaticoExpressao(expressao, 8) : new SintaticoCondicao(expressao, 8);
        this.tab = tab;
    }

    public Object resultadoExpressao() {
        return this.executar();
    }

    public boolean resultadoCondicao() {
        return this.logico();
    }

    private Object executar() {
        Object res = null;
        int op = -1;
        Token tk = this.sin.getProxToken();
        while (tk.id != 29 && !tk.erro) {
            if (tk.literal() || tk.funcao() || tk.id == 0 || tk.id == 16) {
                switch (op) {
                    case 27: {
                        res = this.soma(res, this.valor(tk));
                        break;
                    }
                    case 26: {
                        res = this.subtrai(res, this.valor(tk));
                        break;
                    }
                    case 24: {
                        res = this.multiplica(res, this.valor(tk));
                        break;
                    }
                    case 25: {
                        res = this.divide(res, this.valor(tk));
                        break;
                    }
                    case 30: {
                        res = this.eleva(res, this.valor(tk));
                        break;
                    }
                    default: {
                        res = this.valor(tk);
                    }
                }
                if (op == 27 || op == 26 || op == 24 || op == 25) {
                    op = -1;
                }
            } else if (tk.operadorMatematico()) {
                op = tk.id;
            } else if (tk.id == 17 || tk.id == 28 || tk.operadorLogico() || tk.operadorRelacional()) {
                this.tkTermExec = tk;
                break;
            }
            tk = this.sin.getProxToken();
        }
        if (tk.erro) {
            ErrorLogger.mostraMensagem(null, tk.erroDesc, null, "Execucao: 130");
        }
        return res;
    }

    private Object valor(Token tk) {
        try {
            if (tk.literal()) {
                return tk.instancia();
            }
            if (tk.id == 0) {
                return this.tab.getValor(tk.lexema);
            }
            if (tk.id == 16) {
                return this.executar();
            }
            if (tk.id == 5) {
                return this.se();
            }
            if (tk.id == 6) {
                return this.copia();
            }
            if (tk.id == 7) {
                return this.vazio();
            }
            if (tk.id == 8) {
                return this.zero();
            }
            if (tk.id == 9) {
                return this.data();
            }
            if (tk.id == 10) {
                return this.extenso();
            }
            if (tk.id == 11) {
                return this.numero();
            }
            if (tk.id == 13) {
                return this.tamanho();
            }
            if (tk.id == 31) {
                return this.log10();
            }
            if (tk.id == 32) {
                return this.converteDecimal();
            }
            if (tk.id == 33) {
                return this.validarNormal();
            }
            if (tk.id == 34) {
                return this.contem();
            }
            if (tk.id == 12) {
                return this.somaData();
            }
            if (tk.id == 35) {
                return this.raizQuadrada();
            }
            if (tk.id == 36) {
                return this.limpaMascara();
            }
            if (tk.id == 37) {
                return this.notaocaoCientifica();
            }
            if (tk.id == 38) {
                return this.pegaValorCampo();
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Execucao: 175");
        }
        return null;
    }

    private Object limpaMascara() {
        Object tmp;
        Token tk = this.sin.getProxToken();
        if (tk.id == 16 && (tmp = this.executar()) != null) {
            tmp = StringUtil.trataPontuacaoRaiz(tmp.toString());
            BigDecimal d = new BigDecimal(tmp.toString());
            return d;
        }
        return new Double(0.0);
    }

    private Object notaocaoCientifica() {
        Object tmp;
        Token tk = this.sin.getProxToken();
        if (tk.id == 16 && (tmp = this.executar()) != null) {
            String v = String.format("%.13e", Double.parseDouble(tmp.toString()));
            String[] exp = v.split("e+");
            String valorConvertivo = StringUtil.trataPontuacaoRaiz(exp[0]);
            Double total = Double.parseDouble(valorConvertivo);
            Integer potencia = Integer.parseInt(exp[1]);
            StringBuilder buf = new StringBuilder();
            buf.append("<html>");
            buf.append(total).append(" x10");
            buf.append("<sup>").append(potencia);
            buf.append("</sup></html>");
            return buf.toString();
        }
        return new Double(0.0);
    }

    private Object pegaValorCampo() {
        Object tmp;
        Object valor;
        Token tk = this.sin.getProxToken();
        if (tk.id == 16 && (valor = this.tab.getValor((tmp = this.executar()).toString())) != null) {
            return valor.toString();
        }
        return "";
    }

    private boolean logico() {
        boolean res = false;
        Object tmp = this.executar();
        int opRel = this.tkTermExec.id;
        res = this.compara(tmp, this.executar(), opRel);
        while (res && this.tkTermExec.id == 14 || !res && this.tkTermExec.id == 15) {
            int opLog = this.tkTermExec.id;
            tmp = this.executar();
            opRel = this.tkTermExec.id;
            if (opLog == 14) {
                res = res && this.compara(tmp, this.executar(), opRel);
                continue;
            }
            res = res || this.compara(tmp, this.executar(), opRel);
        }
        if (this.tkTermExec.id != 28) {
            this.consumirTokens(28);
        }
        return res;
    }

    private Object se() {
        Object res = null;
        Token tk = this.sin.getProxToken();
        if (tk.id == 16) {
            if (this.logico()) {
                res = this.executar();
                this.consumirTokens(17);
            } else {
                this.consumirTokens(28);
                res = this.executar();
            }
        }
        return res;
    }

    private Object copia() {
        Token tk = this.sin.getProxToken();
        if (tk.id == 16) {
            Object tmp = this.executar();
            if (tmp == null) {
                this.consumirTokens(28);
                this.consumirTokens(17);
            } else {
                String str = tmp.toString();
                int pos = (int)this.valorLong(this.executar());
                int qtd = (int)this.valorLong(this.executar());
                if (pos > 0 && pos <= str.length()) {
                    qtd = pos + qtd - 1 > str.length() ? str.length() - pos + 1 : qtd;
                    return str.substring(pos - 1, pos + qtd - 1);
                }
            }
        }
        return "";
    }

    private Object vazio() {
        Token tk = this.sin.getProxToken();
        if (tk.id == 16) {
            Object tmp = this.executar();
            if (tmp == null) {
                this.consumirTokens(28);
                this.consumirTokens(17);
            } else {
                String str = tmp.toString();
                int tam = (int)this.valorLong(this.executar());
                String ali = (String)this.executar();
                if (tam > str.length()) {
                    StringBuilder res = new StringBuilder(str);
                    if (ali.equalsIgnoreCase("c")) {
                        for (int i = 0; i < (tam - str.length()) / 2; ++i) {
                            res.insert(0, " ");
                            res.append(" ");
                        }
                        if ((tam - str.length()) % 2 != 0) {
                            res.append(" ");
                        }
                    } else if (ali.equalsIgnoreCase("e")) {
                        for (int i = 0; i < tam - str.length(); ++i) {
                            res.append(" ");
                        }
                    } else if (ali.equalsIgnoreCase("d")) {
                        for (int i = 0; i < tam - str.length(); ++i) {
                            res.insert(0, " ");
                        }
                    }
                    return res.toString();
                }
                return str;
            }
        }
        return "";
    }

    private Object zero() {
        Token tk = this.sin.getProxToken();
        if (tk.id == 16) {
            Object tmp = this.executar();
            if (tmp == null) {
                this.consumirTokens(17);
            } else {
                StringBuilder str = new StringBuilder(tmp.toString());
                int tam = (int)this.valorLong(this.executar());
                if (tam > str.length()) {
                    int vzs = tam - str.length();
                    for (int i = 0; i < vzs; ++i) {
                        str.insert(0, "0");
                    }
                }
                return str.toString();
            }
        }
        return "";
    }

    private Object data() {
        Token tk = this.sin.getProxToken();
        if (tk.id == 16) {
            Object tmp = this.executar();
            String masc = (String)this.executar();
            masc = masc.replace('a', 'y').replace('h', 'k');
            if (tmp instanceof String && !Funcoes.textoVazio((String)tmp) && masc.equalsIgnoreCase("kk:mm")) {
                return ((String)tmp).substring(0, 5);
            }
            if (tmp instanceof String && !Funcoes.textoVazio((String)tmp) && masc.equalsIgnoreCase("kk:mm:sss")) {
                return (String)tmp;
            }
            Date d = this.valorData(tmp);
            if (d != null) {
                return new SimpleDateFormat(masc).format(d);
            }
        }
        return "";
    }

    private Object tamanho() {
        Object tmp;
        Token tk = this.sin.getProxToken();
        if (tk.id == 16 && (tmp = this.executar()) != null) {
            return new Long(tmp.toString().length());
        }
        return new Long(0L);
    }

    private Object log10() {
        Object tmp;
        Token tk = this.sin.getProxToken();
        if (tk.id == 16 && (tmp = this.executar()) != null) {
            return new Double(Math.log10(Double.parseDouble(tmp.toString())));
        }
        return new Double(0.0);
    }

    private Object raizQuadrada() {
        Object tmp;
        Token tk = this.sin.getProxToken();
        if (tk.id == 16 && (tmp = this.executar()) != null) {
            return new Double(Math.sqrt(Double.parseDouble(tmp.toString())));
        }
        return new Double(0.0);
    }

    private Object converteDecimal() {
        Object tmp;
        Token tk = this.sin.getProxToken();
        Double retorno = new Double(0.0);
        if (tk.id == 16 && (tmp = this.executar()) != null && tmp.toString().trim().length() > 0) {
            try {
                retorno = tmp.toString().indexOf(".") > 0 && tmp.toString().indexOf(",") > 0 ? new Double(tmp.toString().replaceAll("[.]", "").replaceAll(",", ".")) : new Double(tmp.toString().replaceAll(",", "."));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return retorno;
    }

    private Object extenso() {
        Token tk = this.sin.getProxToken();
        if (tk.id == 16) {
            Object tmp = this.executar();
            if (tmp instanceof Number) {
                return StringUtil.extenso(((Number)tmp).floatValue());
            }
            if (tmp != null && StringUtil.validaNumero(tmp.toString())) {
                return StringUtil.extenso(Float.parseFloat(StringUtil.strDecimal(tmp.toString())));
            }
        }
        return "";
    }

    private Object numero() {
        Token tk = this.sin.getProxToken();
        if (tk.id == 16) {
            Object tmp = this.executar();
            if (tmp == null || !(tmp instanceof Number) && !StringUtil.validaNumero(tmp.toString())) {
                this.consumirTokens(17);
            } else {
                String masc = (String)this.executar();
                BigDecimal valor = tmp instanceof Number ? new BigDecimal(((Number)tmp).toString()) : new BigDecimal(StringUtil.strDecimal(tmp.toString()));
                masc = StringUtil.trocarCaractere(masc, ',', '.');
                return StringUtil.validaMascaraNumero(masc) ? new DecimalFormat(masc).format(valor) : new DecimalFormat().format(valor);
            }
        }
        return "";
    }

    private Object somaData() {
        Token tk = this.sin.getProxToken();
        if (tk.id == 16) {
            Calendar calendario = Calendar.getInstance();
            Date data = ExpUtil.valorData(this.executar());
            calendario.setTime(data == null ? new Date() : data);
            calendario.add(5, ExpUtil.valorInt(this.executar()));
            return calendario.getTime();
        }
        return new Date(0L);
    }

    private void consumirTokens(int tokenDelim) {
        int abre = 0;
        Token tk = this.sin.getProxToken();
        while (tk.id != 29 && !tk.erro) {
            if (tk.id == 16) {
                ++abre;
            } else if (tk.id == 17) {
                --abre;
            } else if (tk.id == tokenDelim && abre == 0) {
                return;
            }
            tk = this.sin.getProxToken();
        }
    }

    public Object soma(Object a, Object b) {
        if (a == null || b == null) {
            return a == null ? b : a;
        }
        if (a instanceof String || b instanceof String) {
            return a.toString() + b.toString();
        }
        if (a instanceof Number && b instanceof Number) {
            return new BigDecimal(((Number)a).toString()).add(new BigDecimal(((Number)b).toString()));
        }
        return null;
    }

    public Object subtrai(Object a, Object b) {
        if (a instanceof Number && b instanceof Number) {
            return new BigDecimal(((Number)a).toString()).subtract(new BigDecimal(((Number)b).toString()));
        }
        return null;
    }

    public Object multiplica(Object a, Object b) {
        if (a instanceof Number && b instanceof Number) {
            return new BigDecimal(((Number)a).toString()).multiply(new BigDecimal(((Number)b).toString()));
        }
        return null;
    }

    public Object divide(Object a, Object b) {
        if (a instanceof Number && b instanceof Number && ((Number)b).floatValue() != 0.0f) {
            return new BigDecimal(((Number)a).toString()).divide(new BigDecimal(((Number)b).toString()), 30, RoundingMode.UP);
        }
        return null;
    }

    public Object eleva(Object a, Object b) {
        if (a instanceof Number && b instanceof Number) {
            return new Float(Math.pow(((Number)a).doubleValue(), ((Number)b).doubleValue()));
        }
        return null;
    }

    public Object raiz(Object a, Object tmp) {
        if (a instanceof Number && tmp instanceof Number) {
            return new Double(Math.sqrt(Double.parseDouble(tmp.toString())));
        }
        return null;
    }

    public boolean compara(Object a, Object b, int opRel) {
        if (a != null && b != null) {
            String strA = a.toString();
            String strB = b.toString();
            while (strA.contains("<") && strA.contains(">") && strA.indexOf("<") < strA.indexOf(">")) {
                strA = strA.replace(strA.substring(strA.indexOf("<"), strA.indexOf(">") + 1), "");
                strA = strA.trim();
            }
            switch (opRel) {
                case 22: {
                    if (a instanceof String || b instanceof String) {
                        if (StringUtil.verificaDataValida(strA) && StringUtil.verificaDataValida(strB)) {
                            return StringUtil.getDataDeString(strA).compareTo(StringUtil.getDataDeString(strB)) == 0;
                        }
                        return strA.equalsIgnoreCase(strB);
                    }
                    if (a instanceof Number && b instanceof Number) {
                        return ((Number)a).floatValue() == ((Number)b).floatValue();
                    }
                }
                case 23: {
                    if (a instanceof String || b instanceof String) {
                        if (StringUtil.verificaDataValida(strA) && StringUtil.verificaDataValida(strB)) {
                            return StringUtil.getDataDeString(strA).compareTo(StringUtil.getDataDeString(strB)) != 0;
                        }
                        return !strA.equalsIgnoreCase(strB);
                    }
                    if (a instanceof Number && b instanceof Number) {
                        return ((Number)a).floatValue() != ((Number)b).floatValue();
                    }
                }
                case 19: {
                    if (a instanceof String || b instanceof String) {
                        if (StringUtil.verificaDataValida(strA) && StringUtil.verificaDataValida(strB)) {
                            return StringUtil.getDataDeString(strA).compareTo(StringUtil.getDataDeString(strB)) > 0;
                        }
                        return strA.compareToIgnoreCase(strB) > 0;
                    }
                    if (a instanceof Number && b instanceof Number) {
                        return ((Number)a).floatValue() > ((Number)b).floatValue();
                    }
                }
                case 21: {
                    if (a instanceof String || b instanceof String) {
                        if (StringUtil.verificaDataValida(strA) && StringUtil.verificaDataValida(strB)) {
                            return StringUtil.getDataDeString(strA).compareTo(StringUtil.getDataDeString(strB)) >= 0;
                        }
                        return strA.compareToIgnoreCase(strB) >= 0;
                    }
                    if (a instanceof Number && b instanceof Number) {
                        return ((Number)a).floatValue() >= ((Number)b).floatValue();
                    }
                }
                case 18: {
                    if (a instanceof String || b instanceof String) {
                        if (StringUtil.verificaDataValida(strA) && StringUtil.verificaDataValida(strB)) {
                            return StringUtil.getDataDeString(strA).compareTo(StringUtil.getDataDeString(strB)) < 0;
                        }
                        return strA.compareToIgnoreCase(strB) < 0;
                    }
                    if (a instanceof Number && b instanceof Number) {
                        return ((Number)a).floatValue() < ((Number)b).floatValue();
                    }
                }
                case 20: {
                    if (a instanceof String || b instanceof String) {
                        if (StringUtil.verificaDataValida(strA) && StringUtil.verificaDataValida(strB)) {
                            return StringUtil.getDataDeString(strA).compareTo(StringUtil.getDataDeString(strB)) <= 0;
                        }
                        return strA.compareToIgnoreCase(strB) <= 0;
                    }
                    if (!(a instanceof Number) || !(b instanceof Number)) break;
                    return ((Number)a).floatValue() <= ((Number)b).floatValue();
                }
            }
        } else if (a == null && b == null) {
            return true;
        }
        return false;
    }

    private long valorLong(Object o) {
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        if (o instanceof String && StringUtil.validaNumero(o.toString())) {
            return new Float(StringUtil.strDecimal(o.toString())).longValue();
        }
        return 0L;
    }

    private Date valorData(Object o) {
        try {
            Object tmp;
            if (o instanceof Date) {
                return (Date)o;
            }
            if (o != null && (tmp = StringUtil.getValorString(o.toString())) instanceof Date) {
                return (Date)tmp;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Execucao: 666");
        }
        return null;
    }

    private Object validarNormal() {
        Token tk = this.sin.getProxToken();
        Boolean retorno = new Boolean(false);
        if (tk.id == 16) {
            tk = this.sin.getProxToken();
            if (tk != null && this.tab.getCampoDigitacao(tk.lexema) != null) {
                CampoDigitacao c = this.tab.getCampoDigitacao(tk.lexema);
                retorno = c.getDono() instanceof Campo && !((Campo)c.getDono()).valorAlterado();
            }
            tk = this.sin.getProxToken();
        }
        return retorno;
    }

    private Object contem() {
        Token tk = this.sin.getProxToken();
        if (tk.id == 16) {
            Object tmp = this.executar();
            if (tmp == null) {
                this.consumirTokens(17);
            } else {
                String buscar = (String)this.executar();
                if (tmp != null && buscar != null) {
                    return new Integer(tmp.toString().toLowerCase().indexOf(buscar.toLowerCase()));
                }
            }
        }
        return new Integer(-1);
    }
}

