/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.digitacao;

import jalis.laboratorio.configurador.acoes.AbstractAcoes;
import jalis.laboratorio.configurador.acoes.FabricaAcoes;
import jalis.laboratorio.configurador.componente.AbstractComponente;
import jalis.laboratorio.configurador.componente.Campo;
import jalis.laboratorio.configurador.componente.CodigoQRCode;
import jalis.laboratorio.configurador.componente.Expressao;
import jalis.laboratorio.configurador.componente.Forma;
import jalis.laboratorio.configurador.componente.Grafico;
import jalis.laboratorio.configurador.componente.Historico;
import jalis.laboratorio.configurador.componente.Imagem;
import jalis.laboratorio.configurador.componente.ReguaReferencial;
import jalis.laboratorio.configurador.componente.ResultadoAnterior;
import jalis.laboratorio.configurador.componente.Rotulo;
import jalis.laboratorio.digitacao.Lupa;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.digitacao.TabelaSimbolosListener;
import jalis.laboratorio.digitacao.componente.AbsurdoListener;
import jalis.laboratorio.digitacao.componente.CampoDigitacao;
import jalis.laboratorio.digitacao.componente.CampoListaDigitacao;
import jalis.laboratorio.digitacao.componente.ComponenteDigitacao;
import jalis.laboratorio.digitacao.componente.DadosDigitacao;
import jalis.laboratorio.digitacao.componente.ExpressaoDigitacao;
import jalis.laboratorio.digitacao.componente.ExternoDigitacao;
import jalis.laboratorio.digitacao.componente.GraficoConfiguravelDigitacao;
import jalis.laboratorio.digitacao.componente.GraficoQuadranteDigitacao;
import jalis.laboratorio.digitacao.componente.GraficoReferenciaDigitacao;
import jalis.laboratorio.digitacao.componente.GraficoResultadoAnteriorDigitacao;
import jalis.laboratorio.digitacao.componente.HistoricoDigitacao;
import jalis.laboratorio.digitacao.componente.ImagemDigitacao;
import jalis.laboratorio.digitacao.componente.ReguaReferencialDigitacao;
import jalis.laboratorio.digitacao.componente.ResultadoAnteriorDigitacao;
import jalis.laboratorio.digitacao.componente.TextoDigitacao;
import jalis.laboratorio.digitacao.evento.DigitacaoEvento;
import jalis.laboratorio.digitacao.evento.DigitacaoListener;
import jalis.laboratorio.digitacao.evento.ImagemDigitacaoListener;
import jalis.laboratorio.impressao.componente.CodigoQRCodeImpressao;
import jalis.laboratorio.impressao.componente.FormaImpressao;
import jalis.laboratorio.impressao.componente.GraficoImpressao;
import jalis.laboratorio.impressao.componente.ImagemImpressao;
import jalis.laboratorio.impressao.componente.ReguaReferencialImpressao;
import jalis.laboratorio.impressao.componente.TextoEstatico;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class Digitacao
extends JPanel
implements ActionListener,
AbsurdoListener {
    JPanel panelArea = new JPanel(null);
    JLabel labelMensagem = new JLabel();
    private JPanel panelBarra = new JPanel(new BorderLayout());
    private JPanel panelBotoes = new JPanel(new FlowLayout(2, 3, 3));
    private JPanel panelBotoesEsquerda = new JPanel(new FlowLayout(0, 3, 3));
    private JCheckBox checkImprimir = ComponenteFactory.novoJCheckBox("Imprimir", 'I', this);
    private JButton buttonImprimir = ComponenteFactory.novoJButton("Imprimir", 'I', this, null, null);
    private JButton buttonSalvar = ComponenteFactory.novoJButton("Salvar", 'S', this, null, null);
    private JButton buttonSalvarParcial = ComponenteFactory.novoJButton("Salvar Parcial", 'r', this, null, null);
    private JButton buttonRemover = ComponenteFactory.novoJButton("Remover", 'R', this, null, null);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this, null, null);
    private Resultado resultado;
    private List<Component> componentesFoco = new ArrayList<Component>();
    private Lupa lupa;
    private boolean verificarCompleto;
    private MouseListener mouseListener;
    private MouseMotionListener mouseMotionListener;
    private JScrollBar scrollBar;
    private ArrayList<ImagemDigitacaoListener> listenerImagemDigitacao = new ArrayList();
    private String codigoExame = null;
    private Integer codigoMaterialColeta = null;
    private int ordem = -1;
    private boolean isEditando = false;
    private boolean absurdoDisparado = false;
    private String situacao = "";
    ArrayList<AbstractAcoes> acoesExame = new ArrayList();
    Map<String, Object> dadosExame = null;
    private TipoOrigemDigitacao tipoOrigemDigitacao = TipoOrigemDigitacao.OUTROS;
    private String atributos;
    private Map<String, Object> dados;
    private Map<String, Object> externos;
    private Map<String, String> historicos;
    private Map<String, String> historicosPorMnemonico;
    private Map<Integer, String> resAnterior;
    private boolean edicao;
    private int ordemAnteriores;
    private String resultadoAtual;
    private AbsurdoListener tabbedPaneExame;
    private List<Component> compsAux = new ArrayList<Component>();
    private ArrayList<ImagemDigitacao> imagens = new ArrayList();

    public Digitacao() {
        this.setLayout(new BorderLayout());
        JScrollPane scroll = new JScrollPane(this.panelArea);
        this.scrollBar = scroll.getVerticalScrollBar();
        this.add((Component)scroll, "Center");
        this.add((Component)this.panelBarra, "South");
        this.panelBarra.add((Component)this.labelMensagem, "Center");
        this.panelBarra.add((Component)this.panelBotoes, "East");
        this.panelBarra.add((Component)this.panelBotoesEsquerda, "West");
        this.panelBotoes.add(this.checkImprimir);
        this.panelBotoes.add(this.buttonImprimir);
        this.panelBotoes.add(this.buttonSalvarParcial);
        this.panelBotoes.add(this.buttonSalvar);
        this.panelBotoes.add(this.buttonFechar);
        this.panelBotoesEsquerda.add(this.buttonRemover);
        this.buttonSalvarParcial.setVisible(false);
        this.buttonFechar.setVisible(false);
        this.componentesFoco.add(this.buttonRemover);
        this.componentesFoco.add(this.checkImprimir);
        this.componentesFoco.add(this.buttonImprimir);
        this.componentesFoco.add(this.buttonSalvar);
        this.componentesFoco.add(this.buttonSalvarParcial);
        this.componentesFoco.add(this.buttonFechar);
        this.verificarCompleto = false;
        this.exibirBotaoImprimir(false);
        this.exibirBotaoRemover(false);
        ScreenUtil.addActionMap(this, KeyStroke.getKeyStroke("F3"), "foco_historicos", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Digitacao.this.setFocoPrimeiroComponenteDoTipo(HistoricoDigitacao.class);
            }
        });
        this.mouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    int x = 0;
                    int y = 0;
                    if (e.getSource() != Digitacao.this.panelArea) {
                        Component comp = (Component)e.getSource();
                        x = comp.getX();
                        y = comp.getY();
                    }
                    Digitacao.this.panelArea.add((Component)(Digitacao.this.lupa = new Lupa(1.6)), 0);
                    Digitacao.this.lupa.setBounds(x + e.getX() - 200, y + e.getY() - 150, 400, 300);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (Digitacao.this.lupa != null) {
                    Digitacao.this.panelArea.remove(Digitacao.this.lupa);
                    Digitacao.this.panelArea.repaint();
                    Digitacao.this.lupa = null;
                }
            }
        };
        this.panelArea.addMouseListener(this.mouseListener);
        this.mouseMotionListener = new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (Digitacao.this.lupa != null) {
                    int x = 0;
                    int y = 0;
                    if (e.getSource() != Digitacao.this.panelArea) {
                        Component comp = (Component)e.getSource();
                        x = comp.getX();
                        y = comp.getY();
                    }
                    Digitacao.this.lupa.setLocation(x + e.getX() - 200, y + e.getY() - 150);
                }
            }
        };
        this.panelArea.addMouseMotionListener(this.mouseMotionListener);
    }

    public void setTipoOrigemDigitacao(TipoOrigemDigitacao tipo) {
        this.tipoOrigemDigitacao = tipo;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (!(this.absurdoDisparado || o != this.buttonSalvar && o != this.buttonSalvarParcial && o != this.buttonImprimir)) {
            if (!this.verificarCondicao()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Funcoes.mensagem(Digitacao.this.getTopLevelAncestor(), Digitacao.this.getMensagemErro(), 1);
                    }
                });
            } else if (o == this.buttonSalvar || o == this.buttonImprimir) {
                if (this.resultadoNaoInformado()) {
                    return;
                }
                if (o == this.buttonSalvar) {
                    this.fireAcaoSalvar();
                } else {
                    this.fireAcaoImprimir();
                }
            } else {
                this.fireAcaoSalvarParcial();
            }
        } else if (o == this.buttonRemover) {
            this.fireAcaoRemover();
        } else if (o == this.buttonFechar) {
            this.fireAcaoFechar();
        }
    }

    public boolean resultadoNaoInformado() {
        if (this.verificarCompleto && !this.resultadoCompleto(false) && this.resultado != null) {
            Component tmp;
            Component component = tmp = this.resultado == null ? null : this.resultado.getPrimeiroCampoVazio();
            if (tmp != null) {
                Funcoes.mensagem(this.getTopLevelAncestor(), "Valor de resultado n\u00e3o informado\n(Campo: " + tmp.getName() + ")", 1);
                ScreenUtil.requisitarFoco(tmp);
                return true;
            }
        }
        return false;
    }

    public void setVerificarCompleto(boolean verificar) {
        this.verificarCompleto = verificar;
    }

    public boolean verificaExameCompleto() {
        return this.verificarCompleto;
    }

    public void setFocoPrimeiroComponenteDoTipo(Class<? extends ComponenteDigitacao> tipo) {
        if (this.resultado != null) {
            ScreenUtil.requisitarFoco(this.resultado.getPrimeiroComponenteDoTipo(tipo));
        }
    }

    public void addBotao(JButton button) {
        if (button != null) {
            this.panelBotoes.add((Component)button, 0);
            this.componentesFoco.add(button);
        }
    }

    public void addDigitacaoListener(DigitacaoListener l) {
        this.listenerList.add(DigitacaoListener.class, l);
    }

    public void removeDigitacaoListener(DigitacaoListener l) {
        this.listenerList.remove(DigitacaoListener.class, l);
    }

    public void addImagemDigitacaoListener(ImagemDigitacaoListener l) {
        this.listenerImagemDigitacao.add(l);
    }

    public void removeImagemDigitacaoListener(ImagemDigitacaoListener l) {
        this.listenerImagemDigitacao.remove(l);
    }

    public void carregarCampos(String atributos) {
        this.carregarCampos(atributos, null, null, null, null, null, false, 1, null, null);
    }

    public void carregarCampos(String atributos, AbsurdoListener tabbedPaneExame) {
        this.carregarCampos(atributos, null, null, null, null, null, false, 1, tabbedPaneExame, null);
    }

    public void carregarCampos(String atributos, boolean edicao) {
        this.carregarCampos(atributos, null, null, null, null, null, edicao, 1, null, null);
    }

    public void carregarCampos(String atributos, boolean edicao, AbsurdoListener tabbedPaneExame) {
        this.carregarCampos(atributos, null, null, null, null, null, edicao, 1, tabbedPaneExame, null);
    }

    public void carregarCampos(String atributos, Map<String, Object> dados) {
        this.carregarCampos(atributos, dados, null, null, null, null, false, 1, null, null);
    }

    public void carregarCampos(String atributos, Map<String, Object> dados, AbsurdoListener tabbedPaneExame) {
        this.carregarCampos(atributos, dados, null, null, null, null, false, 1, tabbedPaneExame, null);
    }

    public void carregarCampos(String atributos, Map<String, Object> dados, Map<String, Object> externos, Map<String, String> historicos, Map<String, String> historicosPorMnemonico, Map<Integer, String> resAnterior, int ordemAnteriores) {
        this.carregarCampos(atributos, dados, externos, historicos, historicosPorMnemonico, resAnterior, false, ordemAnteriores, null, null);
    }

    public void carregarCampos(String atributos, Map<String, Object> dados, Map<String, Object> externos, Map<String, String> historicos, Map<String, String> historicosPorMnemonico, Map<Integer, String> resAnterior, int ordemAnteriores, String resultadoAtual) {
        this.carregarCampos(atributos, dados, externos, historicos, historicosPorMnemonico, resAnterior, false, ordemAnteriores, null, resultadoAtual);
    }

    public void carregarCampos(String atributos, Map<String, Object> dados, Map<String, Object> externos, Map<String, String> historicos, Map<String, String> historicosPorMnemonico, Map<Integer, String> resAnterior, int ordemAnteriores, AbsurdoListener tabbedPaneExame, String resultadoAtual) {
        this.carregarCampos(atributos, dados, externos, historicos, historicosPorMnemonico, resAnterior, false, ordemAnteriores, tabbedPaneExame, resultadoAtual);
    }

    public void carregarCampos(String atributos, Map<String, Object> dados, Map<String, Object> externos, Map<String, String> historicos, Map<String, String> historicosPorMnemonico, Map<Integer, String> resAnterior, boolean edicao, int ordemAnteriores) {
        this.carregarCampos(atributos, dados, externos, historicos, historicosPorMnemonico, resAnterior, edicao, ordemAnteriores, null, null);
    }

    public void carregarCampos(String atributos, Map<String, Object> dados, Map<String, Object> externos, Map<String, String> historicos, Map<String, String> historicosPorMnemonico, Map<Integer, String> resAnterior, boolean edicao, int ordemAnteriores, AbsurdoListener tabbedPaneExame, String resultadoAtual) {
        this.atributos = atributos;
        this.dados = dados;
        this.externos = externos;
        this.historicos = historicos;
        this.historicosPorMnemonico = historicosPorMnemonico;
        this.resAnterior = resAnterior;
        this.edicao = edicao;
        this.ordemAnteriores = ordemAnteriores;
        this.resultadoAtual = resultadoAtual;
        if (!Funcoes.textoVazio(atributos)) {
            atributos = atributos.replace("&apos;", "'");
        }
        this.resultado = new Resultado(this, atributos, dados, externos, historicos, historicosPorMnemonico, resAnterior, this.componentesFoco, edicao, ordemAnteriores, true, resultadoAtual);
        List<Component> comps = this.resultado.getComponentes();
        this.instanciaAcoesExame(atributos);
        this.dadosExame = dados;
        this.redimensionar(comps, false);
        this.panelArea.removeAll();
        for (Component comp : comps) {
            String versaoXML;
            this.panelArea.add(comp);
            comp.addMouseListener(this.mouseListener);
            comp.addMouseMotionListener(this.mouseMotionListener);
            if (comp instanceof CampoDigitacao) {
                ((CampoDigitacao)comp).addListenerAbsurdo(this);
                if (tabbedPaneExame != null) {
                    ((CampoDigitacao)comp).addListenerAbsurdo(tabbedPaneExame);
                }
            }
            if (comp instanceof TextoEstatico && (((TextoEstatico)comp).getDono() instanceof Historico || ((TextoEstatico)comp).getDono() instanceof HistoricoDigitacao) && !Funcoes.textoVazio(versaoXML = StringUtil.getValor(atributos, "versao")) && (versaoXML.equalsIgnoreCase("1.0") || versaoXML.equalsIgnoreCase("2.0"))) {
                ((TextoEstatico)comp).setHorizontalAlignment(2);
            }
            if (!(comp instanceof ImagemDigitacao)) continue;
            for (ImagemDigitacaoListener l : this.listenerImagemDigitacao) {
                ((ImagemDigitacao)comp).addImagemDigitacaoListener(l);
            }
            this.imagens.add((ImagemDigitacao)comp);
        }
        this.panelBarra.setVisible(!this.resultado.getAtributo("tipo").equals("resultado") || edicao);
        this.revalidate();
    }

    private void instanciaAcoesExame(String atributos) {
        if (Funcoes.textoVazio(atributos)) {
            return;
        }
        String exame = StringUtil.getValor(atributos, "exame");
        if (Funcoes.textoVazio(exame)) {
            return;
        }
        String parametros = StringUtil.getValor(exame, "parametros");
        if (Funcoes.textoVazio(parametros)) {
            return;
        }
        String acoesExames = StringUtil.getValor(parametros, "acoesexame");
        if (!Funcoes.textoVazio(acoesExames)) {
            String[] acoes;
            for (String acao : acoes = StringUtil.getValores(acoesExames, "acao")) {
                String nomeInterno = StringUtil.getValor(acao, "tipo");
                if (Funcoes.textoVazio(nomeInterno)) continue;
                AbstractAcoes instancia = FabricaAcoes.getAcaoNomeInterno(nomeInterno);
                instancia.setXML(acao);
                this.acoesExame.add(instancia);
            }
        }
    }

    public void exibirBotaoSalvar(boolean exibir) {
        this.buttonSalvar.setVisible(exibir);
    }

    public void exibirBotaoImprimir(boolean exibir) {
        this.buttonImprimir.setVisible(exibir);
    }

    public void exibirBotaoRemover(boolean exibir) {
        this.panelBarra.setVisible(exibir ? true : this.panelBarra.isVisible());
        this.buttonRemover.setVisible(exibir);
    }

    public void exibirBotaoSalvarParcial(boolean exibir) {
        this.buttonSalvarParcial.setVisible(exibir);
    }

    public void exibirBotaoFechar(boolean exibir) {
        this.buttonFechar.setVisible(exibir);
    }

    public void alterarNomeBotaoFechar(String texto) {
        this.buttonFechar.setText(texto);
    }

    public void exibirCheckBoxImprimir(boolean imprimir) {
        this.checkImprimir.setVisible(imprimir);
    }

    public void setFocoPrimeiroCampo() {
        if (this.resultado != null) {
            this.resultado.setFocoPrimeiro();
        }
    }

    public void setFocoPrimeiroCampoVazio() {
        Component campo = this.resultado == null ? null : this.resultado.getPrimeiroCampoVazio();
        ScreenUtil.requisitarFoco(campo);
    }

    public void setFocoProximo() {
        if (this.resultado != null && !this.resultado.setFocoProximo()) {
            if (this.buttonSalvarParcial.isVisible()) {
                ScreenUtil.requisitarFoco(this.buttonSalvarParcial);
            } else {
                ScreenUtil.requisitarFoco(this.buttonSalvar.isVisible() ? this.buttonSalvar : this.buttonFechar);
            }
        }
    }

    public void setFocoAnterior() {
        if (this.resultado != null) {
            this.resultado.setFocoAnterior();
        }
    }

    public void rolarParaBaixo() {
        this.scrollBar.setValue(this.scrollBar.getValue() - 30);
    }

    public void rolarParaCima() {
        this.scrollBar.setValue(this.scrollBar.getValue() + 30);
    }

    public boolean resultadoCompleto(boolean verificarParcial) {
        if (this.resultado != null) {
            return this.resultado.resultadoCompleto(verificarParcial);
        }
        return false;
    }

    public String getResultadoAnterior(Date dataBase, Date horaBase) {
        if (this.resultado != null) {
            return this.resultado.getResultadoAnterior(dataBase, horaBase);
        }
        return "";
    }

    public boolean isModificou() {
        for (Component comp : this.resultado.getComponentes()) {
            if (!(comp instanceof CampoDigitacao) || !((CampoDigitacao)comp).isModificou()) continue;
            return true;
        }
        return false;
    }

    public Resultado getResultadoObj() {
        return this.resultado;
    }

    public String getResultado() {
        return this.getResultado(true);
    }

    public String getResultado(boolean reprocessar) {
        if (this.resultado != null) {
            return this.resultado.getResultado(reprocessar);
        }
        return "";
    }

    public String getResultado(double zoom, boolean reprocessar) {
        return this.getResultado(reprocessar, zoom);
    }

    public String getResultado(boolean reprocessar, double zoom) {
        if (this.resultado != null) {
            return this.resultado.gerarResultado("resultado", true, reprocessar, zoom);
        }
        return "";
    }

    public String getResultadoPergunta() {
        if (this.resultado != null) {
            return this.resultado.getResultadoPergunta();
        }
        return "";
    }

    public String getResultadoParcial() {
        if (this.resultado != null) {
            return this.resultado.getResultadoParcial();
        }
        return "";
    }

    public String getResultadoParcial(double zoom) {
        if (this.resultado != null) {
            return this.resultado.getResultadoParcial(zoom);
        }
        return "";
    }

    public String getResultadoParcialValidandoCamposRemover() {
        if (this.resultado != null) {
            return this.resultado.getResultadoParcialValidandoCamposRemover();
        }
        return "";
    }

    public String getResultadoValidandoCamposRemover(boolean reprocessar) {
        if (this.resultado != null) {
            return this.resultado.getResultadoValidandoCamposRemover(reprocessar);
        }
        return "";
    }

    public Resultado getResultadoDigitacao() {
        if (this.resultado != null) {
            return this.resultado;
        }
        return null;
    }

    public Map<String, Object> getCamposInterfaceamento() {
        if (this.resultado != null) {
            return this.resultado.getCamposInterfaceamento();
        }
        return new HashMap<String, Object>();
    }

    public void limpar() {
        if (this.resultado != null) {
            this.resultado.limpar();
        }
    }

    public boolean verificarCondicao() {
        if (this.resultado != null) {
            return this.resultado.verificarCondicao();
        }
        return true;
    }

    public String getMensagemErro() {
        if (this.resultado != null) {
            return this.resultado.getMensagemErro();
        }
        return "";
    }

    public int verificarValidacao() {
        if (this.resultado != null) {
            return this.resultado.verificarValidacao();
        }
        return 2;
    }

    public int verificarValidacaoCompulsoria() {
        if (this.resultado != null) {
            return this.resultado.verificarValidacaoCompulsoria();
        }
        return 2;
    }

    public int verificarValidacaoResuldoCritico() {
        if (this.resultado != null) {
            return this.resultado.verificarValidacaoResultadoCritico();
        }
        return 2;
    }

    public String getMensagemValidacao() {
        if (this.resultado != null) {
            return this.resultado.getMensagemValidacao();
        }
        return "";
    }

    public String getMensagemValidacaoCompulsoria() {
        if (this.resultado != null) {
            return this.resultado.getMensagemValidacaoCompulsoria();
        }
        return "";
    }

    public void marcarCamposAlterados() {
        if (this.resultado != null) {
            for (Component c : this.resultado.getComponentes()) {
                TextoEstatico texto;
                if (!(c instanceof TextoEstatico) || !((texto = (TextoEstatico)c).getDono() instanceof Campo) || !((Campo)texto.getDono()).valorAlterado()) continue;
                texto.setOpaque(true);
                texto.setBackground(Campo.COR_ALTERADO);
            }
        }
    }

    public boolean possuiCamposForaDaReferencia() {
        if (this.resultado != null) {
            for (Component c : this.resultado.getComponentes()) {
                CampoDigitacao campo;
                TextoEstatico texto;
                if ((!(c instanceof TextoEstatico) || !((texto = (TextoEstatico)c).getDono() instanceof Campo) || !((Campo)texto.getDono()).valorAlterado()) && (!(c instanceof CampoDigitacao) || !((campo = (CampoDigitacao)c).getDono() instanceof Campo) || !((Campo)campo.getDono()).valorAlterado())) continue;
                return true;
            }
        }
        return false;
    }

    protected void fireAcaoSalvar() {
        for (DigitacaoListener ouvinte : (DigitacaoListener[])this.listenerList.getListeners(DigitacaoListener.class)) {
            ouvinte.acaoSalvar(new DigitacaoEvento(this, this.checkImprimir.isSelected()));
        }
        if (this.tipoOrigemDigitacao == TipoOrigemDigitacao.CONFERENCIA) {
            this.fireAcoesConferirExame();
        }
    }

    public void fireAcoesConferirExame() {
        if (this.dadosExame != null) {
            for (AbstractAcoes acao : this.acoesExame) {
                if (!acao.getTipoEvento().equals((Object)AbstractAcoes.TiposEventosAcoes.CONFERENCIA_RESULTADO)) continue;
                this.dadosExame.put("resultadoexame", this.resultado.getResultado());
                if (acao.executarAcao((HashMap)this.dadosExame)) break;
                Exception excecao = acao.getExcecaoAcao();
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel executar a\u00e7\u00e3o de confer\u00eancia do exame.\n" + excecao.getMessage(), excecao.getStackTrace());
                break;
            }
        }
    }

    protected void fireAcaoSalvarParcial() {
        for (DigitacaoListener ouvinte : (DigitacaoListener[])this.listenerList.getListeners(DigitacaoListener.class)) {
            ouvinte.acaoSalvarParcial(new DigitacaoEvento(this, this.checkImprimir.isSelected()));
        }
    }

    protected void fireAcaoFechar() {
        for (DigitacaoListener ouvinte : (DigitacaoListener[])this.listenerList.getListeners(DigitacaoListener.class)) {
            ouvinte.acaoFechar(new DigitacaoEvento(this, this.checkImprimir.isSelected()));
        }
    }

    protected void fireAcaoRemover() {
        for (DigitacaoListener ouvinte : (DigitacaoListener[])this.listenerList.getListeners(DigitacaoListener.class)) {
            ouvinte.acaoRemover(new DigitacaoEvento(this, this.checkImprimir.isSelected()));
        }
    }

    protected void fireAcaoImprimir() {
        for (DigitacaoListener ouvinte : (DigitacaoListener[])this.listenerList.getListeners(DigitacaoListener.class)) {
            ouvinte.acaoImprimir(new DigitacaoEvento(this, this.checkImprimir.isSelected()));
        }
    }

    public void redimensionar(List<Component> comps, boolean ignorarMargens) {
        if (!ignorarMargens) {
            ScreenUtil.setMargem(comps, 5, 10);
        }
        Dimension tam = ScreenUtil.getAreaOcupada(comps);
        tam = new Dimension(tam.width + 5, tam.height + 5);
        this.panelArea.setPreferredSize(tam);
        this.panelArea.setSize(tam);
    }

    public void redimensionar(List<Component> comps, boolean ignorarMargens, double zoom) {
        if (!ignorarMargens) {
            ScreenUtil.setMargem(comps, 5, 10);
        }
        this.tratarDimensoes(comps, zoom);
        Dimension tam = ScreenUtil.getAreaOcupada(comps);
        tam = new Dimension(tam.width + 5, tam.height + 5);
        this.panelArea.setPreferredSize(tam);
        this.panelArea.setSize(tam);
    }

    public void atualizarCamposOutrosExames(Map<String, Object> campos) {
        if (campos != null) {
            this.resultado.atualizarCamposExamesExternos(campos);
        }
    }

    public void adicionaListenerTabelaSimbolos(TabelaSimbolosListener l) {
        if (l != null) {
            this.resultado.adicionaListenerTabelaSimbolos(l);
        }
    }

    public void setCodigoExame(String codigoExame) {
        this.codigoExame = codigoExame;
    }

    public void setSituacao(String situacao) {
        this.situacao = situacao;
    }

    public String getSituacao() {
        return this.situacao;
    }

    public void setCodigoMaterialColeta(Integer codigoMaterialColeta) {
        this.codigoMaterialColeta = codigoMaterialColeta;
    }

    public void setOrdem(int ordem) {
        this.ordem = ordem;
    }

    public String getCodigoExame() {
        return this.codigoExame;
    }

    public Integer getCodigoMaterialColeta() {
        return this.codigoMaterialColeta;
    }

    public Integer getOrdem() {
        return this.ordem;
    }

    public boolean isEditando() {
        return this.isEditando;
    }

    public void setEditando(boolean isEditando) {
        this.isEditando = isEditando;
    }

    @Override
    public void absurdoDisparado() {
        this.absurdoDisparado = true;
    }

    @Override
    public void absurdoOcultado() {
        this.absurdoDisparado = false;
    }

    @Override
    @Deprecated
    public void componenteSelecionado(CampoDigitacao campoDigitacao) {
    }

    public void setDadosExame(Map<String, Object> dadosExameRequisicao) {
        this.dadosExame = dadosExameRequisicao;
    }

    public JPanel getPanelArea() {
        return this.panelArea;
    }

    public void alterarZoom(double zoom) {
        Resultado resultadoAux = new Resultado(this, this.atributos, this.dados, this.externos, this.historicos, this.historicosPorMnemonico, this.resAnterior, this.componentesFoco, this.edicao, this.ordemAnteriores, true, this.resultadoAtual);
        this.compsAux = resultadoAux.getComponentes();
        this.redimensionar(this.resultado.getComponentes(), false, zoom);
        this.panelArea.removeAll();
        for (Component comp : this.resultado.getComponentes()) {
            String versaoXML;
            this.panelArea.add(comp);
            comp.addMouseMotionListener(this.mouseMotionListener);
            if (comp instanceof CampoDigitacao) {
                ((CampoDigitacao)comp).addListenerAbsurdo(this);
                if (this.tabbedPaneExame != null) {
                    ((CampoDigitacao)comp).addListenerAbsurdo(this.tabbedPaneExame);
                }
            }
            if (comp instanceof TextoEstatico && (((TextoEstatico)comp).getDono() instanceof Historico || ((TextoEstatico)comp).getDono() instanceof HistoricoDigitacao) && !Funcoes.textoVazio(versaoXML = StringUtil.getValor(this.atributos, "versao")) && (versaoXML.equalsIgnoreCase("1.0") || versaoXML.equalsIgnoreCase("2.0"))) {
                ((TextoEstatico)comp).setHorizontalAlignment(2);
            }
            if (comp instanceof Rotulo) {
                ((Rotulo)comp).setAlinhamentoHorizontal(2);
            }
            if (!(comp instanceof ImagemDigitacao)) continue;
            for (ImagemDigitacaoListener l : this.listenerImagemDigitacao) {
                ((ImagemDigitacao)comp).addImagemDigitacaoListener(l);
            }
        }
        this.revalidate();
    }

    private void tratarDimensoes(List<Component> comps, double zoom) {
        Graphics2D graphics = new BufferedImage(10, 10, 1).createGraphics();
        for (int i = 0; i < comps.size(); ++i) {
            JComponent imagem;
            JComponent qrCode;
            JComponent campo;
            int width;
            FontMetrics fm;
            JComponent text;
            Component comp = comps.get(i);
            comp.setBounds(this.compsAux.get(i).getBounds());
            comp.setFont(this.compsAux.get(i).getFont());
            Rectangle rec = this.compsAux.get(i).getBounds();
            if (comp instanceof TextoEstatico) {
                text = (TextoEstatico)comp;
                text.setFont(this.redimensionarFonte(text.getFont(), zoom));
                fm = graphics.getFontMetrics(text.getFont());
                width = fm.stringWidth(((JLabel)text).getText());
                rec.width = this.retornaTamanho(this.compsAux.get((int)i).getBounds().width, zoom);
                rec.height = this.retornaTamanho(this.compsAux.get((int)i).getBounds().height, zoom);
                rec.y = this.retornaTamanho(this.compsAux.get((int)i).getBounds().y, zoom);
                rec.x = this.retornaTamanho(this.compsAux.get((int)i).getBounds().x, zoom);
                ((TextoEstatico)text).setDimensoes(rec);
            } else if (comp instanceof CampoDigitacao) {
                text = (CampoDigitacao)comp;
                ((JTextField)text).setFont(this.redimensionarFonte(text.getFont(), zoom));
                fm = graphics.getFontMetrics(text.getFont());
                width = fm.stringWidth(((JTextComponent)text).getText());
                rec.width = this.retornaTamanho(this.compsAux.get((int)i).getBounds().width, zoom);
                rec.height = this.retornaTamanho(this.compsAux.get((int)i).getBounds().height, zoom);
                rec.y = this.retornaTamanho(this.compsAux.get((int)i).getBounds().y, zoom);
                rec.x = this.retornaTamanho(this.compsAux.get((int)i).getBounds().x, zoom);
                ((CampoDigitacao)text).setDimensoes(rec);
            } else if (comp instanceof ExpressaoDigitacao) {
                text = (ExpressaoDigitacao)comp;
                text.setFont(this.redimensionarFonte(text.getFont(), zoom));
                rec.width = this.retornaTamanho(this.compsAux.get((int)i).getBounds().width, zoom);
                rec.height = this.retornaTamanho(this.compsAux.get((int)i).getBounds().height, zoom);
                rec.y = this.retornaTamanho(this.compsAux.get((int)i).getBounds().y, zoom);
                rec.x = this.retornaTamanho(this.compsAux.get((int)i).getBounds().x, zoom);
                ((ExpressaoDigitacao)text).setDimensoes(rec);
            } else if (comp instanceof Expressao) {
                text = (Expressao)comp;
                text.setFont(this.redimensionarFonte(text.getFont(), zoom));
                rec.width = this.retornaTamanho(this.compsAux.get((int)i).getBounds().width, zoom);
                rec.height = this.retornaTamanho(this.compsAux.get((int)i).getBounds().height, zoom);
                rec.y = this.retornaTamanho(this.compsAux.get((int)i).getBounds().y, zoom);
                rec.x = this.retornaTamanho(this.compsAux.get((int)i).getBounds().x, zoom);
                ((AbstractComponente)text).setDimensoes(rec);
            } else if (comp instanceof TextoDigitacao) {
                text = (TextoDigitacao)comp;
                text.setFont(this.redimensionarFonte(text.getFont(), zoom));
                rec.width = this.retornaTamanho(this.compsAux.get((int)i).getBounds().width, zoom);
                rec.height = this.retornaTamanho(this.compsAux.get((int)i).getBounds().height, zoom);
                rec.y = this.retornaTamanho(this.compsAux.get((int)i).getBounds().y, zoom);
                rec.x = this.retornaTamanho(this.compsAux.get((int)i).getBounds().x, zoom);
                ((TextoDigitacao)text).setDimensoes(rec);
            } else if (comp instanceof ResultadoAnteriorDigitacao) {
                text = (ResultadoAnteriorDigitacao)comp;
                ((JTextField)text).setFont(this.redimensionarFonte(text.getFont(), zoom));
                rec.width = this.retornaTamanho(this.compsAux.get((int)i).getBounds().width, zoom);
                rec.height = this.retornaTamanho(this.compsAux.get((int)i).getBounds().height, zoom);
                rec.y = this.retornaTamanho(this.compsAux.get((int)i).getBounds().y, zoom);
                rec.x = this.retornaTamanho(this.compsAux.get((int)i).getBounds().x, zoom);
                ((ResultadoAnteriorDigitacao)text).setDimensoes(rec);
            } else if (comp instanceof HistoricoDigitacao) {
                HistoricoDigitacao his = (HistoricoDigitacao)comp;
                his.setFont(this.redimensionarFonte(his.getFont(), zoom));
                rec.width = this.retornaTamanho(this.compsAux.get((int)i).getBounds().width, zoom);
                rec.height = this.retornaTamanho(this.compsAux.get((int)i).getBounds().height, zoom);
                rec.y = this.retornaTamanho(this.compsAux.get((int)i).getBounds().y, zoom);
                rec.x = this.retornaTamanho(this.compsAux.get((int)i).getBounds().x, zoom);
                his.setDimensoes(rec);
            } else if (comp instanceof CampoListaDigitacao) {
                CampoListaDigitacao campoLista = (CampoListaDigitacao)comp;
                campoLista.setFont(this.redimensionarFonte(campoLista.getFont(), zoom));
                rec.width = this.retornaTamanho(this.compsAux.get((int)i).getBounds().width, zoom);
                rec.height = this.retornaTamanho(this.compsAux.get((int)i).getBounds().height, zoom);
                rec.y = this.retornaTamanho(this.compsAux.get((int)i).getBounds().y, zoom);
                rec.x = this.retornaTamanho(this.compsAux.get((int)i).getBounds().x, zoom);
                campoLista.setDimensoes(rec);
            } else if (comp instanceof FormaImpressao) {
                campo = (FormaImpressao)comp;
                campo.setFont(this.redimensionarFonte(campo.getFont(), zoom));
                rec.width = this.retornaTamanho(this.compsAux.get((int)i).getBounds().width, zoom);
                rec.height = this.retornaTamanho(this.compsAux.get((int)i).getBounds().height, zoom);
                rec.y = this.retornaTamanho(this.compsAux.get((int)i).getBounds().y, zoom);
                rec.x = this.retornaTamanho(this.compsAux.get((int)i).getBounds().x, zoom);
                ((FormaImpressao)campo).setDimensoes(rec);
            } else if (comp instanceof CodigoQRCodeImpressao) {
                qrCode = (CodigoQRCodeImpressao)comp;
                qrCode.setFont(this.redimensionarFonte(qrCode.getFont(), zoom));
                rec.width = this.retornaTamanho(this.compsAux.get((int)i).getBounds().width, zoom);
                rec.height = this.retornaTamanho(this.compsAux.get((int)i).getBounds().height, zoom);
                rec.y = this.retornaTamanho(this.compsAux.get((int)i).getBounds().y, zoom);
                rec.x = this.retornaTamanho(this.compsAux.get((int)i).getBounds().x, zoom);
                ((CodigoQRCodeImpressao)qrCode).setDimensoes(rec);
            } else if (comp instanceof Campo) {
                campo = (Campo)comp;
                campo.setFont(this.redimensionarFonte(campo.getFont(), zoom));
                rec.width = this.retornaTamanho(this.compsAux.get((int)i).getBounds().width, zoom);
                rec.height = this.retornaTamanho(this.compsAux.get((int)i).getBounds().height, zoom);
                rec.y = this.retornaTamanho(this.compsAux.get((int)i).getBounds().y, zoom);
                rec.x = this.retornaTamanho(this.compsAux.get((int)i).getBounds().x, zoom);
                ((AbstractComponente)campo).setDimensoes(rec);
            } else if (comp instanceof Rotulo) {
                Rotulo rotulo = (Rotulo)comp;
                rotulo.setFont(this.redimensionarFonte(rotulo.getFont(), zoom));
                rec.width = this.retornaTamanho(rotulo.getBounds().width, zoom);
                rec.height = this.retornaTamanho(rotulo.getBounds().height, zoom);
                rec.y = this.retornaTamanho(rotulo.getBounds().y, zoom);
                rec.x = this.retornaTamanho(rotulo.getBounds().x, zoom);
                rotulo.setDimensoes(rec);
            } else if (comp instanceof ImagemDigitacao) {
                imagem = (ImagemDigitacao)comp;
                rec.y = this.retornaTamanho(imagem.getBounds().y, zoom);
                rec.x = this.retornaTamanho(imagem.getBounds().x, zoom);
                ((ImagemDigitacao)imagem).setDimensoes(rec);
            } else if (comp instanceof GraficoConfiguravelDigitacao) {
                GraficoConfiguravelDigitacao graficoConfiguravel = (GraficoConfiguravelDigitacao)comp;
                rec.y = this.retornaTamanho(graficoConfiguravel.getBounds().y, zoom);
                rec.x = this.retornaTamanho(graficoConfiguravel.getBounds().x, zoom);
                graficoConfiguravel.setDimensoes(rec);
            } else if (comp instanceof GraficoQuadranteDigitacao) {
                GraficoQuadranteDigitacao graficoQuadranteDigitacao = (GraficoQuadranteDigitacao)comp;
                rec.y = this.retornaTamanho(graficoQuadranteDigitacao.getBounds().y, zoom);
                rec.x = this.retornaTamanho(graficoQuadranteDigitacao.getBounds().x, zoom);
                graficoQuadranteDigitacao.setDimensoes(rec);
            } else if (comp instanceof GraficoResultadoAnteriorDigitacao) {
                GraficoResultadoAnteriorDigitacao graficoResultadoAnteriorDigitacao = (GraficoResultadoAnteriorDigitacao)comp;
                rec.y = this.retornaTamanho(graficoResultadoAnteriorDigitacao.getBounds().y, zoom);
                rec.x = this.retornaTamanho(graficoResultadoAnteriorDigitacao.getBounds().x, zoom);
                graficoResultadoAnteriorDigitacao.setDimensoes(rec);
            } else if (comp instanceof GraficoReferenciaDigitacao) {
                GraficoReferenciaDigitacao graficoReferenciaDigitacao = (GraficoReferenciaDigitacao)comp;
                rec.y = this.retornaTamanho(graficoReferenciaDigitacao.getBounds().y, zoom);
                rec.x = this.retornaTamanho(graficoReferenciaDigitacao.getBounds().x, zoom);
                graficoReferenciaDigitacao.setDimensoes(rec);
            } else if (comp instanceof Grafico) {
                Grafico grafico = (Grafico)comp;
                rec.y = this.retornaTamanho(grafico.getBounds().y, zoom);
                rec.x = this.retornaTamanho(grafico.getBounds().x, zoom);
                grafico.setDimensoes(rec);
            } else if (comp instanceof GraficoImpressao) {
                GraficoImpressao graficoImpressao = (GraficoImpressao)comp;
                rec.y = this.retornaTamanho(graficoImpressao.getBounds().y, zoom);
                rec.x = this.retornaTamanho(graficoImpressao.getBounds().x, zoom);
                graficoImpressao.setDimensoes(rec);
            } else if (comp instanceof ResultadoAnterior) {
                ResultadoAnterior resultadoAnterior = (ResultadoAnterior)comp;
                rec.y = this.retornaTamanho(resultadoAnterior.getBounds().y, zoom);
                rec.x = this.retornaTamanho(resultadoAnterior.getBounds().x, zoom);
                resultadoAnterior.setDimensoes(rec);
            } else if (comp instanceof ReguaReferencialDigitacao) {
                ReguaReferencialDigitacao reguaDigitacao = (ReguaReferencialDigitacao)comp;
                rec.width = this.retornaTamanho(reguaDigitacao.getBounds().width, zoom);
                rec.height = this.retornaTamanho(reguaDigitacao.getBounds().height, zoom);
                rec.y = this.retornaTamanho(reguaDigitacao.getBounds().y, zoom);
                rec.x = this.retornaTamanho(reguaDigitacao.getBounds().x, zoom);
                reguaDigitacao.setDimensoes(rec);
            } else if (comp instanceof ReguaReferencial) {
                ReguaReferencial reguaReferencial = (ReguaReferencial)comp;
                rec.width = this.retornaTamanho(reguaReferencial.getBounds().width, zoom);
                rec.height = this.retornaTamanho(reguaReferencial.getBounds().height, zoom);
                rec.y = this.retornaTamanho(reguaReferencial.getBounds().y, zoom);
                rec.x = this.retornaTamanho(reguaReferencial.getBounds().x, zoom);
                reguaReferencial.setDimensoes(rec);
            } else if (comp instanceof ReguaReferencialImpressao) {
                ReguaReferencialImpressao reguaReferencialImpressao = (ReguaReferencialImpressao)comp;
                rec.width = this.retornaTamanho(reguaReferencialImpressao.getBounds().width, zoom);
                rec.height = this.retornaTamanho(reguaReferencialImpressao.getBounds().height, zoom);
                rec.y = this.retornaTamanho(reguaReferencialImpressao.getBounds().y, zoom);
                rec.x = this.retornaTamanho(reguaReferencialImpressao.getBounds().x, zoom);
                reguaReferencialImpressao.setDimensoes(rec);
            } else if (comp instanceof Imagem) {
                imagem = (Imagem)comp;
                rec.y = this.retornaTamanho(imagem.getBounds().y, zoom);
                rec.x = this.retornaTamanho(imagem.getBounds().x, zoom);
                ((AbstractComponente)imagem).setDimensoes(rec);
            } else if (comp instanceof ImagemImpressao) {
                imagem = (ImagemImpressao)comp;
                rec.y = this.retornaTamanho(imagem.getBounds().y, zoom);
                rec.x = this.retornaTamanho(imagem.getBounds().x, zoom);
                ((ImagemImpressao)imagem).setDimensoes(rec);
            } else if (comp instanceof Forma) {
                Forma forma = (Forma)comp;
                rec.y = this.retornaTamanho(forma.getBounds().y, zoom);
                rec.x = this.retornaTamanho(forma.getBounds().x, zoom);
                forma.setDimensoes(rec);
            } else if (comp instanceof CodigoQRCode) {
                qrCode = (CodigoQRCode)comp;
                rec.y = this.retornaTamanho(qrCode.getBounds().y, zoom);
                rec.x = this.retornaTamanho(qrCode.getBounds().x, zoom);
                ((AbstractComponente)qrCode).setDimensoes(rec);
            } else if (comp instanceof DadosDigitacao) {
                DadosDigitacao dadosDigitacao = (DadosDigitacao)comp;
                dadosDigitacao.setFont(this.redimensionarFonte(dadosDigitacao.getFont(), zoom));
                rec.width = this.retornaTamanho(dadosDigitacao.getBounds().width, zoom);
                rec.height = this.retornaTamanho(dadosDigitacao.getBounds().height, zoom);
                rec.y = this.retornaTamanho(dadosDigitacao.getBounds().y, zoom);
                rec.x = this.retornaTamanho(dadosDigitacao.getBounds().x, zoom);
                dadosDigitacao.setDimensoes(rec);
            } else if (comp instanceof ExternoDigitacao) {
                ExternoDigitacao externoDigitacao = (ExternoDigitacao)comp;
                externoDigitacao.setFont(this.redimensionarFonte(externoDigitacao.getFont(), zoom));
                rec.width = this.retornaTamanho(externoDigitacao.getBounds().width, zoom);
                rec.height = this.retornaTamanho(externoDigitacao.getBounds().height, zoom);
                rec.y = this.retornaTamanho(externoDigitacao.getBounds().y, zoom);
                rec.x = this.retornaTamanho(externoDigitacao.getBounds().x, zoom);
                externoDigitacao.setDimensoes(rec);
            }
            comp.setBounds(rec);
        }
    }

    private int retornaTamanho(int i, double zoom) {
        BigDecimal calculo = new BigDecimal(String.valueOf(i)).multiply(new BigDecimal(String.valueOf(zoom))).setScale(0, RoundingMode.UP);
        return calculo.intValue();
    }

    private Font redimensionarFonte(Font fonte, double zoom) {
        int valor = fonte.getSize();
        if (this.zoomAplicado(zoom)) {
            valor = (int)((double)fonte.getSize() * zoom) - 1;
        }
        return new Font(fonte.getName(), fonte.getStyle(), valor);
    }

    private boolean zoomAplicado(double zoom) {
        return zoom > 1.0;
    }

    public ArrayList<ImagemDigitacao> getImagensPorOrdem() {
        this.imagens.sort(new Comparator<ImagemDigitacao>(){

            @Override
            public int compare(ImagemDigitacao o1, ImagemDigitacao o2) {
                return o1 == null || o2 == null ? 0 : new Integer(o1.getOrdem()).compareTo(new Integer(o2.getOrdem()));
            }
        });
        return this.imagens;
    }

    public void atribuirImagem(String campo, ImageIcon image) {
        for (ImagemDigitacao img : this.imagens) {
            if (!img.getNome().equals(campo) || img.getImagem() != null && !img.getImagem().isEmpty()) continue;
            img.setImagem(image);
            img.repaint();
        }
    }

    public static enum TipoOrigemDigitacao {
        DIGITACAO(0),
        CONFERENCIA(1),
        OUTROS(2);

        private int tipo = -1;

        private TipoOrigemDigitacao(int tipo) {
            this.tipo = tipo;
        }
    }
}

