/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.consultas.triagem.Soroteca;

import jalis.comum.Conexao;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.triagem.soroteca.jtabuleiro.JTabuleiro;
import jalis.laboratorio.triagem.soroteca.util.Tubo;
import jalis.laboratorio.triagem.soroteca.util.TuboContainer;
import jalis.laboratorio.triagem.soroteca.util.TuboContainerJList;
import jalis.laboratorio.triagem.soroteca.util.TuboContainerJTabuleiro;
import jalis.laboratorio.triagem.soroteca.util.TuboDao;
import jalis.model.bean.cadastro.triagem.EstanteBean;
import jalis.model.vo.cadastro.PacienteVO;
import jalis.model.vo.cadastro.triagem.GeladeiraVO;
import jalis.service.cadastro.PacienteService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ConsultaSoroteca
extends FrmCadPadrao {
    private final JButton buttonPaciente = new JButton();
    private final JButton buttonRequisicao = new JButton();
    private final JButton buttonFiltrar = new JButton("Filtrar");
    private final JButton buttonBuscarFilialPaciente = new JButton();
    private final JButton buttonBuscarFilialRequisicao = new JButton();
    private JTable tableEtiquetas = null;
    private ModeloGridTable modelEtiquetas = null;
    private JScrollPane scrollEtiquetas = null;
    private final JLabel labelNomePaciente = new JLabel();
    private final JLabel labelPaciente = new JLabel();
    private final JLabel labelRequisicao = new JLabel();
    private final JLabel labelEtiqueta = new JLabel();
    private final JLabel labelFilialRequisicao = new JLabel();
    private final JLabel labelFilialPaciente = new JLabel();
    private final SorotecaBasica panelSoroteca = new SorotecaBasica();
    private JSplitPane splitSoroteca = null;
    private final TTextField textPaciente = new TTextField(10, 1);
    private final TTextField textRequisicao = new TTextField(12, 1);
    private final TTextField textEtiqueta = new TTextField(12, 1);
    private final TTextField textFilialRequisicao = new TTextField(5, 1);
    private final TTextField textFilialPaciente = new TTextField(5, 1);
    private final JPanel panelLegenda = new JPanel();
    PacienteVO pacienteAux = null;
    boolean requisicaoSelecionada = false;

    public ConsultaSoroteca() {
        this.setLabelFormulario("Soroteca");
        this.setLabelDescricao("Consulta de armazenamento de tubos");
        this.setIcone(ImagemUtils.carregaImagemJalis("consultas/soroteca.jpg"));
        ScreenUtil.setBorda(new JLabel[]{this.labelNomePaciente}, new TitledBorder(""));
        this.botaoCancelar.setVisible(false);
        this.botaoEditar.setVisible(false);
        this.botaoSalvar.setVisible(false);
        this.botaoExcluir.setVisible(false);
        this.painelCentral.setLayout(new GridBagLayout());
        this.labelRequisicao.setText("Requisi\u00e7\u00e3o:");
        this.labelRequisicao.setDisplayedMnemonic('R');
        this.labelRequisicao.setLabelFor(this.textRequisicao);
        this.labelPaciente.setText("Paciente:");
        this.labelPaciente.setDisplayedMnemonic('P');
        this.labelPaciente.setLabelFor(this.textPaciente);
        this.labelEtiqueta.setText("Etiqueta:");
        this.labelEtiqueta.setDisplayedMnemonic('E');
        this.labelEtiqueta.setLabelFor(this.textEtiqueta);
        this.labelFilialRequisicao.setText("Filial:");
        this.labelFilialPaciente.setText("Filial:");
        Dimension d = new Dimension(50, 20);
        this.textFilialRequisicao.setPreferredSize(d);
        this.textFilialRequisicao.setMinimumSize(d);
        this.textFilialRequisicao.setMaximumSize(d);
        this.textFilialRequisicao.setText(Variaveis.filialPadrao);
        this.textFilialRequisicao.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ConsultaSoroteca.this.buttonBuscarFilialRequisicao.doClick();
                }
            }
        });
        this.textFilialPaciente.setPreferredSize(d);
        this.textFilialPaciente.setMinimumSize(d);
        this.textFilialPaciente.setMaximumSize(d);
        this.textFilialPaciente.setText(Variaveis.filialPadrao);
        this.textFilialPaciente.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ConsultaSoroteca.this.buttonBuscarFilialPaciente.doClick();
                }
            }
        });
        d = new Dimension(20, 20);
        this.buttonBuscarFilialRequisicao.setPreferredSize(d);
        this.buttonBuscarFilialRequisicao.setMinimumSize(d);
        this.buttonBuscarFilialRequisicao.setMaximumSize(d);
        this.buttonBuscarFilialRequisicao.setFocusable(false);
        this.buttonBuscarFilialRequisicao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Hashtable resultado = Pesquisas.filial(ConsultaSoroteca.this.getTopLevelAncestor(), false);
                if (resultado != null) {
                    ConsultaSoroteca.this.textFilialRequisicao.setText(resultado.get("fil_codigo").toString());
                }
                ScreenUtil.requisitarFoco(ConsultaSoroteca.this.textFilialRequisicao);
            }
        });
        this.buttonBuscarFilialPaciente.setPreferredSize(d);
        this.buttonBuscarFilialPaciente.setMinimumSize(d);
        this.buttonBuscarFilialPaciente.setMaximumSize(d);
        this.buttonBuscarFilialPaciente.setFocusable(false);
        this.buttonBuscarFilialPaciente.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Hashtable resultado = Pesquisas.filial(ConsultaSoroteca.this.getTopLevelAncestor(), false);
                if (resultado != null) {
                    ConsultaSoroteca.this.textFilialPaciente.setText(resultado.get("fil_codigo").toString());
                }
                ScreenUtil.requisitarFoco(ConsultaSoroteca.this.textFilialPaciente);
            }
        });
        Funcoes.imagemPesquisa(this.buttonBuscarFilialRequisicao);
        Funcoes.imagemPesquisa(this.buttonBuscarFilialPaciente);
        d = new Dimension(100, 20);
        this.buttonPaciente.setFocusable(false);
        d = new Dimension(20, 20);
        this.buttonPaciente.setMinimumSize(d);
        this.buttonPaciente.setPreferredSize(d);
        Funcoes.imagemPesquisa(this.buttonPaciente);
        this.buttonPaciente.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Funcoes.textoVazio(ConsultaSoroteca.this.textFilialPaciente)) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "Selecione a filial do paciente.", 2);
                    ConsultaSoroteca.this.textFilialPaciente.grabFocus();
                    return;
                }
                PacienteVO paciente = new PacienteVO();
                paciente = (PacienteVO)new PacienteService().pesquisaVO(Laboratorio.getInstancia(), paciente, "Pesquisando Pacientes", false, ConsultaSoroteca.this.textFilialPaciente.getText());
                if (paciente != null) {
                    ConsultaSoroteca.this.pacienteAux = paciente;
                    ConsultaSoroteca.this.textPaciente.setText(paciente.getCodigo().toString());
                    ConsultaSoroteca.this.labelNomePaciente.setText(paciente.getNome());
                    if (ConsultaSoroteca.this.textPaciente.isEnabled() && ConsultaSoroteca.this.textPaciente.isFocusable()) {
                        ScreenUtil.requisitarFoco(ConsultaSoroteca.this.buttonFiltrar);
                    }
                }
                ConsultaSoroteca.this.controlarCampos();
            }
        });
        this.buttonRequisicao.setFocusable(false);
        this.buttonRequisicao.setMinimumSize(d);
        this.buttonRequisicao.setPreferredSize(d);
        Funcoes.imagemPesquisa(this.buttonRequisicao);
        this.buttonRequisicao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Hashtable hash = Pesquisas.requisicao(Laboratorio.getInstancia(), Funcoes.textoVazio(ConsultaSoroteca.this.textFilialRequisicao) ? Variaveis.filialPadrao : ConsultaSoroteca.this.textFilialRequisicao.getText(), false, false, false);
                if (hash != null) {
                    ConsultaSoroteca.this.requisicaoSelecionada = true;
                    ConsultaSoroteca.this.textRequisicao.setText(hash.get("req_codigo").toString());
                    try {
                        String sql = "select fil_codigo, pac_codigo from requisicao where fil_codigo = " + (Funcoes.textoVazio(ConsultaSoroteca.this.textFilialRequisicao) ? Variaveis.filialPadrao : ConsultaSoroteca.this.textFilialRequisicao.getText()) + " and req_codigo = " + hash.get("req_codigo");
                        Statement st = Conexao.getStatement();
                        ResultSet rs = Conexao.executeQuery(st, sql);
                        if (rs.next()) {
                            String pac_codigo = rs.getString("pac_codigo");
                            String fil_codigo = rs.getString("fil_codigo");
                            ConsultaSoroteca.this.pacienteAux = (PacienteVO)new PacienteService().getVO(fil_codigo, pac_codigo);
                        }
                    }
                    catch (Exception e1) {
                        ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel carregar dados do paciente da requisi\u00e7\u00e3o.\n" + e1.getMessage(), e1.getStackTrace());
                    }
                    if (ConsultaSoroteca.this.pacienteAux != null) {
                        ConsultaSoroteca.this.textFilialPaciente.setText(ConsultaSoroteca.this.pacienteAux.getFilial().getCodigo().toString());
                        ConsultaSoroteca.this.textPaciente.setText(ConsultaSoroteca.this.pacienteAux.getCodigo().toString());
                        ConsultaSoroteca.this.labelNomePaciente.setText(ConsultaSoroteca.this.pacienteAux.getNome());
                    }
                }
                ConsultaSoroteca.this.controlarCampos();
                ScreenUtil.requisitarFoco(ConsultaSoroteca.this.buttonFiltrar);
            }
        });
        this.labelNomePaciente.setMinimumSize(d);
        this.labelNomePaciente.setPreferredSize(d);
        d = new Dimension(100, 20);
        this.textRequisicao.setMinimumSize(d);
        this.textRequisicao.setPreferredSize(d);
        this.textRequisicao.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ConsultaSoroteca.this.buttonRequisicao.doClick();
                }
            }
        });
        this.textRequisicao.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                if (Funcoes.textoVazio(ConsultaSoroteca.this.textRequisicao.getText())) {
                    if (ConsultaSoroteca.this.requisicaoSelecionada) {
                        ConsultaSoroteca.this.requisicaoSelecionada = false;
                        ConsultaSoroteca.this.textPaciente.setText("");
                        ConsultaSoroteca.this.labelNomePaciente.setText("");
                        ConsultaSoroteca.this.pacienteAux = null;
                    }
                } else if (ConsultaSoroteca.this.processarNumeroTubo()) {
                    Integer codigoFilial = Integer.parseInt(Funcoes.textoVazio(ConsultaSoroteca.this.textFilialRequisicao.getText()) ? Variaveis.filialPadrao : ConsultaSoroteca.this.textFilialRequisicao.getText());
                    Integer codigoRequisicao = Integer.parseInt(Funcoes.textoVazio(ConsultaSoroteca.this.textRequisicao.getText()) ? Variaveis.filialPadrao : ConsultaSoroteca.this.textRequisicao.getText());
                    ConsultaSoroteca.this.buscaDadosPacienteRequisicao(codigoFilial, codigoRequisicao);
                    ConsultaSoroteca.this.requisicaoSelecionada = true;
                }
                ConsultaSoroteca.this.controlarCampos();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.textRequisicao.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (Funcoes.textoVazio(ConsultaSoroteca.this.textRequisicao)) {
                    ConsultaSoroteca.this.textEtiqueta.setEnabled(true);
                    ConsultaSoroteca.this.textPaciente.setEnabled(true);
                    ConsultaSoroteca.this.buttonPaciente.setEnabled(true);
                } else {
                    ConsultaSoroteca.this.textEtiqueta.setEnabled(false);
                    ConsultaSoroteca.this.textPaciente.setEnabled(false);
                    ConsultaSoroteca.this.buttonPaciente.setEnabled(false);
                }
            }
        });
        this.textPaciente.setMinimumSize(d);
        this.textPaciente.setPreferredSize(d);
        this.textPaciente.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ConsultaSoroteca.this.buttonPaciente.doClick();
                    ConsultaSoroteca.this.controlarCampos();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (Funcoes.textoVazio(ConsultaSoroteca.this.textPaciente)) {
                    ConsultaSoroteca.this.textEtiqueta.setEnabled(true);
                    ConsultaSoroteca.this.textRequisicao.setEnabled(true);
                    ConsultaSoroteca.this.buttonRequisicao.setEnabled(true);
                } else {
                    ConsultaSoroteca.this.textEtiqueta.setEnabled(false);
                    ConsultaSoroteca.this.textRequisicao.setEnabled(false);
                    ConsultaSoroteca.this.buttonRequisicao.setEnabled(false);
                }
            }
        });
        this.textPaciente.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                block7: {
                    if (Funcoes.textoVazio(ConsultaSoroteca.this.textPaciente.getText())) {
                        ConsultaSoroteca.this.pacienteAux = null;
                        ConsultaSoroteca.this.labelNomePaciente.setText("");
                        ConsultaSoroteca.this.controlarCampos();
                    } else {
                        try {
                            ConsultaSoroteca.this.pacienteAux = (PacienteVO)new PacienteService().getVO(Funcoes.textoVazio(ConsultaSoroteca.this.textFilialPaciente) ? Variaveis.filialPadrao : ConsultaSoroteca.this.textFilialPaciente.getText(), ConsultaSoroteca.this.textPaciente.getText());
                            if (ConsultaSoroteca.this.pacienteAux != null) {
                                ConsultaSoroteca.this.labelNomePaciente.setText(ConsultaSoroteca.this.pacienteAux.getNome());
                                ScreenUtil.requisitarFoco(ConsultaSoroteca.this.buttonFiltrar);
                                ConsultaSoroteca.this.controlarCampos();
                            } else {
                                ConsultaSoroteca.this.labelNomePaciente.setText("N\u00e3o cadastrado");
                                if (ConsultaSoroteca.this.textPaciente.isEnabled() && ConsultaSoroteca.this.textPaciente.isFocusable()) {
                                    ConsultaSoroteca.this.textPaciente.selectAll();
                                    ScreenUtil.requisitarFoco(ConsultaSoroteca.this.textPaciente);
                                }
                            }
                        }
                        catch (Exception e1) {
                            Funcoes.mensagem(ConsultaSoroteca.this, "Paciente n\u00e3o localizado.", 2);
                            ConsultaSoroteca.this.labelNomePaciente.setText("N\u00e3o cadastrado");
                            if (!ConsultaSoroteca.this.textPaciente.isEnabled() || !ConsultaSoroteca.this.textPaciente.isFocusable()) break block7;
                            ScreenUtil.requisitarFoco(ConsultaSoroteca.this.textPaciente);
                        }
                    }
                }
                ConsultaSoroteca.this.controlarCampos();
            }

            @Override
            @Deprecated
            public void focusGained(FocusEvent e) {
            }
        });
        d = new Dimension(130, 20);
        this.textEtiqueta.setMinimumSize(d);
        this.textEtiqueta.setPreferredSize(d);
        this.textEtiqueta.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!Funcoes.textoVazio(ConsultaSoroteca.this.textEtiqueta.getText()) && e.getOppositeComponent() == ConsultaSoroteca.this.textFilialRequisicao) {
                    ConsultaSoroteca.this.buscaDadosEtiqueta(ConsultaSoroteca.this.textEtiqueta.getText());
                }
            }

            @Override
            @Deprecated
            public void focusGained(FocusEvent e) {
            }
        });
        this.modelEtiquetas = new ModeloGridTable(new String[]{"Etiqueta", "Data Req.", "Objeto"}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                Object[] classes = new Object[]{String.class, Date.class, Tubo.class};
                return (Class)classes[columnIndex];
            }

            @Override
            public void fireTableStructureChanged() {
                super.fireTableStructureChanged();
                try {
                    if (ConsultaSoroteca.this.tableEtiquetas != null) {
                        ConsultaSoroteca.this.tableEtiquetas.removeColumn(ConsultaSoroteca.this.tableEtiquetas.getColumn("Objeto"));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                try {
                    ConsultaSoroteca.this.tableEtiquetas.removeColumn(ConsultaSoroteca.this.tableEtiquetas.getColumn("Objeto"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        };
        this.tableEtiquetas = new JTable(this.modelEtiquetas);
        this.tableEtiquetas.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                if (ConsultaSoroteca.this.tableEtiquetas.getSelectedRow() >= 0) {
                    ArrayList<Tubo> listaTubos = new ArrayList<Tubo>();
                    for (int i = 0; i < ConsultaSoroteca.this.modelEtiquetas.getRowCount(); ++i) {
                        listaTubos.add((Tubo)ConsultaSoroteca.this.modelEtiquetas.getValueAt(i, ConsultaSoroteca.this.modelEtiquetas.findColumn("Objeto")));
                    }
                    ConsultaSoroteca.this.panelSoroteca.setTubo((Tubo)ConsultaSoroteca.this.modelEtiquetas.getValueAt(ConsultaSoroteca.this.tableEtiquetas.getSelectedRow(), ConsultaSoroteca.this.modelEtiquetas.findColumn("Objeto")), listaTubos);
                }
            }
        });
        this.tableEtiquetas.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        d = new Dimension(80, 20);
        this.buttonFiltrar.setMinimumSize(d);
        d = new Dimension(80, 20);
        this.buttonFiltrar.setPreferredSize(d);
        this.buttonFiltrar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsultaSoroteca.this.panelSoroteca.limpar();
                SplashMensagem msg = new SplashMensagem();
                msg.mostrar("Aguarde, buscando tubos...");
                if (!Funcoes.textoVazio(ConsultaSoroteca.this.textEtiqueta)) {
                    ConsultaSoroteca.this.carregaTubos(ConsultaSoroteca.this.textEtiqueta.getText());
                } else if (ConsultaSoroteca.this.requisicaoSelecionada) {
                    ConsultaSoroteca.this.carregaTubosRequisicao(Integer.parseInt(Funcoes.textoVazio(ConsultaSoroteca.this.textFilialRequisicao) ? Variaveis.filialPadrao : ConsultaSoroteca.this.textFilialRequisicao.getText()), Integer.parseInt(ConsultaSoroteca.this.textRequisicao.getText()));
                } else {
                    ConsultaSoroteca.this.carregaTubosPaciente(ConsultaSoroteca.this.pacienteAux.getFilial().getCodigo(), ConsultaSoroteca.this.pacienteAux.getCodigo());
                }
                if (ConsultaSoroteca.this.modelEtiquetas.getRowCount() > 0 && ConsultaSoroteca.this.tableEtiquetas.isEnabled() && ConsultaSoroteca.this.tableEtiquetas.isFocusable()) {
                    ScreenUtil.requisitarFoco(ConsultaSoroteca.this.tableEtiquetas);
                    ConsultaSoroteca.this.tableEtiquetas.getSelectionModel().setSelectionInterval(0, 0);
                }
                msg.apagar();
            }
        });
        this.modelEtiquetas.setColumnSize(new int[]{0, 80, 0}, this.tableEtiquetas);
        this.tableEtiquetas.getTableHeader().addMouseListener(this.modelEtiquetas);
        this.tableEtiquetas.removeColumn(this.tableEtiquetas.getColumn("Objeto"));
        this.scrollEtiquetas = new JScrollPane(this.tableEtiquetas);
        this.scrollEtiquetas.setBorder(BorderFactory.createTitledBorder("Etiquetas"));
        this.scrollEtiquetas.setMinimumSize(new Dimension(200, 20));
        this.scrollEtiquetas.setPreferredSize(new Dimension(200, 20));
        this.splitSoroteca = new JSplitPane(1, this.scrollEtiquetas, this.panelSoroteca);
        this.buttonFiltrar.setMnemonic('i');
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(1, 0, 0, 1);
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        this.painelCentral.add((Component)this.labelEtiqueta, c);
        c.insets = new Insets(1, 0, 0, 0);
        ++c.gridx;
        c.gridwidth = 3;
        this.painelCentral.add((Component)this.textEtiqueta, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.insets = new Insets(1, 0, 0, 1);
        this.painelCentral.add((Component)this.labelFilialRequisicao, c);
        c.insets = new Insets(1, 0, 0, 0);
        ++c.gridx;
        this.painelCentral.add((Component)this.textFilialRequisicao, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.buttonBuscarFilialRequisicao, c);
        ++c.gridx;
        c.insets = new Insets(1, 20, 0, 0);
        this.painelCentral.add((Component)this.labelRequisicao, c);
        c.insets = new Insets(1, 0, 0, 0);
        ++c.gridx;
        this.painelCentral.add((Component)this.textRequisicao, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.buttonRequisicao, c);
        ++c.gridy;
        c.gridx = 0;
        c.insets = new Insets(1, 0, 1, 1);
        this.painelCentral.add((Component)this.labelFilialPaciente, c);
        c.insets = new Insets(1, 0, 0, 0);
        ++c.gridx;
        this.painelCentral.add((Component)this.textFilialPaciente, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.buttonBuscarFilialPaciente, c);
        ++c.gridx;
        c.insets = new Insets(1, 20, 0, 0);
        this.painelCentral.add((Component)this.labelPaciente, c);
        c.insets = new Insets(1, 0, 0, 0);
        ++c.gridx;
        this.painelCentral.add((Component)this.textPaciente, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.buttonPaciente, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.painelCentral.add((Component)this.labelNomePaciente, c);
        c.fill = 0;
        c.weightx = 0.0;
        c.insets = new Insets(1, 0, 1, 1);
        ++c.gridx;
        this.painelCentral.add((Component)this.buttonFiltrar, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 8;
        c.fill = 1;
        c.anchor = 17;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.painelCentral.add((Component)this.splitSoroteca, c);
        ++c.gridy;
        c.weighty = 0.0;
        c.fill = 2;
        ConsultaSoroteca.montaPanelLegenda(this.panelLegenda);
        this.painelCentral.add((Component)this.panelLegenda, c);
        this.modelEtiquetas.ordenarColunaSemTrocarSentido(this.modelEtiquetas.findColumn("Etiqueta"));
        this.controlarCampos();
    }

    private boolean processarNumeroTubo() {
        return this.processarNumeroTubo(this.textFilialRequisicao, this.textRequisicao);
    }

    public static void montaPanelLegenda(JPanel pnlLegenda) {
        if (pnlLegenda == null) {
            pnlLegenda = new JPanel(new GridBagLayout());
        } else if (!(pnlLegenda.getLayout() instanceof GridBagLayout)) {
            pnlLegenda.setLayout(new GridBagLayout());
        }
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        JPanel pnlCorLegenda = new JPanel();
        pnlCorLegenda = new JPanel();
        pnlCorLegenda.setPreferredSize(new Dimension(10, 10));
        pnlCorLegenda.setBackground(JTabuleiro.COR_PREENCHIDA);
        pnlCorLegenda.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        ++c.gridx;
        pnlLegenda.add((Component)pnlCorLegenda, c);
        JLabel lblLegenda = new JLabel("Tubo OK");
        Font font = new Font(lblLegenda.getFont().getName(), 0, 10);
        lblLegenda.setFont(font);
        ++c.gridx;
        pnlLegenda.add((Component)lblLegenda, c);
        ++c.gridx;
        pnlLegenda.add((Component)new JLabel("  "), c);
        pnlCorLegenda = new JPanel();
        pnlCorLegenda.setPreferredSize(new Dimension(10, 10));
        pnlCorLegenda.setBackground(JTabuleiro.COR_PREENCHIDA_VENCIDO);
        pnlCorLegenda.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        ++c.gridx;
        pnlLegenda.add((Component)pnlCorLegenda, c);
        lblLegenda = new JLabel("Tubo Vencido");
        font = new Font(lblLegenda.getFont().getName(), 0, 10);
        lblLegenda.setFont(font);
        ++c.gridx;
        pnlLegenda.add((Component)lblLegenda, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        pnlLegenda.add((Component)new JLabel(""), c);
    }

    private void buscaDadosPacienteRequisicao(int codigoFilial, int codigoRequisicao) {
        block8: {
            try {
                this.pacienteAux = new PacienteService().getPacienteRequisicao(String.valueOf(codigoFilial), String.valueOf(codigoRequisicao));
                if (this.pacienteAux != null) {
                    this.textFilialPaciente.setText(this.pacienteAux.getFilial().getCodigo().toString());
                    this.textPaciente.setText(this.pacienteAux.getCodigo().toString());
                    this.labelNomePaciente.setText(this.pacienteAux.getNome());
                    this.controlarCampos();
                    if (this.buttonFiltrar.isEnabled() && this.buttonFiltrar.isFocusable()) {
                        ScreenUtil.requisitarFoco(this.buttonFiltrar);
                    }
                } else {
                    if (!Funcoes.textoVazio(this.textPaciente)) {
                        Funcoes.mensagem(this, "Paciente n\u00e3o localizado.", 2);
                    } else {
                        Funcoes.mensagem(this, "Requisi\u00e7\u00e3o n\u00e3o localizada.", 2);
                    }
                    if (this.textRequisicao.isEnabled() && this.textRequisicao.isFocusable()) {
                        this.textRequisicao.selectAll();
                        ScreenUtil.requisitarFoco(this.textRequisicao);
                    }
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar os dados da requisi\u00e7\u00e3o.\n" + e.getMessage(), e.getStackTrace());
                if (!this.textRequisicao.isEnabled() || !this.textRequisicao.isFocusable()) break block8;
                this.textRequisicao.selectAll();
                ScreenUtil.requisitarFoco(this.textRequisicao);
            }
        }
    }

    private void buscaDadosEtiqueta(String etiqueta) {
        ArrayList<Tubo> tubos = null;
        try {
            new TuboDao();
            tubos = TuboDao.carregaTubosConsulta(this.textEtiqueta.getText(), false, true);
            if (tubos != null) {
                if (!tubos.isEmpty() && tubos.get(0) != null) {
                    this.textFilialRequisicao.setText(String.valueOf(((Tubo)tubos.get(0)).getFilial().getCodigo()));
                    this.textRequisicao.setText(String.valueOf(((Tubo)tubos.get(0)).getCodigoRequisicaoEtiqueta()));
                    this.textPaciente.setText(String.valueOf(((Tubo)tubos.get(0)).getPaciente().getCodigo()));
                    this.buscaDadosPacienteRequisicao(((Tubo)tubos.get(0)).getFilial().getCodigo(), ((Tubo)tubos.get(0)).getCodigoRequisicaoEtiqueta());
                } else {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "Os tubos associados \u00e0 etiqueta n\u00e3o foram encontrados na soroteca.", 2);
                }
            } else {
                Funcoes.mensagem(Laboratorio.getInstancia(), "Etiqueta incorreta.", 2);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar dados da etiqueta.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    private void controlarCampos() {
        boolean habilita = this.getStatus() == 2;
        this.botaoNovo.setEnabled(true);
        this.botaoFechar.setEnabled(true);
        this.textRequisicao.setEnabled(habilita && Funcoes.textoVazio(this.textPaciente.getText()));
        this.buttonRequisicao.setEnabled(habilita && Funcoes.textoVazio(this.textPaciente.getText()));
        this.textPaciente.setEnabled(habilita && Funcoes.textoVazio(this.textRequisicao.getText()) && this.pacienteAux == null);
        this.buttonPaciente.setEnabled(habilita && Funcoes.textoVazio(this.textRequisicao.getText()));
        this.textEtiqueta.setEnabled(habilita && this.pacienteAux == null && !this.requisicaoSelecionada);
        this.buttonFiltrar.setEnabled(habilita && (this.requisicaoSelecionada || this.pacienteAux != null));
        this.tableEtiquetas.setEnabled(habilita && (this.requisicaoSelecionada || this.pacienteAux != null));
        this.textFilialPaciente.setEnabled(habilita && Funcoes.textoVazio(this.textRequisicao.getText()) && this.pacienteAux == null);
        this.buttonBuscarFilialPaciente.setEnabled(habilita && Funcoes.textoVazio(this.textRequisicao.getText()) && this.pacienteAux == null);
        this.textFilialRequisicao.setEnabled(habilita && Funcoes.textoVazio(this.textPaciente.getText()));
        this.buttonBuscarFilialRequisicao.setEnabled(habilita && Funcoes.textoVazio(this.textPaciente.getText()));
    }

    @Override
    public void cancelar() {
        this.limparCampos();
        this.setStatus(1);
        this.controlarCampos();
    }

    @Override
    @Deprecated
    public void editar() {
    }

    @Override
    @Deprecated
    public void excluir() {
    }

    @Override
    public void fechar() {
        this.setVisible(false);
    }

    private void limparCampos() {
        this.textEtiqueta.setText("");
        this.textRequisicao.setText("");
        this.textPaciente.setText("");
        this.labelNomePaciente.setText("");
        this.modelEtiquetas.clear();
        this.panelSoroteca.limpar();
        this.requisicaoSelecionada = false;
        this.pacienteAux = null;
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlarCampos();
        this.requisicaoSelecionada = false;
        if (this.textEtiqueta.isEnabled() && this.textEtiqueta.isFocusable()) {
            ScreenUtil.requisitarFoco(this.textEtiqueta);
        }
    }

    @Override
    @Deprecated
    public void salvar() {
    }

    @Override
    @Deprecated
    public boolean validaCampos() {
        return false;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0701000100");
    }

    public void carregaTubos(String etiqueta) {
        this.modelEtiquetas.clear();
        ArrayList<Tubo> tubos = null;
        try {
            new TuboDao();
            tubos = TuboDao.carregaTubosConsulta(etiqueta, true, true);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar dados dos tubos.\n" + e.getMessage(), e.getStackTrace());
        }
        if (tubos != null) {
            for (int i = 0; i < tubos.size(); ++i) {
                Tubo tubo = (Tubo)tubos.get(i);
                if (tubo != null && tubo.getEtiqueta() != null && !Funcoes.textoVazio(tubo.getEtiqueta()) && tubo.getEstante() != null) continue;
                tubos.remove(i);
                --i;
            }
        }
        if (tubos == null || tubos.size() == 0) {
            Funcoes.mensagem(this, "Nenhum tubo encontrado na soroteca.", 2);
        } else {
            this.preencheDadosTubos(tubos);
        }
    }

    public void carregaTubosRequisicao(int filialRequisicao, int codigoRequsicao) {
        this.modelEtiquetas.clear();
        List<Tubo> tubos = null;
        try {
            new TuboDao();
            tubos = TuboDao.carregaTubosConsulta(Integer.parseInt(Variaveis.filialPadrao), filialRequisicao, codigoRequsicao);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar dados dos tubos.\n" + e.getMessage(), e.getStackTrace());
        }
        if (tubos != null) {
            for (int i = 0; i < tubos.size(); ++i) {
                Tubo tubo = tubos.get(i);
                if (tubo != null && tubo.getEtiqueta() != null && !Funcoes.textoVazio(tubo.getEtiqueta()) && tubo.getEstante() != null) continue;
                tubos.remove(i);
                --i;
            }
        }
        if (tubos == null || tubos.size() == 0) {
            Funcoes.mensagem(this, "Nenhum tubo da requisi\u00e7\u00e3o foi encontrado na soroteca.", 2);
        } else {
            this.preencheDadosTubos(tubos);
        }
    }

    public void carregaTubosPaciente(int filialPaciente, int codigoPaciente) {
        this.modelEtiquetas.clear();
        List<Tubo> tubos = null;
        try {
            new TuboDao();
            tubos = TuboDao.carregaTubosPaciente(Integer.parseInt(Variaveis.filialPadrao), filialPaciente, codigoPaciente);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar dados dos tubos.\n" + e.getMessage(), e.getStackTrace());
        }
        if (tubos == null || tubos.size() == 0) {
            Funcoes.mensagem(this, "Nenhum tubo associado ao paciente foi encontrado na soroteca.", 2);
        } else {
            if (tubos != null) {
                for (int i = 0; i < tubos.size(); ++i) {
                    Tubo tubo = tubos.get(i);
                    if (tubo != null && tubo.getEtiqueta() != null && !Funcoes.textoVazio(tubo.getEtiqueta()) && tubo.getEstante() != null) continue;
                    tubos.remove(i);
                    --i;
                }
            }
            this.preencheDadosTubos(tubos);
        }
    }

    private void preencheDadosTubos(List<Tubo> tubos) {
        if (tubos == null) {
            return;
        }
        this.modelEtiquetas.clear();
        for (int i = 0; i < tubos.size(); ++i) {
            Tubo tubo = tubos.get(i);
            if (tubo.getDataHoraDescarte() != null || tubo.getUsuarioDescarte() != null) continue;
            this.modelEtiquetas.addLine(new Object[]{tubo.getEtiqueta(), tubo.getDataRequisicao(), tubo});
        }
        if (this.modelEtiquetas.getRowCount() == 0) {
            Tubo aux = null;
            for (int i = 0; i < tubos.size(); ++i) {
                if (aux != null && tubos.get(i).getDataHoraDescarte().compareTo(aux.getDataHoraDescarte()) <= 0) continue;
                aux = tubos.get(i);
            }
            if (aux != null) {
                Funcoes.mensagem(null, "O tubo foi removido da soroteca em \"" + Funcoes.formataData("dd/MM/yyyy HH:mm", aux.getDataHoraDescarte()) + "\" pelo usu\u00e1rio \"" + aux.getUsuarioDescarte().getCodigo() + "\".", 5);
            }
        }
    }

    private JPanel getPanelVazio(int width, int height) {
        JPanel aux = new JPanel();
        Dimension d = new Dimension(width, height);
        aux.setMinimumSize(d);
        aux.setPreferredSize(d);
        aux.setMaximumSize(d);
        return aux;
    }

    @Override
    public String getRetornoParaPesquisa() {
        return "";
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return null;
    }

    class SorotecaBasica
    extends JPanel {
        private final JLabel labelFilial = new JLabel("Filial:");
        private final JLabel labelCodigoFilial = new JLabel();
        private final JLabel labelGeladeira = new JLabel("Geladeira:");
        private final JLabel labelCodigoGeladeira = new JLabel();
        private final JLabel labelDescricaoGeladeira = new JLabel();
        private final JLabel labelPrateleira = new JLabel("Prateleira:");
        private final JLabel labelCodigoPrateleira = new JLabel();
        private final JLabel labelEstante = new JLabel("Estante:");
        private final JLabel labelCodigoEstante = new JLabel();
        private final JLabel labelDescricaoEstante = new JLabel();
        private JScrollPane scrollEstante = null;
        private JPanel panelEstante = null;
        TuboContainer tuboContainer = null;

        public SorotecaBasica() {
            this.desenha();
        }

        public void limpar() {
            this.labelCodigoGeladeira.setText("");
            this.labelDescricaoGeladeira.setText("");
            this.labelCodigoPrateleira.setText("");
            this.labelCodigoEstante.setText("");
            this.labelDescricaoEstante.setText("");
            this.labelCodigoFilial.setText("");
            this.panelEstante.removeAll();
            this.panelEstante.repaint();
        }

        private void desenha() {
            this.setLayout(new GridBagLayout());
            ScreenUtil.setBorda(new JLabel[]{this.labelCodigoFilial, this.labelCodigoGeladeira, this.labelDescricaoGeladeira, this.labelCodigoPrateleira, this.labelCodigoEstante, this.labelDescricaoEstante}, new TitledBorder(""));
            Dimension d = new Dimension(50, 20);
            this.labelCodigoGeladeira.setMinimumSize(d);
            this.labelCodigoGeladeira.setPreferredSize(d);
            this.labelCodigoGeladeira.setHorizontalAlignment(4);
            this.labelCodigoEstante.setMinimumSize(d);
            this.labelCodigoEstante.setPreferredSize(d);
            this.labelCodigoEstante.setHorizontalAlignment(4);
            d = new Dimension(70, 20);
            this.labelCodigoPrateleira.setMinimumSize(d);
            this.labelCodigoPrateleira.setPreferredSize(d);
            this.labelCodigoFilial.setMaximumSize(d);
            this.labelCodigoFilial.setPreferredSize(d);
            d = new Dimension(20, 20);
            this.labelDescricaoGeladeira.setMinimumSize(d);
            this.labelDescricaoGeladeira.setPreferredSize(d);
            this.labelDescricaoEstante.setMinimumSize(d);
            this.labelDescricaoEstante.setPreferredSize(d);
            this.panelEstante = new JPanel(new BorderLayout());
            this.scrollEstante = new JScrollPane(this.panelEstante);
            this.scrollEstante.setBorder(BorderFactory.createTitledBorder(""));
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 17;
            c.gridy = 0;
            c.gridx = 0;
            c.fill = 0;
            c.weightx = 0.0;
            c.gridwidth = 1;
            c.insets = new Insets(1, 1, 1, 0);
            this.add((Component)this.labelFilial, c);
            c.gridwidth = 2;
            ++c.gridx;
            this.add((Component)this.labelCodigoFilial, c);
            c.gridwidth = 1;
            c.gridx += 2;
            this.add((Component)ConsultaSoroteca.this.getPanelVazio(20, 20), c);
            ++c.gridx;
            this.add((Component)this.labelGeladeira, c);
            ++c.gridx;
            this.add((Component)this.labelCodigoGeladeira, c);
            c.fill = 2;
            c.weightx = 1.0;
            c.insets = new Insets(1, 0, 1, 1);
            ++c.gridx;
            this.add((Component)this.labelDescricaoGeladeira, c);
            ++c.gridy;
            c.gridx = 0;
            c.fill = 0;
            c.weightx = 0.0;
            c.gridwidth = 1;
            c.insets = new Insets(1, 1, 1, 0);
            this.add((Component)this.labelPrateleira, c);
            c.gridwidth = 2;
            ++c.gridx;
            this.add((Component)this.labelCodigoPrateleira, c);
            c.gridwidth = 1;
            c.gridx += 2;
            this.add((Component)ConsultaSoroteca.this.getPanelVazio(20, 20), c);
            ++c.gridx;
            this.add((Component)this.labelEstante, c);
            ++c.gridx;
            this.add((Component)this.labelCodigoEstante, c);
            c.fill = 2;
            c.weightx = 1.0;
            c.insets = new Insets(1, 0, 1, 1);
            ++c.gridx;
            this.add((Component)this.labelDescricaoEstante, c);
            ++c.gridy;
            c.gridx = 0;
            c.weighty = 1.0;
            c.fill = 1;
            c.gridwidth = 10;
            this.add((Component)this.scrollEstante, c);
        }

        public void setTubo(Tubo tuboSelecionado, List<Tubo> listaTubos) {
            this.limpar();
            if (tuboSelecionado != null && listaTubos != null && listaTubos.size() > 0) {
                GeladeiraVO geladeira = tuboSelecionado.getEstante().getPrateleira().getGeladeira();
                this.labelCodigoGeladeira.setText(geladeira.getCodigo().toString());
                this.labelDescricaoGeladeira.setText(geladeira.getDescricao());
                String prateleira = tuboSelecionado.getEstante().getPrateleira().getCodigo();
                this.labelCodigoPrateleira.setText(prateleira);
                EstanteBean estante = tuboSelecionado.getEstante();
                this.labelCodigoEstante.setText(estante.getCodigo().toString());
                this.labelDescricaoEstante.setText(estante.getIdentificador());
                this.labelCodigoFilial.setText(String.valueOf(tuboSelecionado.getFilial().getCodigo()));
                if (estante.isPacote().booleanValue()) {
                    this.tuboContainer = new TuboContainerJList(false, false);
                } else {
                    this.tuboContainer = new TuboContainerJTabuleiro(estante.getLinhas(), estante.getColunas(), this.panelEstante, false, false);
                    ((TuboContainerJTabuleiro)this.tuboContainer).setBarraDetalhesVisivel(false);
                }
                if (this.panelEstante != null) {
                    this.panelEstante.add(this.tuboContainer.getUI());
                }
                if (this.panelEstante != null) {
                    this.panelEstante.addComponentListener(new ComponentListener(){

                        @Override
                        public void componentResized(ComponentEvent e) {
                            if (SorotecaBasica.this.tuboContainer instanceof TuboContainerJTabuleiro) {
                                ((TuboContainerJTabuleiro)SorotecaBasica.this.tuboContainer).atualizaDiametroTubos(SorotecaBasica.this.panelEstante);
                            }
                        }

                        @Override
                        @Deprecated
                        public void componentShown(ComponentEvent e) {
                        }

                        @Override
                        @Deprecated
                        public void componentMoved(ComponentEvent e) {
                        }

                        @Override
                        @Deprecated
                        public void componentHidden(ComponentEvent e) {
                        }
                    });
                }
                for (int i = 0; i < listaTubos.size(); ++i) {
                    Tubo tuboAux = listaTubos.get(i);
                    if (tuboAux == null || tuboAux.getEstante().getCodigo().intValue() != estante.getCodigo().intValue() || !tuboAux.getEstante().getPrateleira().getCodigo().equalsIgnoreCase(prateleira) || tuboAux.getEstante().getPrateleira().getGeladeira().getCodigo().intValue() != geladeira.getCodigo().intValue()) continue;
                    this.tuboContainer.addTubo(tuboAux, false);
                }
                this.tuboContainer.selecionarTuboEtiquetaRepetida(tuboSelecionado);
            }
        }
    }
}

