/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.consultas.triagem;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.model.bean.triagem.MaterialIdentificadoBean;
import jalis.model.vo.cadastro.ConvenioVO;
import jalis.model.vo.cadastro.RotaVO;
import jalis.service.cadastro.ConvenioService;
import jalis.service.cadastro.RotaService;
import jalis.util.CheckItemFiltro;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.ThreadFinalizadaListener;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;

public class PrevisaoRecebimentoMaterial
extends FrmCadPadrao
implements ActionListener,
ThreadFinalizadaListener {
    private JPanel panelPrinc = new JPanel(new BorderLayout());
    private JPanel panelFiltro = new JPanel(new GridBagLayout());
    private JPanel panelDiasSemana = new JPanel(new GridBagLayout());
    private JPanel panelRotas = new JPanel();
    private CheckItemFiltro itemRota = new CheckItemFiltro("Rota", "Filtrar", "Filtrando rotas", "fil_codigo = " + Variaveis.filialPadrao);
    private CheckItemFiltro itemConvenio = new CheckItemFiltro("Conv\u00eanio", "Filtrar", "Filtrando conv\u00eanios", "fil_codigo = " + Variaveis.filialPadrao);
    private JLabel labelDataInicial = new JLabel("Dt. Inicial: ");
    private JLabel labelDataFinal = new JLabel("Dt. Final:");
    private JLabel labelTextoInicial = new JLabel("Selecione um dia da semana");
    private TTextField textDataInicial = new TTextField(10, 4);
    private TTextField textDataFinal = new TTextField(10, 4);
    private JButton buttonConsultar = new JButton("Consultar");
    private JButton buttonDataInicial = new JButton();
    private JButton buttonDataFinal = new JButton();
    private int LARGURA_PANEL_ROTA = 140;
    private int LARGURA_PANEL_DIA_SEMANA = 110;
    private boolean isPesquisando = false;
    ArrayList<DiasSemana> listaDiasSemana = null;

    public PrevisaoRecebimentoMaterial() {
        this.panelDiasSemana.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                PrevisaoRecebimentoMaterial.this.desenhaDiasSemana();
            }
        });
        Funcoes.criaBarraDescricao(this, "Previs\u00e3o de Recebimento de Material", "Visualiza\u00e7\u00e3o das rotas e quantidades por data.", "consultas/previsao_material.jpg");
        this.painelBotoes.remove(this.botaoEditar);
        this.painelBotoes.remove(this.botaoSalvar);
        this.painelBotoes.remove(this.botaoExcluir);
        this.painelBotoes.remove(this.botaoCancelar);
        this.buttonDataInicial.setPreferredSize(new Dimension(20, 20));
        this.buttonDataInicial.setMinimumSize(new Dimension(20, 20));
        this.buttonDataInicial.setMaximumSize(new Dimension(20, 20));
        this.buttonDataFinal.setPreferredSize(new Dimension(20, 20));
        this.buttonDataFinal.setMinimumSize(new Dimension(20, 20));
        this.buttonDataFinal.setMaximumSize(new Dimension(20, 20));
        this.buttonDataInicial.setFocusable(false);
        this.buttonDataFinal.setFocusable(false);
        Funcoes.imagemPesquisa(this.buttonDataInicial);
        Funcoes.imagemPesquisa(this.buttonDataFinal);
        this.buttonDataInicial.addActionListener(this);
        this.buttonDataFinal.addActionListener(this);
        AdaptadorTecla aux = new AdaptadorTecla();
        this.textDataInicial.addKeyListener(aux);
        this.textDataFinal.addKeyListener(aux);
        this.panelFiltro.setBorder(new TitledBorder("Filtro"));
        this.panelFiltro.setPreferredSize(new Dimension(180, 100));
        this.panelDiasSemana.setBorder(new TitledBorder("Dias da Semana"));
        this.panelDiasSemana.setOpaque(true);
        this.panelDiasSemana.setBackground(Color.WHITE);
        this.panelRotas.setBorder(new TitledBorder("Rotas"));
        this.painelCentral.setLayout(new BorderLayout());
        this.painelCentral.add((Component)this.panelFiltro, "West");
        this.painelCentral.add((Component)this.panelPrinc, "Center");
        this.panelPrinc.add((Component)this.panelDiasSemana, "North");
        this.panelPrinc.add((Component)this.panelRotas, "Center");
        this.panelRotas.setLayout(new BorderLayout());
        this.labelTextoInicial.setHorizontalAlignment(0);
        this.panelRotas.add((Component)this.labelTextoInicial, "Center");
        this.montaPainelFiltro();
        this.controlaCampos();
    }

    private void montaPainelFiltro() {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 3;
        this.itemConvenio.setDados("convenios", new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia Conv\u00eanio"}, new int[]{70, 0});
        this.itemConvenio.setColunaHint(1);
        this.panelFiltro.add((Component)this.itemConvenio, c);
        ++c.gridy;
        this.itemRota.setDados("rota", new String[]{"rot_codigo", "rot_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemRota.setColunaHint(1);
        this.panelFiltro.add((Component)this.itemRota, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.panelFiltro.add((Component)this.labelDataInicial, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.panelFiltro.add((Component)this.textDataInicial, c);
        ++c.gridx;
        c.weightx = 0.0;
        this.panelFiltro.add((Component)this.buttonDataInicial, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        this.panelFiltro.add((Component)this.labelDataFinal, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.panelFiltro.add((Component)this.textDataFinal, c);
        ++c.gridx;
        c.weightx = 0.0;
        this.panelFiltro.add((Component)this.buttonDataFinal, c);
        ++c.gridy;
        c.gridx = 0;
        c.fill = 0;
        c.anchor = 13;
        c.gridwidth = 3;
        c.weightx = 0.0;
        this.buttonConsultar.setMnemonic('C');
        this.buttonConsultar.setPreferredSize(new Dimension(100, 20));
        this.buttonConsultar.setMinimumSize(new Dimension(100, 20));
        this.buttonConsultar.addActionListener(this);
        this.panelFiltro.add((Component)this.buttonConsultar, c);
        ++c.gridy;
        c.weighty = 1.0;
        this.panelFiltro.add((Component)new JLabel(), c);
    }

    private void limparCampos() {
        this.itemConvenio.clear();
        this.itemRota.clear();
        this.textDataFinal.clear();
        this.textDataInicial.clear();
        this.carregaDadosDiaSemana(new ArrayRotas(), false);
    }

    private void controlaCampos() {
        boolean habilita = this.getStatus() != 1 && !this.isPesquisando;
        this.itemConvenio.setEnabled(habilita);
        this.itemRota.setEnabled(habilita);
        this.textDataInicial.setEnabled(habilita);
        this.textDataFinal.setEnabled(habilita);
        this.buttonConsultar.setEnabled(habilita);
        this.buttonDataInicial.setEnabled(habilita);
        this.buttonDataFinal.setEnabled(habilita);
        this.botaoFechar.setEnabled(!this.isPesquisando);
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        ScreenUtil.requisitarFoco(this.itemConvenio);
    }

    @Override
    @Deprecated
    public void cancelar() {
    }

    @Override
    public void fechar() {
        this.setVisible(false);
    }

    @Override
    @Deprecated
    public void salvar() {
    }

    @Override
    @Deprecated
    public void excluir() {
    }

    @Override
    @Deprecated
    public void editar() {
    }

    @Override
    @Deprecated
    public boolean validaCampos() {
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonConsultar) {
            if (Funcoes.textoVazio(this.textDataInicial)) {
                Funcoes.mensagem(this, "Informe uma data inicial.", 2);
                ScreenUtil.requisitarFoco(this.textDataInicial);
                return;
            }
            if (Funcoes.textoVazio(this.textDataFinal)) {
                Funcoes.mensagem(this, "Informe uma data final.", 2);
                ScreenUtil.requisitarFoco(this.textDataFinal);
                return;
            }
            this.panelRotas.setBorder(BorderFactory.createTitledBorder("Rotas"));
            this.panelRotas.removeAll();
            this.buscarRotas();
        } else if (e.getSource() == this.buttonDataInicial) {
            Funcoes.mostraData(this.textDataInicial, this.buttonDataInicial, (JPanel)this.textDataInicial.getParent(), true);
        } else if (e.getSource() == this.buttonDataFinal) {
            Funcoes.mostraData(this.textDataFinal, this.buttonDataFinal, (JPanel)this.textDataFinal.getParent(), true);
        }
    }

    private void buscarRotas() {
        ArrayList<DadosConvenio> listaDadosConvenios = this.buscaDadosConvenios();
        StringBuilder bufConv = new StringBuilder();
        String dataInicial = Funcoes.formataData("yyyy-MM-dd", this.textDataInicial.getText());
        String dataFinal = Funcoes.formataData("yyyy-MM-dd", this.textDataFinal.getText());
        StringBuilder auxConv = new StringBuilder();
        String[] convenios = this.itemConvenio.getSelecionados();
        if (convenios != null) {
            auxConv.append(" and con.con_codigo in (");
            for (int i = 0; i < convenios.length; ++i) {
                auxConv.append("'");
                auxConv.append(convenios[i]);
                auxConv.append("'");
                if (i >= convenios.length - 1) continue;
                auxConv.append(", ");
            }
            auxConv.append(")");
        }
        StringBuilder auxRota = new StringBuilder();
        String[] rotas = this.itemRota.getSelecionados();
        if (rotas != null) {
            auxRota.append(" and con.rot_codigo in (");
            for (int i = 0; i < rotas.length; ++i) {
                auxRota.append("'");
                auxRota.append(rotas[i]);
                auxRota.append("'");
                if (i >= rotas.length - 1) continue;
                auxRota.append(", ");
            }
            auxRota.append(")");
        }
        SplashMensagem splash = SplashMensagem.getInstancia(this);
        splash.mostrar("Pesquisando. Aguarde...");
        ArrayRotas arrayRotas = new ArrayRotas();
        int i = 0;
        while (i < listaDadosConvenios.size()) {
            for (int j = 0; i < listaDadosConvenios.size() && j < 100; ++i, ++j) {
                if (j > 0) {
                    bufConv.append(" UNION ");
                }
                bufConv.append(" select ").append(listaDadosConvenios.get((int)i).diaSemana).append(" as dow ");
                bufConv.append(" ,").append(listaDadosConvenios.get((int)i).qtde).append(" as qtde ");
                bufConv.append(" ,").append(listaDadosConvenios.get((int)i).codigoConvenio).append(" as con_codigo ");
            }
            StringBuilder buf = new StringBuilder();
            buf.append(" select EXTRACT(DOW from date '").append(dataInicial).append("' + numero) as dow ");
            buf.append("       ,date '").append(dataInicial).append("' + numero as data ");
            buf.append("       ,con.rot_codigo as rota ");
            buf.append("       ,con.con_codigo as convenio ");
            buf.append("       ,COUNT(distinct lot.lot_caixaapoio) as qtdeEnviada ");
            buf.append("       ,COUNT(distinct midr.mid_codigo) as qtdeRecebida ");
            buf.append("       ,CASE WHEN (COALESCE(pre.qtde, 0) - COALESCE(cir.cir_quantidade, 0) < 0) THEN 0 ELSE (COALESCE(pre.qtde, 0) - COALESCE(cir.cir_quantidade, 0)) END as qtde ");
            buf.append("       ,pre.qtde - COUNT(distinct lot.lot_caixaapoio) as difEnviada ");
            buf.append("       ,pre.qtde - COUNT(distinct midr.mid_codigo) as difRecebida ");
            buf.append("  from generate_series(0, date '").append(dataFinal).append("' - date '").append(dataInicial).append("') numero ");
            buf.append("  left join (").append(bufConv.toString()).append(") pre on pre.dow = EXTRACT(DOW from date '").append(dataInicial).append("' + numero) ");
            buf.append("  left join convenios con on con.fil_codigo = ").append(Variaveis.filialPadrao).append(" and pre.con_codigo = con.con_codigo ");
            buf.append("  left join materialenviado men on con.fil_codigo = men.fil_codigo and con.con_codigo = men.con_codigo and cast(men.men_datahora as date) = date '").append(dataInicial).append("' + numero ");
            buf.append("  left join materialidentificado midr on men.fil_codigo = midr.fil_codigo and men.men_codigo = midr.men_codigo and cast(midr.mid_dataretorno as date) = date '").append(dataInicial).append("' + numero ");
            buf.append("  left join loteapoio lot on con.fil_codigo = lot.fil_codigo and con.con_codigo = lot.con_codigo and cast(lot.lot_datahora as date) = date '").append(dataInicial).append("' + numero ");
            buf.append("  left join materialidentificado mide on substring(lot.lot_caixaapoio, 1, " + MaterialIdentificadoBean.QTDE_CARAC_FILIAL + ") = text(mide.fil_codigo) ");
            buf.append("            and substring(lot.lot_caixaapoio, " + (MaterialIdentificadoBean.QTDE_CARAC_FILIAL + 1) + ", " + MaterialIdentificadoBean.QTDE_CARAC_CELULA + ") = text(mide.cel_codigo) ");
            buf.append("            and substring(lot.lot_caixaapoio, " + (MaterialIdentificadoBean.QTDE_CARAC_FILIAL + MaterialIdentificadoBean.QTDE_CARAC_CELULA + 1) + ", " + MaterialIdentificadoBean.QTDE_CARAC_MATERIAL + ") = text(mide.mid_codigo) ");
            buf.append("  left join convenioignorarecebimento cir on con.fil_codigo = cir.fil_codigo and con.con_codigo = cir.con_codigo and cir.cir_data = (date '").append(dataInicial).append("' + numero) ");
            buf.append(" where con.rot_codigo IS NOT NULL ");
            buf.append(auxConv.toString());
            buf.append(auxRota.toString());
            buf.append(" group by numero.numero ");
            buf.append("      ,con.con_codigo ");
            buf.append("      ,qtde ");
            buf.append("      ,con.rot_codigo ");
            buf.append("      ,cir.cir_quantidade ");
            buf.append(" order by data ");
            buf.append("         ,rota ");
            buf.append("         ,convenio ");
            try {
                ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
                while (rs.next()) {
                    RotaVO rota = (RotaVO)new RotaService().getVO(Variaveis.filialPadrao, rs.getString("rota"));
                    ConvenioVO convenio = (ConvenioVO)new ConvenioService().getVO(Variaveis.filialPadrao, rs.getString("convenio"));
                    if (rs.getInt("qtde") <= 0 && rs.getInt("qtdeenviada") <= 0 && rs.getInt("qtderecebida") <= 0) continue;
                    arrayRotas.adicionaRota(rota, rs.getDate("data"), rs.getInt("dow"), convenio, rs.getInt("qtde"), rs.getInt("qtdeenviada"), rs.getInt("qtderecebida"));
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar rotas. - " + e.getMessage(), e.getStackTrace());
                return;
            }
            bufConv.setLength(0);
        }
        splash.apagar();
        this.carregaDadosDiaSemana(arrayRotas, true);
        this.desenhaDiasSemana();
    }

    private void carregaDadosDiaSemana(ArrayRotas arrayRotas, boolean ativar) {
        Integer totalPrevisto = 0;
        Integer totalEnviado = 0;
        Integer totalRecebido = 0;
        Integer totalDevedor = 0;
        if (this.listaDiasSemana == null) {
            this.listaDiasSemana = new ArrayList();
        } else {
            this.listaDiasSemana.clear();
        }
        for (int i = 0; i <= 6; ++i) {
            DiasSemana dia = new DiasSemana(i, arrayRotas, ativar);
            this.listaDiasSemana.add(dia);
            if (dia == null) continue;
            totalPrevisto = totalPrevisto + dia.previsto;
            totalEnviado = totalEnviado + dia.enviado;
            totalRecebido = totalRecebido + dia.recebido;
        }
        totalDevedor = totalPrevisto - totalRecebido;
        TotalDiasSemana total = new TotalDiasSemana(totalPrevisto, totalRecebido, totalEnviado, totalDevedor, ativar);
        this.listaDiasSemana.add(total);
    }

    private void desenhaDiasSemana() {
        int qtde;
        this.panelDiasSemana.removeAll();
        if (this.listaDiasSemana == null) {
            this.carregaDadosDiaSemana(new ArrayRotas(), false);
        }
        if ((qtde = this.panelDiasSemana.getWidth() / (this.LARGURA_PANEL_DIA_SEMANA + 10)) == 0) {
            return;
        }
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 5, 1, 5);
        for (int i = 0; i < this.listaDiasSemana.size(); ++i) {
            DiasSemana dia = this.listaDiasSemana.get(i);
            if (dia == null) continue;
            this.panelDiasSemana.add((Component)dia, c);
            if ((i + 1) % qtde == 0) {
                c.gridx = 0;
                ++c.gridy;
                continue;
            }
            ++c.gridx;
        }
        ++c.gridy;
        c.gridx = 1;
        c.gridwidth = qtde;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.panelDiasSemana.add((Component)new JLabel(), c);
        this.panelDiasSemana.revalidate();
        this.panelDiasSemana.repaint();
    }

    private ArrayList<DadosConvenio> buscaDadosConvenios() {
        StringBuilder buf = new StringBuilder();
        buf.append(" select con_codigo ");
        buf.append("       ,con_qtderecebimentocaixa ");
        buf.append("  from convenios ");
        buf.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
        String[] convenios = this.itemConvenio.getSelecionados();
        if (convenios != null) {
            buf.append(" and con_codigo in (");
            for (int i = 0; i < convenios.length; ++i) {
                buf.append("'");
                buf.append(convenios[i]);
                buf.append("'");
                if (i >= convenios.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        ArrayList<DadosConvenio> arrayDados = new ArrayList<DadosConvenio>();
        try {
            ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
            while (rs.next()) {
                String valoresRec;
                Integer codigoConvenio = rs.getInt("con_codigo");
                String string = valoresRec = rs.getString("con_qtderecebimentocaixa") == null ? "" : rs.getString("con_qtderecebimentocaixa");
                if (StringUtil.getValor(valoresRec, "segunda") != null && !Funcoes.textoVazio(StringUtil.getValor(valoresRec, "segunda"))) {
                    arrayDados.add(new DadosConvenio(codigoConvenio, 1, Integer.parseInt(StringUtil.getValor(valoresRec, "segunda"))));
                } else {
                    arrayDados.add(new DadosConvenio(codigoConvenio, 1, 0));
                }
                if (StringUtil.getValor(valoresRec, "terca") != null && !Funcoes.textoVazio(StringUtil.getValor(valoresRec, "terca"))) {
                    arrayDados.add(new DadosConvenio(codigoConvenio, 2, Integer.parseInt(StringUtil.getValor(valoresRec, "terca"))));
                } else {
                    arrayDados.add(new DadosConvenio(codigoConvenio, 2, 0));
                }
                if (StringUtil.getValor(valoresRec, "quarta") != null && !Funcoes.textoVazio(StringUtil.getValor(valoresRec, "quarta"))) {
                    arrayDados.add(new DadosConvenio(codigoConvenio, 3, Integer.parseInt(StringUtil.getValor(valoresRec, "quarta"))));
                } else {
                    arrayDados.add(new DadosConvenio(codigoConvenio, 3, 0));
                }
                if (StringUtil.getValor(valoresRec, "quinta") != null && !Funcoes.textoVazio(StringUtil.getValor(valoresRec, "quinta"))) {
                    arrayDados.add(new DadosConvenio(codigoConvenio, 4, Integer.parseInt(StringUtil.getValor(valoresRec, "quinta"))));
                } else {
                    arrayDados.add(new DadosConvenio(codigoConvenio, 4, 0));
                }
                if (StringUtil.getValor(valoresRec, "sexta") != null && !Funcoes.textoVazio(StringUtil.getValor(valoresRec, "sexta"))) {
                    arrayDados.add(new DadosConvenio(codigoConvenio, 5, Integer.parseInt(StringUtil.getValor(valoresRec, "sexta"))));
                } else {
                    arrayDados.add(new DadosConvenio(codigoConvenio, 5, 0));
                }
                if (StringUtil.getValor(valoresRec, "sabado") != null && !Funcoes.textoVazio(StringUtil.getValor(valoresRec, "sabado"))) {
                    arrayDados.add(new DadosConvenio(codigoConvenio, 6, Integer.parseInt(StringUtil.getValor(valoresRec, "sabado"))));
                } else {
                    arrayDados.add(new DadosConvenio(codigoConvenio, 6, 0));
                }
                if (StringUtil.getValor(valoresRec, "domingo") != null && !Funcoes.textoVazio(StringUtil.getValor(valoresRec, "domingo"))) {
                    arrayDados.add(new DadosConvenio(codigoConvenio, 0, Integer.parseInt(StringUtil.getValor(valoresRec, "domingo"))));
                    continue;
                }
                arrayDados.add(new DadosConvenio(codigoConvenio, 0, 0));
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar dados dos conv\u00eanios. - " + e.getMessage(), e.getStackTrace());
        }
        return arrayDados;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0701000200");
    }

    @Override
    public String getRetornoParaPesquisa() {
        return "";
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return null;
    }

    @Override
    public void threadIniciada(EventObject e) {
        this.isPesquisando = true;
        this.controlaCampos();
    }

    @Override
    public void threadFinalizada(EventObject e) {
        this.isPesquisando = false;
        this.controlaCampos();
    }

    class DetalhesConvenioRota {
        ArrayList<ConvenioVO> convenios = new ArrayList();
        ArrayList<Integer> previstos = new ArrayList();
        ArrayList<Integer> enviados = new ArrayList();
        ArrayList<Integer> recebidos = new ArrayList();
        ArrayList<Integer> saldoDevedor = new ArrayList();

        public Integer getSaldoDevedor(int pos) {
            return this.saldoDevedor.get(pos);
        }

        public ConvenioVO getConvenio(int pos) {
            return this.convenios.get(pos);
        }

        public int size() {
            return this.convenios.size();
        }

        public void adicionarValoresConvenio(ConvenioVO convenio, Integer previsto, Integer enviado, Integer recebido, Integer devedor) {
            for (int i = 0; i < this.convenios.size(); ++i) {
                ConvenioVO aux = this.convenios.get(i);
                if (aux.getCodigo().intValue() != convenio.getCodigo().intValue()) continue;
                this.previstos.set(i, previsto);
                this.enviados.set(i, enviado);
                this.recebidos.set(i, recebido);
                this.saldoDevedor.set(i, devedor);
                return;
            }
            this.convenios.add(convenio);
            this.previstos.add(previsto);
            this.enviados.add(enviado);
            this.recebidos.add(recebido);
            this.saldoDevedor.add(devedor);
        }

        public Integer getPrevisto(int pos) {
            return this.previstos.get(pos);
        }

        public Integer getEnviado(int pos) {
            return this.enviados.get(pos);
        }

        public Integer getRecebido(int pos) {
            return this.recebidos.get(pos);
        }

        public Integer getSomatorioPrevisto() {
            Integer sum = 0;
            for (int i = 0; i < this.previstos.size(); ++i) {
                sum = sum + this.previstos.get(i);
            }
            return sum;
        }

        public Integer getSomatorioEnviado() {
            Integer sum = 0;
            for (int i = 0; i < this.enviados.size(); ++i) {
                sum = sum + this.enviados.get(i);
            }
            return sum;
        }

        public Integer getSomatorioRecebido() {
            Integer sum = 0;
            for (int i = 0; i < this.recebidos.size(); ++i) {
                sum = sum + this.recebidos.get(i);
            }
            return sum;
        }

        public Integer getSomatorioDevedor() {
            Integer sum = 0;
            for (int i = 0; i < this.saldoDevedor.size(); ++i) {
                sum = sum + this.saldoDevedor.get(i);
            }
            return sum;
        }

        public boolean isOk() {
            Integer somaRecebido;
            Integer somaPrevisto = this.getSomatorioPrevisto();
            return somaPrevisto.equals(somaRecebido = this.getSomatorioRecebido());
        }
    }

    class DetalhesRota {
        RotaVO rota = null;
        Date data = null;
        Integer dow = null;
        DetalhesConvenioRota dadosConvenioRota = null;

        public DetalhesRota(RotaVO rota, Date data, Integer dow) {
            this.rota = rota;
            this.data = data;
            this.dow = dow;
            this.dadosConvenioRota = new DetalhesConvenioRota();
        }

        public void adicionaConvenio(ConvenioVO convenio, Integer previsto, Integer enviado, Integer recebido, Integer devedor) {
            if (this.dadosConvenioRota == null) {
                return;
            }
            this.dadosConvenioRota.adicionarValoresConvenio(convenio, previsto, enviado, recebido, devedor);
        }

        public boolean isOk() {
            return this.dadosConvenioRota.isOk();
        }
    }

    class ArrayRotas {
        ArrayList<DetalhesRota> rotas = new ArrayList();

        public void adicionaRota(DetalhesRota det) {
            if (this.rotas == null) {
                return;
            }
            this.rotas.add(det);
        }

        public void adicionaRota(RotaVO rota, Date data, Integer dow, ConvenioVO convenio, Integer previsto, Integer enviado, Integer recebido) {
            if (this.rotas == null) {
                return;
            }
            boolean encontrado = false;
            for (int i = 0; i < this.rotas.size(); ++i) {
                DetalhesRota rotaAux = this.rotas.get(i);
                if (rotaAux.rota.getCodigo().intValue() != rota.getCodigo().intValue() || !rotaAux.data.equals(data)) continue;
                rotaAux.adicionaConvenio(convenio, previsto, enviado, recebido, previsto - recebido);
                encontrado = true;
                break;
            }
            if (!encontrado) {
                DetalhesRota det = new DetalhesRota(rota, data, dow);
                det.adicionaConvenio(convenio, previsto, enviado, recebido, previsto - recebido);
                this.rotas.add(det);
            }
        }

        public int size() {
            if (this.rotas == null) {
                return -1;
            }
            return this.rotas.size();
        }

        public DetalhesRota get(int pos) {
            if (this.rotas != null) {
                return this.rotas.get(pos);
            }
            return null;
        }

        public DetalhesRota getDetalhesMaiorDataRota(RotaVO rotaParam) {
            Date dataAux = null;
            int posAux = -1;
            for (int i = 0; i < this.rotas.size(); ++i) {
                DetalhesRota detAux = this.rotas.get(i);
                if (detAux.rota.getCodigo().intValue() != rotaParam.getCodigo().intValue() || dataAux != null && !dataAux.before(detAux.data)) continue;
                dataAux = detAux.data;
                posAux = i;
            }
            if (posAux == -1) {
                return null;
            }
            return this.rotas.get(posAux);
        }

        public ArrayList<RotaVO> getListaRotas() {
            ArrayList<RotaVO> aux = new ArrayList<RotaVO>();
            for (int i = 0; i < this.rotas.size(); ++i) {
                boolean isAdicionado = false;
                for (int j = 0; j < aux.size(); ++j) {
                    if (aux.get(j).getCodigo().intValue() != this.rotas.get((int)i).rota.getCodigo().intValue()) continue;
                    isAdicionado = true;
                    break;
                }
                if (isAdicionado) continue;
                aux.add(this.rotas.get((int)i).rota);
            }
            return aux;
        }
    }

    class TelaDetalhesConvenioRota
    extends JDialog {
        ModeloGridTable modeloRota;
        JTable tableRota;
        JScrollPane scrollRota;
        JPanel panelBotao;
        JButton buttonOK;

        public TelaDetalhesConvenioRota(JFrame owner, DetalhesRota detalhesRota) {
            super(owner);
            this.modeloRota = new ModeloGridTable(new String[]{"Conv\u00eanio", "Previsto", "Enviado", "Recebido", "Diferen\u00e7a"});
            this.tableRota = new JTable(this.modeloRota);
            this.scrollRota = new JScrollPane(this.tableRota);
            this.panelBotao = new JPanel(new FlowLayout(2));
            this.buttonOK = new JButton("OK");
            this.buttonOK.setMnemonic('O');
            this.panelBotao.add(this.buttonOK);
            this.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TelaDetalhesConvenioRota.this.setVisible(false);
                }
            });
            this.setLayout(new BorderLayout());
            this.add((Component)this.scrollRota, "Center");
            this.add((Component)this.panelBotao, "South");
            this.setTitle("Detalhes: \"" + detalhesRota.rota.getDescricao() + " - " + Funcoes.formataData("dd/MM/yyyy", detalhesRota.data) + "\"");
            this.setSize(500, 440);
            this.setLocationRelativeTo(owner);
            this.setModal(true);
            this.modeloRota.setColumnSize(new int[]{0, 80, 80, 80, 120}, this.tableRota);
            this.tableRota.getTableHeader().addMouseListener(this.modeloRota);
            this.tableRota.setDefaultRenderer(Object.class, new RendererConvenioRota());
            this.preencheDadosConvenios(detalhesRota.dadosConvenioRota);
        }

        private void preencheDadosConvenios(DetalhesConvenioRota rota) {
            if (rota == null) {
                return;
            }
            for (int i = 0; i < rota.size(); ++i) {
                this.modeloRota.addLine(new Object[]{rota.getConvenio(i).getFantasia(), rota.getPrevisto(i), rota.getEnviado(i), rota.getRecebido(i), rota.getSaldoDevedor(i)});
            }
        }

        class RendererConvenioRota
        extends DefaultTableCellRenderer {
            RendererConvenioRota() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                Integer diferenca = (Integer)TelaDetalhesConvenioRota.this.modeloRota.getValueAt(row, TelaDetalhesConvenioRota.this.modeloRota.findColumn("Diferen\u00e7a"));
                if (diferenca > 0) {
                    this.setForeground(Color.RED);
                } else if (diferenca < 0) {
                    this.setForeground(new Color(20, 160, 15));
                } else {
                    this.setForeground(table.getForeground());
                }
                if (column == TelaDetalhesConvenioRota.this.modeloRota.findColumn("Diferen\u00e7a")) {
                    if (diferenca > 0) {
                        this.setText(diferenca + " (devedor)");
                    } else if (diferenca < 0) {
                        this.setText(diferenca * -1 + " (excedente)");
                    }
                }
                return this;
            }
        }
    }

    class Rotas
    extends JPanel {
        private JPanel panelNomeRota = new JPanel(new FlowLayout(1));
        private JPanel panelDadosRota = new JPanel(new GridBagLayout()){

            @Override
            public void paint(Graphics g) {
                g.drawImage(Rotas.this.image, 0, (this.getHeight() - Rotas.this.image.getHeight(null)) / 2, null);
                super.paintChildren(g);
            }
        };
        private JLabel labelNomeRota = new JLabel();
        private JLabel labelPrevisto = new JLabel("Previsto: ");
        private JLabel labelEnviado = new JLabel("Enviado: ");
        private JLabel labelRecebido = new JLabel("Recebido: ");
        private JLabel labelDevedor = new JLabel("Devedor: ");
        private JLabel labelVlrPrevisto = new JLabel();
        private JLabel labelVlrEnviado = new JLabel();
        private JLabel labelVlrRecebido = new JLabel();
        private JLabel labelVlrDevedor = new JLabel();
        private Image image = null;

        public Rotas(final DetalhesRota detalhesRota) {
            boolean isOk = detalhesRota.isOk();
            this.image = isOk ? ImagemUtils.carregaImagemJalis("rota_on.jpg").getImage() : ImagemUtils.carregaImagemJalis("rota_off.jpg").getImage();
            this.setPreferredSize(new Dimension(PrevisaoRecebimentoMaterial.this.LARGURA_PANEL_ROTA, 100));
            this.setMinimumSize(new Dimension(PrevisaoRecebimentoMaterial.this.LARGURA_PANEL_ROTA, 100));
            this.setMaximumSize(new Dimension(PrevisaoRecebimentoMaterial.this.LARGURA_PANEL_ROTA, 100));
            this.setLayout(new FlowLayout(1));
            Color corFundo = new Color(255, 255, 255, 200);
            Color corFundoDevedor = new Color(255, 0, 0, 150);
            Color corFundoSobra = new Color(0, 255, 0, 150);
            this.labelNomeRota.setText("<html><center>" + detalhesRota.rota.getDescricao() + "<br>" + Funcoes.formataData("dd/MM/yyyy", detalhesRota.data) + "</html>");
            this.labelNomeRota.setHorizontalAlignment(0);
            this.labelNomeRota.setFont(this.panelNomeRota.getFont().deriveFont(this.panelNomeRota.getFont().getSize() + 2));
            this.labelNomeRota.setFont(this.panelNomeRota.getFont().deriveFont(1));
            this.labelNomeRota.setBackground(corFundo);
            this.labelPrevisto.setText("Previsto: ");
            this.labelPrevisto.setHorizontalAlignment(2);
            this.labelPrevisto.setBackground(corFundo);
            this.labelVlrPrevisto.setText(detalhesRota.dadosConvenioRota.getSomatorioPrevisto().toString());
            this.labelVlrPrevisto.setHorizontalAlignment(4);
            this.labelVlrPrevisto.setBackground(corFundo);
            this.labelVlrPrevisto.setOpaque(true);
            this.labelDevedor.setText("Devedor: ");
            this.labelDevedor.setHorizontalAlignment(2);
            this.labelDevedor.setOpaque(true);
            if (detalhesRota.dadosConvenioRota.getSomatorioDevedor() > 0) {
                this.labelDevedor.setBackground(corFundoDevedor);
                this.labelVlrDevedor.setText(detalhesRota.dadosConvenioRota.getSomatorioDevedor().toString());
            } else if (detalhesRota.dadosConvenioRota.getSomatorioDevedor() < 0) {
                this.labelDevedor.setText("Excedente: ");
                this.labelDevedor.setBackground(corFundoSobra);
                Integer qtde = detalhesRota.dadosConvenioRota.getSomatorioDevedor() * -1;
                this.labelVlrDevedor.setText(qtde.toString());
            } else {
                this.labelVlrDevedor.setText("0");
            }
            this.labelVlrDevedor.setHorizontalAlignment(4);
            this.labelVlrDevedor.setBackground(this.labelDevedor.getBackground());
            this.labelVlrDevedor.setOpaque(true);
            this.labelEnviado.setText("Enviado: ");
            this.labelEnviado.setHorizontalAlignment(2);
            this.labelEnviado.setBackground(corFundo);
            this.labelEnviado.setOpaque(true);
            this.labelVlrEnviado.setText(detalhesRota.dadosConvenioRota.getSomatorioEnviado().toString());
            this.labelVlrEnviado.setHorizontalAlignment(4);
            this.labelVlrEnviado.setBackground(corFundo);
            this.labelVlrEnviado.setOpaque(true);
            this.labelRecebido.setText("Recebido: ");
            this.labelRecebido.setHorizontalAlignment(2);
            this.labelRecebido.setBackground(corFundo);
            this.labelRecebido.setOpaque(true);
            this.labelVlrRecebido.setText(detalhesRota.dadosConvenioRota.getSomatorioRecebido().toString());
            this.labelVlrRecebido.setHorizontalAlignment(4);
            this.labelVlrRecebido.setBackground(corFundo);
            this.labelVlrRecebido.setOpaque(true);
            this.setBackground(Color.WHITE);
            this.setLayout(new BorderLayout());
            this.add((Component)this.labelNomeRota, "North");
            this.add((Component)this.panelDadosRota, "Center");
            this.panelDadosRota.setOpaque(false);
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 1;
            c.anchor = 17;
            c.fill = 0;
            c.gridheight = 4;
            c.weightx = 1.0;
            c.fill = 2;
            this.panelDadosRota.add((Component)new JLabel(), c);
            c.gridx = 2;
            c.gridy = 1;
            c.gridheight = 1;
            c.weightx = 0.0;
            c.fill = 0;
            c.anchor = 13;
            this.panelDadosRota.add((Component)this.labelPrevisto, c);
            ++c.gridx;
            c.fill = 2;
            c.anchor = 17;
            this.panelDadosRota.add((Component)this.labelVlrPrevisto, c);
            c.gridx = 2;
            ++c.gridy;
            c.anchor = 13;
            c.fill = 0;
            this.panelDadosRota.add((Component)this.labelEnviado, c);
            ++c.gridx;
            c.fill = 2;
            c.anchor = 17;
            this.panelDadosRota.add((Component)this.labelVlrEnviado, c);
            c.gridx = 1;
            c.gridwidth = 2;
            ++c.gridy;
            c.anchor = 13;
            c.fill = 0;
            this.panelDadosRota.add((Component)this.labelRecebido, c);
            c.gridwidth = 1;
            c.gridx = 3;
            c.fill = 2;
            c.anchor = 17;
            this.panelDadosRota.add((Component)this.labelVlrRecebido, c);
            c.gridx = 2;
            ++c.gridy;
            c.anchor = 12;
            c.fill = 0;
            this.panelDadosRota.add((Component)this.labelDevedor, c);
            ++c.gridx;
            c.fill = 2;
            c.anchor = 18;
            this.panelDadosRota.add((Component)this.labelVlrDevedor, c);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    TelaDetalhesConvenioRota telaDetalhes = new TelaDetalhesConvenioRota(Laboratorio.getInstancia(), detalhesRota);
                    telaDetalhes.setVisible(true);
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    PrevisaoRecebimentoMaterial.this.setCursor(Cursor.getPredefinedCursor(12));
                    Rotas.this.setBorder(BorderFactory.createLineBorder(Color.GRAY, 1));
                    Rotas.this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    PrevisaoRecebimentoMaterial.this.setCursor(Cursor.getPredefinedCursor(0));
                    Rotas.this.setBorder(null);
                    Rotas.this.repaint();
                }
            });
        }
    }

    class TotalDiasSemana
    extends DiasSemana {
        public TotalDiasSemana(Integer previsto, Integer recebido, Integer enviado, Integer devedor, boolean isEnabledParam) {
            this.isEnabled = isEnabledParam;
            this.isOk = devedor <= 0;
            this.setOpaque(false);
            this.setBackground(Color.WHITE);
            this.setMinimumSize(new Dimension(PrevisaoRecebimentoMaterial.this.LARGURA_PANEL_DIA_SEMANA, 80));
            this.setPreferredSize(new Dimension(PrevisaoRecebimentoMaterial.this.LARGURA_PANEL_DIA_SEMANA, 80));
            this.setMaximumSize(new Dimension(PrevisaoRecebimentoMaterial.this.LARGURA_PANEL_DIA_SEMANA, 80));
            if (this.isEnabled) {
                if (this.isOk) {
                    this.setToolTipText("Materiais recebidos");
                } else {
                    this.setToolTipText("Devendo material");
                }
            }
            this.image = this.isEnabled ? (this.isOk ? ImagemUtils.carregaImagemJalis("logistica_on.jpg").getImage() : ImagemUtils.carregaImagemJalis("logistica_off.jpg").getImage()) : ImagemUtils.carregaImagemJalis("logistica_dis.jpg").getImage();
            this.setLayout(new FlowLayout(1));
            Color corFundo = new Color(255, 255, 255, 200);
            Color corFundoDevedor = new Color(255, 0, 0, 150);
            Color corFundoSobra = new Color(0, 255, 0, 150);
            this.labelDiaSemana.setText("TOTAL");
            this.labelDiaSemana.setHorizontalAlignment(0);
            this.labelDiaSemana.setFont(this.labelDiaSemana.getFont().deriveFont(this.labelDiaSemana.getFont().getSize() + 1));
            this.labelDiaSemana.setFont(this.labelDiaSemana.getFont().deriveFont(1));
            this.labelDiaSemana.setOpaque(true);
            this.labelDiaSemana.setBackground(Color.WHITE);
            this.labelPrevisto.setText("Previsto: ");
            this.labelPrevisto.setHorizontalAlignment(2);
            this.labelPrevisto.setBackground(this.isEnabled ? corFundo : Color.LIGHT_GRAY);
            this.labelPrevisto.setOpaque(true);
            this.labelVlrPrevisto.setText(previsto.toString());
            this.labelVlrPrevisto.setHorizontalAlignment(4);
            this.labelVlrPrevisto.setBackground(this.isEnabled ? corFundo : Color.LIGHT_GRAY);
            this.labelVlrPrevisto.setOpaque(true);
            this.labelDevedor.setHorizontalAlignment(2);
            this.labelDevedor.setOpaque(true);
            this.labelVlrDevedor.setHorizontalAlignment(4);
            this.labelVlrDevedor.setOpaque(true);
            this.labelDevedor.setText("Devedor: ");
            if (devedor > 0) {
                this.labelDevedor.setBackground(this.isEnabled ? corFundoDevedor : Color.LIGHT_GRAY);
                this.labelVlrDevedor.setBackground(this.isEnabled ? corFundoDevedor : Color.LIGHT_GRAY);
                this.labelVlrDevedor.setText(devedor.toString());
            } else if (devedor < 0) {
                this.labelDevedor.setBackground(this.isEnabled ? corFundoSobra : Color.LIGHT_GRAY);
                this.labelVlrDevedor.setBackground(this.isEnabled ? corFundoSobra : Color.LIGHT_GRAY);
                this.labelDevedor.setText("Excedente: ");
                Integer aux = devedor * -1;
                this.labelVlrDevedor.setText(aux.toString());
            } else {
                this.labelVlrDevedor.setText("0");
            }
            this.labelEnviado.setText("Enviado: ");
            this.labelEnviado.setHorizontalAlignment(2);
            this.labelEnviado.setBackground(this.isEnabled ? corFundo : Color.LIGHT_GRAY);
            this.labelEnviado.setOpaque(true);
            this.labelVlrEnviado.setText(enviado.toString());
            this.labelVlrEnviado.setHorizontalAlignment(4);
            this.labelVlrEnviado.setBackground(this.isEnabled ? corFundo : Color.LIGHT_GRAY);
            this.labelVlrEnviado.setOpaque(true);
            this.labelRecebido.setText("Recebido: ");
            this.labelRecebido.setHorizontalAlignment(2);
            this.labelRecebido.setBackground(this.isEnabled ? corFundo : Color.LIGHT_GRAY);
            this.labelRecebido.setOpaque(true);
            this.labelVlrRecebido.setText(recebido.toString());
            this.labelVlrRecebido.setHorizontalAlignment(4);
            this.labelVlrRecebido.setBackground(this.isEnabled ? corFundo : Color.LIGHT_GRAY);
            this.labelVlrRecebido.setOpaque(true);
            this.setLayout(new BorderLayout());
            this.add((Component)this.labelDiaSemana, "North");
            this.add((Component)this.panelDados, "Center");
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 1;
            c.anchor = 17;
            c.fill = 0;
            c.gridheight = 4;
            c.weightx = 1.0;
            c.fill = 2;
            this.panelDados.add((Component)new JLabel(), c);
            c.gridx = 2;
            c.gridy = 1;
            c.gridheight = 1;
            c.weightx = 0.0;
            c.fill = 0;
            c.anchor = 13;
            this.panelDados.add((Component)this.labelPrevisto, c);
            ++c.gridx;
            c.fill = 2;
            c.anchor = 17;
            this.panelDados.add((Component)this.labelVlrPrevisto, c);
            c.gridx = 2;
            ++c.gridy;
            c.anchor = 13;
            c.fill = 0;
            this.panelDados.add((Component)this.labelEnviado, c);
            ++c.gridx;
            c.fill = 2;
            c.anchor = 17;
            this.panelDados.add((Component)this.labelVlrEnviado, c);
            c.gridx = 1;
            c.gridwidth = 2;
            ++c.gridy;
            c.anchor = 13;
            c.fill = 0;
            this.panelDados.add((Component)this.labelRecebido, c);
            c.gridwidth = 1;
            c.gridx = 3;
            c.fill = 2;
            c.anchor = 17;
            this.panelDados.add((Component)this.labelVlrRecebido, c);
            c.gridx = 2;
            ++c.gridy;
            c.anchor = 12;
            c.fill = 0;
            this.panelDados.add((Component)this.labelDevedor, c);
            ++c.gridx;
            c.fill = 2;
            c.anchor = 18;
            this.panelDados.add((Component)this.labelVlrDevedor, c);
        }
    }

    class DiasSemana
    extends JPanel {
        protected JLabel labelDiaSemana = new JLabel();
        protected JLabel labelPrevisto = new JLabel("Previsto: ");
        protected JLabel labelDevedor = new JLabel("Devedor: ");
        protected JLabel labelEnviado = new JLabel("Enviado: ");
        protected JLabel labelRecebido = new JLabel("Recebido: ");
        protected JLabel labelVlrPrevisto = new JLabel();
        protected JLabel labelVlrDevedor = new JLabel();
        protected JLabel labelVlrEnviado = new JLabel();
        protected JLabel labelVlrRecebido = new JLabel();
        protected JPanel panelDados = new JPanel(new GridBagLayout()){

            @Override
            public void paint(Graphics g) {
                g.drawImage(DiasSemana.this.image, 0, (this.getHeight() - DiasSemana.this.image.getHeight(null)) / 2, null);
                super.paintChildren(g);
            }
        };
        private Integer dow = null;
        private ArrayRotas rotas = null;
        private Integer previsto = 0;
        private Integer enviado = 0;
        private Integer recebido = 0;
        private Integer devedor = 0;
        boolean isOk = true;
        boolean isEnabled = false;
        boolean isSelected = false;
        protected Image image = null;

        public DiasSemana(Integer dow, ArrayRotas todasRotas, boolean isEnabledParam) {
            this.dow = dow;
            this.isEnabled = isEnabledParam;
            this.setOpaque(false);
            this.setBackground(Color.WHITE);
            this.setMinimumSize(new Dimension(PrevisaoRecebimentoMaterial.this.LARGURA_PANEL_DIA_SEMANA, 80));
            this.setPreferredSize(new Dimension(PrevisaoRecebimentoMaterial.this.LARGURA_PANEL_DIA_SEMANA, 80));
            this.setMaximumSize(new Dimension(PrevisaoRecebimentoMaterial.this.LARGURA_PANEL_DIA_SEMANA, 80));
            this.rotas = new ArrayRotas();
            this.preencheDadosRotas(todasRotas);
            if (this.isEnabled) {
                if (this.isOk) {
                    this.setToolTipText("Materiais recebidos");
                } else {
                    this.setToolTipText("Devendo material");
                }
            }
            this.image = this.isEnabled ? (this.isOk ? ImagemUtils.carregaImagemJalis("logistica_on.jpg").getImage() : ImagemUtils.carregaImagemJalis("logistica_off.jpg").getImage()) : ImagemUtils.carregaImagemJalis("logistica_dis.jpg").getImage();
            this.setLayout(new FlowLayout(1));
            Color corFundo = new Color(255, 255, 255, 200);
            Color corFundoDevedor = new Color(255, 0, 0, 150);
            Color corFundoSobra = new Color(0, 255, 0, 150);
            this.labelDiaSemana.setText(this.getExtenso());
            this.labelDiaSemana.setHorizontalAlignment(0);
            this.labelDiaSemana.setVerticalAlignment(0);
            this.labelDiaSemana.setFont(this.labelDiaSemana.getFont().deriveFont(this.labelDiaSemana.getFont().getSize() + 2));
            this.labelDiaSemana.setFont(this.labelDiaSemana.getFont().deriveFont(1));
            this.labelDiaSemana.setOpaque(true);
            this.labelDiaSemana.setBackground(Color.WHITE);
            this.labelPrevisto.setText("Previsto: ");
            this.labelPrevisto.setHorizontalAlignment(2);
            this.labelPrevisto.setBackground(this.isEnabled ? corFundo : Color.LIGHT_GRAY);
            this.labelPrevisto.setOpaque(true);
            this.labelVlrPrevisto.setText(this.previsto.toString());
            this.labelVlrPrevisto.setHorizontalAlignment(4);
            this.labelVlrPrevisto.setBackground(this.isEnabled ? corFundo : Color.LIGHT_GRAY);
            this.labelVlrPrevisto.setOpaque(true);
            this.labelDevedor.setText("Devedor: ");
            if (this.devedor > 0) {
                this.labelDevedor.setBackground(this.isEnabled ? corFundoDevedor : Color.LIGHT_GRAY);
                this.labelVlrDevedor.setText(this.devedor.toString());
            } else if (this.devedor < 0) {
                this.labelDevedor.setBackground(this.isEnabled ? corFundoSobra : Color.LIGHT_GRAY);
                this.labelDevedor.setText("Excedente: ");
                Integer aux = this.devedor * -1;
                this.labelVlrDevedor.setText(aux.toString());
            } else {
                this.labelVlrDevedor.setText("0");
            }
            this.labelDevedor.setHorizontalAlignment(2);
            this.labelDevedor.setOpaque(true);
            this.labelVlrDevedor.setHorizontalAlignment(4);
            this.labelVlrDevedor.setOpaque(true);
            this.labelEnviado.setText("Enviado: ");
            this.labelEnviado.setHorizontalAlignment(2);
            this.labelEnviado.setBackground(this.isEnabled ? corFundo : Color.LIGHT_GRAY);
            this.labelEnviado.setOpaque(true);
            this.labelVlrEnviado.setText(this.enviado.toString());
            this.labelVlrEnviado.setHorizontalAlignment(4);
            this.labelVlrEnviado.setBackground(this.isEnabled ? corFundo : Color.LIGHT_GRAY);
            this.labelVlrEnviado.setOpaque(true);
            this.labelRecebido.setText("Recebido: ");
            this.labelRecebido.setHorizontalAlignment(2);
            this.labelRecebido.setBackground(this.isEnabled ? corFundo : Color.LIGHT_GRAY);
            this.labelRecebido.setOpaque(true);
            this.labelVlrRecebido.setText(this.recebido.toString());
            this.labelVlrRecebido.setHorizontalAlignment(4);
            this.labelVlrRecebido.setBackground(this.isEnabled ? corFundo : Color.LIGHT_GRAY);
            this.labelVlrRecebido.setOpaque(true);
            this.setLayout(new BorderLayout());
            this.add((Component)this.labelDiaSemana, "North");
            this.add((Component)this.panelDados, "Center");
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 1;
            c.anchor = 17;
            c.fill = 0;
            c.gridheight = 4;
            c.weightx = 1.0;
            c.fill = 2;
            this.panelDados.add((Component)new JLabel(), c);
            c.gridx = 2;
            c.gridy = 1;
            c.gridheight = 1;
            c.weightx = 0.0;
            c.fill = 0;
            c.anchor = 13;
            this.panelDados.add((Component)this.labelPrevisto, c);
            ++c.gridx;
            c.fill = 2;
            c.anchor = 17;
            this.panelDados.add((Component)this.labelVlrPrevisto, c);
            c.gridx = 2;
            ++c.gridy;
            c.anchor = 13;
            c.fill = 0;
            this.panelDados.add((Component)this.labelEnviado, c);
            ++c.gridx;
            c.fill = 2;
            c.anchor = 17;
            this.panelDados.add((Component)this.labelVlrEnviado, c);
            c.gridx = 1;
            c.gridwidth = 2;
            ++c.gridy;
            c.anchor = 13;
            c.fill = 0;
            this.panelDados.add((Component)this.labelRecebido, c);
            c.gridwidth = 1;
            c.gridx = 3;
            c.fill = 2;
            c.anchor = 17;
            this.panelDados.add((Component)this.labelVlrRecebido, c);
            c.gridx = 2;
            ++c.gridy;
            c.anchor = 12;
            c.fill = 0;
            this.panelDados.add((Component)this.labelDevedor, c);
            ++c.gridx;
            c.fill = 2;
            c.anchor = 18;
            this.panelDados.add((Component)this.labelVlrDevedor, c);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (DiasSemana.this.isEnabled) {
                        PainelDetalhesDiaSemana tela = new PainelDetalhesDiaSemana(DiasSemana.this.rotas);
                        PrevisaoRecebimentoMaterial.this.panelRotas.removeAll();
                        ((TitledBorder)PrevisaoRecebimentoMaterial.this.panelRotas.getBorder()).setTitle("Rotas - " + DiasSemana.this.getExtenso());
                        PrevisaoRecebimentoMaterial.this.panelRotas.setLayout(new BorderLayout());
                        PrevisaoRecebimentoMaterial.this.panelRotas.add((Component)tela, "Center");
                        PrevisaoRecebimentoMaterial.this.panelRotas.revalidate();
                        PrevisaoRecebimentoMaterial.this.panelRotas.repaint();
                        DiasSemana.this.selecionar();
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    PrevisaoRecebimentoMaterial.this.setCursor(Cursor.getPredefinedCursor(12));
                    if (DiasSemana.this.isEnabled) {
                        DiasSemana.this.setBorder(BorderFactory.createLineBorder(Color.GRAY, 1));
                    }
                    DiasSemana.this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    PrevisaoRecebimentoMaterial.this.setCursor(Cursor.getPredefinedCursor(0));
                    if (DiasSemana.this.isEnabled && !DiasSemana.this.isSelected) {
                        DiasSemana.this.setBorder(null);
                    }
                    DiasSemana.this.repaint();
                }
            });
        }

        public DiasSemana() {
        }

        public String getExtenso() {
            switch (this.dow) {
                case 0: {
                    return "DOMINGO";
                }
                case 1: {
                    return "SEGUNDA-FEIRA";
                }
                case 2: {
                    return "TER\u00c7A-FEIRA";
                }
                case 3: {
                    return "QUARTA-FEIRA";
                }
                case 4: {
                    return "QUINTA-FEIRA";
                }
                case 5: {
                    return "SEXTA-FEIRA";
                }
                case 6: {
                    return "S\u00c1BADO";
                }
            }
            return "";
        }

        public void preencheDadosRotas(ArrayRotas todasRotas) {
            boolean utilizado = false;
            for (int i = 0; i < todasRotas.size(); ++i) {
                DetalhesRota aux = todasRotas.get(i);
                if (aux.dow.intValue() != this.dow.intValue()) continue;
                utilizado = true;
                this.previsto = this.previsto + aux.dadosConvenioRota.getSomatorioPrevisto();
                this.enviado = this.enviado + aux.dadosConvenioRota.getSomatorioEnviado();
                this.recebido = this.recebido + aux.dadosConvenioRota.getSomatorioRecebido();
                if (!aux.isOk()) {
                    this.isOk = false;
                }
                this.rotas.adicionaRota(aux);
            }
            if (!utilizado) {
                this.isEnabled = false;
            }
            this.devedor = this.previsto - this.recebido;
        }

        public void selecionar() {
            Component[] comps = this.getParent().getComponents();
            for (int i = 0; i < comps.length; ++i) {
                if (!(comps[i] instanceof DiasSemana)) continue;
                ((DiasSemana)comps[i]).deselecionar();
            }
            this.setBorder(BorderFactory.createLineBorder(Color.GRAY, 1));
            this.isSelected = true;
        }

        public void deselecionar() {
            this.setBorder(null);
            this.isSelected = false;
        }
    }

    class PainelDetalhesDiaSemana
    extends JScrollPane {
        JPanel panelRotas;
        ArrayRotas rotas;

        public PainelDetalhesDiaSemana(ArrayRotas rotasParam) {
            super(new JPanel(new GridBagLayout()));
            this.panelRotas = null;
            this.rotas = new ArrayRotas();
            this.panelRotas = (JPanel)this.getViewport().getView();
            this.panelRotas.setBackground(Color.WHITE);
            this.setHorizontalScrollBarPolicy(31);
            this.setVerticalScrollBarPolicy(22);
            this.separaRotas(rotasParam);
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (PainelDetalhesDiaSemana.this.rotas != null) {
                        PainelDetalhesDiaSemana.this.mostraDadosRotas();
                    }
                }
            });
        }

        private void separaRotas(ArrayRotas arrayRotas) {
            for (int i = 0; i < arrayRotas.size(); ++i) {
                Rotas aux = new Rotas(arrayRotas.get(i));
                if (aux == null) continue;
                this.rotas.adicionaRota(arrayRotas.get(i));
            }
        }

        private void mostraDadosRotas() {
            this.panelRotas.removeAll();
            if (this.rotas != null && this.rotas.size() > 0) {
                int qtde = this.getWidth() / (PrevisaoRecebimentoMaterial.this.LARGURA_PANEL_ROTA + 15);
                GridBagConstraints c = new GridBagConstraints();
                c.anchor = 17;
                c.fill = 0;
                c.gridheight = 1;
                c.gridwidth = 1;
                c.gridx = 0;
                c.gridy = 0;
                c.insets = new Insets(5, 5, 5, 5);
                for (int i = 0; i < this.rotas.size(); ++i) {
                    Rotas aux = new Rotas(this.rotas.get(i));
                    if (aux == null) continue;
                    this.panelRotas.add((Component)aux, c);
                    if ((i + 1) % qtde == 0) {
                        c.gridx = 0;
                        ++c.gridy;
                        continue;
                    }
                    ++c.gridx;
                }
                ++c.gridy;
                c.gridx = 1;
                c.gridwidth = qtde;
                c.weightx = 1.0;
                c.weighty = 1.0;
                this.panelRotas.add((Component)new JLabel(), c);
            } else {
                this.panelRotas.setLayout(new BorderLayout());
                JLabel labelAux = new JLabel("Nenhuma rota para o dia da semana");
                labelAux.setHorizontalAlignment(0);
                this.panelRotas.add((Component)labelAux, "Center");
            }
            this.panelRotas.revalidate();
            this.panelRotas.repaint();
        }
    }

    class DadosConvenio {
        Integer codigoConvenio;
        Integer diaSemana;
        Integer qtde;

        public DadosConvenio(Integer codigoConvenio, Integer diaSemana, Integer qtde) {
            this.codigoConvenio = codigoConvenio;
            this.diaSemana = diaSemana;
            this.qtde = qtde;
        }
    }

    class AdaptadorTecla
    extends KeyAdapter {
        AdaptadorTecla() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 113) {
                if (e.getSource() == PrevisaoRecebimentoMaterial.this.textDataInicial) {
                    PrevisaoRecebimentoMaterial.this.buttonDataInicial.doClick();
                } else if (e.getSource() == PrevisaoRecebimentoMaterial.this.textDataFinal) {
                    PrevisaoRecebimentoMaterial.this.buttonDataFinal.doClick();
                }
            }
        }
    }
}

