/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.consultas.triagem;

import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.triagem.apoio.EnviarMaterial;
import jalis.laboratorio.util.impressao.ImprimirEtiquetasMaterialEnviado;
import jalis.laboratorio.util.impressao.ImprimirReciboMaterialEnviado;
import jalis.model.bean.triagem.MaterialEnviadoBean;
import jalis.model.bean.triagem.MaterialEnviadoMaterialBean;
import jalis.service.triagem.MaterialEnviadoService;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;

public class ConsultaMaterialEnviado
extends EnviarMaterial {
    private int codigo = -1;

    public ConsultaMaterialEnviado() {
        Funcoes.criaBarraDescricao(this, "Material Enviado", "Consulta de materiais enviados para apoio.", "consultas/consulta_material.jpg");
        this.buttonEnviar.setVisible(false);
        this.buttonCancelar.setVisible(false);
        this.controlaCampos();
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0701000300");
    }

    @Override
    protected void controlaCampos() {
        this.buttonNovo.setEnabled(true);
        this.buttonFechar.setEnabled(true);
        this.buttonCancelar.setEnabled(this.status != 1);
        this.buttonImprimir.setEnabled(this.status != 1 && this.codigo > 0);
        this.textCodigoConvenio.setEnabled(false);
        this.buttonBuscaConvenio.setEnabled(false);
        this.textCodigoPaciente.setEnabled(false);
        this.buttonBuscaPaciente.setEnabled(false);
        this.textCodigoMaterial.setEnabled(false);
        this.buttonBuscaMaterial.setEnabled(false);
        this.textCodigoCelulaOrigem.setEnabled(false);
        this.buttonBuscaCelulaOrigem.setEnabled(false);
        this.textQuantidadeMaterial.setEnabled(false);
        this.buttonOKMaterial.setEnabled(false);
        this.tabela.setEnabled(false);
    }

    @Override
    public void limparCampos() {
        super.limparCampos();
        this.codigo = -1;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonNovo) {
            this.limparCampos();
            this.status = 2;
            Hashtable pesquisa = Pesquisas.materialEnviado(Laboratorio.getInstancia());
            if (pesquisa != null) {
                String codigo;
                String string = codigo = pesquisa.get("men_codigo") != null ? pesquisa.get("men_codigo").toString() : null;
                if (codigo != null) {
                    try {
                        MaterialEnviadoBean matEnviado = (MaterialEnviadoBean)new MaterialEnviadoService().get(Variaveis.filialPadrao, codigo);
                        this.preencherDados(matEnviado);
                    }
                    catch (Exception e1) {
                        ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar dados.\n" + e1.getMessage(), e1.getStackTrace());
                    }
                }
            }
            this.controlaCampos();
        } else if (e.getSource() == this.buttonFechar) {
            this.setVisible(false);
        } else if (e.getSource() == this.buttonImprimir) {
            this.menu.show(this.buttonImprimir.getParent(), this.buttonImprimir.getX(), this.buttonImprimir.getY() + this.buttonImprimir.getHeight());
        } else if (e.getSource() == this.itemImprimirEtiqueta) {
            try {
                if (this.codigo > 0) {
                    ImprimirEtiquetasMaterialEnviado.imprimir(Variaveis.filialPadrao, String.valueOf(this.codigo), this.textCodigoConvenio.getText());
                }
            }
            catch (SQLException e1) {
                ErrorLogger.mostraMensagem(this, e1.getMessage(), e1.getStackTrace());
            }
        } else if (e.getSource() == this.itemImprimirRecibo) {
            try {
                if (this.codigo > 0) {
                    ImprimirReciboMaterialEnviado.imprimir(Variaveis.filialPadrao, String.valueOf(this.codigo), this.textCodigoConvenio.getText());
                }
            }
            catch (SQLException e1) {
                ErrorLogger.mostraMensagem(this, e1.getMessage(), e1.getStackTrace(), "EnviarMaterial (484)");
            }
        }
    }

    private void preencherDados(MaterialEnviadoBean matEnviado) {
        if (matEnviado == null) {
            return;
        }
        this.codigo = matEnviado.getCodigo();
        this.textCodigoCelulaOrigem.setText(matEnviado.getCelulaOrigem().getCodigo().toString());
        this.labelDescricaoCelulaOrigem.setText(matEnviado.getCelulaOrigem().getDescricao());
        this.textCodigoConvenio.setText(matEnviado.getConvenio().getCodigo().toString());
        this.labelDescricaoConvenio.setText(matEnviado.getConvenio().getFantasia());
        this.labelCodigoCelula.setText(matEnviado.getCelulaDestino().getCodigo().toString());
        this.labelDescricaoCelula.setText(matEnviado.getCelulaDestino().getDescricao());
        ArrayList<MaterialEnviadoMaterialBean> materiais = matEnviado.getListaMateriais();
        for (int i = 0; i < materiais.size(); ++i) {
            this.modelo.addLine(new Object[]{materiais.get(i).getMaterial().getCodigo(), materiais.get(i).getMaterial().getDescricao(), Funcoes.formataDecimal(materiais.get(i).getQuantidade())});
        }
    }
}

