/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.consultas.sms;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.ConsultarGraficoListener;
import jalis.comum.padroes.FrmGraficoPadrao;
import jalis.laboratorio.exportacao.thread.ExportaSMS;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Paint;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.NumberFormat;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import org.apache.commons.codec.binary.Base64;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieItemLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.ui.HorizontalAlignment;

public class ConsultaEnvioSms
extends FrmGraficoPadrao
implements ConsultarGraficoListener {
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_TIPO_SMS = "filtroTipoSms";
    private final String FILTRO_SITUACAO_SMS = "filtroSituacaoSms";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_HORA_INICIAL = "filtroHoraInicial";
    private final String FILTRO_HORA_FINAL = "filtroHoraFinal";
    private final String IMAGEM_GRAFICO = "imagemGrafico";
    private final String FILTRO_INTERVALO_HORA = "filtroIntervaloHora";
    public static final int CONSULTA_POR_TIPO = 0;
    public static final int CONSULTA_POR_SITUACAO = 1;
    private int tipoConsulta;
    protected static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"contagem", "tipoSms", "situacaosms"});

    public ConsultaEnvioSms(int tipo) {
        this.tipoConsulta = tipo;
        if (this.tipoConsulta == 0) {
            this.montaBarraDescricao("Envio de SMS por tipo", "Gr\u00e1fico de envio de sms por tipo", "consultas/sms_tipo.jpg");
        } else if (this.tipoConsulta == 1) {
            this.montaBarraDescricao("Envio de SMS por situa\u00e7\u00e3o", "Gr\u00e1fico de envio de sms por situa\u00e7\u00e3o", "consultas/sms_situacao.jpg");
        }
        this.adicionaConsultaListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroTipoSms", "Tipo", ExportaSMS.TipoSMS.getTipos(), new String[]{"Descri\u00e7\u00e3o"});
        this.adicionaItemFiltro("filtroSituacaoSms", "Situa\u00e7\u00e3o", Tipos.arrayTiposSMS, new String[]{"Descri\u00e7\u00e3o"});
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaFiltroHora("filtroHoraInicial", "Hora final:");
        this.adicionaFiltroHora("filtroHoraFinal", "Hora final:");
        this.adicionaFiltroCheck("filtroIntervaloHora", "Intervalo de hora", false);
        this.adicionaNomeVariavel("imagemGrafico");
        this.montaTela();
        this.setModuloConfigurar(ConsultaEnvioSms.getModuloConfigurar(this.tipoConsulta));
        this.setModuloAcesso(ConsultaEnvioSms.getModuloAcesso(this.tipoConsulta));
        this.setCamposConfigurador(campos);
    }

    @Override
    public void consultarGrafico() {
        String[] situacaoSms;
        String[] tipoSms;
        int total = 0;
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.habilitaBotaoConsultar(false);
        StringBuilder buf = new StringBuilder();
        if (this.tipoConsulta == 0) {
            buf.append("select sms_origem as tiposms, count(distinct (cast(a.fil_codigo as text)||a.sms_codigo)) as contagem, '' as situacaosms,");
        } else if (this.tipoConsulta == 1) {
            buf.append("select sms_situacao as situacaosms, count(distinct (cast(a.fil_codigo as text)||a.sms_codigo)) as contagem, '' as tiposms,");
        }
        buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
        buf.append("from logsms a ");
        buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
        String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
        if (filiais == null) {
            filiais = new String[]{Variaveis.filialPadrao};
        }
        buf.append(" where a.fil_codigo in (");
        for (int i = 0; i < filiais.length; ++i) {
            buf.append(filiais[i]);
            if (i >= filiais.length - 1) continue;
            buf.append(", ");
        }
        buf.append(") ");
        if (!this.getFiltroCheck("filtroIntervaloHora")) {
            if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                buf.append("  and cast(a.sms_datahora as date) >= '");
                buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataInicial")));
                buf.append("'");
            }
            if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                buf.append("  and cast(a.sms_datahora as date) <= '");
                buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataFinal")));
                buf.append("'");
            }
            if (Funcoes.verificaHora(this.getFiltroHora("filtroHoraInicial"))) {
                buf.append(" and date_trunc('minute',cast(a.sms_datahora as time)) >= '");
                buf.append(this.getFiltroHora("filtroHoraInicial"));
                buf.append("'");
            }
            if (Funcoes.verificaHora(this.getFiltroHora("filtroHoraFinal"))) {
                buf.append(" and date_trunc('minute',cast(a.sms_datahora as time)) <= '");
                buf.append(this.getFiltroHora("filtroHoraFinal"));
                buf.append("'");
            }
        } else {
            if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                buf.append("  and cast(a.sms_datahora as date) >= '");
                buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataInicial")) + " " + this.getFiltroHora("filtroHoraInicial"));
                buf.append("'");
            }
            if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                buf.append("  and cast(a.sms_datahora as date) <= '");
                buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataFinal")) + " " + this.getFiltroHora("filtroHoraInicial"));
                buf.append("'");
            }
        }
        if ((tipoSms = this.getSelecionadosFiltroArray("filtroTipoSms")) != null) {
            buf.append(" and a.sms_origem in (");
            for (int i = 0; i < tipoSms.length; ++i) {
                ExportaSMS.TipoSMS tipo = ExportaSMS.TipoSMS.get(tipoSms[i]);
                buf.append("'");
                buf.append(tipo.getCodigo());
                buf.append("'");
                if (i >= tipoSms.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if ((situacaoSms = this.getSelecionadosFiltroArray("filtroSituacaoSms")) != null) {
            buf.append(" and a.sms_situacao in (");
            for (int i = 0; i < situacaoSms.length; ++i) {
                buf.append("'");
                buf.append(Tipos.getCodigoSituacaoSMS(situacaoSms[i]));
                buf.append("'");
                if (i >= situacaoSms.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if (this.tipoConsulta == 0) {
            buf.append(" group by codigoFilial, tiposms, ");
            buf.append("filial.fil_codigo, filial.fil_descricao, filial.fil_cnpj, filial.fil_endereco, filial.fil_complemento, filial.fil_cep, filial.fil_fone, filial.fil_fax, filial.fil_razaosocial, filial.fil_cnes, cidadefilial.cid_codigo, cidadefilial.cid_nome, cidadefilial.cid_uf, bairrofilial.bai_codigo, bairrofilial.bai_descricao ");
            buf.append(" order by codigoFilial, tiposms");
        } else if (this.tipoConsulta == 1) {
            buf.append(" group by codigoFilial, situacaosms, ");
            buf.append("filial.fil_codigo, filial.fil_descricao, filial.fil_cnpj, filial.fil_endereco, filial.fil_complemento, filial.fil_cep, filial.fil_fone, filial.fil_fax, filial.fil_razaosocial, filial.fil_cnes, cidadefilial.cid_codigo, cidadefilial.cid_nome, cidadefilial.cid_uf, bairrofilial.bai_codigo, bairrofilial.bai_descricao ");
            buf.append(" order by codigoFilial, situacaosms");
        }
        try {
            Statement st = Conexao.getStatement();
            this.panelAbas.removeAll();
            this.panelCentro.removeAll();
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                boolean qtdeTotal = false;
                if (rs.next()) {
                    int i;
                    do {
                        total += rs.getInt("contagem");
                    } while (rs.next());
                    DefaultPieDataset pie = new DefaultPieDataset();
                    ModeloGridTable modelo = new ModeloGridTable(campos);
                    int outros = 0;
                    rs.first();
                    do {
                        ExportaSMS.TipoSMS tipo = null;
                        ExportaSMS.SituacaoSMS situacao = null;
                        if (this.tipoConsulta == 0) {
                            tipo = ExportaSMS.TipoSMS.get(rs.getString("tiposms"));
                        } else if (this.tipoConsulta == 1) {
                            situacao = ExportaSMS.SituacaoSMS.get(rs.getString("situacaosms"));
                        }
                        if (rs.getInt("contagem") * 100 / total < 1) {
                            outros += rs.getInt("contagem");
                        } else if (this.tipoConsulta == 0) {
                            pie.setValue((Comparable)((Object)tipo.getDescricao()), (double)rs.getInt("contagem"));
                        } else {
                            pie.setValue((Comparable)((Object)situacao.getDescricao()), (double)rs.getInt("contagem"));
                        }
                        Object[] o = new Object[campos.length];
                        for (int i2 = 0; i2 < campos.length; ++i2) {
                            if (this.tipoConsulta == 0) {
                                if (campos[i2].equalsIgnoreCase("tipoSms")) {
                                    o[modelo.findColumn((String)ConsultaEnvioSms.campos[i2])] = tipo.getDescricao();
                                    continue;
                                }
                                o[modelo.findColumn((String)ConsultaEnvioSms.campos[i2])] = rs.getObject(campos[i2]);
                                continue;
                            }
                            if (this.tipoConsulta != 1) continue;
                            o[modelo.findColumn((String)ConsultaEnvioSms.campos[i2])] = campos[i2].equalsIgnoreCase("situacaosms") ? situacao.getDescricao() : rs.getObject(campos[i2]);
                        }
                        modelo.addLine(o);
                    } while (rs.next());
                    NumberFormat nf = NumberFormat.getNumberInstance();
                    NumberFormat nfp = NumberFormat.getPercentInstance();
                    nfp.setMinimumFractionDigits(0);
                    nfp.setMaximumFractionDigits(2);
                    PiePlot plot = new PiePlot((PieDataset)pie);
                    StandardPieItemLabelGenerator labels = new StandardPieItemLabelGenerator("{0}: ({1}) {2}", nf, nfp);
                    plot.setLabelGenerator((PieSectionLabelGenerator)labels);
                    plot.setLabelFont(this.getFonteLegenda());
                    JFreeChart chart = new JFreeChart("Envio de SMS", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
                    TextTitle subtitulo = new TextTitle("Total de sms: " + total, TextTitle.DEFAULT_FONT, HorizontalAlignment.CENTER);
                    chart.addSubtitle((Title)subtitulo);
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                        var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                    }
                    if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                        var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                    }
                    if (Funcoes.verificaHora(this.getFiltroHora("filtroHoraInicial"))) {
                        var.put("filtroHoraInicial", this.getFiltroHora("filtroHoraInicial"));
                    }
                    if (Funcoes.verificaHora(this.getFiltroHora("filtroHoraFinal"))) {
                        var.put("filtroHoraFinal", this.getFiltroHora("filtroHoraFinal"));
                    }
                    var.put("filtroIntervaloHora", this.getFiltroCheck("filtroIntervaloHora") ? "Sim" : "N\u00e3o");
                    buf.delete(0, buf.length());
                    if (filiais != null) {
                        for (i = 0; i < filiais.length; ++i) {
                            buf.append(filiais[i]);
                            if (i >= filiais.length - 1) continue;
                            buf.append(",");
                        }
                    }
                    var.put("filtroFilial", buf.toString());
                    buf.delete(0, buf.length());
                    if (situacaoSms != null) {
                        for (i = 0; i < situacaoSms.length; ++i) {
                            buf.append(situacaoSms[i]);
                            if (i >= situacaoSms.length - 1) continue;
                            buf.append(",");
                        }
                    }
                    var.put("filtroSituacaoSms", buf.toString());
                    buf.delete(0, buf.length());
                    if (tipoSms != null) {
                        for (i = 0; i < tipoSms.length; ++i) {
                            buf.append(tipoSms[i]);
                            if (i >= tipoSms.length - 1) continue;
                            buf.append(",");
                        }
                    }
                    var.put("filtroTipoSms", buf.toString());
                    Paint bgColor = chart.getBackgroundPaint();
                    chart.setBackgroundPaint((Paint)Color.WHITE);
                    var.put("imagemGrafico", new Base64().encodeAsString(ImagemUtils.imageToByte(chart.createBufferedImage(1024, 768))));
                    chart.setBackgroundPaint(bgColor);
                    this.panelCentro.setLayout(new BorderLayout());
                    this.panelAbas.insertTab("Gr\u00e1fico", null, (Component)new ChartPanel(chart, false, false, false, false, true), "Gr\u00e1fico", 0);
                    this.panelAbas.insertTab("Relat\u00f3rio", null, new JPanel(), "Relat\u00f3rio", 1);
                    this.panelCentro.add((Component)this.panelAbas, "Center");
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    buf.append(ConsultaEnvioSms.getModuloAcesso(this.tipoConsulta));
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai((Container)this.panelAbas.getComponentAt(1));
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(0.5f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                ConsultaEnvioSms.this.panelCentro.removeAll();
                                ConsultaEnvioSms.this.panelCentro.repaint();
                                ConsultaEnvioSms.this.habilitaBotaoConsultar(true);
                            }
                        });
                        gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                        this.panelAbas.repaint();
                        this.panelAbas.revalidate();
                        this.panelCentro.repaint();
                        this.panelCentro.revalidate();
                    }
                } else {
                    Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                    this.habilitaBotaoConsultar(true);
                    this.panelCentro.repaint();
                }
                rs.close();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel gerar gr\u00e1fico.\n" + ex.getMessage(), ex.getStackTrace());
            }
            Conexao.fecharStatement(st);
            this.setCursor(Cursor.getDefaultCursor());
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel gerar gr\u00e1fico.\n" + ex.getMessage(), ex.getStackTrace());
        }
    }

    public static long getModuloAcesso(int tipo) {
        if (tipo == 0) {
            return Long.parseLong("0700501700");
        }
        return Long.parseLong("0700501800");
    }

    public static long getModuloConfigurar(int tipo) {
        if (tipo == 0) {
            return Long.parseLong("0700501701");
        }
        return Long.parseLong("0700501801");
    }

    @Override
    public void novo() {
        this.panelAbas.removeAll();
        this.panelCentro.removeAll();
        this.panelAbas.repaint();
        this.panelCentro.repaint();
        this.habilitaBotaoConsultar(true);
    }
}

