/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.consultas.recepcao;

import jalis.laboratorio.consultas.recepcao.LinhaTabelaReq;
import jalis.laboratorio.consultas.recepcao.MonitorPromessa;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.tabela.ObjectTableModel;
import java.awt.Color;
import java.awt.Component;
import java.util.Date;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

class ReqTableCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;

    ReqTableCellRenderer() {
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        int rowModel = table.getRowSorter().convertRowIndexToModel(row);
        LinhaTabelaReq linha = (LinhaTabelaReq)((ObjectTableModel)table.getModel()).getRow(rowModel);
        Date dataEntrega = linha.getDataEntregaPrev();
        if (dataEntrega != null && dataEntrega.before(new Date())) {
            this.setForeground(MonitorPromessa.COR_ATRASADO);
        } else if (dataEntrega != null && Funcoes.hoje(Funcoes.formataData(dataEntrega))) {
            this.setForeground(MonitorPromessa.COR_HOJE);
        } else {
            this.setForeground(table.getForeground());
        }
        if (table.getSelectedRow() == row) {
            c.setBackground(table.getSelectionBackground());
        } else if (linha.isUrgente()) {
            c.setBackground(MonitorPromessa.COR_URGENTE);
        } else {
            c.setBackground(Color.WHITE);
        }
        return c;
    }

    @Override
    protected void setValue(Object value) {
        if (value instanceof Date) {
            value = Funcoes.formataData("dd/MM/yy HH:mm", (Date)value);
        } else if (value instanceof List) {
            value = StringUtil.implode((List)value, ", ");
        }
        super.setValue(value);
    }
}

