/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.consultas.recepcao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.consultas.recepcao.BlinkLabel;
import jalis.laboratorio.consultas.recepcao.CustomJTable;
import jalis.laboratorio.consultas.recepcao.DialogConfiguracoes;
import jalis.laboratorio.consultas.recepcao.DialogFiltro;
import jalis.laboratorio.consultas.recepcao.LinhaTabelaDestino;
import jalis.laboratorio.consultas.recepcao.LinhaTabelaReq;
import jalis.laboratorio.consultas.recepcao.LinhaTabelaSetor;
import jalis.laboratorio.consultas.recepcao.ReqTableCellRenderer;
import jalis.laboratorio.consultas.recepcao.SetorTableCellRenderer;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.Legenda;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.ObjectTableModel;
import jalis.util.tabela.ObjectTableModelColumn;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.Timer;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieItemLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public class MonitorPromessa
extends FrmPadrao
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public static final Color COR_URGENTE = ScreenUtil.clarearCor(Color.RED, 200);
    public static final Color COR_ATRASADO = Color.RED;
    public static final Color COR_HOJE = Color.BLUE;
    public static final String PARAMETRO_OPCOES = "MonitorPromessa.opcoes";
    public static final String PARAMETRO_TABELAS_CONFIG = "MonitorPromessa.tabelasConfig";
    public static final String ID_TABELA_REQ = "requisicao";
    public static final String ID_TABELA_SETOR = "setor";
    public static final String ID_TABELA_DESTINO = "destino";
    public static final String ID_SPLIT_HORIZONTAL = "horizontal";
    public static final String ID_SPLIT_SETOR_DEST = "setorDestino";
    public static final String ID_SPLIT_REQ_GRAFICO = "requisicaoGrafico";
    public static final String ID_SPLIT_SET_DEST_GRAFICO = "setorDestinoGrafico";
    public static final int ID_GRAFICO_SETOR = 0;
    public static final int ID_GRAFICO_DESTINO = 1;
    private JFrame frameFullScreen;
    private GraphicsDevice screenDevice;
    private JPanel panelPrincipal;
    private JPanel panelReqAtraso;
    private JPanel panelRequisicoes;
    private JPanel panelAtrasados;
    private JPanel panelGrafico;
    private JPanel panelGraficoSet;
    private JPanel panelGraficoDest;
    private JPanel panelSetores;
    private JPanel panelDestinos;
    private JPanel panelBotoes;
    private JPanel panelBotoesEsquerda;
    private JPanel panelBotoesDireita;
    private JSplitPane splitSetorDestino;
    private JSplitPane splitRequisicaoGrafico;
    private JSplitPane splitHorizontal;
    private JSplitPane splitSetorDestinoGrafico;
    private Legenda legenda = new Legenda(10, Legenda.Orientacoes.HORIZONTAL);
    private BlinkLabel labelAtrasados = new BlinkLabel("");
    private JPopupMenu menuOpcoes = new JPopupMenu();
    private JMenuItem itemConfiguracoes = new JMenuItem("Configura\u00e7\u00f5es");
    private JMenuItem itemFiltros = new JMenuItem("Filtros");
    private JButton buttonOpcoes = ComponenteFactory.novoJButton("Op\u00e7oes \u25bc", this);
    private JButton buttonIniParar = ComponenteFactory.novoJButton("Iniciar", this);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", this);
    private JButton buttonFullScreen = ComponenteFactory.novoJButton("", this);
    private Icon iconeMaximizar;
    private Icon iconeMinimizar;
    private List<Integer> indicesColunasReqVisiveis;
    private List<Integer> indicesColunasSetVisiveis;
    private ObjectTableModel<LinhaTabelaReq> modeloRequisicoes;
    private ObjectTableModel<LinhaTabelaSetor> modeloSetores;
    private ObjectTableModel<LinhaTabelaDestino> modeloDestinos;
    private List<ObjectTableModelColumn> colunasReq;
    private List<ObjectTableModelColumn> colunasSetor;
    private List<ObjectTableModelColumn> colunasDestino;
    private CustomJTable tableRequisicoes;
    private CustomJTable tableSetores;
    private CustomJTable tableDestinos;
    private Map<String, LinhaTabelaReq> requisicoesById;
    private Map<String, LinhaTabelaSetor> setoresById;
    private Map<String, LinhaTabelaDestino> destinosById;
    private String[] filtroFiliais;
    private String[] filtroExames;
    private String[] filtroConvenios;
    private String[] filtroSetores;
    private String[] filtroColetas;
    private String[] filtroDestinos;
    private String[] filtroSituacoesReq;
    private String[] filtroSituacaoExames;
    private boolean filtroApresentarDigitadoParcial = false;
    private int intervaloSegundos = 5;
    private Date ultimaConsulta;
    private int retrocessoDias = 1;
    private int avancoHoras = 8;
    private int tamanhoFonte = 12;
    private boolean mostrarGrafico = false;
    private boolean avisoSonoro = false;
    private int tempoAlertarAtraso = 10;
    private String msgAviso = "";
    private int indexSelecionadoComboBox;
    private JProgressBar progressBar = new JProgressBar(0, this.intervaloSegundos * 1000);
    private Timer timer;
    private PreparedStatement prstExames;
    private boolean atualizarPrst = false;
    private boolean fullScreen = false;
    private double splitHorizontalLocal = 0.7;
    private double splitSetorDestinoLocal = 0.5;
    private double splitRequisicaoGraficoLocal = 0.7;
    private double splitSetorDestinoGraficoLocal = 0.5;
    private DefaultPieDataset pieSetor;
    private DefaultPieDataset pieDestino;
    private int avisoBeep = -1;
    private boolean exibirLegenda = false;

    public MonitorPromessa() {
        this.iniciaValores();
        this.desenha();
        this.carregaOpcoes();
        this.carregaTabelasConfig();
        this.timer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                long milisegundosDecorridos = new Date().getTime() - (MonitorPromessa.this.ultimaConsulta != null ? MonitorPromessa.this.ultimaConsulta.getTime() : 0L);
                MonitorPromessa.this.progressBar.setString(MonitorPromessa.this.intervaloSegundos + " seg.");
                MonitorPromessa.this.progressBar.setValue((int)milisegundosDecorridos);
                if (Math.round(milisegundosDecorridos / 1000L) >= MonitorPromessa.this.intervaloSegundos) {
                    MonitorPromessa.this.executaConsulta();
                }
            }
        });
        this.timer.setInitialDelay(0);
    }

    private void iniciaValores() {
        this.screenDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        this.frameFullScreen = new JFrame("Monitor de Promessa");
        this.frameFullScreen.getContentPane().setLayout(new BorderLayout());
        this.frameFullScreen.setUndecorated(true);
        this.panelPrincipal = new JPanel(new BorderLayout());
        this.panelRequisicoes = new JPanel(new BorderLayout());
        this.panelAtrasados = new JPanel(new BorderLayout());
        JPanel aux = new JPanel();
        this.panelAtrasados = ComponenteFactory.novoJPanelBorderLayout("", aux);
        this.panelReqAtraso = new JPanel();
        this.panelGrafico = new JPanel(new BorderLayout());
        this.panelGraficoSet = new JPanel(new BorderLayout());
        this.panelGraficoDest = new JPanel(new BorderLayout());
        this.panelSetores = new JPanel(new BorderLayout());
        this.panelDestinos = new JPanel(new BorderLayout());
        this.panelBotoesEsquerda = new JPanel(new FlowLayout(0));
        this.panelBotoesDireita = new JPanel(new FlowLayout(2));
        this.panelBotoes = new JPanel(new BorderLayout());
        this.splitSetorDestino = new JSplitPane(1, this.panelSetores, this.panelDestinos);
        this.splitSetorDestinoGrafico = new JSplitPane(0, this.panelGraficoSet, this.panelGraficoDest);
        this.splitRequisicaoGrafico = new JSplitPane(1, true);
        this.labelAtrasados.setText(this.msgAviso);
        this.labelAtrasados.setFont(new Font(this.labelAtrasados.getFont().getName(), 1, 16));
        this.panelReqAtraso.setLayout(new GridBagLayout());
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 1;
        cons.weightx = 1.0;
        cons.weighty = 0.9;
        cons.gridx = 0;
        cons.gridy = 0;
        this.panelReqAtraso.add((Component)this.panelRequisicoes, cons);
        ++cons.gridy;
        cons.weighty = 0.0;
        this.panelReqAtraso.add((Component)this.panelAtrasados, cons);
        this.panelAtrasados.setMaximumSize(new Dimension(100, 45));
        this.panelAtrasados.setMinimumSize(new Dimension(100, 45));
        this.panelAtrasados.setPreferredSize(new Dimension(100, 45));
        aux.setLayout(new GridBagLayout());
        cons.fill = 3;
        cons.weightx = 1.0;
        cons.weighty = 1.0;
        cons.gridx = 0;
        cons.gridy = 0;
        aux.setBackground(Color.RED);
        aux.add((Component)this.labelAtrasados, cons);
        this.splitRequisicaoGrafico.add(this.panelReqAtraso);
        this.panelAtrasados.setVisible(false);
        this.splitRequisicaoGrafico.add(this.panelGrafico);
        this.panelGrafico.add(this.splitSetorDestinoGrafico);
        JPanel gfSet = (JPanel)this.splitSetorDestinoGrafico.getComponent(0);
        gfSet.add((Component)new ChartPanel(this.geraGrafico(this.pieSetor, "Gr\u00e1fico Setor", this.exibirLegenda), false, false, false, false, true), "Center");
        JPanel gfDes = (JPanel)this.splitSetorDestinoGrafico.getComponent(1);
        gfDes.add((Component)new ChartPanel(this.geraGrafico(this.pieDestino, "Gr\u00e1fico Destino", this.exibirLegenda), false, false, false, false, true), "Center");
        this.splitHorizontal = new JSplitPane(0, this.splitRequisicaoGrafico, this.splitSetorDestino);
        this.iconeMaximizar = ImagemUtils.carregaImagemJalis("maximizar.png");
        this.iconeMinimizar = ImagemUtils.carregaImagemJalis("minimizar.png");
        this.buttonFullScreen.setIcon(this.iconeMaximizar);
        this.buttonFullScreen.setToolTipText("Tela Cheia");
        this.indicesColunasReqVisiveis = new ArrayList<Integer>();
        this.indicesColunasSetVisiveis = new ArrayList<Integer>();
        this.modeloRequisicoes = new ObjectTableModel<LinhaTabelaReq>(LinhaTabelaReq.class);
        this.modeloSetores = new ObjectTableModel<LinhaTabelaSetor>(LinhaTabelaSetor.class);
        this.modeloDestinos = new ObjectTableModel<LinhaTabelaDestino>(LinhaTabelaDestino.class);
        this.colunasSetor = new ArrayList<ObjectTableModelColumn>();
        this.colunasSetor.add(new ObjectTableModelColumn("Fil.", "filial"));
        this.colunasSetor.add(new ObjectTableModelColumn("Setor", "descricaoSetor"));
        this.colunasSetor.add(new ObjectTableModelColumn("A Fazer", "aFazer"));
        this.colunasSetor.add(new ObjectTableModelColumn("M\u00e9dia", "duracaoMediaExames"));
        this.colunasSetor.add(new ObjectTableModelColumn("Previs\u00e3o Total", "previsaoTotal"));
        this.colunasSetor.add(new ObjectTableModelColumn("Atrasados", "atrasados"));
        this.colunasReq = new ArrayList<ObjectTableModelColumn>();
        this.colunasReq.add(new ObjectTableModelColumn("Fil.", "filial"));
        this.colunasReq.add(new ObjectTableModelColumn("Requisi\u00e7\u00e3o", ID_TABELA_REQ));
        this.colunasReq.add(new ObjectTableModelColumn("Entrega prev.", "dataEntregaPrev"));
        this.colunasReq.add(new ObjectTableModelColumn("Paciente", "paciente"));
        this.colunasReq.add(new ObjectTableModelColumn("Exames", "exames"));
        this.colunasReq.add(new ObjectTableModelColumn("Setor", "descricaoSetor"));
        this.colunasReq.add(new ObjectTableModelColumn("Descri\u00e7\u00e3o", "descricaoDestino"));
        this.colunasReq.add(new ObjectTableModelColumn("Data Coleta", "dataColeta"));
        this.colunasDestino = new ArrayList<ObjectTableModelColumn>();
        this.colunasDestino.add(new ObjectTableModelColumn("Fil.", "filial"));
        this.colunasDestino.add(new ObjectTableModelColumn("Destino", "descricaoDestino"));
        this.colunasDestino.add(new ObjectTableModelColumn("A Fazer", "aFazer"));
        this.colunasDestino.add(new ObjectTableModelColumn("Atrasados", "atrasados"));
        try {
            this.modeloRequisicoes.setColumns(this.colunasReq);
            this.modeloSetores.setColumns(this.colunasSetor);
            this.modeloDestinos.setColumns(this.colunasDestino);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.tableRequisicoes = new CustomJTable(this.modeloRequisicoes, new int[]{4, 4, 0, 2, 2, 2, 2, 2}, ReqTableCellRenderer.class);
        this.tableSetores = new CustomJTable(this.modeloSetores, new int[]{4, 2, 4, 4, 4, 4}, SetorTableCellRenderer.class);
        this.tableDestinos = new CustomJTable(this.modeloDestinos, new int[]{4, 2, 4, 4});
        this.requisicoesById = new HashMap<String, LinhaTabelaReq>();
        this.setoresById = new HashMap<String, LinhaTabelaSetor>();
        this.destinosById = new HashMap<String, LinhaTabelaDestino>();
        this.panelRequisicoes.setBorder(BorderFactory.createTitledBorder("Requisi\u00e7\u00f5es"));
        this.panelSetores.setBorder(BorderFactory.createTitledBorder("Setores"));
        this.panelDestinos.setBorder(BorderFactory.createTitledBorder("Destinos"));
        this.buttonOpcoes.setDisplayedMnemonicIndex(0);
        this.buttonIniParar.setDisplayedMnemonicIndex(0);
        this.buttonFechar.setDisplayedMnemonicIndex(0);
        this.itemConfiguracoes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MonitorPromessa.this.abreConfig();
            }
        });
        this.itemFiltros.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MonitorPromessa.this.abreFiltros();
            }
        });
    }

    private void desenha() {
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Monitor de Promessas", "Mostra as promessas pendentes", "consultas/consulta_monitor_promessa.jpg");
        this.panelPrincipal.add((Component)this.splitHorizontal, "Center");
        this.panelPrincipal.add((Component)this.panelBotoes, "South");
        this.progressBar.setPreferredSize(new Dimension(80, 15));
        this.progressBar.setStringPainted(true);
        this.progressBar.setFont(new Font("Sans", 0, 10));
        this.progressBar.setBorder(BorderFactory.createLoweredBevelBorder());
        this.panelBotoesEsquerda.add(this.buttonOpcoes);
        this.panelBotoesDireita.add(this.progressBar);
        this.panelBotoesDireita.add(this.buttonIniParar);
        this.panelBotoesDireita.add(this.buttonFechar);
        this.panelBotoesDireita.add(this.buttonFullScreen);
        this.panelBotoes.add((Component)this.panelBotoesEsquerda, "West");
        this.panelBotoes.add((Component)this.panelBotoesDireita, "East");
        this.menuOpcoes.add(this.itemConfiguracoes);
        this.menuOpcoes.add(this.itemFiltros);
        JScrollPane scrollRequisicao = new JScrollPane(this.tableRequisicoes);
        JScrollPane scrollSetores = new JScrollPane(this.tableSetores);
        JScrollPane scrollDestino = new JScrollPane(this.tableDestinos);
        this.panelRequisicoes.add(scrollRequisicao);
        this.panelSetores.add(scrollSetores);
        this.panelDestinos.add(scrollDestino);
        this.legenda.addItem(COR_URGENTE, "Urgente");
        this.legenda.addItem(COR_ATRASADO, "Atrasado");
        this.legenda.addItem(COR_HOJE, "Hoje");
        this.panelBotoesEsquerda.add(this.legenda.getPanel());
        this.add((Component)this.panelPrincipal, "Center");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOpcoes) {
            this.menuOpcoes.show(this.panelBotoesEsquerda, this.buttonOpcoes.getX(), this.buttonOpcoes.getY() + this.buttonOpcoes.getHeight());
        } else if (e.getSource() == this.buttonFechar) {
            this.timer.stop();
            this.labelAtrasados.stop();
            this.labelAtrasados = null;
            this.timer = null;
            this.salvaTabelasConfig();
            if (this.fullScreen) {
                this.setFullScreen(false);
            }
            if (this.prstExames != null) {
                Conexao.fecharStatement(this.prstExames);
            }
            this.setVisible(false);
        } else if (e.getSource() == this.buttonIniParar) {
            this.iniciarParar();
        } else if (e.getSource() == this.buttonFullScreen) {
            this.trocaFullScreen();
        }
    }

    private void trocaFullScreen() {
        if (this.fullScreen) {
            this.setFullScreen(false);
            this.fullScreen = false;
            this.buttonFullScreen.setIcon(this.iconeMaximizar);
            this.buttonFullScreen.setToolTipText("Tela Cheia");
        } else {
            this.setFullScreen(true);
            this.fullScreen = true;
            this.buttonFullScreen.setIcon(this.iconeMinimizar);
            this.buttonFullScreen.setToolTipText("Tela Normal");
        }
    }

    private void setFullScreen(boolean flag) {
        if (flag) {
            this.remove(this.panelPrincipal);
            this.frameFullScreen.getContentPane().add((Component)this.panelPrincipal, "Center");
            try {
                this.screenDevice.setFullScreenWindow(this.frameFullScreen);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.frameFullScreen.getContentPane().remove(this.panelPrincipal);
            this.add((Component)this.panelPrincipal, "Center");
            this.revalidate();
            try {
                this.screenDevice.setFullScreenWindow(null);
                this.frameFullScreen.setVisible(false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static Long getModuloAcesso() {
        return Long.parseLong("0700600200");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void atualizaDados() {
        Date dataAtual = new Date();
        this.requisicoesById.clear();
        this.setoresById.clear();
        this.destinosById.clear();
        if (this.prstExames == null || this.atualizarPrst) {
            if (this.prstExames != null) {
                Conexao.fecharStatement(this.prstExames);
            }
            StringBuilder bui = new StringBuilder();
            bui.append("select a.fil_codigo, a.exa_codigo, a.exr_dataentregaprev, b.req_codigo, c.pac_nome");
            bui.append("   , e.set_codigo, f.set_descricao, g.des_codigo, g.des_descricao, (b.req_urgente or coalesce(a.exr_urgente, false)) as req_urgente ");
            bui.append("   , a.exr_datamaterial, a.exr_datadigita, a.exr_situacao ");
            bui.append(" from examerequisicao a");
            bui.append(" left join requisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo");
            bui.append(" left join paciente c on a.fil_codigo = c.fil_codigo and b.pac_codigo = c.pac_codigo");
            bui.append(" left join exames d on a.fil_codigo = d.fil_codigo and a.exa_codigo = d.exa_codigo");
            bui.append(" left join examesetor e on a.fil_codigo = e.fil_codigo and d.exa_codigo = e.exa_codigo");
            bui.append(" left join setores f on a.fil_codigo = f.fil_codigo and e.set_codigo = f.set_codigo");
            bui.append(" left join destino g on a.fil_codigo = g.fil_codigo and b.des_codigo = g.des_codigo");
            bui.append(" where b.req_excluida = false and a.exr_excluido = false");
            bui.append("   and a.exr_dataentregaprev is not null");
            bui.append("   and (a.exr_avisarentrega is null  or  a.exr_avisarentrega = false)");
            if (this.filtroFiliais != null && this.filtroFiliais.length > 0) {
                bui.append(" and a.fil_codigo in (");
                StringUtil.implode(this.filtroFiliais, ", ", bui);
                bui.append(")");
            } else {
                bui.append(" and a.fil_codigo = ").append(Variaveis.filialPadrao);
            }
            if (this.filtroExames != null && this.filtroExames.length > 0) {
                bui.append(" and a.exa_codigo in ('");
                StringUtil.implode(this.filtroExames, "', '", bui);
                bui.append("')");
            }
            if (this.filtroSetores != null && this.filtroSetores.length > 0) {
                bui.append(" and e.set_codigo in (");
                StringUtil.implode(this.filtroSetores, ", ", bui);
                bui.append(")");
            }
            if (this.filtroConvenios != null && this.filtroConvenios.length > 0) {
                bui.append(" and b.con_codigo in (");
                StringUtil.implode(this.filtroConvenios, ", ", bui);
                bui.append(")");
            }
            if (this.filtroColetas != null && this.filtroColetas.length > 0) {
                bui.append(" and b.col_codigo in ('");
                StringUtil.implode(this.filtroColetas, "', '", bui);
                bui.append("')");
            }
            if (this.filtroDestinos != null && this.filtroDestinos.length > 0) {
                bui.append(" and b.des_codigo in ('");
                StringUtil.implode(this.filtroDestinos, "', '", bui);
                bui.append("')");
            }
            if (this.filtroSituacoesReq != null && this.filtroSituacoesReq.length > 0) {
                bui.append(" and b.sit_codigo in (");
                StringUtil.implode(this.filtroSituacoesReq, ", ", bui);
                bui.append(")");
            }
            if (this.filtroSituacaoExames != null && this.filtroSituacaoExames.length > 0) {
                boolean adicionarNull = false;
                bui.append(" and (a.exr_situacao in (");
                int i = 0;
                for (String situacao : this.filtroSituacaoExames) {
                    if (i > 0) {
                        bui.append(", ");
                    }
                    bui.append("'").append(Tipos.getCodigoSituacaoExame(situacao)).append("'");
                    ++i;
                    if (adicionarNull) continue;
                    adicionarNull = Funcoes.textoVazio(Tipos.getCodigoSituacaoExame(situacao));
                }
                bui.append(") ");
                if (adicionarNull) {
                    bui.append(" or a.exr_situacao IS NULL");
                }
                bui.append(")");
            } else {
                bui.append("   and a.exr_situacao not in ('").append("T").append("'");
                bui.append("     , '").append("F").append("'");
                bui.append("     , '").append("R").append("'");
                bui.append("     , '").append("E").append("'");
                bui.append("     , '").append("I").append("'");
                bui.append("     , '").append("A").append("')");
                if (this.filtroApresentarDigitadoParcial) {
                    bui.append(" and (a.exr_datadigita IS NULL OR a.exr_situacao IN ('").append("L").append("', '").append("P").append("')) ");
                } else {
                    bui.append(" and a.exr_datadigita IS NULL ");
                }
            }
            bui.append(" and a.exr_dataentregaprev >= ?");
            bui.append(" and a.exr_dataentregaprev <= ?");
            bui.append(" order by a.fil_codigo, f.set_codigo, g.des_codigo");
            this.prstExames = Conexao.getPreparedStatement(bui.toString());
            this.atualizarPrst = false;
        }
        try {
            GregorianCalendar dataRetrocesso = new GregorianCalendar();
            ((Calendar)dataRetrocesso).add(5, -this.retrocessoDias);
            dataRetrocesso.set(11, 0);
            dataRetrocesso.set(12, 0);
            dataRetrocesso.set(13, 0);
            GregorianCalendar dataAvanco = new GregorianCalendar();
            ((Calendar)dataAvanco).add(11, this.avancoHoras);
            this.prstExames.setTimestamp(1, new Timestamp(dataRetrocesso.getTimeInMillis()));
            this.prstExames.setTimestamp(2, new Timestamp(dataAvanco.getTimeInMillis()));
            try (ResultSet rs = null;){
                rs = this.prstExames.executeQuery();
                this.pieDestino = new DefaultPieDataset();
                this.pieSetor = new DefaultPieDataset();
                boolean avisarAtraso = false;
                boolean atrasou = false;
                if (!this.panelAtrasados.isVisible()) {
                    this.labelAtrasados.setAvisado(0);
                }
                this.panelAtrasados.setVisible(avisarAtraso);
                ArrayList<Date> datas = new ArrayList<Date>();
                while (rs.next()) {
                    LinhaTabelaDestino linhaDestino;
                    LinhaTabelaReq linhaReq;
                    LinhaTabelaSetor linhaSetor;
                    int codigoFilial = rs.getInt("fil_codigo");
                    int codigoSetor = rs.getInt("set_codigo");
                    String descricaoSetor = rs.getString("set_descricao");
                    Long codigoReq = rs.getLong("req_codigo");
                    String codigoDestino = rs.getString("des_codigo");
                    String idRequisicao = codigoFilial + " " + rs.getTimestamp("exr_dataentregaprev") + " " + codigoReq + " " + codigoSetor;
                    String idSetor = codigoFilial + " " + codigoSetor;
                    String idDestino = codigoFilial + " " + codigoDestino;
                    String idExaDes = codigoReq + " " + rs.getString("exa_codigo");
                    if (this.setoresById.containsKey(idSetor)) {
                        linhaSetor = this.setoresById.get(idSetor);
                    } else {
                        linhaSetor = new LinhaTabelaSetor(codigoFilial, codigoSetor);
                        linhaSetor.setDescricaoSetor(rs.getString("set_descricao"));
                        this.setoresById.put(idSetor, linhaSetor);
                    }
                    if (rs.getDate("exr_datadigita") != null) {
                        long duracao = rs.getTimestamp("exr_datamaterial") == null ? 0L : rs.getTimestamp("exr_datadigita").getTime() - rs.getTimestamp("exr_datamaterial").getTime();
                        linhaSetor.addDuracaoExame(duracao);
                    }
                    Date dataEntregaPrev = new Date(rs.getTimestamp("exr_dataentregaprev").getTime());
                    Date dataColeta = new Date(rs.getTimestamp("exr_datamaterial").getTime());
                    if (this.requisicoesById.containsKey(idRequisicao)) {
                        linhaReq = this.requisicoesById.get(idRequisicao);
                    } else {
                        linhaReq = new LinhaTabelaReq(codigoFilial, codigoReq, codigoSetor);
                        linhaReq.setPaciente(rs.getString("pac_nome"));
                        linhaReq.setDescricaoSetor(rs.getString("set_descricao"));
                        linhaReq.setDescricaoDestino(rs.getString("des_descricao"));
                        linhaReq.setUrgente(rs.getBoolean("req_urgente"));
                        this.requisicoesById.put(idRequisicao, linhaReq);
                    }
                    if (this.destinosById.containsKey(idDestino)) {
                        linhaDestino = this.destinosById.get(idDestino);
                    } else {
                        linhaDestino = new LinhaTabelaDestino(codigoFilial, codigoDestino);
                        linhaDestino.setDescricaoDestino(rs.getString("des_descricao"));
                        this.destinosById.put(idDestino, linhaDestino);
                    }
                    linhaReq.setDataEntregaPrev(dataEntregaPrev);
                    linhaReq.addExame(rs.getString("exa_codigo"));
                    if (linhaReq.getExames().size() > 1) {
                        datas.add(dataColeta);
                        for (Date data : datas) {
                            if (!data.before(dataColeta)) continue;
                            linhaReq.setDataColeta(data);
                        }
                    } else {
                        datas.clear();
                        datas.add(dataColeta);
                        linhaReq.setDataColeta(dataColeta);
                    }
                    linhaSetor.addAFazer();
                    if (!this.destinosById.get(idDestino).getExameDest().contains(idExaDes)) {
                        this.destinosById.get(idDestino).getExameDest().add(idExaDes);
                    }
                    if (dataAtual.compareTo(dataEntregaPrev) > 0) {
                        linhaSetor.addAtrasado();
                        if (!this.destinosById.get(idDestino).getExamesDestAtrasados().contains(idExaDes)) {
                            this.destinosById.get(idDestino).getExamesDestAtrasados().add(idExaDes);
                        }
                        atrasou = true;
                        avisarAtraso = true;
                    }
                    if (!atrasou && this.tempoAlertarAtraso > 0 && !avisarAtraso) {
                        long d = rs.getTimestamp("exr_dataentregaprev").getTime() - new Date().getTime();
                        if (Long.parseLong(String.valueOf(this.tempoAlertarAtraso * 60 * 1000)) >= d && d > 0L) {
                            avisarAtraso = true;
                        }
                        if (!this.panelAtrasados.isVisible()) {
                            this.emiteAvisoAtrasado(avisarAtraso);
                        }
                    }
                    this.pieSetor.setValue((Comparable)((Object)linhaSetor.getDescricaoSetor()), (Number)linhaSetor.getAtrasados());
                    this.pieDestino.setValue((Comparable)((Object)linhaDestino.getDescricaoDestino()), (Number)linhaDestino.getAtrasados());
                }
                if (atrasou && !this.panelAtrasados.isVisible()) {
                    this.emiteAvisoAtrasado(avisarAtraso);
                }
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "MonitorPromessa (236)");
        }
        JPanel gfSet = (JPanel)this.splitSetorDestinoGrafico.getComponent(0);
        JPanel gfDes = (JPanel)this.splitSetorDestinoGrafico.getComponent(1);
        this.panelGraficoSet.removeAll();
        this.panelGraficoDest.removeAll();
        JFreeChart chartSetor = this.geraGrafico(this.pieSetor, "Gr\u00e1fico Setor", this.exibirLegenda);
        JFreeChart chartDestino = this.geraGrafico(this.pieDestino, "Gr\u00e1fico Destino", this.exibirLegenda);
        gfSet.add((Component)new ChartPanel(chartSetor, false, false, false, false, true), "Center");
        gfDes.add((Component)new ChartPanel(chartDestino, false, false, false, false, true), "Center");
        this.panelGraficoSet.revalidate();
        this.panelGraficoDest.revalidate();
        ArrayList<LinhaTabelaSetor> setores = new ArrayList<LinhaTabelaSetor>();
        for (LinhaTabelaSetor setor : this.setoresById.values()) {
            if (setor.getAFazer() <= 0) continue;
            setores.add(setor);
        }
        this.modeloRequisicoes.setData(new ArrayList<LinhaTabelaReq>(this.requisicoesById.values()));
        this.modeloSetores.setData(setores);
        this.modeloDestinos.setData(new ArrayList<LinhaTabelaDestino>(this.destinosById.values()));
    }

    private void emiteAvisoAtrasado(boolean avisarAtraso) {
        if (avisarAtraso) {
            ++this.avisoBeep;
            this.labelAtrasados.setAvisado(this.avisoBeep);
            this.labelAtrasados.start();
            this.panelAtrasados.setVisible(avisarAtraso);
        } else {
            this.labelAtrasados.stop();
        }
    }

    private void setTamanhoFonte(int tamanhoFonte) {
        this.tableRequisicoes.setFont(new Font(this.tableRequisicoes.getFont().getName(), this.tableRequisicoes.getFont().getStyle(), tamanhoFonte));
        this.tableSetores.setFont(new Font(this.tableSetores.getFont().getName(), this.tableSetores.getFont().getStyle(), tamanhoFonte));
        this.tableDestinos.setFont(new Font(this.tableDestinos.getFont().getName(), this.tableDestinos.getFont().getStyle(), tamanhoFonte));
        this.tableRequisicoes.setRowHeight(tamanhoFonte + 2);
        this.tableSetores.setRowHeight(tamanhoFonte + 2);
        this.tableDestinos.setRowHeight(tamanhoFonte + 2);
    }

    private void setMostrarGrafico(boolean mostrarGrafico) {
        if (!mostrarGrafico) {
            this.splitRequisicaoGrafico.remove(this.panelGrafico);
        } else if (this.splitRequisicaoGrafico.contains(this.panelGrafico.getLocation())) {
            this.splitRequisicaoGrafico.add(this.panelGrafico);
        }
    }

    private void carregaOpcoes() {
        String xmlOpcoes = ParametrosUsuarios.getValor(PARAMETRO_OPCOES);
        if (!Funcoes.textoVazio(xmlOpcoes)) {
            String filtroSituacaoExameString;
            String filtroSitReqString;
            String filtroDestinosString;
            String filtroColetasString;
            String filtroSetoresString;
            String filtroConveniosString;
            String filtroExamesString;
            String[] colunas;
            String xmlConfig = StringUtil.getValor(xmlOpcoes, "configuracoes");
            String xmlFiltros = StringUtil.getValor(xmlOpcoes, "filtros");
            this.intervaloSegundos = Integer.parseInt(StringUtil.getValor(xmlConfig, "intervaloSegundos"));
            this.retrocessoDias = Integer.parseInt(StringUtil.getValor(xmlConfig, "retrocessoDias"));
            this.avancoHoras = Integer.parseInt(StringUtil.getValor(xmlConfig, "avancoHoras"));
            this.tamanhoFonte = Integer.parseInt(StringUtil.getValor(xmlConfig, "tamanhoFonte"));
            this.mostrarGrafico = StringUtil.getBoolean(xmlConfig, "mostarGrafico");
            this.tempoAlertarAtraso = StringUtil.getInt(xmlConfig, "tempoAlertarAtraso");
            this.msgAviso = StringUtil.getValor(xmlConfig, "msgAviso");
            this.avisoSonoro = StringUtil.getBoolean(xmlConfig, "avisoSonoro");
            this.exibirLegenda = StringUtil.getBoolean(xmlConfig, "exibirLegenda");
            this.indicesColunasReqVisiveis.clear();
            for (String colString : colunas = StringUtil.getValor(xmlConfig, "colunasVisiveis").split(",")) {
                if (!Funcoes.isNumeric(colString)) continue;
                this.indicesColunasReqVisiveis.add(Integer.valueOf(colString));
            }
            this.tableRequisicoes.setColunasVisiveis(this.indicesColunasReqVisiveis);
            this.indicesColunasSetVisiveis.clear();
            String[] colunasSet = !xmlConfig.contains("colunasSetVisiveis") ? "0,1,2,3,4,5".split(",") : StringUtil.getValor(xmlConfig, "colunasSetVisiveis").split(",");
            for (String colString : colunasSet) {
                if (!Funcoes.isNumeric(colString)) continue;
                this.indicesColunasSetVisiveis.add(Integer.valueOf(colString));
            }
            this.tableSetores.setColunasVisiveis(this.indicesColunasSetVisiveis);
            String filtroFiliaisString = StringUtil.getValor(xmlFiltros, "filial");
            if (!Funcoes.textoVazio(filtroFiliaisString)) {
                this.filtroFiliais = filtroFiliaisString.split(",");
            }
            if (!Funcoes.textoVazio(filtroExamesString = StringUtil.getValor(xmlFiltros, "exames"))) {
                this.filtroExames = filtroExamesString.split(",");
            }
            if (!Funcoes.textoVazio(filtroConveniosString = StringUtil.getValor(xmlFiltros, "convenios"))) {
                this.filtroConvenios = filtroConveniosString.split(",");
            }
            if (!Funcoes.textoVazio(filtroSetoresString = StringUtil.getValor(xmlFiltros, ID_TABELA_SETOR))) {
                this.filtroSetores = filtroSetoresString.split(",");
            }
            if (!Funcoes.textoVazio(filtroColetasString = StringUtil.getValor(xmlFiltros, "coletas"))) {
                this.filtroColetas = filtroColetasString.split(",");
            }
            if (!Funcoes.textoVazio(filtroDestinosString = StringUtil.getValor(xmlFiltros, "destinos"))) {
                this.filtroDestinos = filtroDestinosString.split(",");
            }
            if (!Funcoes.textoVazio(filtroSitReqString = StringUtil.getValor(xmlFiltros, "situacoesReq"))) {
                this.filtroSituacoesReq = filtroSitReqString.split(",");
            }
            if (!Funcoes.textoVazio(filtroSituacaoExameString = StringUtil.getValor(xmlFiltros, "situacaoExame"))) {
                this.filtroSituacaoExames = filtroSituacaoExameString.split(",");
            }
            this.filtroApresentarDigitadoParcial = StringUtil.getBoolean(xmlFiltros, "apresentarDigitadoParcial");
            this.progressBar.setMaximum(this.intervaloSegundos * 1000);
            this.progressBar.setString(this.intervaloSegundos + " seg.");
        }
        this.setTamanhoFonte(this.tamanhoFonte);
        this.setMostrarGrafico(this.mostrarGrafico);
        this.labelAtrasados.setAvisoSonoro(this.avisoSonoro);
        this.labelAtrasados.setText(this.msgAviso);
    }

    private void salvaOpcoes() {
        StringBuilder xml = new StringBuilder();
        xml.append("<opcoes>");
        xml.append("<configuracoes>");
        xml.append("<intervaloSegundos>").append(this.intervaloSegundos).append("</intervaloSegundos>");
        xml.append("<tempoAlertarAtraso>").append(this.tempoAlertarAtraso).append("</tempoAlertarAtraso>");
        xml.append("<msgAviso>").append(this.msgAviso).append("</msgAviso>");
        xml.append("<avisoSonoro>").append(this.avisoSonoro).append("</avisoSonoro>");
        xml.append("<retrocessoDias>").append(this.retrocessoDias).append("</retrocessoDias>");
        xml.append("<avancoHoras>").append(this.avancoHoras).append("</avancoHoras>");
        xml.append("<tamanhoFonte>").append(this.tamanhoFonte).append("</tamanhoFonte>");
        xml.append("<mostarGrafico>").append(this.mostrarGrafico).append("</mostarGrafico>");
        xml.append("<exibirLegenda>").append(this.exibirLegenda).append("</exibirLegenda>");
        xml.append("<colunasVisiveis>");
        StringUtil.implode(this.indicesColunasReqVisiveis, ",", xml);
        xml.append("</colunasVisiveis>");
        xml.append("<colunasSetVisiveis>");
        StringUtil.implode(this.indicesColunasSetVisiveis, ",", xml);
        xml.append("</colunasSetVisiveis>");
        xml.append("</configuracoes>");
        xml.append("<filtros>");
        if (this.filtroFiliais != null && this.filtroFiliais.length > 0) {
            xml.append("<filial>");
            StringUtil.implode(this.filtroFiliais, ",", xml);
            xml.append("</filial>");
        }
        if (this.filtroExames != null && this.filtroExames.length > 0) {
            xml.append("<exames>");
            StringUtil.implode(this.filtroExames, ",", xml);
            xml.append("</exames>");
        }
        if (this.filtroConvenios != null && this.filtroConvenios.length > 0) {
            xml.append("<convenios>");
            StringUtil.implode(this.filtroConvenios, ",", xml);
            xml.append("</convenios>");
        }
        if (this.filtroSetores != null && this.filtroSetores.length > 0) {
            xml.append("<setor>");
            StringUtil.implode(this.filtroSetores, ",", xml);
            xml.append("</setor>");
        }
        if (this.filtroColetas != null && this.filtroColetas.length > 0) {
            xml.append("<coletas>");
            StringUtil.implode(this.filtroColetas, ",", xml);
            xml.append("</coletas>");
        }
        if (this.filtroDestinos != null && this.filtroDestinos.length > 0) {
            xml.append("<destinos>");
            StringUtil.implode(this.filtroDestinos, ",", xml);
            xml.append("</destinos>");
        }
        if (this.filtroSituacoesReq != null && this.filtroSituacoesReq.length > 0) {
            xml.append("<situacoesReq>");
            StringUtil.implode(this.filtroSituacoesReq, ",", xml);
            xml.append("</situacoesReq>");
        }
        if (this.filtroSituacaoExames != null && this.filtroSituacaoExames.length > 0) {
            xml.append("<situacaoExame>");
            StringUtil.implode(this.filtroSituacaoExames, ",", xml);
            xml.append("</situacaoExame>");
        }
        xml.append("<apresentarDigitadoParcial>").append(this.filtroApresentarDigitadoParcial ? "true" : "false").append("</apresentarDigitadoParcial>");
        xml.append("</filtros>");
        xml.append("</opcoes>");
        ParametrosUsuarios.setValor(PARAMETRO_OPCOES, xml.toString());
        ParametrosUsuarios.salvarParametros(true);
    }

    private void carregaTabelasConfig() {
        String xml = ParametrosUsuarios.getValor(PARAMETRO_TABELAS_CONFIG);
        if (!Funcoes.textoVazio(xml)) {
            String[] tabelas;
            String[] splits;
            String xmlTabelasConfig = StringUtil.getValor(xml, "tabelasConfig");
            String xmlSplits = StringUtil.getValor(xmlTabelasConfig, "splits");
            for (String xmlSplit : splits = StringUtil.getValores(xmlSplits, "split")) {
                String id = StringUtil.getValor(xmlSplit, "id");
                float local = StringUtil.getFloat(xmlSplit, "local");
                if (id.equals(ID_SPLIT_HORIZONTAL)) {
                    this.splitHorizontalLocal = Double.parseDouble(Funcoes.formataDecimal("##,#00.0", local).replace(",", "."));
                    continue;
                }
                if (id.equals(ID_SPLIT_SETOR_DEST)) {
                    this.splitSetorDestinoLocal = Double.parseDouble(Funcoes.formataDecimal("##,#00.0", local).replace(",", "."));
                    continue;
                }
                if (id.equals(ID_SPLIT_REQ_GRAFICO)) {
                    this.splitRequisicaoGraficoLocal = Double.parseDouble(Funcoes.formataDecimal("##,#00.0", local).replace(",", "."));
                    continue;
                }
                if (!id.equals(ID_SPLIT_SET_DEST_GRAFICO)) continue;
                this.splitSetorDestinoGraficoLocal = Double.parseDouble(Funcoes.formataDecimal("##,#00.0", local).replace(",", "."));
            }
            String xmlTabelas = StringUtil.getValor(xmlTabelasConfig, "tabelas");
            for (String xmlTabela : tabelas = StringUtil.getValores(xmlTabelas, "tabela")) {
                String id = StringUtil.getValor(xmlTabela, "id");
                if (id.equals(ID_TABELA_REQ)) {
                    this.tableRequisicoes.setXmlConfig(xmlTabela);
                    continue;
                }
                if (id.equals(ID_TABELA_SETOR)) {
                    this.tableSetores.setXmlConfig(xmlTabela);
                    continue;
                }
                if (!id.equals(ID_TABELA_DESTINO)) continue;
                this.tableDestinos.setXmlConfig(xmlTabela);
            }
        }
        if (this.splitHorizontalLocal > 1.0) {
            this.splitHorizontalLocal = 0.7;
        }
        if (this.splitSetorDestinoLocal > 1.0) {
            this.splitSetorDestinoLocal = 0.5;
        }
        if (this.splitRequisicaoGraficoLocal > 1.0) {
            this.splitRequisicaoGraficoLocal = 0.7;
        }
        if (this.splitSetorDestinoGraficoLocal > 1.0) {
            this.splitSetorDestinoGraficoLocal = 0.5;
        }
        this.splitSetorDestino.setResizeWeight(this.splitSetorDestinoLocal);
        this.splitRequisicaoGrafico.setResizeWeight(this.splitRequisicaoGraficoLocal);
        this.splitSetorDestinoGrafico.setResizeWeight(this.splitSetorDestinoGraficoLocal);
        this.splitHorizontal.setResizeWeight(this.splitHorizontalLocal);
    }

    private void tamanhoSplits() {
        double width = this.splitRequisicaoGrafico.getDividerLocation();
        double divider = this.panelPrincipal.getSize().width;
        if (this.mostrarGrafico) {
            this.splitRequisicaoGraficoLocal = Double.parseDouble(Funcoes.formataDecimal("##,#00.0", width / divider).replace(",", "."));
        }
        width = this.splitSetorDestino.getDividerLocation();
        this.splitSetorDestinoLocal = Double.parseDouble(Funcoes.formataDecimal("##,#00.0", width / divider).replace(",", "."));
        width = this.splitHorizontal.getDividerLocation();
        divider = this.panelPrincipal.getSize().height;
        this.splitHorizontalLocal = Double.parseDouble(Funcoes.formataDecimal("##,#00.0", width / divider).replace(",", "."));
        width = this.splitSetorDestinoGrafico.getDividerLocation();
        divider = this.panelGrafico.getSize().height;
        if (divider > 0.0 && width > 0.0) {
            this.splitSetorDestinoGraficoLocal = Double.parseDouble(Funcoes.formataDecimal("##,#00.0", width / divider).replace(",", "."));
        }
    }

    private void salvaTabelasConfig() {
        this.tamanhoSplits();
        StringBuilder xml = new StringBuilder();
        xml.append("<tabelasConfig>");
        xml.append("<splits>");
        xml.append("<split>");
        xml.append("<id>").append(ID_SPLIT_HORIZONTAL).append("</id>");
        xml.append("<local>").append(this.splitHorizontalLocal).append("</local>");
        xml.append("</split>");
        xml.append("<split>");
        xml.append("<id>").append(ID_SPLIT_SETOR_DEST).append("</id>");
        xml.append("<local>").append(this.splitSetorDestinoLocal).append("</local>");
        xml.append("</split>");
        xml.append("<split>");
        xml.append("<id>").append(ID_SPLIT_REQ_GRAFICO).append("</id>");
        xml.append("<local>").append(this.splitRequisicaoGraficoLocal).append("</local>");
        xml.append("</split>");
        xml.append("<split>");
        xml.append("<id>").append(ID_SPLIT_SET_DEST_GRAFICO).append("</id>");
        xml.append("<local>").append(this.splitSetorDestinoGraficoLocal).append("</local>");
        xml.append("</split>");
        xml.append("</splits>");
        xml.append("<tabelas>");
        xml.append("<tabela>");
        xml.append("<id>").append(ID_TABELA_REQ).append("</id>");
        xml.append(this.tableRequisicoes.getXmlConfig());
        xml.append("</tabela>");
        xml.append("<tabela>");
        xml.append("<id>").append(ID_TABELA_SETOR).append("</id>");
        xml.append(this.tableSetores.getXmlConfig());
        xml.append("</tabela>");
        xml.append("<tabela>");
        xml.append("<id>").append(ID_TABELA_DESTINO).append("</id>");
        xml.append(this.tableDestinos.getXmlConfig());
        xml.append("</tabela>");
        xml.append("</tabelas>");
        xml.append("</tabelasConfig>");
        ParametrosUsuarios.setValor(PARAMETRO_TABELAS_CONFIG, xml.toString());
        ParametrosUsuarios.salvarParametros(true);
    }

    private void abreConfig() {
        DialogConfiguracoes dialogConfig = new DialogConfiguracoes(Laboratorio.getInstancia(), this.colunasReq, this.indicesColunasReqVisiveis, this.colunasSetor, this.indicesColunasSetVisiveis);
        dialogConfig.getTextIntervalo().setText(String.valueOf(this.intervaloSegundos));
        dialogConfig.getTextRetrocesso().setText(String.valueOf(this.retrocessoDias));
        dialogConfig.getTextAvanco().setText(String.valueOf(this.avancoHoras));
        dialogConfig.getTextTamanhoFonte().setText(String.valueOf(this.tamanhoFonte));
        dialogConfig.getcheckBoxGrafico().setSelected(this.mostrarGrafico);
        dialogConfig.getcheckBoxAvisoSonoro().setSelected(this.avisoSonoro);
        dialogConfig.getTextAtrasados().setText(String.valueOf(this.tempoAlertarAtraso));
        dialogConfig.getTextMsgAviso().setText(String.valueOf(this.msgAviso));
        if (this.exibirLegenda) {
            dialogConfig.getComboBoxLegendaGrafico().setSelectedIndex(1);
        } else {
            dialogConfig.getComboBoxLegendaGrafico().setSelectedIndex(0);
        }
        dialogConfig.setVisible(true);
        if (dialogConfig.getOK()) {
            try {
                boolean novoMostrarGrafico;
                int novoTamanhoFonte;
                int novoAvanco;
                int salvaOpcaoLegenda;
                boolean novoAvisoSonoro;
                String novoMsgAviso;
                int novotempoAlertarAtraso;
                int novoIntervalo = Integer.parseInt(dialogConfig.getTextIntervalo().getText());
                if (novoIntervalo > 0) {
                    this.intervaloSegundos = novoIntervalo;
                }
                if ((novotempoAlertarAtraso = Integer.parseInt(dialogConfig.getTextAtrasados().getText())) >= 0 && this.tempoAlertarAtraso != novotempoAlertarAtraso) {
                    this.tempoAlertarAtraso = novotempoAlertarAtraso;
                }
                if (!this.msgAviso.equals(novoMsgAviso = dialogConfig.getTextMsgAviso().getText())) {
                    this.msgAviso = novoMsgAviso;
                    this.labelAtrasados.setText(this.msgAviso);
                }
                if ((novoAvisoSonoro = dialogConfig.getcheckBoxAvisoSonoro().isSelected()) != this.avisoSonoro) {
                    this.avisoSonoro = novoAvisoSonoro;
                    this.labelAtrasados.setAvisoSonoro(this.avisoSonoro);
                }
                this.exibirLegenda = (salvaOpcaoLegenda = dialogConfig.getComboBoxLegendaGrafico().getSelectedIndex()) == 1;
                int novoRetrocesso = Integer.parseInt(dialogConfig.getTextRetrocesso().getText());
                if (novoRetrocesso >= 0) {
                    this.retrocessoDias = novoRetrocesso;
                }
                if ((novoAvanco = Integer.parseInt(dialogConfig.getTextAvanco().getText())) >= 0) {
                    this.avancoHoras = novoAvanco;
                }
                if ((novoTamanhoFonte = Integer.parseInt(dialogConfig.getTextTamanhoFonte().getText())) >= 0) {
                    this.tamanhoFonte = novoTamanhoFonte;
                    this.setTamanhoFonte(this.tamanhoFonte);
                }
                if ((novoMostrarGrafico = dialogConfig.getcheckBoxGrafico().isSelected()) != this.mostrarGrafico) {
                    this.mostrarGrafico = novoMostrarGrafico;
                    this.setMostrarGrafico(this.mostrarGrafico);
                }
                this.indicesColunasReqVisiveis = dialogConfig.getIndicesColunasReqVisiveis();
                this.tableRequisicoes.setColunasVisiveis(this.indicesColunasReqVisiveis);
                this.indicesColunasSetVisiveis = dialogConfig.getIndicesColunasSetVisiveis();
                this.tableSetores.setColunasVisiveis(this.indicesColunasSetVisiveis);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.progressBar.setMaximum(this.intervaloSegundos * 1000);
            this.progressBar.setString(this.intervaloSegundos + " seg.");
            this.atualizarPrst = true;
            if (this.timer.isRunning()) {
                this.executaConsulta();
            }
            this.salvaOpcoes();
        }
    }

    private void abreFiltros() {
        DialogFiltro dialogFiltros = new DialogFiltro(Laboratorio.getInstancia());
        if (this.filtroFiliais != null && this.filtroFiliais.length > 0) {
            dialogFiltros.getItemFilial().setSelecionados(this.filtroFiliais);
            dialogFiltros.getItemFilial().setSelected(true);
        }
        if (this.filtroExames != null && this.filtroExames.length > 0) {
            dialogFiltros.getItemExame().setSelecionados(this.filtroExames);
            dialogFiltros.getItemExame().setSelected(true);
        }
        if (this.filtroConvenios != null && this.filtroConvenios.length > 0) {
            dialogFiltros.getItemConvenio().setSelecionados(this.filtroConvenios);
            dialogFiltros.getItemConvenio().setSelected(true);
        }
        if (this.filtroSetores != null && this.filtroSetores.length > 0) {
            dialogFiltros.getItemSetor().setSelecionados(this.filtroSetores);
            dialogFiltros.getItemSetor().setSelected(true);
        }
        if (this.filtroColetas != null && this.filtroColetas.length > 0) {
            dialogFiltros.getItemColeta().setSelecionados(this.filtroColetas);
            dialogFiltros.getItemColeta().setSelected(true);
        }
        if (this.filtroDestinos != null && this.filtroDestinos.length > 0) {
            dialogFiltros.getItemDestino().setSelecionados(this.filtroDestinos);
            dialogFiltros.getItemDestino().setSelected(true);
        }
        if (this.filtroSituacoesReq != null && this.filtroSituacoesReq.length > 0) {
            dialogFiltros.getItemSituacaoReq().setSelecionados(this.filtroSituacoesReq);
            dialogFiltros.getItemSituacaoReq().setSelected(true);
        }
        if (this.filtroSituacaoExames != null && this.filtroSituacaoExames.length > 0) {
            dialogFiltros.getItemSituacaoExame().setSelecionados(this.filtroSituacaoExames);
            dialogFiltros.getItemSituacaoExame().setSelected(true);
            dialogFiltros.validaCheckDigitadoParcial();
        }
        dialogFiltros.setApresentarDigitadoParcial(this.filtroApresentarDigitadoParcial);
        dialogFiltros.setVisible(true);
        if (dialogFiltros.getOK()) {
            this.filtroFiliais = dialogFiltros.getItemFilial().getSelecionados();
            this.filtroExames = dialogFiltros.getItemExame().getSelecionados();
            this.filtroConvenios = dialogFiltros.getItemConvenio().getSelecionados();
            this.filtroSetores = dialogFiltros.getItemSetor().getSelecionados();
            this.filtroColetas = dialogFiltros.getItemColeta().getSelecionados();
            this.filtroDestinos = dialogFiltros.getItemDestino().getSelecionados();
            this.filtroSituacoesReq = dialogFiltros.getItemSituacaoReq().getSelecionados();
            this.filtroSituacaoExames = dialogFiltros.getItemSituacaoExame().getSelecionados();
            this.filtroApresentarDigitadoParcial = dialogFiltros.getApresentarDigitadoParcial();
            this.atualizarPrst = true;
            if (this.timer.isRunning()) {
                this.executaConsulta();
            }
            this.salvaOpcoes();
        }
    }

    private void iniciarParar() {
        if (this.timer.isRunning()) {
            this.timer.stop();
            this.labelAtrasados.stop();
            this.panelAtrasados.setVisible(false);
            this.buttonIniParar.setText("Iniciar");
        } else {
            this.timer.start();
            this.buttonIniParar.setText("Parar");
        }
    }

    private void executaConsulta() {
        this.atualizaDados();
        this.ultimaConsulta = new Date();
    }

    public JFreeChart geraGrafico(DefaultPieDataset pie, String titulo, boolean legendaOpcao) {
        JFreeChart chart = null;
        chart = ChartFactory.createPieChart((String)titulo, (PieDataset)pie, (boolean)legendaOpcao, (boolean)true, (boolean)true);
        PiePlot p = (PiePlot)chart.getPlot();
        p.setLabelGenerator(null);
        p.setInteriorGap(0.3);
        if (legendaOpcao) {
            NumberFormat nf = NumberFormat.getNumberInstance();
            NumberFormat nfp = NumberFormat.getPercentInstance();
            nfp.setMinimumFractionDigits(0);
            nfp.setMaximumFractionDigits(2);
            StandardPieItemLabelGenerator labels = new StandardPieItemLabelGenerator("{0}: ({1}) {2}", nf, nfp);
            p.setLabelGenerator((PieSectionLabelGenerator)labels);
        }
        return chart;
    }
}

