/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.consultas.recepcao;

import jalis.util.Intervalo;
import java.util.ArrayList;
import java.util.List;

class LinhaTabelaSetor {
    private int filial;
    private int codigoSetor;
    private String descricaoSetor;
    private Integer aFazer;
    private int atrasados;
    private List<Long> duracaoExames;
    private boolean duracaoExamesAlterada = false;
    private Intervalo duracaoMediaExames;

    public LinhaTabelaSetor(int filial, int codigoSetor) {
        this.filial = filial;
        this.codigoSetor = codigoSetor;
        this.aFazer = 0;
        this.atrasados = 0;
        this.duracaoExames = new ArrayList<Long>();
    }

    public void setDescricaoSetor(String descricaoSetor) {
        this.descricaoSetor = descricaoSetor;
    }

    public Integer getFilial() {
        return this.filial;
    }

    public Integer getCodigoSetor() {
        return this.codigoSetor;
    }

    public void addAFazer() {
        Integer n = this.aFazer;
        Integer n2 = this.aFazer = Integer.valueOf(this.aFazer + 1);
    }

    public void addAtrasado() {
        ++this.atrasados;
    }

    public void addDuracaoExame(long duracaoEmMilisegundos) {
        this.duracaoExamesAlterada = true;
        this.duracaoExames.add(duracaoEmMilisegundos);
    }

    public String getDescricaoSetor() {
        return this.descricaoSetor;
    }

    public Integer getAFazer() {
        return this.aFazer;
    }

    public Integer getAtrasados() {
        return this.atrasados;
    }

    public Intervalo getDuracaoMediaExames() {
        if (this.duracaoExamesAlterada || this.duracaoMediaExames == null) {
            this.calculaDuracaoMediaExames();
        }
        return this.duracaoMediaExames;
    }

    public Intervalo getPrevisaoTotal() {
        if (this.duracaoExamesAlterada || this.duracaoMediaExames == null) {
            this.calculaDuracaoMediaExames();
        }
        return new Intervalo(this.duracaoMediaExames.getMilisegundos() * (long)this.aFazer.intValue());
    }

    private void calculaDuracaoMediaExames() {
        long mili = 0L;
        for (long duracao : this.duracaoExames) {
            mili += duracao;
        }
        mili = this.duracaoExames.isEmpty() ? 0L : mili / (long)this.duracaoExames.size();
        this.duracaoMediaExames = new Intervalo(mili);
        this.duracaoExamesAlterada = false;
    }
}

