/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.consultas.recepcao;

import jalis.util.StringUtil;
import java.util.Arrays;
import java.util.List;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

class CustomJTable
extends JTable {
    private static final long serialVersionUID = 1L;
    private TableColumn[] colunas = new TableColumn[this.getColumnModel().getColumnCount()];
    private RowSorter<TableModel> sorter;

    public CustomJTable(TableModel tableModel, int[] alinhamentos, Class<? extends DefaultTableCellRenderer> cellRenderer) {
        super(tableModel);
        this.sorter = new TableRowSorter<TableModel>(tableModel);
        this.setRowSorter(this.sorter);
        this.getTableHeader().setReorderingAllowed(false);
        for (int i = 0; i < this.colunas.length; ++i) {
            this.colunas[i] = this.getColumnModel().getColumn(i);
            try {
                DefaultTableCellRenderer columnCellRenderer = cellRenderer.newInstance();
                columnCellRenderer.setHorizontalAlignment(alinhamentos[i]);
                this.colunas[i].setCellRenderer(columnCellRenderer);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public CustomJTable(TableModel modeloGridTable, int[] alinhamentos) {
        this(modeloGridTable, alinhamentos, DefaultTableCellRenderer.class);
    }

    public void setColunasVisiveis(List<Integer> indicesColunasVisiveis) {
        for (int i = 0; i < this.colunas.length; ++i) {
            this.getColumnModel().removeColumn(this.colunas[i]);
        }
        for (Integer indice : indicesColunasVisiveis) {
            this.getColumnModel().addColumn(this.colunas[indice]);
        }
    }

    public String getXmlConfig() {
        StringBuilder xml = new StringBuilder();
        xml.append("<config>");
        if (!this.sorter.getSortKeys().isEmpty()) {
            xml.append("<sorter>");
            xml.append("<indice>").append(this.sorter.getSortKeys().get(0).getColumn()).append("</indice>");
            xml.append("<ordem>").append((Object)this.sorter.getSortKeys().get(0).getSortOrder()).append("</ordem>");
            xml.append("</sorter>");
        }
        xml.append("<colunas>");
        for (TableColumn column : this.colunas) {
            xml.append("<coluna>");
            xml.append("<width>").append(column.getPreferredWidth()).append("</width>");
            xml.append("</coluna>");
        }
        xml.append("</colunas>");
        xml.append("</config>");
        return xml.toString();
    }

    public void setXmlConfig(String xml) {
        String xmlConfig = StringUtil.getValor(xml, "config");
        String xmlSorter = StringUtil.getValor(xmlConfig, "sorter");
        if (!xmlSorter.isEmpty()) {
            int coluna = Integer.parseInt(StringUtil.getValor(xmlSorter, "indice"));
            SortOrder ordem = SortOrder.valueOf(StringUtil.getValor(xmlSorter, "ordem"));
            this.sorter.setSortKeys(Arrays.asList(new RowSorter.SortKey(coluna, ordem)));
        }
        String[] xmlsColunas = StringUtil.getValores(xmlConfig, "coluna");
        for (int i = 0; i < this.colunas.length; ++i) {
            if (xmlsColunas.length - 1 < i) continue;
            int width = Integer.parseInt(StringUtil.getValor(xmlsColunas[i], "width"));
            if (this.colunas.length <= i) continue;
            this.colunas[i].setPreferredWidth(width);
        }
    }
}

