/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.consultas.recepcao;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmPadrao;
import jalis.util.CheckItemFiltro;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class ConsultaRequisicoes
extends FrmPadrao
implements ActionListener {
    private final long ACESSO_VISUALIZAR_DATA = 700600100L;
    private final String PROXIMO = "Pr\u00f3ximo >>";
    private final String ANTERIOR = "<< Anterior";
    private CardLayout card = new CardLayout();
    private JPanel panelMudanca = new JPanel(this.card);
    private JPanel panelGeral = new JPanel(new GridBagLayout());
    private JPanel panelAlimentos = new JPanel(new GridBagLayout());
    private GridBagLayout grid = new GridBagLayout();
    private GridBagConstraints constraints = new GridBagConstraints();
    private JPanel panelEsquerdo = new JPanel(this.grid);
    private JPanel panelDireito = new JPanel(new BorderLayout());
    private JPanel panelBotoes = new JPanel(new BorderLayout());
    private JPanel panelBotoesE = new JPanel(new FlowLayout(0));
    private JPanel panelBotoesD = new JPanel(new FlowLayout(2));
    private JButton buttonFechar = new JButton("Fechar");
    private JButton buttonConsultar = new JButton("Consultar");
    private JButton buttonProximo = ComponenteFactory.novoJButton("Pr\u00f3ximo >>", 'r', this);
    private JLabel labelDataFim = new JLabel("Data final:");
    private JLabel labelDataInicio = new JLabel("Data inicial:");
    private JLabel labelSituacao = new JLabel("Situa\u00e7\u00e3o:");
    private TTextField txtDataInicio = new TTextField(10, 4);
    private TTextField txtDataFim = new TTextField(10, 4);
    private JButton buttonDataInicio = new JButton();
    private JButton buttonDataFim = new JButton();
    private CheckItemFiltro itemUsuario = new CheckItemFiltro("Usu\u00e1rios", "Filtrar", "Filtrando usu\u00e1rios", "");
    private CheckItemFiltro itemDestino = new CheckItemFiltro(Variaveis.tipoFilialPadrao.equals("A") ? "Modalidade" : "Destino", "Filtrar", "Filtrando " + (Variaveis.tipoFilialPadrao.equals("A") ? "modalidades" : "destinos"), "fil_codigo = " + Variaveis.filialPadrao);
    private CheckItemFiltro itemColeta = new CheckItemFiltro("Coleta", "Filtrar", "Filtrando coletas", "fil_codigo = " + Variaveis.filialPadrao);
    private CheckItemFiltro itemConvenio = new CheckItemFiltro("Conv\u00eanio", "Filtrar", "Filtrando conv\u00eanios", "fil_codigo = " + Variaveis.filialPadrao);
    private CheckItemFiltro itemPaciente = new CheckItemFiltro(Variaveis.tipoFilialPadrao.equals("A") ? "Cliente" : "Paciente", "Filtrar", "Filtrando " + (Variaveis.tipoFilialPadrao.equals("A") ? "clientes" : "pacientes"), "fil_codigo = " + Variaveis.filialPadrao);
    private CheckItemFiltro itemMedico = new CheckItemFiltro(Variaveis.tipoFilialPadrao.equals("A") ? "Coletador" : "M\u00e9dico", "Filtrar", "Filtrando m\u00e9dicos", "fil_codigo = " + Variaveis.filialPadrao, new int[]{0, 1, 2}, false);
    private CheckItemFiltro itemExame = new CheckItemFiltro("Exame", "Filtrar", "Filtrando exames", "fil_codigo = " + Variaveis.filialPadrao);
    private CheckItemFiltro itemMaterialColetado = new CheckItemFiltro("Material", "Filtrar", "Filtrando materiais", "fil_codigo = " + Variaveis.filialPadrao);
    private CheckItemFiltro itemSetor = new CheckItemFiltro("Setor", "Filtrar", "Filtrando setores", "fil_codigo = " + Variaveis.filialPadrao);
    private TTextField textSif = new TTextField();
    private TTextField textDescricaoProduto = new TTextField();
    private TTextField textMarcaProduto = new TTextField();
    private TTextField textLoteProduto = new TTextField();
    private TTextField textLacreProduto = new TTextField();
    private TTextField textNumeroRegistroProduto = new TTextField();
    private TTextField textAnoPRP = new TTextField(5, 1);
    private TTextField textCicloPRP = new TTextField();
    private TTextField textAmostraPRP = new TTextField();
    private TTextField textDocumentoProduto = new TTextField();
    private TTextField textNumeroSolicitacaoProduto = new TTextField();
    private TTextField textResponsavelProduto = new TTextField();
    private TTextField textLocalColetaProduto = new TTextField();
    private TTextField textDataRecebimentoInicio = new TTextField(10, 4);
    private TTextField textDataRecebimentoFim = new TTextField(10, 4);
    private JButton buttonDataRecebimentoInicio = ComponenteFactory.novoJButton(this, true);
    private JButton buttonDataRecebimentoFim = ComponenteFactory.novoJButton(this, true);
    private static final String[] situacao = new String[]{"Todas", Tipos.tipoSituacaoExame(""), Tipos.tipoSituacaoExame("T"), Tipos.tipoSituacaoExame("F"), Tipos.tipoSituacaoExame("R"), Tipos.tipoSituacaoExame("L"), Tipos.tipoSituacaoExame("C"), Tipos.tipoSituacaoExame("O"), Tipos.tipoSituacaoExame("I"), Tipos.tipoSituacaoExame("E"), Tipos.tipoSituacaoExame("A"), Tipos.tipoSituacaoExame("P")};
    private JComboBox comboSituacao = new JComboBox<String>(situacao);
    private int posicaoAtual = 0;

    public ConsultaRequisicoes() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "ConsultaRequisicoes");
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelEsquerdo, "West");
        this.add((Component)this.panelBotoes, "South");
        this.add((Component)this.panelDireito, "Center");
        this.panelEsquerdo.setPreferredSize(new Dimension(210, 100));
        Funcoes.criaBarraDescricao(this, "Requisi\u00e7\u00f5es", "Consulta requisi\u00e7\u00f5es", "consultas/consulta_requisicao.jpg");
        this.panelBotoes.add((Component)this.panelBotoesE, "West");
        this.panelBotoes.add((Component)this.panelBotoesD, "East");
        this.panelBotoesD.add(this.buttonFechar);
        this.itemUsuario.setDados("usuario", new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{100, 0});
        this.itemUsuario.setColunaHint(1);
        this.itemDestino.setDados("destino", new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Destino"}, new int[]{70, 0});
        this.itemDestino.setColunaHint(1);
        this.itemColeta.setDados("coletas", new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Coleta"}, new int[]{70, 0});
        this.itemColeta.setColunaHint(1);
        this.itemConvenio.setDados("convenios", new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Conv\u00eanio"}, new int[]{70, 0});
        this.itemConvenio.setColunaHint(1);
        this.itemPaciente.setDados("paciente", new String[]{"pac_codigo", "pac_nome"}, new String[]{"C\u00f3digo", "Nome/Raz\u00e3o"}, new int[]{70, 0});
        this.itemPaciente.setColunaHint(1);
        this.itemMedico.setDados("medico", new String[]{"med_conselho", "med_crm", "med_uf", "med_nome"}, new String[]{"Conselho", "C\u00f3digo", "UF", "Nome"}, new int[]{30, 70, 30, 0}, 4, false, true, false);
        this.itemDestino.setColunaHint(3);
        this.itemExame.setDados("exames", new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Exame"}, new int[]{70, 0});
        this.itemExame.setColunaHint(1);
        this.itemMaterialColetado.setDados("materialcoleta", new String[]{"mco_codigo", "mco_descricao"}, new String[]{"C\u00f3digo", "Material"}, new int[]{70, 0});
        this.itemMaterialColetado.setColunaHint(1);
        this.itemSetor.setDados("setores", new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Setor"}, new int[]{70, 0});
        this.itemSetor.setColunaHint(1);
        this.panelEsquerdo.setBorder(new TitledBorder("Filtro"));
        this.buttonFechar.setMnemonic('F');
        this.buttonConsultar.setMnemonic('C');
        Funcoes.imagemPesquisa(this.buttonDataInicio);
        Funcoes.imagemPesquisa(this.buttonDataFim);
        this.buttonDataInicio.setFocusable(false);
        this.buttonDataFim.setFocusable(false);
        this.montaFiltros();
        this.buttonFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsultaRequisicoes.this.setVisible(false);
            }
        });
        this.buttonDataInicio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Funcoes.mostraData(ConsultaRequisicoes.this.txtDataInicio, ConsultaRequisicoes.this.buttonDataInicio, ConsultaRequisicoes.this.panelGeral, true);
            }
        });
        this.buttonDataFim.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Funcoes.mostraData(ConsultaRequisicoes.this.txtDataFim, ConsultaRequisicoes.this.buttonDataFim, ConsultaRequisicoes.this.panelGeral, true);
            }
        });
        this.buttonConsultar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsultaRequisicoes.this.pesquisaRequisicoes();
            }
        });
    }

    public void montaFiltros() {
        this.montaPanelGeral();
        this.montaPanelAlimentos();
        this.panelMudanca.add((Component)this.panelGeral, "geral");
        this.panelMudanca.add((Component)this.panelAlimentos, "alimentos");
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.fill = 1;
        this.constraints.anchor = 18;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.panelEsquerdo.add((Component)this.panelMudanca, this.constraints);
        this.constraints.gridx = 0;
        ++this.constraints.gridy;
        this.constraints.fill = 2;
        this.constraints.anchor = 13;
        this.constraints.gridwidth = 3;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.buttonProximo.setPreferredSize(new Dimension(100, 20));
        this.buttonProximo.setMinimumSize(new Dimension(100, 20));
        if (Variaveis.tipoFilialPadrao.equals("A")) {
            JPanel p = ComponenteFactory.novoJPanelFlowLayout(2, 0, 0, this.buttonProximo);
            p.setPreferredSize(new Dimension(100, 20));
            this.panelEsquerdo.add((Component)p, this.constraints);
            ++this.constraints.gridy;
        }
        this.buttonConsultar.setPreferredSize(new Dimension(100, 20));
        this.buttonConsultar.setMinimumSize(new Dimension(100, 20));
        JPanel p1 = ComponenteFactory.novoJPanelFlowLayout(2, 0, 0, this.buttonConsultar);
        p1.setPreferredSize(new Dimension(100, 20));
        this.panelEsquerdo.add((Component)p1, this.constraints);
    }

    public void montaPanelGeral() {
        Dimension dim = new Dimension(70, 20);
        GridBagConstraints c = new GridBagConstraints();
        this.itemUsuario.setPreferredSize(dim);
        this.itemDestino.setPreferredSize(dim);
        this.itemColeta.setPreferredSize(dim);
        this.itemConvenio.setPreferredSize(dim);
        this.itemPaciente.setPreferredSize(dim);
        this.itemMedico.setPreferredSize(dim);
        this.itemExame.setPreferredSize(dim);
        this.itemMaterialColetado.setPreferredSize(dim);
        this.itemSetor.setPreferredSize(dim);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.anchor = 18;
        c.gridwidth = 3;
        c.weightx = 1.0;
        this.panelGeral.add((Component)this.itemUsuario, c);
        ++c.gridy;
        this.panelGeral.add((Component)this.itemDestino, c);
        ++c.gridy;
        this.panelGeral.add((Component)this.itemColeta, c);
        ++c.gridy;
        this.panelGeral.add((Component)this.itemConvenio, c);
        ++c.gridy;
        this.panelGeral.add((Component)this.itemPaciente, c);
        ++c.gridy;
        this.panelGeral.add((Component)this.itemMedico, c);
        ++c.gridy;
        this.panelGeral.add((Component)this.itemExame, c);
        ++c.gridy;
        this.panelGeral.add((Component)this.itemMaterialColetado, c);
        ++c.gridy;
        this.panelGeral.add((Component)this.itemSetor, c);
        c.gridy = 9;
        c.fill = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.panelGeral.add((Component)this.labelDataInicio, c);
        c.gridy = 10;
        this.panelGeral.add((Component)this.labelDataFim, c);
        c.gridy = 11;
        this.panelGeral.add((Component)this.labelSituacao, c);
        c.gridx = 2;
        c.gridy = 9;
        this.buttonDataInicio.setPreferredSize(new Dimension(20, 20));
        this.buttonDataInicio.setMinimumSize(new Dimension(20, 20));
        this.panelGeral.add((Component)this.buttonDataInicio, c);
        c.gridy = 10;
        this.buttonDataFim.setPreferredSize(new Dimension(20, 20));
        this.buttonDataFim.setMinimumSize(new Dimension(20, 20));
        this.panelGeral.add((Component)this.buttonDataFim, c);
        c.gridx = 1;
        c.gridy = 9;
        c.fill = 2;
        c.anchor = 17;
        c.gridwidth = 1;
        c.weightx = 1.0;
        this.txtDataInicio.setPreferredSize(new Dimension(90, 20));
        this.txtDataInicio.setMinimumSize(new Dimension(90, 20));
        this.panelGeral.add((Component)this.txtDataInicio, c);
        c.gridy = 10;
        this.txtDataFim.setPreferredSize(new Dimension(90, 20));
        this.txtDataFim.setMinimumSize(new Dimension(90, 20));
        this.panelGeral.add((Component)this.txtDataFim, c);
        c.gridy = 11;
        c.gridwidth = 2;
        this.comboSituacao.setPreferredSize(new Dimension(90, 20));
        this.comboSituacao.setMinimumSize(new Dimension(90, 20));
        this.panelGeral.add((Component)this.comboSituacao, c);
        ++c.gridy;
        c.gridwidth = 3;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.panelGeral.add((Component)new JPanel(), c);
    }

    public void montaPanelAlimentos() {
        Dimension dim = new Dimension(50, 20);
        this.textSif.setPreferredSize(dim);
        this.textDescricaoProduto.setPreferredSize(dim);
        this.textMarcaProduto.setPreferredSize(dim);
        this.textLoteProduto.setPreferredSize(dim);
        this.textLacreProduto.setPreferredSize(dim);
        this.textNumeroRegistroProduto.setPreferredSize(dim);
        this.textAnoPRP.setPreferredSize(dim);
        this.textCicloPRP.setPreferredSize(dim);
        this.textAmostraPRP.setPreferredSize(dim);
        this.textDocumentoProduto.setPreferredSize(dim);
        this.textNumeroSolicitacaoProduto.setPreferredSize(dim);
        this.textResponsavelProduto.setPreferredSize(dim);
        this.textLocalColetaProduto.setPreferredSize(dim);
        this.textDataRecebimentoInicio.setPreferredSize(dim);
        this.textDataRecebimentoFim.setPreferredSize(dim);
        this.buttonDataRecebimentoInicio.setPreferredSize(new Dimension(20, 20));
        this.buttonDataRecebimentoFim.setPreferredSize(new Dimension(20, 20));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 18;
        this.panelAlimentos.add((Component)new JLabel("SIF:"), c);
        c.gridy = 1;
        this.panelAlimentos.add((Component)new JLabel("Descri\u00e7\u00e3o:"), c);
        c.gridy = 2;
        this.panelAlimentos.add((Component)new JLabel("Marca:"), c);
        c.gridy = 3;
        this.panelAlimentos.add((Component)new JLabel("Lote:"), c);
        c.gridy = 4;
        this.panelAlimentos.add((Component)new JLabel("Lacre:"), c);
        c.gridy = 5;
        this.panelAlimentos.add((Component)new JLabel("Registro:"), c);
        c.gridy = 6;
        this.panelAlimentos.add((Component)new JLabel("Documento:"), c);
        c.gridy = 7;
        this.panelAlimentos.add((Component)new JLabel("Solicita\u00e7\u00e3o:"), c);
        c.gridy = 8;
        this.panelAlimentos.add((Component)new JLabel("Respons\u00e1vel:"), c);
        c.gridy = 9;
        this.panelAlimentos.add((Component)new JLabel("Local coleta:"), c);
        c.gridy = 10;
        this.panelAlimentos.add((Component)new JLabel("Ano PRP:"), c);
        c.gridy = 11;
        this.panelAlimentos.add((Component)new JLabel("Ciclo PRP:"), c);
        c.gridy = 12;
        this.panelAlimentos.add((Component)new JLabel("Amostra PRP:"), c);
        c.gridy = 13;
        this.panelAlimentos.add((Component)new JLabel("Receb. inicial:"), c);
        c.gridy = 14;
        this.panelAlimentos.add((Component)new JLabel("Receb. final:"), c);
        c.gridx = 2;
        c.gridy = 13;
        this.panelAlimentos.add((Component)this.buttonDataRecebimentoInicio, c);
        c.gridy = 14;
        this.panelAlimentos.add((Component)this.buttonDataRecebimentoFim, c);
        c.weightx = 1.0;
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 13;
        this.panelAlimentos.add((Component)this.textDataRecebimentoInicio, c);
        c.gridy = 14;
        this.panelAlimentos.add((Component)this.textDataRecebimentoFim, c);
        c.gridwidth = 2;
        c.gridy = 0;
        this.panelAlimentos.add((Component)this.textSif, c);
        c.gridy = 1;
        this.panelAlimentos.add((Component)this.textDescricaoProduto, c);
        c.gridy = 2;
        this.panelAlimentos.add((Component)this.textMarcaProduto, c);
        c.gridy = 3;
        this.panelAlimentos.add((Component)this.textLoteProduto, c);
        c.gridy = 4;
        this.panelAlimentos.add((Component)this.textLacreProduto, c);
        c.gridy = 5;
        this.panelAlimentos.add((Component)this.textNumeroRegistroProduto, c);
        c.gridy = 6;
        this.panelAlimentos.add((Component)this.textDocumentoProduto, c);
        c.gridy = 7;
        this.panelAlimentos.add((Component)this.textNumeroSolicitacaoProduto, c);
        c.gridy = 8;
        this.panelAlimentos.add((Component)this.textResponsavelProduto, c);
        c.gridy = 9;
        this.panelAlimentos.add((Component)this.textLocalColetaProduto, c);
        c.gridy = 10;
        this.panelAlimentos.add((Component)this.textAnoPRP, c);
        c.gridy = 11;
        this.panelAlimentos.add((Component)this.textCicloPRP, c);
        c.gridy = 12;
        this.panelAlimentos.add((Component)this.textAmostraPRP, c);
        c.weighty = 1.0;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 15;
        this.panelAlimentos.add((Component)new JPanel(), c);
    }

    public static Long getModuloAcesso() {
        return Long.parseLong("0700600100");
    }

    @Override
    public void pressioneiF2() {
        if (this.txtDataInicio.hasFocus()) {
            Funcoes.mostraData(this.txtDataInicio, this.buttonDataInicio, this.panelEsquerdo, true);
        } else if (this.txtDataFim.hasFocus()) {
            Funcoes.mostraData(this.txtDataFim, this.buttonDataFim, this.panelEsquerdo, true);
        } else if (this.textDataRecebimentoInicio.hasFocus()) {
            this.buscaDataRecebimento(this.textDataRecebimentoInicio);
        } else if (this.textDataRecebimentoFim.hasFocus()) {
            this.buscaDataRecebimento(this.textDataRecebimentoFim);
        }
    }

    private void pesquisaRequisicoes() {
        if (!Funcoes.verificaData(this.txtDataInicio.getText()) || !Funcoes.verificaData(this.txtDataFim.getText())) {
            Funcoes.mensagem(this, "Data inv\u00e1lida para consulta", 1);
            this.txtDataInicio.grabFocus();
            return;
        }
        if (!(!Variaveis.tipoFilialPadrao.equals("A") || Funcoes.verificaData(this.txtDataInicio.getText()) && Funcoes.verificaData(this.txtDataFim.getText()))) {
            Funcoes.mensagem(this, "Data de recebimento inv\u00e1lida para consulta", 1);
            this.textDataRecebimentoInicio.grabFocus();
            return;
        }
        this.buttonConsultar.setEnabled(false);
        this.panelDireito.removeAll();
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Statement st = Conexao.getStatement();
                try {
                    ResultSet rs = Conexao.executeQuery(st, ConsultaRequisicoes.this.getSelect());
                    if (rs.next() && rs.first()) {
                        String[] colunas = ConsultaRequisicoes.this.pegaColunas(rs);
                        ModeloResultSet modelo = new ModeloResultSet(rs, colunas){

                            @Override
                            public Object getValueAt(int row, int col) {
                                Registro reg = this.getRegistro(row);
                                if (reg != null && col * 2 + 1 < this.cols.length) {
                                    if (reg.getValor(this.cols[col * 2 + 1]) != null && reg.getValor(this.cols[col * 2 + 1]) instanceof String && reg.getValor(this.cols[col * 2 + 1]).toString().matches("\\d{4}/(0[1-9]|1[012])/(0[1-9]|[12]\\d|3[01])")) {
                                        return Funcoes.formataData(Funcoes.stringToDate("yyyy/MM/dd", reg.getValor(this.cols[col * 2 + 1]).toString()));
                                    }
                                    if (reg.getValor(this.cols[col * 2 + 1]) instanceof String && (reg.getValor(this.cols[col * 2 + 1]).toString().indexOf(10) > -1 || reg.getValor(this.cols[col * 2 + 1]).toString().indexOf(13) > -1 || reg.getValor(this.cols[col * 2 + 1]).toString().indexOf(9) > -1)) {
                                        return StringUtil.limpaString(reg.getValor(this.cols[col * 2 + 1]).toString(), new String[]{"\n", "\r", "\t"});
                                    }
                                    if (this.cols[col * 2 + 1].equalsIgnoreCase("ultimaDataConferenciaExamesRequisicao") && reg.getValor(this.cols[col * 2 + 1]) != null && reg.getValor(this.cols[col * 2 + 1]).toString().matches("\\d{4}/(0[1-9]|1[012])/(0[1-9]|[12]\\d|3[01]) ([01]\\d|2[0-3]):[0-5]\\d:[0-5]\\d(\\.\\d+)?")) {
                                        return Funcoes.formataData("dd/MM/yyyy HH:mm", Funcoes.stringToDate("yyyy/MM/dd HH:mm:ss.S", reg.getValor(this.cols[col * 2 + 1]).toString()));
                                    }
                                    if (this.cols[col * 2 + 1].equalsIgnoreCase("ultimaDataImpressaoExamesRequisicao") && reg.getValor(this.cols[col * 2 + 1]) != null && reg.getValor(this.cols[col * 2 + 1]).toString().matches("\\d{4}/(0[1-9]|1[012])/(0[1-9]|[12]\\d|3[01]) ([01]\\d|2[0-3]):[0-5]\\d:[0-5]\\d(\\.\\d+)?")) {
                                        return Funcoes.formataData("dd/MM/yyyy HH:mm", Funcoes.stringToDate("yyyy/MM/dd HH:mm:ss.S", reg.getValor(this.cols[col * 2 + 1]).toString()));
                                    }
                                    if (this.cols[col * 2 + 1].equalsIgnoreCase("ultimaDataColetaExamesRequisicao") && reg.getValor(this.cols[col * 2 + 1]) != null && reg.getValor(this.cols[col * 2 + 1]).toString().matches("\\d{4}/(0[1-9]|1[012])/(0[1-9]|[12]\\d|3[01]) ([01]\\d|2[0-3]):[0-5]\\d:[0-5]\\d(\\.\\d+)?")) {
                                        return Funcoes.formataData("dd/MM/yyyy HH:mm", Funcoes.stringToDate("yyyy/MM/dd HH:mm:ss.S", reg.getValor(this.cols[col * 2 + 1]).toString()));
                                    }
                                    if (this.cols[col * 2 + 1].equalsIgnoreCase("ultimaDataTriagemExamesRequisicao") && reg.getValor(this.cols[col * 2 + 1]) != null && reg.getValor(this.cols[col * 2 + 1]).toString().matches("\\d{4}/(0[1-9]|1[012])/(0[1-9]|[12]\\d|3[01]) ([01]\\d|2[0-3]):[0-5]\\d:[0-5]\\d(\\.\\d+)?")) {
                                        return Funcoes.formataData("dd/MM/yyyy HH:mm", Funcoes.stringToDate("yyyy/MM/dd HH:mm:ss.S", reg.getValor(this.cols[col * 2 + 1]).toString()));
                                    }
                                    if (this.cols[col * 2 + 1].equalsIgnoreCase("generoPaciente") && reg.getValor(this.cols[col * 2 + 1]) != null) {
                                        return ConsultaRequisicoes.this.getDescricaoGeneroPaciente(reg.getString(this.cols[col * 2 + 1]).toString());
                                    }
                                    return reg.getValor(this.cols[col * 2 + 1]);
                                }
                                return null;
                            }
                        };
                        JTable table = new JTable(modelo);
                        table.setAutoCreateRowSorter(true);
                        table.setAutoResizeMode(0);
                        modelo.setTamanhoColunas(table, ConsultaRequisicoes.this.pegaTamanhoColunas(rs, table));
                        JScrollPane scroll = new JScrollPane(table);
                        scroll.setPreferredSize(new Dimension(100, 100));
                        ConsultaRequisicoes.this.panelDireito.add((Component)scroll, "Center");
                    } else {
                        Funcoes.mensagem(ConsultaRequisicoes.this, "N\u00e3o existe requisi\u00e7\u00f5es para o filtro pesquisado", 2);
                    }
                    ConsultaRequisicoes.this.panelDireito.revalidate();
                    ConsultaRequisicoes.this.panelDireito.repaint();
                }
                catch (Exception e) {
                    try {
                        ErrorLogger.mostraMensagem(ConsultaRequisicoes.this, e.getMessage(), e.getStackTrace(), "ConsultaRequisicoes (495)");
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st);
                        ConsultaRequisicoes.this.buttonConsultar.setEnabled(true);
                        throw throwable;
                    }
                    Conexao.fecharStatement(st);
                    ConsultaRequisicoes.this.buttonConsultar.setEnabled(true);
                }
                Conexao.fecharStatement(st);
                ConsultaRequisicoes.this.buttonConsultar.setEnabled(true);
            }
        });
    }

    private String getDescricaoGeneroPaciente(String codigoGenero) {
        String retorno = "";
        Statement st = Conexao.getStatement();
        String sql = "select ige_descricao from identidadegenero where ige_codigo = " + codigoGenero;
        try {
            ResultSet rs = st.executeQuery(sql);
            if (rs.next()) {
                retorno = rs.getString("ige_descricao");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return retorno;
    }

    private int[] pegaTamanhoColunas(ResultSet rs, JTable tabela) throws SQLException {
        if (tabela != null) {
            FontMetrics met = tabela.getFontMetrics(tabela.getFont());
            int[] tamCols = new int[rs.getMetaData().getColumnCount()];
            for (int i = 0; i < tamCols.length; ++i) {
                int tamanho;
                tamCols[i] = tamanho = met.stringWidth(rs.getMetaData().getColumnName(i + 1)) + 15;
            }
            return tamCols;
        }
        return new int[0];
    }

    private String[] pegaColunas(ResultSet rs) throws SQLException {
        if (rs != null) {
            String[] retorno = new String[rs.getMetaData().getColumnCount() * 2];
            for (int i = 0; i < rs.getMetaData().getColumnCount(); ++i) {
                retorno[i * 2] = rs.getMetaData().getColumnName(i + 1);
                retorno[i * 2 + 1] = rs.getMetaData().getColumnName(i + 1);
            }
            return retorno;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonProximo) {
            this.controlaCard();
        } else if (e.getSource() == this.buttonDataRecebimentoInicio) {
            this.buscaDataRecebimento(this.textDataRecebimentoInicio);
        } else if (e.getSource() == this.buttonDataRecebimentoFim) {
            this.buscaDataRecebimento(this.textDataRecebimentoFim);
        }
    }

    private void buscaDataRecebimento(TTextField text) {
        Funcoes.mostraData(text, this.buttonDataRecebimentoInicio, this.panelAlimentos, true);
    }

    private void controlaCard() {
        if (this.posicaoAtual == 1) {
            this.posicaoAtual = 0;
            this.buttonProximo.setText("Pr\u00f3ximo >>");
            this.card.previous(this.panelMudanca);
        } else {
            this.posicaoAtual = 1;
            this.buttonProximo.setText("<< Anterior");
            this.card.next(this.panelMudanca);
        }
    }

    private String getSelect() {
        String[] setores;
        String[] materiais;
        String[] exames;
        String[] pacientes;
        String[] convenios;
        String[] coletas;
        String[] destinos;
        StringBuilder buf = new StringBuilder();
        buf.append("select distinct a.req_codigo as codigoRequisicao, a.req_dtfatura as dataFaturaRequisicao, ");
        if (Acesso.getAcesso(700600100L)) {
            buf.append("a.req_data as dataRequisicao, ");
        }
        buf.append("a.req_urgente as urgenteRequisicao, a.req_dataentregaprev as dataEntregaRequisicao,  ");
        if (!Variaveis.tipoFilialPadrao.equals("A")) {
            buf.append("a.req_dclinicos as dadosClinicosRequisicao, a.req_dum as dumRequisicao, ");
            buf.append("a.req_matricula as matriculaRequisicao, a.req_anomes as anomesIdadeRequisicao, a.req_idade as idadeRequisicao, ");
            buf.append("a.req_titular as titularRequisicao, a.req_altura as alturaRequisicao, a.req_peso as pesoRequisicao,  ");
            buf.append("a.req_validadeguia as validadeGuiaRequisicao,  a.req_guia as guiaRequisicao, ");
            buf.append("a.req_quarto as quartoRequisicao, a.req_leito as leitoRequisicao, ");
            buf.append("ala.ala_codigo as codigoAla, ala.ala_descricao as descricaoAla, ");
        } else {
            buf.append("a.req_datarecebimentoproduto as dataRecebimentoProduto, a.req_horarecebimentoproduto as horaRecebimentoProduto, ");
            buf.append("a.req_datacoletaproduto as dataColetaProduto, a.req_horacoletaproduto as horaColetaProduto, ");
        }
        buf.append("a.req_obs as observacaoRequisicao, a.req_totpago as totalPagoRequisicao, a.req_total as totalRequisicao, ");
        buf.append("a.req_horaentregaprev as horaEntregaRequisicao, a.req_horafatura as horaFaturaRequisicao, ");
        buf.append("a.req_hora as horaRequisicao, ");
        buf.append("a.req_avisarpaciente as avisarPacienteRequisicao, a.req_senhaweb as senhaWebRequisicao,  ");
        buf.append("a.req_vlracrescimo as valorAcrescimoRequisicao, a.req_acrescimo as percentualAcrescimoRequisicao, ");
        buf.append("a.req_vlrdesconto as valorDescontoRequisicao, a.req_desconto as percentualDescontoRequisicao, ");
        buf.append("a.req_datarequisicao as dataAberturaRequisicao, ");
        buf.append("a.req_tipoultpagamento as tipoUltimoPagamentoRequisicao, ");
        if (!Variaveis.tipoFilialPadrao.equals("A")) {
            buf.append("paciente.pac_codigo as codigoPaciente, paciente.pac_nome as nomePaciente, paciente.pac_nomesocial as nomeSocial, ");
            buf.append("paciente.pac_datanasc as dataNascimentoPaciente, paciente.pac_sexo as sexoPaciente, coalesce(paciente.pac_genero, 0) as generoPaciente, ");
            buf.append("paciente.pac_rg as rgPaciente, paciente.pac_cpf as cpfPaciente, ");
            buf.append("paciente.pac_estcivil as estadoCivilPaciente, paciente.pac_numfilho as numeroFilhosPaciente, ");
            buf.append("destino.des_codigo as codigoDestino, destino.des_descricao as descricaoDestino, ");
        } else {
            buf.append("paciente.pac_codigo as codigoCliente, paciente.pac_nome as fantasiaCliente, ");
            buf.append("paciente.pac_razaosocial as razaoSocialCliente, ");
            buf.append("paciente.pac_cnpj as cnpjCliente, paciente.pac_ie as ieCliente, paciente.pac_sif as sifCliente, ");
            buf.append("destino.des_codigo as codigoModalidade, destino.des_descricao as descricaoModalidade,  ");
        }
        buf.append("usrrequisicao.usr_codigo as codigoUsuarioRequisicao, usrrequisicao.usr_nome as nomeUsuarioRequisicao, ");
        buf.append("a.usr_codigo as codigoUsuarioAberturaRequisicao, ");
        buf.append("coleta.col_codigo as codigoColeta, coleta.col_descricao as descricaoColeta,  ");
        buf.append("convenio.con_codigo as codigoConvenio, convenio.con_razao as razaoSocialConvenio,  ");
        buf.append("convenio.con_fantasia as fantasiaConvenio, convenio.con_cnpjcpf as cnpjConvenio,  ");
        buf.append("convenio.con_inscrest as inscricaoEstadualConvenio, convenio.con_fone as foneConvenio, ");
        if (!Variaveis.tipoFilialPadrao.equals("A")) {
            buf.append("medico.med_conselho as conselhoMedico, medico.med_crm as crmMedico, medico.med_uf as ufMedico, medico.med_nome as nomeMedico,  ");
            buf.append("medico.med_abrev as abreviaturaMedico, ");
        } else {
            buf.append("medico.med_conselho as conselhoColetador, medico.med_crm as crmColetador, medico.med_uf as ufMedico, medico.med_nome as nomeColetador,  ");
            buf.append("medico.med_abrev as abreviaturaColetador, ");
        }
        buf.append("sit.sit_codigo as codigoSituacao, ");
        buf.append("sit.sit_descricao as descricaoSituacao ");
        if (Variaveis.tipoFilialPadrao.equals("A")) {
            buf.append(", a.req_descricaoproduto as descricaoProdutoRequisicao, ");
            buf.append("a.req_datafabricacao as dataFabricacaoProdutoRequisicao, ");
            buf.append("a.req_numeroregistroproduto as numeroRegistroProdutoRequisicao, ");
            buf.append("a.req_temperaturacoletaproduto as temperaturaColetaProdutoRequisicao, ");
            buf.append("a.req_numeroloteproduto as numeroLoteProdutoRequisicao, ");
            buf.append("a.req_datavalidade as dataValidadeProdutoRequisicao, ");
            buf.append("a.req_marcaproduto as marcaProdutoRequisicao, ");
            buf.append("a.req_lacreproduto as lacreProdutoRequisicao, ");
            buf.append("a.req_lacreprodutocontra as lacreContraProvaProdutoRequisicao, ");
            buf.append("a.req_lacreprodutocontraempresa as lacreContraProvaEmpresaProdutoRequisicao, ");
            buf.append("a.req_doctoreferenciaproduto as documentoReferenciaProdutoRequisicao, ");
            buf.append("a.req_temperaturarecebimento as temperaturaRecebimentoProdutoRequisicao, ");
            buf.append("a.req_sanitariasproduto as caracteristicasSanitariasProdutoRequisicao, ");
            buf.append("a.req_condicoesambproduto as condicoesAmbientaisProdutoRequisicao, ");
            buf.append("a.req_procedimentocoletaproduto as procedimentoColetaProdutoRequisicao, ");
            buf.append("a.req_tiporecebimentoproduto as tipoRecebimentoProdutoRequisicao, ");
            buf.append("a.req_localcoletaproduto as localColetaProdutoRequisicao, ");
            buf.append("a.req_areaproduto as areaProdutoRequisicao, ");
            buf.append("a.req_partidaproduto as partidaProdutoRequisicao, ");
            buf.append("a.req_qtdeamostraproduto as qtdeAmostrasProdutoRequisicao, ");
            buf.append("a.req_qtdeunidadeproduto as qtdeUnidadeProdutoRequisicao, ");
            buf.append("a.unm_codigo as codigoUnidadeProdutoRequisicao, ");
            buf.append("unidademedida.unm_descricao as descricaoUnidadeProdutoRequisicao, ");
            buf.append("a.emb_codigo as codigoEmbalagemProdutoRequisicao, ");
            buf.append("emb.emb_descricao as descricaoEmbalagemProdutoRequisicao, ");
            buf.append("paccontatos.pco_nome as nomeResponsavelRequisicao_, ");
            buf.append("paccontatos.pco_cargo as cargoResponsavelRequisicao_, ");
            buf.append("paccontatos.pco_email as emailResponsavelRequisicao_, ");
            buf.append("paccontatos.pco_fone as foneResponsavelRequisicao_, ");
            buf.append("ent.ent_fantasia as nomeResponsavelRequisicao, ");
            buf.append("ent.ent_cargo as cargoResponsavelRequisicao, ");
            buf.append("ent.ent_email as emailResponsavelRequisicao, ");
            buf.append("ent.ent_fone as foneResponsavelRequisicao ");
        } else if (Variaveis.tipoFilialPadrao.equals("V")) {
            buf.append(", paciente.pac_proprietario as proprietarioPaciente ");
        }
        buf.append(", pegadescricaoexamerequisicao(a.fil_codigo, a.req_codigo) as descricaoExamesRequisicao, pegacodigoexamerequisicao(a.fil_codigo, a.req_codigo) as codigoExamesRequisicao ");
        buf.append(", pegadatasconferenciaexamerequisicao(a.fil_codigo, a.req_codigo) as datasConferenciaExamesRequisicao, pegadatasimpressaoexamerequisicao(a.fil_codigo, a.req_codigo) as datasImpressaoExamesRequisicao ");
        buf.append(", (select max(exr_dataassina) from examerequisicao ee where ee.fil_codigo = a.fil_codigo and a.req_codigo = ee.req_codigo) as ultimaDataConferenciaExamesRequisicao ");
        buf.append(", (select max(exr_dataimpresso) from examerequisicao ee where ee.fil_codigo = a.fil_codigo and a.req_codigo = ee.req_codigo) as ultimaDataImpressaoExamesRequisicao ");
        buf.append(", (select max(exr_datamaterial) from examerequisicao ee where ee.fil_codigo = a.fil_codigo and a.req_codigo = ee.req_codigo) as ultimaDataColetaExamesRequisicao ");
        buf.append(", (select max(exr_datatriagem) from examerequisicao ee where ee.fil_codigo = a.fil_codigo and a.req_codigo = ee.req_codigo) as ultimaDataTriagemExamesRequisicao ");
        buf.append("from requisicao a ");
        buf.append("join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
        buf.append("join paciente on a.fil_codigo = paciente.fil_codigo and a.pac_codigo = paciente.pac_codigo ");
        buf.append("left join exames c on b.fil_codigo = c.fil_codigo and b.exa_codigo = c.exa_codigo ");
        buf.append("left join examesetor e on b.fil_codigo = e.fil_codigo and b.exa_codigo = e.exa_codigo and e.ese_default = true ");
        buf.append("left join setores setor on e.fil_codigo = setor.fil_codigo and e.set_codigo = setor.set_codigo ");
        buf.append("join convenios convenio on a.fil_codigo = convenio.fil_codigo and a.con_codigo = convenio.con_codigo ");
        buf.append("join medico on a.fil_codigo = medico.fil_codigo and a.med_conselho = medico.med_conselho and a.med_crm = medico.med_crm and a.med_uf = medico.med_uf ");
        buf.append("join usuario usrrequisicao on a.usr_codigo = usrrequisicao.usr_codigo ");
        buf.append("left join embalagemproduto emb on a.fil_codigo = emb.fil_codigo and a.emb_codigo = emb.emb_codigo ");
        buf.append("left join situacao sit on a.fil_codigo = sit.fil_codigo and a.sit_codigo = sit.sit_codigo ");
        buf.append("join destino on a.fil_codigo = destino.fil_codigo and a.des_codigo = destino.des_codigo ");
        buf.append("join coletas coleta on a.fil_codigo = coleta.fil_codigo and a.col_codigo = coleta.col_codigo ");
        buf.append("left join alahospital ala on a.fil_codigo = ala.fil_codigo and a.ala_codigo = ala.ala_codigo ");
        buf.append("left join materialcoleta coletado on b.fil_codigo = coletado.fil_codigo and b.mco_codigo = coletado.mco_codigo ");
        buf.append("left join metodologia on b.fil_codigo = metodologia.fil_codigo and b.met_codigo = metodologia.met_codigo ");
        buf.append("left join unidademedida on a.fil_codigo = unidademedida.fil_codigo and a.unm_codigo = unidademedida.unm_codigo ");
        buf.append("left join pacientescontatos paccontatos on a.fil_codigo = paccontatos.fil_codigo and a.pac_codigo = paccontatos.pac_codigo and a.pco_codigo = paccontatos.pco_codigo ");
        buf.append("left join entidade ent on a.fil_codigo = ent.fil_codigo and a.ent_codigo = ent.ent_codigo ");
        buf.append(" where a.fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append(" and b.exr_excluido = false and a.req_excluida = false ");
        String s = this.comboSituacao.getSelectedItem().toString();
        if (s.equals(situacao[1])) {
            buf.append(" and (b.exr_situacao = '' or b.exr_situacao = ' ')");
        } else if (!s.equals(situacao[0])) {
            buf.append(" and b.exr_situacao = '");
            if (s.equals(situacao[2])) {
                buf.append("T");
            } else if (s.equals(situacao[3])) {
                buf.append("F");
            } else if (s.equals(situacao[4])) {
                buf.append("R");
            } else if (s.equals(situacao[5])) {
                buf.append("L");
            } else if (s.equals(situacao[6])) {
                buf.append("C");
            } else if (s.equals(situacao[7])) {
                buf.append("O");
            } else if (s.equals(situacao[8])) {
                buf.append("I");
            } else if (s.equals(situacao[9])) {
                buf.append("E");
            } else if (s.equals(situacao[10])) {
                buf.append("A");
            } else {
                buf.append("P");
            }
            buf.append("'");
        }
        String[] usuarios = this.itemUsuario.getSelecionados();
        if (usuarios != null && usuarios.length > 0) {
            buf.append(" and a.usr_codabertura in (");
            for (int i = 0; i < usuarios.length; ++i) {
                buf.append("'");
                buf.append(usuarios[i]);
                buf.append("'");
                if (i >= usuarios.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if ((destinos = this.itemDestino.getSelecionados()) != null && destinos.length > 0) {
            buf.append(" and a.des_codigo in (");
            for (int i = 0; i < destinos.length; ++i) {
                buf.append("'");
                buf.append(destinos[i]);
                buf.append("'");
                if (i >= destinos.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if ((coletas = this.itemColeta.getSelecionados()) != null && coletas.length > 0) {
            buf.append(" and a.col_codigo in (");
            for (int i = 0; i < coletas.length; ++i) {
                buf.append("'");
                buf.append(coletas[i]);
                buf.append("'");
                if (i >= coletas.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if ((convenios = this.itemConvenio.getSelecionados()) != null && convenios.length > 0) {
            buf.append(" and a.con_codigo in (");
            for (int i = 0; i < convenios.length; ++i) {
                buf.append(convenios[i]);
                if (i >= convenios.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if ((pacientes = this.itemPaciente.getSelecionados()) != null && pacientes.length > 0) {
            buf.append(" and a.pac_codigo in (");
            for (int i = 0; i < pacientes.length; ++i) {
                buf.append(pacientes[i]);
                if (i >= pacientes.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        String[] medicosCrm = this.itemMedico.getSelecionadosAvancado(1);
        String[] medicosUF = this.itemMedico.getSelecionadosAvancado(2);
        String[] medicosConselho = this.itemMedico.getSelecionadosAvancado(0);
        if (medicosCrm != null && medicosUF != null && medicosCrm.length <= ParametrosGerais.getQuantidadeMaximoFiltroAvancado()) {
            buf.append(" and (");
            for (int i = 0; i < medicosCrm.length; ++i) {
                buf.append("(a.med_conselho = '");
                buf.append(medicosConselho[i]);
                buf.append("' and a.med_crm = '");
                buf.append(medicosCrm[i]);
                buf.append("' and a.med_uf = '");
                buf.append(medicosUF[i]);
                buf.append("')");
                if (i >= medicosCrm.length - 1) continue;
                buf.append(" or ");
            }
            buf.append(")");
        }
        if ((exames = this.itemExame.getSelecionados()) != null && exames.length > 0) {
            buf.append(" and b.exa_codigo in (");
            for (int i = 0; i < exames.length; ++i) {
                buf.append("'");
                buf.append(exames[i]);
                buf.append("'");
                if (i >= exames.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if ((materiais = this.itemMaterialColetado.getSelecionados()) != null && materiais.length > 0) {
            buf.append(" and b.mco_codigo in (");
            for (int i = 0; i < materiais.length; ++i) {
                buf.append(materiais[i]);
                if (i >= materiais.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if ((setores = this.itemSetor.getSelecionados()) != null && setores.length > 0) {
            buf.append(" and e.set_codigo in (");
            for (int i = 0; i < setores.length; ++i) {
                buf.append("'");
                buf.append(setores[i]);
                buf.append("'");
                if (i >= setores.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if (Funcoes.verificaData(this.txtDataInicio.getText())) {
            buf.append(" and a.req_data >= '");
            buf.append(Funcoes.formataData("MM/dd/yyyy", this.txtDataInicio.getText()));
            buf.append("'");
        }
        if (Funcoes.verificaData(this.txtDataFim.getText())) {
            buf.append(" and a.req_data <= '");
            buf.append(Funcoes.formataData("MM/dd/yyyy", this.txtDataFim.getText()));
            buf.append("'");
        }
        if (Variaveis.tipoFilialPadrao.equals("A")) {
            if (!Funcoes.textoVazio(this.textSif.getText())) {
                buf.append(" and upper(to_ascii(paciente.pac_sif)) ilike upper(to_ascii('%").append(this.textSif.getTextDB()).append("%'))");
            }
            if (!Funcoes.textoVazio(this.textDescricaoProduto.getText())) {
                buf.append(" and upper(to_ascii(a.req_descricaoproduto)) ilike upper(to_ascii('%").append(this.textDescricaoProduto.getTextDB()).append("%'))");
            }
            if (!Funcoes.textoVazio(this.textMarcaProduto.getText())) {
                buf.append(" and upper(to_ascii(a.req_marcaproduto)) ilike upper(to_ascii('%").append(this.textMarcaProduto.getTextDB()).append("%'))");
            }
            if (!Funcoes.textoVazio(this.textLoteProduto.getText())) {
                buf.append(" and upper(to_ascii(a.req_numeroloteproduto)) ilike upper(to_ascii('%").append(this.textLoteProduto.getTextDB()).append("%'))");
            }
            if (!Funcoes.textoVazio(this.textNumeroRegistroProduto.getText())) {
                buf.append(" and upper(to_ascii(a.req_numeroregistroproduto)) ilike upper(to_ascii('%").append(this.textNumeroRegistroProduto.getTextDB()).append("%'))");
            }
            if (!Funcoes.textoVazio(this.textLacreProduto.getText())) {
                buf.append(" and upper(to_ascii(a.req_lacreproduto)) ilike upper(to_ascii('%").append(this.textLacreProduto.getTextDB()).append("%'))");
            }
            if (!Funcoes.textoVazio(this.textDocumentoProduto.getText())) {
                buf.append(" and upper(to_ascii(a.req_doctoreferenciaproduto)) ilike upper(to_ascii('%").append(this.textDocumentoProduto.getTextDB()).append("%'))");
            }
            if (!Funcoes.textoVazio(this.textNumeroSolicitacaoProduto.getText())) {
                buf.append(" and upper(to_ascii(a.req_nrsolicitacaoproduto)) ilike upper(to_ascii('%").append(this.textNumeroSolicitacaoProduto.getTextDB()).append("%'))");
            }
            if (!Funcoes.textoVazio(this.textResponsavelProduto.getText())) {
                buf.append(" and upper(to_ascii(paccontatos.pco_nome)) ilike upper(to_ascii('%").append(this.textResponsavelProduto.getTextDB()).append("%'))");
            }
            if (!Funcoes.textoVazio(this.textAnoPRP.getText()) && Funcoes.isNumeric(this.textAnoPRP.getText())) {
                buf.append(" and a.req_anoprpproduto = ").append(this.textAnoPRP.getTextDB());
            }
            if (!Funcoes.textoVazio(this.textCicloPRP.getText())) {
                buf.append(" and upper(to_ascii(a.req_cicloprpproduto)) = upper(to_ascii('").append(this.textCicloPRP.getTextDB()).append("'))");
            }
            if (!Funcoes.textoVazio(this.textAmostraPRP.getText())) {
                buf.append(" and upper(to_ascii(a.req_amostraprpproduto)) = upper(to_ascii('").append(this.textAmostraPRP.getTextDB()).append("'))");
            }
            if (!Funcoes.textoVazio(this.textLocalColetaProduto.getText())) {
                buf.append(" and upper(to_ascii(a.req_localcoletaproduto)) ilike upper(to_ascii('%").append(this.textLocalColetaProduto.getTextDB()).append("%'))");
            }
            if (Funcoes.verificaData(this.textDataRecebimentoInicio.getText())) {
                buf.append(" and a.req_datarecebimentoproduto >= '");
                buf.append(Funcoes.formataData("MM/dd/yyyy", this.textDataRecebimentoInicio.getText()));
                buf.append("'");
            }
            if (Funcoes.verificaData(this.textDataRecebimentoFim.getText())) {
                buf.append(" and a.req_datarecebimentoproduto <= '");
                buf.append(Funcoes.formataData("MM/dd/yyyy", this.textDataRecebimentoFim.getText()));
                buf.append("'");
            }
        }
        buf.append(" order by a.req_codigo ");
        return buf.toString();
    }
}

