/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.consultas.recepcao;

import java.awt.Color;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.Timer;

class BlinkLabel
extends JLabel {
    private static final long serialVersionUID = 1L;
    private static final int BLINKING_RATE = 1000;
    private boolean blinkingOn = true;
    private boolean avisoSonoro = false;
    private int avisado = 0;
    private Timer timer = new Timer(1000, new TimerListener(this));

    public BlinkLabel(String text) {
        super(text);
        this.timer.setInitialDelay(0);
    }

    public void start() {
        this.timer.start();
    }

    public void stop() {
        this.timer.stop();
    }

    public void setBlinking(boolean flag) {
        this.blinkingOn = flag;
    }

    public boolean getBlinking(boolean flag) {
        return this.blinkingOn;
    }

    public boolean isAvisoSonoro() {
        return this.avisoSonoro;
    }

    public void setAvisoSonoro(boolean avisoSonoro) {
        this.avisoSonoro = avisoSonoro;
    }

    public int getAvisado() {
        return this.avisado;
    }

    public void setAvisado(int avisado) {
        this.avisado = avisado;
    }

    private class TimerListener
    implements ActionListener {
        private BlinkLabel bl;
        private Color bg;
        private Color fg;
        private boolean isForeground = true;

        public TimerListener(BlinkLabel bl) {
            this.bl = bl;
            this.fg = bl.getForeground();
            this.bg = bl.getBackground();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.bl.blinkingOn) {
                if (this.isForeground) {
                    this.bl.setForeground(this.fg);
                    if (BlinkLabel.this.avisoSonoro && BlinkLabel.this.avisado < 1) {
                        for (int i = 0; i < 8; ++i) {
                            Toolkit.getDefaultToolkit().beep();
                            try {
                                Thread.sleep(250L);
                                continue;
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        BlinkLabel.this.avisado++;
                    }
                } else {
                    this.bl.setForeground(this.bg);
                }
                this.isForeground = !this.isForeground;
            } else if (this.isForeground) {
                this.bl.setForeground(this.fg);
                this.isForeground = false;
            }
        }
    }
}

