/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.consultas.graficos;

import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.consultas.graficos.Atualiza;
import jalis.laboratorio.consultas.graficos.Filtro;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.Minute;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class TotalPorRecebido
extends FrmPadrao {
    JPanel panelCentro = new JPanel(new BorderLayout());
    JPanel panelBotoes = new JPanel(new FlowLayout(2));
    JButton buttonFiltro = new JButton("Filtro");
    JButton buttonFechar = new JButton("Fechar");
    JCheckBox checkAtualizar = new JCheckBox("Atualizar");
    JFreeChart chart;
    ChartPanel panelChart;
    XYDataset dataset;
    TimeSeries total = new TimeSeries("Total", Minute.class);
    TimeSeries recebido = new TimeSeries("Recebido", Minute.class);
    Atualiza atualiza;

    public TotalPorRecebido() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "TotalPorRecebido");
        }
    }

    public void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelCentro, "Center");
        this.add((Component)this.panelBotoes, "South");
        this.panelBotoes.add(this.checkAtualizar);
        this.panelBotoes.add(this.buttonFiltro);
        this.panelBotoes.add(this.buttonFechar);
        Funcoes.criaBarraDescricao(this, "Total requisi\u00e7\u00e3o por total recebido", "Total das requisi\u00e7\u00f5es \u00e0 receber por total recebido", "consultas/cons_graficos_tot_req_valor.jpg");
        TimeSeriesCollection time = new TimeSeriesCollection();
        time.addSeries(this.total);
        time.addSeries(this.recebido);
        this.dataset = time;
        this.chart = ChartFactory.createTimeSeriesChart((String)"Total requisi\u00e7\u00e3o por total recebido", (String)"Hor\u00e1rio", (String)"Total", (XYDataset)this.dataset, (boolean)true, (boolean)true, (boolean)false);
        this.atualiza = new Atualiza(this.total, this.recebido, this.chart);
        this.panelChart = new ChartPanel(this.chart);
        this.panelCentro.add((Component)this.panelChart, "Center");
        XYPlot plot = this.chart.getXYPlot();
        XYItemRenderer r = plot.getRenderer();
        if (r instanceof XYLineAndShapeRenderer) {
            XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)r;
            renderer.setDefaultShapesVisible(true);
        }
        DateAxis axis = (DateAxis)plot.getDomainAxis();
        axis.setDateFormatOverride((DateFormat)new SimpleDateFormat("HH:mm"));
        this.buttonFiltro.setMnemonic('i');
        this.buttonFechar.setMnemonic('F');
        this.checkAtualizar.setMnemonic('A');
        this.checkAtualizar.setSelected(true);
        this.atualiza.start();
        this.panelChart.revalidate();
        this.buttonFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TotalPorRecebido.this.atualiza.parar();
                TotalPorRecebido.this.setVisible(false);
            }
        });
        this.buttonFiltro.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Filtro filtro = new Filtro((Frame)TotalPorRecebido.this.getTopLevelAncestor());
                filtro.setVisible(true);
                if (filtro.isOK()) {
                    TotalPorRecebido.this.atualiza.setFilial(filtro.getFilial());
                    TotalPorRecebido.this.atualiza.atualizar();
                    TotalPorRecebido.this.panelChart.revalidate();
                }
            }
        });
        this.checkAtualizar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!TotalPorRecebido.this.checkAtualizar.isSelected()) {
                    TotalPorRecebido.this.atualiza.parar();
                } else {
                    TotalPorRecebido.this.atualiza = new Atualiza(TotalPorRecebido.this.total, TotalPorRecebido.this.recebido, TotalPorRecebido.this.chart);
                    TotalPorRecebido.this.atualiza.start();
                    TotalPorRecebido.this.panelChart.revalidate();
                }
            }
        });
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0700500100");
    }
}

